/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.AbstractGraphics2D;
import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.DOMGroupManager;
import io.sf.carte.echosvg.svggen.DOMTreeManager;
import io.sf.carte.echosvg.svggen.DefaultErrorHandler;
import io.sf.carte.echosvg.svggen.DefaultStyleHandler;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.ExtensionHandler;
import io.sf.carte.echosvg.svggen.GenericImageHandler;
import io.sf.carte.echosvg.svggen.ImageHandler;
import io.sf.carte.echosvg.svggen.SVGCSSStyler;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGIDGenerator;
import io.sf.carte.echosvg.svggen.SVGShape;
import io.sf.carte.echosvg.svggen.SVGSyntax;
import io.sf.carte.echosvg.svggen.XmlWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGGraphics2D
extends AbstractGraphics2D
implements Cloneable,
SVGSyntax,
ErrorConstants {
    public static final String DEFAULT_XML_ENCODING = "ISO-8859-1";
    public static final int DEFAULT_MAX_GC_OVERRIDES = 3;
    private DOMTreeManager domTreeManager;
    private DOMGroupManager domGroupManager;
    private SVGGeneratorContext generatorCtx;
    private SVGShape shapeConverter;
    private Dimension svgCanvasSize;
    private Graphics2D fmg;
    protected Set<AttributedCharacterIterator.Attribute> unsupportedAttributes;

    public final Dimension getSVGCanvasSize() {
        return this.svgCanvasSize;
    }

    public final void setSVGCanvasSize(Dimension dimension) {
        this.svgCanvasSize = new Dimension(dimension);
    }

    public final SVGGeneratorContext getGeneratorContext() {
        return this.generatorCtx;
    }

    public final SVGShape getShapeConverter() {
        return this.shapeConverter;
    }

    public final DOMTreeManager getDOMTreeManager() {
        return this.domTreeManager;
    }

    protected final void setDOMTreeManager(DOMTreeManager dOMTreeManager) {
        this.domTreeManager = dOMTreeManager;
        this.generatorCtx.getGenericImageHandler().setDOMTreeManager(this.domTreeManager);
    }

    protected final DOMGroupManager getDOMGroupManager() {
        return this.domGroupManager;
    }

    protected final void setDOMGroupManager(DOMGroupManager dOMGroupManager) {
        this.domGroupManager = dOMGroupManager;
    }

    public final Document getDOMFactory() {
        return this.generatorCtx.getDOMFactory();
    }

    public final ImageHandler getImageHandler() {
        return this.generatorCtx.getImageHandler();
    }

    public final GenericImageHandler getGenericImageHandler() {
        return this.generatorCtx.getGenericImageHandler();
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.generatorCtx.getExtensionHandler();
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        this.generatorCtx.setExtensionHandler(extensionHandler);
    }

    public SVGGraphics2D(Document document) {
        this(SVGGeneratorContext.createDefault(document), false);
    }

    public SVGGraphics2D(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler, boolean bl) {
        this(SVGGraphics2D.buildSVGGeneratorContext(document, imageHandler, extensionHandler), bl);
    }

    public static SVGGeneratorContext buildSVGGeneratorContext(Document document, ImageHandler imageHandler, ExtensionHandler extensionHandler) {
        SVGGeneratorContext sVGGeneratorContext = new SVGGeneratorContext(document);
        sVGGeneratorContext.setIDGenerator(new SVGIDGenerator());
        sVGGeneratorContext.setExtensionHandler(extensionHandler);
        sVGGeneratorContext.setImageHandler(imageHandler);
        sVGGeneratorContext.setStyleHandler(new DefaultStyleHandler());
        sVGGeneratorContext.setComment("Generated by the EchoSVG Graphics2D SVG Generator");
        sVGGeneratorContext.setErrorHandler(new DefaultErrorHandler());
        return sVGGeneratorContext;
    }

    public SVGGraphics2D(SVGGeneratorContext sVGGeneratorContext, boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.unsupportedAttributes = new HashSet<AttributedCharacterIterator.Attribute>();
        this.unsupportedAttributes.add(TextAttribute.BACKGROUND);
        this.unsupportedAttributes.add(TextAttribute.BIDI_EMBEDDING);
        this.unsupportedAttributes.add(TextAttribute.CHAR_REPLACEMENT);
        this.unsupportedAttributes.add(TextAttribute.JUSTIFICATION);
        this.unsupportedAttributes.add(TextAttribute.RUN_DIRECTION);
        this.unsupportedAttributes.add(TextAttribute.SUPERSCRIPT);
        this.unsupportedAttributes.add(TextAttribute.SWAP_COLORS);
        this.unsupportedAttributes.add(TextAttribute.TRANSFORM);
        this.unsupportedAttributes.add(TextAttribute.WIDTH);
        if (sVGGeneratorContext == null) {
            throw new SVGGraphics2DRuntimeException("generatorContext should not be null");
        }
        this.setGeneratorContext(sVGGeneratorContext);
    }

    protected void setGeneratorContext(SVGGeneratorContext sVGGeneratorContext) {
        this.generatorCtx = sVGGeneratorContext;
        this.gc = new GraphicContext(new AffineTransform());
        SVGGeneratorContext.GraphicContextDefaults graphicContextDefaults = sVGGeneratorContext.getGraphicContextDefaults();
        if (graphicContextDefaults != null) {
            if (graphicContextDefaults.getPaint() != null) {
                this.gc.setPaint(graphicContextDefaults.getPaint());
            }
            if (graphicContextDefaults.getStroke() != null) {
                this.gc.setStroke(graphicContextDefaults.getStroke());
            }
            if (graphicContextDefaults.getComposite() != null) {
                this.gc.setComposite(graphicContextDefaults.getComposite());
            }
            if (graphicContextDefaults.getClip() != null) {
                this.gc.setClip(graphicContextDefaults.getClip());
            }
            if (graphicContextDefaults.getRenderingHints() != null) {
                this.gc.setRenderingHints((Map)graphicContextDefaults.getRenderingHints());
            }
            if (graphicContextDefaults.getFont() != null) {
                this.gc.setFont(graphicContextDefaults.getFont());
            }
            if (graphicContextDefaults.getBackground() != null) {
                this.gc.setBackground(graphicContextDefaults.getBackground());
            }
        }
        this.shapeConverter = new SVGShape(sVGGeneratorContext);
        this.domTreeManager = new DOMTreeManager(this.gc, sVGGeneratorContext, 3);
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
        sVGGeneratorContext.getGenericImageHandler().setDOMTreeManager(this.domTreeManager);
    }

    public SVGGraphics2D(SVGGraphics2D sVGGraphics2D) {
        super((AbstractGraphics2D)sVGGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.unsupportedAttributes = new HashSet<AttributedCharacterIterator.Attribute>();
        this.unsupportedAttributes.add(TextAttribute.BACKGROUND);
        this.unsupportedAttributes.add(TextAttribute.BIDI_EMBEDDING);
        this.unsupportedAttributes.add(TextAttribute.CHAR_REPLACEMENT);
        this.unsupportedAttributes.add(TextAttribute.JUSTIFICATION);
        this.unsupportedAttributes.add(TextAttribute.RUN_DIRECTION);
        this.unsupportedAttributes.add(TextAttribute.SUPERSCRIPT);
        this.unsupportedAttributes.add(TextAttribute.SWAP_COLORS);
        this.unsupportedAttributes.add(TextAttribute.TRANSFORM);
        this.unsupportedAttributes.add(TextAttribute.WIDTH);
        this.generatorCtx = sVGGraphics2D.generatorCtx;
        this.gc.validateTransformStack();
        this.shapeConverter = sVGGraphics2D.shapeConverter;
        this.domTreeManager = sVGGraphics2D.domTreeManager;
        this.domGroupManager = new DOMGroupManager(this.gc, this.domTreeManager);
        this.domTreeManager.addGroupManager(this.domGroupManager);
    }

    public void stream(String string) throws SVGGraphics2DIOException {
        this.stream(string, false);
    }

    public void stream(String string, boolean bl) throws SVGGraphics2DIOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), DEFAULT_XML_ENCODING);
            this.stream(outputStreamWriter, bl);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            throw sVGGraphics2DIOException;
        }
        catch (IOException iOException) {
            this.generatorCtx.getErrorHandler().handleError(new SVGGraphics2DIOException(iOException));
        }
    }

    public void stream(Writer writer) throws SVGGraphics2DIOException {
        this.stream(writer, false);
    }

    public void stream(Writer writer, boolean bl, boolean bl2) throws SVGGraphics2DIOException {
        Element element = this.getRoot();
        this.stream(element, writer, bl, bl2);
    }

    public void stream(Writer writer, boolean bl) throws SVGGraphics2DIOException {
        Element element = this.getRoot();
        this.stream(element, writer, bl, false);
    }

    public void stream(Element element, Writer writer) throws SVGGraphics2DIOException {
        this.stream(element, writer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(Element element, Writer writer, boolean bl, boolean bl2) throws SVGGraphics2DIOException {
        Node node = element.getParentNode();
        Node node2 = element.getNextSibling();
        try {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
            DocumentFragment documentFragment = element.getOwnerDocument().createDocumentFragment();
            documentFragment.appendChild(element);
            if (bl) {
                SVGCSSStyler.style(documentFragment);
            }
            XmlWriter.writeXml(documentFragment, writer, bl2);
            writer.flush();
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            this.generatorCtx.getErrorHandler().handleError(sVGGraphics2DIOException);
        }
        catch (IOException iOException) {
            this.generatorCtx.getErrorHandler().handleError(new SVGGraphics2DIOException(iOException));
        }
        finally {
            if (node != null) {
                if (node2 == null) {
                    node.appendChild(element);
                } else {
                    node.insertBefore(element, node2);
                }
            }
        }
    }

    public List<Element> getDefinitionSet() {
        return this.domTreeManager.getDefinitionSet();
    }

    public Element getTopLevelGroup() {
        return this.getTopLevelGroup(true);
    }

    public Element getTopLevelGroup(boolean bl) {
        return this.domTreeManager.getTopLevelGroup(bl);
    }

    public void setTopLevelGroup(Element element) {
        this.domTreeManager.setTopLevelGroup(element);
    }

    public Element getRoot() {
        return this.getRoot(null);
    }

    public Element getRoot(Element element) {
        element = this.domTreeManager.getRoot(element);
        if (this.svgCanvasSize != null) {
            element.setAttributeNS(null, "width", String.valueOf(this.svgCanvasSize.width));
            element.setAttributeNS(null, "height", String.valueOf(this.svgCanvasSize.height));
        }
        return element;
    }

    public Graphics create() {
        return new SVGGraphics2D(this);
    }

    public void setXORMode(Color color) {
        this.generatorCtx.getErrorHandler().handleError(new SVGGraphics2DRuntimeException("XOR Mode is not supported by Graphics2D SVG Generator"));
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform = this.getGenericImageHandler().handleImage(image, element, n, n2, image.getWidth(null), image.getHeight(null), this.getGeneratorContext());
        if (affineTransform == null) {
            this.domGroupManager.addElement(element);
        } else {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        }
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform = this.getGenericImageHandler().handleImage(image, element, n, n2, n3, n4, this.getGeneratorContext());
        if (affineTransform == null) {
            this.domGroupManager.addElement(element);
        } else {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform2);
        }
        return true;
    }

    public void dispose() {
        this.domTreeManager.removeGroupManager(this.domGroupManager);
    }

    public void draw(Shape shape) {
        Stroke stroke = this.gc.getStroke();
        if (stroke instanceof BasicStroke) {
            Element element = this.shapeConverter.toSVG(shape);
            if (element != null) {
                this.domGroupManager.addElement(element, (short)1);
            }
        } else {
            Shape shape2 = stroke.createStrokedShape(shape);
            this.fill(shape2);
        }
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl = true;
        if (affineTransform == null) {
            bl = this.drawImage(image, 0, 0, null);
        } else if (affineTransform.getDeterminant() != 0.0) {
            AffineTransform affineTransform2 = null;
            try {
                affineTransform2 = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.transform(affineTransform2);
        } else {
            AffineTransform affineTransform3 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform);
            bl = this.drawImage(image, 0, 0, null);
            this.gc.setTransform(affineTransform3);
        }
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage, n, n2, null);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform3 = this.getGenericImageHandler().handleImage(renderedImage, element, renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), this.getGeneratorContext());
        if (affineTransform == null) {
            affineTransform2 = affineTransform3;
        } else if (affineTransform3 == null) {
            affineTransform2 = affineTransform;
        } else {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(affineTransform3);
        }
        if (affineTransform2 == null) {
            this.domGroupManager.addElement(element);
        } else if (affineTransform2.getDeterminant() != 0.0) {
            AffineTransform affineTransform4 = null;
            try {
                affineTransform4 = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform4);
        } else {
            AffineTransform affineTransform5 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform5);
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        Element element = this.getGenericImageHandler().createElement(this.getGeneratorContext());
        AffineTransform affineTransform3 = this.getGenericImageHandler().handleImage(renderableImage, element, renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight(), this.getGeneratorContext());
        if (affineTransform == null) {
            affineTransform2 = affineTransform3;
        } else if (affineTransform3 == null) {
            affineTransform2 = affineTransform;
        } else {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(affineTransform3);
        }
        if (affineTransform2 == null) {
            this.domGroupManager.addElement(element);
        } else if (affineTransform2.getDeterminant() != 0.0) {
            AffineTransform affineTransform4 = null;
            try {
                affineTransform4 = affineTransform2.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGGraphics2DRuntimeException("unexpected exception");
            }
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.transform(affineTransform4);
        } else {
            AffineTransform affineTransform5 = new AffineTransform(this.gc.getTransform());
            this.gc.transform(affineTransform2);
            this.domGroupManager.addElement(element);
            this.gc.setTransform(affineTransform5);
        }
    }

    public void drawString(String string, float f, float f2) {
        if (this.textAsShapes) {
            GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), string);
            this.drawGlyphVector(glyphVector, f, f2);
            return;
        }
        if (this.generatorCtx.isEmbeddedFontsOn()) {
            this.domTreeManager.getGraphicContextConverter().getFontConverter().recordFontUsage(string, this.getFont());
        }
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = this.transformText(f, f2);
        Element element = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        element.setAttributeNS(null, "x", this.generatorCtx.doubleString(f));
        element.setAttributeNS(null, "y", this.generatorCtx.doubleString(f2));
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        element.appendChild(this.getDOMFactory().createTextNode(string));
        SVGGraphicContext sVGGraphicContext = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
        this.setTextElementAttributes(sVGGraphicContext, element);
        this.domGroupManager.addElement(element, (short)16, sVGGraphicContext);
        if (affineTransform2 != null) {
            this.setTransform(affineTransform);
        }
    }

    private AffineTransform transformText(float f, float f2) {
        AffineTransform affineTransform = null;
        Font font = this.getFont();
        if (font != null) {
            affineTransform = font.getTransform();
            if (affineTransform != null && !affineTransform.isIdentity()) {
                AffineTransform affineTransform2 = new AffineTransform();
                affineTransform2.translate(f, f2);
                affineTransform2.concatenate(affineTransform);
                affineTransform2.translate(-f, -f2);
                this.transform(affineTransform2);
            } else {
                affineTransform = null;
            }
        }
        return affineTransform;
    }

    private void setTextElementAttributes(SVGGraphicContext sVGGraphicContext, Element element) {
        int n;
        Map<TextAttribute, ?> map = this.getFont().getAttributes();
        String string = "";
        if (TextAttribute.UNDERLINE_ON.equals(map.get(TextAttribute.UNDERLINE))) {
            string = string + "underline ";
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(map.get(TextAttribute.STRIKETHROUGH))) {
            string = string + "line-through ";
        }
        if ((n = string.length()) != 0) {
            sVGGraphicContext.getGraphicElementContext().put("text-decoration", string.substring(0, n - 1));
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        if (this.textAsShapes || this.usesUnsupportedAttributes(attributedCharacterIterator)) {
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
            textLayout.draw((Graphics2D)((Object)this), f, f2);
            return;
        }
        boolean bl = false;
        if (attributedCharacterIterator.getRunLimit() < attributedCharacterIterator.getEndIndex()) {
            bl = true;
        }
        Element element = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "text");
        element.setAttributeNS(null, "x", this.generatorCtx.doubleString(f));
        element.setAttributeNS(null, "y", this.generatorCtx.doubleString(f2));
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        Font font = this.getFont();
        Paint paint = this.getPaint();
        char c = attributedCharacterIterator.first();
        this.setTextElementFill(attributedCharacterIterator);
        this.setTextFontAttributes(attributedCharacterIterator, font);
        SVGGraphicContext sVGGraphicContext = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
        this.domGroupManager.addElement(element, (short)16);
        sVGGraphicContext.getContext().put("stroke", "none");
        sVGGraphicContext.getGroupContext().put("stroke", "none");
        boolean bl2 = true;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = null;
        while (c != '\uffff') {
            Element element2 = element;
            if (bl) {
                element2 = this.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "tspan");
                element.appendChild(element2);
            }
            this.setTextElementFill(attributedCharacterIterator);
            boolean bl3 = this.setTextFontAttributes(attributedCharacterIterator, font);
            if (bl3 || bl2) {
                affineTransform2 = this.transformText(f, f2);
                bl2 = false;
            }
            int n = attributedCharacterIterator.getIndex();
            int n2 = attributedCharacterIterator.getRunLimit() - 1;
            StringBuilder stringBuilder = new StringBuilder(n2 - n);
            stringBuilder.append(c);
            for (int i = n; i < n2; ++i) {
                c = attributedCharacterIterator.next();
                stringBuilder.append(c);
            }
            String string = stringBuilder.toString();
            if (this.generatorCtx.isEmbeddedFontsOn()) {
                this.getDOMTreeManager().getGraphicContextConverter().getFontConverter().recordFontUsage(string, this.getFont());
            }
            SVGGraphicContext sVGGraphicContext2 = this.domTreeManager.getGraphicContextConverter().toSVG(this.gc);
            sVGGraphicContext2.getGroupContext().put("stroke", "none");
            SVGGraphicContext sVGGraphicContext3 = DOMGroupManager.processDeltaGC(sVGGraphicContext2, sVGGraphicContext);
            this.setTextElementAttributes(sVGGraphicContext3, attributedCharacterIterator);
            this.domTreeManager.getStyleHandler().setStyle(element2, sVGGraphicContext3.getContext(), this.domTreeManager.getGeneratorContext());
            element2.appendChild(this.getDOMFactory().createTextNode(string));
            if ((bl3 || bl2) && affineTransform2 != null) {
                this.setTransform(affineTransform);
            }
            c = attributedCharacterIterator.next();
        }
        this.setFont(font);
        this.setPaint(paint);
    }

    public void fill(Shape shape) {
        Element element = this.shapeConverter.toSVG(shape);
        if (element != null) {
            this.domGroupManager.addElement(element, (short)16);
        }
    }

    private boolean setTextFontAttributes(AttributedCharacterIterator attributedCharacterIterator, Font font) {
        boolean bl = false;
        if (attributedCharacterIterator.getAttribute(TextAttribute.FONT) != null || attributedCharacterIterator.getAttribute(TextAttribute.FAMILY) != null || attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT) != null || attributedCharacterIterator.getAttribute(TextAttribute.POSTURE) != null || attributedCharacterIterator.getAttribute(TextAttribute.SIZE) != null) {
            Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
            Font font2 = font.deriveFont(map);
            this.setFont(font2);
            bl = true;
        }
        return bl;
    }

    private void setTextElementFill(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND) != null) {
            Color color = (Color)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND);
            this.setPaint(color);
        }
    }

    private void setTextElementAttributes(SVGGraphicContext sVGGraphicContext, AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        String string = "";
        if (this.isUnderline(attributedCharacterIterator)) {
            string = string + "underline ";
        }
        if (this.isStrikeThrough(attributedCharacterIterator)) {
            string = string + "line-through ";
        }
        if ((n = string.length()) != 0) {
            sVGGraphicContext.getContext().put("text-decoration", string.substring(0, n - 1));
        }
    }

    private boolean isBold(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT);
        if (object == null) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_REGULAR)) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_DEMILIGHT)) {
            return false;
        }
        if (object.equals(TextAttribute.WEIGHT_EXTRA_LIGHT)) {
            return false;
        }
        return !object.equals(TextAttribute.WEIGHT_LIGHT);
    }

    private boolean isItalic(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.POSTURE);
        return TextAttribute.POSTURE_OBLIQUE.equals(object);
    }

    private boolean isUnderline(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(object);
    }

    private boolean isStrikeThrough(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(object);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setUnsupportedAttributes(Set<AttributedCharacterIterator.Attribute> set) {
        this.unsupportedAttributes = set == null ? null : new HashSet<AttributedCharacterIterator.Attribute>(set);
    }

    public boolean usesUnsupportedAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        if (this.unsupportedAttributes == null) {
            return false;
        }
        Set<AttributedCharacterIterator.Attribute> set = attributedCharacterIterator.getAllAttributeKeys();
        for (AttributedCharacterIterator.Attribute attribute : set) {
            if (!this.unsupportedAttributes.contains(attribute)) continue;
            return true;
        }
        return false;
    }
}

