/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.DefaultErrorHandler;
import io.sf.carte.echosvg.svggen.DefaultExtensionHandler;
import io.sf.carte.echosvg.svggen.DefaultStyleHandler;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.ErrorHandler;
import io.sf.carte.echosvg.svggen.ExtensionHandler;
import io.sf.carte.echosvg.svggen.GenericImageHandler;
import io.sf.carte.echosvg.svggen.ImageHandler;
import io.sf.carte.echosvg.svggen.ImageHandlerBase64Encoder;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import io.sf.carte.echosvg.svggen.SVGIDGenerator;
import io.sf.carte.echosvg.svggen.SimpleImageHandler;
import io.sf.carte.echosvg.svggen.StyleHandler;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.w3c.dom.Document;

public class SVGGeneratorContext
implements ErrorConstants {
    private Document domFactory;
    private ImageHandler imageHandler;
    private GenericImageHandler genericImageHandler;
    private ExtensionHandler extensionHandler;
    private SVGIDGenerator idGenerator;
    private StyleHandler styleHandler;
    private String generatorComment;
    private ErrorHandler errorHandler;
    private boolean svgFont = false;
    private GraphicContextDefaults gcDefaults;
    private int precision = 4;
    private DecimalFormat decimalFormat = decimalFormats[this.precision];
    protected static DecimalFormatSymbols dsf = new DecimalFormatSymbols(Locale.US);
    protected static DecimalFormat[] decimalFormats = new DecimalFormat[13];

    protected SVGGeneratorContext(Document document) {
        this.setDOMFactory(document);
    }

    public static SVGGeneratorContext createDefault(Document document) {
        SVGGeneratorContext sVGGeneratorContext = new SVGGeneratorContext(document);
        sVGGeneratorContext.setIDGenerator(new SVGIDGenerator());
        sVGGeneratorContext.setExtensionHandler(new DefaultExtensionHandler());
        sVGGeneratorContext.setImageHandler(new ImageHandlerBase64Encoder());
        sVGGeneratorContext.setStyleHandler(new DefaultStyleHandler());
        sVGGeneratorContext.setComment("Generated by the EchoSVG Graphics2D SVG Generator");
        sVGGeneratorContext.setErrorHandler(new DefaultErrorHandler());
        return sVGGeneratorContext;
    }

    public final GraphicContextDefaults getGraphicContextDefaults() {
        return this.gcDefaults;
    }

    public final void setGraphicContextDefaults(GraphicContextDefaults graphicContextDefaults) {
        this.gcDefaults = graphicContextDefaults;
    }

    public final SVGIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    public final void setIDGenerator(SVGIDGenerator sVGIDGenerator) {
        if (sVGIDGenerator == null) {
            throw new SVGGraphics2DRuntimeException("idGenerator should not be null");
        }
        this.idGenerator = sVGIDGenerator;
    }

    public final Document getDOMFactory() {
        return this.domFactory;
    }

    public final void setDOMFactory(Document document) {
        if (document == null) {
            throw new SVGGraphics2DRuntimeException("domFactory should not be null");
        }
        this.domFactory = document;
    }

    public final ExtensionHandler getExtensionHandler() {
        return this.extensionHandler;
    }

    public final void setExtensionHandler(ExtensionHandler extensionHandler) {
        if (extensionHandler == null) {
            throw new SVGGraphics2DRuntimeException("extensionHandler should not be null");
        }
        this.extensionHandler = extensionHandler;
    }

    public final ImageHandler getImageHandler() {
        return this.imageHandler;
    }

    public final void setImageHandler(ImageHandler imageHandler) {
        if (imageHandler == null) {
            throw new SVGGraphics2DRuntimeException("imageHandler should not be null");
        }
        this.imageHandler = imageHandler;
        this.genericImageHandler = new SimpleImageHandler(imageHandler);
    }

    public final void setGenericImageHandler(GenericImageHandler genericImageHandler) {
        if (genericImageHandler == null) {
            throw new SVGGraphics2DRuntimeException("imageHandler should not be null");
        }
        this.imageHandler = null;
        this.genericImageHandler = genericImageHandler;
    }

    GenericImageHandler getGenericImageHandler() {
        return this.genericImageHandler;
    }

    public final StyleHandler getStyleHandler() {
        return this.styleHandler;
    }

    public final void setStyleHandler(StyleHandler styleHandler) {
        if (styleHandler == null) {
            throw new SVGGraphics2DRuntimeException("styleHandler should not be null");
        }
        this.styleHandler = styleHandler;
    }

    public final String getComment() {
        return this.generatorComment;
    }

    public final void setComment(String string) {
        this.generatorComment = string;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new SVGGraphics2DRuntimeException("errorHandler should not be null");
        }
        this.errorHandler = errorHandler;
    }

    public final boolean isEmbeddedFontsOn() {
        return this.svgFont;
    }

    public final void setEmbeddedFontsOn(boolean bl) {
        this.svgFont = bl;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final void setPrecision(int n) {
        this.precision = n < 0 ? 0 : (n > 12 ? 12 : n);
        this.decimalFormat = decimalFormats[this.precision];
    }

    public final String doubleString(double d) {
        double d2 = Math.abs(d);
        if (d2 >= 1.0E8 || (double)((int)d) == d) {
            return Integer.toString((int)d);
        }
        return this.decimalFormat.format(d);
    }

    static {
        SVGGeneratorContext.decimalFormats[0] = new DecimalFormat("#", dsf);
        String string = "#.";
        for (int i = 1; i < decimalFormats.length; ++i) {
            string = string + "#";
            SVGGeneratorContext.decimalFormats[i] = new DecimalFormat(string, dsf);
        }
    }

    public static class GraphicContextDefaults {
        private Paint paint;
        private Stroke stroke;
        private Composite composite;
        private Shape clip;
        private RenderingHints hints;
        private Font font;
        private Color background;

        public void setStroke(Stroke stroke) {
            this.stroke = stroke;
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setComposite(Composite composite) {
            this.composite = composite;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public void setClip(Shape shape) {
            this.clip = shape;
        }

        public Shape getClip() {
            return this.clip;
        }

        public void setRenderingHints(RenderingHints renderingHints) {
            this.hints = renderingHints;
        }

        public RenderingHints getRenderingHints() {
            return this.hints;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public Paint getPaint() {
            return this.paint;
        }
    }
}

