/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGFontDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGPath;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGFont
extends AbstractSVGConverter {
    public static final float EXTRA_LIGHT = TextAttribute.WEIGHT_EXTRA_LIGHT.floatValue();
    public static final float LIGHT = TextAttribute.WEIGHT_LIGHT.floatValue();
    public static final float DEMILIGHT = TextAttribute.WEIGHT_DEMILIGHT.floatValue();
    public static final float REGULAR = TextAttribute.WEIGHT_REGULAR.floatValue();
    public static final float SEMIBOLD = TextAttribute.WEIGHT_SEMIBOLD.floatValue();
    public static final float MEDIUM = TextAttribute.WEIGHT_MEDIUM.floatValue();
    public static final float DEMIBOLD = TextAttribute.WEIGHT_DEMIBOLD.floatValue();
    public static final float BOLD = TextAttribute.WEIGHT_BOLD.floatValue();
    public static final float HEAVY = TextAttribute.WEIGHT_HEAVY.floatValue();
    public static final float EXTRABOLD = TextAttribute.WEIGHT_EXTRABOLD.floatValue();
    public static final float ULTRABOLD = TextAttribute.WEIGHT_ULTRABOLD.floatValue();
    public static final float POSTURE_REGULAR = TextAttribute.POSTURE_REGULAR.floatValue();
    public static final float POSTURE_OBLIQUE = TextAttribute.POSTURE_OBLIQUE.floatValue();
    static final float[] fontStyles = new float[]{POSTURE_REGULAR + (POSTURE_OBLIQUE - POSTURE_REGULAR) / 2.0f};
    static final String[] svgStyles = new String[]{"normal", "italic"};
    static final float[] fontWeights = new float[]{EXTRA_LIGHT + (LIGHT - EXTRA_LIGHT) / 2.0f, LIGHT + (DEMILIGHT - LIGHT) / 2.0f, DEMILIGHT + (REGULAR - DEMILIGHT) / 2.0f, REGULAR + (SEMIBOLD - REGULAR) / 2.0f, SEMIBOLD + (MEDIUM - SEMIBOLD) / 2.0f, MEDIUM + (DEMIBOLD - MEDIUM) / 2.0f, DEMIBOLD + (BOLD - DEMIBOLD) / 2.0f, BOLD + (HEAVY - BOLD) / 2.0f, HEAVY + (EXTRABOLD - HEAVY) / 2.0f, EXTRABOLD + (ULTRABOLD - EXTRABOLD)};
    static final String[] svgWeights = new String[]{"100", "200", "300", "normal", "500", "500", "600", "bold", "800", "800", "900"};
    private static Map<String, String> logicalFontMap = new HashMap<String, String>();
    private static final int COMMON_FONT_SIZE = 100;
    private final Map<String, CharListHelper> fontStringMap = new HashMap<String, CharListHelper>();

    public SVGFont(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public void recordFontUsage(String string, Font font) {
        Font font2 = SVGFont.createCommonSizeFont(font);
        String string2 = this.getFontKey(font2);
        CharListHelper charListHelper = this.fontStringMap.get(string2);
        if (charListHelper == null) {
            charListHelper = new CharListHelper();
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            charListHelper.add(c);
        }
        this.fontStringMap.put(string2, charListHelper);
    }

    private String getFontKey(Font font) {
        return font.getFamily() + font.getStyle();
    }

    private static Font createCommonSizeFont(Font font) {
        HashMap<TextAttribute, Float> hashMap = new HashMap<TextAttribute, Float>();
        hashMap.put(TextAttribute.SIZE, Float.valueOf(100.0f));
        hashMap.put(TextAttribute.TRANSFORM, null);
        return font.deriveFont(hashMap);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG(graphicContext.getFont(), graphicContext.getFontRenderContext());
    }

    public SVGFontDescriptor toSVG(Font font, FontRenderContext fontRenderContext) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Element element;
        FontRenderContext fontRenderContext2 = new FontRenderContext(new AffineTransform(), fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics());
        String string = this.doubleString(font.getSize2D()) + "px";
        String string2 = SVGFont.weightToSVG(font);
        String string3 = SVGFont.styleToSVG(font);
        String string4 = SVGFont.familyToSVG(font);
        Font font2 = SVGFont.createCommonSizeFont(font);
        String string5 = this.getFontKey(font2);
        CharListHelper charListHelper = this.fontStringMap.get(string5);
        if (charListHelper == null) {
            return new SVGFontDescriptor(string, string2, string3, string4, null);
        }
        Document document = this.getGeneratorContext().getDOMFactory();
        SVGFontDescriptor sVGFontDescriptor = (SVGFontDescriptor)this.descMap.get(string5);
        if (sVGFontDescriptor != null) {
            element = sVGFontDescriptor.getDef();
        } else {
            element = document.createElementNS("http://www.w3.org/2000/svg", "font");
            object6 = document.createElementNS("http://www.w3.org/2000/svg", "font-face");
            String string6 = string4;
            if (string4.startsWith("'") && string4.endsWith("'")) {
                string6 = string4.substring(1, string4.length() - 1);
            }
            object6.setAttributeNS(null, "font-family", string6);
            object6.setAttributeNS(null, "font-weight", string2);
            object6.setAttributeNS(null, "font-style", string3);
            object6.setAttributeNS(null, "units-per-em", "100");
            element.appendChild((Node)object6);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "missing-glyph");
            object5 = new int[1];
            object5[0] = font2.getMissingGlyphCode();
            GlyphVector glyphVector = font2.createGlyphVector(fontRenderContext2, (int[])object5);
            object4 = glyphVector.getGlyphOutline(0);
            object3 = glyphVector.getGlyphMetrics(0);
            object2 = AffineTransform.getScaleInstance(1.0, -1.0);
            object4 = ((AffineTransform)object2).createTransformedShape((Shape)object4);
            element2.setAttributeNS(null, "d", SVGPath.toSVGPathData((Shape)object4, this.getGeneratorContext()));
            element2.setAttributeNS(null, "horiz-adv-x", SVGGeneratorContext.decimalFormats[3].format(((GlyphMetrics)object3).getAdvance()));
            element.appendChild(element2);
            element.setAttributeNS(null, "horiz-adv-x", SVGGeneratorContext.decimalFormats[3].format(((GlyphMetrics)object3).getAdvance()));
            object = font2.getLineMetrics("By", fontRenderContext2);
            object6.setAttributeNS(null, "ascent", SVGGeneratorContext.decimalFormats[3].format(((LineMetrics)object).getAscent()));
            object6.setAttributeNS(null, "descent", SVGGeneratorContext.decimalFormats[3].format(((LineMetrics)object).getDescent()));
            int n = font2.getSize();
            float f = -((LineMetrics)object).getStrikethroughOffset() * 100.0f / (float)n;
            float f2 = ((LineMetrics)object).getStrikethroughThickness() * 100.0f / (float)n;
            float f3 = ((LineMetrics)object).getUnderlineOffset() * 100.0f / (float)n;
            float f4 = ((LineMetrics)object).getUnderlineThickness() * 100.0f / (float)n;
            object6.setAttributeNS(null, "strikethrough-position", SVGGeneratorContext.decimalFormats[2].format(f));
            object6.setAttributeNS(null, "strikethrough-thickness", SVGGeneratorContext.decimalFormats[2].format(f2));
            object6.setAttributeNS(null, "underline-position", SVGGeneratorContext.decimalFormats[2].format(f3));
            object6.setAttributeNS(null, "underline-thickness", SVGGeneratorContext.decimalFormats[2].format(f4));
            element.setAttributeNS(null, "id", this.getGeneratorContext().getIDGenerator().generateID("font"));
        }
        object6 = charListHelper.getNewChars();
        charListHelper.clearNewChars();
        for (int i = ((String)object6).length() - 1; i >= 0; --i) {
            char c = ((String)object6).charAt(i);
            object5 = String.valueOf(c);
            boolean bl = false;
            object4 = element.getChildNodes();
            for (int j = 0; j < object4.getLength(); ++j) {
                if (!(object4.item(j) instanceof Element) || !(object2 = (Element)object4.item(j)).getAttributeNS(null, "unicode").equals(object5)) continue;
                bl = true;
                break;
            }
            if (bl) break;
            object3 = document.createElementNS("http://www.w3.org/2000/svg", "glyph");
            object2 = font2.createGlyphVector(fontRenderContext2, "" + c);
            object = ((GlyphVector)object2).getGlyphOutline(0);
            GlyphMetrics glyphMetrics = ((GlyphVector)object2).getGlyphMetrics(0);
            AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
            object = affineTransform.createTransformedShape((Shape)object);
            object3.setAttributeNS(null, "d", SVGPath.toSVGPathData((Shape)object, this.getGeneratorContext()));
            object3.setAttributeNS(null, "horiz-adv-x", String.valueOf(glyphMetrics.getAdvance()));
            object3.setAttributeNS(null, "unicode", String.valueOf(c));
            element.appendChild((Node)object3);
        }
        SVGFontDescriptor sVGFontDescriptor2 = new SVGFontDescriptor(string, string2, string3, string4, element);
        if (sVGFontDescriptor == null) {
            this.descMap.put(string5, sVGFontDescriptor2);
            this.defSet.add(element);
        }
        return sVGFontDescriptor2;
    }

    public static String familyToSVG(Font font) {
        String string = font.getFamily();
        String string2 = logicalFontMap.get(font.getName().toLowerCase());
        if (string2 != null) {
            string = string2;
        } else {
            int n = 39;
            string = '\'' + string + '\'';
        }
        return string;
    }

    public static String styleToSVG(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f = (Float)map.get(TextAttribute.POSTURE);
        if (f == null) {
            f = font.isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR;
        }
        float f2 = f.floatValue();
        int n = 0;
        for (n = 0; n < fontStyles.length && !(f2 <= fontStyles[n]); ++n) {
        }
        return svgStyles[n];
    }

    public static String weightToSVG(Font font) {
        Map<TextAttribute, ?> map = font.getAttributes();
        Float f = (Float)map.get(TextAttribute.WEIGHT);
        if (f == null) {
            f = font.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
        }
        float f2 = f.floatValue();
        int n = 0;
        for (n = 0; n < fontWeights.length && !(f2 <= fontWeights[n]); ++n) {
        }
        return svgWeights[n];
    }

    static {
        logicalFontMap.put("dialog", "sans-serif");
        logicalFontMap.put("dialoginput", "monospace");
        logicalFontMap.put("monospaced", "monospace");
        logicalFontMap.put("serif", "serif");
        logicalFontMap.put("sansserif", "sans-serif");
        logicalFontMap.put("symbol", "'WingDings'");
    }

    private static class CharListHelper {
        private int nUsed = 0;
        private int[] charList = new int[40];
        private StringBuffer freshChars = new StringBuffer(40);

        CharListHelper() {
        }

        String getNewChars() {
            return this.freshChars.toString();
        }

        void clearNewChars() {
            this.freshChars = new StringBuffer(40);
        }

        boolean add(int n) {
            int n2 = CharListHelper.binSearch(this.charList, this.nUsed, n);
            if (n2 >= 0) {
                return false;
            }
            if (this.nUsed == this.charList.length) {
                int[] nArray = new int[this.nUsed + 20];
                System.arraycopy(this.charList, 0, nArray, 0, this.nUsed);
                this.charList = nArray;
            }
            n2 = -n2 - 1;
            System.arraycopy(this.charList, n2, this.charList, n2 + 1, this.nUsed - n2);
            this.charList[n2] = n;
            this.freshChars.append((char)n);
            ++this.nUsed;
            return true;
        }

        static int binSearch(int[] nArray, int n, int n2) {
            int n3 = 0;
            int n4 = n - 1;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                int n6 = nArray[n5];
                if (n6 < n2) {
                    n3 = n5 + 1;
                    continue;
                }
                if (n6 > n2) {
                    n4 = n5 - 1;
                    continue;
                }
                return n5;
            }
            return -(n3 + 1);
        }
    }
}

