/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGStrokeDescriptor;
import java.awt.BasicStroke;

public class SVGBasicStroke
extends AbstractSVGConverter {
    public SVGBasicStroke(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        if (graphicContext.getStroke() instanceof BasicStroke) {
            return this.toSVG((BasicStroke)graphicContext.getStroke());
        }
        return null;
    }

    public final SVGStrokeDescriptor toSVG(BasicStroke basicStroke) {
        String string = this.doubleString(basicStroke.getLineWidth());
        String string2 = SVGBasicStroke.endCapToSVG(basicStroke.getEndCap());
        String string3 = SVGBasicStroke.joinToSVG(basicStroke.getLineJoin());
        String string4 = this.doubleString(basicStroke.getMiterLimit());
        float[] fArray = basicStroke.getDashArray();
        String string5 = null;
        string5 = fArray != null ? this.dashArrayToSVG(fArray) : "none";
        String string6 = this.doubleString(basicStroke.getDashPhase());
        return new SVGStrokeDescriptor(string, string2, string3, string4, string5, string6);
    }

    private final String dashArrayToSVG(float[] fArray) {
        StringBuilder stringBuilder = new StringBuilder(fArray.length * 8);
        if (fArray.length > 0) {
            stringBuilder.append(this.doubleString(fArray[0]));
        }
        for (int i = 1; i < fArray.length; ++i) {
            stringBuilder.append(",");
            stringBuilder.append(this.doubleString(fArray[i]));
        }
        return stringBuilder.toString();
    }

    private static String joinToSVG(int n) {
        switch (n) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
        }
        return "miter";
    }

    private static String endCapToSVG(int n) {
        switch (n) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
        }
        return "square";
    }
}

