/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.constants.XMLConstants;
import io.sf.carte.echosvg.svggen.ErrorConstants;
import io.sf.carte.echosvg.svggen.ImageHandler;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import io.sf.carte.echosvg.svggen.SVGGraphics2DRuntimeException;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import org.w3c.dom.Element;

public class DefaultImageHandler
implements ImageHandler,
ErrorConstants,
XMLConstants {
    @Override
    public void handleImage(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "width", String.valueOf(image.getWidth(null)));
        element.setAttributeNS(null, "height", String.valueOf(image.getHeight(null)));
        try {
            this.handleHREF(image, element, sVGGeneratorContext);
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            try {
                sVGGeneratorContext.getErrorHandler().handleError(sVGGraphics2DIOException);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
            }
        }
    }

    @Override
    public void handleImage(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "width", String.valueOf(renderedImage.getWidth()));
        element.setAttributeNS(null, "height", String.valueOf(renderedImage.getHeight()));
        try {
            this.handleHREF(renderedImage, element, sVGGeneratorContext);
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            try {
                sVGGeneratorContext.getErrorHandler().handleError(sVGGraphics2DIOException);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
            }
        }
    }

    @Override
    public void handleImage(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) {
        element.setAttributeNS(null, "width", String.valueOf(renderableImage.getWidth()));
        element.setAttributeNS(null, "height", String.valueOf(renderableImage.getHeight()));
        try {
            this.handleHREF(renderableImage, element, sVGGeneratorContext);
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {
            try {
                sVGGeneratorContext.getErrorHandler().handleError(sVGGraphics2DIOException);
            }
            catch (SVGGraphics2DIOException sVGGraphics2DIOException2) {
                throw new SVGGraphics2DRuntimeException(sVGGraphics2DIOException2);
            }
        }
    }

    protected void handleHREF(Image image, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", image.toString());
    }

    protected void handleHREF(RenderedImage renderedImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", renderedImage.toString());
    }

    protected void handleHREF(RenderableImage renderableImage, Element element, SVGGeneratorContext sVGGeneratorContext) throws SVGGraphics2DIOException {
        element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", renderableImage.toString());
    }
}

