/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.svggen.DefaultCachedImageHandler;
import io.sf.carte.echosvg.svggen.ImageCacher;
import io.sf.carte.echosvg.svggen.SVGGraphics2DIOException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class CachedImageHandlerJPEGEncoder
extends DefaultCachedImageHandler {
    public static final String CACHED_JPEG_PREFIX = "jpegImage";
    public static final String CACHED_JPEG_SUFFIX = ".jpg";
    protected String refPrefix = "";

    public CachedImageHandlerJPEGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        this.refPrefix = string2 + "/";
        this.setImageCacher(new ImageCacher.External(string, CACHED_JPEG_PREFIX, CACHED_JPEG_SUFFIX));
    }

    @Override
    public void encodeImage(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        imageWriterParams.setJPEGQuality(1.0f, false);
        imageWriter.writeImage((RenderedImage)bufferedImage, outputStream, imageWriterParams);
    }

    @Override
    public int getBufferedImageType() {
        return 1;
    }

    @Override
    public String getRefPrefix() {
        return this.refPrefix;
    }
}

