/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.XYZColor;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Objects;
import org.w3c.dom.DOMException;

class XYZColorImpl
extends BaseColor
implements XYZColor {
    private static final long serialVersionUID = 1L;
    private PrimitiveValue x = null;
    private PrimitiveValue y = null;
    private PrimitiveValue z = null;
    private final ColorProfile.Illuminant refWhite;

    XYZColorImpl(ColorProfile.Illuminant illuminant) {
        this.refWhite = illuminant;
    }

    XYZColorImpl(XYZColorImpl xYZColorImpl) {
        this.refWhite = xYZColorImpl.refWhite;
        if (xYZColorImpl.x != null) {
            this.x = xYZColorImpl.x.clone();
        }
        if (xYZColorImpl.y != null) {
            this.y = xYZColorImpl.y.clone();
        }
        if (xYZColorImpl.z != null) {
            this.z = xYZColorImpl.z.clone();
        }
        this.alpha = xYZColorImpl.alpha.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.XYZ;
    }

    @Override
    public String getColorSpace() {
        return this.refWhite == ColorProfile.Illuminant.D50 ? "xyz-d50" : "xyz";
    }

    @Override
    BaseColor.Space getSpace() {
        return this.refWhite == ColorProfile.Illuminant.D50 ? BaseColor.Space.CIE_XYZ_D50 : BaseColor.Space.CIE_XYZ;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        XYZColorImpl xYZColorImpl = (XYZColorImpl)baseColor;
        this.x = xYZColorImpl.x;
        this.y = xYZColorImpl.y;
        this.z = xYZColorImpl.z;
    }

    @Override
    public PrimitiveValue item(int n) {
        switch (n) {
            case 0: {
                return this.alpha;
            }
            case 1: {
                return this.getX();
            }
            case 2: {
                return this.getY();
            }
            case 3: {
                return this.getZ();
            }
        }
        return null;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        switch (n) {
            case 0: {
                this.setAlpha(primitiveValue);
                break;
            }
            case 1: {
                this.setX(primitiveValue);
                break;
            }
            case 2: {
                this.setY(primitiveValue);
                break;
            }
            case 3: {
                this.setZ(primitiveValue);
            }
        }
    }

    @Override
    public PrimitiveValue getX() {
        return this.x;
    }

    public void setX(PrimitiveValue primitiveValue) {
        this.x = this.normalizeAxisComponent(primitiveValue);
    }

    @Override
    public PrimitiveValue getY() {
        return this.y;
    }

    public void setY(PrimitiveValue primitiveValue) {
        this.y = this.normalizeAxisComponent(primitiveValue);
    }

    @Override
    public PrimitiveValue getZ() {
        return this.z;
    }

    public void setZ(PrimitiveValue primitiveValue) {
        this.z = this.normalizeAxisComponent(primitiveValue);
    }

    private PrimitiveValue normalizeAxisComponent(PrimitiveValue primitiveValue) {
        return XYZColorImpl.normalizePcntToNumber(primitiveValue, 0.01f, 5, true);
    }

    @Override
    boolean hasConvertibleComponents() {
        return XYZColorImpl.isConvertibleComponent(this.getX()) && XYZColorImpl.isConvertibleComponent(this.getY()) && XYZColorImpl.isConvertibleComponent(this.getZ());
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        numberValue.setSubproperty(true);
        numberValue.setAbsolutizedUnit();
        numberValue.setMaxFractionDigits(5);
        this.setX(numberValue);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)dArray[1]);
        numberValue2.setSubproperty(true);
        numberValue2.setAbsolutizedUnit();
        numberValue2.setMaxFractionDigits(5);
        this.setY(numberValue2);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)0, (float)dArray[2]);
        numberValue3.setSubproperty(true);
        numberValue3.setAbsolutizedUnit();
        numberValue3.setMaxFractionDigits(5);
        this.setZ(numberValue3);
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[]{ColorUtil.floatNumber((TypedValue)this.x), ColorUtil.floatNumber((TypedValue)this.y), ColorUtil.floatNumber((TypedValue)this.z)};
        return dArray;
    }

    @Override
    double[] toXYZ(ColorProfile.Illuminant illuminant) {
        double[] dArray = this.toNumberArray();
        if (this.refWhite != illuminant) {
            dArray = illuminant == ColorProfile.Illuminant.D50 ? ColorUtil.d65xyzToD50(dArray) : ColorUtil.d50xyzToD65(dArray);
        }
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        double[] dArray = this.toNumberArray();
        double[] dArray2 = this.refWhite == ColorProfile.Illuminant.D50 ? ColorUtil.d50xyzToD65(dArray) : dArray;
        double[] dArray3 = new double[3];
        ColorUtil.d65xyzToSRGB(dArray2, dArray3);
        if (!ColorUtil.rangeRoundCheck(dArray3) && bl) {
            double[] dArray4 = new double[3];
            if (this.refWhite == ColorProfile.Illuminant.D65) {
                dArray = ColorUtil.d65xyzToD50(dArray2);
            }
            ColorUtil.xyzD50ToLab(dArray, dArray4);
            SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
            ColorUtil.clampRGB(dArray4[0], dArray4[1], dArray4[2], sRGBColorProfile, dArray3);
        }
        return dArray3;
    }

    RGBAColor toSRGBColor(boolean bl) {
        double[] dArray = this.toSRGB(bl);
        RGBColor rGBColor = new RGBColor();
        rGBColor.setColorComponents(dArray);
        rGBColor.setAlpha(this.getAlpha().clone());
        return rGBColor;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Objects.hash(new Object[]{this.refWhite, this.x, this.y, this.z});
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XYZColorImpl xYZColorImpl = (XYZColorImpl)object;
        return this.refWhite == xYZColorImpl.refWhite && Objects.equals(this.x, xYZColorImpl.x) && Objects.equals(this.y, xYZColorImpl.y) && Objects.equals(this.z, xYZColorImpl.z);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public XYZColorImpl clone() {
        return new XYZColorImpl(this);
    }
}

