/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSVarValue;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public class VarValue
extends ProxyValue
implements CSSVarValue {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private LexicalUnit fallback = null;

    VarValue() {
        super(CSSValue.Type.VAR);
        this.fallback = null;
    }

    protected VarValue(VarValue varValue) {
        super(varValue);
        this.name = varValue.name;
        this.fallback = varValue.fallback;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LexicalUnit getFallback() {
        return this.fallback;
    }

    public void setFallback(LexicalUnit lexicalUnit) {
        this.fallback = lexicalUnit;
    }

    @Override
    public String getCssText() {
        String string;
        int n = this.name.length();
        if (this.fallback == null) {
            n += 2;
            string = null;
        } else {
            string = this.fallback.toString();
            n += 4 + string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append("var(");
        stringBuilder.append(this.name);
        if (string != null) {
            stringBuilder.append(", ");
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"var(");
        simpleWriter.write((CharSequence)this.name);
        if (this.fallback != null) {
            simpleWriter.write((CharSequence)", ");
            this.writeFallback(simpleWriter);
        }
        simpleWriter.write(')');
    }

    private void writeFallback(SimpleWriter simpleWriter) throws IOException {
        ValueFactory valueFactory = new ValueFactory();
        try {
            StyleValue styleValue = valueFactory.createCSSValue(this.fallback);
            styleValue.writeCssText(simpleWriter);
        }
        catch (DOMException dOMException) {
            simpleWriter.write((CharSequence)this.fallback.toString());
        }
    }

    @Override
    public String getMinifiedCssText(String string) {
        int n = this.name.length() + 5;
        if (this.fallback != null) {
            n += 80;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append("var(");
        stringBuilder.append(this.name);
        if (this.fallback != null) {
            stringBuilder.append(',');
            this.appendMinifiedFallback(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private void appendMinifiedFallback(StringBuilder stringBuilder) {
        String string;
        ValueFactory valueFactory = new ValueFactory();
        try {
            StyleValue styleValue = valueFactory.createCSSValue(this.fallback);
            string = styleValue.getMinifiedCssText(this.name);
        }
        catch (DOMException dOMException) {
            string = this.fallback.toString();
        }
        stringBuilder.append(string);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        LexicalUnit lexicalUnit;
        this.checkModifiableProperty();
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue(new StringReader(string));
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (IOException iOException) {
            return;
        }
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
            throw new DOMException(13, "Not a var() function.");
        }
        PrimitiveValue.LexicalSetter lexicalSetter = this.newLexicalSetter();
        lexicalSetter.setLexicalUnit(lexicalUnit);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + (this.fallback == null ? 0 : this.fallback.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VarValue varValue = (VarValue)object;
        if (this.name == null ? varValue.name != null : !this.name.equals(varValue.name)) {
            return false;
        }
        if (this.fallback == null) {
            return varValue.fallback == null;
        }
        return this.fallback.equals(varValue.fallback);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public VarValue clone() {
        return new VarValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            if (lexicalUnit2 == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            String string = lexicalUnit2.getStringValue();
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw new DOMException(12, "Fallback must be separated by comma");
                }
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    VarValue.this.fallback = lexicalUnit2.clone();
                } else {
                    VarValue.this.fallback = null;
                }
            }
            VarValue.this.name = string;
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

