/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Arrays;
import org.w3c.dom.DOMException;

class ProfiledColorImpl
extends BaseColor {
    private static final long serialVersionUID = 1L;
    private String colorSpace;
    private PrimitiveValue[] components;

    ProfiledColorImpl(String string) {
        this(string, new PrimitiveValue[0]);
    }

    ProfiledColorImpl(String string, PrimitiveValue[] primitiveValueArray) {
        this.colorSpace = string;
        this.components = primitiveValueArray;
    }

    ProfiledColorImpl(ProfiledColorImpl profiledColorImpl) {
        this.alpha = profiledColorImpl.alpha;
        this.colorSpace = profiledColorImpl.colorSpace;
        this.components = (PrimitiveValue[])profiledColorImpl.components.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.PROFILE;
    }

    @Override
    public String getColorSpace() {
        return this.colorSpace;
    }

    @Override
    BaseColor.Space getSpace() {
        return BaseColor.Space.OTHER;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        ProfiledColorImpl profiledColorImpl = (ProfiledColorImpl)baseColor;
        if (profiledColorImpl.components.length != this.components.length) {
            throw new DOMException(13, "This value can only be set to a color in the " + (Object)((Object)this.getColorModel()) + " color model with " + this.components.length + " components.");
        }
        System.arraycopy(profiledColorImpl.components, 0, this.components, 0, this.components.length);
        this.colorSpace = baseColor.getColorSpace();
    }

    @Override
    public PrimitiveValue item(int n) {
        if (n == 0) {
            return this.getAlpha();
        }
        try {
            return this.components[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        if (n == 0) {
            this.setAlpha(primitiveValue);
        } else {
            try {
                this.components[n - 1] = primitiveValue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getLength() {
        return this.components.length + 1;
    }

    @Override
    public boolean hasConvertibleComponents() {
        int n = this.components.length;
        for (int i = 0; i < n; ++i) {
            if (ProfiledColorImpl.isConvertibleComponent(this.components[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    void setColorComponents(double[] dArray) {
        NumberValue numberValue;
        int n;
        if (this.components.length == 0) {
            this.components = new PrimitiveValue[dArray.length];
        }
        for (n = 0; n < dArray.length; ++n) {
            numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[n]);
            numberValue.setSubproperty(true);
            numberValue.setAbsolutizedUnit();
            this.components[n] = numberValue;
        }
        for (n = dArray.length; n < this.components.length; ++n) {
            numberValue = NumberValue.createCSSNumberValue((short)0, 0.0f);
            numberValue.setSubproperty(true);
            this.components[n] = numberValue;
        }
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[this.components.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((TypedValue)this.components[i]).getFloatValue((short)0);
        }
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        throw new DOMException(9, "Cannot convert profiled colors.");
    }

    @Override
    double[] toXYZ(ColorProfile.Illuminant illuminant) {
        throw new DOMException(9, "Cannot convert profiled colors.");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("color(").append(this.getColorSpace());
        for (PrimitiveValue primitiveValue : this.components) {
            stringBuilder.append(' ');
            this.appendComponentCssText(stringBuilder, primitiveValue);
        }
        if (this.isNonOpaque()) {
            stringBuilder.append(" / ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public String toMinifiedString() {
        StringBuilder stringBuilder = new StringBuilder(58);
        stringBuilder.append("color(").append(this.getColorSpace());
        for (PrimitiveValue primitiveValue : this.components) {
            stringBuilder.append(' ');
            this.appendComponentMinifiedCssText(stringBuilder, primitiveValue);
        }
        if (this.isNonOpaque()) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.components);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ProfiledColorImpl profiledColorImpl = (ProfiledColorImpl)object;
        return Arrays.equals(this.components, profiledColorImpl.components);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public ProfiledColorImpl clone() {
        return new ProfiledColorImpl(this);
    }
}

