/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueItem;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

public abstract class PrimitiveValue
extends StyleValue
implements CSSPrimitiveValue {
    private static final long serialVersionUID = 1L;
    private final CSSValue.Type primitiveType;
    private boolean subproperty = false;

    protected PrimitiveValue(CSSValue.Type type) {
        this.primitiveType = type;
    }

    protected PrimitiveValue(PrimitiveValue primitiveValue) {
        this.subproperty = primitiveValue.subproperty;
        this.primitiveType = primitiveValue.primitiveType;
    }

    @Override
    public CSSValue.Type getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public boolean isPrimitiveValue() {
        return true;
    }

    @Override
    public void setExpectInteger() {
        throw new DOMException(17, "Expected an integer, found type " + (Object)((Object)this.getPrimitiveType()));
    }

    public void setSubproperty(boolean bl) {
        this.subproperty = bl;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    void checkModifiableProperty() throws DOMException {
        if (this.isSubproperty() || this.isReadOnly()) {
            throw new DOMException(7, "This property was either set as a shorthand or as part of a more complex property. Must modify at a higher level (possibly at the style-declaration).");
        }
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.primitiveType.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PrimitiveValue primitiveValue = (PrimitiveValue)object;
        return this.primitiveType == primitiveValue.primitiveType;
    }

    LexicalSetter newLexicalSetter() {
        return null;
    }

    @Override
    public abstract PrimitiveValue clone();

    class LexicalSetter
    implements ValueItem {
        LexicalUnit nextLexicalUnit = null;
        private LinkedList<String> syntaxWarnings = null;

        LexicalSetter() {
        }

        void setLexicalUnit(LexicalUnit lexicalUnit) throws DOMException {
        }

        @Override
        public LexicalUnit getNextLexicalUnit() {
            return this.nextLexicalUnit;
        }

        @Override
        public PrimitiveValue getCSSValue() {
            return PrimitiveValue.this;
        }

        void reportSyntaxWarning(String string) {
            if (this.syntaxWarnings == null) {
                this.syntaxWarnings = new LinkedList();
            }
            this.syntaxWarnings.add(string);
        }

        @Override
        public boolean hasWarnings() {
            return this.syntaxWarnings != null;
        }

        @Override
        public void handleSyntaxWarnings(StyleDeclarationErrorHandler styleDeclarationErrorHandler) {
            if (this.syntaxWarnings != null) {
                Iterator iterator = this.syntaxWarnings.iterator();
                while (iterator.hasNext()) {
                    styleDeclarationErrorHandler.syntaxWarning((String)iterator.next());
                }
            }
        }

        boolean checkProxyValue(LexicalUnit lexicalUnit) {
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.VAR || lexicalType == LexicalUnit.LexicalType.ATTR) {
                throw new CSSLexicalProcessingException("Cannot handle this PROXY in this value.");
            }
            return false;
        }

        public String toString() {
            return PrimitiveValue.this.getCssText();
        }
    }
}

