/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.HWBColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import org.w3c.dom.DOMException;

public class HWBColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.HWBColorValue {
    private static final long serialVersionUID = 1L;
    private final HWBColorImpl hwbColor;

    public HWBColorValue() {
        this(new HWBColorImpl());
    }

    HWBColorValue(HWBColorImpl hWBColorImpl) {
        this.hwbColor = hWBColorImpl;
    }

    HWBColorValue(HWBColorValue hWBColorValue) {
        super(hWBColorValue);
        this.hwbColor = hWBColorValue.hwbColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.HWB;
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        HWBColorImpl hWBColorImpl = ((HWBColorValue)styleValue).hwbColor;
        this.hwbColor.setHue(hWBColorImpl.getHue());
        this.hwbColor.setWhiteness(hWBColorImpl.getWhiteness());
        this.hwbColor.setBlackness(hWBColorImpl.getBlackness());
        this.hwbColor.alpha = hWBColorImpl.alpha;
    }

    @Override
    public String getCssText() {
        return this.hwbColor.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        String string2;
        String string3 = this.hwbColor.toMinifiedString();
        if (!this.hwbColor.isNonOpaque() && this.hasConvertibleComponents() && (string2 = ((ColorValue.CSSRGBColor)this.toRGBColor()).toMinifiedString()).length() < string3.length()) {
            string3 = string2;
        }
        return string3;
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.hwbColor.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.hwbColor.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.hwbColor.hasConvertibleComponents();
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        double[] dArray = this.hwbColor.toSRGB(false);
        ColorValue.CSSRGBColor cSSRGBColor = new ColorValue.CSSRGBColor();
        cSSRGBColor.setColorComponents(dArray);
        cSSRGBColor.setAlpha(this.hwbColor.alpha.clone());
        return cSSRGBColor;
    }

    @Override
    public HWBColor getColor() {
        return this.hwbColor;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private static void checkPcntCompValidity(PrimitiveValue primitiveValue, LexicalUnit lexicalUnit) {
        if (primitiveValue.getUnitType() != 2 && primitiveValue.getCssValueType() != CSSValue.CssType.PROXY && primitiveValue.getPrimitiveType() != CSSValue.Type.EXPRESSION) {
            throw new DOMException(17, "Type not compatible: " + lexicalUnit.toString());
        }
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.hwbColor.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof HWBColorValue)) {
            return false;
        }
        HWBColorValue hWBColorValue = (HWBColorValue)object;
        return this.hwbColor.equals(hWBColorValue.hwbColor);
    }

    @Override
    public HWBColorValue clone() {
        return new HWBColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(HWBColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.HWBCOLOR) {
                    throw new DOMException(13, "No hwb() value: " + lexicalUnit.toString());
                }
                this.setLexicalHWB(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalHWB(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            HWBColorValue.checkPcntCompValidity(primitiveValue2, lexicalUnit);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            HWBColorValue.checkPcntCompValidity(primitiveValue3, lexicalUnit);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue4 = null;
            if (lexicalUnit2 != null) {
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lexicalUnit.toString());
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                HWBColorValue.this.hwbColor.setAlpha(primitiveValue4);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
            HWBColorValue.this.hwbColor.setHue(primitiveValue);
            HWBColorValue.this.hwbColor.setWhiteness(primitiveValue2);
            HWBColorValue.this.hwbColor.setBlackness(primitiveValue3);
        }
    }
}

