/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.UnknownValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class FunctionValue
extends TypedValue
implements CSSFunctionValue {
    private static final long serialVersionUID = 1L;
    private String functionName = null;
    private final LinkedCSSValueList arguments = new LinkedCSSValueList();

    public FunctionValue() {
        super(CSSValue.Type.FUNCTION);
    }

    protected FunctionValue(CSSValue.Type type) {
        super(type);
    }

    protected FunctionValue(FunctionValue functionValue) {
        super(functionValue);
        this.functionName = functionValue.functionName;
        this.arguments.addAll(functionValue.arguments);
    }

    @Override
    public LinkedCSSValueList getArguments() {
        return this.arguments;
    }

    @Override
    public StyleValue getComponent(int n) {
        try {
            return (StyleValue)this.arguments.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        try {
            this.arguments.set(n, styleValue);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public int getComponentCount() {
        return this.arguments.getLength();
    }

    void setFunctionName(String string) {
        this.functionName = string;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case transformFunction: 
            case transformList: {
                return ParseHelper.isTransformFunction(this.functionName) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case image: {
                return this.isImageFunction() ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private boolean isImageFunction() {
        return this.functionName.endsWith("-gradient") || this.functionName.equalsIgnoreCase("image") || this.functionName.equalsIgnoreCase("image-set") || this.functionName.equalsIgnoreCase("cross-fade");
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(this.functionName.length() + this.arguments.size() * 8 + 12);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.functionName.length() + this.arguments.size() * 8 + 12);
        stringBuilder.append(this.functionName).append('(');
        int n = this.arguments.size();
        if (n > 0) {
            stringBuilder.append(((StyleValue)this.arguments.get(0)).getMinifiedCssText(string));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(',').append(((StyleValue)this.arguments.get(i)).getMinifiedCssText(string));
            }
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.functionName);
        simpleWriter.write('(');
        int n = this.arguments.size();
        if (n == 1) {
            StyleValue styleValue = (StyleValue)this.arguments.get(0);
            if (styleValue.getPrimitiveType() == CSSValue.Type.EXPRESSION && ((CSSExpressionValue)((Object)styleValue)).getStringValue().length() == 0) {
                ((CSSExpressionValue)((Object)styleValue)).getExpression().writeCssText(simpleWriter);
            } else {
                styleValue.writeCssText(simpleWriter);
            }
        } else if (n != 0) {
            ((StyleValue)this.arguments.get(0)).writeCssText(simpleWriter);
            for (int i = 1; i < n; ++i) {
                simpleWriter.write(',');
                simpleWriter.write(' ');
                ((StyleValue)this.arguments.get(i)).writeCssText(simpleWriter);
            }
        }
        simpleWriter.write(')');
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.functionName;
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.arguments == null ? 0 : this.arguments.hashCode());
        n2 = 31 * n2 + (this.functionName == null ? 0 : this.functionName.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FunctionValue functionValue = (FunctionValue)object;
        if (this.arguments == null ? functionValue.arguments != null : !this.arguments.equals(functionValue.arguments)) {
            return false;
        }
        if (this.functionName == null) {
            return functionValue.functionName == null;
        }
        return this.functionName.equals(functionValue.functionName);
    }

    @Override
    public FunctionValue clone() {
        return new FunctionValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(FunctionValue.this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            FunctionValue.this.functionName = lexicalUnit.getFunctionName();
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            boolean bl = false;
            ValueList valueList = null;
            while (true) {
                Object object;
                StyleValue styleValue;
                Object object2;
                block22: {
                    if (lexicalUnit2 == null) {
                        this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
                        return;
                    }
                    LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
                    if (lexicalType == LexicalUnit.LexicalType.SUB_EXPRESSION) {
                        object2 = this.subExpression(lexicalUnit2);
                        styleValue = object2.getCSSValue();
                    } else {
                        if (lexicalType == LexicalUnit.LexicalType.LEFT_BRACKET) {
                            object = lexicalUnit2.getNextLexicalUnit();
                            object2 = valueFactory.parseBracketList((LexicalUnit)object, null, false);
                            if (object2 != null) {
                                styleValue = object2.getCSSValue();
                                break block22;
                            } else {
                                lexicalUnit2 = object.getNextLexicalUnit();
                                continue;
                            }
                        }
                        if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                            if (valueList != null && valueList.getLength() == 1 && this.isOperand(valueList.item(0))) {
                                valueList = null;
                                object2 = this.expressionItem(lexicalUnit2);
                                styleValue = object2.getCSSValue();
                            } else {
                                object = new ValueFactory.BasicValueItem();
                                ((ValueFactory.BasicValueItem)object).nextLexicalUnit = lexicalUnit2.getNextLexicalUnit();
                                object2 = object;
                                styleValue = new UnknownValue();
                                ((UnknownValue)styleValue).setPlainCssText("/");
                            }
                        } else if (valueList != null && (lexicalType == LexicalUnit.LexicalType.OPERATOR_PLUS || lexicalType == LexicalUnit.LexicalType.OPERATOR_MINUS || lexicalType == LexicalUnit.LexicalType.OPERATOR_MULTIPLY) && valueList.getLength() == 1 && this.isOperand(valueList.item(0))) {
                            valueList = null;
                            object2 = this.expressionItem(lexicalUnit2);
                            styleValue = object2.getCSSValue();
                        } else {
                            object2 = valueFactory.createCSSPrimitiveValueItem(lexicalUnit2, false, true);
                            styleValue = object2.getCSSValue();
                        }
                    }
                }
                lexicalUnit2 = object2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                        if (!bl && !FunctionValue.this.arguments.isEmpty()) {
                            valueList = ValueList.createWSValueList();
                            object = FunctionValue.this.arguments.iterator();
                            while (object.hasNext()) {
                                valueList.add((StyleValue)object.next());
                            }
                            valueList.add(styleValue);
                            FunctionValue.this.arguments.clear();
                            FunctionValue.this.arguments.add(valueList);
                            valueList = null;
                        } else if (valueList == null) {
                            FunctionValue.this.arguments.add(styleValue);
                        } else {
                            valueList.add(styleValue);
                            valueList = null;
                        }
                        bl = true;
                        continue;
                    }
                    if (valueList == null) {
                        valueList = ValueList.createWSValueList();
                        valueList.add(styleValue);
                        FunctionValue.this.arguments.add(valueList);
                        continue;
                    }
                    valueList.add(styleValue);
                    continue;
                }
                if (valueList == null) {
                    FunctionValue.this.arguments.add(styleValue);
                    continue;
                }
                valueList.add(styleValue);
            }
        }

        private boolean isOperand(StyleValue styleValue) {
            if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
                CSSValue.Type type = cSSTypedValue.getPrimitiveType();
                switch (type) {
                    case STRING: 
                    case COLOR: 
                    case COLOR_MIX: 
                    case URI: 
                    case ATTR: 
                    case COUNTER: 
                    case COUNTERS: 
                    case RECT: 
                    case UNKNOWN: 
                    case ELEMENT_REFERENCE: 
                    case GRADIENT: 
                    case UNICODE_CHARACTER: 
                    case UNICODE_RANGE: 
                    case UNICODE_WILDCARD: {
                        break;
                    }
                    case IDENT: {
                        return this.isConstant(cSSTypedValue.getStringValue());
                    }
                    default: {
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isConstant(String string) {
            return "e".equalsIgnoreCase(string) || "pi".equalsIgnoreCase(string);
        }

        private ValueItem subExpression(LexicalUnit lexicalUnit) {
            ExpressionValue expressionValue = new ExpressionValue();
            ExpressionValue.ExpressionLexicalSetter expressionLexicalSetter = expressionValue.newLexicalSetter();
            expressionLexicalSetter.setLexicalUnitFromSubValues(lexicalUnit.getSubValues());
            LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
                if (lexicalType == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    expressionLexicalSetter.setLexicalUnitFromSubValues(lexicalUnit);
                } else {
                    expressionLexicalSetter.setLexicalUnitFromSubValues(lexicalUnit.getSubValues());
                    expressionLexicalSetter.nextLexicalUnit = lexicalUnit2;
                }
            }
            return expressionLexicalSetter;
        }

        private ValueItem expressionItem(LexicalUnit lexicalUnit) {
            FunctionValue.this.arguments.removeLast();
            LexicalUnit lexicalUnit2 = lexicalUnit.getPreviousLexicalUnit();
            LexicalUnit lexicalUnit3 = lexicalUnit2.getPreviousLexicalUnit();
            if (lexicalUnit3 == null || lexicalUnit3.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                ExpressionValue expressionValue = new ExpressionValue();
                ExpressionValue.ExpressionLexicalSetter expressionLexicalSetter = expressionValue.newLexicalSetter();
                expressionLexicalSetter.setLexicalUnitFromSubValues(lexicalUnit2);
                return expressionLexicalSetter;
            }
            throw new IllegalStateException();
        }
    }
}

