/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueList;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.Unit;
import java.util.Iterator;
import org.w3c.dom.DOMException;

public class Evaluator {
    private final short preferredUnit;

    public Evaluator() {
        this(6);
    }

    public Evaluator(short s) {
        this.preferredUnit = s;
    }

    public TypedValue evaluateFunction(CSSMathFunctionValue cSSMathFunctionValue) throws DOMException {
        Unit unit = new Unit();
        TypedValue typedValue = this.evaluateFunction(cSSMathFunctionValue, unit);
        int n = unit.getExponent();
        if (n > 1 || n < 0) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        float f = typedValue.getFloatValue(typedValue.getUnitType());
        if (Float.isNaN(f)) {
            throw new DOMException(15, "Result is not a number (NaN).");
        }
        return typedValue;
    }

    TypedValue evaluateFunction(CSSMathFunctionValue cSSMathFunctionValue, Unit unit) throws DOMException {
        TypedValue typedValue;
        switch (cSSMathFunctionValue.getFunction()) {
            case MAX: {
                typedValue = this.functionMax(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case MIN: {
                typedValue = this.functionMin(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case CLAMP: {
                typedValue = this.functionClamp(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case SIN: {
                typedValue = this.functionSin(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case COS: {
                typedValue = this.functionCos(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case TAN: {
                typedValue = this.functionTan(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case ASIN: {
                typedValue = this.functionASin(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case ACOS: {
                typedValue = this.functionACos(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case ATAN: {
                typedValue = this.functionATan(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case ATAN2: {
                typedValue = this.functionATan2(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case POW: {
                typedValue = this.functionPow(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case SQRT: {
                typedValue = this.functionSqrt(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case HYPOT: {
                typedValue = this.functionHypot(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case ABS: {
                typedValue = this.functionAbs(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            case SIGN: {
                typedValue = this.functionSign(cSSMathFunctionValue.getArguments(), unit);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown math function: " + cSSMathFunctionValue.getFunctionName());
            }
        }
        return typedValue;
    }

    private TypedValue functionMax(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        short s;
        if (cSSValueList.getLength() == 0) {
            throw new DOMException(12, "max() functions take at least one argument");
        }
        Iterator iterator = cSSValueList.iterator();
        CSSValue cSSValue = (CSSValue)iterator.next();
        TypedValue typedValue = this.enforceTyped(cSSValue);
        typedValue = this.evaluate(typedValue, unit);
        boolean bl = typedValue.isCalculatedNumber();
        float f = this.floatValue(typedValue, unit);
        int n = unit.getExponent();
        short s2 = s = unit.getUnitType();
        float f2 = f;
        while (iterator.hasNext()) {
            cSSValue = (CSSValue)iterator.next();
            typedValue = this.enforceTyped(cSSValue);
            typedValue = this.evaluate(typedValue, unit);
            float f3 = this.floatValue(typedValue, unit);
            if (n != unit.getExponent()) {
                throw new DOMException(15, "max() arguments have incompatible dimensions.");
            }
            float f4 = NumberValue.floatValueConversion(f3, unit.getUnitType(), s);
            if (!(f < f4)) continue;
            f = f4;
            f2 = f3;
            s2 = unit.getUnitType();
            bl = typedValue.isCalculatedNumber();
        }
        NumberValue numberValue = NumberValue.createCSSNumberValue(s2, f2);
        numberValue.setCalculatedNumber(bl);
        return numberValue;
    }

    private TypedValue enforceTyped(CSSValue cSSValue) throws DOMException {
        if (cSSValue.getCssValueType() != CSSValue.CssType.TYPED) {
            throw new DOMException(12, "Unexpected value: " + cSSValue.getCssText());
        }
        TypedValue typedValue = (TypedValue)cSSValue;
        if (typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string = typedValue.getStringValue();
            if ("pi".equalsIgnoreCase(string)) {
                typedValue = NumberValue.createCSSNumberValue((short)0, (float)Math.PI);
            } else if ("e".equalsIgnoreCase(string)) {
                typedValue = NumberValue.createCSSNumberValue((short)0, (float)Math.E);
            } else {
                throw new DOMException(12, "Unexpected value: " + cSSValue.getCssText());
            }
        }
        return typedValue;
    }

    private TypedValue functionMin(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        short s;
        if (cSSValueList.getLength() == 0) {
            throw new DOMException(12, "min() functions take at least one argument");
        }
        Iterator iterator = cSSValueList.iterator();
        CSSValue cSSValue = (CSSValue)iterator.next();
        TypedValue typedValue = this.enforceTyped(cSSValue);
        typedValue = this.evaluate(typedValue, unit);
        boolean bl = typedValue.isCalculatedNumber();
        float f = this.floatValue(typedValue, unit);
        int n = unit.getExponent();
        short s2 = s = unit.getUnitType();
        float f2 = f;
        while (iterator.hasNext()) {
            cSSValue = (CSSValue)iterator.next();
            typedValue = this.enforceTyped(cSSValue);
            typedValue = this.evaluate(typedValue, unit);
            float f3 = this.floatValue(typedValue, unit);
            if (n != unit.getExponent()) {
                throw new DOMException(15, "min() arguments have incompatible dimensions.");
            }
            float f4 = NumberValue.floatValueConversion(f3, unit.getUnitType(), s);
            if (!(f > f4)) continue;
            f = f4;
            f2 = f3;
            s2 = unit.getUnitType();
            bl = typedValue.isCalculatedNumber();
        }
        NumberValue numberValue = NumberValue.createCSSNumberValue(s2, f2);
        numberValue.setCalculatedNumber(bl);
        return numberValue;
    }

    private TypedValue functionClamp(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 3) {
            throw new DOMException(12, "Clamp functions take three arguments");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 1);
        typedValue = this.evaluate(typedValue, unit);
        boolean bl = typedValue.isCalculatedNumber();
        float f = this.floatValue(typedValue, unit);
        short s = unit.getUnitType();
        int n = unit.getExponent();
        TypedValue typedValue2 = this.typedArgument(cSSValueList, 0);
        typedValue2 = this.evaluate(typedValue2, unit);
        float f2 = this.floatValue(typedValue2, unit);
        if (n != unit.getExponent()) {
            throw new DOMException(15, "clamp() arguments have incompatible dimensions.");
        }
        f2 = NumberValue.floatValueConversion(f2, unit.getUnitType(), s);
        TypedValue typedValue3 = this.typedArgument(cSSValueList, 2);
        typedValue3 = this.evaluate(typedValue3, unit);
        float f3 = this.floatValue(typedValue3, unit);
        if (n != unit.getExponent()) {
            throw new DOMException(15, "clamp() arguments have incompatible dimensions.");
        }
        if (f > (f3 = NumberValue.floatValueConversion(f3, unit.getUnitType(), s))) {
            f = f3;
            bl = typedValue3.isCalculatedNumber();
        }
        if (f < f2) {
            f = f2;
            bl = typedValue2.isCalculatedNumber();
        }
        NumberValue numberValue = NumberValue.createCSSNumberValue(s, f);
        numberValue.setCalculatedNumber(bl);
        return numberValue;
    }

    private TypedValue functionSin(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "sin() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(typedValue, unit);
        if (unit.getUnitType() != 0) {
            int n = unit.getExponent();
            if (n > 1 || n < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            f = NumberValue.floatValueConversion(f, unit.getUnitType(), (short)81);
        }
        float f2 = (float)Math.sin(f);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, f2);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionCos(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "cos() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(typedValue, unit);
        if (unit.getUnitType() != 0) {
            int n = unit.getExponent();
            if (n > 1 || n < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            f = NumberValue.floatValueConversion(f, unit.getUnitType(), (short)81);
        }
        float f2 = (float)Math.cos(f);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, f2);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionTan(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "tan() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(typedValue, unit);
        if (unit.getUnitType() != 0) {
            int n = unit.getExponent();
            if (n > 1 || n < 0) {
                throw new DOMException(17, "Argument unit is not angle nor plain number.");
            }
            f = NumberValue.floatValueConversion(f, unit.getUnitType(), (short)81);
        }
        float f2 = (float)Math.tan(f);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, f2);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionASin(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "asin() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = (float)Math.asin(this.evalValue(typedValue, unit));
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "asin() argument must be dimensionless");
        }
        unit.setUnitType((short)81);
        unit.setExponent(1);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)81, f);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionACos(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "acos() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = (float)Math.acos(this.evalValue(typedValue, unit));
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "acos() argument must be dimensionless");
        }
        unit.setUnitType((short)81);
        unit.setExponent(1);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)81, f);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionATan(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "atan() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(typedValue, unit);
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "atan() argument must be dimensionless");
        }
        float f2 = (float)Math.atan(f);
        unit.setUnitType((short)81);
        unit.setExponent(1);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)81, f2);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionATan2(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 2) {
            throw new DOMException(12, "atan2() functions take two arguments");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        TypedValue typedValue2 = this.typedArgument(cSSValueList, 1);
        float f = this.evalValue(typedValue, unit);
        if (unit.getUnitType() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float f2 = this.evalValue(typedValue2, unit);
        if (unit.getExponent() != 0) {
            throw new DOMException(12, "atan2() arguments must be dimensionless");
        }
        float f3 = (float)Math.atan2(f, f2);
        unit.setUnitType((short)81);
        unit.setExponent(1);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)81, f3);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionPow(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 2) {
            throw new DOMException(12, "pow() functions take two arguments");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        TypedValue typedValue2 = this.typedArgument(cSSValueList, 1);
        unit.setUnitType(typedValue.getUnitType());
        float f = this.evalValue(typedValue, unit);
        Unit unit2 = new Unit();
        float f2 = this.evalValue(typedValue2, unit2);
        if (unit2.getExponent() != 0) {
            throw new DOMException(12, "pow() exponent cannot have a dimension");
        }
        float f3 = (float)Math.pow(f, f2);
        unit.setExponent(unit.getExponent() * Math.round(f2));
        NumberValue numberValue = NumberValue.createCSSNumberValue(unit.getUnitType(), f3);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionSqrt(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "sqrt() functions take one argument");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = (float)Math.sqrt(this.evalValue(typedValue, unit));
        int n = unit.getExponent();
        if (n % 2 != 0) {
            throw new DOMException(15, "invalid CSS unit in sqrt() function");
        }
        unit.setExponent(n / 2);
        NumberValue numberValue = NumberValue.createCSSNumberValue(unit.getUnitType(), f);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionHypot(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        int n = cSSValueList.getLength();
        if (n == 2) {
            return this.functionHypot2(cSSValueList, unit);
        }
        if (n == 0) {
            throw new DOMException(12, "hypot() functions need at least one argument.");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(typedValue, unit);
        double d = f * f;
        short s = unit.getUnitType();
        for (int i = 1; i < n; ++i) {
            typedValue = this.typedArgument(cSSValueList, i);
            f = this.evalValue(typedValue, unit);
            if (s != unit.getUnitType()) {
                f = NumberValue.floatValueConversion(f, unit.getUnitType(), s);
            }
            d += (double)(f * f);
        }
        d = Math.sqrt(d);
        NumberValue numberValue = NumberValue.createCSSNumberValue(s, (float)d);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionHypot2(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        TypedValue typedValue2 = this.typedArgument(cSSValueList, 1);
        Unit unit2 = new Unit();
        float f = this.evalValue(typedValue, unit);
        float f2 = this.evalValue(typedValue2, unit2);
        if (unit.getUnitType() != unit2.getUnitType()) {
            f2 = NumberValue.floatValueConversion(f2, unit2.getUnitType(), unit.getUnitType());
        }
        float f3 = (float)Math.hypot(f, f2);
        NumberValue numberValue = NumberValue.createCSSNumberValue(unit.getUnitType(), f3);
        numberValue.setCalculatedNumber(true);
        return numberValue;
    }

    private TypedValue functionAbs(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "abs() functions take one argument.");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        TypedValue typedValue2 = this.evaluate(typedValue, unit);
        float f = this.floatValue(typedValue2, unit);
        float f2 = Math.abs(f);
        NumberValue numberValue = NumberValue.createCSSNumberValue(unit.getUnitType(), f2);
        numberValue.setCalculatedNumber(typedValue2.isCalculatedNumber());
        return numberValue;
    }

    private TypedValue functionSign(CSSValueList<? extends CSSValue> cSSValueList, Unit unit) throws DOMException {
        if (cSSValueList.getLength() != 1) {
            throw new DOMException(12, "sign() functions take one argument.");
        }
        TypedValue typedValue = this.typedArgument(cSSValueList, 0);
        float f = this.evalValue(typedValue, unit);
        unit.setUnitType((short)0);
        unit.setExponent(0);
        float f2 = Math.signum(f);
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValue((short)0, f2);
        return numberValue;
    }

    TypedValue unknownFunction(CSSFunctionValue cSSFunctionValue, Unit unit) {
        unit.setUnitType((short)255);
        cSSFunctionValue = cSSFunctionValue.clone();
        LinkedCSSValueList linkedCSSValueList = cSSFunctionValue.getArguments();
        int n = linkedCSSValueList.getLength();
        for (int i = 0; i < n; ++i) {
            StyleValue styleValue = linkedCSSValueList.item(i);
            if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) continue;
            linkedCSSValueList.set(i, this.absoluteValue((CSSPrimitiveValue)((Object)styleValue)));
        }
        return (TypedValue)((Object)cSSFunctionValue);
    }

    private TypedValue typedArgument(CSSValueList<? extends CSSValue> cSSValueList, int n) {
        CSSValue cSSValue = cSSValueList.item(n);
        return this.enforceTyped(cSSValue);
    }

    private float evalValue(CSSTypedValue cSSTypedValue, Unit unit) throws DOMException {
        TypedValue typedValue = this.evaluate(cSSTypedValue, unit);
        return this.floatValue(typedValue, unit);
    }

    private float floatValue(CSSTypedValue cSSTypedValue, Unit unit) throws DOMException {
        float f;
        short s = unit.getUnitType();
        short s2 = cSSTypedValue.getUnitType();
        if (s2 == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
        } else if (s2 != 2) {
            f = cSSTypedValue.getFloatValue(s);
        } else {
            short s3 = this.getPreferredUnit();
            f = this.percentage(cSSTypedValue, s3);
            unit.setUnitType(s3);
        }
        return f;
    }

    short getPreferredUnit() {
        return this.preferredUnit;
    }

    public TypedValue evaluateExpression(ExpressionValue expressionValue) throws DOMException {
        float f;
        Unit unit = new Unit();
        TypedValue typedValue = this.evaluateExpression(expressionValue.getExpression(), unit);
        int n = unit.getExponent();
        if (n > 1 || n < 0) {
            throw new DOMException(17, "Resulting unit is not valid CSS unit.");
        }
        if (expressionValue.mustRoundResult()) {
            ((NumberValue)typedValue).roundToInteger();
        }
        if (Float.isNaN(f = typedValue.getFloatValue(typedValue.getUnitType()))) {
            throw new DOMException(15, "Result is not a number (NaN).");
        }
        return typedValue;
    }

    TypedValue evaluateExpression(CSSExpression cSSExpression, Unit unit) throws DOMException {
        float f;
        Object object;
        switch (cSSExpression.getPartType()) {
            case SUM: {
                object = (AlgebraicExpression)cSSExpression;
                f = this.sum((AlgebraicExpression)object, unit);
                if (cSSExpression.getParentExpression() != null || !cSSExpression.isInverseOperation()) break;
                f = -f;
                break;
            }
            case PRODUCT: {
                AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
                f = this.multiply(algebraicExpression, unit);
                break;
            }
            default: {
                return this.evaluate(((CSSOperandExpression)cSSExpression).getOperand(), unit);
            }
        }
        object = NumberValue.createCSSNumberValue(unit.getUnitType(), f);
        ((NumberValue)object).setCalculatedNumber(true);
        ((NumberValue)object).setAbsolutizedUnit();
        return object;
    }

    private float sum(AlgebraicExpression algebraicExpression, Unit unit) throws DOMException {
        int n = algebraicExpression.getLength();
        if (n == 0) {
            throw new DOMException(12, "Sum without operands.");
        }
        CSSExpression cSSExpression = algebraicExpression.item(0);
        float f = this.evalValue(this.evaluateExpression(cSSExpression, unit), unit);
        if (cSSExpression.isInverseOperation()) {
            f = -f;
        }
        short s = unit.getUnitType();
        for (int i = 1; i < n; ++i) {
            cSSExpression = algebraicExpression.item(i);
            float f2 = this.evalValue(this.evaluateExpression(cSSExpression, unit), unit);
            short s2 = unit.getUnitType();
            if (s != s2) {
                f2 = NumberValue.floatValueConversion(f2, s2, s);
            }
            if (cSSExpression.isInverseOperation()) {
                f -= f2;
                continue;
            }
            f += f2;
        }
        unit.setUnitType(s);
        return f;
    }

    private float multiply(AlgebraicExpression algebraicExpression, Unit unit) throws DOMException {
        float f = 1.0f;
        short s = 0;
        int n = 0;
        int n2 = algebraicExpression.getLength();
        for (int i = 0; i < n2; ++i) {
            CSSExpression cSSExpression = algebraicExpression.item(i);
            TypedValue typedValue = this.evaluateExpression(cSSExpression, unit);
            float f2 = this.evalValue(typedValue, unit);
            short s2 = unit.getUnitType();
            if (s2 != 0) {
                if (s == 0) {
                    s = s2;
                } else {
                    try {
                        f2 = NumberValue.floatValueConversion(f2, s2, s);
                    }
                    catch (DOMException dOMException) {
                        if (cSSExpression.isInverseOperation()) {
                            throw dOMException;
                        }
                        f2 = this.unitCancellation(f2, s2, s, dOMException);
                        if (--n == 0) {
                            s = 0;
                        }
                        f *= f2;
                        continue;
                    }
                    s2 = s;
                }
            }
            if (cSSExpression.isInverseOperation()) {
                if (s2 != 0) {
                    s = --n != 0 ? s2 : (short)0;
                }
                if (!Float.isNaN(f /= f2)) continue;
                throw new DOMException(15, "Found NaN.");
            }
            if (s2 != 0) {
                s = ++n != 0 ? s2 : (short)0;
            }
            f *= f2;
        }
        if (n < 0) {
            if (s == 100) {
                s = 90;
                n = -n;
            } else if (s == 101) {
                s = 91;
                n = -n;
            } else if (s == 90) {
                s = 100;
                n = -n;
            } else if (s == 91) {
                s = 101;
                n = -n;
            }
        }
        unit.setUnitType(s);
        unit.setExponent(n);
        return f;
    }

    private float unitCancellation(float f, short s, short s2, DOMException dOMException) throws DOMException {
        if (s == 90 || s == 91) {
            if (s2 == 100) {
                return NumberValue.floatValueConversion(f, s, (short)90);
            }
            if (s2 == 101) {
                return NumberValue.floatValueConversion(f, s, (short)91);
            }
        } else if (s == 100 || s == 101) {
            if (s2 == 90) {
                return NumberValue.floatValueConversion(f, s, (short)100);
            }
            if (s2 == 91) {
                return NumberValue.floatValueConversion(f, s, (short)101);
            }
        }
        throw dOMException;
    }

    private TypedValue evaluate(CSSPrimitiveValue cSSPrimitiveValue, Unit unit) {
        TypedValue typedValue;
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case MATH_FUNCTION: {
                typedValue = this.evaluateFunction((CSSMathFunctionValue)cSSPrimitiveValue, unit);
                break;
            }
            case EXPRESSION: {
                CSSExpression cSSExpression = ((ExpressionValue)cSSPrimitiveValue).getExpression();
                typedValue = this.evaluateExpression(cSSExpression, unit);
                break;
            }
            case FUNCTION: {
                typedValue = this.unknownFunction((CSSFunctionValue)cSSPrimitiveValue, unit);
                break;
            }
            default: {
                typedValue = this.absoluteValue(cSSPrimitiveValue);
                unit.setUnitType(typedValue.getUnitType());
            }
        }
        return typedValue;
    }

    protected TypedValue absoluteValue(CSSPrimitiveValue cSSPrimitiveValue) throws DOMException {
        CSSValue.CssType cssType = cSSPrimitiveValue.getCssValueType();
        while (cssType == CSSValue.CssType.PROXY) {
            CSSValue cSSValue = this.absoluteProxyValue(cSSPrimitiveValue);
            if (cSSValue == null) {
                throw new DOMException(15, "Unable to evaluate: " + cSSPrimitiveValue.getCssText());
            }
            cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
            cssType = cSSValue.getCssValueType();
        }
        if (cssType == CSSValue.CssType.TYPED) {
            return this.absoluteTypedValue((TypedValue)cSSPrimitiveValue);
        }
        throw new DOMException(15, "Unexpected value: " + cSSPrimitiveValue.getCssText());
    }

    protected TypedValue absoluteTypedValue(TypedValue typedValue) {
        return typedValue;
    }

    protected CSSValue absoluteProxyValue(CSSPrimitiveValue cSSPrimitiveValue) {
        throw new DOMException(15, "Unexpected value: " + cSSPrimitiveValue.getCssText());
    }

    protected float percentage(CSSTypedValue cSSTypedValue, short s) throws DOMException {
        throw new DOMException(9, "Unexpected percentage in calc()");
    }
}

