/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSFunctionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.AttrValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.Unit;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.LinkedList;
import java.util.Random;
import org.w3c.dom.DOMException;

class DimensionalEvaluator
extends Evaluator {
    private transient boolean hasPercentage;
    private transient Random random = null;
    private transient CSSExpression latestExpression;
    private transient CSSMathFunctionValue latestFunction;
    private transient boolean unknownFunction;

    DimensionalEvaluator() {
    }

    boolean hasUnknownFunction() {
        return this.unknownFunction;
    }

    @Override
    TypedValue evaluateExpression(CSSExpression cSSExpression, Unit unit) throws DOMException {
        this.latestExpression = cSSExpression;
        return super.evaluateExpression(cSSExpression, unit);
    }

    short computeUnitType(CSSExpression cSSExpression) throws DOMException {
        this.hasPercentage = false;
        Unit unit = new Unit();
        this.evaluateExpression(cSSExpression, unit);
        int n = unit.getExponent();
        short s = n > 1 || n < 0 ? (short)255 : (short)unit.getUnitType();
        return s;
    }

    CSSValueSyntax.Category dimensionalAnalysis(CSSExpression cSSExpression) throws DOMException {
        return this.getCategory(this.computeUnitType(cSSExpression));
    }

    @Override
    TypedValue evaluateFunction(CSSMathFunctionValue cSSMathFunctionValue, Unit unit) throws DOMException {
        this.latestFunction = cSSMathFunctionValue;
        return super.evaluateFunction(cSSMathFunctionValue, unit);
    }

    short computeUnitType(CSSMathFunctionValue cSSMathFunctionValue) throws DOMException {
        this.hasPercentage = false;
        Unit unit = new Unit();
        this.evaluateFunction(cSSMathFunctionValue, unit);
        short s = unit.getUnitType();
        int n = unit.getExponent();
        if (n > 1 || n < 0 || this.hasPercentage && s != 2 && s != 0) {
            s = 255;
        }
        return s;
    }

    CSSValueSyntax.Category dimensionalAnalysis(CSSMathFunctionValue cSSMathFunctionValue) throws DOMException {
        short s;
        this.hasPercentage = false;
        Unit unit = new Unit();
        this.evaluateFunction(cSSMathFunctionValue, unit);
        switch (unit.getExponent()) {
            case 0: {
                this.hasPercentage = false;
            }
            case 1: {
                s = unit.getUnitType();
                break;
            }
            default: {
                s = 255;
            }
        }
        return this.getCategory(s);
    }

    private CSSValueSyntax.Category getCategory(short s) throws DOMException {
        CSSValueSyntax.Category category;
        if (s == 0) {
            category = this.hasPercentage ? CSSValueSyntax.Category.percentage : CSSValueSyntax.Category.number;
        } else if (CSSUnit.isLengthUnitType(s)) {
            category = this.hasPercentage ? CSSValueSyntax.Category.lengthPercentage : CSSValueSyntax.Category.length;
        } else if (CSSUnit.isAngleUnitType(s)) {
            category = CSSValueSyntax.Category.angle;
        } else if (CSSUnit.isTimeUnitType(s)) {
            category = CSSValueSyntax.Category.time;
        } else if (CSSUnit.isResolutionUnitType(s)) {
            category = CSSValueSyntax.Category.resolution;
        } else if (s == 100 || s == 101) {
            category = CSSValueSyntax.Category.frequency;
        } else if (s == 2) {
            category = CSSValueSyntax.Category.percentage;
        } else {
            throw new DOMException(17, "Unknown unit: " + s);
        }
        return category;
    }

    @Override
    protected CSSValue absoluteProxyValue(CSSPrimitiveValue cSSPrimitiveValue) {
        if (cSSPrimitiveValue.getPrimitiveType() == CSSValue.Type.ATTR) {
            this.checkRandom();
            AttrValue attrValue = (AttrValue)cSSPrimitiveValue;
            String string = attrValue.getAttributeType();
            if (string != null) {
                int n = string.length();
                if (n <= 2) {
                    ValueFactory valueFactory = new ValueFactory();
                    NumberValue numberValue = (NumberValue)valueFactory.parseProperty('1' + string);
                    numberValue.setFloatValue(numberValue.getUnitType(), this.random.nextFloat() + 1.1f);
                    return numberValue;
                }
                if ("length".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)3, this.random.nextFloat() + 1.1f);
                }
                if ("percentage".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)2, this.random.nextFloat() * 10.0f + 1.1f);
                }
                if ("integer".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)0, this.random.nextInt(15) + 1);
                }
                if ("number".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)0, this.random.nextFloat() + 1.1f);
                }
                if ("angle".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)81, this.random.nextFloat() + 1.1f);
                }
                if ("time".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)90, this.random.nextFloat() + 1.1f);
                }
                if ("frequency".equals(string)) {
                    return NumberValue.createCSSNumberValue((short)100, this.random.nextFloat() * 10.0f + 1.1f);
                }
            }
        }
        return super.absoluteProxyValue(cSSPrimitiveValue);
    }

    @Override
    protected TypedValue absoluteTypedValue(TypedValue typedValue) {
        int n = typedValue.getUnitType();
        if (CSSUnit.isRelativeLengthUnitType((short)n)) {
            this.checkRandom();
            n = 3;
            NumberValue numberValue = NumberValue.createCSSNumberValue((short)3, typedValue.getFloatValue(typedValue.getUnitType()) * (this.random.nextFloat() + 1.1f));
            numberValue.setCalculatedNumber(true);
            typedValue = numberValue;
        } else if (n == 2) {
            this.hasPercentage = true;
        }
        return typedValue;
    }

    private void checkRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
    }

    @Override
    protected float percentage(CSSTypedValue cSSTypedValue, short s) throws DOMException {
        this.hasPercentage = true;
        return cSSTypedValue.getFloatValue((short)2);
    }

    @Override
    TypedValue unknownFunction(CSSFunctionValue cSSFunctionValue, Unit unit) {
        this.unknownFunction = true;
        return super.unknownFunction(cSSFunctionValue, unit);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    short getPreferredUnit() {
        Object object;
        int n = 2;
        if (this.latestExpression != null) {
            CSSOperandExpression cSSOperandExpression;
            CSSPrimitiveValue cSSPrimitiveValue;
            for (object = this.latestExpression.getParentExpression(); object != null && object.getPartType() == CSSExpression.AlgebraicPart.PRODUCT; object = object.getParentExpression()) {
            }
            if (object != null && (object = this.findNonPercentOperand((CSSExpression)object)) != null && (cSSPrimitiveValue = (cSSOperandExpression = (CSSOperandExpression)object).getOperand()).getUnitType() != 255 && CSSUnit.isRelativeLengthUnitType((short)(n = cSSPrimitiveValue.getUnitType()))) {
                n = 3;
            }
        }
        if (this.latestFunction == null) return (short)n;
        if (n != 2) return (short)n;
        object = this.latestFunction.getArguments();
        int n2 = ((LinkedCSSValueList)object).getLength();
        int n3 = 0;
        while (n3 < n2) {
            StyleValue styleValue = (StyleValue)((LinkedList)object).get(n3);
            switch (styleValue.getPrimitiveType()) {
                case NUMERIC: {
                    short s = ((TypedValue)styleValue).getUnitType();
                    if (s == 2 || s == 255 || s == 1) break;
                    n = s;
                    if (!CSSUnit.isRelativeLengthUnitType((short)n)) return (short)n;
                    return (short)3;
                }
                case EXPRESSION: {
                    short s = ((ExpressionValue)styleValue).computeUnitType();
                    if (s == 255) break;
                    return (short)((int)s);
                }
                case MATH_FUNCTION: {
                    short s = ((CSSMathFunctionValue)((Object)styleValue)).computeUnitType();
                    if (s == 255) break;
                    return (short)((int)s);
                }
            }
            ++n3;
        }
        return (short)n;
    }

    private CSSExpression findNonPercentOperand(CSSExpression cSSExpression) {
        block0 : switch (cSSExpression.getPartType()) {
            case SUM: {
                AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
                int n = algebraicExpression.getLength();
                for (int i = 0; i < n; ++i) {
                    CSSOperandExpression cSSOperandExpression;
                    CSSPrimitiveValue cSSPrimitiveValue;
                    CSSExpression cSSExpression2 = algebraicExpression.item(i);
                    if (cSSExpression2.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
                        cSSExpression2 = this.findNonPercentOperand(cSSExpression2);
                    }
                    if (cSSExpression2 != null && cSSExpression2.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = (cSSOperandExpression = (CSSOperandExpression)cSSExpression2).getOperand()).getUnitType() != 2 && cSSPrimitiveValue.getUnitType() != 255) {
                        cSSExpression = cSSExpression2;
                        break block0;
                    }
                    cSSExpression = null;
                }
                break;
            }
            case PRODUCT: {
                AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
                int n = algebraicExpression.getLength();
                for (int i = 0; i < n; ++i) {
                    CSSOperandExpression cSSOperandExpression;
                    CSSPrimitiveValue cSSPrimitiveValue;
                    CSSExpression cSSExpression3 = algebraicExpression.item(i);
                    if (cSSExpression3.getPartType() != CSSExpression.AlgebraicPart.OPERAND) {
                        cSSExpression3 = this.findNonPercentOperand(cSSExpression3);
                    }
                    if (cSSExpression3 != null && cSSExpression3.getPartType() == CSSExpression.AlgebraicPart.OPERAND && (cSSPrimitiveValue = (cSSOperandExpression = (CSSOperandExpression)cSSExpression3).getOperand()).getUnitType() != 2 && cSSPrimitiveValue.getUnitType() != 0 && cSSPrimitiveValue.getUnitType() != 255) {
                        cSSExpression = cSSExpression3;
                        break block0;
                    }
                    cSSExpression = null;
                }
                break;
            }
        }
        return cSSExpression;
    }
}

