/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.jclf.math.linear3.Matrices;
import org.w3c.dom.DOMException;

class ColorUtil {
    ColorUtil() {
    }

    static double hueRadians(CSSTypedValue cSSTypedValue) {
        float f;
        short s = cSSTypedValue.getUnitType();
        if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
            f = NumberValue.floatValueConversion(f, (short)80, (short)81);
        } else {
            try {
                f = cSSTypedValue.getFloatValue((short)81);
            }
            catch (DOMException dOMException) {
                if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    f = 0.0f;
                }
                throw dOMException;
            }
        }
        double d = f;
        double d2 = Math.PI * 2;
        if (Math.abs(d) > Math.PI * 2) {
            d = Math.IEEEremainder(d, Math.PI * 2);
        }
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    static double hueDegrees(CSSTypedValue cSSTypedValue) {
        float f;
        short s = cSSTypedValue.getUnitType();
        if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
        } else {
            try {
                f = cSSTypedValue.getFloatValue((short)80);
            }
            catch (DOMException dOMException) {
                if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
                    f = 0.0f;
                }
                throw dOMException;
            }
        }
        double d = f;
        if (Math.abs(d) > 360.0) {
            d = Math.IEEEremainder(d, 360.0);
        }
        if (d < 0.0) {
            d += 360.0;
        }
        return d;
    }

    static double floatPercent(CSSTypedValue cSSTypedValue) {
        double d;
        short s = cSSTypedValue.getUnitType();
        if (s == 2) {
            d = cSSTypedValue.getFloatValue((short)2);
        } else if (s == 0) {
            d = cSSTypedValue.getFloatValue((short)0);
        } else if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            d = 0.0;
        } else {
            throw new DOMException(17, "Wrong component: " + cSSTypedValue.getCssText());
        }
        return d;
    }

    static float fraction(CSSTypedValue cSSTypedValue) {
        float f;
        short s = cSSTypedValue.getUnitType();
        if (s == 2) {
            f = cSSTypedValue.getFloatValue((short)2);
        } else if (s == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
        } else if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            f = 0.0f;
        } else {
            throw new DOMException(17, "Wrong component: " + cSSTypedValue.getCssText());
        }
        return f * 0.01f;
    }

    static float floatNumber(CSSTypedValue cSSTypedValue) {
        float f;
        if (cSSTypedValue.getUnitType() == 0) {
            f = cSSTypedValue.getFloatValue((short)0);
        } else if (cSSTypedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            f = 0.0f;
        } else {
            throw new DOMException(17, "Wrong component: " + cSSTypedValue.getCssText());
        }
        return f;
    }

    static double[] srgbToHsl(double d, double d2, double d3) {
        double d4;
        double d5;
        boolean bl = false;
        boolean bl2 = false;
        if (d2 > d) {
            d5 = d2;
            bl2 = true;
        } else {
            d5 = d;
            bl = true;
        }
        if (d3 > d5) {
            d5 = d3;
            bl = false;
            bl2 = false;
        }
        double d6 = Math.min(d, d2);
        if (d5 == (d6 = Math.min(d6, d3))) {
            d4 = 0.0;
        } else if (bl) {
            d4 = (d2 - d3) / (d5 - d6) * 60.0 + 360.0;
            if ((d4 = Math.IEEEremainder(d4, 360.0)) < 0.0) {
                d4 += 360.0;
            }
        } else if (bl2) {
            d4 = (d3 - d) / (d5 - d6) * 60.0 + 120.0;
            if (d4 < 0.0) {
                d4 += 360.0;
            }
        } else {
            d4 = (d - d2) / (d5 - d6) * 60.0 + 240.0;
            if (d4 < 0.0) {
                d4 += 360.0;
            }
        }
        double d7 = (d5 + d6) * 0.5;
        double[] dArray = new double[3];
        dArray[1] = d5 != d6 ? (d7 <= 0.5 ? (double)Math.round((d5 - d6) / d7 * 50000.0) * 0.001 : (double)Math.round((d5 - d6) / (1.0 - d7) * 50000.0) * 0.001) : 0.0;
        dArray[0] = (double)Math.round(d4 * 1000.0) * 0.001;
        if (dArray[0] >= 360.0) {
            dArray[0] = dArray[0] - 360.0;
        }
        dArray[2] = (double)Math.round(d7 * 100000.0) * 0.001;
        return dArray;
    }

    static double[] srgbToHwb(double[] dArray) {
        int n;
        double d;
        double d2 = Math.min(dArray[0], dArray[1]);
        d2 = Math.min(d2, dArray[2]);
        double d3 = Math.max(dArray[0], dArray[1]);
        d3 = Math.max(d3, dArray[2]);
        double[] dArray2 = new double[3];
        if (Math.abs(d3 - d2) < 1.0E-5) {
            dArray2[0] = 0.0;
            dArray2[1] = d2;
            dArray2[2] = dArray[2];
            return dArray2;
        }
        if (dArray[0] == d2) {
            d = dArray[1] - dArray[2];
            n = 3;
        } else if (dArray[1] == d2) {
            d = dArray[2] - dArray[0];
            n = 5;
        } else {
            d = dArray[0] - dArray[1];
            n = 1;
        }
        dArray2[0] = ((double)n - d / (d3 - d2)) * 60.0;
        dArray2[1] = d2 * 100.0;
        dArray2[2] = (1.0 - d3) * 100.0;
        return dArray2;
    }

    static void labToLCh(double[] dArray, double[] dArray2) {
        dArray2[0] = dArray[0];
        dArray2[1] = Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        dArray2[2] = Math.atan2(dArray[2], dArray[1]) * 180.0 / Math.PI;
        if (dArray2[2] < 0.0) {
            dArray2[2] = dArray2[2] + 360.0;
        }
    }

    static void lchToLab(double[] dArray, double[] dArray2) {
        double d = dArray[2] * Math.PI / 180.0;
        dArray2[0] = dArray[0];
        dArray2[1] = dArray[1] * Math.cos(d);
        dArray2[2] = dArray[1] * Math.sin(d);
    }

    static void labToClampedRGB(double d, double d2, double d3, boolean bl, ColorProfile colorProfile, double[] dArray) {
        ColorUtil.labToRGB(d, d2, d3, colorProfile, dArray);
        if (!ColorUtil.rangeRoundCheck(dArray) && bl) {
            ColorUtil.clampRGB(d, d2, d3, colorProfile, dArray);
        }
    }

    static double[] labToXYZd50(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6 = (d + 16.0) / 116.0;
        double d7 = d2 / 500.0 + d6;
        double d8 = d6 - d3 / 200.0;
        double d9 = 0.008856451679035631;
        double d10 = 903.2962962962963;
        double d11 = d7 * d7 * d7;
        if (d11 <= 0.008856451679035631) {
            d11 = (116.0 * d7 - 16.0) / 903.2962962962963;
        }
        if ((d5 = d8 * d8 * d8) <= 0.008856451679035631) {
            d5 = (116.0 * d8 - 16.0) / 903.2962962962963;
        }
        if (d > 8.0) {
            d4 = (d + 16.0) / 116.0;
            d4 = d4 * d4 * d4;
        } else {
            d4 = d / 903.2962962962963;
        }
        double d12 = 0.96422;
        double d13 = 0.82521;
        double d14 = d11 * d12;
        double d15 = d5 * d13;
        double[] dArray = new double[]{d14, d4, d15};
        return dArray;
    }

    private static void labToRGB(double d, double d2, double d3, ColorProfile colorProfile, double[] dArray) {
        double[] dArray2 = ColorUtil.labToXYZd50(d, d2, d3);
        if (colorProfile.getIlluminant() == ColorProfile.Illuminant.D65) {
            dArray2 = ColorUtil.d50xyzToD65(dArray2);
        }
        colorProfile.xyzToRgb(dArray2, dArray);
    }

    static void oklabToRGB(double d, double d2, double d3, boolean bl, ColorProfile colorProfile, double[] dArray) {
        ColorUtil.oklabToSRGB(d, d2, d3, dArray);
        if (!ColorUtil.rangeRoundCheck(dArray) && bl) {
            ColorUtil.okClampRGB(d, d2, d3, colorProfile, dArray);
        }
    }

    private static void oklabToSRGB(double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = ColorUtil.oklabToXyzD65(d, d2, d3);
        ColorUtil.d65xyzToSRGB(dArray2, dArray);
    }

    static void oklabToLab(double d, double d2, double d3, double[] dArray) {
        double[] dArray2 = ColorUtil.oklabToXyzD65(d, d2, d3);
        double[] dArray3 = ColorUtil.d65xyzToD50(dArray2);
        ColorUtil.xyzD50ToLab(dArray3, dArray);
    }

    static double[] oklabToXyzD65(double d, double d2, double d3) {
        double d4 = d + 0.3963377774 * d2 + 0.2158037573 * d3;
        double d5 = d - 0.1055613458 * d2 - 0.0638541728 * d3;
        double d6 = d - 0.0894841775 * d2 - 1.291485548 * d3;
        double d7 = d4 * d4 * d4;
        double d8 = d5 * d5 * d5;
        double d9 = d6 * d6 * d6;
        double[][] dArrayArray = new double[][]{{1.2270138511035211, -0.5577999806518222, 0.28125614896646783}, {-0.04058017842328059, 1.11225686961683, -0.07167667866560119}, {-0.0763812845057069, -0.4214819784180127, 1.586163220440795}};
        double[] dArray = new double[3];
        Matrices.multiplyByVector3((double[][])dArrayArray, (double)d7, (double)d8, (double)d9, (double[])dArray);
        return dArray;
    }

    static void xyzD65ToOkLab(double[] dArray, double[] dArray2) {
        double[][] dArrayArray = new double[][]{{0.8189330101, 0.3618667424, -0.1288597137}, {0.0329845436, 0.9293118715, 0.0361456387}, {0.0482003018, 0.2643662691, 0.633851707}};
        double[] dArray3 = new double[3];
        Matrices.multiplyByVector3((double[][])dArrayArray, (double[])dArray, (double[])dArray3);
        double d = 0.3333333333333333;
        dArray3[0] = Math.signum(dArray3[0]) * Math.pow(Math.abs(dArray3[0]), 0.3333333333333333);
        dArray3[1] = Math.signum(dArray3[1]) * Math.pow(Math.abs(dArray3[1]), 0.3333333333333333);
        dArray3[2] = Math.signum(dArray3[2]) * Math.pow(Math.abs(dArray3[2]), 0.3333333333333333);
        double[][] dArrayArray2 = new double[][]{{0.2104542553, 0.793617785, -0.0040720468}, {1.9779984951, -2.428592205, 0.4505937099}, {0.0259040371, 0.7827717662, -0.808675766}};
        Matrices.multiplyByVector3((double[][])dArrayArray2, (double[])dArray3, (double[])dArray2);
    }

    static boolean rangeRoundCheck(double[] dArray) {
        boolean bl = true;
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (d < 0.0) {
                if (d > -1.0E-4) {
                    dArray[i] = 0.0;
                    continue;
                }
                bl = false;
                continue;
            }
            if (!(d > 1.0)) continue;
            if (d < 1.0001) {
                dArray[i] = 1.0;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    static void clampRGB(double d, double d2, double d3, ColorProfile colorProfile, double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        double d4 = Math.atan2(d3, d2);
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = d2;
        double d8 = d3;
        if (Math.sqrt(d2 * d2 + d3 * d3) > 400.0) {
            double d9 = 400.0;
            d7 = 400.0 * d6;
            d8 = 400.0 * d5;
            ColorUtil.labToRGB(d, d7, d8, colorProfile, dArray);
        }
        if (ColorUtil.isInGamut(d, d7, d8, dArray, dArray3 = new double[3], dArray2 = new double[3])) {
            System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
            return;
        }
        double d10 = Math.sqrt(d7 * d7 + d8 * d8) - dArray2[0];
        d7 = d10 * d6;
        d8 = d10 * d5;
        ColorUtil.labToRGB(d, d7, d8, colorProfile, dArray);
        double d11 = 0.025;
        double d12 = 0.97;
        while (true) {
            ColorUtil.rangeClamp(dArray, dArray3);
            ColorUtil.rgbToLab(dArray3[0], dArray3[1], dArray3[2], dArray2);
            d10 = Math.sqrt(d7 * d7 + d8 * d8);
            double d13 = ColorUtil.deltaE2000ChromaReduction(d, d10, d7, d8, dArray2);
            if (d13 < 2.0) {
                if (d12 < 1.0) {
                    if (d11 < 9.0E-5) {
                        System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
                        return;
                    }
                    d12 = 1.0 + (d11 *= 0.15);
                }
            } else if (d12 > 1.0) {
                d12 = 1.0 - (d11 *= 0.15);
            }
            d7 = (d10 *= d12) * d6;
            d8 = d10 * d5;
            ColorUtil.labToRGB(d, d7, d8, colorProfile, dArray);
        }
    }

    private static void okClampRGB(double d, double d2, double d3, ColorProfile colorProfile, double[] dArray) {
        double[] dArray2;
        double[] dArray3;
        ColorUtil.oklabToLab(d, d2, d3, dArray);
        d = dArray[0];
        double d4 = dArray[1];
        double d5 = dArray[2];
        double d6 = Math.atan2(d5, d4);
        double d7 = Math.sin(d6);
        double d8 = Math.cos(d6);
        if (Math.sqrt(d4 * d4 + d5 * d5) > 400.0) {
            double d9 = 400.0;
            d4 = 400.0 * d8;
            d5 = 400.0 * d7;
            ColorUtil.oklabToSRGB(d, d4, d5, dArray);
        }
        if (ColorUtil.isInGamut(d, d4, d5, dArray, dArray3 = new double[3], dArray2 = new double[3])) {
            System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
            return;
        }
        double d10 = Math.sqrt(d4 * d4 + d5 * d5) - dArray2[0];
        d4 = d10 * d8;
        d5 = d10 * d7;
        ColorUtil.oklabToSRGB(d, d4, d5, dArray);
        float f = 0.025f;
        float f2 = 0.97f;
        while (true) {
            ColorUtil.rangeClamp(dArray, dArray3);
            ColorUtil.rgbToLab(dArray3[0], dArray3[1], dArray3[2], dArray2);
            d10 = Math.sqrt(d4 * d4 + d5 * d5);
            double d11 = ColorUtil.deltaE2000ChromaReduction(d, d10, d4, d5, dArray2);
            if (d11 < 2.0) {
                if (f2 < 1.0f) {
                    if ((double)f < 9.0E-5) {
                        System.arraycopy(dArray3, 0, dArray, 0, dArray.length);
                        return;
                    }
                    f2 = 1.0f + (f *= 0.15f);
                }
            } else if (f2 > 1.0f) {
                f2 = 1.0f - (f *= 0.15f);
            }
            d4 = (d10 *= (double)f2) * d8;
            d5 = d10 * d7;
            ColorUtil.labToRGB(d, d4, d5, colorProfile, dArray);
        }
    }

    private static void rangeClamp(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            dArray2[i] = d > 1.0 ? 1.0 : (d < 0.0 ? 0.0 : dArray[i]);
        }
    }

    private static boolean isInGamut(double d, double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3) {
        ColorUtil.rangeClamp(dArray, dArray2);
        ColorUtil.rgbToLab(dArray2[0], dArray2[1], dArray2[2], dArray3);
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = ColorUtil.deltaE2000ChromaReduction(d, d4, d2, d3, dArray3);
        return d5 < 2.0;
    }

    static double[] d65xyzToD50(double[] dArray) {
        double[] dArray2 = new double[]{1.0478112436606313 * dArray[0] + 0.022886602481693052 * dArray[1] - 0.05012697596852886 * dArray[2], 0.029542398290574905 * dArray[0] + 0.9904844034904394 * dArray[1] - 0.017049095628961564 * dArray[2], -0.009234489723309473 * dArray[0] + 0.015043616793498756 * dArray[1] + 0.7521316354746059 * dArray[2]};
        return dArray2;
    }

    static double[] d50xyzToD65(double[] dArray) {
        double[] dArray2 = new double[]{0.955576615033105 * dArray[0] + -0.02303934471607876 * dArray[1] + 0.06316363224980126 * dArray[2], -0.028289544243554895 * dArray[0] + 1.0099416173711144 * dArray[1] + 0.021007654996190325 * dArray[2], 0.012298165717207273 * dArray[0] + -0.020483025232449423 * dArray[1] + 1.329909826449757 * dArray[2]};
        return dArray2;
    }

    static void d65xyzToSRGB(double[] dArray, double[] dArray2) {
        double d = 3.24096994190452 * dArray[0] - 1.53738317757 * dArray[1] - 0.498610760293 * dArray[2];
        double d2 = -0.96924363628088 * dArray[0] + 1.8759675015077 * dArray[1] + 0.04155505740718 * dArray[2];
        double d3 = 0.055630079697 * dArray[0] - 0.20397695888898 * dArray[1] + 1.05697151424288 * dArray[2];
        dArray2[0] = ColorUtil.sRGBCompanding(d);
        dArray2[1] = ColorUtil.sRGBCompanding(d2);
        dArray2[2] = ColorUtil.sRGBCompanding(d3);
    }

    private static double sRGBCompanding(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 <= 0.0031308 ? 12.92 * d : 1.055 * Math.signum(d) * Math.pow(d2, 0.4166666666666667) - 0.055;
        return d3;
    }

    static double[] srgbToXYZd65(double d, double d2, double d3) {
        d = RGBColor.inverseSRGBCompanding(d);
        d2 = RGBColor.inverseSRGBCompanding(d2);
        d3 = RGBColor.inverseSRGBCompanding(d3);
        return ColorUtil.linearSRGBToXYZd65(d, d2, d3);
    }

    static void rgbToLab(double d, double d2, double d3, double[] dArray) {
        d = RGBColor.inverseSRGBCompanding(d);
        d2 = RGBColor.inverseSRGBCompanding(d2);
        d3 = RGBColor.inverseSRGBCompanding(d3);
        double[] dArray2 = ColorUtil.linearSRGBToXYZd65(d, d2, d3);
        double[] dArray3 = ColorUtil.d65xyzToD50(dArray2);
        ColorUtil.xyzD50ToLab(dArray3, dArray);
    }

    static double[] linearSRGBToXYZd65(double d, double d2, double d3) {
        double[] dArray = new double[]{0.41239079926595934 * d + 0.357584339383878 * d2 + 0.1804807884018343 * d3, 0.21263900587151027 * d + 0.715168678767756 * d2 + 0.07219231536073371 * d3, 0.01933081871559182 * d + 0.11919477979462598 * d2 + 0.9505321522496607 * d3};
        return dArray;
    }

    static void xyzD50ToLab(double[] dArray, double[] dArray2) {
        double d = BaseColor.whiteD50[0];
        double d2 = BaseColor.whiteD50[2];
        dArray[0] = dArray[0] / d;
        dArray[2] = dArray[2] / d2;
        double d3 = ColorUtil.fxyz(dArray[0]);
        double d4 = ColorUtil.fxyz(dArray[1]);
        double d5 = ColorUtil.fxyz(dArray[2]);
        dArray2[0] = 116.0 * d4 - 16.0;
        dArray2[1] = 500.0 * (d3 - d4);
        dArray2[2] = 200.0 * (d4 - d5);
    }

    private static double fxyz(double d) {
        double d2 = 0.008856451679035631;
        double d3 = 903.2962962962963;
        double d4 = d > 0.008856451679035631 ? Math.pow(d, 0.3333333333333333) : (903.2962962962963 * d + 16.0) / 116.0;
        return d4;
    }

    static float deltaE2000LCh(float f, float f2, double d, float f3, float f4, double d2) {
        double d3 = f3 - f;
        double d4 = (double)(f + f3) * 0.5;
        double d5 = (double)(f2 + f4) * 0.5;
        double d6 = (double)f2 * Math.cos(d);
        double d7 = (double)f4 * Math.cos(d2);
        double d8 = (double)f2 * Math.sin(d);
        double d9 = (double)f4 * Math.sin(d2);
        return ColorUtil.deltaE2000(d3, d4, d5, d6, d8, d7, d9);
    }

    static float deltaE2000Lab(float f, float f2, float f3, float f4, float f5, float f6) {
        double d = f4 - f;
        double d2 = (double)(f + f4) * 0.5;
        double d3 = Math.sqrt(f2 * f2 + f3 * f3);
        double d4 = Math.sqrt(f5 * f5 + f6 * f6);
        double d5 = (d3 + d4) * 0.5;
        return ColorUtil.deltaE2000(d, d2, d5, f2, f3, f5, f6);
    }

    private static float deltaE2000(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = Math.pow(d3, 7.0);
        double d10 = 1.0 + 0.5 * (1.0 - Math.sqrt(d9 / (d9 + 6.103515625E9)));
        double d11 = d4 * d10;
        double d12 = d6 * d10;
        double d13 = Math.sqrt(d11 * d11 + d5 * d5);
        double d14 = Math.sqrt(d12 * d12 + d7 * d7);
        double d15 = d14 - d13;
        double d16 = (d13 + d14) * 0.5;
        double d17 = Math.PI * 2;
        double d18 = Math.atan2(d5, d11);
        if (d18 < 0.0) {
            d18 += Math.PI * 2;
        }
        if ((d8 = Math.atan2(d7, d12)) < 0.0) {
            d8 += Math.PI * 2;
        }
        double d19 = 0.0;
        double d20 = d8 - d18;
        if (Math.abs(d18 - d8) > Math.PI) {
            d20 = d8 <= d18 ? (d20 += Math.PI * 2) : (d20 -= Math.PI * 2);
            d19 = Math.PI;
        }
        double d21 = 2.0 * Math.sqrt(d13 * d14) * Math.sin(d20 * 0.5);
        double d22 = 1.0 - 0.17 * Math.cos((d19 += (d18 + d8) * 0.5) - 0.5235988) + 0.24 * Math.cos(d19 + d19) + 0.32 * Math.cos(3.0 * d19 + 0.1047198) - 0.2 * Math.cos(4.0 * d19 - 1.099557);
        double d23 = d2 - 50.0;
        d23 *= d23;
        double d24 = 1.0 + 0.015 * d23 / Math.sqrt(d23 + 20.0);
        double d25 = 1.0 + 0.045 * d16;
        double d26 = 1.0 + 0.015 * d16 * d22;
        double d27 = Math.pow(d16, 7.0);
        double d28 = (d19 - 4.799655443) / 0.436332313;
        double d29 = -2.0 * Math.sqrt(d27 / (d27 + 6.103515625E9)) * Math.sin(1.04719755 * Math.exp(-d28 * d28));
        double d30 = d / d24;
        double d31 = d15 / d25;
        double d32 = d21 / d26;
        double d33 = d29 * d31 * d32;
        double d34 = Math.sqrt(d30 * d30 + d31 * d31 + d32 * d32 + d33);
        return (float)d34;
    }

    private static double deltaE2000ChromaReduction(double d, double d2, double d3, double d4, double[] dArray) {
        double d5;
        double d6 = Math.sqrt(dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        double d7 = (d2 + d6) * 0.5;
        double d8 = Math.pow(d7, 7.0);
        double d9 = 1.0 + 0.5 * (1.0 - Math.sqrt(d8 / (d8 + 6.103515625E9)));
        double d10 = d3 * d9;
        double d11 = dArray[1] * d9;
        double d12 = Math.sqrt(d10 * d10 + d4 * d4);
        double d13 = Math.sqrt(d11 * d11 + dArray[2] * dArray[2]);
        double d14 = d13 - d12;
        double d15 = (d12 + d13) * 0.5;
        double d16 = Math.PI * 2;
        double d17 = Math.atan2(d4, d10);
        if (d17 < 0.0) {
            d17 += Math.PI * 2;
        }
        if ((d5 = Math.atan2(dArray[2], d11)) < 0.0) {
            d5 += Math.PI * 2;
        }
        double d18 = 0.0;
        double d19 = d5 - d17;
        if (Math.abs(d17 - d5) > Math.PI) {
            d19 = d5 <= d17 ? (d19 += Math.PI * 2) : (d19 -= Math.PI * 2);
            d18 = Math.PI;
        }
        double d20 = 2.0 * Math.sqrt(d12 * d13) * Math.sin(d19 * 0.5);
        double d21 = 1.0 - 0.17 * Math.cos((d18 += (d17 + d5) * 0.5) - 0.5235988) + 0.24 * Math.cos(d18 + d18) + 0.32 * Math.cos(3.0 * d18 + 0.1047198) - 0.2 * Math.cos(4.0 * d18 - 1.099557);
        double d22 = 1.0 + 0.045 * d15;
        double d23 = 1.0 + 0.015 * d15 * d21;
        double d24 = Math.pow(d15, 7.0);
        double d25 = (d18 - 4.799655443) / 0.436332313;
        double d26 = d14 / d22;
        double d27 = d20 / d23;
        double d28 = -2.0 * Math.sqrt(d24 / (d24 + 6.103515625E9)) * Math.sin(1.04719755 * Math.exp(-d25 * d25));
        double d29 = d28 * d26 * d27;
        double d30 = Math.sqrt(d26 * d26 + d27 * d27 + d29);
        double d31 = d30 - 2.0;
        double d32 = d31 * d31 - d27 * d27 - d29;
        dArray[0] = d32 > 0.0 ? d22 * Math.sqrt(d32) : 0.0;
        return d30;
    }
}

