/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.property.A98RGBColorProfile;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.DisplayP3ColorProfile;
import io.sf.carte.doc.style.css.property.HSLColorImpl;
import io.sf.carte.doc.style.css.property.HWBColorImpl;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LCHColorImpl;
import io.sf.carte.doc.style.css.property.ProPhotoRGBColorProfile;
import io.sf.carte.doc.style.css.property.ProfiledRGBColor;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.Rec2020ColorProfile;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import java.util.Locale;
import org.w3c.dom.DOMException;

class ColorConverter {
    private final boolean createValue;
    private BaseColor destColor;

    public ColorConverter(boolean bl) {
        this.createValue = bl;
    }

    public BaseColor getLastColor() {
        return this.destColor;
    }

    double[] toColorSpace(BaseColor baseColor, String string, boolean bl) throws DOMException {
        double[] dArray;
        string = string.toLowerCase(Locale.ROOT);
        if (baseColor.getColorSpace().equals(string)) {
            if (this.createValue) {
                this.destColor = baseColor;
            }
            return baseColor.toNumberArray();
        }
        if ("srgb".equals(string)) {
            dArray = baseColor.toSRGB(true);
            if (this.createValue) {
                this.destColor = new RGBColor();
            }
        } else if ("display-p3".equals(string)) {
            DisplayP3ColorProfile displayP3ColorProfile = new DisplayP3ColorProfile();
            dArray = new double[3];
            this.convertToProfiled(displayP3ColorProfile, baseColor, bl, dArray);
            if (this.createValue) {
                this.destColor = new ProfiledRGBColor("display-p3");
            }
        } else if ("a98-rgb".equals(string)) {
            A98RGBColorProfile a98RGBColorProfile = new A98RGBColorProfile();
            dArray = new double[3];
            this.convertToProfiled(a98RGBColorProfile, baseColor, bl, dArray);
            if (this.createValue) {
                this.destColor = new ProfiledRGBColor("a98-rgb");
            }
        } else if ("prophoto-rgb".equals(string)) {
            ProPhotoRGBColorProfile proPhotoRGBColorProfile = new ProPhotoRGBColorProfile();
            dArray = new double[3];
            this.convertToProfiled(proPhotoRGBColorProfile, baseColor, bl, dArray);
            if (this.createValue) {
                this.destColor = new ProfiledRGBColor("prophoto-rgb");
            }
        } else if ("rec2020".equals(string)) {
            Rec2020ColorProfile rec2020ColorProfile = new Rec2020ColorProfile();
            dArray = new double[3];
            this.convertToProfiled(rec2020ColorProfile, baseColor, bl, dArray);
            if (this.createValue) {
                this.destColor = new ProfiledRGBColor("rec2020");
            }
        } else if ("xyz".equals(string) || "xyz-d65".equals(string)) {
            dArray = baseColor.toXYZ(ColorProfile.Illuminant.D65);
            if (this.createValue) {
                this.destColor = new XYZColorImpl(ColorProfile.Illuminant.D65);
            }
        } else if ("xyz-d50".equals(string)) {
            dArray = baseColor.toXYZ(ColorProfile.Illuminant.D50);
            if (this.createValue) {
                this.destColor = new XYZColorImpl(ColorProfile.Illuminant.D50);
            }
        } else if ("hsl".equals(string) || "hsla".equals(string)) {
            if (baseColor.getColorModel() == CSSColorValue.ColorModel.HSL) {
                dArray = baseColor.toNumberArray();
            } else {
                dArray = baseColor.toSRGB(true);
                dArray = ColorUtil.srgbToHsl(dArray[0], dArray[1], dArray[2]);
            }
            if (this.createValue) {
                this.destColor = new HSLColorImpl();
            }
        } else if ("hwb".equals(string)) {
            if (baseColor.getColorModel() == CSSColorValue.ColorModel.HWB) {
                dArray = baseColor.toNumberArray();
            } else {
                double[] dArray2 = baseColor.toSRGB(true);
                dArray = ColorUtil.srgbToHwb(dArray2);
            }
            if (this.createValue) {
                this.destColor = new HWBColorImpl();
            }
        } else if ("lab".equals(string)) {
            dArray = new double[3];
            if (baseColor.getSpace() == BaseColor.Space.CIE_LCh) {
                double[] dArray3 = baseColor.toNumberArray();
                ColorUtil.lchToLab(dArray3, dArray);
            } else {
                double[] dArray4 = baseColor.toXYZ(ColorProfile.Illuminant.D50);
                ColorUtil.xyzD50ToLab(dArray4, dArray);
            }
            if (this.createValue) {
                this.destColor = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
            }
        } else if ("lch".equals(string)) {
            double[] dArray5;
            if (baseColor.getSpace() == BaseColor.Space.CIE_Lab) {
                dArray5 = baseColor.toNumberArray();
            } else {
                double[] dArray6 = baseColor.toXYZ(ColorProfile.Illuminant.D50);
                dArray5 = new double[3];
                ColorUtil.xyzD50ToLab(dArray6, dArray5);
            }
            dArray = new double[3];
            ColorUtil.labToLCh(dArray5, dArray);
            if (this.createValue) {
                this.destColor = new LCHColorImpl(BaseColor.Space.CIE_LCh, "lch");
            }
        } else if ("oklab".equals(string)) {
            dArray = new double[3];
            if (baseColor.getSpace() == BaseColor.Space.OK_LCh) {
                double[] dArray7 = baseColor.toNumberArray();
                ColorUtil.lchToLab(dArray7, dArray);
            } else {
                double[] dArray8 = baseColor.toXYZ(ColorProfile.Illuminant.D65);
                ColorUtil.xyzD65ToOkLab(dArray8, dArray);
            }
            if (this.createValue) {
                this.destColor = new LABColorImpl(BaseColor.Space.OK_Lab, "oklab");
            }
        } else if ("oklch".equals(string)) {
            double[] dArray9;
            if (baseColor.getSpace() == BaseColor.Space.OK_Lab) {
                dArray9 = baseColor.toNumberArray();
            } else {
                double[] dArray10 = baseColor.toXYZ(ColorProfile.Illuminant.D65);
                dArray9 = new double[3];
                ColorUtil.xyzD65ToOkLab(dArray10, dArray9);
            }
            dArray = new double[3];
            ColorUtil.labToLCh(dArray9, dArray);
            if (this.createValue) {
                this.destColor = new LCHColorImpl(BaseColor.Space.OK_LCh, "oklch");
            }
        } else {
            throw new DOMException(9, "Unsupported color space: " + string);
        }
        if (this.createValue) {
            this.destColor.setAlpha(baseColor.getAlpha().clone());
            this.destColor.setColorComponents(dArray);
        }
        return dArray;
    }

    private void convertToProfiled(ColorProfile colorProfile, BaseColor baseColor, boolean bl, double[] dArray) {
        double[] dArray2 = baseColor.toXYZ(colorProfile.getIlluminant());
        colorProfile.xyzToLinearRgb(dArray2, dArray);
        dArray[0] = colorProfile.gammaCompanding(dArray[0]);
        dArray[1] = colorProfile.gammaCompanding(dArray[1]);
        dArray[2] = colorProfile.gammaCompanding(dArray[2]);
        if (bl && !ColorUtil.rangeRoundCheck(dArray)) {
            double[] dArray3 = new double[3];
            if (colorProfile.getIlluminant() == ColorProfile.Illuminant.D65) {
                dArray2 = ColorUtil.d65xyzToD50(dArray2);
            }
            ColorUtil.xyzD50ToLab(dArray2, dArray3);
            ColorUtil.labToClampedRGB(dArray3[0], dArray3[1], dArray3[2], true, colorProfile, dArray);
        }
    }
}

