/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.ColorConverter;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PercentageValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import org.w3c.dom.DOMException;

abstract class BaseColor
implements CSSColor,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3L;
    static final double[] whiteD65 = new double[]{0.95047, 1.0, 1.08883};
    static final double[] whiteD50 = new double[]{0.96422, 1.0, 0.82521};
    PrimitiveValue alpha = ColorValue.opaqueAlpha;

    BaseColor() {
    }

    @Override
    public String getColorSpace() {
        return "srgb";
    }

    Space getSpace() {
        return Space.sRGB;
    }

    @Override
    public PrimitiveValue getAlpha() {
        return this.alpha;
    }

    public void setAlpha(PrimitiveValue object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException();
        }
        if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateExpression((ExpressionValue)object);
                if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.NUMERIC) {
                    ((NumberValue)object).setMaxFractionDigits(5);
                }
            }
            catch (DOMException dOMException) {}
        } else if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateFunction((CSSMathFunctionValue)object);
                if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.NUMERIC) {
                    ((NumberValue)object).setMaxFractionDigits(5);
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (object.getUnitType() == 0) {
            object2 = (TypedValue)object;
            float f = ((TypedValue)object2).getFloatValue((short)0);
            if (f < 0.0f) {
                object2 = new PercentageValue();
                ((TypedValue)object2).setFloatValue((short)0, 0.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            } else if (f > 1.0f) {
                object2 = new PercentageValue();
                ((TypedValue)object2).setFloatValue((short)0, 1.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            }
        } else if (object.getUnitType() == 2) {
            object2 = (TypedValue)object;
            float f = ((TypedValue)object2).getFloatValue((short)2);
            if (f < 0.0f) {
                object2 = NumberValue.createCSSNumberValue((short)2, 0.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            } else if (f > 100.0f) {
                object2 = NumberValue.createCSSNumberValue((short)2, 100.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            }
        } else if (!(object.getCssValueType() == CSSValue.CssType.PROXY || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)object).getStringValue()))) {
            throw new DOMException(17, "Type not compatible with alpha.");
        }
        this.alpha = object;
    }

    static PrimitiveValue enforcePcntComponent(PrimitiveValue object) throws DOMException {
        Object object2;
        if (object == null) {
            throw new NullPointerException();
        }
        if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateExpression((ExpressionValue)object);
            }
            catch (DOMException dOMException) {}
        } else if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateFunction((CSSMathFunctionValue)object);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (object.getUnitType() == 2) {
            object2 = (TypedValue)object;
            float f = ((TypedValue)object2).getFloatValue((short)2);
            if (f < 0.0f) {
                object2 = NumberValue.createCSSNumberValue((short)2, 0.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            } else if (f > 100.0f) {
                object2 = NumberValue.createCSSNumberValue((short)2, 100.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            }
        } else if (!(object.getCssValueType() == CSSValue.CssType.PROXY || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)object).getStringValue()))) {
            throw new DOMException(17, "Invalid color component: " + ((StyleValue)object).getCssText());
        }
        return object;
    }

    static PrimitiveValue enforcePcntOrNumberComponent(PrimitiveValue object) throws DOMException {
        Object object2;
        if (object == null) {
            throw new NullPointerException();
        }
        if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateExpression((ExpressionValue)object);
            }
            catch (DOMException dOMException) {}
        } else if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateFunction((CSSMathFunctionValue)object);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (object.getUnitType() == 2) {
            object2 = (TypedValue)object;
            float f = ((TypedValue)object2).getFloatValue((short)2);
            if (f < 0.0f) {
                object2 = NumberValue.createCSSNumberValue((short)2, 0.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            } else if (f > 100.0f) {
                object2 = NumberValue.createCSSNumberValue((short)2, 100.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            }
        } else if (object.getUnitType() == 0) {
            object2 = (TypedValue)object;
            float f = ((TypedValue)object2).getFloatValue((short)0);
            if (f < 0.0f) {
                object2 = NumberValue.createCSSNumberValue((short)0, 0.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            } else if (f > 100.0f) {
                object2 = NumberValue.createCSSNumberValue((short)0, 100.0f);
                ((PrimitiveValue)object2).setSubproperty(true);
                object = object2;
            }
        } else if (!(object.getCssValueType() == CSSValue.CssType.PROXY || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)object).getStringValue()))) {
            throw new DOMException(17, "Invalid color component: " + ((StyleValue)object).getCssText());
        }
        return object;
    }

    static PrimitiveValue enforceHueComponent(PrimitiveValue primitiveValue) {
        if (primitiveValue == null) {
            throw new NullPointerException();
        }
        if (primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            Evaluator evaluator = new Evaluator(80);
            try {
                primitiveValue = evaluator.evaluateExpression((ExpressionValue)primitiveValue);
            }
            catch (DOMException dOMException) {}
        } else if (primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            Evaluator evaluator = new Evaluator(80);
            try {
                primitiveValue = evaluator.evaluateFunction((CSSMathFunctionValue)((Object)primitiveValue));
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (!(primitiveValue.getUnitType() == 0 || CSSUnit.isAngleUnitType(primitiveValue.getUnitType()) || primitiveValue.getCssValueType() == CSSValue.CssType.PROXY || primitiveValue.getPrimitiveType() == CSSValue.Type.EXPRESSION || primitiveValue.getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || primitiveValue.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)primitiveValue).getStringValue()))) {
            throw new DOMException(17, "Type not compatible with hue.");
        }
        return primitiveValue;
    }

    static PrimitiveValue normalizePcntToNumber(PrimitiveValue object, float f, int n, boolean bl) {
        Object object2;
        if (object == null) {
            throw new NullPointerException();
        }
        if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateExpression((ExpressionValue)object);
            }
            catch (DOMException dOMException) {}
        } else if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION) {
            object2 = new PercentageEvaluator();
            try {
                object = ((Evaluator)object2).evaluateFunction((CSSMathFunctionValue)object);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (object.getUnitType() == 2) {
            object2 = (NumberValue)object;
            boolean bl2 = ((NumberValue)object2).isSpecified() && bl;
            float f2 = ((NumberValue)object2).getFloatValue((short)2) * f;
            object2 = new PercentageValue();
            ((NumberValue)object2).setFloatValue((short)0, f2);
            ((PrimitiveValue)object2).setSubproperty(true);
            ((NumberValue)object2).setSpecified(bl2);
            ((NumberValue)object2).setMaxFractionDigits(n);
            object = object2;
        } else if (!(object.getUnitType() == 0 || object.getCssValueType() == CSSValue.CssType.PROXY || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.EXPRESSION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.MATH_FUNCTION || ((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((TypedValue)object).getStringValue()))) {
            throw new DOMException(17, "Type not compatible: " + ((StyleValue)object).getCssText());
        }
        return object;
    }

    abstract boolean hasConvertibleComponents();

    static boolean isConvertibleComponent(CSSPrimitiveValue cSSPrimitiveValue) {
        return cSSPrimitiveValue != null && (cSSPrimitiveValue.getPrimitiveType() == CSSValue.Type.NUMERIC || cSSPrimitiveValue.getPrimitiveType() == CSSValue.Type.IDENT && "none".equalsIgnoreCase(((CSSTypedValue)cSSPrimitiveValue).getStringValue()));
    }

    public String toString() {
        int n = this.getLength();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("color(").append(this.getColorSpace());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ');
            this.appendComponentCssText(stringBuilder, this.item(i));
        }
        if (this.isNonOpaque()) {
            stringBuilder.append(" / ");
            this.appendAlphaChannel(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    StringBuilder appendComponentCssText(StringBuilder stringBuilder, PrimitiveValue primitiveValue) {
        return stringBuilder.append(primitiveValue.getCssText());
    }

    @Override
    public String toMinifiedString() {
        int n = this.getLength();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("color(").append(this.getColorSpace());
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(' ');
            this.appendComponentMinifiedCssText(stringBuilder, this.item(i));
        }
        if (this.isNonOpaque()) {
            stringBuilder.append('/');
            this.appendAlphaChannelMinified(stringBuilder);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    StringBuilder appendComponentMinifiedCssText(StringBuilder stringBuilder, PrimitiveValue primitiveValue) {
        return stringBuilder.append(primitiveValue.getMinifiedCssText(""));
    }

    boolean isNonOpaque() {
        return this.alpha.getPrimitiveType() != CSSValue.Type.NUMERIC || ((CSSTypedValue)((Object)this.alpha)).getFloatValue((short)0) != 1.0f;
    }

    void appendAlphaChannel(SimpleWriter simpleWriter) throws IOException {
        if (this.alpha.getUnitType() == 0) {
            String string = this.formattedNumber((TypedValue)this.alpha);
            simpleWriter.write((CharSequence)string);
        } else {
            this.alpha.writeCssText(simpleWriter);
        }
    }

    StringBuilder appendAlphaChannel(StringBuilder stringBuilder) {
        String string = this.alpha.getUnitType() == 0 && !((NumberValue)this.alpha).isSpecified() ? this.formattedNumber((TypedValue)this.alpha) : this.alpha.getCssText();
        return stringBuilder.append(string);
    }

    StringBuilder appendAlphaChannelMinified(StringBuilder stringBuilder) {
        String string = this.alpha.getUnitType() == 0 && !((NumberValue)this.alpha).isSpecified() ? this.formattedNumberMinified((TypedValue)this.alpha) : this.alpha.getMinifiedCssText("");
        return stringBuilder.append(string);
    }

    private String formattedNumber(TypedValue typedValue) {
        float f = typedValue.getFloatValue((short)0);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat.format(f);
    }

    private String formattedNumberMinified(TypedValue typedValue) {
        float f = typedValue.getFloatValue((short)0);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
        numberFormat.setMaximumFractionDigits(4);
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMinimumIntegerDigits(0);
        return numberFormat.format(f);
    }

    void appendHue(StringBuilder stringBuilder, PrimitiveValue primitiveValue) {
        short s = primitiveValue.getUnitType();
        if (s == 80) {
            NumberValue numberValue = (NumberValue)primitiveValue;
            float f = numberValue.getFloatValue(s);
            NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, f);
            if (!numberValue.isSpecified()) {
                numberValue2.setAbsolutizedUnit();
            }
            String string = numberValue2.getCssText();
            stringBuilder.append(string);
        } else {
            stringBuilder.append(primitiveValue.getCssText());
        }
    }

    void writeHue(SimpleWriter simpleWriter, PrimitiveValue primitiveValue) throws IOException {
        short s = primitiveValue.getUnitType();
        if (s == 80) {
            NumberValue numberValue = (NumberValue)primitiveValue;
            float f = numberValue.getFloatValue(s);
            NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, f);
            if (!numberValue.isSpecified()) {
                numberValue2.setAbsolutizedUnit();
            }
            numberValue2.writeCssText(simpleWriter);
        } else {
            primitiveValue.writeCssText(simpleWriter);
        }
    }

    void appendMinifiedHue(StringBuilder stringBuilder, PrimitiveValue primitiveValue) {
        short s = primitiveValue.getUnitType();
        if (s == 80) {
            NumberValue numberValue = (NumberValue)primitiveValue;
            float f = numberValue.getFloatValue(s);
            NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, f);
            if (!numberValue.isSpecified()) {
                numberValue2.setAbsolutizedUnit();
            }
            String string = numberValue2.getMinifiedCssText("");
            stringBuilder.append(string);
        } else {
            stringBuilder.append(primitiveValue.getMinifiedCssText(""));
        }
    }

    void set(BaseColor baseColor) {
        this.alpha = baseColor.alpha;
    }

    static void setLabColor(double[] dArray, PrimitiveValue primitiveValue, LABColorImpl lABColorImpl) {
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)2, (float)dArray[0]);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)dArray[1]);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)0, (float)dArray[2]);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        numberValue3.setAbsolutizedUnit();
        lABColorImpl.setLightness(numberValue);
        lABColorImpl.setA(numberValue2);
        lABColorImpl.setB(numberValue3);
        lABColorImpl.setAlpha(primitiveValue.clone());
    }

    public int hashCode() {
        int n = 31;
        int n2 = Objects.hash(this.getColorSpace().toLowerCase(Locale.ROOT));
        n2 = 31 * n2 + Objects.hash(new Object[]{this.getColorModel()});
        n2 = 31 * n2 + Objects.hash(this.alpha);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(this instanceof BaseColor)) {
            return false;
        }
        BaseColor baseColor = (BaseColor)object;
        return Objects.equals(this.alpha, baseColor.alpha) && this.getColorSpace().equals(baseColor.getColorSpace()) && Objects.equals((Object)this.getColorModel(), (Object)baseColor.getColorModel());
    }

    @Override
    public abstract CSSColorValue.ColorModel getColorModel();

    @Override
    public abstract PrimitiveValue item(int var1);

    @Override
    public int getLength() {
        return 4;
    }

    abstract void setComponent(int var1, PrimitiveValue var2);

    abstract void setColorComponents(double[] var1);

    @Override
    public abstract double[] toNumberArray() throws DOMException;

    double[] toXYZ(ColorProfile.Illuminant illuminant) {
        double[] dArray = this.toSRGB(true);
        double[] dArray2 = ColorUtil.srgbToXYZd65(dArray[0], dArray[1], dArray[2]);
        if (illuminant == ColorProfile.Illuminant.D50) {
            dArray2 = ColorUtil.d65xyzToD50(dArray2);
        }
        return dArray2;
    }

    void toLABColor(LABColorImpl lABColorImpl) throws DOMException {
        double[] dArray = this.toXYZ(ColorProfile.Illuminant.D50);
        double[] dArray2 = new double[3];
        ColorUtil.xyzD50ToLab(dArray, dArray2);
        BaseColor.setLabColor(dArray2, this.getAlpha(), lABColorImpl);
    }

    @Override
    public BaseColor toColorSpace(String string) throws DOMException {
        ColorConverter colorConverter = new ColorConverter(true);
        colorConverter.toColorSpace(this, string, true);
        return colorConverter.getLastColor();
    }

    abstract double[] toSRGB(boolean var1);

    @Override
    public abstract ColorValue packInValue();

    @Override
    public abstract BaseColor clone();

    static enum Space {
        sRGB,
        p3,
        A98_RGB,
        ProPhoto_RGB,
        Rec2020,
        CIE_XYZ,
        CIE_XYZ_D50,
        CIE_Lab,
        CIE_LCh,
        OK_Lab,
        OK_LCh,
        OTHER;

    }
}

