/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSAttrValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSLexicalProcessingException;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class AttrValue
extends ProxyValue
implements CSSAttrValue {
    private static final long serialVersionUID = 1L;
    private String attrname = null;
    private String typeval = null;
    private StyleValue fallback = null;
    private final byte flags;

    public AttrValue(byte by) {
        super(CSSValue.Type.ATTR);
        this.flags = by;
    }

    protected AttrValue(AttrValue attrValue) {
        super(attrValue);
        this.attrname = attrValue.attrname;
        this.typeval = attrValue.typeval;
        this.fallback = attrValue.fallback;
        this.flags = attrValue.flags;
    }

    @Override
    public String getAttributeName() {
        return this.attrname;
    }

    @Override
    public String getAttributeType() {
        return this.typeval;
    }

    @Override
    public void setExpectInteger() {
        super.setExpectInteger();
        if (this.fallback != null && this.fallback.isPrimitiveValue()) {
            ((PrimitiveValue)this.fallback).setExpectInteger();
        }
    }

    @Override
    public StyleValue getFallback() {
        return this.fallback;
    }

    public void setFallback(StyleValue styleValue) {
        if (styleValue != null && (TypedValue.isOrContainsType(styleValue, CSSValue.Type.ATTR) || styleValue.getCssValueType() == CSSValue.CssType.KEYWORD)) {
            throw new DOMException(17, "Invalid fallback: " + styleValue.toString());
        }
        this.fallback = styleValue;
    }

    public static TypedValue defaultFallback(String string) {
        TypedValue typedValue = null;
        if (string == null || "string".equalsIgnoreCase(string)) {
            typedValue = new StringValue();
            ((TypedValue)typedValue).setStringValue(CSSValue.Type.STRING, "");
        } else if ("color".equalsIgnoreCase(string)) {
            typedValue = new IdentifierValue("currentColor");
        } else if ("integer".equalsIgnoreCase(string) || "number".equalsIgnoreCase(string) || "length".equalsIgnoreCase(string)) {
            typedValue = NumberValue.createCSSNumberValue((short)0, 0.0f);
        } else if ("angle".equalsIgnoreCase(string)) {
            typedValue = NumberValue.createCSSNumberValue((short)80, 0.0f);
        } else if ("time".equalsIgnoreCase(string)) {
            typedValue = NumberValue.createCSSNumberValue((short)90, 0.0f);
        } else if ("frequency".equalsIgnoreCase(string)) {
            typedValue = NumberValue.createCSSNumberValue((short)100, 0.0f);
        } else if ("percentage".equalsIgnoreCase(string)) {
            typedValue = NumberValue.createCSSNumberValue((short)2, 0.0f);
        } else {
            String string2 = string.toLowerCase(Locale.ROOT).intern();
            short s = ParseHelper.unitFromString(string2);
            if (s != 1) {
                if (CSSUnit.isLengthUnitType(s)) {
                    typedValue = NumberValue.createCSSNumberValue((short)0, 0.0f);
                } else if (CSSUnit.isAngleUnitType(s)) {
                    typedValue = NumberValue.createCSSNumberValue((short)80, 0.0f);
                } else if (s == 90 || s == 91) {
                    typedValue = NumberValue.createCSSNumberValue((short)90, 0.0f);
                } else if (s == 100 || s == 101) {
                    typedValue = NumberValue.createCSSNumberValue((short)100, 0.0f);
                }
            }
        }
        return typedValue;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        String string = this.typeval != null ? this.typeval.toLowerCase(Locale.ROOT) : "string";
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        CSSValueSyntax cSSValueSyntax2 = cSSValueSyntax;
        block0: do {
            boolean bl;
            if (bl = ParseHelper.matchAttrType(string, cSSValueSyntax2.getCategory())) {
                match = CSSValueSyntax.Match.PENDING;
            }
            if (this.fallback != null) {
                CSSValueSyntax cSSValueSyntax3 = cSSValueSyntax;
                do {
                    CSSValueSyntax.Match match2;
                    if ((match2 = this.fallback.matches(cSSValueSyntax3)) == CSSValueSyntax.Match.FALSE) continue;
                    if (match2 == CSSValueSyntax.Match.PENDING) {
                        match = CSSValueSyntax.Match.PENDING;
                        if (bl) {
                            continue;
                        }
                    } else {
                        if (!bl) {
                            match = CSSValueSyntax.Match.PENDING;
                            continue block0;
                        }
                        match = CSSValueSyntax.Match.TRUE;
                    }
                    return match;
                } while ((cSSValueSyntax3 = cSSValueSyntax3.getNext()) != null);
                continue;
            }
            if (!bl) continue;
            return CSSValueSyntax.Match.TRUE;
        } while ((cSSValueSyntax2 = cSSValueSyntax2.getNext()) != null);
        return match;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        String string = this.typeval != null ? this.typeval.toLowerCase(Locale.ROOT) : "string";
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        boolean bl = ParseHelper.matchAttrType(string, cSSValueSyntax.getCategory());
        if (bl) {
            match = CSSValueSyntax.Match.PENDING;
        }
        if (this.fallback != null) {
            CSSValueSyntax.Match match2 = this.fallback.matchesComponent(cSSValueSyntax);
            if (match2 == CSSValueSyntax.Match.TRUE) {
                match = !bl ? CSSValueSyntax.Match.PENDING : CSSValueSyntax.Match.TRUE;
            } else if (match2 == CSSValueSyntax.Match.PENDING) {
                match = CSSValueSyntax.Match.PENDING;
            }
        } else if (bl) {
            match = CSSValueSyntax.Match.TRUE;
        }
        return match;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private static void wrongSyntax(LexicalUnit lexicalUnit) {
        throw new DOMException(12, "Wrong attr() syntax: " + lexicalUnit.toString());
    }

    @Override
    public String getCssText() {
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(32);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)"attr(");
        simpleWriter.write((CharSequence)this.attrname);
        if (this.typeval != null) {
            simpleWriter.write(' ');
            simpleWriter.write((CharSequence)this.typeval);
        }
        if (this.fallback != null) {
            simpleWriter.write((CharSequence)", ");
            this.fallback.writeCssText(simpleWriter);
        }
        simpleWriter.write(')');
    }

    @Override
    public String getMinifiedCssText(String string) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("attr(");
        stringBuilder.append(this.attrname);
        if (this.typeval != null) {
            stringBuilder.append(' ');
            stringBuilder.append(this.typeval);
        }
        if (this.fallback != null) {
            stringBuilder.append(',');
            stringBuilder.append(this.fallback.getMinifiedCssText(string));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        LexicalUnit lexicalUnit;
        this.checkModifiableProperty();
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue(new StringReader(string));
        }
        catch (CSSParseException cSSParseException) {
            throw new DOMException(12, "Not an attr value.");
        }
        catch (IOException iOException) {
            return;
        }
        this.newLexicalSetter().setLexicalUnit(lexicalUnit);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.attrname == null ? 0 : this.attrname.hashCode());
        n2 = 31 * n2 + (this.fallback == null ? 0 : this.fallback.hashCode());
        n2 = 31 * n2 + (this.typeval == null ? 0 : this.typeval.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AttrValue attrValue = (AttrValue)object;
        if (this.attrname == null ? attrValue.attrname != null : !this.attrname.equals(attrValue.attrname)) {
            return false;
        }
        if (this.fallback == null ? attrValue.fallback != null : !this.fallback.equals(attrValue.fallback)) {
            return false;
        }
        if (this.typeval == null) {
            return attrValue.typeval == null;
        }
        return this.typeval.equals(attrValue.typeval);
    }

    @Override
    public AttrValue clone() {
        return new AttrValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(AttrValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            String string = null;
            StyleValue styleValue = null;
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
            if (lexicalType != LexicalUnit.LexicalType.IDENT) {
                if (lexicalType == LexicalUnit.LexicalType.VAR) {
                    throw new CSSLexicalProcessingException("var() inside attr() found.");
                }
                throw new DOMException(17, "Invalid attr() name.");
            }
            String string2 = lexicalUnit2.getStringValue();
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 != null) {
                lexicalType = lexicalUnit2.getLexicalUnitType();
                if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if (lexicalType == LexicalUnit.LexicalType.VAR) {
                        throw new CSSLexicalProcessingException("var() inside attr() found.");
                    }
                    if (lexicalType == LexicalUnit.LexicalType.ATTR) {
                        throw new DOMException(17, "Invalid attr() nested in attr().");
                    }
                    if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                        string = lexicalUnit2.getStringValue();
                    } else if (lexicalType == LexicalUnit.LexicalType.OPERATOR_MOD) {
                        string = "%";
                    } else {
                        throw new DOMException(17, "Invalid attr() name.");
                    }
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 == null) {
                        AttrValue.this.attrname = string2;
                        AttrValue.this.typeval = string;
                        AttrValue.this.fallback = null;
                        this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
                        return;
                    }
                    lexicalType = lexicalUnit2.getLexicalUnitType();
                    if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        AttrValue.wrongSyntax(lexicalUnit);
                    }
                }
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                    AttrValue.wrongSyntax(lexicalUnit);
                }
                lexicalType = lexicalUnit2.getLexicalUnitType();
                ValueFactory valueFactory = new ValueFactory(AttrValue.this.flags);
                try {
                    styleValue = valueFactory.createCSSValue(lexicalUnit2.clone(), null, false);
                }
                catch (RuntimeException runtimeException) {
                    DOMException dOMException = new DOMException(17, "Invalid fallback: " + styleValue.toString());
                    dOMException.initCause(runtimeException);
                    throw dOMException;
                }
            }
            AttrValue.this.setFallback(styleValue);
            AttrValue.this.attrname = string2;
            AttrValue.this.typeval = string;
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

