/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import java.io.Serializable;
import java.util.Locale;

class LexicalUnitImpl
implements LexicalUnit,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LEXICAL_REPLACE_LIMIT = 262144;
    private LexicalUnit.LexicalType unitType;
    private short cssUnit = (short)255;
    int intValue = 0;
    float floatValue = Float.NaN;
    String dimensionUnitText = "";
    String value = null;
    String identCssText = null;
    LexicalUnitImpl previousLexicalUnit = null;
    LexicalUnitImpl nextLexicalUnit = null;
    LexicalUnitImpl parameters = null;
    LexicalUnitImpl ownerLexicalUnit = null;

    public LexicalUnitImpl(LexicalUnit.LexicalType lexicalType) {
        this.unitType = lexicalType;
    }

    @Override
    public LexicalUnit.LexicalType getLexicalUnitType() {
        return this.unitType;
    }

    void setUnitType(LexicalUnit.LexicalType lexicalType) {
        this.unitType = lexicalType;
    }

    @Override
    public short getCssUnit() {
        return this.cssUnit;
    }

    void setCssUnit(short s) {
        this.cssUnit = s;
    }

    @Override
    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    @Override
    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    @Override
    public void insertNextLexicalUnit(LexicalUnit lexicalUnit) throws CSSException {
        LexicalUnitImpl lexicalUnitImpl;
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            return;
        }
        LexicalUnitImpl lexicalUnitImpl2 = (LexicalUnitImpl)lexicalUnit;
        if (lexicalUnitImpl2.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Argument is a parameter of another unit.");
        }
        if (lexicalUnitImpl2.getPreviousLexicalUnit() != null) {
            throw new IllegalArgumentException("Argument unit has a previous unit.");
        }
        lexicalUnitImpl2.previousLexicalUnit = this;
        lexicalUnitImpl2.ownerLexicalUnit = this.ownerLexicalUnit;
        LexicalUnitImpl lexicalUnitImpl3 = lexicalUnitImpl2;
        do {
            lexicalUnitImpl = lexicalUnitImpl3;
        } while ((lexicalUnitImpl3 = lexicalUnitImpl3.nextLexicalUnit) != null);
        lexicalUnitImpl.nextLexicalUnit = this.nextLexicalUnit;
        if (this.nextLexicalUnit != null) {
            this.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl;
        }
        this.nextLexicalUnit = lexicalUnitImpl2;
    }

    @Override
    public LexicalUnit replaceBy(LexicalUnit lexicalUnit) throws CSSBudgetException {
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            return this.remove();
        }
        LexicalUnitImpl lexicalUnitImpl = (LexicalUnitImpl)lexicalUnit;
        if (lexicalUnitImpl.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Replacement unit is a parameter.");
        }
        if (this.ownerLexicalUnit != null) {
            if (lexicalUnitImpl.previousLexicalUnit != null) {
                throw new IllegalArgumentException("Replacement unit has a previous unit.");
            }
            LexicalUnitImpl lexicalUnitImpl2 = lexicalUnitImpl;
            do {
                lexicalUnitImpl2.ownerLexicalUnit = this.ownerLexicalUnit;
            } while ((lexicalUnitImpl2 = lexicalUnitImpl2.nextLexicalUnit) != null);
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = lexicalUnitImpl;
            }
            this.ownerLexicalUnit = null;
        }
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = lexicalUnitImpl;
            lexicalUnitImpl.previousLexicalUnit = this.previousLexicalUnit;
        }
        if (this.nextLexicalUnit != null) {
            LexicalUnitImpl lexicalUnitImpl3;
            int n = 0;
            LexicalUnitImpl lexicalUnitImpl4 = lexicalUnitImpl;
            do {
                lexicalUnitImpl3 = lexicalUnitImpl4;
                lexicalUnitImpl4 = lexicalUnitImpl4.nextLexicalUnit;
                if (++n < 262144) continue;
                throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
            } while (lexicalUnitImpl4 != null);
            this.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl3;
            lexicalUnitImpl3.nextLexicalUnit = this.nextLexicalUnit;
            this.nextLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return lexicalUnit;
    }

    @Override
    public int countReplaceBy(LexicalUnit lexicalUnit) throws CSSBudgetException {
        LexicalUnitImpl lexicalUnitImpl;
        if (lexicalUnit == null) {
            this.remove();
            return 0;
        }
        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            this.remove();
            return 1;
        }
        int n = 0;
        LexicalUnitImpl lexicalUnitImpl2 = (LexicalUnitImpl)lexicalUnit;
        if (lexicalUnitImpl2.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Replacement unit is a parameter.");
        }
        if (this.ownerLexicalUnit != null) {
            if (lexicalUnitImpl2.previousLexicalUnit != null) {
                throw new IllegalArgumentException("Replacement unit has a previous unit.");
            }
            lexicalUnitImpl = lexicalUnitImpl2;
            do {
                lexicalUnitImpl.ownerLexicalUnit = this.ownerLexicalUnit;
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = lexicalUnitImpl2;
            }
            this.ownerLexicalUnit = null;
        }
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = lexicalUnitImpl2;
            lexicalUnitImpl2.previousLexicalUnit = this.previousLexicalUnit;
        }
        if (this.nextLexicalUnit != null) {
            LexicalUnitImpl lexicalUnitImpl3;
            lexicalUnitImpl = lexicalUnitImpl2;
            do {
                lexicalUnitImpl3 = lexicalUnitImpl;
                lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                if (++n < 262144) continue;
                throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
            } while (lexicalUnitImpl != null);
            this.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl3;
            lexicalUnitImpl3.nextLexicalUnit = this.nextLexicalUnit;
            this.nextLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return n;
    }

    @Override
    public LexicalUnit remove() {
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = this.nextLexicalUnit;
        }
        LexicalUnitImpl lexicalUnitImpl = this.nextLexicalUnit;
        if (this.nextLexicalUnit != null) {
            this.nextLexicalUnit.previousLexicalUnit = this.previousLexicalUnit;
            this.nextLexicalUnit = null;
        }
        if (this.ownerLexicalUnit != null) {
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = lexicalUnitImpl;
            }
            this.ownerLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return lexicalUnitImpl;
    }

    @Override
    public int getIntegerValue() {
        return this.intValue;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    public String getFunctionName() {
        return this.value;
    }

    @Override
    public LexicalUnit getParameters() {
        if (this.unitType != LexicalUnit.LexicalType.SUB_EXPRESSION) {
            return this.parameters;
        }
        return null;
    }

    @Override
    public boolean isParameter() {
        return this.ownerLexicalUnit != null;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public LexicalUnit getSubValues() {
        if (this.unitType == LexicalUnit.LexicalType.SUB_EXPRESSION || this.unitType == LexicalUnit.LexicalType.UNICODE_RANGE) {
            return this.parameters;
        }
        return null;
    }

    void addFunctionParameter(LexicalUnitImpl lexicalUnitImpl) {
        lexicalUnitImpl.ownerLexicalUnit = this;
        if (this.parameters == null) {
            this.parameters = lexicalUnitImpl;
        } else {
            LexicalUnit lexicalUnit = this.parameters;
            while (lexicalUnit.getNextLexicalUnit() != null) {
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            LexicalUnitImpl lexicalUnitImpl2 = lexicalUnit;
            lexicalUnitImpl2.nextLexicalUnit = lexicalUnitImpl;
            lexicalUnitImpl.previousLexicalUnit = lexicalUnitImpl2;
        }
    }

    void reset() {
        this.intValue = 0;
        this.floatValue = 0.0f;
        this.dimensionUnitText = "";
        this.parameters = null;
        this.nextLexicalUnit = null;
    }

    @Override
    public String getCssText() {
        return this.currentToString().toString();
    }

    public String toString() {
        if (this.nextLexicalUnit == null) {
            return this.currentToString().toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        LexicalUnitImpl lexicalUnitImpl = this;
        boolean bl = false;
        while (lexicalUnitImpl != null) {
            switch (lexicalUnitImpl.getLexicalUnitType()) {
                case OPERATOR_EXP: 
                case OPERATOR_GE: 
                case OPERATOR_GT: 
                case OPERATOR_LE: 
                case OPERATOR_LT: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_SLASH: 
                case OPERATOR_TILDE: 
                case LEFT_BRACKET: 
                case EMPTY: {
                    bl = false;
                }
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    break;
                }
                case RIGHT_BRACKET: {
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        stringBuilder.append(' ');
                        break;
                    }
                    bl = true;
                }
            }
            stringBuilder.append(lexicalUnitImpl.currentToString());
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
        }
        return stringBuilder.toString();
    }

    CharSequence currentToString() {
        switch (this.unitType) {
            case INTEGER: {
                return Integer.toString(this.intValue);
            }
            case PERCENTAGE: 
            case REAL: 
            case DIMENSION: {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.floatValue % 1.0f != 0.0f) {
                    stringBuilder.append(String.format(Locale.ROOT, "%s", Float.valueOf(this.floatValue)));
                } else {
                    stringBuilder.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(this.floatValue)));
                }
                if (this.dimensionUnitText != null) {
                    stringBuilder.append(this.dimensionUnitText);
                }
                return stringBuilder;
            }
            case RGBCOLOR: {
                if (this.identCssText != null) {
                    return this.identCssText;
                }
            }
            case FUNCTION: {
                return this.functionalSerialization(this.value);
            }
            case CALC: 
            case RECT_FUNCTION: 
            case VAR: 
            case ATTR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: 
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: 
            case CUBIC_BEZIER_FUNCTION: 
            case STEPS_FUNCTION: {
                return this.functionalSerialization(this.value.toLowerCase(Locale.ROOT));
            }
            case SUB_EXPRESSION: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                LexicalUnitImpl lexicalUnitImpl = this.parameters;
                if (lexicalUnitImpl != null) {
                    stringBuilder.append(((Object)lexicalUnitImpl).toString());
                }
                stringBuilder.append(')');
                return stringBuilder;
            }
            case IDENT: {
                return this.identCssText != null ? this.identCssText : this.value;
            }
            case STRING: {
                return this.identCssText;
            }
            case URI: {
                String string = this.identCssText != null ? this.identCssText : (this.value != null ? ParseHelper.quote(this.value, '\'') : (this.parameters != null ? this.parameters.getCssText() : ""));
                return "url(" + string + ")";
            }
            case INHERIT: {
                return "inherit";
            }
            case INITIAL: {
                return "initial";
            }
            case UNSET: {
                return "unset";
            }
            case REVERT: {
                return "revert";
            }
            case ELEMENT_REFERENCE: {
                if (this.value == null) {
                    if (this.parameters == null) {
                        return "element(#)";
                    }
                    return this.functionalSerialization("element");
                }
                int n = this.value.length();
                StringBuilder stringBuilder = new StringBuilder(n + 10);
                stringBuilder.append("element(#").append(this.value).append(')');
                return stringBuilder;
            }
            case UNICODE_RANGE: {
                StringBuilder stringBuilder = new StringBuilder();
                LexicalUnit lexicalUnit = this.parameters;
                if (lexicalUnit != null) {
                    if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                        stringBuilder.append("U+").append(Integer.toHexString(lexicalUnit.getIntegerValue()));
                    } else {
                        stringBuilder.append("U+").append(lexicalUnit.getStringValue());
                    }
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit != null) {
                        stringBuilder.append('-');
                        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                            stringBuilder.append(Integer.toHexString(lexicalUnit.getIntegerValue()));
                        } else {
                            stringBuilder.append(lexicalUnit.getStringValue());
                        }
                    }
                }
                return stringBuilder;
            }
            case UNICODE_WILDCARD: {
                return this.getStringValue();
            }
            case OPERATOR_COMMA: {
                return ",";
            }
            case OPERATOR_SEMICOLON: {
                return ";";
            }
            case OPERATOR_EXP: {
                return "^";
            }
            case OPERATOR_GE: {
                return ">=";
            }
            case OPERATOR_GT: {
                return ">";
            }
            case OPERATOR_LE: {
                return "<=";
            }
            case OPERATOR_LT: {
                return "<";
            }
            case OPERATOR_MINUS: {
                return "-";
            }
            case OPERATOR_MOD: {
                return "%";
            }
            case OPERATOR_MULTIPLY: {
                return "*";
            }
            case OPERATOR_PLUS: {
                return "+";
            }
            case OPERATOR_SLASH: {
                return "/";
            }
            case OPERATOR_TILDE: {
                return "~";
            }
            case LEFT_BRACKET: {
                return "[";
            }
            case RIGHT_BRACKET: {
                return "]";
            }
            case COMPAT_IDENT: 
            case COMPAT_PRIO: {
                return ParseHelper.escapeControl(this.value);
            }
        }
        return "";
    }

    private CharSequence functionalSerialization(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('(');
        LexicalUnitImpl lexicalUnitImpl = this.parameters;
        if (lexicalUnitImpl != null) {
            stringBuilder.append(((Object)lexicalUnitImpl).toString());
        }
        stringBuilder.append(')');
        return stringBuilder;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax != null) {
            switch (this.getLexicalUnitType()) {
                case INHERIT: 
                case INITIAL: 
                case UNSET: 
                case REVERT: {
                    return this.nextLexicalUnit == null ? CSSValueSyntax.Match.PENDING : CSSValueSyntax.Match.FALSE;
                }
            }
            CSSValueSyntax cSSValueSyntax2 = cSSValueSyntax;
            do {
                CSSValueSyntax.Match match;
                CSSValueSyntax.Multiplier multiplier = cSSValueSyntax2.getMultiplier();
                CSSValueSyntax.Category category = cSSValueSyntax2.getCategory();
                if (category == CSSValueSyntax.Category.universal) {
                    return CSSValueSyntax.Match.TRUE;
                }
                if (multiplier == CSSValueSyntax.Multiplier.NONE && this.nextLexicalUnit != null && category != CSSValueSyntax.Category.transformList || (match = this.matchesComponent(cSSValueSyntax, cSSValueSyntax2)) == CSSValueSyntax.Match.FALSE) continue;
                return match;
            } while ((cSSValueSyntax2 = cSSValueSyntax2.getNext()) != null);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        CSSValueSyntax.Match match;
        block4: {
            LexicalUnitImpl lexicalUnitImpl = this;
            match = CSSValueSyntax.Match.FALSE;
            while (true) {
                CSSValueSyntax.Match match2;
                if ((match2 = LexicalUnitImpl.matchesComponent(lexicalUnitImpl, cSSValueSyntax, cSSValueSyntax2)) == CSSValueSyntax.Match.FALSE) {
                    return CSSValueSyntax.Match.FALSE;
                }
                if (match != CSSValueSyntax.Match.PENDING) {
                    match = match2;
                }
                if ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) == null) break block4;
                if (cSSValueSyntax2.getMultiplier() != CSSValueSyntax.Multiplier.NUMBER) continue;
                if (lexicalUnitImpl.unitType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                    if (lexicalUnitImpl != null) continue;
                    break block4;
                }
                if (cSSValueSyntax2.getCategory() != CSSValueSyntax.Category.transformList && lexicalUnitImpl.unitType != LexicalUnit.LexicalType.VAR && lexicalUnitImpl.previousLexicalUnit.unitType != LexicalUnit.LexicalType.VAR) break;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        return match;
    }

    private static CSSValueSyntax.Match matchesComponent(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
        switch (lexicalType) {
            case OPERATOR_COMMA: {
                if (cSSValueSyntax2.getMultiplier() != CSSValueSyntax.Multiplier.NUMBER || lexicalUnitImpl.nextLexicalUnit == null) {
                    return CSSValueSyntax.Match.FALSE;
                }
                return CSSValueSyntax.Match.TRUE;
            }
            case OPERATOR_EXP: 
            case OPERATOR_GE: 
            case OPERATOR_GT: 
            case OPERATOR_LE: 
            case OPERATOR_LT: 
            case OPERATOR_MULTIPLY: 
            case OPERATOR_SLASH: 
            case OPERATOR_TILDE: 
            case OPERATOR_SEMICOLON: 
            case INHERIT: 
            case INITIAL: 
            case UNSET: 
            case REVERT: 
            case OPERATOR_MINUS: 
            case OPERATOR_MOD: 
            case OPERATOR_PLUS: {
                return CSSValueSyntax.Match.FALSE;
            }
        }
        CSSValueSyntax.Category category = cSSValueSyntax2.getCategory();
        if (category == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        switch (lexicalType) {
            case IDENT: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.customIdent || category == CSSValueSyntax.Category.IDENT && cSSValueSyntax2.getName().equals(lexicalUnitImpl.getStringValue()) || category == CSSValueSyntax.Category.color && ColorIdentifiers.getInstance().isColorIdentifier(lexicalUnitImpl.getStringValue().toLowerCase(Locale.ROOT)));
            }
            case STRING: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.string);
            }
            case ATTR: {
                return LexicalUnitImpl.matchAttr(lexicalUnitImpl, cSSValueSyntax, cSSValueSyntax2);
            }
            case URI: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.url || category == CSSValueSyntax.Category.image);
            }
            case DIMENSION: {
                return LexicalUnitImpl.matchBoolean(ParseHelper.matchesDimension(lexicalUnitImpl.getCssUnit(), category));
            }
            case PERCENTAGE: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.percentage || category == CSSValueSyntax.Category.lengthPercentage);
            }
            case REAL: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.number);
            }
            case INTEGER: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.integer || category == CSSValueSyntax.Category.number);
            }
            case RGBCOLOR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.color);
            }
            case CALC: {
                return LexicalUnitImpl.isNumericCategory(category) ? LexicalUnitImpl.matchesOperandOfSyntax(lexicalUnitImpl.getParameters(), cSSValueSyntax2) : CSSValueSyntax.Match.FALSE;
            }
            case FUNCTION: {
                return LexicalUnitImpl.matchFunction(lexicalUnitImpl, cSSValueSyntax2);
            }
            case ELEMENT_REFERENCE: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.image);
            }
            case VAR: {
                return CSSValueSyntax.Match.PENDING;
            }
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.counter);
            }
            case UNICODE_RANGE: 
            case UNICODE_WILDCARD: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.unicodeRange);
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private static CSSValueSyntax.Match matchBoolean(boolean bl) {
        return bl ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    private static CSSValueSyntax.Match matchAttr(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        CSSValueSyntax.Match match;
        block19: {
            String string;
            LexicalUnit lexicalUnit;
            block21: {
                block20: {
                    match = CSSValueSyntax.Match.FALSE;
                    LexicalUnit lexicalUnit2 = lexicalUnitImpl.getParameters();
                    if (lexicalUnit2 == null) break block19;
                    lexicalUnit = null;
                    if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) break block20;
                    switch (lexicalUnit2.getLexicalUnitType()) {
                        case OPERATOR_COMMA: {
                            string = "string";
                            lexicalUnit = lexicalUnit2.getNextLexicalUnit();
                            break block21;
                        }
                        case IDENT: {
                            string = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT);
                            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                            if (lexicalUnit2 != null) {
                                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                                    return CSSValueSyntax.Match.FALSE;
                                }
                                lexicalUnit = lexicalUnit2.getNextLexicalUnit();
                            }
                            break block21;
                        }
                        case OPERATOR_MOD: {
                            string = "percentage";
                            lexicalUnit = lexicalUnit2.getNextLexicalUnit();
                            break block21;
                        }
                        case VAR: {
                            return CSSValueSyntax.Match.PENDING;
                        }
                        default: {
                            return CSSValueSyntax.Match.FALSE;
                        }
                    }
                }
                return cSSValueSyntax2.getCategory() == CSSValueSyntax.Category.string ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            CSSValueSyntax cSSValueSyntax3 = null;
            CSSValueSyntax cSSValueSyntax4 = cSSValueSyntax;
            block6: do {
                boolean bl;
                if (bl = ParseHelper.matchAttrType(string, cSSValueSyntax4.getCategory())) {
                    match = CSSValueSyntax.Match.PENDING;
                    cSSValueSyntax3 = cSSValueSyntax4;
                }
                if (lexicalUnit != null) {
                    CSSValueSyntax cSSValueSyntax5 = cSSValueSyntax;
                    do {
                        CSSValueSyntax.Match match2;
                        if ((match2 = lexicalUnit.matches(cSSValueSyntax5)) == CSSValueSyntax.Match.FALSE) {
                            if (!bl || !"url".equals(string) || lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.STRING || !LexicalUnitImpl.hasNoSiblings(lexicalUnitImpl) || lexicalUnit.getNextLexicalUnit() != null) continue;
                            match = CSSValueSyntax.Match.TRUE;
                        } else if (match2 == CSSValueSyntax.Match.PENDING) {
                            match = CSSValueSyntax.Match.PENDING;
                            if (bl) {
                                continue;
                            }
                        } else {
                            if (!bl) {
                                match = CSSValueSyntax.Match.PENDING;
                                continue block6;
                            }
                            if (LexicalUnitImpl.hasNoSiblings(lexicalUnitImpl) || cSSValueSyntax3 == cSSValueSyntax5) {
                                match = CSSValueSyntax.Match.TRUE;
                            }
                        }
                        return match;
                    } while ((cSSValueSyntax5 = cSSValueSyntax5.getNext()) != null);
                    continue;
                }
                if (!bl) continue;
                return CSSValueSyntax.Match.TRUE;
            } while ((cSSValueSyntax4 = cSSValueSyntax4.getNext()) != null);
        }
        return match;
    }

    private static boolean hasNoSiblings(LexicalUnit lexicalUnit) {
        return lexicalUnit.getNextLexicalUnit() == null && lexicalUnit.getPreviousLexicalUnit() == null;
    }

    private static CSSValueSyntax.Match matchFunction(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Category category = cSSValueSyntax.getCategory();
        String string = lexicalUnitImpl.getFunctionName().toLowerCase(Locale.ROOT);
        if (string.endsWith("-gradient") || string.equals("image") || string.equals("image-set") || string.equals("cross-fade")) {
            return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.image);
        }
        if (string.equals("env")) {
            return CSSValueSyntax.Match.PENDING;
        }
        if (LexicalUnitImpl.isNumericCategory(category)) {
            if (LexicalUnitImpl.isCompatibleNumberFunction(string, category)) {
                return CSSValueSyntax.Match.TRUE;
            }
            return LexicalUnitImpl.matchesOperandOfSyntax(lexicalUnitImpl.getParameters(), cSSValueSyntax);
        }
        return LexicalUnitImpl.matchBoolean(ParseHelper.isTransformFunction(string));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CSSValueSyntax.Match matchesOperandOfSyntax(LexicalUnit lexicalUnit, CSSValueSyntax cSSValueSyntax) {
        CSSValueSyntax.Category category = cSSValueSyntax.getCategory();
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        while (lexicalUnit != null) {
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.DIMENSION) {
                if (ParseHelper.matchesDimension(lexicalUnit.getCssUnit(), category)) {
                    if (match != CSSValueSyntax.Match.PENDING) {
                        match = CSSValueSyntax.Match.TRUE;
                    }
                } else {
                    if (category == CSSValueSyntax.Category.percentage) {
                        return CSSValueSyntax.Match.FALSE;
                    }
                    if (lexicalUnit.getNextLexicalUnit() == null) return CSSValueSyntax.Match.FALSE;
                    match = CSSValueSyntax.Match.PENDING;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.REAL) {
                if (category == CSSValueSyntax.Category.number && match != CSSValueSyntax.Match.PENDING) {
                    match = CSSValueSyntax.Match.TRUE;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.INTEGER) {
                if ((category == CSSValueSyntax.Category.integer || category == CSSValueSyntax.Category.number) && match != CSSValueSyntax.Match.PENDING) {
                    match = CSSValueSyntax.Match.TRUE;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.PERCENTAGE) {
                if (!ParseHelper.matchesDimension((short)2, category)) return CSSValueSyntax.Match.FALSE;
                if (match != CSSValueSyntax.Match.PENDING) {
                    match = CSSValueSyntax.Match.TRUE;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.CALC) {
                CSSValueSyntax.Match match2 = LexicalUnitImpl.matchesOperandOfSyntax(lexicalUnit.getParameters(), cSSValueSyntax);
                if (match2 == CSSValueSyntax.Match.FALSE) return CSSValueSyntax.Match.FALSE;
                if (match != CSSValueSyntax.Match.PENDING) {
                    match = match2;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.VAR) {
                if (match != CSSValueSyntax.Match.TRUE) {
                    match = CSSValueSyntax.Match.PENDING;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.SUB_EXPRESSION) {
                CSSValueSyntax.Match match3 = LexicalUnitImpl.matchesOperandOfSyntax(lexicalUnit.getSubValues(), cSSValueSyntax);
                if (match3 == CSSValueSyntax.Match.FALSE) return CSSValueSyntax.Match.FALSE;
                if (match != CSSValueSyntax.Match.PENDING) {
                    match = match3;
                }
            } else if (lexicalType == LexicalUnit.LexicalType.ATTR || lexicalType == LexicalUnit.LexicalType.FUNCTION) {
                void var5_10;
                CSSValueSyntax.Match match4;
                LexicalUnit lexicalUnit2 = lexicalUnit;
                if (lexicalUnit.getNextLexicalUnit() != null) {
                    LexicalUnit lexicalUnit3 = lexicalUnit.shallowClone();
                }
                if ((match4 = var5_10.matches(cSSValueSyntax)) == CSSValueSyntax.Match.FALSE) {
                    return CSSValueSyntax.Match.FALSE;
                }
                if (match != CSSValueSyntax.Match.PENDING) {
                    match = match4;
                }
            }
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        return match;
    }

    private static boolean isCompatibleNumberFunction(String string, CSSValueSyntax.Category category) {
        switch (category) {
            case number: {
                return "sin".equals(string) || "cos".equals(string) || "tan".equals(string) || "sign".equals(string);
            }
            case angle: {
                return "asin".equals(string) || "acos".equals(string) || "atan".equals(string) || "atan2".equals(string);
            }
        }
        return false;
    }

    private static boolean isNumericCategory(CSSValueSyntax.Category category) {
        switch (category) {
            case number: 
            case angle: 
            case integer: 
            case length: 
            case percentage: 
            case lengthPercentage: 
            case time: 
            case frequency: 
            case resolution: 
            case flex: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.unitType.hashCode();
        n2 = 31 * n2 + this.cssUnit;
        n2 = 31 * n2 + (this.dimensionUnitText == null ? 0 : this.dimensionUnitText.hashCode());
        n2 = 31 * n2 + Float.floatToIntBits(this.floatValue);
        n2 = 31 * n2 + (this.identCssText == null ? 0 : this.identCssText.hashCode());
        n2 = 31 * n2 + this.intValue;
        n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
        LexicalUnitImpl lexicalUnitImpl = this.parameters;
        while (lexicalUnitImpl != null) {
            n2 = 31 * n2 + lexicalUnitImpl.hashCode();
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LexicalUnitImpl lexicalUnitImpl = (LexicalUnitImpl)object;
        if (this.unitType != lexicalUnitImpl.unitType) {
            return false;
        }
        if (this.cssUnit != lexicalUnitImpl.cssUnit) {
            return false;
        }
        if (this.dimensionUnitText == null ? lexicalUnitImpl.dimensionUnitText != null : !this.dimensionUnitText.equals(lexicalUnitImpl.dimensionUnitText)) {
            return false;
        }
        if (Float.floatToIntBits(this.floatValue) != Float.floatToIntBits(lexicalUnitImpl.floatValue)) {
            return false;
        }
        if (this.value == null ? lexicalUnitImpl.value != null : !this.value.equals(lexicalUnitImpl.value)) {
            return false;
        }
        if (this.identCssText == null ? lexicalUnitImpl.identCssText != null : !this.identCssText.equals(lexicalUnitImpl.identCssText)) {
            return false;
        }
        if (this.intValue != lexicalUnitImpl.intValue) {
            return false;
        }
        if (this.parameters == null) {
            return lexicalUnitImpl.parameters == null;
        }
        if (lexicalUnitImpl.parameters == null) {
            return false;
        }
        LexicalUnitImpl lexicalUnitImpl2 = this.parameters;
        LexicalUnitImpl lexicalUnitImpl3 = lexicalUnitImpl.parameters;
        while (lexicalUnitImpl2 != null) {
            if (!lexicalUnitImpl2.equals(lexicalUnitImpl3)) {
                return false;
            }
            lexicalUnitImpl2 = lexicalUnitImpl2.nextLexicalUnit;
            lexicalUnitImpl3 = lexicalUnitImpl3.nextLexicalUnit;
        }
        return lexicalUnitImpl3 == null;
    }

    @Override
    public LexicalUnitImpl shallowClone() {
        LexicalUnitImpl lexicalUnitImpl = new LexicalUnitImpl(this.unitType);
        lexicalUnitImpl.cssUnit = this.cssUnit;
        lexicalUnitImpl.intValue = this.intValue;
        lexicalUnitImpl.floatValue = this.floatValue;
        lexicalUnitImpl.dimensionUnitText = this.dimensionUnitText;
        lexicalUnitImpl.identCssText = this.identCssText;
        lexicalUnitImpl.value = this.value;
        if (this.parameters != null) {
            lexicalUnitImpl.parameters = this.parameters.clone(lexicalUnitImpl);
        }
        return lexicalUnitImpl;
    }

    @Override
    public LexicalUnitImpl clone() {
        return this.clone(null);
    }

    private LexicalUnitImpl clone(LexicalUnitImpl lexicalUnitImpl) {
        LexicalUnitImpl lexicalUnitImpl2 = new LexicalUnitImpl(this.unitType);
        lexicalUnitImpl2.cssUnit = this.cssUnit;
        lexicalUnitImpl2.intValue = this.intValue;
        lexicalUnitImpl2.floatValue = this.floatValue;
        lexicalUnitImpl2.dimensionUnitText = this.dimensionUnitText;
        lexicalUnitImpl2.identCssText = this.identCssText;
        lexicalUnitImpl2.value = this.value;
        if (this.nextLexicalUnit != null) {
            lexicalUnitImpl2.nextLexicalUnit = this.nextLexicalUnit.clone(lexicalUnitImpl);
            lexicalUnitImpl2.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl2;
        }
        lexicalUnitImpl2.ownerLexicalUnit = lexicalUnitImpl;
        if (this.parameters != null) {
            lexicalUnitImpl2.parameters = this.parameters.clone(lexicalUnitImpl2);
        }
        return lexicalUnitImpl2;
    }
}

