/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSShorthandValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.w3c.dom.DOMException;

class ShorthandValue
extends StyleValue
implements CSSShorthandValue {
    private static final long serialVersionUID = 1L;
    private String cssText = null;
    private final LexicalUnit lexicalUnit;
    private final boolean important;
    private final boolean priorityCompat;
    private final HashSet<String> longhands;
    private String miniCssText = "";

    ShorthandValue(LexicalUnit lexicalUnit, boolean bl) {
        this(lexicalUnit, bl, new String[0]);
    }

    private ShorthandValue(LexicalUnit lexicalUnit, boolean bl, String[] stringArray) {
        this.lexicalUnit = lexicalUnit;
        this.important = bl;
        this.priorityCompat = lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.COMPAT_PRIO;
        this.longhands = new HashSet(stringArray.length);
        Collections.addAll(this.longhands, stringArray);
    }

    private ShorthandValue(ShorthandValue shorthandValue) {
        this.lexicalUnit = shorthandValue.lexicalUnit;
        this.important = shorthandValue.important;
        this.priorityCompat = shorthandValue.priorityCompat;
        this.cssText = shorthandValue.cssText;
        this.miniCssText = shorthandValue.miniCssText;
        this.longhands = new HashSet(shorthandValue.longhands.size());
        this.longhands.addAll(shorthandValue.longhands);
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "This property can only be changed from CSSStyleDeclaration.setCssText()");
    }

    public void setShorthandText(String string, String string2) throws DOMException {
        this.cssText = string;
        this.miniCssText = string2;
    }

    public LexicalUnit getLexicalUnit() {
        return this.lexicalUnit;
    }

    public HashSet<String> getLonghands() {
        return this.longhands;
    }

    @Override
    public boolean isImportant() {
        return this.important && !this.priorityCompat;
    }

    public boolean isPriorityCompat() {
        return this.priorityCompat;
    }

    @Override
    public String getCssText() {
        return this.cssText;
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getCssText());
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.miniCssText;
    }

    boolean isSetSubproperty(String string) {
        return this.longhands.contains(string);
    }

    boolean overrideBy(ShorthandValue shorthandValue) {
        this.longhands.removeAll(shorthandValue.longhands);
        return this.longhands.isEmpty();
    }

    boolean overrideByLonghand(String string) {
        this.longhands.remove(string);
        return this.longhands.isEmpty();
    }

    @Override
    public ShorthandValue clone() {
        return new ShorthandValue(this);
    }

    static ShorthandValue createCSSShorthandValue(ShorthandDatabase shorthandDatabase, String string, LexicalUnit lexicalUnit, boolean bl) {
        ShorthandValue shorthandValue = new ShorthandValue(lexicalUnit, bl, shorthandDatabase.getLonghandProperties(string));
        if ("border".equals(string)) {
            shorthandValue.longhands.add("border-image-source");
            shorthandValue.longhands.add("border-image-slice");
            shorthandValue.longhands.add("border-image-width");
            shorthandValue.longhands.add("border-image-outset");
            shorthandValue.longhands.add("border-image-repeat");
        } else if ("font".equals(string)) {
            shorthandValue.longhands.add("font-variant-caps");
            shorthandValue.longhands.add("font-variant-ligatures");
            shorthandValue.longhands.add("font-variant-position");
            shorthandValue.longhands.add("font-variant-numeric");
            shorthandValue.longhands.add("font-variant-alternates");
            shorthandValue.longhands.add("font-variant-east-asian");
        }
        return shorthandValue;
    }
}

