/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSPropertyRule;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PropertyDescriptorStyleDeclaration;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class PropertyRule
extends BaseCSSDeclarationRule
implements CSSPropertyRule {
    private static final long serialVersionUID = 1L;
    private String name = null;

    public PropertyRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)18, by);
    }

    @Override
    PropertyDescriptorStyleDeclaration createStyleDeclaration(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return new PropertyDescriptorStyleDeclaration(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String string) throws DOMException {
        this.name = string;
    }

    @Override
    public boolean inherits() {
        String string = this.getStyle().getPropertyValue("inherits").toLowerCase(Locale.ROOT);
        return !string.equals("false");
    }

    @Override
    public LexicalValue getInitialValue() {
        return (LexicalValue)this.getStyle().getPropertyCSSValue("initial-value");
    }

    @Override
    public CSSValueSyntax getSyntax() {
        CSSValueSyntax cSSValueSyntax;
        StyleValue styleValue = this.getStyle().getPropertyCSSValue("syntax");
        if (styleValue == null || styleValue.getPrimitiveType() != CSSValue.Type.STRING) {
            return null;
        }
        String string = ((CSSTypedValue)((Object)styleValue)).getStringValue();
        try {
            cSSValueSyntax = new SyntaxParser().parseSyntax(string);
        }
        catch (CSSException cSSException) {
            return null;
        }
        return cSSValueSyntax;
    }

    @Override
    public String getCssText() {
        PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (propertyDescriptorStyleDeclaration.isValidDeclaration() && this.name != null) {
            StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
            styleFormattingContext.setParentContext(this.getParentRule());
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
            try {
                this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
            }
            catch (IOException iOException) {
                throw new DOMException(11, iOException.getMessage());
            }
            return bufferSimpleWriter.toString();
        }
        return "";
    }

    @Override
    public String getMinifiedCssText() {
        PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (propertyDescriptorStyleDeclaration.isValidDeclaration() && this.name != null) {
            return "@property " + ParseHelper.escape(this.name) + " {" + this.getStyle().getMinifiedCssText() + '}';
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (propertyDescriptorStyleDeclaration.isValidDeclaration() && this.name != null) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)"@property ");
            simpleWriter.write((CharSequence)ParseHelper.escape(this.name));
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            styleFormattingContext.startStyleDeclaration(simpleWriter);
            this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endStyleDeclaration(simpleWriter);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    @Override
    public void setCssText(String string) throws DOMException {
        int n = (string = string.trim()).indexOf(123);
        if (n < 11) {
            throw new DOMException(12, "Bad property rule: " + string);
        }
        try {
            super.setCssText(string);
        }
        catch (DOMException dOMException) {
            this.clear();
            throw dOMException;
        }
        PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration = (PropertyDescriptorStyleDeclaration)this.getStyle();
        if (!propertyDescriptorStyleDeclaration.isValidDeclaration()) {
            this.clear();
            throw new DOMException(12, "Bad property rule: " + string);
        }
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        super.setRule(abstractCSSRule);
        this.name = ((PropertyRule)abstractCSSRule).name;
        PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration = (PropertyDescriptorStyleDeclaration)this.getStyle();
        propertyDescriptorStyleDeclaration.updateValidity();
    }

    @Override
    void startAtRule(String string, String string2) {
        if (!"property".equalsIgnoreCase(string)) {
            throw new DOMException(13, "Cannot set rule of type: " + string);
        }
        if (string2 == null) {
            throw new DOMException(12, "No property name.");
        }
        string2 = ParseHelper.parseIdent(string2);
        this.setName(string2);
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.getType();
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PropertyRule propertyRule = (PropertyRule)object;
        return !(this.name == null ? propertyRule.name != null : !this.name.equals(propertyRule.name));
    }

    @Override
    public PropertyRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        PropertyRule propertyRule = new PropertyRule(abstractCSSStyleSheet, this.getOrigin());
        propertyRule.setName(this.getName());
        PropertyDescriptorStyleDeclaration propertyDescriptorStyleDeclaration = (PropertyDescriptorStyleDeclaration)propertyRule.getStyle();
        propertyDescriptorStyleDeclaration.addStyle((BaseCSSStyleDeclaration)this.getStyle());
        return propertyRule;
    }
}

