/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.CSSKeyframesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.KeyframeRule;
import io.sf.carte.doc.style.css.om.PropertyCSSHandler;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.CommentRemover;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class KeyframesRule
extends BaseCSSRule
implements CSSKeyframesRule {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private final CSSRuleArrayList cssRules;

    protected KeyframesRule(AbstractCSSStyleSheet abstractCSSStyleSheet, byte by) {
        super(abstractCSSStyleSheet, (short)7, by);
        this.cssRules = new CSSRuleArrayList();
    }

    KeyframesRule(AbstractCSSStyleSheet abstractCSSStyleSheet, KeyframesRule keyframesRule) {
        super(abstractCSSStyleSheet, (short)7, keyframesRule.getOrigin());
        this.name = keyframesRule.name;
        this.cssRules = keyframesRule.cssRules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public void appendRule(String string) throws DOMException {
        KeyframeRule keyframeRule = new KeyframeRule(this);
        keyframeRule.setCssText(string);
        this.cssRules.add(keyframeRule);
    }

    @Override
    public void deleteRule(String string) {
        try {
            string = this.keyframeSelector(string);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule cSSKeyframeRule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!cSSKeyframeRule.getKeyText().equals(string)) continue;
            this.cssRules.remove(i);
            break;
        }
    }

    @Override
    public CSSKeyframeRule findRule(String string) throws DOMException {
        try {
            string = this.keyframeSelector(string);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        for (int i = this.cssRules.getLength() - 1; i >= 0; --i) {
            CSSKeyframeRule cSSKeyframeRule = (CSSKeyframeRule)this.cssRules.get(i);
            if (!cSSKeyframeRule.getKeyText().equals(string)) continue;
            return cSSKeyframeRule;
        }
        return null;
    }

    String keyframeSelector(String string) {
        LexicalUnit lexicalUnit;
        StringReader stringReader = new StringReader(string);
        Parser parser = this.createSACParser();
        try {
            lexicalUnit = parser.parsePropertyValue(stringReader);
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return KeyframesRule.keyframeSelector(lexicalUnit);
    }

    static String keyframeSelector(LexicalUnit lexicalUnit) {
        StringBuilder stringBuilder = new StringBuilder();
        KeyframesRule.appendSelector(stringBuilder, lexicalUnit);
        LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
        while (lexicalUnit2 != null) {
            LexicalUnit lexicalUnit3 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || lexicalUnit3 == null) {
                throw new DOMException(12, "Wrong keyframe selector syntax: " + lexicalUnit.toString());
            }
            stringBuilder.append(',');
            KeyframesRule.appendSelector(stringBuilder, lexicalUnit3);
            lexicalUnit2 = lexicalUnit3.getNextLexicalUnit();
        }
        return stringBuilder.toString();
    }

    private static void appendSelector(StringBuilder stringBuilder, LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (lexicalType == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.STRING) {
            stringBuilder.append(lexicalUnit.getStringValue());
        } else if (lexicalType == LexicalUnit.LexicalType.PERCENTAGE) {
            float f = lexicalUnit.getFloatValue();
            if (f % 1.0f != 0.0f) {
                stringBuilder.append(String.format(Locale.ROOT, "%s", Float.valueOf(f)));
            } else {
                stringBuilder.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(f)));
            }
            stringBuilder.append('%');
        } else if (lexicalType == LexicalUnit.LexicalType.INTEGER && lexicalUnit.getIntegerValue() == 0) {
            stringBuilder.append('0');
        } else {
            throw new DOMException(12, "Wrong keyframe selector: " + lexicalUnit.toString());
        }
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(30 + this.getCssRules().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(30 + this.getCssRules().getLength() * 20);
            stringBuilder.append("@keyframes");
            if (this.name != null) {
                object = this.getName();
                if (((String)object).indexOf(32) == -1) {
                    stringBuilder.append(' ').append((String)object);
                } else {
                    stringBuilder.append(' ').append('\'').append((String)object).append('\'');
                }
            }
            stringBuilder.append('{');
            object = this.getCssRules().iterator();
            while (object.hasNext()) {
                stringBuilder.append(((AbstractCSSRule)object.next()).getMinifiedCssText());
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
        return "";
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        if (this.name != null || !this.getCssRules().isEmpty()) {
            styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
            simpleWriter.write((CharSequence)"@keyframes ");
            if (this.name != null) {
                String string = this.getName();
                if (string.indexOf(32) == -1) {
                    simpleWriter.write((CharSequence)string);
                } else {
                    simpleWriter.write('\'');
                    simpleWriter.write((CharSequence)string);
                    simpleWriter.write('\'');
                }
            }
            styleFormattingContext.updateContext(this);
            styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
            this.getCssRules().writeCssText(simpleWriter, styleFormattingContext);
            styleFormattingContext.endCurrentContext(this);
            styleFormattingContext.endRuleList(simpleWriter);
            styleFormattingContext.writeRightCurlyBracket(simpleWriter);
            styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
        }
    }

    @Override
    public void setCssText(String string) throws DOMException {
        string = string.trim();
        int n = string.length();
        int n2 = string.indexOf(64);
        if (n < 14 || n2 == -1) {
            throw new DOMException(12, "Invalid @keyframes rule: " + string);
        }
        String string2 = CommentRemover.removeComments(string).toString().trim();
        CharSequence charSequence = string2.subSequence(0, 11);
        if (!ParseHelper.startsWithIgnoreCase(charSequence, "@keyframes") || !Character.isWhitespace(charSequence.charAt(10))) {
            throw new DOMException(13, "Not a @keyframes rule: " + string);
        }
        String string3 = string.substring(n2 + 11);
        MyKeyframesHandler myKeyframesHandler = new MyKeyframesHandler();
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        cSSParser.setDocumentHandler(myKeyframesHandler);
        try {
            cSSParser.parseKeyFramesBody(string3);
        }
        catch (CSSParseException cSSParseException) {
            throw new DOMException(5, cSSParseException.getMessage());
        }
    }

    @Override
    void clear() {
        this.cssRules.clear();
        this.resetComments();
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        this.setPrecedingComments(abstractCSSRule.getPrecedingComments());
        this.setTrailingComments(abstractCSSRule.getTrailingComments());
        KeyframesRule keyframesRule = (KeyframesRule)abstractCSSRule;
        this.name = keyframesRule.name;
        this.cssRules.clear();
        this.cssRules.addAll(keyframesRule.getCssRules());
        for (AbstractCSSRule abstractCSSRule2 : this.cssRules) {
            abstractCSSRule2.setParentRule(this);
        }
    }

    @Override
    boolean hasErrorsOrWarnings() {
        for (AbstractCSSRule abstractCSSRule : this.cssRules) {
            if (!abstractCSSRule.hasErrorsOrWarnings()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.cssRules.hashCode();
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyframesRule keyframesRule = (KeyframesRule)object;
        if (this.name == null ? keyframesRule.name != null : !this.name.equals(keyframesRule.name)) {
            return false;
        }
        return !(this.cssRules == null ? keyframesRule.cssRules != null : !this.cssRules.equals(keyframesRule.cssRules));
    }

    @Override
    public KeyframesRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        return new KeyframesRule(abstractCSSStyleSheet, this);
    }

    private class MyKeyframesHandler
    extends PropertyCSSHandler {
        private String name = null;
        private final CSSRuleArrayList cssRules = new CSSRuleArrayList();
        private KeyframeRule currentRule = null;
        private KeyframeRule lastRule = null;
        private StringList comments = null;

        private MyKeyframesHandler() {
        }

        @Override
        public void startKeyframes(String string) {
            this.name = string;
            this.newRule();
        }

        private void newRule() {
            this.lastRule = null;
        }

        @Override
        public void endKeyframes() {
            KeyframesRule.this.name = this.name;
            KeyframesRule.this.cssRules.clear();
            KeyframesRule.this.cssRules.addAll(this.cssRules);
            KeyframesRule.this.resetComments();
        }

        @Override
        public void startKeyframe(LexicalUnit lexicalUnit) {
            this.newRule();
            this.currentRule = new KeyframeRule(KeyframesRule.this);
            this.currentRule.setKeyText(KeyframesRule.keyframeSelector(lexicalUnit));
            this.setLexicalPropertyListener(this.currentRule.getLexicalPropertyListener());
            this.cssRules.add(this.currentRule);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            if (this.currentRule == null) throw new CSSException("Declaration outside of keyframe rule");
            if (bl) {
                CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                cSSPropertyValueException.setValueText(lexicalUnit.toString() + " !important");
                this.currentRule.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
                return;
            } else {
                try {
                    super.property(string, lexicalUnit, bl);
                    return;
                }
                catch (DOMException dOMException) {
                    if (this.currentRule.getStyleDeclarationErrorHandler() == null) return;
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException(dOMException);
                    cSSPropertyValueException.setValueText(lexicalUnit.toString());
                    this.currentRule.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
                }
            }
        }

        @Override
        public void endKeyframe() {
            this.setCommentsToRule(this.currentRule);
            this.lastRule = this.currentRule = null;
            this.setLexicalPropertyListener(null);
        }

        @Override
        public void comment(String string, boolean bl) {
            if (this.lastRule != null && !bl) {
                if (this.lastRule.getTrailingComments() == null) {
                    this.lastRule.setTrailingComments(new LinkedStringList());
                }
                this.lastRule.getTrailingComments().add(string);
            } else if (this.currentRule == null) {
                if (this.comments == null) {
                    this.comments = new LinkedStringList();
                }
                this.comments.add(string);
            }
        }

        private void setCommentsToRule(AbstractCSSRule abstractCSSRule) {
            if (this.comments != null && !this.comments.isEmpty()) {
                LinkedStringList linkedStringList = new LinkedStringList();
                linkedStringList.addAll(this.comments);
                abstractCSSRule.setPrecedingComments(linkedStringList);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }
    }
}

