/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.MediaListAccess;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSImportRule;

public class ImportRule
extends BaseCSSRule
implements CSSImportRule,
CSSRule {
    private static final long serialVersionUID = 1L;
    private AbstractCSSStyleSheet importedSheet = null;
    private String styleSheetURI;
    private MediaQueryList mediaList;

    protected ImportRule(AbstractCSSStyleSheet abstractCSSStyleSheet, MediaQueryList mediaQueryList, String string, byte by) {
        super(abstractCSSStyleSheet, (short)3, by);
        this.mediaList = mediaQueryList;
        this.styleSheetURI = string;
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public MediaQueryList getMedia() {
        return this.mediaList;
    }

    @Override
    public AbstractCSSStyleSheet getStyleSheet() {
        if (this.importedSheet == null) {
            AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
            this.importedSheet = abstractCSSStyleSheet.getStyleSheetFactory().createRuleStyleSheet(this, abstractCSSStyleSheet.getTitle(), this.mediaList);
            this.importedSheet.setParentStyleSheet(abstractCSSStyleSheet);
            try {
                this.loadStyleSheet();
            }
            catch (DOMPolicyException dOMPolicyException) {
                this.importedSheet = null;
            }
            catch (DOMException dOMException) {
                abstractCSSStyleSheet.getErrorHandler().badAtRule(dOMException, this.getCssText());
            }
            catch (IOException iOException) {
                abstractCSSStyleSheet.getDocumentErrorHandler().ioError(this.styleSheetURI, iOException);
            }
        }
        return this.importedSheet;
    }

    private boolean loadStyleSheet() throws IOException, DOMException {
        URL uRL = this.getURL(this.getHref());
        Node node = this.getParentStyleSheet().getOwnerNode();
        CSSDocument cSSDocument = node != null ? (node.getNodeType() == 9 ? (CSSDocument)node : (CSSDocument)node.getOwnerDocument()) : null;
        if (cSSDocument != null && !cSSDocument.isAuthorizedOrigin(uRL)) {
            cSSDocument.getErrorHandler().policyError(node, "Unauthorized @import URL: " + uRL.toExternalForm());
            return false;
        }
        return this.importedSheet.loadStyleSheet(uRL, "");
    }

    @Override
    void clear() {
    }

    @Override
    void setRule(AbstractCSSRule abstractCSSRule) {
        ImportRule importRule = (ImportRule)abstractCSSRule;
        this.styleSheetURI = importRule.getHref();
        this.mediaList = importRule.getMedia();
        this.setPrecedingComments(importRule.getPrecedingComments());
        this.setTrailingComments(importRule.getTrailingComments());
        this.importedSheet = null;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(230);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        simpleWriter.write((CharSequence)"@import ");
        styleFormattingContext.writeURL(simpleWriter, this.getHref());
        if (!this.mediaList.isAllMedia()) {
            simpleWriter.write(' ');
            simpleWriter.write((CharSequence)this.mediaList.getMediaText());
        }
        styleFormattingContext.writeSemiColon(simpleWriter);
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("@import ");
        stringBuilder.append(ParseHelper.quote(this.styleSheetURI, '\''));
        if (!this.mediaList.isAllMedia()) {
            stringBuilder.append(' ');
            stringBuilder.append(this.mediaList.getMinifiedMedia());
        }
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return this.mediaList != null && this.mediaList.hasErrors();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.mediaList == null ? 0 : this.mediaList.hashCode());
        n2 = 31 * n2 + (this.styleSheetURI == null ? 0 : this.styleSheetURI.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImportRule importRule = (ImportRule)object;
        if (this.mediaList == null ? importRule.mediaList != null : !this.mediaList.equals(importRule.mediaList)) {
            return false;
        }
        return !(this.styleSheetURI == null ? importRule.styleSheetURI != null : !this.styleSheetURI.equals(importRule.styleSheetURI));
    }

    @Override
    public ImportRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        ImportRule importRule = new ImportRule(abstractCSSStyleSheet, ((MediaListAccess)((Object)this.getMedia())).unmodifiable(), this.getHref(), this.getOrigin());
        return importRule;
    }
}

