/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.AlgebraicExpression;
import io.sf.carte.doc.style.css.BoxValues;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSColorMixFunction;
import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSExpression;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSOperandExpression;
import io.sf.carte.doc.style.css.CSSPrimitiveValue;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDatabaseRequiredException;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BoxModelHelper;
import io.sf.carte.doc.style.css.om.CSSResourceLimitException;
import io.sf.carte.doc.style.css.om.CounterRef;
import io.sf.carte.doc.style.css.om.PendingValue;
import io.sf.carte.doc.style.css.om.PropertyCounterHandler;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.om.SimpleBoxModel;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.AttrValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.EnvVariableValue;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.ExpressionValue;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.LinkedCSSValueList;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PercentageEvaluator;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.PropertyDatabase;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.URIValue;
import io.sf.carte.doc.style.css.property.URIValueWrapper;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.doc.style.css.property.VarValue;
import io.sf.carte.doc.style.css.property.WrappedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;

public abstract class ComputedCSSStyle
extends BaseCSSStyleDeclaration
implements CSSComputedProperties {
    private static final long serialVersionUID = 1L;
    static final float SCREEN_WIDTH = 1440.0f;
    static final float SCREEN_HEIGHT = 810.0f;
    static final float HANDHELD_WIDTH = 270.0f;
    static final float HANDHELD_HEIGHT = 480.0f;
    static final float PRINT_WIDTH = 595.0f;
    static final float PRINT_HEIGHT = 842.0f;
    private final BaseDocumentCSSStyleSheet ownerSheet;
    private CSSElement node = null;
    private transient LinkedList<String> customPropertyStack = null;
    private transient LinkedList<String> attrValueStack = null;

    protected ComputedCSSStyle(BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet) {
        this.ownerSheet = baseDocumentCSSStyleSheet;
    }

    protected ComputedCSSStyle(ComputedCSSStyle computedCSSStyle) {
        super(computedCSSStyle);
        this.ownerSheet = computedCSSStyle.ownerSheet;
        this.setOwnerNode(computedCSSStyle.getOwnerNode());
    }

    protected void setOwnerNode(CSSElement cSSElement) {
        this.node = cSSElement;
    }

    @Override
    public CSSElement getOwnerNode() {
        return this.node;
    }

    protected BaseDocumentCSSStyleSheet getOwnerSheet() {
        return this.ownerSheet;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.node != null && this.node.getNodeType() == 1) {
            return this.node.getOwnerDocument().getErrorHandler().getInlineStyleErrorHandler(this.node);
        }
        return null;
    }

    @Override
    String getUnknownPropertyPriority(String string) {
        return this.checkShorthandPriority(string);
    }

    @Override
    public String getPropertyValue(String string) {
        StyleValue styleValue = this.getCSSValue(string = this.getCanonicalPropertyName(string));
        if (styleValue != null) {
            CSSValue.Type type;
            CSSValue.CssType cssType = styleValue.getCssValueType();
            if (cssType == CSSValue.CssType.TYPED && ((type = styleValue.getPrimitiveType()) == CSSValue.Type.STRING || type == CSSValue.Type.IDENT)) {
                return ((CSSTypedValue)((Object)styleValue)).getStringValue();
            }
            return styleValue.getCssText();
        }
        if (ShorthandDatabase.getInstance().isShorthand(string)) {
            return this.serializeShorthand(string);
        }
        return "";
    }

    private static boolean isCustomPropertyName(String string) {
        return string.startsWith("--");
    }

    private String serializeShorthand(String string) {
        ShorthandBuilder shorthandBuilder = this.createBuilder(string);
        if (shorthandBuilder != null) {
            String[] stringArray = shorthandBuilder.getLonghandProperties();
            for (String object2 : stringArray) {
                shorthandBuilder.addAssignedProperty(object2, false);
            }
            if ("font".equals(string) || "font-variant".equals(string)) {
                shorthandBuilder.addAssignedProperty("font-variant-caps", false);
                shorthandBuilder.addAssignedProperty("font-variant-ligatures", false);
                shorthandBuilder.addAssignedProperty("font-variant-position", false);
                shorthandBuilder.addAssignedProperty("font-variant-numeric", false);
                shorthandBuilder.addAssignedProperty("font-variant-alternates", false);
                shorthandBuilder.addAssignedProperty("font-variant-east-asian", false);
            }
            StringBuilder stringBuilder = new StringBuilder(64);
            shorthandBuilder.appendMinifiedCssText(stringBuilder);
            String string2 = stringBuilder.toString();
            StringReader stringReader = new StringReader(string2);
            CSSParser cSSParser = new CSSParser();
            PropertyCounterHandler propertyCounterHandler = new PropertyCounterHandler();
            cSSParser.setDocumentHandler(propertyCounterHandler);
            cSSParser.setErrorHandler(propertyCounterHandler);
            try {
                cSSParser.parseStyleDeclaration(stringReader);
            }
            catch (CSSException | IOException n) {
                return "";
            }
            if (!propertyCounterHandler.hasError() && propertyCounterHandler.getPropertyCount() == 1) {
                int n = string2.length();
                int n2 = n - 1;
                int n3 = string2.indexOf(58);
                if (string2.charAt(n2) == ';') {
                    n = n2;
                }
                return string2.substring(n3 + 1, n);
            }
        }
        return "";
    }

    @Override
    protected void setPropertyCSSValue(String string, StyleValue styleValue, String string2) {
        if ("background-image".equals(string) || "border-image-source".equals(string)) {
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
                if (string2 != null) {
                    styleValue = ((ValueList)styleValue).wrap(string2, this.getOwnerNode().getOwnerDocument().getBaseURI());
                }
            } else if (styleValue.getPrimitiveType() == CSSValue.Type.URI && string2 != null) {
                styleValue = new URIValueWrapper((URIValue)styleValue, string2, this.getOwnerNode().getOwnerDocument().getBaseURI());
            }
        }
        super.setPropertyCSSValue(string, styleValue, string2);
    }

    private LexicalValue getCustomPropertyValue(String string, boolean bl, CounterRef counterRef) {
        LexicalValue lexicalValue = (LexicalValue)super.getCSSValue(string);
        ComputedCSSStyle computedCSSStyle = this;
        if (bl) {
            while (lexicalValue == null) {
                if ((computedCSSStyle = computedCSSStyle.getParentComputedStyle()) == null) {
                    lexicalValue = null;
                    break;
                }
                if (!computedCSSStyle.isPropertySet(string)) continue;
                lexicalValue = (LexicalValue)computedCSSStyle.getDeclaredCSSValue(string);
            }
        }
        if (lexicalValue != null) {
            LexicalUnit lexicalUnit;
            if (computedCSSStyle.customPropertyStack == null) {
                computedCSSStyle.customPropertyStack = new LinkedList();
            }
            LexicalUnit lexicalUnit2 = lexicalValue.getLexicalUnit().clone();
            try {
                lexicalUnit = computedCSSStyle.replaceLexicalProxy(string, lexicalUnit2, counterRef);
            }
            catch (CSSResourceLimitException cSSResourceLimitException) {
                throw cSSResourceLimitException;
            }
            catch (Exception exception) {
                computedCSSStyle.computedStyleError(string, lexicalValue.getCssText(), null, exception);
                lexicalUnit = null;
            }
            if (lexicalUnit != null) {
                lexicalValue = new LexicalValue();
                lexicalValue.setLexicalUnit(lexicalUnit);
            } else {
                lexicalValue = null;
            }
        }
        return lexicalValue;
    }

    public StyleValue getCascadedValue(String string) throws StyleDatabaseRequiredException {
        Object object;
        StyleValue styleValue = super.getCSSValue(string);
        if (styleValue != null) {
            object = styleValue.getCssValueType();
            if (object == CSSValue.CssType.PROXY) {
                styleValue = this.replaceProxyValues(string, styleValue);
            } else if (styleValue.getCssValueType() == CSSValue.CssType.SHORTHAND) {
                return null;
            }
            if (styleValue != null) {
                if (styleValue.getPrimitiveType() == CSSValue.Type.UNSET) {
                    styleValue = null;
                } else {
                    try {
                        styleValue = this.absoluteValue(string, styleValue, false);
                    }
                    catch (DOMException dOMException) {
                        this.computedStyleError(string, styleValue.getCssText(), null, dOMException);
                        styleValue = null;
                    }
                }
            }
        }
        if (styleValue == null) {
            boolean bl;
            object = null;
            boolean bl2 = bl = PropertyDatabase.getInstance().isInherited(string) || ComputedCSSStyle.isCustomPropertyName(string) && ((object = this.getOwnerSheet().getPropertyDefinition(string)) == null || object.inherits());
            styleValue = bl ? InheritValue.getValue() : (object != null ? (StyleValue)((Object)object.getInitialValue()) : this.defaultPropertyValue(string));
        }
        return styleValue;
    }

    @Override
    public StyleValue getCSSValue(String string) throws StyleDatabaseRequiredException {
        StyleValue styleValue;
        boolean bl = PropertyDatabase.getInstance().isInherited(string);
        if (!bl && ComputedCSSStyle.isCustomPropertyName(string)) {
            LexicalValue lexicalValue;
            CSSPropertyDefinition cSSPropertyDefinition = this.getOwnerSheet().getPropertyDefinition(string);
            bl = cSSPropertyDefinition == null || cSSPropertyDefinition.inherits();
            CounterRef counterRef = new CounterRef();
            try {
                lexicalValue = this.getCustomPropertyValue(string, bl, counterRef);
            }
            catch (DOMException dOMException) {
                this.computedStyleError(string, null, null, dOMException);
                return null;
            }
            if (lexicalValue == null) {
                if (cSSPropertyDefinition != null) {
                    LexicalValue lexicalValue2 = (LexicalValue)cSSPropertyDefinition.getInitialValue();
                    styleValue = this.customPropertyFallback(string, lexicalValue2, lexicalValue2.getLexicalUnit());
                } else {
                    styleValue = null;
                }
            } else {
                styleValue = this.evaluateLexicalValue(string, lexicalValue, counterRef);
                if (styleValue != null && styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                    try {
                        styleValue = this.absoluteValue(string, styleValue, false);
                    }
                    catch (DOMException dOMException) {
                        this.computedStyleError(string, styleValue.getCssText(), null, dOMException);
                        styleValue = null;
                    }
                }
            }
        } else {
            styleValue = this.getCSSValue(string, bl);
        }
        return styleValue;
    }

    StyleValue getCSSValue(String string, boolean bl) throws StyleDatabaseRequiredException {
        StyleValue styleValue = this.getDeclaredCSSValue(string);
        if (styleValue != null) {
            CSSValue.CssType cssType = styleValue.getCssValueType();
            if (cssType == CSSValue.CssType.PROXY || cssType == CSSValue.CssType.LIST) {
                styleValue = this.replaceProxyValues(string, styleValue);
            } else if (cssType == CSSValue.CssType.SHORTHAND) {
                return null;
            }
            if (styleValue != null) {
                if (styleValue.getPrimitiveType() == CSSValue.Type.UNSET) {
                    styleValue = null;
                } else if (styleValue.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                    this.computedStyleError(string, styleValue.getCssText(), "Unable to replace LEXICAL value.");
                    styleValue = null;
                }
            }
        }
        if ((styleValue = ComputedCSSStyle.inheritValue(this, string, styleValue, bl)) != null && styleValue.getPrimitiveType() == CSSValue.Type.INHERIT) {
            styleValue = null;
        }
        styleValue = this.computeValue(string, styleValue, bl);
        return styleValue;
    }

    private StyleValue replaceProxyValues(String string, StyleValue styleValue) {
        block4: {
            CSSValue.CssType cssType;
            block5: {
                cssType = styleValue.getCssValueType();
                if (cssType != CSSValue.CssType.LIST) break block5;
                ValueList valueList = (ValueList)styleValue;
                int n = valueList.getLength();
                for (int i = 0; i < n; ++i) {
                    StyleValue styleValue2 = valueList.item(i);
                    styleValue2 = this.replaceProxyValues(string, styleValue2);
                    while (styleValue2 != null && styleValue2.getCssValueType() == CSSValue.CssType.PROXY) {
                        styleValue2 = this.replaceProxyValue(string, styleValue2);
                    }
                    if (styleValue2 == null) {
                        styleValue = null;
                        break block4;
                    }
                    valueList.set(i, styleValue2);
                }
                break block4;
            }
            if (cssType != CSSValue.CssType.PROXY) break block4;
            while ((styleValue = this.replaceProxyValue(string, styleValue)) != null && styleValue.getCssValueType() == CSSValue.CssType.PROXY && styleValue.getPrimitiveType() != CSSValue.Type.LEXICAL) {
            }
        }
        return styleValue;
    }

    private TypedValue primitiveToTypedValue(String string, PrimitiveValue primitiveValue) {
        TypedValue typedValue;
        if (primitiveValue.getCssValueType() == CSSValue.CssType.TYPED) {
            typedValue = (TypedValue)primitiveValue;
        } else {
            StyleValue styleValue = primitiveValue;
            while ((styleValue = this.replaceProxyValue(string, styleValue)) != null && styleValue.getCssValueType() == CSSValue.CssType.PROXY && styleValue.getPrimitiveType() != CSSValue.Type.LEXICAL) {
            }
            if (styleValue == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                this.computedStyleError(string, primitiveValue.getCssText(), "Could not evaluate proxy value");
                return null;
            }
            typedValue = (TypedValue)styleValue;
        }
        return typedValue;
    }

    StyleValue replaceProxyValue(String string, CSSValue cSSValue) {
        StyleValue styleValue;
        CSSValue.Type type = cSSValue.getPrimitiveType();
        if (type == CSSValue.Type.VAR) {
            VarValue varValue = (VarValue)cSSValue;
            styleValue = this.evaluateVarValue(string, varValue);
            if (styleValue != null && (styleValue.getPrimitiveType() == CSSValue.Type.INITIAL || styleValue.getPrimitiveType() == CSSValue.Type.UNSET && !PropertyDatabase.getInstance().isInherited(string)) && (styleValue = this.defaultPropertyValue(string)) != null) {
                styleValue = this.enforceExpectIntegerFromProxy(string, varValue, styleValue);
            }
        } else if (type == CSSValue.Type.LEXICAL) {
            try {
                styleValue = this.evaluateLexicalValue(string, (LexicalValue)cSSValue, new CounterRef());
            }
            catch (CSSResourceLimitException cSSResourceLimitException) {
                this.computedStyleError(string, cSSValue.getCssText(), null, cSSResourceLimitException);
                return null;
            }
            if (styleValue != null && styleValue.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                if (!ComputedCSSStyle.isCustomPropertyName(string)) {
                    this.computedStyleError(string, styleValue.getCssText(), "Invalid value for non-custom property.");
                    return null;
                }
                return styleValue;
            }
        } else if (type == CSSValue.Type.ATTR) {
            styleValue = this.computeAttribute(string, (AttrValue)cSSValue);
        } else if (type == CSSValue.Type.ENV) {
            styleValue = this.computeEnv(string, (EnvVariableValue)cSSValue);
        } else if (type == CSSValue.Type.INTERNAL) {
            PendingValue pendingValue = (PendingValue)cSSValue;
            styleValue = this.getSubstitutedValue(string, pendingValue.getShorthandName(), pendingValue.getLexicalUnit().clone(), this.isPropertyImportant(string));
        } else {
            return null;
        }
        return styleValue;
    }

    private static StyleValue inheritValue(ComputedCSSStyle computedCSSStyle, String string, StyleValue styleValue, boolean bl) {
        while ((styleValue == null ? bl : styleValue.getPrimitiveType() == CSSValue.Type.INHERIT) && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            if (!computedCSSStyle.isPropertySet(string) || (styleValue = computedCSSStyle.getCSSValue(string)) == null || styleValue.getPrimitiveType() != CSSValue.Type.UNSET) continue;
            styleValue = null;
        }
        return styleValue;
    }

    private StyleValue getSubstitutedValue(String string, String string2, LexicalUnit lexicalUnit, boolean bl) {
        try {
            if (this.substituteShorthand(string, string2, lexicalUnit, bl)) {
                return this.getCSSValue(string);
            }
        }
        catch (DOMException dOMException) {
            this.computedStyleError(string, lexicalUnit.toString(), "Problem substituting lexical value in shorthand.", dOMException);
        }
        return null;
    }

    private boolean substituteShorthand(String string, String string2, LexicalUnit lexicalUnit, boolean bl) {
        if (this.customPropertyStack == null) {
            this.customPropertyStack = new LinkedList();
        }
        return (lexicalUnit = this.replaceLexicalProxy(string, lexicalUnit, new CounterRef())) != null ? this.setShorthandLonghands(string2, lexicalUnit, bl, null) : false;
    }

    private StyleValue computeValue(String string, StyleValue styleValue, boolean bl) {
        if (styleValue == null || styleValue.getPrimitiveType() == CSSValue.Type.INITIAL || !bl && styleValue.getPrimitiveType() == CSSValue.Type.UNSET) {
            styleValue = this.defaultPropertyValue(string);
        }
        if (styleValue != null) {
            if (styleValue.isSystemDefault()) {
                return styleValue;
            }
            if (string.equals("font-size")) {
                styleValue = this.absoluteFontSizeValue(styleValue, false);
            } else {
                try {
                    styleValue = this.absoluteValue(string, styleValue, false);
                }
                catch (DOMException dOMException) {
                    this.computedStyleError(string, styleValue.getCssText(), null, dOMException);
                    styleValue = null;
                }
                if (styleValue == null) {
                    if (bl) {
                        ComputedCSSStyle computedCSSStyle = this;
                        do {
                            if ((styleValue = ComputedCSSStyle.inheritValue(computedCSSStyle, string, styleValue, true)) == null || (styleValue = computedCSSStyle.replaceProxyValues(string, styleValue)) == null) continue;
                            styleValue = computedCSSStyle.computeValue(string, styleValue, bl);
                        } while (styleValue == null && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null);
                    }
                    if (styleValue == null || styleValue.getPrimitiveType() == CSSValue.Type.INHERIT) {
                        styleValue = this.defaultPropertyValue(string);
                    }
                }
                if ("display".equals(string)) {
                    styleValue = this.applyDisplayConstrains(styleValue);
                } else if (string.endsWith("-width")) {
                    styleValue = this.applyBorderWidthConstrains(string, styleValue);
                } else if ("background-repeat".equals(string)) {
                    styleValue = this.computeBackgroundRepeat(styleValue);
                } else if (string.endsWith("color") && styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                    styleValue = this.colorValue(string, (TypedValue)styleValue);
                }
            }
        }
        return styleValue;
    }

    private StyleValue absoluteValue(String string, StyleValue styleValue, boolean bl) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            int n = valueList.getLength();
            for (int i = 0; i < n; ++i) {
                valueList.set(i, this.absoluteValue(string, valueList.item(i), bl));
            }
        } else if (cssType == CSSValue.CssType.TYPED) {
            styleValue = this.absoluteTypedValue(string, (TypedValue)styleValue, bl);
        }
        return styleValue;
    }

    TypedValue absoluteTypedValue(String string, TypedValue typedValue, boolean bl) {
        if (this.isRelativeUnit(typedValue)) {
            try {
                typedValue = this.absoluteNumberValue((NumberValue)typedValue, bl);
            }
            catch (IllegalStateException | DOMException runtimeException) {
                this.computedStyleError(string, typedValue.getCssText(), "Could not absolutize property value.", runtimeException);
            }
        } else {
            CSSValue.Type type = typedValue.getPrimitiveType();
            if (type == CSSValue.Type.EXPRESSION) {
                typedValue = typedValue.clone();
                ExpressionValue expressionValue = (ExpressionValue)typedValue;
                MyEvaluator myEvaluator = new MyEvaluator(string);
                try {
                    typedValue = myEvaluator.evaluateExpression(expressionValue);
                }
                catch (DOMException dOMException) {
                    this.computedStyleWarning(string, typedValue, "Could not evaluate expression value.", dOMException);
                    this.absoluteExpressionValue(string, expressionValue.getExpression(), bl);
                }
            } else if (type == CSSValue.Type.MATH_FUNCTION) {
                CSSMathFunctionValue cSSMathFunctionValue = (CSSMathFunctionValue)((Object)typedValue);
                MyEvaluator myEvaluator = new MyEvaluator(string);
                try {
                    typedValue = myEvaluator.evaluateFunction(cSSMathFunctionValue);
                }
                catch (DOMException dOMException) {
                    this.computedStyleWarning(string, typedValue, "Could not evaluate function value.", dOMException);
                    typedValue = typedValue.clone();
                    cSSMathFunctionValue = (CSSMathFunctionValue)((Object)typedValue);
                    LinkedCSSValueList linkedCSSValueList = cSSMathFunctionValue.getArguments();
                    int n = linkedCSSValueList.size();
                    for (int i = 0; i < n; ++i) {
                        linkedCSSValueList.set(i, this.absoluteValue(string, (StyleValue)linkedCSSValueList.get(i), bl));
                    }
                }
            } else if (type == CSSValue.Type.COLOR) {
                typedValue = this.computeColor(string, (ColorValue)typedValue);
            } else if (type == CSSValue.Type.COLOR_MIX) {
                typedValue = this.computeColorMix(string, typedValue, bl);
            } else if (typedValue.getComponentCount() != 0) {
                typedValue = this.absolutizeComponents(string, typedValue, bl);
            }
        }
        return typedValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NumberValue absoluteNumberValue(NumberValue numberValue, boolean bl) {
        short s = numberValue.getUnitType();
        float f = numberValue.getFloatValue(s);
        if (s == 20) {
            ComputedCSSStyle computedCSSStyle;
            f = bl ? ((computedCSSStyle = this.getParentComputedStyle()) != null ? (f *= computedCSSStyle.getComputedFontSize()) : (f *= this.getInitialFontSize())) : (f *= this.getComputedFontSize());
            return ComputedCSSStyle.asNumericValuePt(f);
        } else if (s == 21) {
            float f2;
            ComputedCSSStyle computedCSSStyle;
            if (bl) {
                computedCSSStyle = this.getParentComputedStyle();
                if (computedCSSStyle != null) {
                    f2 = computedCSSStyle.getComputedFontSize();
                } else {
                    computedCSSStyle = this;
                    f2 = this.getInitialFontSize();
                }
            } else {
                computedCSSStyle = this;
                f2 = this.getComputedFontSize();
            }
            f = this.getStyleDatabase() != null ? (f *= this.getStyleDatabase().getExSizeInPt(computedCSSStyle.getUsedFontFamily(), f2)) : (f *= f2 * 0.5f);
            return ComputedCSSStyle.asNumericValuePt(f);
        } else if (s == 26) {
            CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            f = cSSElement != this.getOwnerNode() ? (f *= cSSElement.getComputedStyle(null).getComputedFontSize()) : (!bl ? (f *= this.getComputedFontSize()) : (f *= this.getInitialFontSize()));
            return ComputedCSSStyle.asNumericValuePt(f);
        } else if (s == 28) {
            float f3;
            CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            CSSComputedProperties cSSComputedProperties = this;
            if (cSSElement != this.getOwnerNode()) {
                cSSComputedProperties = cSSElement.getComputedStyle(null);
                f3 = cSSComputedProperties.getComputedFontSize();
            } else {
                f3 = !bl ? this.getComputedFontSize() : this.getInitialFontSize();
            }
            f = this.getStyleDatabase() != null ? (f *= this.getStyleDatabase().getExSizeInPt(cSSComputedProperties.getUsedFontFamily(), f3)) : (f *= f3 * 0.5f);
            return ComputedCSSStyle.asNumericValuePt(f);
        } else if (s == 25) {
            ComputedCSSStyle computedCSSStyle;
            f = bl ? ((computedCSSStyle = this.getParentComputedStyle()) != null ? (f *= computedCSSStyle.getComputedLineHeight()) : (f *= this.getInitialFontSize() * 1.2f)) : (f *= this.getComputedLineHeight());
            return ComputedCSSStyle.asNumericValuePt(f);
        } else if (s == 27) {
            CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
            f = cSSElement != this.getOwnerNode() ? (f *= cSSElement.getComputedStyle(null).getComputedLineHeight()) : (!bl ? (f *= this.getComputedLineHeight()) : (f *= this.getInitialFontSize() * 1.2f));
            return ComputedCSSStyle.asNumericValuePt(f);
        } else {
            CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
            if (s == 22) {
                ComputedCSSStyle computedCSSStyle;
                if (cSSCanvas == null) throw new IllegalStateException("cap unit requires canvas");
                if (bl) {
                    computedCSSStyle = this.getParentComputedStyle();
                    if (computedCSSStyle == null) {
                        throw new DOMException(9, "Cannot use parent style at root element.");
                    }
                } else {
                    computedCSSStyle = this;
                }
                f *= cSSCanvas.getCapHeight(computedCSSStyle);
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 23) {
                ComputedCSSStyle computedCSSStyle;
                if (bl) {
                    computedCSSStyle = this.getParentComputedStyle();
                    if (computedCSSStyle == null) {
                        return ComputedCSSStyle.asNumericValuePt(f *= this.getInitialFontSize() * 0.25f);
                    }
                } else {
                    computedCSSStyle = this;
                }
                f = cSSCanvas != null ? (f *= (float)cSSCanvas.stringWidth("0", computedCSSStyle)) : (f *= computedCSSStyle.getComputedFontSize() * 0.25f);
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 29) {
                CSSComputedProperties cSSComputedProperties;
                CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (cSSElement != this.getOwnerNode()) {
                    cSSComputedProperties = cSSElement.getComputedStyle(null);
                } else {
                    if (bl) return ComputedCSSStyle.asNumericValuePt(f *= this.getInitialFontSize() * 0.25f);
                    cSSComputedProperties = this;
                }
                f = cSSCanvas != null ? (f *= (float)cSSCanvas.stringWidth("0", cSSComputedProperties)) : (f *= cSSComputedProperties.getComputedFontSize() * 0.25f);
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 24) {
                ComputedCSSStyle computedCSSStyle;
                if (bl) {
                    computedCSSStyle = this.getParentComputedStyle();
                    if (computedCSSStyle == null) {
                        return ComputedCSSStyle.asNumericValuePt(f *= this.getInitialFontSize());
                    }
                } else {
                    computedCSSStyle = this;
                }
                f = cSSCanvas != null ? (f *= (float)cSSCanvas.stringWidth("\u6c34", computedCSSStyle)) : (f *= this.getComputedFontSize());
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 30) {
                CSSComputedProperties cSSComputedProperties;
                CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (cSSElement != this.getOwnerNode()) {
                    cSSComputedProperties = cSSElement.getComputedStyle(null);
                } else {
                    if (bl) return ComputedCSSStyle.asNumericValuePt(f *= this.getInitialFontSize());
                    cSSComputedProperties = this;
                }
                f = cSSCanvas != null ? (f *= (float)cSSCanvas.stringWidth("\u6c34", cSSComputedProperties)) : (f *= cSSComputedProperties.getComputedFontSize());
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 45) {
                f *= this.getInitialContainingBlockWidthPt(cSSCanvas, true) * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 41) {
                f *= this.getInitialContainingBlockHeightPt(cSSCanvas, true) * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 42) {
                String string = this.getCSSValue("writing-mode").getCssText();
                f = "horizontal-tb".equalsIgnoreCase(string) ? (f *= this.getInitialContainingBlockWidthPt(cSSCanvas, true)) : (f *= this.getInitialContainingBlockHeightPt(cSSCanvas, true));
                f *= 0.01f;
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 40) {
                String string = this.getCSSValue("writing-mode").getCssText();
                f = "horizontal-tb".equalsIgnoreCase(string) ? (f *= this.getInitialContainingBlockHeightPt(cSSCanvas, true)) : (f *= this.getInitialContainingBlockWidthPt(cSSCanvas, true));
                f *= 0.01f;
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 44) {
                float f4 = Math.min(this.getInitialContainingBlockWidthPt(cSSCanvas, true), this.getInitialContainingBlockHeightPt(cSSCanvas, true));
                f *= f4 * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(f);
            } else if (s == 43) {
                float f5 = Math.max(this.getInitialContainingBlockWidthPt(cSSCanvas, true), this.getInitialContainingBlockHeightPt(cSSCanvas, true));
                f *= f5 * 0.01f;
                return ComputedCSSStyle.asNumericValuePt(f);
            } else {
                f = NumberValue.floatValueConversion(f, s, (short)6);
            }
        }
        return ComputedCSSStyle.asNumericValuePt(f);
    }

    private float getInitialContainingBlockWidthPt(CSSCanvas cSSCanvas, boolean bl) throws StyleDatabaseRequiredException {
        String string;
        Object object;
        if (cSSCanvas != null && (object = cSSCanvas.getViewport()) != null) {
            float f = object.getViewportWidth();
            return NumberValue.floatValueConversion(f, this.getStyleDatabase().getNaturalUnit(), (short)6);
        }
        object = this.getStyleDatabase();
        if (object != null) {
            float f = object.getDeviceWidth();
            return NumberValue.floatValueConversion(f, object.getNaturalUnit(), (short)6);
        }
        if (bl && (string = this.getOwnerNode().getOwnerDocument().getTargetMedium()) != null) {
            if ("print".equals(string)) {
                return 595.0f;
            }
            if ("screen".equals(string)) {
                return 1440.0f;
            }
            if ("handheld".equals(string)) {
                return 270.0f;
            }
        }
        throw new StyleDatabaseRequiredException("Unit conversion failed.");
    }

    private float getInitialContainingBlockHeightPt(CSSCanvas cSSCanvas, boolean bl) throws StyleDatabaseRequiredException {
        String string;
        Object object;
        if (cSSCanvas != null && (object = cSSCanvas.getViewport()) != null) {
            float f = object.getViewportHeight();
            return NumberValue.floatValueConversion(f, this.getStyleDatabase().getNaturalUnit(), (short)6);
        }
        object = this.getStyleDatabase();
        if (object != null) {
            float f = object.getDeviceHeight();
            return NumberValue.floatValueConversion(f, object.getNaturalUnit(), (short)6);
        }
        if (bl && (string = this.getOwnerNode().getOwnerDocument().getTargetMedium()) != null) {
            if ("print".equals(string)) {
                return 842.0f;
            }
            if ("screen".equals(string)) {
                return 810.0f;
            }
            if ("handheld".equals(string)) {
                return 480.0f;
            }
        }
        throw new StyleDatabaseRequiredException("Unit conversion failed.");
    }

    private TypedValue computeColor(String string, ColorValue colorValue) {
        ColorValue colorValue2 = null;
        int n = colorValue.getColor().getLength();
        for (int i = 0; i < n; ++i) {
            PrimitiveValue primitiveValue = colorValue.getComponent(i);
            if (primitiveValue != null) {
                PercentageEvaluator percentageEvaluator;
                TypedValue typedValue = this.primitiveToTypedValue(string, primitiveValue);
                if (primitiveValue != typedValue) {
                    if (typedValue == null) {
                        return null;
                    }
                    if (colorValue2 == null) {
                        colorValue2 = colorValue.clone();
                    }
                    ((TypedValue)colorValue2).setComponent(i, typedValue);
                }
                if (typedValue.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
                    if (colorValue2 == null) {
                        colorValue2 = colorValue.clone();
                    }
                    percentageEvaluator = new PercentageEvaluator();
                    try {
                        typedValue = percentageEvaluator.evaluateExpression((ExpressionValue)typedValue);
                    }
                    catch (DOMException dOMException) {
                        this.computedStyleError(string, colorValue.getCssText(), "Could not evaluate expression value in color.", dOMException);
                        return null;
                    }
                    ((TypedValue)colorValue2).setComponent(i, typedValue);
                    continue;
                }
                if (typedValue.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) continue;
                if (colorValue2 == null) {
                    colorValue2 = colorValue.clone();
                }
                percentageEvaluator = new PercentageEvaluator();
                try {
                    typedValue = percentageEvaluator.evaluateFunction((CSSMathFunctionValue)((Object)typedValue));
                }
                catch (DOMException dOMException) {
                    this.computedStyleError(string, colorValue.getCssText(), "Could not evaluate math function in color.", dOMException);
                    return null;
                }
                ((TypedValue)colorValue2).setComponent(i, typedValue);
                continue;
            }
            primitiveValue = NumberValue.createCSSNumberValue((short)0, 0.0f);
            if (colorValue2 == null) {
                colorValue2 = colorValue.clone();
            }
            ((TypedValue)colorValue2).setComponent(i, primitiveValue);
        }
        return colorValue2 == null ? colorValue : colorValue2;
    }

    private TypedValue computeColorMix(String string, TypedValue typedValue, boolean bl) {
        Object object;
        PrimitiveValue primitiveValue;
        PrimitiveValue primitiveValue2;
        TypedValue typedValue2 = null;
        if ((typedValue = this.absolutizeComponents(string, typedValue, bl)) == null) {
            return null;
        }
        CSSColorMixFunction cSSColorMixFunction = (CSSColorMixFunction)((Object)typedValue);
        PrimitiveValue primitiveValue3 = (PrimitiveValue)cSSColorMixFunction.getColorValue1();
        PrimitiveValue primitiveValue4 = (PrimitiveValue)cSSColorMixFunction.getColorValue2();
        TypedValue typedValue3 = this.primitiveToTypedValue(string, primitiveValue3);
        TypedValue typedValue4 = this.primitiveToTypedValue(string, primitiveValue4);
        if (typedValue3 == null || typedValue4 == null) {
            return null;
        }
        typedValue3 = this.absolutizeComponents(string, typedValue3, bl);
        typedValue4 = this.absolutizeComponents(string, typedValue4, bl);
        if (typedValue3 != primitiveValue3) {
            typedValue2 = typedValue.clone();
            typedValue2.setComponent(0, typedValue3);
        }
        if (typedValue4 != primitiveValue4) {
            if (typedValue2 == null) {
                typedValue2 = typedValue.clone();
            }
            typedValue2.setComponent(2, typedValue4);
        }
        if ((primitiveValue2 = (PrimitiveValue)cSSColorMixFunction.getPercentage1()) != null) {
            primitiveValue = this.primitiveToTypedValue(string, primitiveValue2);
            if ((primitiveValue = this.absolutizeComponents(string, (TypedValue)primitiveValue, bl)) == null) {
                return null;
            }
            if (primitiveValue != primitiveValue2) {
                if (typedValue2 == null) {
                    typedValue2 = typedValue.clone();
                }
                typedValue2.setComponent(1, primitiveValue);
            }
        }
        if ((primitiveValue2 = (PrimitiveValue)cSSColorMixFunction.getPercentage2()) != null) {
            primitiveValue = this.primitiveToTypedValue(string, primitiveValue2);
            if (primitiveValue == null) {
                return null;
            }
            if ((primitiveValue = this.absolutizeComponents(string, (TypedValue)primitiveValue, bl)) != primitiveValue2) {
                if (typedValue2 == null) {
                    typedValue2 = typedValue.clone();
                }
                typedValue2.setComponent(3, primitiveValue);
            }
        }
        if ((primitiveValue = (PrimitiveValue)typedValue.getComponent(4)) != null) {
            if (typedValue2 == null) {
                typedValue2 = typedValue.clone();
            }
            if ((object = this.primitiveToTypedValue(string, primitiveValue)) == null || ((PrimitiveValue)object).getPrimitiveType() != CSSValue.Type.IDENT) {
                return null;
            }
            typedValue2.setComponent(4, (StyleValue)object);
        }
        cSSColorMixFunction = (CSSColorMixFunction)((Object)(typedValue2 == null ? typedValue : typedValue2));
        object = cSSColorMixFunction.getColor();
        typedValue = object != null ? (TypedValue)((Object)object.packInValue()) : null;
        return typedValue;
    }

    private TypedValue absolutizeComponents(String string, TypedValue typedValue, boolean bl) {
        TypedValue typedValue2 = null;
        int n = typedValue.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Evaluator evaluator;
            CSSTypedValue cSSTypedValue;
            StyleValue styleValue = typedValue.getComponent(i);
            if (styleValue == null) continue;
            StyleValue styleValue2 = this.replaceProxyValues(string, styleValue);
            if (styleValue2 == null) {
                return null;
            }
            if ((styleValue2 = this.absoluteValue(string, styleValue2, bl)) != styleValue) {
                if (styleValue2 == null) {
                    return null;
                }
                if (typedValue2 == null) {
                    typedValue2 = typedValue.clone();
                }
                typedValue2.setComponent(i, styleValue2);
            }
            if (styleValue2.getPrimitiveType() == CSSValue.Type.EXPRESSION) {
                if (typedValue2 == null) {
                    typedValue2 = typedValue.clone();
                }
                cSSTypedValue = (ExpressionValue)styleValue2;
                evaluator = new MyEvaluator(string);
                try {
                    styleValue = evaluator.evaluateExpression((ExpressionValue)cSSTypedValue);
                    typedValue2.setComponent(i, styleValue);
                }
                catch (RuntimeException runtimeException) {
                    this.computedStyleWarning(string, cSSTypedValue, "Could not evaluate expression value.", runtimeException);
                    cSSTypedValue = ((ExpressionValue)cSSTypedValue).clone();
                    try {
                        this.absoluteExpressionValue(string, ((ExpressionValue)cSSTypedValue).getExpression(), bl);
                        typedValue2.setComponent(i, (StyleValue)((Object)cSSTypedValue));
                    }
                    catch (RuntimeException runtimeException2) {}
                }
                continue;
            }
            if (styleValue2.getPrimitiveType() != CSSValue.Type.MATH_FUNCTION) continue;
            if (typedValue2 == null) {
                typedValue2 = typedValue.clone();
            }
            cSSTypedValue = (CSSMathFunctionValue)((Object)styleValue2);
            evaluator = new PercentageEvaluator();
            try {
                styleValue = evaluator.evaluateFunction((CSSMathFunctionValue)cSSTypedValue);
                typedValue2.setComponent(i, styleValue);
                continue;
            }
            catch (RuntimeException runtimeException) {
                this.computedStyleWarning(string, cSSTypedValue, "Could not evaluate math function.", runtimeException);
                cSSTypedValue = cSSTypedValue.clone();
                LinkedCSSValueList linkedCSSValueList = cSSTypedValue.getArguments();
                int n2 = linkedCSSValueList.size();
                int n3 = 0;
                while (i < n2) {
                    try {
                        linkedCSSValueList.set(n3, this.absoluteValue(string, (StyleValue)linkedCSSValueList.get(n3), bl));
                    }
                    catch (RuntimeException runtimeException3) {
                        // empty catch block
                    }
                    ++i;
                }
                try {
                    typedValue2.setComponent(i, (StyleValue)((Object)cSSTypedValue));
                    continue;
                }
                catch (RuntimeException runtimeException4) {
                    // empty catch block
                }
            }
        }
        return typedValue2 == null ? typedValue : typedValue2;
    }

    private void absoluteExpressionValue(String string, CSSExpression cSSExpression, boolean bl) throws DOMException {
        switch (cSSExpression.getPartType()) {
            case SUM: 
            case PRODUCT: {
                AlgebraicExpression algebraicExpression = (AlgebraicExpression)cSSExpression;
                int n = algebraicExpression.getLength();
                for (int i = 0; i < n; ++i) {
                    CSSExpression cSSExpression2 = algebraicExpression.item(i);
                    this.absoluteExpressionValue(string, cSSExpression2, bl);
                }
                break;
            }
            case OPERAND: {
                CSSOperandExpression cSSOperandExpression = (CSSOperandExpression)cSSExpression;
                StyleValue styleValue = (StyleValue)((Object)cSSOperandExpression.getOperand());
                if (styleValue.getCssValueType() == CSSValue.CssType.PROXY) {
                    styleValue = this.replaceProxyValue(string, styleValue);
                }
                if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                    throw new DOMException(15, "Unexpected value in expression: " + styleValue.getCssText());
                }
                TypedValue typedValue = this.absoluteTypedValue(string, (TypedValue)styleValue, bl);
                cSSOperandExpression.setOperand(typedValue);
            }
        }
    }

    private StyleValue computeAttribute(String string, AttrValue attrValue) throws DOMException {
        String string2 = attrValue.getAttributeName();
        CSSElement cSSElement = this.getOwnerNode();
        String string3 = cSSElement.getAttribute(string2);
        String string4 = attrValue.getAttributeType();
        if (string3.length() != 0) {
            if (this.isSafeAttrName(string, cSSElement, string2)) {
                if (string4 == null || "string".equalsIgnoreCase(string4)) {
                    StringValue stringValue = new StringValue(2);
                    stringValue.setStringValue(CSSValue.Type.STRING, string3);
                    return stringValue;
                }
                string3 = string3.trim();
                if ("url".equalsIgnoreCase(string4)) {
                    try {
                        URL uRL = this.getOwnerNode().getOwnerDocument().getURL(string3);
                        URIValue uRIValue = new URIValue(2);
                        uRIValue.setStringValue(CSSValue.Type.URI, uRL.toExternalForm());
                        return uRIValue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.computedStyleError(string, attrValue.getCssText(), "Error building URL from attribute '" + string2 + "', value: " + string3, malformedURLException);
                    }
                } else {
                    StyleValue styleValue;
                    ValueFactory valueFactory = this.getValueFactory();
                    try {
                        styleValue = valueFactory.parseProperty(string3);
                    }
                    catch (DOMException dOMException) {
                        this.computedStyleError(string, attrValue.getCssText(), "Error parsing attribute '" + string2 + "', value: " + string3, dOMException);
                        return this.computeAttrFallback(string, attrValue);
                    }
                    this.addAttrNameGuard(string2);
                    try {
                        styleValue = this.replaceProxyValues(string, styleValue);
                    }
                    catch (Exception exception) {
                        this.computedStyleError(string, attrValue.getCssText(), "Circularity: " + attrValue.getCssText() + " references " + styleValue.getCssText(), exception);
                        StyleValue styleValue2 = this.computeAttrFallback(string, attrValue);
                        this.removeAttrNameGuard(string2);
                        return styleValue2;
                    }
                    this.removeAttrNameGuard(string2);
                    if (styleValue != null) {
                        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                            TypedValue typedValue = (TypedValue)styleValue;
                            if ((typedValue = this.absoluteTypedValue(string, typedValue, false)) != null) {
                                try {
                                    styleValue = this.attrValueOfType(typedValue, string4);
                                    if (styleValue != null) {
                                        return styleValue;
                                    }
                                    this.computedStyleError(string, attrValue.getCssText(), "Attribute value does not match type (" + string4 + ").");
                                }
                                catch (DOMException dOMException) {
                                    this.computedStyleError(string, attrValue.getCssText(), "Attribute value does not match type (" + string4 + ").", dOMException);
                                }
                            }
                        } else {
                            this.computedStyleWarning(string, attrValue, "Invalid attribute value.");
                        }
                    }
                }
            } else {
                this.computedStyleError(string, attrValue.getCssText(), "Unsafe attribute name");
            }
        }
        return this.computeAttrFallback(string, attrValue);
    }

    private StyleValue computeAttrFallback(String string, AttrValue attrValue) throws DOMException {
        Object object;
        String string2 = attrValue.getAttributeType();
        StyleValue styleValue = attrValue.getFallback();
        if (styleValue != null && styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            object = attrValue.getAttributeName();
            this.addAttrNameGuard((String)object);
            styleValue = this.replaceProxyValues(string, styleValue);
            if (styleValue != null && styleValue.getCssValueType() == CSSValue.CssType.PROXY) {
                styleValue = this.replaceProxyValues(string, styleValue);
            }
            this.removeAttrNameGuard((String)object);
        }
        if (styleValue == null) {
            if (this.attrValueStack != null && !this.attrValueStack.isEmpty()) {
                throw new DOMException(15, "No explicit fallback and we are in recursive attr(), forbidden by CSS.");
            }
            object = AttrValue.defaultFallback(string2);
            if (object != null && "color".equalsIgnoreCase(string2)) {
                object = this.colorValue("", (TypedValue)object);
            }
            return object;
        }
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            return styleValue;
        }
        object = (TypedValue)styleValue;
        if (((PrimitiveValue)object).getPrimitiveType() == CSSValue.Type.STRING && "url".equalsIgnoreCase(string2)) {
            try {
                URL uRL = this.getOwnerNode().getOwnerDocument().getURL(((TypedValue)object).getStringValue());
                URIValue uRIValue = new URIValue(2);
                uRIValue.setStringValue(CSSValue.Type.URI, uRL.toExternalForm());
                return uRIValue;
            }
            catch (MalformedURLException malformedURLException) {
                this.computedStyleError(string, attrValue.getCssText(), "Error building URL from attr() fallback: " + ((StyleValue)object).getCssText(), malformedURLException);
                object = null;
            }
        } else if ("color".equalsIgnoreCase(string2)) {
            object = this.colorValue("", (TypedValue)object);
        }
        return object;
    }

    private boolean isSafeAttrName(String string, CSSElement cSSElement, String string2) {
        String string3;
        return "content".equals(string) || !string2.contains("nonce") && !string2.contains("pass") && !string2.contains("pwd") && !string2.contains("user") && !string2.contains("uid") && !string2.contains("session") && !string2.contains("secret") && (!"input".equalsIgnoreCase(string3 = cSSElement.getTagName()) || !string2.equalsIgnoreCase("value")) && !"meta".equals(string3) && !"link".equals(string3);
    }

    private void addAttrNameGuard(String string) {
        if (this.attrValueStack == null) {
            this.attrValueStack = new LinkedList();
        } else if (this.attrValueStack.contains(string)) {
            this.attrValueStack.clear();
            throw new DOMException(15, "Recursive use of attribute " + string + " in computed style.");
        }
        this.attrValueStack.add(string);
    }

    private void removeAttrNameGuard(String string) {
        this.attrValueStack.remove(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypedValue attrValueOfType(TypedValue typedValue, String string) throws DOMException {
        TypedValue typedValue2 = null;
        if ("color".equalsIgnoreCase(string)) {
            if ((typedValue = this.colorValue("", typedValue)).getPrimitiveType() != CSSValue.Type.COLOR) return typedValue2;
            return typedValue;
        }
        short s = typedValue.getUnitType();
        if ("number".equalsIgnoreCase(string)) {
            if (s != 0) return typedValue2;
            return typedValue;
        }
        if ("integer".equalsIgnoreCase(string)) {
            float f;
            if (s != 0) return typedValue2;
            float f2 = typedValue.getFloatValue(s);
            if (!((double)Math.abs(f - (float)Math.round(f2)) < 7.0E-6)) return typedValue2;
            return typedValue;
        }
        if ("percentage".equals(string)) {
            if (s == 0) {
                float f = typedValue.getFloatValue((short)0);
                typedValue.setFloatValue((short)2, f);
                return typedValue;
            }
            if (s != 2) return typedValue2;
            return typedValue;
        }
        if ("ident".equalsIgnoreCase(string)) {
            if (typedValue.getPrimitiveType() != CSSValue.Type.IDENT) return typedValue2;
            return typedValue;
        }
        if ("length".equalsIgnoreCase(string)) {
            if (!CSSUnit.isLengthUnitType(s)) return typedValue2;
            return typedValue;
        }
        if ("angle".equalsIgnoreCase(string)) {
            if (!CSSUnit.isAngleUnitType(s)) return typedValue2;
            return typedValue;
        }
        if ("time".equalsIgnoreCase(string)) {
            if (s == 90) return typedValue;
            if (s != 91) return typedValue2;
            return typedValue;
        }
        if ("frequency".equalsIgnoreCase(string)) {
            if (s == 100) return typedValue;
            if (s != 101) return typedValue2;
            return typedValue;
        }
        if (s != 0) throw new DOMException(15, "Unknown attribute type '" + string + "' found in computed style.");
        float f = typedValue.getFloatValue(s);
        String string2 = string.toLowerCase(Locale.ROOT).intern();
        short s2 = ParseHelper.unitFromString(string2);
        if (s2 == 1) throw new DOMException(15, "Unknown attribute type '" + string + "' found in computed style.");
        return NumberValue.createCSSNumberValue(s2, f);
    }

    private StyleValue evaluateVarValue(String string, VarValue varValue) {
        StyleValue styleValue;
        LexicalValue lexicalValue;
        String string2 = varValue.getName();
        if (!ComputedCSSStyle.isCustomPropertyName(string2)) {
            this.computedStyleError(string, varValue.getCssText(), "var() references non-custom property: " + string2);
            return null;
        }
        if (this.customPropertyStack == null) {
            this.customPropertyStack = new LinkedList();
        } else if (this.customPropertyStack.contains(string2)) {
            this.computedStyleError(string, varValue.getCssText(), "var() dependency loop in " + string2);
            LexicalUnit lexicalUnit = varValue.getFallback();
            if (lexicalUnit != null) {
                StyleValue styleValue2;
                try {
                    styleValue2 = this.customPropertyFallback(string, varValue, lexicalUnit);
                }
                catch (Exception exception) {
                    styleValue2 = null;
                }
                return styleValue2;
            }
            return null;
        }
        this.customPropertyStack.add(string2);
        CSSPropertyDefinition cSSPropertyDefinition = this.getOwnerSheet().getPropertyDefinition(string2);
        boolean bl = cSSPropertyDefinition == null || cSSPropertyDefinition.inherits();
        CounterRef counterRef = new CounterRef();
        try {
            lexicalValue = this.getCustomPropertyValue(string2, bl, counterRef);
        }
        catch (Exception exception) {
            this.computedStyleError(string, varValue.getCssText(), null, exception);
            lexicalValue = null;
        }
        try {
            if (lexicalValue == null) {
                LexicalUnit lexicalUnit = varValue.getFallback();
                if (lexicalUnit == null) {
                    if (cSSPropertyDefinition == null) {
                        this.customPropertyStack.remove(string2);
                        return null;
                    }
                    lexicalUnit = cSSPropertyDefinition.getInitialValue().getLexicalUnit();
                }
                styleValue = this.customPropertyFallback(string, varValue, lexicalUnit);
            } else {
                styleValue = this.evaluateLexicalValue(string, lexicalValue, counterRef);
                if (styleValue != null && styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                    try {
                        styleValue = this.absoluteValue(string, styleValue, false);
                    }
                    catch (DOMException dOMException) {
                        this.computedStyleError(string, styleValue.getCssText(), null, dOMException);
                        styleValue = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            this.computedStyleError(string, varValue.getCssText(), null, exception);
            styleValue = null;
        }
        this.customPropertyStack.remove(string2);
        styleValue = this.enforceExpectIntegerFromProxy(string, varValue, styleValue);
        return styleValue;
    }

    private StyleValue enforceExpectIntegerFromProxy(String string, ProxyValue proxyValue, StyleValue styleValue) {
        if (proxyValue.isExpectingInteger()) {
            if (styleValue.isPrimitiveValue()) {
                try {
                    ((CSSPrimitiveValue)((Object)styleValue)).setExpectInteger();
                }
                catch (DOMException dOMException) {
                    this.computedStyleError(string, styleValue.getCssText(), null, dOMException);
                    styleValue = null;
                }
            } else if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
                this.computedStyleError(string, styleValue.getCssText(), "Expected an integer, found a LIST.");
                styleValue = null;
            }
        }
        return styleValue;
    }

    private StyleValue customPropertyFallback(String string, ProxyValue proxyValue, LexicalUnit lexicalUnit) throws DOMException {
        StyleValue styleValue = this.getValueFactory().createCSSValue(lexicalUnit, this);
        if (styleValue != null) {
            styleValue = this.enforceExpectIntegerFromProxy(string, proxyValue, styleValue);
        }
        return styleValue;
    }

    private StyleValue evaluateLexicalValue(String string, LexicalValue lexicalValue, CounterRef counterRef) {
        LexicalUnit lexicalUnit;
        if (this.customPropertyStack == null) {
            this.customPropertyStack = new LinkedList();
        }
        LexicalUnit lexicalUnit2 = lexicalValue.getLexicalUnit().clone();
        try {
            lexicalUnit = this.replaceLexicalProxy(string, lexicalUnit2, counterRef);
        }
        catch (CSSResourceLimitException cSSResourceLimitException) {
            throw cSSResourceLimitException;
        }
        catch (DOMException dOMException) {
            this.computedStyleError(string, lexicalUnit2.toString(), "Problem evaluating lexical value.", dOMException);
            return null;
        }
        StyleValue styleValue = null;
        if (lexicalUnit != null) {
            try {
                styleValue = this.getValueFactory().createCSSValue(lexicalUnit, this);
            }
            catch (DOMException dOMException) {
                LexicalValue lexicalValue2 = new LexicalValue();
                lexicalValue2.setLexicalUnit(lexicalUnit);
                styleValue = lexicalValue2;
            }
        }
        styleValue = this.enforceExpectIntegerFromProxy(string, lexicalValue, styleValue);
        return styleValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LexicalUnit replaceLexicalProxy(String string, LexicalUnit lexicalUnit, CounterRef counterRef) throws DOMException {
        int n = 282624;
        LexicalUnit lexicalUnit2 = lexicalUnit;
        do {
            LexicalUnit lexicalUnit3;
            LexicalUnit lexicalUnit4;
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                boolean bl;
                lexicalUnit4 = lexicalUnit2.getParameters();
                String string2 = lexicalUnit4.getStringValue();
                if ((lexicalUnit4 = lexicalUnit4.getNextLexicalUnit()) != null) {
                    lexicalUnit4 = lexicalUnit4.getNextLexicalUnit();
                }
                if (this.customPropertyStack.contains(string2)) {
                    if (lexicalUnit4 == null) throw new DOMException(15, "Circularity evaluating custom property " + string2);
                    this.computedStyleError(string, lexicalUnit.toString(), "Circularity evaluating lexical value.");
                    if (!counterRef.increment()) {
                        throw new CSSResourceLimitException("Resource limit hit while replacing custom property: " + string2);
                    }
                    lexicalUnit3 = this.replaceLexicalProxy(string, lexicalUnit4.clone(), counterRef);
                } else {
                    lexicalUnit3 = this.getCustomPropertyValueOrFallback(string, string2, lexicalUnit4, counterRef);
                    while (lexicalUnit3 != null && lexicalUnit3.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                        LexicalUnit lexicalUnit5 = lexicalUnit3.getParameters();
                        String string3 = lexicalUnit5.getStringValue();
                        if ((lexicalUnit5 = lexicalUnit5.getNextLexicalUnit()) != null) {
                            lexicalUnit5 = lexicalUnit5.getNextLexicalUnit();
                        }
                        if (!counterRef.increment()) {
                            throw new CSSResourceLimitException("Resource limit hit while replacing custom property: " + string);
                        }
                        lexicalUnit3 = this.getCustomPropertyValueOrFallback(string, string3, lexicalUnit5, counterRef);
                    }
                }
                boolean bl2 = bl = lexicalUnit2 == lexicalUnit;
                if (lexicalUnit3 == null) {
                    lexicalUnit2 = lexicalUnit2.remove();
                    if (!bl) continue;
                    lexicalUnit = lexicalUnit2;
                    continue;
                }
                if (lexicalUnit3.getLexicalUnitType() != LexicalUnit.LexicalType.EMPTY) {
                    try {
                        counterRef.replaceCounter += lexicalUnit2.countReplaceBy(lexicalUnit3);
                    }
                    catch (CSSBudgetException cSSBudgetException) {
                        CSSResourceLimitException cSSResourceLimitException = new CSSResourceLimitException("Resource limit hit while replacing custom property " + string2);
                        cSSResourceLimitException.initCause(cSSBudgetException);
                        throw cSSResourceLimitException;
                    }
                    lexicalUnit2 = lexicalUnit3;
                    if (bl) {
                        lexicalUnit = lexicalUnit3;
                    }
                    if (counterRef.replaceCounter < 282624) continue;
                    throw new CSSResourceLimitException("Resource limit hit while replacing custom property " + string2);
                }
                lexicalUnit2 = lexicalUnit2.remove();
                if (!bl) continue;
                lexicalUnit = lexicalUnit2;
                continue;
            }
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.ATTR) {
                boolean bl = lexicalUnit2 == lexicalUnit;
                lexicalUnit4 = this.replacementAttrUnit(string, lexicalUnit2, counterRef);
                try {
                    counterRef.replaceCounter += lexicalUnit2.countReplaceBy(lexicalUnit4);
                }
                catch (CSSBudgetException cSSBudgetException) {
                    CSSResourceLimitException cSSResourceLimitException = new CSSResourceLimitException("Resource limit hit while replacing attr() property " + string);
                    cSSResourceLimitException.initCause(cSSBudgetException);
                    throw cSSResourceLimitException;
                }
                if (counterRef.replaceCounter >= 282624) {
                    throw new CSSResourceLimitException("Resource limit hit while replacing attr() property " + string);
                }
                if (bl) {
                    lexicalUnit = lexicalUnit4;
                }
                lexicalUnit2 = lexicalUnit4;
                continue;
            }
            lexicalUnit3 = lexicalUnit2.getParameters();
            if (lexicalUnit3 != null) {
                this.replaceLexicalProxy(string, lexicalUnit3, counterRef);
            } else {
                lexicalUnit3 = lexicalUnit2.getSubValues();
                if (lexicalUnit3 != null) {
                    this.replaceLexicalProxy(string, lexicalUnit3, counterRef);
                }
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
        } while (lexicalUnit2 != null);
        return lexicalUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LexicalUnit getCustomPropertyValueOrFallback(String string, String string2, LexicalUnit lexicalUnit, CounterRef counterRef) throws DOMException {
        Object object;
        CSSPropertyDefinition cSSPropertyDefinition = this.getOwnerSheet().getPropertyDefinition(string2);
        boolean bl = cSSPropertyDefinition == null || cSSPropertyDefinition.inherits();
        Exception exception = null;
        this.customPropertyStack.add(string2);
        try {
            object = this.getCustomPropertyValue(string2, bl, counterRef);
            if (object != null) {
                LexicalUnit lexicalUnit2 = ((LexicalValue)object).getLexicalUnit();
                this.customPropertyStack.remove(string2);
                if (counterRef.increment()) {
                    return lexicalUnit2;
                }
                exception = new CSSResourceLimitException("Resource limit hit while replacing custom property: " + string2);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (lexicalUnit != null) {
            try {
                lexicalUnit = this.replaceLexicalProxy(string, lexicalUnit.clone(), counterRef);
                if (counterRef.increment()) {
                    if (exception != null) {
                        this.computedStyleError(string, null, "Circularity error evaluating custom property " + string2);
                    }
                    object = lexicalUnit;
                    return object;
                }
                try {
                    throw new CSSResourceLimitException("Resource limit hit while replacing custom property: " + string2);
                }
                catch (CSSResourceLimitException cSSResourceLimitException) {
                    throw cSSResourceLimitException;
                }
                catch (DOMException dOMException) {
                    exception = dOMException;
                }
            }
            finally {
                this.customPropertyStack.remove(string2);
            }
        }
        if (exception != null) {
            if (exception.getClass() == CSSResourceLimitException.class) {
                throw (CSSResourceLimitException)exception;
            }
            object = new DOMException(15, "Unable to evaluate custom property " + string2);
            ((Throwable)object).initCause(exception);
            throw object;
        }
        if (cSSPropertyDefinition != null) {
            return cSSPropertyDefinition.getInitialValue().getLexicalUnit();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LexicalUnit replacementAttrUnit(String string, LexicalUnit lexicalUnit, CounterRef counterRef) throws DOMException {
        LexicalUnit lexicalUnit2;
        CSSElement cSSElement;
        String string2;
        String string3;
        String string4;
        LexicalUnit lexicalUnit3;
        block28: {
            block27: {
                lexicalUnit3 = lexicalUnit.getParameters();
                if (lexicalUnit3.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                    this.computedStyleError(string, lexicalUnit.getCssText(), "Unexpected attribute name: " + lexicalUnit3.getCssText());
                    return null;
                }
                string4 = lexicalUnit3.getStringValue();
                if ((lexicalUnit3 = lexicalUnit3.getNextLexicalUnit()) == null) break block27;
                if (lexicalUnit3.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    switch (lexicalUnit3.getLexicalUnitType()) {
                        case IDENT: {
                            string3 = lexicalUnit3.getStringValue().toLowerCase(Locale.ROOT);
                            break;
                        }
                        case OPERATOR_MOD: {
                            string3 = "%";
                            break;
                        }
                        default: {
                            this.computedStyleError(string, lexicalUnit.getCssText(), "Unexpected attribute type: " + lexicalUnit3.getCssText());
                            return null;
                        }
                    }
                    lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    if (lexicalUnit3 != null) {
                        if (lexicalUnit3.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            this.computedStyleError(string, lexicalUnit.getCssText(), "Expected comma, found: " + lexicalUnit3.getCssText());
                            return null;
                        }
                        lexicalUnit3 = lexicalUnit3.getNextLexicalUnit();
                    }
                    break block28;
                } else {
                    if ((lexicalUnit3 = lexicalUnit3.getNextLexicalUnit()) == null) {
                        this.computedStyleError(string, lexicalUnit.getCssText(), "Unexpected end after comma.");
                        return null;
                    }
                    string3 = null;
                }
                break block28;
            }
            string3 = null;
        }
        if ((string2 = (cSSElement = this.getOwnerNode()).getAttribute(string4)).length() == 0) return this.safeReplaceLexicalAttr(string, string4, lexicalUnit3, counterRef);
        if (!this.isSafeAttrName(string, cSSElement, string4)) {
            this.computedStyleError(string, lexicalUnit.getCssText(), "Unsafe attribute name: " + string4);
            return this.safeReplaceLexicalAttr(string, string4, lexicalUnit3, counterRef);
        }
        Parser parser = this.getStyleSheetFactory().createSACParser();
        if (string3 == null || "string".equals(string3)) {
            LexicalUnit lexicalUnit4;
            String string5 = ParseHelper.quote(string2, '\"');
            try {
                lexicalUnit4 = parser.parsePropertyValue(new StringReader(string5));
                return this.safeReplaceLexicalAttr(string, string4, lexicalUnit4, counterRef);
            }
            catch (IOException iOException) {
                lexicalUnit4 = null;
                return this.safeReplaceLexicalAttr(string, string4, lexicalUnit4, counterRef);
            }
            catch (CSSParseException cSSParseException) {
                this.computedStyleError(string, lexicalUnit.getCssText(), "Unexpected error parsing: " + string5.substring(0, Math.min(string5.length(), 255)), cSSParseException);
                lexicalUnit4 = lexicalUnit3;
            }
            return this.safeReplaceLexicalAttr(string, string4, lexicalUnit4, counterRef);
        }
        string2 = string2.trim();
        if ("url".equals(string3)) {
            String string6 = "url(" + ParseHelper.quote(string2, '\"') + ')';
            try {
                return parser.parsePropertyValue(new StringReader(string6));
            }
            catch (IOException iOException) {
                return null;
            }
            catch (CSSParseException cSSParseException) {
                this.computedStyleError(string, lexicalUnit.getCssText(), "Unexpected error parsing: " + string6.substring(0, Math.min(string6.length(), 255)), cSSParseException);
                return this.safeReplaceLexicalAttr(string, string4, lexicalUnit3, counterRef);
            }
        }
        if (string3.length() <= 2 || ParseHelper.unitFromString(string3 = string3.intern()) != 1) {
            string2 = string2 + string3;
        }
        try {
            lexicalUnit2 = parser.parsePropertyValue(new StringReader(string2));
        }
        catch (IOException iOException) {
            lexicalUnit2 = null;
        }
        catch (CSSParseException cSSParseException) {
            this.computedStyleError(string, lexicalUnit.getCssText(), "Error parsing attribute '" + string4 + "', value: " + string2, cSSParseException);
            return this.safeReplaceLexicalAttr(string, string4, lexicalUnit3, counterRef);
        }
        this.addAttrNameGuard(string4);
        try {
            lexicalUnit2 = this.replaceLexicalProxy(string, lexicalUnit2, counterRef);
        }
        catch (Exception exception) {
            this.computedStyleError(string, lexicalUnit.getCssText(), "Circularity: " + lexicalUnit.getCssText() + " references " + lexicalUnit2.getCssText(), exception);
            lexicalUnit2 = null;
        }
        if (lexicalUnit2 != null) {
            lexicalUnit2 = this.replaceLexicalProxy(string, lexicalUnit2, counterRef);
            this.removeAttrNameGuard(string4);
            if (string3.length() <= 2) return lexicalUnit2;
            if (ComputedCSSStyle.unitMatchesAttrType(lexicalUnit2, string3)) return lexicalUnit2;
            lexicalUnit2 = null;
            this.computedStyleError(string, lexicalUnit.getCssText(), "Attribute value does not match type (" + string3 + ").");
            return this.safeReplaceLexicalAttr(string, string4, lexicalUnit3, counterRef);
        }
        if (lexicalUnit3 != null) {
            lexicalUnit2 = this.replaceLexicalProxy(string, lexicalUnit3.clone(), counterRef);
        }
        this.removeAttrNameGuard(string4);
        return lexicalUnit2;
    }

    private LexicalUnit safeReplaceLexicalAttr(String string, String string2, LexicalUnit lexicalUnit, CounterRef counterRef) {
        this.addAttrNameGuard(string2);
        if (lexicalUnit != null) {
            lexicalUnit = this.replaceLexicalProxy(string, lexicalUnit.clone(), counterRef);
        }
        this.removeAttrNameGuard(string2);
        return lexicalUnit;
    }

    private static boolean unitMatchesAttrType(LexicalUnit lexicalUnit, String string) {
        CSSValueSyntax cSSValueSyntax;
        int n = string.length();
        if (n == 1) {
            return "%".equals(string) && lexicalUnit.getCssUnit() == 2;
        }
        if (n == 2) {
            return string.equalsIgnoreCase(lexicalUnit.getDimensionUnitText());
        }
        if ("ident".equalsIgnoreCase(string)) {
            string = "custom-ident";
        }
        if ((cSSValueSyntax = SyntaxParser.createSimpleSyntax(string)) == null) {
            return string.equalsIgnoreCase(lexicalUnit.getDimensionUnitText());
        }
        return lexicalUnit.matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.STRING && string.equals("url");
    }

    private StyleValue computeEnv(String string, EnvVariableValue envVariableValue) {
        StyleValue styleValue;
        if (this.getStyleDatabase() != null && (styleValue = (StyleValue)this.getStyleDatabase().getEnvValue(envVariableValue.getName())) != null) {
            return styleValue;
        }
        styleValue = envVariableValue.getFallback();
        if (styleValue == null) {
            this.computedStyleError(string, envVariableValue.getCssText(), "Unable to evaluate env() value for: " + envVariableValue.getName());
        }
        return styleValue;
    }

    private TypedValue getFontSizeValue() {
        StyleValue styleValue = super.getCSSValue("font-size");
        if (styleValue != null && styleValue.getPrimitiveType() == CSSValue.Type.UNSET) {
            styleValue = null;
        }
        if ((styleValue = ComputedCSSStyle.inheritValue(this, "font-size", styleValue, true)) != null && styleValue.getPrimitiveType() == CSSValue.Type.INHERIT) {
            styleValue = null;
        }
        if (styleValue == null || styleValue.getPrimitiveType() == CSSValue.Type.INITIAL) {
            return new IdentifierValue("medium");
        }
        return this.absoluteFontSizeValue(styleValue, false);
    }

    private TypedValue absoluteFontSizeValue(StyleValue styleValue, boolean bl) {
        TypedValue typedValue;
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED && (typedValue = this.absoluteFontSizeTyped((TypedValue)styleValue, bl)) != null) {
            return typedValue;
        }
        if (styleValue.getPrimitiveType() != CSSValue.Type.INITIAL && styleValue.getPrimitiveType() != CSSValue.Type.INTERNAL) {
            StyleValue styleValue2;
            typedValue = null;
            ComputedCSSStyle computedCSSStyle = this;
            while (((styleValue2 = ComputedCSSStyle.inheritValue(computedCSSStyle, "font-size", typedValue, true)) == null || (typedValue = this.absoluteFontSizeValue(styleValue2, bl)) == null) && (computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) {
            }
            if (typedValue != null) {
                return typedValue;
            }
            this.reportFontSizeError(styleValue, "Could not compute font-size from " + styleValue.getCssText());
        }
        if (bl) {
            float f = this.getInitialFontSize();
            return ComputedCSSStyle.asNumericValuePt(f);
        }
        return new IdentifierValue("medium");
    }

    private TypedValue absoluteFontSizeTyped(TypedValue typedValue, boolean bl) {
        switch (typedValue.getPrimitiveType()) {
            case IDENT: {
                String string = typedValue.getStringValue();
                String string2 = this.getUsedFontFamily();
                if ("larger".equalsIgnoreCase(string)) {
                    typedValue = this.getLargerFontSize(string2);
                } else if ("smaller".equalsIgnoreCase(string)) {
                    typedValue = this.getSmallerFontSize(string2);
                }
                return typedValue;
            }
            case EXPRESSION: {
                typedValue = typedValue.clone();
                ExpressionValue expressionValue = (ExpressionValue)typedValue;
                this.absoluteExpressionValue("font-size", expressionValue.getExpression(), true);
                FontEvaluator fontEvaluator = new FontEvaluator();
                try {
                    typedValue = fontEvaluator.evaluateExpression(expressionValue);
                }
                catch (DOMException dOMException) {
                    this.computedStyleError("font-size", expressionValue.getCssText(), "Could not evaluate expression value.", dOMException);
                    break;
                }
                return typedValue;
            }
            case MATH_FUNCTION: {
                CSSMathFunctionValue cSSMathFunctionValue = (CSSMathFunctionValue)((Object)typedValue);
                cSSMathFunctionValue = cSSMathFunctionValue.clone();
                LinkedCSSValueList linkedCSSValueList = cSSMathFunctionValue.getArguments();
                int n = linkedCSSValueList.size();
                for (int i = 0; i < n; ++i) {
                    linkedCSSValueList.set(i, this.absoluteFontSizeValue((StyleValue)linkedCSSValueList.get(i), true));
                }
                FontEvaluator fontEvaluator = new FontEvaluator();
                try {
                    typedValue = fontEvaluator.evaluateFunction(cSSMathFunctionValue);
                }
                catch (DOMException dOMException) {
                    this.computedStyleError("font-size", cSSMathFunctionValue.getCssText(), "Could not evaluate function value.", dOMException);
                    break;
                }
                return typedValue;
            }
            case NUMERIC: {
                return this.absoluteFontSizeNumeric(typedValue, bl);
            }
            default: {
                String string = typedValue.getCssText();
                this.computedStyleError("font-size", string, "Unable to convert to absolute length.");
            }
        }
        float f = this.getInitialFontSize();
        f = (float)Math.round(f * 100.0f) * 0.01f;
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValuePt(f);
        numberValue.setSubproperty(typedValue.isSubproperty());
        numberValue.setAbsolutizedUnit();
        return numberValue;
    }

    private TypedValue absoluteFontSizeNumeric(TypedValue typedValue, boolean bl) {
        float f;
        switch (typedValue.getUnitType()) {
            case 20: {
                float f2 = typedValue.getFloatValue((short)20);
                return this.getRelativeFontSize(typedValue, f2, bl);
            }
            case 21: {
                float f3 = typedValue.getFloatValue((short)21);
                ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
                if (computedCSSStyle == null) {
                    f = this.getInitialFontSize() * 0.5f * f3;
                    break;
                }
                if (this.getStyleDatabase() != null) {
                    f = this.getStyleDatabase().getExSizeInPt(computedCSSStyle.getUsedFontFamily(), computedCSSStyle.getComputedFontSize()) * f3;
                    break;
                }
                if (bl) {
                    f3 = 0.5f * f3;
                    return this.getRelativeFontSize(typedValue, f3, bl);
                }
                return typedValue;
            }
            case 26: {
                float f3 = typedValue.getFloatValue((short)26);
                CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (cSSElement != this.getOwnerNode()) {
                    f = cSSElement.getComputedStyle(null).getComputedFontSize();
                } else if (bl) {
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'rem'.");
                    f = this.getInitialFontSize();
                } else {
                    return typedValue;
                }
                f *= f3;
                break;
            }
            case 28: {
                float f3 = typedValue.getFloatValue((short)28);
                CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (cSSElement != this.getOwnerNode()) {
                    f = cSSElement.getComputedStyle(null).getComputedFontSize() * 0.5f;
                } else if (bl) {
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'rex'.");
                    f = this.getInitialFontSize() * 0.5f;
                } else {
                    return typedValue;
                }
                f *= f3;
                break;
            }
            case 25: {
                float f3 = typedValue.getFloatValue((short)25);
                ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
                if (computedCSSStyle != null) {
                    f = computedCSSStyle.getComputedLineHeight();
                } else if (bl) {
                    f = this.getInitialFontSize() * 1.2f;
                } else {
                    return typedValue;
                }
                f *= f3;
                break;
            }
            case 27: {
                float f3 = typedValue.getFloatValue((short)27);
                CSSElement cSSElement = this.getOwnerNode().getOwnerDocument().getDocumentElement();
                if (cSSElement != this.getOwnerNode()) {
                    f = cSSElement.getComputedStyle(null).getComputedLineHeight();
                } else if (bl) {
                    f = this.getInitialFontSize() * 1.2f;
                } else {
                    return typedValue;
                }
                f *= f3;
                break;
            }
            case 22: {
                float f3 = typedValue.getFloatValue((short)22);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (cSSCanvas != null) {
                    ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
                    if (computedCSSStyle != null) {
                        f = cSSCanvas.getCapHeight(computedCSSStyle) * f3;
                        break;
                    }
                    f = this.getInitialFontSize() * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'cap'.");
                    break;
                }
                if (bl) {
                    f = this.getInitialFontSize() * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate conversion from 'cap'.");
                    break;
                }
                return typedValue;
            }
            case 23: {
                float f3 = typedValue.getFloatValue((short)23);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (cSSCanvas != null) {
                    ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
                    if (computedCSSStyle != null) {
                        f = (float)cSSCanvas.stringWidth("0", computedCSSStyle) * f3;
                        break;
                    }
                    f = this.getInitialFontSize() * 0.25f * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'ch'.");
                    break;
                }
                if (bl) {
                    f = this.getParentElementFontSize() * 0.25f * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate conversion from 'ch'.");
                    break;
                }
                return typedValue;
            }
            case 29: {
                float f3 = typedValue.getFloatValue((short)29);
                Document document = this.getOwnerNode().getOwnerDocument();
                CSSCanvas cSSCanvas = document.getCanvas();
                CSSElement cSSElement = document.getDocumentElement();
                if (cSSCanvas != null) {
                    if (cSSElement != this.getOwnerNode()) {
                        f = (float)cSSCanvas.stringWidth("0", cSSElement.getComputedStyle(null)) * f3;
                        break;
                    }
                    f = this.getInitialFontSize() * 0.25f * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'rch'.");
                    break;
                }
                if (!bl) {
                    return typedValue;
                }
                f = cSSElement != this.getOwnerNode() ? cSSElement.getComputedStyle(null).getComputedFontSize() * 0.25f : this.getInitialFontSize() * 0.25f;
                this.reportFontSizeWarning(typedValue, "Inaccurate conversion from 'rch'.");
                f *= f3;
                break;
            }
            case 24: {
                float f3 = typedValue.getFloatValue((short)24);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                if (cSSCanvas != null) {
                    ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
                    if (computedCSSStyle != null) {
                        f = (float)cSSCanvas.stringWidth("\u6c34", computedCSSStyle) * f3;
                        break;
                    }
                    f = this.getInitialFontSize() * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'ic'.");
                    break;
                }
                if (bl) {
                    f = this.getParentElementFontSize() * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate conversion from 'ic'.");
                    break;
                }
                return typedValue;
            }
            case 30: {
                float f3 = typedValue.getFloatValue((short)30);
                Document document = this.getOwnerNode().getOwnerDocument();
                CSSCanvas cSSCanvas = document.getCanvas();
                CSSElement cSSElement = document.getDocumentElement();
                if (cSSCanvas != null) {
                    if (cSSElement != this.getOwnerNode()) {
                        f = (float)cSSCanvas.stringWidth("\u6c34", cSSElement.getComputedStyle(null)) * f3;
                        break;
                    }
                    f = this.getInitialFontSize() * f3;
                    this.reportFontSizeWarning(typedValue, "Inaccurate use of 'ric'.");
                    break;
                }
                if (!bl) {
                    return typedValue;
                }
                f = cSSElement != this.getOwnerNode() ? cSSElement.getComputedStyle(null).getComputedFontSize() : this.getInitialFontSize();
                this.reportFontSizeWarning(typedValue, "Inaccurate conversion from 'ric'.");
                f *= f3;
                break;
            }
            case 2: {
                float f4 = typedValue.getFloatValue((short)2);
                return this.getRelativeFontSize(typedValue, f4 * 0.01f, true);
            }
            case 45: {
                float f3 = typedValue.getFloatValue((short)45);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    f = this.getInitialContainingBlockWidthPt(cSSCanvas, bl) * f3 * 0.01f;
                    break;
                }
                catch (StyleDatabaseRequiredException styleDatabaseRequiredException) {
                    if (bl) {
                        throw styleDatabaseRequiredException;
                    }
                    return typedValue;
                }
            }
            case 41: {
                float f3 = typedValue.getFloatValue((short)41);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    f = this.getInitialContainingBlockHeightPt(cSSCanvas, bl) * f3 * 0.01f;
                    break;
                }
                catch (StyleDatabaseRequiredException styleDatabaseRequiredException) {
                    if (bl) {
                        throw styleDatabaseRequiredException;
                    }
                    return typedValue;
                }
            }
            case 42: {
                float f3 = typedValue.getFloatValue((short)42);
                String string = this.getCSSValue("writing-mode").getCssText();
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    f = "horizontal-tb".equalsIgnoreCase(string) ? this.getInitialContainingBlockWidthPt(cSSCanvas, bl) : this.getInitialContainingBlockHeightPt(cSSCanvas, bl);
                }
                catch (StyleDatabaseRequiredException styleDatabaseRequiredException) {
                    if (bl) {
                        throw styleDatabaseRequiredException;
                    }
                    return typedValue;
                }
                f *= f3 * 0.01f;
                break;
            }
            case 40: {
                float f3 = typedValue.getFloatValue((short)40);
                String string = this.getCSSValue("writing-mode").getCssText();
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    f = "horizontal-tb".equalsIgnoreCase(string) ? this.getInitialContainingBlockHeightPt(cSSCanvas, bl) : this.getInitialContainingBlockWidthPt(cSSCanvas, bl);
                }
                catch (StyleDatabaseRequiredException styleDatabaseRequiredException) {
                    if (bl) {
                        throw styleDatabaseRequiredException;
                    }
                    return typedValue;
                }
                f *= f3 * 0.01f;
                break;
            }
            case 44: {
                float f3 = typedValue.getFloatValue((short)44);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    f = Math.min(this.getInitialContainingBlockWidthPt(cSSCanvas, bl), this.getInitialContainingBlockHeightPt(cSSCanvas, bl));
                }
                catch (StyleDatabaseRequiredException styleDatabaseRequiredException) {
                    if (bl) {
                        throw styleDatabaseRequiredException;
                    }
                    return typedValue;
                }
                f *= f3 * 0.01f;
                break;
            }
            case 43: {
                float f3 = typedValue.getFloatValue((short)43);
                CSSCanvas cSSCanvas = this.getOwnerNode().getOwnerDocument().getCanvas();
                try {
                    f = Math.max(this.getInitialContainingBlockWidthPt(cSSCanvas, bl), this.getInitialContainingBlockHeightPt(cSSCanvas, bl));
                }
                catch (StyleDatabaseRequiredException styleDatabaseRequiredException) {
                    if (bl) {
                        throw styleDatabaseRequiredException;
                    }
                    return typedValue;
                }
                f *= f3 * 0.01f;
                break;
            }
            default: {
                try {
                    typedValue.getFloatValue((short)6);
                }
                catch (DOMException dOMException) {
                    String string = typedValue.getCssText();
                    this.computedStyleError("font-size", string, "Error converting to points.", dOMException);
                    f = this.getInitialFontSize();
                    break;
                }
                return typedValue;
            }
        }
        f = (float)Math.round(f * 100.0f) * 0.01f;
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValuePt(f);
        numberValue.setSubproperty(typedValue.isSubproperty());
        numberValue.setAbsolutizedUnit();
        return numberValue;
    }

    private TypedValue getRelativeFontSize(TypedValue typedValue, float f, boolean bl) {
        TypedValue typedValue2;
        ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
        if (computedCSSStyle != null) {
            if (bl) {
                float f2 = computedCSSStyle.getComputedFontSize() * f;
                f2 = (float)Math.round(f2 * 100.0f) * 0.01f;
                typedValue2 = ComputedCSSStyle.asNumericValuePt(f2);
            } else {
                typedValue2 = computedCSSStyle.getFontSizeValue();
                if (typedValue2.getPrimitiveType() == CSSValue.Type.IDENT) {
                    typedValue2 = typedValue;
                } else {
                    try {
                        float f3 = typedValue2.getFloatValue((short)6) * f;
                        f3 = (float)Math.round(f3 * 100.0f) * 0.01f;
                        typedValue2 = ComputedCSSStyle.asNumericValuePt(f3);
                    }
                    catch (DOMException dOMException) {
                        typedValue2 = typedValue;
                    }
                }
            }
        } else {
            float f4 = this.getInitialFontSize() * f;
            typedValue2 = ComputedCSSStyle.asNumericValuePt(f4);
        }
        return typedValue2;
    }

    @Override
    public float getComputedFontSize() {
        float f;
        Object object;
        StyleValue styleValue = super.getCSSValue("font-size");
        if (styleValue != null) {
            if (styleValue.getPrimitiveType() == CSSValue.Type.INTERNAL) {
                object = (PendingValue)styleValue;
                styleValue = this.getSubstitutedValue("font-size", "font", ((PendingValue)object).getLexicalUnit().clone(), this.isPropertyImportant("font-size"));
            } else if (styleValue.getPrimitiveType() == CSSValue.Type.UNSET) {
                styleValue = null;
            }
            if (styleValue != null && (object = styleValue.getCssValueType()) == CSSValue.CssType.PROXY) {
                try {
                    styleValue = this.replaceProxyValues("font-size", styleValue);
                }
                catch (DOMException dOMException) {
                    this.computedStyleError("font-size", styleValue.getCssText(), "Unable to replace PROXY value.", dOMException);
                    styleValue = null;
                }
                if (styleValue != null && styleValue.getPrimitiveType() == CSSValue.Type.LEXICAL) {
                    this.computedStyleError("font-size", styleValue.getCssText(), "Unable to replace LEXICAL value.");
                    styleValue = null;
                }
            }
        }
        if ((styleValue = ComputedCSSStyle.inheritValue(this, "font-size", styleValue, true)) != null && styleValue.getPrimitiveType() == CSSValue.Type.INHERIT) {
            styleValue = null;
        }
        if (styleValue == null || styleValue.getPrimitiveType() == CSSValue.Type.INITIAL) {
            return this.getInitialFontSize();
        }
        object = this.absoluteFontSizeValue(styleValue, true);
        switch (object.getPrimitiveType()) {
            case IDENT: {
                String string = object.getStringValue().toLowerCase(Locale.ROOT);
                try {
                    String string2 = this.getUsedFontFamily();
                    f = this.getFontSizeFromIdentifier(string2, string);
                }
                catch (DOMException dOMException) {
                    this.computedStyleError("font-size", string, "Unknown identifier", dOMException);
                    f = this.getInitialFontSize();
                }
                break;
            }
            default: {
                try {
                    f = object.getFloatValue((short)6);
                    break;
                }
                catch (DOMException dOMException) {
                    String string = object.getCssText();
                    this.computedStyleError("font-size", string, null, dOMException);
                    f = this.getInitialFontSize();
                }
            }
        }
        return f;
    }

    private float getFontSizeFromIdentifier(String string, String string2) {
        if (this.getStyleDatabase() != null) {
            return this.getStyleDatabase().getFontSizeFromIdentifier(string, string2);
        }
        float f = string2.equals("medium") ? 12.0f : (string2.equals("x-small") ? 9.0f : (string2.equals("small") ? 10.0f : (string2.equals("xx-small") ? 8.0f : (string2.equals("large") ? 14.0f : (string2.equals("x-large") ? 18.0f : (string2.equals("xx-large") ? 24.0f : 12.0f))))));
        return f;
    }

    private TypedValue getLargerFontSize(String string) {
        CSSTypedValue cSSTypedValue;
        ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
        if (computedCSSStyle != null && (cSSTypedValue = (CSSTypedValue)((Object)computedCSSStyle.getCSSValue("font-size"))) != null) {
            String string2;
            switch (cSSTypedValue.getPrimitiveType()) {
                case IDENT: {
                    String string3 = cSSTypedValue.getStringValue();
                    if (string3.equals("xx-small")) {
                        string2 = "x-small";
                        break;
                    }
                    if (string3.equals("x-small")) {
                        string2 = "small";
                        break;
                    }
                    if (string3.equals("small")) {
                        string2 = "medium";
                        break;
                    }
                    if (string3.equals("medium")) {
                        string2 = "large";
                        break;
                    }
                    if (string3.equals("large")) {
                        string2 = "x-large";
                        break;
                    }
                    if (string3.equals("x-large")) {
                        string2 = "xx-large";
                        break;
                    }
                    if (string3.equals("xx-large")) {
                        return ComputedCSSStyle.asNumericValuePt(2.0f * this.getFontSizeFromIdentifier(string, "xx-large") - this.getFontSizeFromIdentifier(string, "x-large"));
                    }
                    this.computedStyleError("font-size", string3, "Unknown identifier");
                    return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(string, "medium") * 1.2f);
                }
                default: {
                    return ComputedCSSStyle.asNumericValuePt(computedCSSStyle.getComputedFontSize() * 1.2f);
                }
            }
            return new IdentifierValue(string2);
        }
        return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(string, "medium") * 1.2f);
    }

    private TypedValue getSmallerFontSize(String string) {
        CSSTypedValue cSSTypedValue;
        ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
        if (computedCSSStyle != null && (cSSTypedValue = (CSSTypedValue)((Object)computedCSSStyle.getCSSValue("font-size"))) != null) {
            String string2;
            switch (cSSTypedValue.getPrimitiveType()) {
                case IDENT: {
                    String string3 = cSSTypedValue.getStringValue();
                    if (string3.equals("xx-small")) {
                        float f = 2.0f * this.getFontSizeFromIdentifier(string, "xx-small") - this.getFontSizeFromIdentifier(string, "x-small");
                        if (f < 7.0f) {
                            f = this.getFontSizeFromIdentifier(string, "xx-small");
                        }
                        return ComputedCSSStyle.asNumericValuePt(f);
                    }
                    if (string3.equals("x-small")) {
                        string2 = "xx-small";
                        break;
                    }
                    if (string3.equals("small")) {
                        string2 = "x-small";
                        break;
                    }
                    if (string3.equals("medium")) {
                        string2 = "small";
                        break;
                    }
                    if (string3.equals("large")) {
                        string2 = "medium";
                        break;
                    }
                    if (string3.equals("x-large")) {
                        string2 = "large";
                        break;
                    }
                    if (string3.equals("xx-large")) {
                        string2 = "x-large";
                        break;
                    }
                    this.computedStyleError("font-size", string3, "Unknown identifier");
                    return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(string, "medium") * 0.82f);
                }
                default: {
                    return ComputedCSSStyle.asNumericValuePt(computedCSSStyle.getComputedFontSize() * 0.82f);
                }
            }
            return new IdentifierValue(string2);
        }
        return ComputedCSSStyle.asNumericValuePt(this.getFontSizeFromIdentifier(string, "medium") * 0.82f);
    }

    private void reportFontSizeError(CSSValue cSSValue, String string) {
        String string2 = cSSValue.getCssText();
        this.computedStyleError("font-size", string2, string);
    }

    private void reportFontSizeWarning(PrimitiveValue primitiveValue, String string) {
        this.computedStyleWarning("font-size", primitiveValue, string);
    }

    private float getParentElementFontSize() {
        ComputedCSSStyle computedCSSStyle = this.getParentComputedStyle();
        float f = computedCSSStyle != null ? computedCSSStyle.getComputedFontSize() : this.getInitialFontSize();
        return f;
    }

    private boolean isRelativeUnit(CSSTypedValue cSSTypedValue) {
        return cSSTypedValue.getPrimitiveType() == CSSValue.Type.NUMERIC && CSSUnit.isRelativeLengthUnitType(cSSTypedValue.getUnitType());
    }

    private TypedValue colorValue(String string, TypedValue typedValue) {
        if (typedValue.getPrimitiveType() == CSSValue.Type.IDENT) {
            String string2 = typedValue.getStringValue().toLowerCase(Locale.ROOT);
            if ("currentcolor".equals(string2)) {
                if (!"color".equals(string)) {
                    typedValue = this.getCSSColor();
                }
            } else {
                String string3 = "transparent".equals(string2) ? "rgba(0 0 0/0)" : ColorIdentifiers.getInstance().getColor(string2);
                if (string3 != null) {
                    try {
                        typedValue = (TypedValue)this.getValueFactory().parseProperty(string3);
                    }
                    catch (DOMException dOMException) {
                        // empty catch block
                    }
                }
            }
        }
        return typedValue;
    }

    private static NumberValue asNumericValuePt(float f) {
        NumberValue numberValue = new NumberValue();
        numberValue.setFloatValuePt(f);
        numberValue.setAbsolutizedUnit();
        return numberValue;
    }

    private float getInitialFontSize() {
        String string = this.getUsedFontFamily();
        return this.getFontSizeFromIdentifier(string, "medium");
    }

    @Override
    public float getComputedLineHeight() {
        return this.getComputedLineHeight(1.16f);
    }

    public float getComputedLineHeight(float f) {
        float f2;
        StyleValue styleValue = this.getCSSValue("line-height");
        if (styleValue == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            return f * this.getComputedFontSize();
        }
        CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
        CSSValue.Type type = cSSTypedValue.getPrimitiveType();
        if (type == CSSValue.Type.NUMERIC) {
            short s = cSSTypedValue.getUnitType();
            if (s == 2) {
                f2 = this.getComputedFontSize() * cSSTypedValue.getFloatValue((short)2) / 100.0f;
            } else {
                f2 = cSSTypedValue.getFloatValue(s);
                if (s != 6) {
                    f2 = NumberValue.floatValueConversion(f2, s, (short)6);
                }
            }
        } else if (type == CSSValue.Type.IDENT) {
            if (!"normal".equalsIgnoreCase(cSSTypedValue.getStringValue())) {
                this.computedStyleError("line-height", cSSTypedValue.getStringValue(), "Wrong value: expected 'normal'");
            }
            f2 = f * this.getComputedFontSize();
        } else {
            this.computedStyleError("line-height", cSSTypedValue.getStringValue(), "Wrong value: expected number or identifier");
            f2 = f * this.getComputedFontSize();
        }
        return f2;
    }

    private StyleValue applyDisplayConstrains(StyleValue styleValue) {
        StyleValue styleValue2 = styleValue;
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            return styleValue;
        }
        String string = ((CSSTypedValue)((Object)styleValue)).getStringValue();
        if (!"none".equalsIgnoreCase(string)) {
            String string2 = this.getTypedValueOrInitial("position").getStringValue();
            if ("absolute".equalsIgnoreCase(string2) || "fixed".equalsIgnoreCase(string2)) {
                styleValue2 = this.computeConstrainedDisplay(styleValue);
            } else {
                CSSElement cSSElement;
                String string3 = this.getTypedValueOrInitial("float").getStringValue();
                if (!"none".equalsIgnoreCase(string3) || (cSSElement = this.getOwnerNode()).getParentNode() == cSSElement.getOwnerDocument()) {
                    styleValue2 = this.computeConstrainedDisplay(styleValue);
                }
            }
        }
        return styleValue2;
    }

    private TypedValue getTypedValueOrInitial(String string) {
        StyleValue styleValue = this.getCSSValue(string);
        TypedValue typedValue = styleValue.getCssValueType() != CSSValue.CssType.TYPED ? (TypedValue)this.defaultPropertyValue(string) : (TypedValue)styleValue;
        return typedValue;
    }

    private TypedValue getTypedValueOrInherit(String string) {
        ComputedCSSStyle computedCSSStyle = this;
        StyleValue styleValue = this.getCSSValue(string);
        if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
            while ((styleValue = ComputedCSSStyle.inheritValue(computedCSSStyle, string, styleValue, true)) == null || styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                styleValue = null;
                if ((computedCSSStyle = computedCSSStyle.getParentComputedStyle()) != null) continue;
            }
            if (styleValue == null) {
                styleValue = this.defaultPropertyValue(string);
            }
        }
        return (TypedValue)styleValue;
    }

    private StyleValue computeConstrainedDisplay(StyleValue styleValue) {
        String string = ((CSSTypedValue)((Object)styleValue)).getStringValue().toLowerCase(Locale.ROOT);
        if ("inline-table".equals(string)) {
            return new IdentifierValue("table");
        }
        if ("inline".equals(string) || "run-in".equals(string) || "table-row-group".equals(string) || "table-column".equals(string) || "table-column-group".equals(string) || "table-header-group".equals(string) || "table-footer-group".equals(string) || "table-row".equals(string) || "table-cell".equals(string) || "table-caption".equals(string) || "inline-block".equals(string)) {
            return new IdentifierValue("block");
        }
        return styleValue;
    }

    private StyleValue applyBorderWidthConstrains(String string, StyleValue styleValue) {
        String string2 = null;
        if (string.equals("border-top-width")) {
            string2 = this.getCSSValue("border-top-style").getCssText();
        } else if (string.equals("border-right-width")) {
            string2 = this.getCSSValue("border-top-style").getCssText();
        } else if (string.equals("border-bottom-width")) {
            string2 = this.getCSSValue("border-top-style").getCssText();
        } else if (string.equals("border-left-width")) {
            string2 = this.getCSSValue("border-top-style").getCssText();
        }
        if (string2 != null && (string2.equals("none") || string2.equals("hidden"))) {
            styleValue = this.getValueFactory().parseProperty("0");
        }
        return styleValue;
    }

    private StyleValue computeBackgroundRepeat(StyleValue styleValue) {
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                for (int i = 0; i < valueList.getLength(); ++i) {
                    StyleValue styleValue2 = valueList.item(i);
                    if (styleValue2.getCssValueType() == CSSValue.CssType.LIST) continue;
                    valueList.set(i, this.computeBackgroundRepeatPrimitive(styleValue2));
                }
            }
        } else {
            styleValue = this.computeBackgroundRepeatPrimitive(styleValue);
        }
        return styleValue;
    }

    private StyleValue computeBackgroundRepeatPrimitive(StyleValue styleValue) {
        ValueList valueList = ValueList.createWSValueList();
        String string = styleValue.getCssText();
        if (string.equals("repeat-y")) {
            valueList.add(new IdentifierValue("no-repeat"));
            valueList.add(new IdentifierValue("repeat"));
        } else if (string.equals("repeat-x")) {
            valueList.add(new IdentifierValue("repeat"));
            valueList.add(new IdentifierValue("no-repeat"));
        } else if (string.equals("repeat")) {
            valueList.add(new IdentifierValue("repeat"));
            valueList.add(new IdentifierValue("repeat"));
        } else if (string.equals("no-repeat")) {
            valueList.add(new IdentifierValue("no-repeat"));
            valueList.add(new IdentifierValue("no-repeat"));
        } else if (string.equals("space")) {
            valueList.add(new IdentifierValue("space"));
            valueList.add(new IdentifierValue("space"));
        } else if (string.equals("round")) {
            valueList.add(new IdentifierValue("round"));
            valueList.add(new IdentifierValue("round"));
        } else {
            return styleValue;
        }
        return valueList;
    }

    @Override
    protected TypedValue getCurrentColor() {
        return this.getCSSColor();
    }

    @Override
    public TypedValue getCSSColor() {
        return this.getTypedValueOrInherit("color");
    }

    @Override
    public TypedValue getCSSBackgroundColor() {
        return this.getTypedValueOrInitial("background-color");
    }

    @Override
    public String[] getBackgroundImages() {
        Serializable serializable;
        StyleValue styleValue = this.getCSSValue("background-image");
        if (styleValue == null) {
            return null;
        }
        String string = styleValue instanceof WrappedValue ? ((WrappedValue)((Object)styleValue)).getParentSheetHref() : ((serializable = this.getParentRule()) != null ? serializable.getParentStyleSheet().getHref() : null);
        if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
            return new String[]{this.getHref((CSSTypedValue)((Object)styleValue), string)};
        }
        serializable = (ValueList)styleValue;
        int n = ((ValueList)serializable).getLength();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getHref((CSSTypedValue)((Object)((ValueList)serializable).item(i)), string);
        }
        return stringArray;
    }

    protected String getHref(CSSTypedValue cSSTypedValue, String string) {
        String string2 = cSSTypedValue.getStringValue();
        if (!string2.contains("://")) {
            Object object;
            URL uRL = null;
            if (string == null) {
                object = this.getOwnerNode().getBaseURI();
                if (object != null) {
                    try {
                        uRL = new URL((String)object);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            } else if (!string.contains("://")) {
                try {
                    uRL = new URL(new URL(this.getOwnerNode().getBaseURI()), string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(string);
                }
            } else {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(string);
                }
            }
            if (uRL != null) {
                try {
                    object = new URL(uRL, string2);
                    string2 = ((URL)object).toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    this.getStyleDeclarationErrorHandler().malformedURIValue(string2);
                }
            }
        }
        return string2;
    }

    @Override
    public String getUsedFontFamily() {
        StyleDatabase styleDatabase = this.getStyleDatabase();
        if (styleDatabase != null) {
            return styleDatabase.getUsedFontFamily(this);
        }
        StyleValue styleValue = this.getCSSValue("font-family");
        if (styleValue != null) {
            CSSValue cSSValue;
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
                cSSValue = (ValueList)styleValue;
                styleValue = ((ValueList)cSSValue).item(0);
            }
            if (styleValue.getPrimitiveType() != CSSValue.Type.UNKNOWN && styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                cSSValue = (CSSTypedValue)((Object)styleValue);
                try {
                    return cSSValue.getStringValue();
                }
                catch (DOMException dOMException) {
                    this.computedStyleError("font-family", cSSValue.getCssText(), "Bad font-family.");
                }
            }
        }
        return "Serif";
    }

    private void computedStyleError(String string, String string2, String string3) {
        this.computedStyleError(string, string2, string3, null);
    }

    private void computedStyleError(String string, String string2, String string3, Throwable throwable) {
        CSSPropertyValueException cSSPropertyValueException = throwable == null ? new CSSPropertyValueException(string3) : (string3 == null ? new CSSPropertyValueException(throwable) : new CSSPropertyValueException(string3, throwable));
        cSSPropertyValueException.setValueText(string2);
        this.getOwnerNode().getOwnerDocument().getErrorHandler().computedStyleError(this.getOwnerNode(), string, cSSPropertyValueException);
    }

    private void computedStyleWarning(String string, CSSPrimitiveValue cSSPrimitiveValue, String string2) {
        this.computedStyleWarning(string, cSSPrimitiveValue, string2, null);
    }

    private void computedStyleWarning(String string, CSSPrimitiveValue cSSPrimitiveValue, String string2, Throwable throwable) {
        CSSPropertyValueException cSSPropertyValueException = throwable == null ? new CSSPropertyValueException(string2) : (string2 == null ? new CSSPropertyValueException(throwable) : new CSSPropertyValueException(string2, throwable));
        cSSPropertyValueException.setValueText(cSSPrimitiveValue.getCssText());
        this.getOwnerNode().getOwnerDocument().getErrorHandler().computedStyleWarning(this.getOwnerNode(), string, cSSPropertyValueException);
    }

    @Override
    public BoxValues getBoxValues(short s) throws DOMException, StyleDatabaseRequiredException {
        return new MyDefaultBoxModel().getComputedBox(s);
    }

    @Override
    public String getCssText() {
        return this.getComputedPlainCssText();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        this.writeComputedCssText(simpleWriter, styleFormattingContext);
    }

    @Override
    public String getMinifiedCssText() {
        return this.getOptimizedCssText();
    }

    public ComputedCSSStyle getRevertStyle(Condition condition) {
        ComputedCSSStyle computedCSSStyle = this.ownerSheet.createComputedCSSStyle();
        CSSElement cSSElement = this.getOwnerNode();
        computedCSSStyle.setOwnerNode(cSSElement);
        return this.ownerSheet.computeRevertedStyle(computedCSSStyle, cSSElement.getSelectorMatcher(), condition, (BaseCSSStyleDeclaration)cSSElement.getStyle(), (byte)8);
    }

    @Override
    public abstract ComputedCSSStyle getParentComputedStyle();

    public String getText() {
        return BoxModelHelper.contractSpaces(this.getOwnerNode().getTextContent()).trim();
    }

    @Override
    public abstract ComputedCSSStyle clone();

    private class FontEvaluator
    extends MyEvaluator {
        FontEvaluator() {
            super("font-size");
        }

        @Override
        protected TypedValue absoluteTypedValue(TypedValue typedValue) {
            return ComputedCSSStyle.this.absoluteTypedValue(this.propertyName, typedValue, true);
        }

        @Override
        protected StyleValue absoluteProxyValue(CSSPrimitiveValue cSSPrimitiveValue) {
            return ComputedCSSStyle.this.replaceProxyValue(this.propertyName, cSSPrimitiveValue);
        }

        @Override
        protected float percentage(CSSTypedValue cSSTypedValue, short s) throws DOMException {
            float f = cSSTypedValue.getFloatValue((short)2);
            return ComputedCSSStyle.this.getParentElementFontSize() * f * 0.01f;
        }
    }

    private class MyDefaultBoxModel
    extends SimpleBoxModel {
        MyDefaultBoxModel() {
        }

        @Override
        protected ComputedCSSStyle getComputedStyle() {
            return ComputedCSSStyle.this;
        }

        @Override
        protected CSSComputedProperties getRevertStyle(Condition condition) {
            return ComputedCSSStyle.this.getRevertStyle(condition);
        }
    }

    private class MyEvaluator
    extends Evaluator {
        final String propertyName;

        MyEvaluator(String string) {
            this.propertyName = string;
        }

        @Override
        protected TypedValue absoluteTypedValue(TypedValue typedValue) {
            return ComputedCSSStyle.this.absoluteTypedValue(this.propertyName, typedValue, false);
        }

        @Override
        protected StyleValue absoluteProxyValue(CSSPrimitiveValue cSSPrimitiveValue) {
            return ComputedCSSStyle.this.replaceProxyValue(this.propertyName, cSSPrimitiveValue);
        }
    }
}

