/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.EmptyElementList;
import io.sf.carte.doc.dom.HTMLElement;
import io.sf.carte.doc.dom.StyleDefinerElementHelper;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.property.AttributeToStyle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public abstract class HTMLDocument
extends DOMDocument {
    private static final long serialVersionUID = 2L;
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private URL baseURL = null;
    private static final Set<String> rawTextElementsExceptStyle = new HashSet<String>(6);

    public HTMLDocument(DocumentType documentType) {
        super(documentType);
    }

    @Override
    public HTMLElement getDocumentElement() {
        return (HTMLElement)super.getDocumentElement();
    }

    @Override
    public HTMLDocument getOwnerDocument() {
        return null;
    }

    @Override
    public HTMLDocument cloneNode(boolean bl) {
        return (HTMLDocument)super.cloneNode(bl);
    }

    @Override
    DOMDocument cloneDocument(DocumentType documentType) {
        String string = null;
        String string2 = null;
        HTMLElement hTMLElement = this.getDocumentElement();
        if (hTMLElement != null) {
            string = hTMLElement.getNamespaceURI();
            string2 = hTMLElement.getTagName();
        }
        DOMDocument dOMDocument = this.getImplementation().createDocument(string, string2, documentType);
        if (hTMLElement != null) {
            dOMDocument.removeChild(dOMDocument.getDocumentElement());
        }
        return dOMDocument;
    }

    @Override
    public DOMElement createElement(String string) throws DOMException {
        if (string == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(HTML_NAMESPACE_URI, string);
    }

    @Override
    public DOMElement createElementNS(String string, String string2) throws DOMException {
        String string3;
        String string4;
        if (string2 == null) {
            throw new DOMException(5, "null qualified name");
        }
        if (string != null && !string.equals(HTML_NAMESPACE_URI) && string.length() != 0) {
            string = string.intern();
            int n = string2.indexOf(58);
            if (n == -1) {
                string4 = this.lookupPrefix(string);
                string3 = string2;
            } else {
                if (n == string2.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                if (n == 0) {
                    throw new DOMException(5, "Empty prefix");
                }
                string4 = string2.substring(0, n).intern();
                string3 = string2.substring(n + 1);
            }
        } else {
            string = HTML_NAMESPACE_URI;
            string3 = string2.toLowerCase(Locale.ROOT);
            string4 = null;
        }
        if (!DOMDocument.isValidName(string3)) {
            throw new DOMException(5, "Invalid name: " + string3);
        }
        DOMElement dOMElement = "link".equals(string3) ? new LinkElement(string) : ("style".equals(string3) ? new StyleElement(string) : (string == HTML_NAMESPACE_URI ? ("meta".equals(string3) ? new MetaElement() : ("base".equals(string3) ? new BaseElement() : ("title".equals(string3) ? new MetacontentElement(string3) : ("html".equals(string3) ? new HtmlRootElement() : ("img".equals(string3) ? new ImgElement() : ("font".equals(string3) ? new FontElement() : ("table".equals(string3) ? new TableElement() : ("tr".equals(string3) ? new TableRowElement() : ("td".equals(string3) ? new TableCellElement(string3) : ("th".equals(string3) ? new TableCellElement(string3) : (rawTextElementsExceptStyle.contains(string3) ? new RawTextElement(string3, string) : new MyHTMLElement(string3, string)))))))))))) : new DOMDocument.MyXMLElement(string3, string)));
        if (string4 != null) {
            dOMElement.setPrefix(string4);
        }
        return dOMElement;
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        DOMDocument.MyAttr myAttr;
        if (string2 == null) {
            throw new DOMException(5, "null name");
        }
        String string3 = string2;
        String string4 = null;
        if (string != null) {
            if (string.length() != 0) {
                string = string.intern();
                int n = string2.indexOf(58);
                if (n == -1) {
                    string4 = this.lookupPrefix(string);
                } else {
                    if (n == string2.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (n == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    string4 = string2.substring(0, n).intern();
                    string3 = string2.substring(n + 1);
                }
                if (HTML_NAMESPACE_URI == string) {
                    string3 = string3.toLowerCase(Locale.ROOT);
                }
            } else {
                string = null;
                string3 = string3.toLowerCase(Locale.ROOT);
            }
        } else {
            if (string2.indexOf(58) != -1) {
                throw new DOMException(14, "Prefix with null namespace");
            }
            string3 = string3.toLowerCase(Locale.ROOT);
        }
        if (!DOMDocument.isValidName(string3)) {
            throw new DOMException(5, "Invalid name: " + string3);
        }
        if (string == null || string == HTML_NAMESPACE_URI) {
            myAttr = "class".equals(string3) ? new DOMDocument.ClassAttr(string) : ("href".equals(string3) ? new HrefEventAttr(string) : ("style".equals(string3) ? new DOMDocument.MyStyleAttr(string3) : ("media".equals(string3) || "type".equals(string3) || "crossorigin".equals(string3) ? new DOMDocument.StyleEventAttr(string3, string) : new DOMDocument.MyAttr(string3, string))));
        } else if ("xmlns".equals(string3)) {
            if (!"http://www.w3.org/2000/xmlns/".equals(string)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            myAttr = new DOMDocument.XmlnsAttr();
        } else {
            myAttr = "style".equals(string3) && string4 == null ? new DOMDocument.MyStyleAttr(string3) : new DOMDocument.MyAttr(string3, string);
        }
        if (string4 != null) {
            myAttr.setPrefix(string4);
        }
        return myAttr;
    }

    @Override
    boolean isHTML() {
        return true;
    }

    private boolean setBaseURL(DOMElement dOMElement, String string) {
        if (string.length() != 0) {
            String string2 = this.getDocumentURI();
            if (string2 != null) {
                URL uRL;
                URL uRL2;
                try {
                    uRL2 = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    return this.setBaseForNullDocumentURI(string, dOMElement);
                }
                try {
                    uRL = new URL(uRL2, string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.getErrorHandler().ioError(string, malformedURLException);
                    return false;
                }
                String string3 = uRL2.getProtocol();
                String string4 = uRL.getProtocol();
                if (!(string3.equals(string4) || string4.equals("https") || string4.equals("http") || string3.equals("file") || string3.equals("jar"))) {
                    this.getErrorHandler().policyError(dOMElement, "Remote document wants to set a non-http base URL: " + uRL.toExternalForm());
                    return false;
                }
                this.baseURL = uRL;
                return true;
            }
            return this.setBaseForNullDocumentURI(string, dOMElement);
        }
        return false;
    }

    private boolean setBaseForNullDocumentURI(String string, DOMElement dOMElement) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("https") || string2.equals("http")) {
                this.baseURL = uRL;
                return true;
            }
            this.getErrorHandler().policyError(dOMElement, "Untrusted document wants to set a non-http base URL: " + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public URL getBaseURL() {
        if (this.baseURL == null) {
            String string;
            DOMElement dOMElement;
            Object object;
            Iterator<DOMElement> iterator;
            HTMLElement hTMLElement = this.getDocumentElement();
            Iterator<DOMElement> iterator2 = hTMLElement.elementIterator("head");
            if (iterator2.hasNext() && (iterator = ((DOMElement)(object = iterator2.next())).elementIterator("base")).hasNext() && this.setBaseURL(dOMElement = iterator.next(), string = dOMElement.getAttribute("href"))) {
                return this.baseURL;
            }
            object = this.getDocumentURI();
            if (object != null) {
                try {
                    this.baseURL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return this.baseURL;
    }

    @Override
    public String getBaseURI() {
        URL uRL = this.getBaseURL();
        if (uRL != null) {
            return uRL.toExternalForm();
        }
        return null;
    }

    @Override
    public void setDocumentURI(String string) {
        super.setDocumentURI(string);
        this.baseURL = null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return HTML_NAMESPACE_URI.equals(string);
    }

    @Override
    DOMDocument.LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement dOMElement) {
        if (dOMElement != null) {
            return dOMElement instanceof DOMDocument.LinkStyleDefiner ? (DOMDocument.LinkStyleDefiner)((Object)dOMElement) : null;
        }
        return null;
    }

    ElementList getLinkedStyleNodeList() {
        return this.getElementsByTagName("link");
    }

    ElementList getEmbeddedStyleNodeList() {
        HTMLElement hTMLElement = this.getDocumentElement();
        ElementList elementList = hTMLElement != null ? hTMLElement.getElementsByTagNameNS("*", "style") : EmptyElementList.getInstance();
        return elementList;
    }

    static {
        String[] stringArray = new String[]{"listing", "plaintext", "pre", "script", "textarea", "xmp"};
        Collections.addAll(rawTextElementsExceptStyle, stringArray);
    }

    private class BaseElement
    extends MetacontentElement {
        private static final long serialVersionUID = 2L;

        BaseElement() {
            super("base");
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            if (abstractDOMNode != null) {
                super.setParentNode(abstractDOMNode);
                if (HTMLDocument.this.getStrictErrorChecking() && abstractDOMNode.getNodeType() == 1) {
                    for (Node node = abstractDOMNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (node.getNodeType() != 1 || !"base".equals(node.getNodeName()) || node == this) continue;
                        throw new DOMException(3, "A document can have only one base element.\nDisable strict error checking to avoid this error.");
                    }
                }
                this.getOwnerDocument().baseURL = null;
            } else {
                this.getOwnerDocument().baseURL = null;
                super.setParentNode(abstractDOMNode);
            }
        }
    }

    private class FontElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        FontElement() {
            super("font");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("face") || this.hasAttribute("size") || this.hasAttribute("color");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
            AttributeToStyle.face(this.getAttribute("face"), cSSStyleDeclaration);
            AttributeToStyle.size(this.getAttribute("size"), cSSStyleDeclaration);
            AttributeToStyle.color(this.getAttribute("color"), cSSStyleDeclaration);
        }
    }

    private class HrefEventAttr
    extends DOMDocument.EventAttr {
        private static final long serialVersionUID = 2L;

        HrefEventAttr(String string) {
            super("href", string);
        }

        @Override
        void onAttributeRemoval() {
            DOMElement dOMElement = this.getOwnerElement();
            String string = dOMElement.getTagName();
            if ("base".equals(string)) {
                if (dOMElement.isDocumentDescendant()) {
                    HTMLDocument hTMLDocument = (HTMLDocument)this.getOwnerDocument();
                    hTMLDocument.baseURL = null;
                    hTMLDocument.onBaseModify();
                }
            } else if ("link".equals(string)) {
                ((LinkElement)dOMElement).resetSheet();
            }
        }

        @Override
        void onDOMChange(DOMElement dOMElement) {
            String string = dOMElement.getTagName();
            if ("link".equals(string)) {
                ((LinkElement)dOMElement).resetSheet();
            } else if ("base".equals(string)) {
                HTMLDocument hTMLDocument = (HTMLDocument)this.getOwnerDocument();
                String string2 = this.getValue();
                if (dOMElement.isDocumentDescendant()) {
                    if (!HTMLDocument.this.setBaseURL(dOMElement, string2)) {
                        hTMLDocument.baseURL = null;
                    }
                    HTMLDocument.this.onBaseModify();
                }
            }
        }
    }

    private class HtmlRootElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        private HtmlRootElement() {
            super("html");
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            short s;
            if (abstractDOMNode != null && (s = abstractDOMNode.getNodeType()) != 9 && s != 11) {
                throw new DOMException(3, "A <html> tag cannot be added here.");
            }
            super.setParentNode(abstractDOMNode);
        }

        @Override
        void preAddChild(Node node) {
            String string;
            super.preAddChild(node);
            if (node.getNodeType() == 1 && ("head".equals(string = node.getNodeName()) || "body".equals(string))) {
                for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
                    throw new DOMException(3, "<html> already has a " + string + " child.");
                }
            }
        }

        @Override
        void preReplaceChild(AbstractDOMNode abstractDOMNode, AbstractDOMNode abstractDOMNode2) {
            String string;
            String string2;
            super.preAddChild(abstractDOMNode);
            if (abstractDOMNode.getNodeType() == 1 && !(string2 = abstractDOMNode.getNodeName()).equalsIgnoreCase(string = abstractDOMNode2.getNodeName()) && ("head".equals(string2) || "body".equals(string2))) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !node.getNodeName().equals(string2)) continue;
                    throw new DOMException(3, "<html> already has a " + string2 + " child.");
                }
            }
        }
    }

    private class ImgElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        ImgElement() {
            super("img");
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("border") || this.hasAttribute("hspace") || this.hasAttribute("vspace");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
            AttributeToStyle.width(this.getAttribute("width"), cSSStyleDeclaration);
            AttributeToStyle.height(this.getAttribute("height"), cSSStyleDeclaration);
            AttributeToStyle.hspace(this.getAttribute("hspace"), cSSStyleDeclaration);
            AttributeToStyle.vspace(this.getAttribute("vspace"), cSSStyleDeclaration);
            if (AttributeToStyle.border(this.getAttribute("border"), cSSStyleDeclaration)) {
                cSSStyleDeclaration.setProperty("border-top-style", "solid", null);
                cSSStyleDeclaration.setProperty("border-right-style", "solid", null);
                cSSStyleDeclaration.setProperty("border-bottom-style", "solid", null);
                cSSStyleDeclaration.setProperty("border-left-style", "solid", null);
            }
        }
    }

    private class LinkElement
    extends MyHTMLElement
    implements DOMDocument.LinkStyleDefiner {
        private static final long serialVersionUID = 2L;
        private final StyleDefinerElementHelper helper;

        LinkElement(String string) {
            super("link", string);
            this.helper = new StyleDefinerElementHelper(this);
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            super.setParentNode(abstractDOMNode);
            HTMLDocument.this.onSheetModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            return this.helper.getLinkedSheet();
        }

        @Override
        public void resetSheet() {
            this.helper.resetSheet();
        }

        @Override
        public HTMLElement cloneNode(boolean bl) {
            return this.cloneElementNode(new LinkElement(this.getNamespaceURI()), bl);
        }
    }

    private class MetaElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        MetaElement() {
            super("meta");
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            if (abstractDOMNode == null) {
                String string = this.getAttribute("http-equiv");
                if (string.length() == 0) {
                    string = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaRemoved(string, this.getAttribute("content"));
                super.setParentNode(null);
            } else {
                short s = abstractDOMNode.getNodeType();
                if (HTMLDocument.this.getStrictErrorChecking() && s != 11 && (s != 1 || !this.isValidContext(abstractDOMNode))) {
                    String string = "A <meta> tag without the proper attributes can occur only in the head or noscript element, not in " + abstractDOMNode.getNodeName() + ".\nDisable strict error checking to avoid this error.";
                    throw new DOMException(3, string);
                }
                super.setParentNode(abstractDOMNode);
                String string = this.getAttribute("http-equiv");
                if (string.length() == 0) {
                    string = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaAdded(string, this.getAttribute("content"));
            }
        }

        private boolean isValidContext(Node node) {
            String string = node.getNodeName();
            return "head".equals(string) || "noscript".equals(string) || this.hasAttribute("itemprop") || this.hasAttribute("name");
        }
    }

    private class MetacontentElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        MetacontentElement(String string) {
            super(string);
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            if (abstractDOMNode != null) {
                short s = abstractDOMNode.getNodeType();
                if (HTMLDocument.this.getStrictErrorChecking() && s != 11 && (s != 1 || !"head".equals(abstractDOMNode.getNodeName()) && !"noscript".equals(abstractDOMNode.getNodeName()))) {
                    String string = "A <" + this.getNodeName() + "> tag can occur only in a head or noscript element, not in " + abstractDOMNode.toString() + ".\nDisable strict error checking to avoid this error.";
                    throw new DOMException(3, string);
                }
            }
            super.setParentNode(abstractDOMNode);
        }
    }

    private class MyHTMLElement
    extends HTMLElement {
        private static final long serialVersionUID = 2L;

        MyHTMLElement(String string) {
            this(string, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyHTMLElement(String string, String string2) {
            super(string, string2);
        }

        @Override
        public void setId(String string) {
            this.setAttribute("id", string);
        }

        @Override
        public boolean isDefaultNamespace(String string) {
            return HTMLDocument.this.isDefaultNamespace(string);
        }

        @Override
        public HTMLDocument getOwnerDocument() {
            return HTMLDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return HTMLDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return HTMLDocument.this.getBaseURI();
        }

        @Override
        public HTMLElement cloneNode(boolean bl) {
            return this.cloneElementNode(new MyHTMLElement(this.getLocalName(), this.getNamespaceURI()), bl);
        }

        HTMLElement cloneElementNode(MyHTMLElement myHTMLElement, boolean bl) {
            for (Node node : this.nodeMap.getNodeList()) {
                DOMAttr dOMAttr = (DOMAttr)node.cloneNode(bl);
                dOMAttr.specified = node.getSpecified();
                myHTMLElement.setAttributeNode(dOMAttr);
            }
            if (bl) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    myHTMLElement.appendChild(node.cloneNode(true));
                }
            }
            MyHTMLElement.callUserHandlers((short)1, this, myHTMLElement);
            return myHTMLElement;
        }
    }

    private class RawTextElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        RawTextElement(String string, String string2) {
            super(string, string2);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public HTMLElement cloneNode(boolean bl) {
            return this.cloneElementNode(new RawTextElement(this.getLocalName(), this.getNamespaceURI()), bl);
        }
    }

    private class StyleElement
    extends MyHTMLElement
    implements DOMDocument.LinkStyleDefiner {
        private static final long serialVersionUID = 2L;
        private final StyleDefinerElementHelper helper;

        StyleElement(String string) {
            super("style", string);
            this.helper = new StyleDefinerElementHelper(this);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            return this.helper.getInlineSheet();
        }

        @Override
        public void resetSheet() {
            this.helper.resetSheet();
        }

        @Override
        void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
            super.setParentNode(abstractDOMNode);
            HTMLDocument.this.onSheetModify();
        }

        @Override
        void postAddChild(AbstractDOMNode abstractDOMNode) {
            super.postAddChild(abstractDOMNode);
            this.helper.postAddChildInline(abstractDOMNode);
        }

        @Override
        void postRemoveChild(AbstractDOMNode abstractDOMNode) {
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void setTextContent(String string) throws DOMException {
            super.setTextContent(string);
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void normalize() {
            if (!this.helper.containsCSS()) {
                super.normalize();
            } else {
                AbstractCSSStyleSheet abstractCSSStyleSheet = this.getSheet();
                if (abstractCSSStyleSheet != null) {
                    super.setTextContent(abstractCSSStyleSheet.toString());
                } else {
                    super.normalize();
                }
            }
        }

        @Override
        public HTMLElement cloneNode(boolean bl) {
            return this.cloneElementNode(new StyleElement(this.getNamespaceURI()), bl);
        }
    }

    private class TableCellElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        TableCellElement(String string) {
            super(string);
        }

        TableCellElement(String string, String string2) {
            super(string, string2);
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("background") || this.hasAttribute("align");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), cSSStyleDeclaration);
            AttributeToStyle.width(this.getAttribute("width"), cSSStyleDeclaration);
            AttributeToStyle.height(this.getAttribute("height"), cSSStyleDeclaration);
            AttributeToStyle.background(this.getAttribute("background"), cSSStyleDeclaration);
            AttributeToStyle.align(this.getAttribute("align"), cSSStyleDeclaration);
        }
    }

    private class TableElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        TableElement() {
            super("table");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("cellspacing") || this.hasAttribute("border") || this.hasAttribute("bordercolor") || this.hasAttribute("bgcolor") || this.hasAttribute("background");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), cSSStyleDeclaration);
            AttributeToStyle.cellSpacing(this.getAttribute("cellspacing"), cSSStyleDeclaration);
            AttributeToStyle.width(this.getAttribute("width"), cSSStyleDeclaration);
            AttributeToStyle.height(this.getAttribute("height"), cSSStyleDeclaration);
            AttributeToStyle.border(this.getAttribute("border"), cSSStyleDeclaration);
            AttributeToStyle.borderColor(this.getAttribute("bordercolor"), cSSStyleDeclaration);
            AttributeToStyle.background(this.getAttribute("background"), cSSStyleDeclaration);
        }
    }

    private class TableRowElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        TableRowElement() {
            super("tr");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("height") || this.hasAttribute("background") || this.hasAttribute("align");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration cSSStyleDeclaration) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), cSSStyleDeclaration);
            AttributeToStyle.height(this.getAttribute("height"), cSSStyleDeclaration);
            AttributeToStyle.background(this.getAttribute("background"), cSSStyleDeclaration);
            AttributeToStyle.align(this.getAttribute("align"), cSSStyleDeclaration);
        }
    }
}

