/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeFloat64Array
extends NativeTypedArrayView<Double> {
    private static final long serialVersionUID = -1255405650050639335L;
    private static final String CLASS_NAME = "Float64Array";
    private static final int BYTES_PER_ELEMENT = 8;

    public NativeFloat64Array() {
    }

    public NativeFloat64Array(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2, n2 * 8);
    }

    public NativeFloat64Array(int n) {
        this(new NativeArrayBuffer((double)n * 8.0), 0, n);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeFloat64Array nativeFloat64Array = new NativeFloat64Array();
        nativeFloat64Array.exportAsJSClass(7, scriptable, bl);
    }

    protected NativeFloat64Array construct(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        return new NativeFloat64Array(nativeArrayBuffer, n, n2);
    }

    @Override
    public int getBytesPerElement() {
        return 8;
    }

    protected NativeFloat64Array realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeFloat64Array.ensureType(scriptable, NativeFloat64Array.class, idFunctionObject);
    }

    @Override
    protected Object js_get(int n) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        long l = ByteIo.readUint64Primitive(this.arrayBuffer.buffer, n * 8 + this.offset, NativeFloat64Array.useLittleEndian());
        return Double.longBitsToDouble(l);
    }

    @Override
    protected Object js_set(int n, Object object) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        double d = ScriptRuntime.toNumber(object);
        long l = Double.doubleToLongBits(d);
        ByteIo.writeUint64(this.arrayBuffer.buffer, n * 8 + this.offset, l, NativeFloat64Array.useLittleEndian());
        return null;
    }

    @Override
    public Double get(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Double)this.js_get(n);
    }

    @Override
    public Double set(int n, Double d) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Double)this.js_set(n, d);
    }
}

