/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeConsole;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;
import org.mozilla.javascript.commonjs.module.provider.SoftCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.PipeThread;
import org.mozilla.javascript.tools.shell.QuitAction;
import org.mozilla.javascript.tools.shell.Runner;
import org.mozilla.javascript.tools.shell.ShellConsole;
import org.mozilla.javascript.tools.shell.ShellConsolePrinter;

public class Global
extends ImporterTopLevel {
    static final long serialVersionUID = 4029130780977538005L;
    NativeArray history;
    boolean attemptedJLineLoad;
    private ShellConsole console;
    private InputStream inStream;
    private PrintStream outStream;
    private PrintStream errStream;
    private boolean sealedStdLib = false;
    boolean initialized;
    private QuitAction quitAction;
    private String[] prompts = new String[]{"js> ", "  > "};
    private HashMap<String, String> doctestCanonicalizations;

    public Global() {
    }

    public Global(Context context) {
        this.init(context);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initQuitAction(QuitAction quitAction) {
        if (quitAction == null) {
            throw new IllegalArgumentException("quitAction is null");
        }
        if (this.quitAction != null) {
            throw new IllegalArgumentException("The method is once-call.");
        }
        this.quitAction = quitAction;
    }

    public void init(ContextFactory contextFactory) {
        contextFactory.call(context -> {
            this.init(context);
            return null;
        });
    }

    public void init(Context context) {
        this.initStandardObjects(context, this.sealedStdLib);
        NativeConsole.init(this, this.sealedStdLib, new ShellConsolePrinter());
        String[] stringArray = new String[]{"defineClass", "deserialize", "doctest", "gc", "help", "load", "loadClass", "print", "quit", "readline", "readFile", "readUrl", "runCommand", "seal", "serialize", "spawn", "sync", "toint32", "version", "write"};
        this.defineFunctionProperties(stringArray, Global.class, 2);
        Environment.defineClass(this);
        Environment environment = new Environment(this);
        this.defineProperty("environment", (Object)environment, 2);
        this.history = (NativeArray)context.newArray((Scriptable)this, 0);
        this.defineProperty("history", (Object)this.history, 2);
        this.initialized = true;
    }

    public Require installRequire(Context context, List<String> list, boolean bl) {
        RequireBuilder requireBuilder = new RequireBuilder();
        requireBuilder.setSandboxed(bl);
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (list != null) {
            for (String string : list) {
                try {
                    URI uRI = new URI(string);
                    if (!uRI.isAbsolute()) {
                        uRI = new File(string).toURI().resolve("");
                    }
                    if (!uRI.toString().endsWith("/")) {
                        uRI = new URI(uRI + "/");
                    }
                    arrayList.add(uRI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
            }
        }
        requireBuilder.setModuleScriptProvider(new SoftCachingModuleScriptProvider(new UrlModuleSourceProvider(arrayList, null)));
        Require require = requireBuilder.createRequire(context, this);
        require.install(this);
        return require;
    }

    public static void help(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        PrintStream printStream = Global.getInstance(function).getOut();
        printStream.println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static void gc(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        System.gc();
    }

    public static Object print(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return Global.doPrint(objectArray, function, true);
    }

    public static Object write(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        return Global.doPrint(objectArray, function, false);
    }

    private static Object doPrint(Object[] objectArray, Function function, boolean bl) {
        PrintStream printStream = Global.getInstance(function).getOut();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                printStream.print(" ");
            }
            String string = Context.toString(objectArray[i]);
            printStream.print(string);
        }
        if (bl) {
            printStream.println();
        }
        return Context.getUndefinedValue();
    }

    public static void quit(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Global global = Global.getInstance(function);
        if (global.quitAction != null) {
            int n = objectArray.length == 0 ? 0 : ScriptRuntime.toInt32(objectArray[0]);
            global.quitAction.quit(context, n);
        }
    }

    public static double version(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length > 0) {
            double d = Context.toNumber(objectArray[0]);
            context.setLanguageVersion((int)d);
        }
        return context.getLanguageVersion();
    }

    public static void load(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        for (Object object : objectArray) {
            String string = Context.toString(object);
            try {
                Main.processFile(context, scriptable, string);
            }
            catch (IOException iOException) {
                String string2 = ToolErrorReporter.getMessage("msg.couldnt.read.source", string, iOException.getMessage());
                throw Context.reportRuntimeError(string2);
            }
            catch (VirtualMachineError virtualMachineError) {
                virtualMachineError.printStackTrace();
                String string3 = ToolErrorReporter.getMessage("msg.uncaughtJSException", virtualMachineError.toString());
                throw Context.reportRuntimeError(string3);
            }
        }
    }

    public static void defineClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> clazz = Global.getClass(objectArray);
        if (!Scriptable.class.isAssignableFrom(clazz)) {
            throw Global.reportRuntimeError("msg.must.implement.Scriptable");
        }
        ScriptableObject.defineClass(scriptable, clazz);
    }

    public static void loadClass(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Global.getClass(objectArray);
        if (!Script.class.isAssignableFrom(clazz)) {
            throw Global.reportRuntimeError("msg.must.implement.Script");
        }
        Script script = (Script)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        script.exec(context, scriptable);
    }

    private static Class<?> getClass(Object[] objectArray) {
        Object object;
        if (objectArray.length == 0) {
            throw Global.reportRuntimeError("msg.expected.string.arg");
        }
        Object object2 = objectArray[0];
        if (object2 instanceof Wrapper && (object = ((Wrapper)object2).unwrap()) instanceof Class) {
            return (Class)object;
        }
        object = Context.toString(objectArray[0]);
        try {
            return Class.forName((String)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw Global.reportRuntimeError("msg.class.not.found", (String)object);
        }
    }

    public static void serialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length < 2) {
            throw Context.reportRuntimeError("Expected an object to serialize and a filename to write the serialization to");
        }
        Object object = objectArray[0];
        String string = Context.toString(objectArray[1]);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ScriptableOutputStream scriptableOutputStream = new ScriptableOutputStream(fileOutputStream, scriptable2);
        scriptableOutputStream.writeObject(object);
        scriptableOutputStream.close();
    }

    public static Object deserialize(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException, ClassNotFoundException {
        if (objectArray.length < 1) {
            throw Context.reportRuntimeError("Expected a filename to read the serialization from");
        }
        String string = Context.toString(objectArray[0]);
        FileInputStream fileInputStream = new FileInputStream(string);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ScriptableInputStream scriptableInputStream = new ScriptableInputStream(fileInputStream, scriptable2);
        Object object = scriptableInputStream.readObject();
        scriptableInputStream.close();
        return Context.toObject(object, scriptable2);
    }

    public String[] getPrompts(Context context) {
        Scriptable scriptable;
        Object object;
        if (ScriptableObject.hasProperty((Scriptable)this, "prompts") && (object = ScriptableObject.getProperty((Scriptable)this, "prompts")) instanceof Scriptable && ScriptableObject.hasProperty(scriptable = (Scriptable)object, 0) && ScriptableObject.hasProperty(scriptable, 1)) {
            Object object2 = ScriptableObject.getProperty(scriptable, 0);
            if (object2 instanceof Function) {
                object2 = ((Function)object2).call(context, this, scriptable, new Object[0]);
            }
            this.prompts[0] = Context.toString(object2);
            Object object3 = ScriptableObject.getProperty(scriptable, 1);
            if (object3 instanceof Function) {
                object3 = ((Function)object3).call(context, this, scriptable, new Object[0]);
            }
            this.prompts[1] = Context.toString(object3);
        }
        return this.prompts;
    }

    public static Object doctest(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length == 0) {
            return Boolean.FALSE;
        }
        String string = Context.toString(objectArray[0]);
        Global global = Global.getInstance(function);
        return global.runDoctest(context, global, string, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runDoctest(Context context, Scriptable scriptable, String string, String string2, int n) {
        int n2;
        this.doctestCanonicalizations = new HashMap();
        String[] stringArray = string.split("\r\n?|\n");
        String string3 = this.prompts[0].trim();
        String string4 = this.prompts[1].trim();
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length && !stringArray[n2].trim().startsWith(string3); ++n2) {
        }
        while (n2 < stringArray.length) {
            String string5;
            StringBuilder stringBuilder = new StringBuilder(stringArray[n2].trim().substring(string3.length()));
            stringBuilder.append('\n');
            ++n2;
            while (n2 < stringArray.length && stringArray[n2].trim().startsWith(string4)) {
                stringBuilder.append(stringArray[n2].trim().substring(string4.length()));
                stringBuilder.append('\n');
                ++n2;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            while (n2 < stringArray.length && !stringArray[n2].trim().startsWith(string3)) {
                stringBuilder2.append(stringArray[n2]).append('\n');
                ++n2;
            }
            PrintStream printStream = this.getOut();
            PrintStream printStream2 = this.getErr();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            this.setOut(new PrintStream(byteArrayOutputStream));
            this.setErr(new PrintStream(byteArrayOutputStream2));
            String string6 = "";
            ErrorReporter errorReporter = context.getErrorReporter();
            context.setErrorReporter(new ToolErrorReporter(false, this.getErr()));
            try {
                ++n3;
                string5 = stringBuilder.toString();
                Object object = context.evaluateString(scriptable, string5, "doctest input", 1, null);
                if (!(object == Context.getUndefinedValue() || object instanceof Function && string5.trim().startsWith("function"))) {
                    string6 = Context.toString(object);
                }
            }
            catch (RhinoException rhinoException) {
                ToolErrorReporter.reportException(context.getErrorReporter(), rhinoException);
            }
            finally {
                this.setOut(printStream);
                this.setErr(printStream2);
                context.setErrorReporter(errorReporter);
                string6 = string6 + byteArrayOutputStream2.toString() + byteArrayOutputStream.toString();
            }
            if (this.doctestOutputMatches(stringBuilder2.toString(), string6)) continue;
            string5 = "doctest failure running:\n" + stringBuilder + "expected: " + stringBuilder2 + "actual: " + string6 + "\n";
            if (string2 != null) {
                throw Context.reportRuntimeError(string5, string2, n + n2 - 1, null, 0);
            }
            throw Context.reportRuntimeError(string5);
        }
        return n3;
    }

    private boolean doctestOutputMatches(String string, String string2) {
        if ((string = string.trim()).equals(string2 = string2.trim().replace("\r\n", "\n"))) {
            return true;
        }
        for (Map.Entry<String, String> object2 : this.doctestCanonicalizations.entrySet()) {
            string = string.replace(object2.getKey(), object2.getValue());
        }
        if (string.equals(string2)) {
            return true;
        }
        Pattern pattern = Pattern.compile("@[0-9a-fA-F]+");
        Matcher matcher = pattern.matcher(string);
        Matcher matcher2 = pattern.matcher(string2);
        do {
            if (!matcher.find()) {
                return false;
            }
            if (!matcher2.find()) {
                return false;
            }
            if (matcher2.start() != matcher.start()) {
                return false;
            }
            int n = matcher.start();
            if (!string.substring(0, n).equals(string2.substring(0, n))) {
                return false;
            }
            String string3 = matcher.group();
            String string4 = matcher2.group();
            String string5 = this.doctestCanonicalizations.get(string3);
            if (string5 == null) {
                this.doctestCanonicalizations.put(string3, string4);
                string = string.replace(string3, string4);
                continue;
            }
            if (string4.equals(string5)) continue;
            return false;
        } while (!string.equals(string2));
        return true;
    }

    public static Object spawn(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Runner runner;
        Object object;
        Scriptable scriptable2 = function.getParentScope();
        if (objectArray.length != 0 && objectArray[0] instanceof Function) {
            object = null;
            if (objectArray.length > 1 && objectArray[1] instanceof Scriptable) {
                object = context.getElements((Scriptable)objectArray[1]);
            }
            if (object == null) {
                object = ScriptRuntime.emptyArgs;
            }
            runner = new Runner(scriptable2, (Function)objectArray[0], (Object[])object);
        } else if (objectArray.length != 0 && objectArray[0] instanceof Script) {
            runner = new Runner(scriptable2, (Script)objectArray[0]);
        } else {
            throw Global.reportRuntimeError("msg.spawn.args");
        }
        runner.factory = context.getFactory();
        object = new Thread(runner);
        ((Thread)object).start();
        return object;
    }

    public static Object sync(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length >= 1 && objectArray.length <= 2 && objectArray[0] instanceof Function) {
            Object object = null;
            if (objectArray.length == 2 && objectArray[1] != Undefined.instance) {
                object = objectArray[1];
            }
            return new Synchronizer((Function)objectArray[0], object);
        }
        throw Global.reportRuntimeError("msg.sync.args");
    }

    public static Object runCommand(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2 = objectArray.length;
        if (n2 == 0 || n2 == 1 && objectArray[0] instanceof Scriptable) {
            throw Global.reportRuntimeError("msg.runCommand.bad.args");
        }
        File file = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        OutputStream outputStream2 = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        Object object4 = null;
        Object object5 = null;
        String[] stringArray = null;
        Scriptable scriptable2 = null;
        Object[] objectArray2 = null;
        if (objectArray[n2 - 1] instanceof Scriptable) {
            Object object6;
            Object object7;
            scriptable2 = (Scriptable)objectArray[n2 - 1];
            --n2;
            object3 = ScriptableObject.getProperty(scriptable2, "env");
            if (object3 != Scriptable.NOT_FOUND) {
                if (object3 == null) {
                    stringArray = new String[]{};
                } else {
                    if (!(object3 instanceof Scriptable)) {
                        throw Global.reportRuntimeError("msg.runCommand.bad.env");
                    }
                    object2 = (Scriptable)object3;
                    object7 = ScriptableObject.getPropertyIds((Scriptable)object2);
                    stringArray = new String[((Object[])object7).length];
                    for (int i = 0; i != ((Object[])object7).length; ++i) {
                        Object object8;
                        String string;
                        object6 = object7[i];
                        if (object6 instanceof String) {
                            string = (String)object6;
                            object8 = ScriptableObject.getProperty((Scriptable)object2, string);
                        } else {
                            int n3 = ((Number)object6).intValue();
                            string = Integer.toString(n3);
                            object8 = ScriptableObject.getProperty((Scriptable)object2, n3);
                        }
                        if (object8 == ScriptableObject.NOT_FOUND) {
                            object8 = Undefined.instance;
                        }
                        stringArray[i] = string + '=' + ScriptRuntime.toString(object8);
                    }
                }
            }
            if ((object2 = ScriptableObject.getProperty(scriptable2, "dir")) != Scriptable.NOT_FOUND) {
                file = new File(ScriptRuntime.toString(object2));
            }
            if ((object7 = ScriptableObject.getProperty(scriptable2, "input")) != Scriptable.NOT_FOUND) {
                inputStream = Global.toInputStream(object7);
            }
            if ((object4 = ScriptableObject.getProperty(scriptable2, "output")) != Scriptable.NOT_FOUND && (outputStream = Global.toOutputStream(object4)) == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = byteArrayOutputStream;
            }
            if ((object5 = ScriptableObject.getProperty(scriptable2, "err")) != Scriptable.NOT_FOUND && (outputStream2 = Global.toOutputStream(object5)) == null) {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                outputStream2 = byteArrayOutputStream2;
            }
            if ((object = ScriptableObject.getProperty(scriptable2, "args")) != Scriptable.NOT_FOUND) {
                object6 = Context.toObject(object, Global.getTopLevelScope(scriptable));
                objectArray2 = context.getElements((Scriptable)object6);
            }
        }
        object3 = Global.getInstance(function);
        if (outputStream == null) {
            outputStream = ((Global)object3).getOut();
        }
        if (outputStream2 == null) {
            outputStream2 = ((Global)object3).getErr();
        }
        object2 = new String[objectArray2 == null ? n2 : n2 + objectArray2.length];
        for (n = 0; n != n2; ++n) {
            object2[n] = ScriptRuntime.toString(objectArray[n]);
        }
        if (objectArray2 != null) {
            for (n = 0; n != objectArray2.length; ++n) {
                object2[n2 + n] = ScriptRuntime.toString(objectArray2[n]);
            }
        }
        n = Global.runProcess(object2, stringArray, file, inputStream, outputStream, outputStream2);
        if (byteArrayOutputStream != null) {
            object = ScriptRuntime.toString(object4) + byteArrayOutputStream.toString();
            ScriptableObject.putProperty(scriptable2, "output", object);
        }
        if (byteArrayOutputStream2 != null) {
            object = ScriptRuntime.toString(object5) + byteArrayOutputStream2.toString();
            ScriptableObject.putProperty(scriptable2, "err", object);
        }
        return n;
    }

    public static void seal(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object;
        int n;
        for (n = 0; n != objectArray.length; ++n) {
            object = objectArray[n];
            if (object instanceof ScriptableObject && object != Undefined.instance) continue;
            if (!(object instanceof Scriptable) || object == Undefined.instance) {
                throw Global.reportRuntimeError("msg.shell.seal.not.object");
            }
            throw Global.reportRuntimeError("msg.shell.seal.not.scriptable");
        }
        for (n = 0; n != objectArray.length; ++n) {
            object = objectArray[n];
            ((ScriptableObject)object).sealObject();
        }
    }

    public static Object readFile(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length == 0) {
            throw Global.reportRuntimeError("msg.shell.readFile.bad.args");
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        String string2 = null;
        if (objectArray.length >= 2) {
            string2 = ScriptRuntime.toString(objectArray[1]);
        }
        return Global.readUrl(string, string2, true);
    }

    public static Object readUrl(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        if (objectArray.length == 0) {
            throw Global.reportRuntimeError("msg.shell.readUrl.bad.args");
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        String string2 = null;
        if (objectArray.length >= 2) {
            string2 = ScriptRuntime.toString(objectArray[1]);
        }
        return Global.readUrl(string, string2, false);
    }

    public static Object toint32(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object;
        Object object2 = object = objectArray.length != 0 ? objectArray[0] : Undefined.instance;
        if (object instanceof Integer) {
            return object;
        }
        return ScriptRuntime.wrapInt(ScriptRuntime.toInt32(object));
    }

    private boolean loadJLine(Charset charset) {
        if (!this.attemptedJLineLoad) {
            this.attemptedJLineLoad = true;
            this.console = ShellConsole.getConsole(this, charset);
        }
        return this.console != null;
    }

    public ShellConsole getConsole(Charset charset) {
        if (!this.loadJLine(charset)) {
            this.console = ShellConsole.getConsole(this.getIn(), this.getErr(), charset);
        }
        return this.console;
    }

    public InputStream getIn() {
        if (this.inStream == null && !this.attemptedJLineLoad && this.loadJLine(Charset.defaultCharset())) {
            this.inStream = this.console.getIn();
        }
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream printStream) {
        this.outStream = printStream;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream printStream) {
        this.errStream = printStream;
    }

    public void setSealedStdLib(boolean bl) {
        this.sealedStdLib = bl;
    }

    private static Global getInstance(Function function) {
        Scriptable scriptable = function.getParentScope();
        if (!(scriptable instanceof Global)) {
            throw Global.reportRuntimeError("msg.bad.shell.function.scope", String.valueOf(scriptable));
        }
        return (Global)scriptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runProcess(String[] stringArray, String[] stringArray2, File file, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        Process process = stringArray2 == null ? Runtime.getRuntime().exec(stringArray, null, file) : Runtime.getRuntime().exec(stringArray, stringArray2, file);
        try {
            PipeThread pipeThread = null;
            if (inputStream != null) {
                pipeThread = new PipeThread(false, inputStream, process.getOutputStream());
                pipeThread.start();
            } else {
                process.getOutputStream().close();
            }
            PipeThread pipeThread2 = null;
            if (outputStream != null) {
                pipeThread2 = new PipeThread(true, process.getInputStream(), outputStream);
                pipeThread2.start();
            } else {
                process.getInputStream().close();
            }
            PipeThread pipeThread3 = null;
            if (outputStream2 != null) {
                pipeThread3 = new PipeThread(true, process.getErrorStream(), outputStream2);
                pipeThread3.start();
            } else {
                process.getErrorStream().close();
            }
            while (true) {
                try {
                    process.waitFor();
                    if (pipeThread2 != null) {
                        pipeThread2.join();
                    }
                    if (pipeThread != null) {
                        pipeThread.join();
                    }
                    if (pipeThread3 == null) break;
                    pipeThread3.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            int n = process.exitValue();
            return n;
        }
        finally {
            process.destroy();
        }
    }

    /*
     * Exception decompiling
     */
    static void pipe(boolean var0, InputStream var1_1, OutputStream var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream toInputStream(Object object) throws IOException {
        InputStream inputStream = null;
        String string = null;
        if (object instanceof Wrapper) {
            Object object2 = ((Wrapper)object).unwrap();
            if (object2 instanceof InputStream) {
                inputStream = (InputStream)object2;
            } else if (object2 instanceof byte[]) {
                inputStream = new ByteArrayInputStream((byte[])object2);
            } else if (object2 instanceof Reader) {
                string = Global.readReader((Reader)object2);
            } else if (object2 instanceof char[]) {
                string = new String((char[])object2);
            }
        }
        if (inputStream == null) {
            if (string == null) {
                string = ScriptRuntime.toString(object);
            }
            inputStream = new ByteArrayInputStream(string.getBytes());
        }
        return inputStream;
    }

    private static OutputStream toOutputStream(Object object) {
        Object object2;
        OutputStream outputStream = null;
        if (object instanceof Wrapper && (object2 = ((Wrapper)object).unwrap()) instanceof OutputStream) {
            outputStream = (OutputStream)object2;
        }
        return outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(String string, String string2, boolean bl) throws IOException {
        try (InputStream inputStream = null;){
            int n;
            Object object;
            Object object2;
            if (!bl) {
                String string3;
                object2 = new URL(string);
                object = ((URL)object2).openConnection();
                inputStream = ((URLConnection)object).getInputStream();
                n = ((URLConnection)object).getContentLength();
                if (n <= 0) {
                    n = 1024;
                }
                if (string2 == null && (string3 = ((URLConnection)object).getContentType()) != null) {
                    string2 = Global.getCharCodingFromType(string3);
                }
            } else {
                object2 = new File(string);
                if (!((File)object2).exists()) {
                    throw new FileNotFoundException("File not found: " + string);
                }
                if (!((File)object2).canRead()) {
                    throw new IOException("Cannot read file: " + string);
                }
                long l = ((File)object2).length();
                n = (int)l;
                if ((long)n != l) {
                    throw new IOException("Too big file size: " + l);
                }
                if (n == 0) {
                    String string4 = "";
                    return string4;
                }
                inputStream = new FileInputStream((File)object2);
            }
            object2 = string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2);
            object = Global.readReader((Reader)object2, n);
            return object;
        }
    }

    public static Object readline(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws IOException {
        Global global = Global.getInstance(function);
        if (objectArray.length > 0) {
            return global.console.readLine(Context.toString(objectArray[0]));
        }
        return global.console.readLine();
    }

    private static String getCharCodingFromType(String string) {
        int n = string.indexOf(59);
        if (n >= 0) {
            int n2 = string.length();
            ++n;
            while (n != n2 && string.charAt(n) <= ' ') {
                ++n;
            }
            String string2 = "charset";
            if (string2.regionMatches(true, 0, string, n, string2.length())) {
                n += string2.length();
                while (n != n2 && string.charAt(n) <= ' ') {
                    ++n;
                }
                if (n != n2 && string.charAt(n) == '=') {
                    ++n;
                    while (n != n2 && string.charAt(n) <= ' ') {
                        ++n;
                    }
                    if (n != n2) {
                        while (string.charAt(n2 - 1) <= ' ') {
                            --n2;
                        }
                        return string.substring(n, n2);
                    }
                }
            }
        }
        return null;
    }

    private static String readReader(Reader reader) throws IOException {
        return Global.readReader(reader, 4096);
    }

    private static String readReader(Reader reader, int n) throws IOException {
        int n2;
        char[] cArray = new char[n];
        int n3 = 0;
        while ((n2 = reader.read(cArray, n3, cArray.length - n3)) >= 0) {
            if ((n3 += n2) != cArray.length) continue;
            char[] cArray2 = new char[cArray.length * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            cArray = cArray2;
        }
        return new String(cArray, 0, n3);
    }

    static RuntimeException reportRuntimeError(String string) {
        String string2 = ToolErrorReporter.getMessage(string);
        return Context.reportRuntimeError(string2);
    }

    static RuntimeException reportRuntimeError(String string, String string2) {
        String string3 = ToolErrorReporter.getMessage(string, string2);
        return Context.reportRuntimeError(string3);
    }
}

