/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.optimizer.ClassCompiler;
import org.mozilla.javascript.tools.SourceReader;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private boolean printHelp;
    private ToolErrorReporter reporter = new ToolErrorReporter(true);
    private CompilerEnvirons compilerEnv = new CompilerEnvirons();
    private ClassCompiler compiler;
    private String targetName;
    private String targetPackage;
    private String destinationDir;
    private String characterEncoding;

    public static void main(String[] stringArray) {
        Main main = new Main();
        if ((stringArray = main.processOptions(stringArray)) == null) {
            if (main.printHelp) {
                System.out.println(ToolErrorReporter.getMessage("msg.jsc.usage", Main.class.getName()));
                System.exit(0);
            }
            System.exit(1);
        }
        if (!main.reporter.hasReportedError()) {
            main.processSource(stringArray);
        }
    }

    public Main() {
        this.compilerEnv.setErrorReporter(this.reporter);
        this.compiler = new ClassCompiler(this.compilerEnv);
    }

    public String[] processOptions(String[] stringArray) {
        this.targetPackage = "";
        this.compilerEnv.setGenerateDebugInfo(false);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-")) {
                int n = stringArray.length - i;
                if (this.targetName != null && n > 1) {
                    this.addError("msg.multiple.js.to.file", this.targetName);
                    return null;
                }
                String[] stringArray2 = new String[n];
                for (int j = 0; j != n; ++j) {
                    stringArray2[j] = stringArray[i + j];
                }
                return stringArray2;
            }
            if (string.equals("-help") || string.equals("-h") || string.equals("--help")) {
                this.printHelp = true;
                return null;
            }
            try {
                if (string.equals("-version") && ++i < stringArray.length) {
                    int n = Integer.parseInt(stringArray[i]);
                    this.compilerEnv.setLanguageVersion(n);
                    continue;
                }
                if ((string.equals("-opt") || string.equals("-O")) && ++i < stringArray.length) {
                    int n = Integer.parseInt(stringArray[i]);
                    this.compilerEnv.setOptimizationLevel(n);
                    continue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Main.badUsage(stringArray[i]);
                return null;
            }
            if (string.equals("-nosource")) {
                this.compilerEnv.setGeneratingSource(false);
                continue;
            }
            if (string.equals("-debug") || string.equals("-g")) {
                this.compilerEnv.setGenerateDebugInfo(true);
                continue;
            }
            if (string.equals("-main-method-class") && ++i < stringArray.length) {
                this.compiler.setMainMethodClass(stringArray[i]);
                continue;
            }
            if (string.equals("-encoding") && ++i < stringArray.length) {
                this.characterEncoding = stringArray[i];
                continue;
            }
            if (string.equals("-o") && ++i < stringArray.length) {
                String string2 = stringArray[i];
                int n = string2.length();
                if (n == 0 || !Character.isJavaIdentifierStart(string2.charAt(0))) {
                    this.addError("msg.invalid.classfile.name", string2);
                    continue;
                }
                for (int j = 1; j < n; ++j) {
                    char c = string2.charAt(j);
                    if (Character.isJavaIdentifierPart(c)) continue;
                    if (c == '.' && j == n - 6 && string2.endsWith(".class")) {
                        string2 = string2.substring(0, j);
                        break;
                    }
                    this.addError("msg.invalid.classfile.name", string2);
                    break;
                }
                this.targetName = string2;
                continue;
            }
            if (string.equals("-observe-instruction-count")) {
                this.compilerEnv.setGenerateObserverCount(true);
            }
            if (string.equals("-package") && ++i < stringArray.length) {
                String string3 = stringArray[i];
                int n = string3.length();
                for (int j = 0; j != n; ++j) {
                    char c = string3.charAt(j);
                    if (Character.isJavaIdentifierStart(c)) {
                        ++j;
                        while (j != n && Character.isJavaIdentifierPart(c = string3.charAt(j))) {
                            ++j;
                        }
                        if (j == n) break;
                        if (c == '.' && j != n - 1) continue;
                    }
                    this.addError("msg.package.name", this.targetPackage);
                    return null;
                }
                this.targetPackage = string3;
                continue;
            }
            if (string.equals("-extends") && ++i < stringArray.length) {
                Class<?> clazz;
                String string4 = stringArray[i];
                try {
                    clazz = Class.forName(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new Error(classNotFoundException.toString());
                }
                this.compiler.setTargetExtends(clazz);
                continue;
            }
            if (string.equals("-implements") && ++i < stringArray.length) {
                String string5 = stringArray[i];
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                ArrayList arrayList = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    String string6 = stringTokenizer.nextToken();
                    try {
                        arrayList.add(Class.forName(string6));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new Error(classNotFoundException.toString());
                    }
                }
                Class[] classArray = arrayList.toArray(new Class[arrayList.size()]);
                this.compiler.setTargetImplements(classArray);
                continue;
            }
            if (string.equals("-d") && ++i < stringArray.length) {
                this.destinationDir = stringArray[i];
                continue;
            }
            Main.badUsage(string);
            return null;
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        return null;
    }

    private static void badUsage(String string) {
        System.err.println(ToolErrorReporter.getMessage("msg.jsc.bad.usage", Main.class.getName(), string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSource(String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            Object object;
            Object[] objectArray;
            String string = stringArray[i];
            if (!string.endsWith(".js")) {
                this.addError("msg.extension.not.js", string);
                return;
            }
            File file = new File(string);
            String string2 = this.readSource(file);
            if (string2 == null) {
                return;
            }
            String string3 = this.targetName;
            if (string3 == null) {
                objectArray = file.getName();
                object = objectArray.substring(0, objectArray.length() - 3);
                string3 = this.getClassName((String)object);
            }
            if (this.targetPackage.length() != 0) {
                string3 = this.targetPackage + "." + string3;
            }
            if ((objectArray = this.compiler.compileToClassFiles(string2, string, 1, string3)) == null || objectArray.length == 0) {
                return;
            }
            object = null;
            if (this.destinationDir != null) {
                object = new File(this.destinationDir);
            } else {
                String string4 = file.getParent();
                if (string4 != null) {
                    object = new File(string4);
                }
            }
            for (int j = 0; j != objectArray.length; j += 2) {
                String string5 = (String)objectArray[j];
                byte[] byArray = (byte[])objectArray[j + 1];
                try {
                    File file2 = this.getOutputFile((File)object, string5);
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                        fileOutputStream.write(byArray);
                        continue;
                    }
                }
                catch (IOException iOException) {
                    this.addFormatedError(iOException.toString());
                }
            }
        }
    }

    private String readSource(File file) {
        String string = file.getAbsolutePath();
        if (!file.isFile()) {
            this.addError("msg.jsfile.not.found", string);
            return null;
        }
        try {
            return (String)SourceReader.readFileOrUrl(string, true, this.characterEncoding);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addError("msg.couldnt.open", string);
        }
        catch (IOException iOException) {
            this.addFormatedError(iOException.toString());
        }
        return null;
    }

    private File getOutputFile(File file, String string) throws IOException {
        File file2;
        String string2 = string.replace('.', File.separatorChar);
        File file3 = new File(file, string2 = string2.concat(".class"));
        String string3 = file3.getParent();
        if (string3 != null && !(file2 = new File(string3)).exists() && !file2.mkdirs()) {
            throw new IOException("Error making output directory " + string3);
        }
        return file3;
    }

    String getClassName(String string) {
        char[] cArray = new char[string.length() + 1];
        int n = 0;
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            cArray[n++] = 95;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2);
            cArray[n] = Character.isJavaIdentifierPart((char)n3) ? n3 : 95;
            ++n2;
            ++n;
        }
        return new String(cArray).trim();
    }

    private static void p(String string) {
        System.out.println(string);
    }

    private void addError(String string, String string2) {
        String string3 = string2 == null ? ToolErrorReporter.getMessage(string) : ToolErrorReporter.getMessage(string, string2);
        this.addFormatedError(string3);
    }

    private void addFormatedError(String string) {
        this.reporter.error(string, null, -1, null, -1);
    }
}

