/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptRuntime;

class BodyCodegen {
    private static final int JAVASCRIPT_EXCEPTION = 0;
    private static final int EVALUATOR_EXCEPTION = 1;
    private static final int ECMAERROR_EXCEPTION = 2;
    private static final int THROWABLE_EXCEPTION = 3;
    private static final int FINALLY_EXCEPTION = 4;
    private static final int EXCEPTION_MAX = 5;
    private ExceptionManager exceptionManager = new ExceptionManager();
    static final int GENERATOR_TERMINATE = -1;
    static final int GENERATOR_START = 0;
    static final int GENERATOR_YIELD_START = 1;
    ClassFileWriter cfw;
    Codegen codegen;
    CompilerEnvirons compilerEnv;
    ScriptNode scriptOrFn;
    public int scriptOrFnIndex;
    private int savedCodeOffset;
    private OptFunctionNode fnCurrent;
    private static final int MAX_LOCALS = 1024;
    private int[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private int itsLineNumber;
    private boolean hasVarsInRegs;
    private short[] varRegisters;
    private boolean inDirectCallFunction;
    private boolean itsForcedObjectParameters;
    private int enterAreaStartLabel;
    private int epilogueLabel;
    private boolean inLocalBlock;
    private short variableObjectLocal;
    private short popvLocal;
    private short contextLocal;
    private short argsLocal;
    private short operationLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private short generatorStateLocal;
    private boolean isGenerator;
    private int generatorSwitch;
    private int maxLocals = 0;
    private int maxStack = 0;
    private Map<Node, FinallyReturnPoint> finallys;
    private List<Node> literals;
    private int unnestedYieldCount = 0;
    private IdentityHashMap<Node, String> unnestedYields = new IdentityHashMap();

    BodyCodegen() {
    }

    void generateBodyCode() {
        Object object;
        this.isGenerator = Codegen.isGenerator(this.scriptOrFn);
        this.initBodyGeneration();
        if (this.isGenerator) {
            object = "(" + this.codegen.mainClassSignature + "Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;";
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn) + "_gen", (String)object, (short)10);
        } else {
            this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        }
        this.generatePrologue();
        object = this.fnCurrent != null ? this.scriptOrFn.getLastChild() : this.scriptOrFn;
        this.generateStatement((Node)object);
        this.generateEpilogue();
        this.cfw.stopMethod((short)(this.localsMax + 1));
        if (this.isGenerator) {
            this.generateGenerator();
        }
        if (this.literals != null) {
            block4: for (int i = 0; i < this.literals.size(); ++i) {
                Node node = this.literals.get(i);
                int n = node.getType();
                switch (n) {
                    case 67: {
                        this.generateObjectLiteralFactory(node, i + 1);
                        continue block4;
                    }
                    case 66: {
                        this.generateArrayLiteralFactory(node, i + 1);
                        continue block4;
                    }
                    default: {
                        Kit.codeBug(Token.typeToName(n));
                    }
                }
            }
        }
    }

    private void generateGenerator() {
        this.cfw.startMethod(this.codegen.getBodyMethodName(this.scriptOrFn), this.codegen.getBodyMethodSignature(this.scriptOrFn), (short)10);
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        this.cfw.addALoad(this.funObjLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.addPush(this.scriptOrFn.isInStrictMode());
        this.addScriptRuntimeInvoke("createFunctionActivation", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Z)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(this.scriptOrFnIndex);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        this.generateNestedFunctionInits();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.thisObjLocal);
        this.cfw.addLoadConstant(this.maxLocals);
        this.cfw.addLoadConstant(this.maxStack);
        this.addOptRuntimeInvoke("createNativeGenerator", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;II)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateNestedFunctionInits() {
        int n = this.scriptOrFn.getFunctionCount();
        for (int i = 0; i != n; ++i) {
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, i);
            if (optFunctionNode.fnode.getFunctionType() != 1) continue;
            this.visitFunction(optFunctionNode, 1);
        }
    }

    private void initBodyGeneration() {
        this.varRegisters = null;
        if (this.scriptOrFn.getType() == 113) {
            int n;
            this.fnCurrent = OptFunctionNode.get(this.scriptOrFn);
            boolean bl = this.hasVarsInRegs = !this.fnCurrent.fnode.requiresActivation();
            if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getParamAndVarCount()) != 0) {
                this.varRegisters = new short[n];
            }
            this.inDirectCallFunction = this.fnCurrent.isTargetOfDirectCall();
            if (this.inDirectCallFunction && !this.hasVarsInRegs) {
                Codegen.badTree();
            }
        } else {
            this.fnCurrent = null;
            this.hasVarsInRegs = false;
            this.inDirectCallFunction = false;
        }
        this.locals = new int[1024];
        this.funObjLocal = 0;
        this.contextLocal = 1;
        this.variableObjectLocal = (short)2;
        this.thisObjLocal = (short)3;
        this.localsMax = (short)4;
        this.firstFreeLocal = (short)4;
        this.popvLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        this.epilogueLabel = -1;
        this.enterAreaStartLabel = -1;
        this.generatorStateLocal = (short)-1;
    }

    private void generatePrologue() {
        String string;
        int n;
        int n2;
        int n3;
        if (this.inDirectCallFunction) {
            n3 = this.scriptOrFn.getParamCount();
            if (this.firstFreeLocal != 4) {
                Kit.codeBug();
            }
            for (n2 = 0; n2 != n3; ++n2) {
                this.varRegisters[n2] = this.firstFreeLocal;
                this.firstFreeLocal = (short)(this.firstFreeLocal + 3);
            }
            if (!this.fnCurrent.getParameterNumberContext()) {
                this.itsForcedObjectParameters = true;
                for (n2 = 0; n2 != n3; ++n2) {
                    n = this.varRegisters[n2];
                    this.cfw.addALoad(n);
                    this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n4 = this.cfw.acquireLabel();
                    this.cfw.add(166, n4);
                    this.cfw.addDLoad(n + 1);
                    this.addDoubleWrap();
                    this.cfw.addAStore(n);
                    this.cfw.markLabel(n4);
                }
            }
        }
        if (this.fnCurrent != null) {
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addInvoke(185, "org/mozilla/javascript/Scriptable", "getParentScope", "()Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
        }
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        if (this.isGenerator) {
            List<Node> list;
            short s2 = this.firstFreeLocal;
            this.firstFreeLocal = (short)(s2 + 1);
            this.operationLocal = s2;
            this.localsMax = this.firstFreeLocal;
            this.cfw.addALoad(this.thisObjLocal);
            short s3 = this.firstFreeLocal;
            this.firstFreeLocal = (short)(s3 + 1);
            this.generatorStateLocal = s3;
            this.localsMax = this.firstFreeLocal;
            this.cfw.add(192, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState");
            this.cfw.add(89);
            this.cfw.addAStore(this.generatorStateLocal);
            this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "thisObj", "Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.thisObjLocal);
            if (this.epilogueLabel == -1) {
                this.epilogueLabel = this.cfw.acquireLabel();
            }
            if ((list = ((FunctionNode)this.scriptOrFn).getResumptionPoints()) != null) {
                this.generateGetGeneratorResumptionPoint();
                this.generatorSwitch = this.cfw.addTableSwitch(0, list.size() + 0);
                this.generateCheckForThrowOrClose(-1, false, 0);
            }
        }
        if (this.fnCurrent == null) {
            if (this.scriptOrFn.getRegexpCount() != 0) {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addInvoke(184, this.codegen.mainClassName, "_reInit", "(Lorg/mozilla/javascript/Context;)V");
            }
            if (this.scriptOrFn.getTemplateLiteralCount() != 0) {
                this.cfw.addInvoke(184, this.codegen.mainClassName, "_qInit", "()V");
            }
        }
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.saveCurrentCodeOffset();
        }
        if (this.isGenerator) {
            return;
        }
        if (this.hasVarsInRegs) {
            n3 = this.scriptOrFn.getParamCount();
            if (n3 > 0 && !this.inDirectCallFunction) {
                this.cfw.addALoad(this.argsLocal);
                this.cfw.add(190);
                this.cfw.addPush(n3);
                n2 = this.cfw.acquireLabel();
                this.cfw.add(162, n2);
                this.cfw.addALoad(this.argsLocal);
                this.cfw.addPush(n3);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)[Ljava/lang/Object;");
                this.cfw.addAStore(this.argsLocal);
                this.cfw.markLabel(n2);
            }
            n2 = this.fnCurrent.fnode.getParamCount();
            n = this.fnCurrent.fnode.getParamAndVarCount();
            boolean[] blArray = this.fnCurrent.fnode.getParamAndVarConst();
            int n5 = -1;
            for (int i = 0; i != n; ++i) {
                int n6 = -1;
                if (i < n2) {
                    if (!this.inDirectCallFunction) {
                        n6 = this.getNewWordLocal();
                        this.cfw.addALoad(this.argsLocal);
                        this.cfw.addPush(i);
                        this.cfw.add(50);
                        this.cfw.addAStore(n6);
                    }
                } else if (this.fnCurrent.isNumberVar(i)) {
                    n6 = this.getNewWordPairLocal(blArray[i]);
                    this.cfw.addPush(0.0);
                    this.cfw.addDStore(n6);
                } else {
                    n6 = this.getNewWordLocal(blArray[i]);
                    if (n5 == -1) {
                        Codegen.pushUndefined(this.cfw);
                        n5 = n6;
                    } else {
                        this.cfw.addALoad(n5);
                    }
                    this.cfw.addAStore(n6);
                }
                if (n6 >= 0) {
                    if (blArray[i]) {
                        this.cfw.addPush(0);
                        this.cfw.addIStore(n6 + (this.fnCurrent.isNumberVar(i) ? 2 : 1));
                    }
                    this.varRegisters[i] = n6;
                }
                if (!this.compilerEnv.isGenerateDebugInfo()) continue;
                String string2 = this.fnCurrent.fnode.getParamOrVarName(i);
                String string3 = this.fnCurrent.isNumberVar(i) ? "D" : "Ljava/lang/Object;";
                int n7 = this.cfw.getCurrentCodeOffset();
                if (n6 < 0) {
                    n6 = this.varRegisters[i];
                }
                this.cfw.addVariableDescriptor(string2, string3, n7, n6);
            }
            return;
        }
        n2 = 0;
        if (this.scriptOrFn instanceof FunctionNode) {
            int n8 = n2 = ((FunctionNode)this.scriptOrFn).getFunctionType() == 4 ? 1 : 0;
        }
        if (this.fnCurrent != null) {
            string = "activation";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.argsLocal);
            String string4 = n2 != 0 ? "createArrowFunctionActivation" : "createFunctionActivation";
            this.cfw.addPush(this.scriptOrFn.isInStrictMode());
            this.addScriptRuntimeInvoke(string4, "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Z)Lorg/mozilla/javascript/Scriptable;");
            this.cfw.addAStore(this.variableObjectLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("enterActivationFunction", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V");
        } else {
            string = "global";
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addPush(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Z)V");
        }
        this.enterAreaStartLabel = this.cfw.acquireLabel();
        this.epilogueLabel = this.cfw.acquireLabel();
        this.cfw.markLabel(this.enterAreaStartLabel);
        this.generateNestedFunctionInits();
        if (this.compilerEnv.isGenerateDebugInfo()) {
            this.cfw.addVariableDescriptor(string, "Lorg/mozilla/javascript/Scriptable;", this.cfw.getCurrentCodeOffset(), this.variableObjectLocal);
        }
        if (this.fnCurrent == null) {
            this.popvLocal = this.getNewWordLocal();
            Codegen.pushUndefined(this.cfw);
            this.cfw.addAStore(this.popvLocal);
            int n9 = this.scriptOrFn.getEndLineno();
            if (n9 != -1) {
                this.cfw.addLineNumberEntry((short)n9);
            }
        } else {
            if (this.fnCurrent.itsContainsCalls0) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.cfw.addAStore(this.itsZeroArgArray);
            }
            if (this.fnCurrent.itsContainsCalls1) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.cfw.addPush(1);
                this.cfw.add(189, "java/lang/Object");
                this.cfw.addAStore(this.itsOneArgArray);
            }
        }
    }

    private void generateGetGeneratorResumptionPoint() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.add(180, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", "I");
    }

    private void generateSetGeneratorResumptionPoint(int n) {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.addLoadConstant(n);
        this.cfw.add(181, "org/mozilla/javascript/optimizer/OptRuntime$GeneratorState", "resumptionPoint", "I");
    }

    private void generateGetGeneratorStackState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorStackState", "(Ljava/lang/Object;)[Ljava/lang/Object;");
    }

    private void generateEpilogue() {
        if (this.compilerEnv.isGenerateObserverCount()) {
            this.addInstructionCount();
        }
        if (this.isGenerator) {
            int n;
            Object object;
            Map<Node, int[]> map = ((FunctionNode)this.scriptOrFn).getLiveLocals();
            if (map != null) {
                List<Node> list = ((FunctionNode)this.scriptOrFn).getResumptionPoints();
                Iterator<Node> object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    int[] nArray = map.get(object);
                    if (nArray == null) continue;
                    this.cfw.markTableSwitchCase(this.generatorSwitch, this.getNextGeneratorState((Node)object));
                    this.generateGetGeneratorLocalsState();
                    for (n = 0; n < nArray.length; ++n) {
                        this.cfw.add(89);
                        this.cfw.addLoadConstant(n);
                        this.cfw.add(50);
                        this.cfw.addAStore(nArray[n]);
                    }
                    this.cfw.add(87);
                    this.cfw.add(167, this.getTargetLabel((Node)object));
                }
            }
            if (this.finallys != null) {
                for (Map.Entry entry : this.finallys.entrySet()) {
                    if (((Node)entry.getKey()).getType() != 129) continue;
                    object = (FinallyReturnPoint)entry.getValue();
                    this.cfw.markLabel(((FinallyReturnPoint)object).tableLabel, (short)1);
                    int n2 = this.cfw.addTableSwitch(0, ((FinallyReturnPoint)object).jsrPoints.size() - 1);
                    n = 0;
                    this.cfw.markTableSwitchDefault(n2);
                    for (int i = 0; i < ((FinallyReturnPoint)object).jsrPoints.size(); ++i) {
                        this.cfw.markTableSwitchCase(n2, n);
                        this.cfw.add(167, ((FinallyReturnPoint)object).jsrPoints.get(i));
                        ++n;
                    }
                }
            }
        }
        if (this.epilogueLabel != -1) {
            this.cfw.markLabel(this.epilogueLabel);
        }
        if (this.isGenerator) {
            if (((FunctionNode)this.scriptOrFn).getResumptionPoints() != null) {
                this.cfw.markTableSwitchDefault(this.generatorSwitch);
            }
            this.generateSetGeneratorResumptionPoint(-1);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.generatorStateLocal);
            this.addOptRuntimeInvoke("throwStopIteration", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            Codegen.pushUndefined(this.cfw);
            this.cfw.add(176);
        } else if (this.hasVarsInRegs) {
            this.cfw.add(176);
        } else if (this.fnCurrent == null) {
            this.cfw.addALoad(this.popvLocal);
            this.cfw.add(176);
        } else {
            this.generateActivationExit();
            this.cfw.add(176);
            int n = this.cfw.acquireLabel();
            this.cfw.markHandler(n);
            short s = this.getNewWordLocal();
            this.cfw.addAStore(s);
            this.generateActivationExit();
            this.cfw.addALoad(s);
            this.releaseWordLocal(s);
            this.cfw.add(191);
            this.cfw.addExceptionHandler(this.enterAreaStartLabel, this.epilogueLabel, n, null);
        }
    }

    private void generateGetGeneratorLocalsState() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.addOptRuntimeInvoke("getGeneratorLocalsState", "(Ljava/lang/Object;)[Ljava/lang/Object;");
    }

    private void generateSetGeneratorReturnValue() {
        this.cfw.addALoad(this.generatorStateLocal);
        this.cfw.add(95);
        this.addOptRuntimeInvoke("setGeneratorReturnValue", "(Ljava/lang/Object;Ljava/lang/Object;)V");
    }

    private void generateActivationExit() {
        if (this.fnCurrent == null || this.hasVarsInRegs) {
            throw Kit.codeBug();
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("exitActivationFunction", "(Lorg/mozilla/javascript/Context;)V");
    }

    private void generateStatement(Node node) {
        this.updateLineNumber(node);
        int n = node.getType();
        Node node2 = node.getFirstChild();
        switch (n) {
            case 127: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 140: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount(1);
                }
                while (node2 != null) {
                    this.generateStatement(node2);
                    node2 = node2.getNext();
                }
                break;
            }
            case 145: {
                boolean bl = this.inLocalBlock;
                this.inLocalBlock = true;
                short s = this.getNewWordLocal();
                if (this.isGenerator) {
                    this.cfw.add(1);
                    this.cfw.addAStore(s);
                }
                node.putIntProp(2, s);
                while (node2 != null) {
                    this.generateStatement(node2);
                    node2 = node2.getNext();
                }
                this.releaseWordLocal(s);
                node.removeProp(2);
                this.inLocalBlock = bl;
                break;
            }
            case 113: {
                int n2 = node.getExistingIntProp(1);
                OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, n2);
                int n3 = optFunctionNode.fnode.getFunctionType();
                if (n3 == 3) {
                    this.visitFunction(optFunctionNode, n3);
                    break;
                }
                if (n3 == 1) break;
                throw Codegen.badTree();
            }
            case 84: {
                this.visitTryCatchFinally((Jump)node, node2);
                break;
            }
            case 57: {
                this.cfw.setStackTop((short)0);
                int n4 = BodyCodegen.getLocalBlockRegister(node);
                int n5 = node.getExistingIntProp(14);
                String string = null;
                if (node2.getType() == 39) {
                    string = node2.getString();
                }
                node2 = node2.getNext();
                this.generateExpression(node2, node);
                if (n5 == 0) {
                    this.cfw.add(1);
                } else {
                    this.cfw.addALoad(n4);
                }
                if (string != null) {
                    this.cfw.addPush(string);
                } else {
                    this.cfw.add(1);
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("newCatchScope", "(Ljava/lang/Throwable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(n4);
                break;
            }
            case 50: {
                this.generateExpression(node2, node);
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.generateThrowJavaScriptException();
                break;
            }
            case 51: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.cfw.addALoad(BodyCodegen.getLocalBlockRegister(node));
                this.cfw.add(191);
                break;
            }
            case 4: 
            case 65: {
                if (node2 != null) {
                    this.generateExpression(node2, node);
                } else if (n == 4) {
                    Codegen.pushUndefined(this.cfw);
                } else {
                    if (this.popvLocal < 0) {
                        throw Codegen.badTree();
                    }
                    this.cfw.addALoad(this.popvLocal);
                }
                if (this.isGenerator) {
                    this.generateSetGeneratorReturnValue();
                }
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                if (this.epilogueLabel == -1) {
                    if (!this.hasVarsInRegs) {
                        throw Codegen.badTree();
                    }
                    this.epilogueLabel = this.cfw.acquireLabel();
                }
                this.cfw.add(167, this.epilogueLabel);
                break;
            }
            case 118: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.visitSwitch((Jump)node, node2);
                break;
            }
            case 2: {
                this.generateExpression(node2, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                this.incReferenceWordLocal(this.variableObjectLocal);
                break;
            }
            case 3: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
                this.cfw.addAStore(this.variableObjectLocal);
                this.decReferenceWordLocal(this.variableObjectLocal);
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.generateExpression(node2, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                int n6 = n == 58 ? 0 : (n == 59 ? 1 : (n == 61 ? 6 : 2));
                this.cfw.addPush(n6);
                this.addScriptRuntimeInvoke("enumInit", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                this.cfw.addAStore(BodyCodegen.getLocalBlockRegister(node));
                break;
            }
            case 137: {
                if (node2.getType() == 56) {
                    this.visitSetVar(node2, node2.getFirstChild(), false);
                    break;
                }
                if (node2.getType() == 160) {
                    this.visitSetConstVar(node2, node2.getFirstChild(), false);
                    break;
                }
                if (node2.getType() == 73 || node2.getType() == 169) {
                    this.generateYieldPoint(node2, false);
                    break;
                }
                this.generateExpression(node2, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.add(88);
                    break;
                }
                this.cfw.add(87);
                break;
            }
            case 138: {
                this.generateExpression(node2, node);
                if (this.popvLocal < 0) {
                    this.popvLocal = this.getNewWordLocal();
                }
                this.cfw.addAStore(this.popvLocal);
                break;
            }
            case 135: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                int n7 = this.getTargetLabel(node);
                this.cfw.markLabel(n7);
                if (!this.compilerEnv.isGenerateObserverCount()) break;
                this.saveCurrentCodeOffset();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 139: {
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.addInstructionCount();
                }
                this.visitGoto((Jump)node, n, node2);
                break;
            }
            case 129: {
                if (!this.isGenerator) break;
                if (this.compilerEnv.isGenerateObserverCount()) {
                    this.saveCurrentCodeOffset();
                }
                this.cfw.setStackTop((short)1);
                short s = this.getNewWordLocal();
                int n8 = this.cfw.acquireLabel();
                int n9 = this.cfw.acquireLabel();
                this.cfw.markLabel(n8);
                this.generateIntegerWrap();
                this.cfw.addAStore(s);
                while (node2 != null) {
                    this.generateStatement(node2);
                    node2 = node2.getNext();
                }
                this.cfw.addALoad(s);
                this.cfw.add(192, "java/lang/Integer");
                this.generateIntegerUnwrap();
                FinallyReturnPoint finallyReturnPoint = this.finallys.get(node);
                finallyReturnPoint.tableLabel = this.cfw.acquireLabel();
                this.cfw.add(167, finallyReturnPoint.tableLabel);
                this.cfw.setStackTop((short)0);
                this.releaseWordLocal(s);
                this.cfw.markLabel(n9);
                break;
            }
            case 164: {
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
    }

    private void generateIntegerWrap() {
        this.cfw.addInvoke(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
    }

    private void generateIntegerUnwrap() {
        this.cfw.addInvoke(182, "java/lang/Integer", "intValue", "()I");
    }

    private void generateThrowJavaScriptException() {
        this.cfw.add(187, "org/mozilla/javascript/JavaScriptException");
        this.cfw.add(90);
        this.cfw.add(95);
        this.cfw.addPush(this.scriptOrFn.getSourceName());
        this.cfw.addPush(this.itsLineNumber);
        this.cfw.addInvoke(183, "org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;Ljava/lang/String;I)V");
        this.cfw.add(191);
    }

    private int getNextGeneratorState(Node node) {
        int n = ((FunctionNode)this.scriptOrFn).getResumptionPoints().indexOf(node);
        return n + 1;
    }

    private void generateExpression(Node node, Node node2) {
        int n = node.getType();
        block0 : switch (n) {
            case 142: {
                break;
            }
            case 113: {
                if (this.fnCurrent == null && node2.getType() == 140) break;
                int n2 = node.getExistingIntProp(1);
                OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFn, n2);
                int n3 = optFunctionNode.fnode.getFunctionType();
                if (n3 != 2 && n3 != 4) {
                    throw Codegen.badTree();
                }
                this.visitFunction(optFunctionNode, n3);
                break;
            }
            case 39: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
                break;
            }
            case 30: 
            case 38: {
                Node node3;
                int n4 = node.getIntProp(10, 0);
                if (n4 == 0) {
                    OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(9);
                    if (optFunctionNode != null) {
                        this.visitOptimizedCall(node, optFunctionNode, n, node3);
                        break;
                    }
                    if (n == 38) {
                        this.visitStandardCall(node, node3);
                        break;
                    }
                    this.visitStandardNew(node, node3);
                    break;
                }
                this.visitSpecialCall(node, n, n4, node3);
                break;
            }
            case 71: {
                Node node3;
                this.generateFunctionAndThisObj(node3, node);
                node3 = node3.getNext();
                this.generateCallArgArray(node, node3, false);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("callRef", "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Ref;");
                break;
            }
            case 40: {
                double d = node.getDouble();
                if (node.getIntProp(8, -1) != -1) {
                    this.cfw.addPush(d);
                    break;
                }
                this.codegen.pushNumberAsObject(this.cfw, d);
                break;
            }
            case 83: {
                byte[] byArray = node.getBigInt().toByteArray();
                this.cfw.add(187, "java/math/BigInteger");
                this.cfw.add(89);
                this.cfw.addPush(byArray.length);
                this.cfw.add(188, 8);
                for (int i = 0; i < byArray.length; ++i) {
                    this.cfw.add(89);
                    this.cfw.addPush(i);
                    this.cfw.add(16, byArray[i]);
                    this.cfw.add(84);
                }
                this.cfw.addInvoke(183, "java/math/BigInteger", "<init>", "([B)V");
                break;
            }
            case 41: {
                this.cfw.addPush(node.getString());
                break;
            }
            case 43: {
                this.cfw.addALoad(this.thisObjLocal);
                break;
            }
            case 64: {
                this.cfw.add(42);
                break;
            }
            case 42: {
                this.cfw.add(1);
                break;
            }
            case 45: {
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 44: {
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 48: {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                int n5 = node.getExistingIntProp(4);
                this.cfw.add(178, this.codegen.mainClassName, this.codegen.getCompiledRegexpName(this.scriptOrFn, n5), "Ljava/lang/Object;");
                this.cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 92: {
                Node node3;
                for (Node node4 = node3.getNext(); node4 != null; node4 = node4.getNext()) {
                    this.generateExpression(node3, node);
                    this.cfw.add(87);
                    node3 = node4;
                }
                this.generateExpression(node3, node);
                break;
            }
            case 62: 
            case 63: {
                int n6 = BodyCodegen.getLocalBlockRegister(node);
                this.cfw.addALoad(n6);
                this.cfw.addALoad(this.contextLocal);
                if (n == 62) {
                    this.addScriptRuntimeInvoke("enumNext", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Boolean;");
                    break;
                }
                this.addScriptRuntimeInvoke("enumId", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 66: {
                Node node3;
                this.visitArrayLiteral(node, node3, false);
                break;
            }
            case 67: {
                Node node3;
                this.visitObjectLiteral(node, node3, false);
                break;
            }
            case 26: {
                Node node3;
                int n7 = this.cfw.acquireLabel();
                int n8 = this.cfw.acquireLabel();
                int n9 = this.cfw.acquireLabel();
                this.generateIfJump(node3, node, n7, n8);
                this.cfw.markLabel(n7);
                this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.cfw.add(167, n9);
                this.cfw.markLabel(n8);
                this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.cfw.markLabel(n9);
                this.cfw.adjustStackTop(-1);
                break;
            }
            case 27: {
                Node node3;
                this.visitBitNot(node, node3);
                break;
            }
            case 130: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.add(87);
                Codegen.pushUndefined(this.cfw);
                break;
            }
            case 32: {
                Node node3;
                this.generateExpression(node3, node);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                break;
            }
            case 141: {
                this.visitTypeofname(node);
                break;
            }
            case 110: 
            case 111: {
                this.visitIncDec(node);
                break;
            }
            case 108: 
            case 109: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.add(89);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int n10 = this.cfw.acquireLabel();
                if (n == 109) {
                    this.cfw.add(153, n10);
                } else {
                    this.cfw.add(154, n10);
                }
                this.cfw.add(87);
                this.generateExpression(node3.getNext(), node);
                this.cfw.markLabel(n10);
                break;
            }
            case 106: {
                Node node3;
                Node node5 = node3.getNext();
                Node node6 = node5.getNext();
                this.generateExpression(node3, node);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                int n11 = this.cfw.acquireLabel();
                this.cfw.add(153, n11);
                short s = this.cfw.getStackTop();
                this.generateExpression(node5, node);
                int n12 = this.cfw.acquireLabel();
                this.cfw.add(167, n12);
                this.cfw.markLabel(n11, s);
                this.generateExpression(node6, node);
                this.cfw.markLabel(n12);
                break;
            }
            case 21: {
                Node node3;
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                switch (node.getIntProp(8, -1)) {
                    case 0: {
                        this.cfw.add(99);
                        break block0;
                    }
                    case 1: {
                        this.cfw.addALoad(this.contextLocal);
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                        break block0;
                    }
                    case 2: {
                        this.cfw.addALoad(this.contextLocal);
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                        break block0;
                    }
                }
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Node node3;
                this.visitArithmetic(node, n, node3, node2);
                break;
            }
            case 75: {
                Node node3;
                this.visitExponentiation(node, node3, node2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: {
                Node node3;
                this.visitBitOp(node, n, node3);
                break;
            }
            case 28: {
                Node node3;
                int n13 = node.getIntProp(8, -1);
                this.generateExpression(node3, node);
                if (n13 != -1) break;
                this.addObjectToDouble();
                this.addDoubleWrap();
                break;
            }
            case 29: {
                Node node3;
                int n14 = node.getIntProp(8, -1);
                this.generateExpression(node3, node);
                if (n14 == -1) {
                    this.addObjectToNumeric();
                    this.addScriptRuntimeInvoke("negate", "(Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                this.cfw.add(119);
                break;
            }
            case 154: {
                Node node3;
                this.generateExpression(node3, node);
                this.addObjectToDouble();
                break;
            }
            case 153: {
                Node node3;
                int n15 = -1;
                if (node3.getType() == 40) {
                    n15 = node3.getIntProp(8, -1);
                }
                if (n15 != -1) {
                    node3.removeProp(8);
                    this.generateExpression(node3, node);
                    node3.putIntProp(8, n15);
                    break;
                }
                this.generateExpression(node3, node);
                this.addDoubleWrap();
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 52: 
            case 53: {
                Node node3;
                int n16 = this.cfw.acquireLabel();
                int n17 = this.cfw.acquireLabel();
                this.visitIfJumpRelOp(node, node3, n16, n17);
                this.addJumpedBooleanWrap(n16, n17);
                break;
            }
            case 12: 
            case 13: 
            case 46: 
            case 47: {
                Node node3;
                int n18 = this.cfw.acquireLabel();
                int n19 = this.cfw.acquireLabel();
                this.visitIfJumpEqOp(node, node3, n18, n19);
                this.addJumpedBooleanWrap(n18, n19);
                break;
            }
            case 33: 
            case 34: {
                Node node3;
                this.visitGetProp(node, node3);
                break;
            }
            case 36: {
                Node node3;
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                if (node.getIntProp(8, -1) != -1) {
                    this.addScriptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                    break;
                }
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                break;
            }
            case 68: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refGet", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 55: {
                this.visitGetVar(node);
                break;
            }
            case 56: {
                Node node3;
                this.visitSetVar(node, node3, true);
                break;
            }
            case 8: {
                Node node3;
                this.visitSetName(node, node3);
                break;
            }
            case 74: {
                Node node3;
                this.visitStrictSetName(node, node3);
                break;
            }
            case 159: {
                Node node3;
                this.visitSetConst(node, node3);
                break;
            }
            case 160: {
                Node node3;
                this.visitSetConstVar(node, node3, true);
                break;
            }
            case 35: 
            case 143: {
                Node node3;
                this.visitSetProp(n, node, node3);
                break;
            }
            case 37: 
            case 144: {
                Node node3;
                this.visitSetElem(n, node, node3);
                break;
            }
            case 69: 
            case 146: {
                Node node3;
                this.generateExpression(node3, node);
                node3 = node3.getNext();
                if (n == 146) {
                    this.cfw.add(89);
                    this.cfw.addALoad(this.contextLocal);
                    this.addScriptRuntimeInvoke("refGet", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                }
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("refSet", "(Lorg/mozilla/javascript/Ref;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
                break;
            }
            case 70: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("refDel", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 31: {
                Node node3;
                boolean bl = node3.getType() == 49;
                this.generateExpression(node3, node);
                node3 = node3.getNext();
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(bl);
                this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Z)Ljava/lang/Object;");
                break;
            }
            case 49: {
                Node node3;
                for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                    this.generateExpression(node3, node);
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node.getString());
                this.addScriptRuntimeInvoke("bind", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Lorg/mozilla/javascript/Scriptable;");
                break;
            }
            case 54: {
                this.cfw.addALoad(BodyCodegen.getLocalBlockRegister(node));
                break;
            }
            case 72: {
                Node node3;
                String string = (String)node.getProp(17);
                this.generateExpression(node3, node);
                this.cfw.addPush(string);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("specialRef", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Ref;");
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                String string;
                String string2;
                Node node3;
                int n20 = node.getIntProp(16, 0);
                do {
                    this.generateExpression(node3, node);
                } while ((node3 = node3.getNext()) != null);
                this.cfw.addALoad(this.contextLocal);
                switch (n) {
                    case 79: {
                        string2 = "memberRef";
                        string = "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Lorg/mozilla/javascript/Ref;";
                        break;
                    }
                    case 80: {
                        string2 = "memberRef";
                        string = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;I)Lorg/mozilla/javascript/Ref;";
                        break;
                    }
                    case 81: {
                        string2 = "nameRef";
                        string = "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Lorg/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    case 82: {
                        string2 = "nameRef";
                        string = "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Lorg/mozilla/javascript/Ref;";
                        this.cfw.addALoad(this.variableObjectLocal);
                        break;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
                this.cfw.addPush(n20);
                this.addScriptRuntimeInvoke(string2, string);
                break;
            }
            case 150: {
                Node node3;
                this.visitDotQuery(node, node3);
                break;
            }
            case 77: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeAttributeValue", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 78: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("escapeTextValue", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/String;");
                break;
            }
            case 76: {
                Node node3;
                this.generateExpression(node3, node);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("setDefaultNamespace", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
                break;
            }
            case 73: 
            case 169: {
                this.generateYieldPoint(node, true);
                break;
            }
            case 163: {
                Node node3;
                Node node7 = node3.getNext();
                Node node8 = node7.getNext();
                this.generateStatement(node3);
                this.generateExpression(node7.getFirstChild(), node7);
                this.generateStatement(node8);
                break;
            }
            case 161: {
                Node node3;
                Node node9 = node3.getNext();
                this.generateStatement(node3);
                this.generateExpression(node9, node);
                break;
            }
            case 170: {
                this.visitTemplateLiteral(node);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected node type " + n);
            }
        }
    }

    private Node findNestedYield(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (node2.getType() == 73 || node2.getType() == 169) {
                return node2;
            }
            Node node3 = this.findNestedYield(node2);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    private void generateYieldPoint(Node node, boolean bl) {
        if (this.unnestedYields.containsKey(node)) {
            if (bl) {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addLoadConstant(this.unnestedYields.get(node));
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectPropNoWarn", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
            return;
        }
        Node node2 = this.findNestedYield(node);
        if (node2 != null) {
            this.generateYieldPoint(node2, true);
            String string = "__nested__yield__" + this.unnestedYieldCount;
            ++this.unnestedYieldCount;
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.add(95);
            this.cfw.addLoadConstant(string);
            this.cfw.add(95);
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("setObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            this.cfw.add(87);
            this.unnestedYields.put(node2, string);
        }
        this.generateLocalYieldPoint(node, bl);
    }

    private void generateLocalYieldPoint(Node node, boolean bl) {
        Node node2;
        int n = this.cfw.getStackTop();
        int n2 = this.maxStack = this.maxStack > n ? this.maxStack : n;
        if (n != 0) {
            this.generateGetGeneratorStackState();
            for (int i = 0; i < n; ++i) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addLoadConstant(i);
                this.cfw.add(95);
                this.cfw.add(83);
            }
            this.cfw.add(87);
        }
        if ((node2 = node.getFirstChild()) != null) {
            this.generateExpression(node2, node);
        } else {
            Codegen.pushUndefined(this.cfw);
        }
        if (node.getType() == 169) {
            this.cfw.add(187, "org/mozilla/javascript/ES6Generator$YieldStarResult");
            this.cfw.add(90);
            this.cfw.add(95);
            this.cfw.addInvoke(183, "org/mozilla/javascript/ES6Generator$YieldStarResult", "<init>", "(Ljava/lang/Object;)V");
        }
        int n3 = this.getNextGeneratorState(node);
        this.generateSetGeneratorResumptionPoint(n3);
        boolean bl2 = this.generateSaveLocals(node);
        this.cfw.add(176);
        this.generateCheckForThrowOrClose(this.getTargetLabel(node), bl2, n3);
        if (n != 0) {
            this.generateGetGeneratorStackState();
            for (int i = n - 1; i >= 0; --i) {
                this.cfw.add(89);
                this.cfw.addLoadConstant(i);
                this.cfw.add(50);
                this.cfw.add(95);
            }
            this.cfw.add(87);
        }
        if (bl) {
            this.cfw.addALoad(this.argsLocal);
        }
    }

    private void generateCheckForThrowOrClose(int n, boolean bl, int n2) {
        int n3 = this.cfw.acquireLabel();
        int n4 = this.cfw.acquireLabel();
        this.cfw.markLabel(n3);
        this.cfw.addALoad(this.argsLocal);
        this.generateThrowJavaScriptException();
        this.cfw.markLabel(n4);
        this.cfw.addALoad(this.argsLocal);
        this.cfw.add(192, "java/lang/Throwable");
        this.cfw.add(191);
        if (n != -1) {
            this.cfw.markLabel(n);
        }
        if (!bl) {
            this.cfw.markTableSwitchCase(this.generatorSwitch, n2);
        }
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(2);
        this.cfw.add(159, n4);
        this.cfw.addILoad(this.operationLocal);
        this.cfw.addLoadConstant(1);
        this.cfw.add(159, n3);
    }

    private void visitTemplateLiteral(Node node) {
        int n = node.getExistingIntProp(28);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.add(178, this.codegen.mainClassName, this.codegen.getTemplateLiteralName(this.scriptOrFn), "[Ljava/lang/Object;");
        this.cfw.addPush(n);
        this.cfw.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "getTemplateLiteralCallSite", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;I)Lorg/mozilla/javascript/Scriptable;");
    }

    private void generateIfJump(Node node, Node node2, int n, int n2) {
        int n3 = node.getType();
        Node node3 = node.getFirstChild();
        switch (n3) {
            case 26: {
                this.generateIfJump(node3, node, n2, n);
                break;
            }
            case 108: 
            case 109: {
                int n4 = this.cfw.acquireLabel();
                if (n3 == 109) {
                    this.generateIfJump(node3, node, n4, n2);
                } else {
                    this.generateIfJump(node3, node, n, n4);
                }
                this.cfw.markLabel(n4);
                node3 = node3.getNext();
                this.generateIfJump(node3, node, n, n2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 52: 
            case 53: {
                this.visitIfJumpRelOp(node, node3, n, n2);
                break;
            }
            case 12: 
            case 13: 
            case 46: 
            case 47: {
                this.visitIfJumpEqOp(node, node3, n, n2);
                break;
            }
            default: {
                this.generateExpression(node, node2);
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
                this.cfw.add(154, n);
                this.cfw.add(167, n2);
            }
        }
    }

    private void visitFunction(OptFunctionNode optFunctionNode, int n) {
        int n2 = this.codegen.getIndex(optFunctionNode.fnode);
        this.cfw.add(187, this.codegen.mainClassName);
        this.cfw.add(89);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(n2);
        this.cfw.addInvoke(183, this.codegen.mainClassName, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V");
        if (n == 4) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.addOptRuntimeInvoke("bindThis", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Function;");
        }
        if (n == 2 || n == 4) {
            return;
        }
        this.cfw.addPush(n);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addALoad(this.contextLocal);
        this.addOptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;ILorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V");
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n == -1) {
            n = this.cfw.acquireLabel();
            node.labelId(n);
        }
        return n;
    }

    private void visitGoto(Jump jump, int n, Node node) {
        Node node2 = jump.target;
        if (n == 6 || n == 7) {
            if (node == null) {
                throw Codegen.badTree();
            }
            int n2 = this.getTargetLabel(node2);
            int n3 = this.cfw.acquireLabel();
            if (n == 6) {
                this.generateIfJump(node, jump, n2, n3);
            } else {
                this.generateIfJump(node, jump, n3, n2);
            }
            this.cfw.markLabel(n3);
        } else if (n == 139) {
            if (this.isGenerator) {
                this.addGotoWithReturn(node2);
            } else {
                this.inlineFinally(node2);
            }
        } else {
            this.addGoto(node2, 167);
        }
    }

    private void addGotoWithReturn(Node node) {
        FinallyReturnPoint finallyReturnPoint = this.finallys.get(node);
        this.cfw.addLoadConstant(finallyReturnPoint.jsrPoints.size());
        this.addGoto(node, 167);
        this.cfw.add(87);
        int n = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        finallyReturnPoint.jsrPoints.add(n);
    }

    private void generateArrayLiteralFactory(Node node, int n) {
        String string = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + n;
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        this.cfw.startMethod(string, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)2);
        this.visitArrayLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void generateObjectLiteralFactory(Node node, int n) {
        String string = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + n;
        this.initBodyGeneration();
        short s = this.firstFreeLocal;
        this.firstFreeLocal = (short)(s + 1);
        this.argsLocal = s;
        this.localsMax = this.firstFreeLocal;
        this.cfw.startMethod(string, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;", (short)2);
        this.visitObjectLiteral(node, node.getFirstChild(), true);
        this.cfw.add(176);
        this.cfw.stopMethod((short)(this.localsMax + 1));
    }

    private void visitArrayLiteral(Node node, Node node2, boolean bl) {
        int[] nArray;
        int n;
        Object object;
        int n2 = 0;
        for (object = node2; object != null; object = ((Node)object).getNext()) {
            ++n2;
        }
        if (!(bl || n2 <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new LinkedList<Node>();
            }
            this.literals.add(node);
            object = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + this.literals.size();
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(182, this.codegen.mainClassName, (String)object, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        if (this.isGenerator) {
            for (n = 0; n != n2; ++n) {
                this.generateExpression(node2, node);
                node2 = node2.getNext();
            }
            this.addNewObjectArray(n2);
            for (n = 0; n != n2; ++n) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(n2 - n - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            this.addNewObjectArray(n2);
            for (n = 0; n != n2; ++n) {
                this.cfw.add(89);
                this.cfw.addPush(n);
                this.generateExpression(node2, node);
                this.cfw.add(83);
                node2 = node2.getNext();
            }
        }
        if ((nArray = (int[])node.getProp(11)) == null) {
            this.cfw.add(1);
            this.cfw.add(3);
        } else {
            this.cfw.addPush(OptRuntime.encodeIntArray(nArray));
            this.cfw.addPush(nArray.length);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke("newArrayLiteral", "([Ljava/lang/Object;Ljava/lang/String;ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void addLoadPropertyIds(Object[] objectArray, int n) {
        this.addNewObjectArray(n);
        for (int i = 0; i != n; ++i) {
            this.cfw.add(89);
            this.cfw.addPush(i);
            Object object = objectArray[i];
            if (object instanceof String) {
                this.cfw.addPush((String)object);
            } else {
                this.cfw.addPush((Integer)object);
                this.addScriptRuntimeInvoke("wrapInt", "(I)Ljava/lang/Integer;");
            }
            this.cfw.add(83);
        }
    }

    private void addLoadPropertyValues(Node node, Node node2, int n) {
        if (this.isGenerator) {
            int n2;
            for (n2 = 0; n2 != n; ++n2) {
                int n3 = node2.getType();
                if (n3 == 155 || n3 == 156 || n3 == 167) {
                    this.generateExpression(node2.getFirstChild(), node);
                } else {
                    this.generateExpression(node2, node);
                }
                node2 = node2.getNext();
            }
            this.addNewObjectArray(n);
            for (n2 = 0; n2 != n; ++n2) {
                this.cfw.add(90);
                this.cfw.add(95);
                this.cfw.addPush(n - n2 - 1);
                this.cfw.add(95);
                this.cfw.add(83);
            }
        } else {
            this.addNewObjectArray(n);
            Node node3 = node2;
            for (int i = 0; i != n; ++i) {
                this.cfw.add(89);
                this.cfw.addPush(i);
                int n4 = node3.getType();
                if (n4 == 155 || n4 == 156 || n4 == 167) {
                    this.generateExpression(node3.getFirstChild(), node);
                } else {
                    this.generateExpression(node3, node);
                }
                this.cfw.add(83);
                node3 = node3.getNext();
            }
        }
    }

    private void visitObjectLiteral(Node node, Node node2, boolean bl) {
        int n;
        int n2;
        int n3;
        Object[] objectArray = (Object[])node.getProp(12);
        int n4 = n3 = objectArray == null ? 0 : objectArray.length;
        if (!(bl || n3 <= 10 && this.cfw.getCurrentCodeOffset() <= 30000 || this.hasVarsInRegs || this.isGenerator || this.inLocalBlock)) {
            if (this.literals == null) {
                this.literals = new LinkedList<Node>();
            }
            this.literals.add(node);
            String string = this.codegen.getBodyMethodName(this.scriptOrFn) + "_literal" + this.literals.size();
            this.cfw.addALoad(this.funObjLocal);
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addALoad(this.argsLocal);
            this.cfw.addInvoke(182, this.codegen.mainClassName, string, "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        if (this.isGenerator) {
            this.addLoadPropertyValues(node, node2, n3);
            this.addLoadPropertyIds(objectArray, n3);
            this.cfw.add(95);
        } else {
            this.addLoadPropertyIds(objectArray, n3);
            this.addLoadPropertyValues(node, node2, n3);
        }
        boolean bl2 = false;
        Node node3 = node2;
        for (n2 = 0; n2 != n3; ++n2) {
            n = node3.getType();
            if (n == 155 || n == 156) {
                bl2 = true;
                break;
            }
            node3 = node3.getNext();
        }
        if (bl2) {
            this.cfw.addPush(n3);
            this.cfw.add(188, 10);
            node3 = node2;
            for (n2 = 0; n2 != n3; ++n2) {
                this.cfw.add(89);
                this.cfw.addPush(n2);
                n = node3.getType();
                if (n == 155) {
                    this.cfw.add(2);
                } else if (n == 156) {
                    this.cfw.add(4);
                } else {
                    this.cfw.add(3);
                }
                this.cfw.add(79);
                node3 = node3.getNext();
            }
        } else {
            this.cfw.add(1);
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("newObjectLiteral", "([Ljava/lang/Object;[Ljava/lang/Object;[ILorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitSpecialCall(Node node, int n, int n2, Node node2) {
        String string;
        String string2;
        this.cfw.addALoad(this.contextLocal);
        if (n == 30) {
            this.generateExpression(node2, node);
        } else {
            this.generateFunctionAndThisObj(node2, node);
        }
        node2 = node2.getNext();
        this.generateCallArgArray(node, node2, false);
        if (n == 30) {
            string2 = "newObjectSpecial";
            string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;";
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(n2);
        } else {
            string2 = "callSpecial";
            string = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;ILjava/lang/String;I)Ljava/lang/Object;";
            this.cfw.addALoad(this.variableObjectLocal);
            this.cfw.addALoad(this.thisObjLocal);
            this.cfw.addPush(n2);
            String string3 = this.scriptOrFn.getSourceName();
            this.cfw.addPush(string3 == null ? "" : string3);
            this.cfw.addPush(this.itsLineNumber);
        }
        this.addOptRuntimeInvoke(string2, string);
    }

    private void visitStandardCall(Node node, Node node2) {
        String string;
        String string2;
        if (node.getType() != 38) {
            throw Codegen.badTree();
        }
        Node node3 = node2.getNext();
        int n = node2.getType();
        if (node3 == null) {
            if (n == 39) {
                String string3 = node2.getString();
                this.cfw.addPush(string3);
                string2 = "callName0";
                string = "(Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (n == 33) {
                Node node4 = node2.getFirstChild();
                this.generateExpression(node4, node);
                Node node5 = node4.getNext();
                String string4 = node5.getString();
                this.cfw.addPush(string4);
                string2 = "callProp0";
                string = "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                if (n == 34) {
                    throw Kit.codeBug();
                }
                this.generateFunctionAndThisObj(node2, node);
                string2 = "call0";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        } else if (n == 39) {
            String string5 = node2.getString();
            this.generateCallArgArray(node, node3, false);
            this.cfw.addPush(string5);
            string2 = "callName";
            string = "([Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        } else {
            int n2 = 0;
            for (Node node6 = node3; node6 != null; node6 = node6.getNext()) {
                ++n2;
            }
            this.generateFunctionAndThisObj(node2, node);
            if (n2 == 1) {
                this.generateExpression(node3, node);
                string2 = "call1";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else if (n2 == 2) {
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                string2 = "call2";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            } else {
                this.generateCallArgArray(node, node3, false);
                string2 = "callN";
                string = "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addOptRuntimeInvoke(string2, string);
    }

    private void visitStandardNew(Node node, Node node2) {
        if (node.getType() != 30) {
            throw Codegen.badTree();
        }
        Node node3 = node2.getNext();
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.generateCallArgArray(node, node3, false);
        this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void visitOptimizedCall(Node node, OptFunctionNode optFunctionNode, int n, Node node2) {
        Node node3 = node2.getNext();
        String string = this.codegen.mainClassName;
        short s = 0;
        if (n == 30) {
            this.generateExpression(node2, node);
        } else {
            this.generateFunctionAndThisObj(node2, node);
            s = this.getNewWordLocal();
            this.cfw.addAStore(s);
        }
        int n2 = this.cfw.acquireLabel();
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(89);
        this.cfw.add(193, string);
        this.cfw.add(153, n3);
        this.cfw.add(192, string);
        this.cfw.add(89);
        this.cfw.add(180, string, "_id", "I");
        this.cfw.addPush(this.codegen.getIndex(optFunctionNode.fnode));
        this.cfw.add(160, n3);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (n == 30) {
            this.cfw.add(1);
        } else {
            this.cfw.addALoad(s);
        }
        for (Node node4 = node3; node4 != null; node4 = node4.getNext()) {
            int n4 = this.nodeIsDirectCallParameter(node4);
            if (n4 >= 0) {
                this.cfw.addALoad(n4);
                this.cfw.addDLoad(n4 + 1);
                continue;
            }
            if (node4.getIntProp(8, -1) == 0) {
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.generateExpression(node4, node);
                continue;
            }
            this.generateExpression(node4, node);
            this.cfw.addPush(0.0);
        }
        this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
        this.cfw.addInvoke(184, this.codegen.mainClassName, n == 30 ? this.codegen.getDirectCtorName(optFunctionNode.fnode) : this.codegen.getBodyMethodName(optFunctionNode.fnode), this.codegen.getBodyMethodSignature(optFunctionNode.fnode));
        this.cfw.add(167, n2);
        this.cfw.markLabel(n3);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (n != 30) {
            this.cfw.addALoad(s);
            this.releaseWordLocal(s);
        }
        this.generateCallArgArray(node, node3, true);
        if (n == 30) {
            this.addScriptRuntimeInvoke("newObject", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.cfw.addInvoke(185, "org/mozilla/javascript/Callable", "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        }
        this.cfw.markLabel(n2);
    }

    private void generateCallArgArray(Node node, Node node2, boolean bl) {
        int n = 0;
        for (Node node3 = node2; node3 != null; node3 = node3.getNext()) {
            ++n;
        }
        if (n == 1 && this.itsOneArgArray >= 0) {
            this.cfw.addALoad(this.itsOneArgArray);
        } else {
            this.addNewObjectArray(n);
        }
        for (int i = 0; i != n; ++i) {
            int n2;
            if (!this.isGenerator) {
                this.cfw.add(89);
                this.cfw.addPush(i);
            }
            if (!bl) {
                this.generateExpression(node2, node);
            } else {
                n2 = this.nodeIsDirectCallParameter(node2);
                if (n2 >= 0) {
                    this.dcpLoadAsObject(n2);
                } else {
                    this.generateExpression(node2, node);
                    int n3 = node2.getIntProp(8, -1);
                    if (n3 == 0) {
                        this.addDoubleWrap();
                    }
                }
            }
            if (this.isGenerator) {
                n2 = this.getNewWordLocal();
                this.cfw.addAStore(n2);
                this.cfw.add(192, "[Ljava/lang/Object;");
                this.cfw.add(89);
                this.cfw.addPush(i);
                this.cfw.addALoad(n2);
                this.releaseWordLocal((short)n2);
            }
            this.cfw.add(83);
            node2 = node2.getNext();
        }
    }

    private void generateFunctionAndThisObj(Node node, Node node2) {
        int n = node.getType();
        switch (node.getType()) {
            case 34: {
                throw Kit.codeBug();
            }
            case 33: 
            case 36: {
                Node node3 = node.getFirstChild();
                this.generateExpression(node3, node);
                Node node4 = node3.getNext();
                if (n == 33) {
                    String string = node4.getString();
                    this.cfw.addPush(string);
                    this.cfw.addALoad(this.contextLocal);
                    this.cfw.addALoad(this.variableObjectLocal);
                    this.addScriptRuntimeInvoke("getPropFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
                    break;
                }
                this.generateExpression(node4, node);
                if (node.getIntProp(8, -1) != -1) {
                    this.addDoubleWrap();
                }
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getElemFunctionAndThis", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
                break;
            }
            case 39: {
                String string = node.getString();
                this.cfw.addPush(string);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getNameFunctionAndThis", "(Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Callable;");
                break;
            }
            default: {
                this.generateExpression(node, node2);
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getValueFunctionAndThis", "(Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Callable;");
            }
        }
        this.cfw.addALoad(this.contextLocal);
        this.addScriptRuntimeInvoke("lastStoredScriptable", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/Scriptable;");
    }

    private void updateLineNumber(Node node) {
        this.itsLineNumber = node.getLineno();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.cfw.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Jump jump, Node node) {
        int n;
        Object object;
        short s = this.getNewWordLocal();
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addAStore(s);
        int n2 = this.cfw.acquireLabel();
        this.cfw.markLabel(n2, (short)0);
        Node node2 = jump.target;
        Node node3 = jump.getFinally();
        int[] nArray = new int[5];
        this.exceptionManager.pushExceptionInfo(jump);
        if (node2 != null) {
            nArray[0] = this.cfw.acquireLabel();
            nArray[1] = this.cfw.acquireLabel();
            nArray[2] = this.cfw.acquireLabel();
            object = Context.getCurrentContext();
            if (object != null && ((Context)object).hasFeature(13)) {
                nArray[3] = this.cfw.acquireLabel();
            }
        }
        if (node3 != null) {
            nArray[4] = this.cfw.acquireLabel();
        }
        this.exceptionManager.setHandlers(nArray, n2);
        if (this.isGenerator && node3 != null) {
            object = new FinallyReturnPoint();
            if (this.finallys == null) {
                this.finallys = new HashMap<Node, FinallyReturnPoint>();
            }
            this.finallys.put(node3, (FinallyReturnPoint)object);
            this.finallys.put(node3.getNext(), (FinallyReturnPoint)object);
        }
        while (node != null) {
            if (node == node2) {
                int n3 = this.getTargetLabel(node2);
                this.exceptionManager.removeHandler(0, n3);
                this.exceptionManager.removeHandler(1, n3);
                this.exceptionManager.removeHandler(2, n3);
                this.exceptionManager.removeHandler(3, n3);
            }
            this.generateStatement(node);
            node = node.getNext();
        }
        int n4 = this.cfw.acquireLabel();
        this.cfw.add(167, n4);
        int n5 = BodyCodegen.getLocalBlockRegister(jump);
        if (node2 != null) {
            n = node2.labelId();
            this.generateCatchBlock(0, s, n, n5, nArray[0]);
            this.generateCatchBlock(1, s, n, n5, nArray[1]);
            this.generateCatchBlock(2, s, n, n5, nArray[2]);
            Context context = Context.getCurrentContext();
            if (context != null && context.hasFeature(13)) {
                this.generateCatchBlock(3, s, n, n5, nArray[3]);
            }
        }
        if (node3 != null) {
            n = this.cfw.acquireLabel();
            int n6 = this.cfw.acquireLabel();
            this.cfw.markHandler(n);
            if (!this.isGenerator) {
                this.cfw.markLabel(nArray[4]);
            }
            this.cfw.addAStore(n5);
            this.cfw.addALoad(s);
            this.cfw.addAStore(this.variableObjectLocal);
            int n7 = node3.labelId();
            if (this.isGenerator) {
                this.addGotoWithReturn(node3);
            } else {
                this.inlineFinally(node3, nArray[4], n6);
            }
            this.cfw.addALoad(n5);
            if (this.isGenerator) {
                this.cfw.add(192, "java/lang/Throwable");
            }
            this.cfw.add(191);
            this.cfw.markLabel(n6);
            if (this.isGenerator) {
                this.cfw.addExceptionHandler(n2, n7, n, null);
            }
        }
        this.releaseWordLocal(s);
        this.cfw.markLabel(n4);
        if (!this.isGenerator) {
            this.exceptionManager.popExceptionInfo();
        }
    }

    private void generateCatchBlock(int n, short s, int n2, int n3, int n4) {
        if (n4 == 0) {
            n4 = this.cfw.acquireLabel();
        }
        this.cfw.markHandler(n4);
        this.cfw.addAStore(n3);
        this.cfw.addALoad(s);
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(167, n2);
    }

    private static String exceptionTypeToName(int n) {
        if (n == 0) {
            return "org/mozilla/javascript/JavaScriptException";
        }
        if (n == 1) {
            return "org/mozilla/javascript/EvaluatorException";
        }
        if (n == 2) {
            return "org/mozilla/javascript/EcmaError";
        }
        if (n == 3) {
            return "java/lang/Throwable";
        }
        if (n == 4) {
            return null;
        }
        throw Kit.codeBug();
    }

    private void inlineFinally(Node node, int n, int n2) {
        Node node2 = BodyCodegen.getFinallyAtTarget(node);
        node2.resetTargets();
        this.exceptionManager.markInlineFinallyStart(node2, n);
        for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            this.generateStatement(node3);
        }
        this.exceptionManager.markInlineFinallyEnd(node2, n2);
    }

    private void inlineFinally(Node node) {
        int n = this.cfw.acquireLabel();
        int n2 = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        this.inlineFinally(node, n, n2);
        this.cfw.markLabel(n2);
    }

    private static Node getFinallyAtTarget(Node node) {
        Node node2;
        if (node == null) {
            return null;
        }
        if (node.getType() == 129) {
            return node;
        }
        if (node.getType() == 135 && (node2 = node.getNext()) != null && node2.getType() == 129) {
            return node2;
        }
        throw Kit.codeBug("bad finally target");
    }

    private boolean generateSaveLocals(Node node) {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.firstFreeLocal; ++i) {
            if (this.locals[i] == 0) continue;
            ++n2;
        }
        if (n2 == 0) {
            ((FunctionNode)this.scriptOrFn).addLiveLocals(node, null);
            return false;
        }
        this.maxLocals = this.maxLocals > n2 ? this.maxLocals : n2;
        int[] nArray = new int[n2];
        int n3 = 0;
        for (n = 0; n < this.firstFreeLocal; ++n) {
            if (this.locals[n] == 0) continue;
            nArray[n3] = n;
            ++n3;
        }
        ((FunctionNode)this.scriptOrFn).addLiveLocals(node, nArray);
        this.generateGetGeneratorLocalsState();
        for (n = 0; n < n2; ++n) {
            this.cfw.add(89);
            this.cfw.addLoadConstant(n);
            this.cfw.addALoad(nArray[n]);
            this.cfw.add(83);
        }
        this.cfw.add(87);
        return true;
    }

    private void visitSwitch(Jump jump, Node node) {
        this.generateExpression(node, jump);
        short s = this.getNewWordLocal();
        this.cfw.addAStore(s);
        for (Jump jump2 = (Jump)node.getNext(); jump2 != null; jump2 = (Jump)jump2.getNext()) {
            if (jump2.getType() != 119) {
                throw Codegen.badTree();
            }
            Node node2 = jump2.getFirstChild();
            this.generateExpression(node2, jump2);
            this.cfw.addALoad(s);
            this.addScriptRuntimeInvoke("shallowEq", "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.addGoto(jump2.target, 154);
        }
        this.releaseWordLocal(s);
    }

    private void visitTypeofname(Node node) {
        int n;
        if (this.hasVarsInRegs && (n = this.fnCurrent.fnode.getIndexForNameNode(node)) >= 0) {
            if (this.fnCurrent.isNumberVar(n)) {
                this.cfw.addPush("number");
            } else if (this.varIsDirectCallParameter(n)) {
                short s = this.varRegisters[n];
                this.cfw.addALoad(s);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n2 = this.cfw.acquireLabel();
                this.cfw.add(165, n2);
                short s2 = this.cfw.getStackTop();
                this.cfw.addALoad(s);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
                int n3 = this.cfw.acquireLabel();
                this.cfw.add(167, n3);
                this.cfw.markLabel(n2, s2);
                this.cfw.addPush("number");
                this.cfw.markLabel(n3);
            } else {
                this.cfw.addALoad(this.varRegisters[n]);
                this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)Ljava/lang/String;");
            }
            return;
        }
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(node.getString());
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/String;");
    }

    private void saveCurrentCodeOffset() {
        this.savedCodeOffset = this.cfw.getCurrentCodeOffset();
    }

    private void addInstructionCount() {
        int n = this.cfw.getCurrentCodeOffset() - this.savedCodeOffset;
        this.addInstructionCount(Math.max(n, 1));
    }

    private void addInstructionCount(int n) {
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(n);
        this.addScriptRuntimeInvoke("addInstructionCount", "(Lorg/mozilla/javascript/Context;I)V");
    }

    private void visitIncDec(Node node) {
        int n = node.getExistingIntProp(13);
        Node node2 = node.getFirstChild();
        switch (node2.getType()) {
            case 55: {
                if (!this.hasVarsInRegs) {
                    Kit.codeBug();
                }
                boolean bl = (n & 2) != 0;
                int n2 = this.fnCurrent.getVarIndex(node2);
                short s = this.varRegisters[n2];
                boolean[] blArray = this.fnCurrent.fnode.getParamAndVarConst();
                if (blArray[n2]) {
                    if (node.getIntProp(8, -1) != -1) {
                        short s2 = this.varIsDirectCallParameter(n2) ? (short)1 : 0;
                        this.cfw.addDLoad(s + s2);
                        if (bl) break;
                        this.cfw.addPush(1.0);
                        if ((n & 1) == 0) {
                            this.cfw.add(99);
                            break;
                        }
                        this.cfw.add(103);
                        break;
                    }
                    if (this.varIsDirectCallParameter(n2)) {
                        this.dcpLoadAsObject(s);
                    } else {
                        this.cfw.addALoad(s);
                    }
                    if (bl) {
                        this.cfw.add(89);
                        this.addObjectToDouble();
                        this.cfw.add(88);
                        break;
                    }
                    this.addObjectToDouble();
                    this.cfw.addPush(1.0);
                    if ((n & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    this.addDoubleWrap();
                    break;
                }
                if (node.getIntProp(8, -1) != -1) {
                    short s3 = this.varIsDirectCallParameter(n2) ? (short)1 : 0;
                    this.cfw.addDLoad(s + s3);
                    if (bl) {
                        this.cfw.add(92);
                    }
                    this.cfw.addPush(1.0);
                    if ((n & 1) == 0) {
                        this.cfw.add(99);
                    } else {
                        this.cfw.add(103);
                    }
                    if (!bl) {
                        this.cfw.add(92);
                    }
                    this.cfw.addDStore(s + s3);
                    break;
                }
                if (this.varIsDirectCallParameter(n2)) {
                    this.dcpLoadAsObject(s);
                } else {
                    this.cfw.addALoad(s);
                }
                this.addObjectToDouble();
                if (bl) {
                    this.cfw.add(92);
                }
                this.cfw.addPush(1.0);
                if ((n & 1) == 0) {
                    this.cfw.add(99);
                } else {
                    this.cfw.add(103);
                }
                this.addDoubleWrap();
                if (!bl) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(s);
                if (!bl) break;
                this.addDoubleWrap();
                break;
            }
            case 39: {
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(node2.getString());
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addPush(n);
                this.addScriptRuntimeInvoke("nameIncrDecr", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;I)Ljava/lang/Object;");
                break;
            }
            case 34: {
                throw Kit.codeBug();
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.generateExpression(node3, node);
                this.generateExpression(node3.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(n);
                this.addScriptRuntimeInvoke("propIncrDecr", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                break;
            }
            case 36: {
                Node node4 = node2.getFirstChild();
                this.generateExpression(node4, node);
                this.generateExpression(node4.getNext(), node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(n);
                if (node4.getNext().getIntProp(8, -1) != -1) {
                    this.addOptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                    break;
                }
                this.addScriptRuntimeInvoke("elemIncrDecr", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                break;
            }
            case 68: {
                Node node5 = node2.getFirstChild();
                this.generateExpression(node5, node);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.cfw.addPush(n);
                this.addScriptRuntimeInvoke("refIncrDecr", "(Lorg/mozilla/javascript/Ref;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;I)Ljava/lang/Object;");
                break;
            }
            default: {
                Codegen.badTree();
            }
        }
    }

    private static boolean isArithmeticNode(Node node) {
        int n = node.getType();
        return n == 22 || n == 25 || n == 24 || n == 23;
    }

    private void visitArithmetic(Node node, int n, Node node2, Node node3) {
        block15: {
            block14: {
                int n2 = node.getIntProp(8, -1);
                if (n2 == -1) break block14;
                this.generateExpression(node2, node);
                this.generateExpression(node2.getNext(), node);
                switch (n) {
                    case 22: {
                        this.cfw.add(103);
                        break block15;
                    }
                    case 23: {
                        this.cfw.add(107);
                        break block15;
                    }
                    case 24: {
                        this.cfw.add(111);
                        break block15;
                    }
                    case 25: {
                        this.cfw.add(115);
                        break block15;
                    }
                    default: {
                        throw Kit.codeBug(Token.typeToName(n));
                    }
                }
            }
            this.generateExpression(node2, node);
            if (!BodyCodegen.isArithmeticNode(node2)) {
                this.addObjectToNumeric();
            }
            this.generateExpression(node2.getNext(), node);
            if (!BodyCodegen.isArithmeticNode(node2.getNext())) {
                this.addObjectToNumeric();
            }
            switch (n) {
                case 22: {
                    this.addScriptRuntimeInvoke("subtract", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                case 23: {
                    this.addScriptRuntimeInvoke("multiply", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                case 24: {
                    this.addScriptRuntimeInvoke("divide", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                case 25: {
                    this.addScriptRuntimeInvoke("remainder", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                    break;
                }
                default: {
                    throw Kit.codeBug(Token.typeToName(n));
                }
            }
        }
    }

    private void visitExponentiation(Node node, Node node2, Node node3) {
        int n = node.getIntProp(8, -1);
        if (n != -1) {
            this.generateExpression(node2, node);
            this.generateExpression(node2.getNext(), node);
            this.cfw.addInvoke(184, "java/lang/Math", "pow", "(DD)D");
        } else {
            this.generateExpression(node2, node);
            this.generateExpression(node2.getNext(), node);
            short s = this.getNewWordLocal();
            this.cfw.addAStore(s);
            this.addObjectToNumeric();
            this.cfw.addALoad(s);
            this.addObjectToNumeric();
            this.addScriptRuntimeInvoke("exponentiate", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
        }
    }

    private void visitBitNot(Node node, Node node2) {
        int n = node.getIntProp(8, -1);
        this.generateExpression(node2, node);
        if (n == -1) {
            this.addObjectToNumeric();
            this.addScriptRuntimeInvoke("bitwiseNOT", "(Ljava/lang/Number;)Ljava/lang/Number;");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.cfw.addPush(-1);
            this.cfw.add(130);
            this.cfw.add(135);
        }
    }

    private void visitBitOp(Node node, int n, Node node2) {
        block16: {
            block15: {
                int n2 = node.getIntProp(8, -1);
                this.generateExpression(node2, node);
                if (n == 20) {
                    this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)J");
                    this.generateExpression(node2.getNext(), node);
                    this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)I");
                    this.cfw.addPush(31);
                    this.cfw.add(126);
                    this.cfw.add(125);
                    this.cfw.add(138);
                    this.addDoubleWrap();
                    return;
                }
                if (n2 != -1) break block15;
                this.addObjectToNumeric();
                this.generateExpression(node2.getNext(), node);
                this.addObjectToNumeric();
                switch (n) {
                    case 9: {
                        this.addScriptRuntimeInvoke("bitwiseOR", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 10: {
                        this.addScriptRuntimeInvoke("bitwiseXOR", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 11: {
                        this.addScriptRuntimeInvoke("bitwiseAND", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 19: {
                        this.addScriptRuntimeInvoke("signedRightShift", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    case 18: {
                        this.addScriptRuntimeInvoke("leftShift", "(Ljava/lang/Number;Ljava/lang/Number;)Ljava/lang/Number;");
                        break block16;
                    }
                    default: {
                        throw Kit.codeBug(Token.typeToName(n));
                    }
                }
            }
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            this.generateExpression(node2.getNext(), node);
            this.addScriptRuntimeInvoke("toInt32", "(D)I");
            switch (n) {
                case 9: {
                    this.cfw.add(128);
                    break;
                }
                case 10: {
                    this.cfw.add(130);
                    break;
                }
                case 11: {
                    this.cfw.add(126);
                    break;
                }
                case 19: {
                    this.cfw.add(122);
                    break;
                }
                case 18: {
                    this.cfw.add(120);
                    break;
                }
                default: {
                    throw Kit.codeBug(Token.typeToName(n));
                }
            }
            this.cfw.add(135);
        }
    }

    private int nodeIsDirectCallParameter(Node node) {
        int n;
        if (node.getType() == 55 && this.inDirectCallFunction && !this.itsForcedObjectParameters && this.fnCurrent.isParameter(n = this.fnCurrent.getVarIndex(node))) {
            return this.varRegisters[n];
        }
        return -1;
    }

    private boolean varIsDirectCallParameter(int n) {
        return this.fnCurrent.isParameter(n) && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        if (n2 == -1) {
            throw Codegen.badTree();
        }
        switch (n) {
            case 15: {
                this.cfw.add(152);
                this.cfw.add(158, n2);
                break;
            }
            case 17: {
                this.cfw.add(151);
                this.cfw.add(156, n2);
                break;
            }
            case 14: {
                this.cfw.add(152);
                this.cfw.add(155, n2);
                break;
            }
            case 16: {
                this.cfw.add(151);
                this.cfw.add(157, n2);
                break;
            }
            default: {
                throw Codegen.badTree();
            }
        }
        if (n3 != -1) {
            this.cfw.add(167, n3);
        }
    }

    private void visitIfJumpRelOp(Node node, Node node2, int n, int n2) {
        if (n == -1 || n2 == -1) {
            throw Codegen.badTree();
        }
        int n3 = node.getType();
        Node node3 = node2.getNext();
        if (n3 == 53 || n3 == 52) {
            this.generateExpression(node2, node);
            this.generateExpression(node3, node);
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke(n3 == 53 ? "instanceOf" : "in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;)Z");
            this.cfw.add(154, n);
            this.cfw.add(167, n2);
            return;
        }
        int n4 = node.getIntProp(8, -1);
        int n5 = this.nodeIsDirectCallParameter(node2);
        int n6 = this.nodeIsDirectCallParameter(node3);
        if (n4 != -1) {
            if (n4 != 2) {
                this.generateExpression(node2, node);
            } else if (n5 != -1) {
                this.dcpLoadAsNumber(n5);
            } else {
                this.generateExpression(node2, node);
                this.addObjectToDouble();
            }
            if (n4 != 1) {
                this.generateExpression(node3, node);
            } else if (n6 != -1) {
                this.dcpLoadAsNumber(n6);
            } else {
                this.generateExpression(node3, node);
                this.addObjectToDouble();
            }
            this.genSimpleCompare(n3, n, n2);
        } else {
            if (n5 != -1 && n6 != -1) {
                short s = this.cfw.getStackTop();
                int n7 = this.cfw.acquireLabel();
                this.cfw.addALoad(n5);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, n7);
                this.cfw.addDLoad(n5 + 1);
                this.dcpLoadAsNumber(n6);
                this.genSimpleCompare(n3, n, n2);
                if (s != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(n7);
                int n8 = this.cfw.acquireLabel();
                this.cfw.addALoad(n6);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                this.cfw.add(166, n8);
                this.cfw.addALoad(n5);
                this.addObjectToDouble();
                this.cfw.addDLoad(n6 + 1);
                this.genSimpleCompare(n3, n, n2);
                if (s != this.cfw.getStackTop()) {
                    throw Codegen.badTree();
                }
                this.cfw.markLabel(n8);
                this.cfw.addALoad(n5);
                this.cfw.addALoad(n6);
            } else {
                this.generateExpression(node2, node);
                this.generateExpression(node3, node);
            }
            this.cfw.addPush(n3);
            this.addScriptRuntimeInvoke("compare", "(Ljava/lang/Object;Ljava/lang/Object;I)Z");
            this.cfw.add(154, n);
            this.cfw.add(167, n2);
        }
    }

    private void visitIfJumpEqOp(Node node, Node node2, int n, int n2) {
        if (n == -1 || n2 == -1) {
            throw Codegen.badTree();
        }
        short s = this.cfw.getStackTop();
        int n3 = node.getType();
        Node node3 = node2.getNext();
        if (node2.getType() == 42 || node3.getType() == 42) {
            if (node2.getType() == 42) {
                node2 = node3;
            }
            this.generateExpression(node2, node);
            if (n3 == 46 || n3 == 47) {
                int n4 = n3 == 46 ? 198 : 199;
                this.cfw.add(n4, n);
            } else {
                int n5;
                if (n3 != 12) {
                    if (n3 != 13) {
                        throw Codegen.badTree();
                    }
                    n5 = n;
                    n = n2;
                    n2 = n5;
                }
                this.cfw.add(89);
                n5 = this.cfw.acquireLabel();
                this.cfw.add(199, n5);
                short s2 = this.cfw.getStackTop();
                this.cfw.add(87);
                this.cfw.add(167, n);
                this.cfw.markLabel(n5, s2);
                Codegen.pushUndefined(this.cfw);
                this.cfw.add(165, n);
            }
            this.cfw.add(167, n2);
        } else {
            int n6;
            Object object;
            int n7 = this.nodeIsDirectCallParameter(node2);
            if (n7 != -1 && node3.getType() == 153 && ((Node)(object = node3.getFirstChild())).getType() == 40) {
                this.cfw.addALoad(n7);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                n6 = this.cfw.acquireLabel();
                this.cfw.add(166, n6);
                this.cfw.addDLoad(n7 + 1);
                this.cfw.addPush(((Node)object).getDouble());
                this.cfw.add(151);
                if (n3 == 12) {
                    this.cfw.add(153, n);
                } else {
                    this.cfw.add(154, n);
                }
                this.cfw.add(167, n2);
                this.cfw.markLabel(n6);
            }
            this.generateExpression(node2, node);
            this.generateExpression(node3, node);
            switch (n3) {
                case 12: {
                    object = "eq";
                    n6 = 154;
                    break;
                }
                case 13: {
                    object = "eq";
                    n6 = 153;
                    break;
                }
                case 46: {
                    object = "shallowEq";
                    n6 = 154;
                    break;
                }
                case 47: {
                    object = "shallowEq";
                    n6 = 153;
                    break;
                }
                default: {
                    throw Codegen.badTree();
                }
            }
            this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)Z");
            this.cfw.add(n6, n);
            this.cfw.add(167, n2);
        }
        if (s != this.cfw.getStackTop()) {
            throw Codegen.badTree();
        }
    }

    private void visitSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitStrictSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("strictSetName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitSetConst(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateExpression(node2, node);
            node2 = node2.getNext();
        }
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addPush(string);
        this.addScriptRuntimeInvoke("setConst", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Ljava/lang/String;)Ljava/lang/Object;");
    }

    private void visitGetVar(Node node) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        short s = this.varRegisters[n];
        if (this.varIsDirectCallParameter(n)) {
            if (node.getIntProp(8, -1) != -1) {
                this.dcpLoadAsNumber(s);
            } else {
                this.dcpLoadAsObject(s);
            }
        } else if (this.fnCurrent.isNumberVar(n)) {
            this.cfw.addDLoad(s);
        } else {
            this.cfw.addALoad(s);
        }
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        this.generateExpression(node2.getNext(), node);
        boolean bl2 = node.getIntProp(8, -1) != -1;
        short s = this.varRegisters[n];
        boolean[] blArray = this.fnCurrent.fnode.getParamAndVarConst();
        if (blArray[n]) {
            if (!bl) {
                if (bl2) {
                    this.cfw.add(88);
                } else {
                    this.cfw.add(87);
                }
            }
        } else if (this.varIsDirectCallParameter(n)) {
            if (bl2) {
                if (bl) {
                    this.cfw.add(92);
                }
                this.cfw.addALoad(s);
                this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n2 = this.cfw.acquireLabel();
                int n3 = this.cfw.acquireLabel();
                this.cfw.add(165, n2);
                short s2 = this.cfw.getStackTop();
                this.addDoubleWrap();
                this.cfw.addAStore(s);
                this.cfw.add(167, n3);
                this.cfw.markLabel(n2, s2);
                this.cfw.addDStore(s + 1);
                this.cfw.markLabel(n3);
            } else {
                if (bl) {
                    this.cfw.add(89);
                }
                this.cfw.addAStore(s);
            }
        } else {
            boolean bl3 = this.fnCurrent.isNumberVar(n);
            if (bl2) {
                if (bl3) {
                    this.cfw.addDStore(s);
                    if (bl) {
                        this.cfw.addDLoad(s);
                    }
                } else {
                    if (bl) {
                        this.cfw.add(92);
                    }
                    this.addDoubleWrap();
                    this.cfw.addAStore(s);
                }
            } else {
                if (bl3) {
                    Kit.codeBug();
                }
                this.cfw.addAStore(s);
                if (bl) {
                    this.cfw.addALoad(s);
                }
            }
        }
    }

    private void visitSetConstVar(Node node, Node node2, boolean bl) {
        if (!this.hasVarsInRegs) {
            Kit.codeBug();
        }
        int n = this.fnCurrent.getVarIndex(node);
        this.generateExpression(node2.getNext(), node);
        boolean bl2 = node.getIntProp(8, -1) != -1;
        short s = this.varRegisters[n];
        int n2 = this.cfw.acquireLabel();
        int n3 = this.cfw.acquireLabel();
        if (bl2) {
            this.cfw.addILoad(s + 2);
            this.cfw.add(154, n3);
            short s2 = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(s + 2);
            this.cfw.addDStore(s);
            if (bl) {
                this.cfw.addDLoad(s);
                this.cfw.markLabel(n3, s2);
            } else {
                this.cfw.add(167, n2);
                this.cfw.markLabel(n3, s2);
                this.cfw.add(88);
            }
        } else {
            this.cfw.addILoad(s + 1);
            this.cfw.add(154, n3);
            short s3 = this.cfw.getStackTop();
            this.cfw.addPush(1);
            this.cfw.addIStore(s + 1);
            this.cfw.addAStore(s);
            if (bl) {
                this.cfw.addALoad(s);
                this.cfw.markLabel(n3, s3);
            } else {
                this.cfw.add(167, n2);
                this.cfw.markLabel(n3, s3);
                this.cfw.add(87);
            }
        }
        this.cfw.markLabel(n2);
    }

    private void visitGetProp(Node node, Node node2) {
        this.generateExpression(node2, node);
        Node node3 = node2.getNext();
        this.generateExpression(node3, node);
        if (node.getType() == 34) {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getObjectPropNoWarn", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            return;
        }
        int n = node2.getType();
        if (n == 43 && node3.getType() == 41) {
            this.cfw.addALoad(this.contextLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
        } else {
            this.cfw.addALoad(this.contextLocal);
            this.cfw.addALoad(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitSetProp(int n, Node node, Node node2) {
        Node node3 = node2;
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 143) {
            this.cfw.add(89);
        }
        Node node4 = node2;
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 143) {
            this.cfw.add(90);
            if (node3.getType() == 43 && node4.getType() == 41) {
                this.cfw.addALoad(this.contextLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;)Ljava/lang/Object;");
            } else {
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setObjectProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
    }

    private void visitSetElem(int n, Node node, Node node2) {
        boolean bl;
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        if (n == 144) {
            this.cfw.add(89);
        }
        this.generateExpression(node2, node);
        node2 = node2.getNext();
        boolean bl2 = bl = node.getIntProp(8, -1) != -1;
        if (n == 144) {
            if (bl) {
                this.cfw.add(93);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectIndex", "(Ljava/lang/Object;DLorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            } else {
                this.cfw.add(90);
                this.cfw.addALoad(this.contextLocal);
                this.cfw.addALoad(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
            }
        }
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.contextLocal);
        this.cfw.addALoad(this.variableObjectLocal);
        if (bl) {
            this.addScriptRuntimeInvoke("setObjectIndex", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("setObjectElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        }
    }

    private void visitDotQuery(Node node, Node node2) {
        this.updateLineNumber(node);
        this.generateExpression(node2, node);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterDotQuery", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
        this.cfw.add(1);
        int n = this.cfw.acquireLabel();
        this.cfw.markLabel(n);
        this.cfw.add(87);
        this.generateExpression(node2.getNext(), node);
        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)Z");
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("updateDotQuery", "(ZLorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;");
        this.cfw.add(89);
        this.cfw.add(198, n);
        this.cfw.addALoad(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveDotQuery", "(Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        this.cfw.addAStore(this.variableObjectLocal);
    }

    private static int getLocalBlockRegister(Node node) {
        Node node2 = (Node)node.getProp(3);
        int n = node2.getExistingIntProp(2);
        return n;
    }

    private void dcpLoadAsNumber(int n) {
        this.cfw.addALoad(n);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int n2 = this.cfw.acquireLabel();
        this.cfw.add(165, n2);
        short s = this.cfw.getStackTop();
        this.cfw.addALoad(n);
        this.addObjectToDouble();
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        this.cfw.markLabel(n2, s);
        this.cfw.addDLoad(n + 1);
        this.cfw.markLabel(n3);
    }

    private void dcpLoadAsObject(int n) {
        this.cfw.addALoad(n);
        this.cfw.add(178, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
        int n2 = this.cfw.acquireLabel();
        this.cfw.add(165, n2);
        short s = this.cfw.getStackTop();
        this.cfw.addALoad(n);
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(167, n3);
        this.cfw.markLabel(n2, s);
        this.cfw.addDLoad(n + 1);
        this.addDoubleWrap();
        this.cfw.markLabel(n3);
    }

    private void addGoto(Node node, int n) {
        int n2 = this.getTargetLabel(node);
        this.cfw.add(n, n2);
    }

    private void addObjectToDouble() {
        this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)D");
    }

    private void addObjectToNumeric() {
        this.addScriptRuntimeInvoke("toNumeric", "(Ljava/lang/Object;)Ljava/lang/Number;");
    }

    private void addNewObjectArray(int n) {
        if (n == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.cfw.addALoad(this.itsZeroArgArray);
            } else {
                this.cfw.add(178, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
            }
        } else {
            this.cfw.addPush(n);
            this.cfw.add(189, "java/lang/Object");
        }
    }

    private void addScriptRuntimeInvoke(String string, String string2) {
        this.cfw.addInvoke(184, "org.mozilla.javascript.ScriptRuntime", string, string2);
    }

    private void addOptRuntimeInvoke(String string, String string2) {
        this.cfw.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", string, string2);
    }

    private void addJumpedBooleanWrap(int n, int n2) {
        this.cfw.markLabel(n2);
        int n3 = this.cfw.acquireLabel();
        this.cfw.add(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cfw.add(167, n3);
        this.cfw.markLabel(n);
        this.cfw.add(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        this.cfw.markLabel(n3);
        this.cfw.adjustStackTop(-1);
    }

    private void addDoubleWrap() {
        this.addOptRuntimeInvoke("wrapDouble", "(D)Ljava/lang/Double;");
    }

    private short getNewWordPairLocal(boolean bl) {
        return this.getNewWordIntern(bl ? 3 : 2);
    }

    private short getNewWordLocal(boolean bl) {
        return this.getNewWordIntern(bl ? 2 : 1);
    }

    private short getNewWordLocal() {
        return this.getNewWordIntern(1);
    }

    private short getNewWordIntern(int n) {
        int n2;
        assert (n >= 1 && n <= 3);
        int[] nArray = this.locals;
        short s = -1;
        if (n > 1) {
            n2 = this.firstFreeLocal;
            block0: while (n2 + n <= 1024) {
                for (int i = 0; i < n; ++i) {
                    if (nArray[n2 + i] == 0) continue;
                    n2 += i + 1;
                    continue block0;
                }
                s = (short)n2;
                break;
            }
        } else {
            s = this.firstFreeLocal;
        }
        if (s != -1) {
            nArray[s] = 1;
            if (n > 1) {
                nArray[s + 1] = 1;
            }
            if (n > 2) {
                nArray[s + 2] = 1;
            }
            if (s == this.firstFreeLocal) {
                for (n2 = s + n; n2 < 1024; ++n2) {
                    if (nArray[n2] != 0) continue;
                    this.firstFreeLocal = (short)n2;
                    if (this.localsMax < this.firstFreeLocal) {
                        this.localsMax = this.firstFreeLocal;
                    }
                    return s;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void incReferenceWordLocal(short s) {
        short s2 = s;
        this.locals[s2] = this.locals[s2] + 1;
    }

    private void decReferenceWordLocal(short s) {
        short s2 = s;
        this.locals[s2] = this.locals[s2] - 1;
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = 0;
    }

    private class ExceptionManager {
        private LinkedList<ExceptionInfo> exceptionInfo = new LinkedList();

        ExceptionManager() {
        }

        void pushExceptionInfo(Jump jump) {
            Node node = BodyCodegen.getFinallyAtTarget(jump.getFinally());
            ExceptionInfo exceptionInfo = new ExceptionInfo(jump, node);
            this.exceptionInfo.add(exceptionInfo);
        }

        void addHandler(int n, int n2, int n3) {
            ExceptionInfo exceptionInfo = this.getTop();
            exceptionInfo.handlerLabels[n] = n2;
            exceptionInfo.exceptionStarts[n] = n3;
        }

        void setHandlers(int[] nArray, int n) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                this.addHandler(i, nArray[i], n);
            }
        }

        int removeHandler(int n, int n2) {
            ExceptionInfo exceptionInfo = this.getTop();
            if (exceptionInfo.handlerLabels[n] != 0) {
                int n3 = exceptionInfo.handlerLabels[n];
                this.endCatch(exceptionInfo, n, n2);
                exceptionInfo.handlerLabels[n] = 0;
                return n3;
            }
            return 0;
        }

        void popExceptionInfo() {
            this.exceptionInfo.removeLast();
        }

        void markInlineFinallyStart(Node node, int n) {
            ListIterator<ExceptionInfo> listIterator = this.exceptionInfo.listIterator(this.exceptionInfo.size());
            while (listIterator.hasPrevious()) {
                ExceptionInfo exceptionInfo = listIterator.previous();
                for (int i = 0; i < 5; ++i) {
                    if (exceptionInfo.handlerLabels[i] == 0 || exceptionInfo.currentFinally != null) continue;
                    this.endCatch(exceptionInfo, i, n);
                    exceptionInfo.exceptionStarts[i] = 0;
                    exceptionInfo.currentFinally = node;
                }
                if (exceptionInfo.finallyBlock != node) continue;
                break;
            }
        }

        void markInlineFinallyEnd(Node node, int n) {
            ListIterator<ExceptionInfo> listIterator = this.exceptionInfo.listIterator(this.exceptionInfo.size());
            while (listIterator.hasPrevious()) {
                ExceptionInfo exceptionInfo = listIterator.previous();
                for (int i = 0; i < 5; ++i) {
                    if (exceptionInfo.handlerLabels[i] == 0 || exceptionInfo.currentFinally != node) continue;
                    exceptionInfo.exceptionStarts[i] = n;
                    exceptionInfo.currentFinally = null;
                }
                if (exceptionInfo.finallyBlock != node) continue;
                break;
            }
        }

        private void endCatch(ExceptionInfo exceptionInfo, int n, int n2) {
            int n3;
            if (exceptionInfo.exceptionStarts[n] == 0) {
                throw new IllegalStateException("bad exception start");
            }
            int n4 = exceptionInfo.exceptionStarts[n];
            int n5 = BodyCodegen.this.cfw.getLabelPC(n4);
            if (n5 != (n3 = BodyCodegen.this.cfw.getLabelPC(n2))) {
                BodyCodegen.this.cfw.addExceptionHandler(exceptionInfo.exceptionStarts[n], n2, exceptionInfo.handlerLabels[n], BodyCodegen.exceptionTypeToName(n));
            }
        }

        private ExceptionInfo getTop() {
            return this.exceptionInfo.getLast();
        }

        private class ExceptionInfo {
            Node finallyBlock;
            int[] handlerLabels;
            int[] exceptionStarts;
            Node currentFinally;

            ExceptionInfo(Jump jump, Node node) {
                this.finallyBlock = node;
                this.handlerLabels = new int[5];
                this.exceptionStarts = new int[5];
                this.currentFinally = null;
            }
        }
    }

    static class FinallyReturnPoint {
        public List<Integer> jsrPoints = new ArrayList<Integer>();
        public int tableLabel = 0;

        FinallyReturnPoint() {
        }
    }
}

