/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.math.BigInteger;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class BigIntLiteral
extends AstNode {
    private String value;
    private BigInteger bigInt;

    public BigIntLiteral() {
        this.type = 83;
    }

    public BigIntLiteral(int n) {
        super(n);
        this.type = 83;
    }

    public BigIntLiteral(int n, int n2) {
        super(n, n2);
        this.type = 83;
    }

    public BigIntLiteral(int n, String string) {
        super(n);
        this.type = 83;
        this.setValue(string);
        this.setLength(string.length());
    }

    public BigIntLiteral(int n, String string, BigInteger bigInteger) {
        this(n, string);
        this.setBigInt(bigInteger);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.assertNotNull(string);
        this.value = string;
    }

    @Override
    public BigInteger getBigInt() {
        return this.bigInt;
    }

    @Override
    public void setBigInt(BigInteger bigInteger) {
        this.bigInt = bigInteger;
    }

    @Override
    public String toSource(int n) {
        return this.makeIndent(n) + (this.bigInt == null ? "<null>" : this.bigInt.toString());
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

