/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

class SpecialRef
extends Ref {
    private static final long serialVersionUID = -7521596632456797847L;
    private static final int SPECIAL_NONE = 0;
    private static final int SPECIAL_PROTO = 1;
    private static final int SPECIAL_PARENT = 2;
    private Scriptable target;
    private int type;
    private String name;

    private SpecialRef(Scriptable scriptable, int n, String string) {
        this.target = scriptable;
        this.type = n;
        this.name = string;
    }

    static Ref createSpecial(Context context, Scriptable scriptable, Object object, String string) {
        int n;
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        if (string.equals("__proto__")) {
            n = 1;
        } else if (string.equals("__parent__")) {
            n = 2;
        } else {
            throw new IllegalArgumentException(string);
        }
        if (!context.hasFeature(5)) {
            n = 0;
        }
        return new SpecialRef(scriptable2, n, string);
    }

    @Override
    public Object get(Context context) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.getObjectProp(this.target, this.name, context);
            }
            case 1: {
                return this.target.getPrototype();
            }
            case 2: {
                return this.target.getParentScope();
            }
        }
        throw Kit.codeBug();
    }

    @Override
    @Deprecated
    public Object set(Context context, Object object) {
        throw new IllegalStateException();
    }

    @Override
    public Object set(Context context, Scriptable scriptable, Object object) {
        switch (this.type) {
            case 0: {
                return ScriptRuntime.setObjectProp(this.target, this.name, object, context);
            }
            case 1: 
            case 2: {
                Object object2;
                Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
                if (scriptable2 != null) {
                    object2 = scriptable2;
                    do {
                        if (object2 != this.target) continue;
                        throw Context.reportRuntimeErrorById("msg.cyclic.value", this.name);
                    } while ((object2 = this.type == 1 ? object2.getPrototype() : object2.getParentScope()) != null);
                }
                if (this.type == 1) {
                    if (this.target instanceof ScriptableObject && !((ScriptableObject)this.target).isExtensible() && context.getLanguageVersion() >= 180) {
                        throw ScriptRuntime.typeErrorById("msg.not.extensible", new Object[0]);
                    }
                    if (context.getLanguageVersion() >= 200) {
                        object2 = ScriptRuntime.typeof(this.target);
                        if ("function".equals(object2)) {
                            if (object == null) {
                                this.target.setPrototype(Undefined.SCRIPTABLE_UNDEFINED);
                                return object;
                            }
                            String string = ScriptRuntime.typeof(object);
                            if ("object".equals(string) || "function".equals(string)) {
                                this.target.setPrototype(scriptable2);
                            }
                            return object;
                        }
                        String string = ScriptRuntime.typeof(object);
                        if (object != null && !"object".equals(string) || !"object".equals(object2)) {
                            return Undefined.instance;
                        }
                        this.target.setPrototype(scriptable2);
                    } else {
                        this.target.setPrototype(scriptable2);
                    }
                } else {
                    this.target.setParentScope(scriptable2);
                }
                return scriptable2;
            }
        }
        throw Kit.codeBug();
    }

    @Override
    public boolean has(Context context) {
        if (this.type == 0) {
            return ScriptRuntime.hasObjectElem(this.target, this.name, context);
        }
        return true;
    }

    @Override
    public boolean delete(Context context) {
        if (this.type == 0) {
            return ScriptRuntime.deleteObjectElem(this.target, this.name, context);
        }
        return false;
    }
}

