/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import org.mozilla.javascript.AbstractEcmaObjectOperations;
import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeBigInt;
import org.mozilla.javascript.NativeBoolean;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeCollectionIterator;
import org.mozilla.javascript.NativeDate;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeIterator;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeJavaMap;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeMap;
import org.mozilla.javascript.NativeMath;
import org.mozilla.javascript.NativeNumber;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativePromise;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.NativeSet;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.NativeStringIterator;
import org.mozilla.javascript.NativeSymbol;
import org.mozilla.javascript.NativeWeakMap;
import org.mozilla.javascript.NativeWeakSet;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.RefCallable;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SpecialRef;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.SymbolScriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.v8dtoa.DoubleConversion;
import org.mozilla.javascript.v8dtoa.FastDtoa;
import org.mozilla.javascript.xml.XMLLib;
import org.mozilla.javascript.xml.XMLObject;

public class ScriptRuntime {
    public static final Class<?> BooleanClass = Kit.classOrNull("java.lang.Boolean");
    public static final Class<?> ByteClass = Kit.classOrNull("java.lang.Byte");
    public static final Class<?> CharacterClass = Kit.classOrNull("java.lang.Character");
    public static final Class<?> ClassClass = Kit.classOrNull("java.lang.Class");
    public static final Class<?> DoubleClass = Kit.classOrNull("java.lang.Double");
    public static final Class<?> FloatClass = Kit.classOrNull("java.lang.Float");
    public static final Class<?> IntegerClass = Kit.classOrNull("java.lang.Integer");
    public static final Class<?> LongClass = Kit.classOrNull("java.lang.Long");
    public static final Class<?> NumberClass = Kit.classOrNull("java.lang.Number");
    public static final Class<?> ObjectClass = Kit.classOrNull("java.lang.Object");
    public static final Class<?> ShortClass = Kit.classOrNull("java.lang.Short");
    public static final Class<?> StringClass = Kit.classOrNull("java.lang.String");
    public static final Class<?> DateClass = Kit.classOrNull("java.util.Date");
    public static final Class<?> BigIntegerClass = Kit.classOrNull("java.math.BigInteger");
    public static final Class<?> ContextClass = Kit.classOrNull("org.mozilla.javascript.Context");
    public static final Class<?> ContextFactoryClass = Kit.classOrNull("org.mozilla.javascript.ContextFactory");
    public static final Class<?> FunctionClass = Kit.classOrNull("org.mozilla.javascript.Function");
    public static final Class<?> ScriptableObjectClass = Kit.classOrNull("org.mozilla.javascript.ScriptableObject");
    public static final Class<Scriptable> ScriptableClass = Scriptable.class;
    private static final Object LIBRARY_SCOPE_KEY = "LIBRARY_SCOPE";
    public static final double NaN = Double.NaN;
    public static final Double NaNobj = Double.NaN;
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final Double zeroObj = 0.0;
    public static final Double negativeZeroObj = -0.0;
    private static final String DEFAULT_NS_TAG = "__default_namespace__";
    public static final int ENUMERATE_KEYS = 0;
    public static final int ENUMERATE_VALUES = 1;
    public static final int ENUMERATE_ARRAY = 2;
    public static final int ENUMERATE_KEYS_NO_ITERATOR = 3;
    public static final int ENUMERATE_VALUES_NO_ITERATOR = 4;
    public static final int ENUMERATE_ARRAY_NO_ITERATOR = 5;
    public static final int ENUMERATE_VALUES_IN_ORDER = 6;
    public static final MessageProvider messageProvider = new DefaultMessageProvider();
    public static final Object[] emptyArgs = new Object[0];
    public static final String[] emptyStrings = new String[0];

    protected ScriptRuntime() {
    }

    @Deprecated
    public static BaseFunction typeErrorThrower() {
        return ScriptRuntime.typeErrorThrower(Context.getCurrentContext());
    }

    public static BaseFunction typeErrorThrower(Context context) {
        if (context.typeErrorThrower == null) {
            BaseFunction baseFunction = new BaseFunction(){
                private static final long serialVersionUID = -5891740962154902286L;

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    throw ScriptRuntime.typeErrorById("msg.op.not.allowed", new Object[0]);
                }

                @Override
                public int getLength() {
                    return 0;
                }
            };
            ScriptRuntime.setFunctionProtoAndParent(baseFunction, context, context.topCallScope, false);
            baseFunction.preventExtensions();
            context.typeErrorThrower = baseFunction;
        }
        return context.typeErrorThrower;
    }

    public static boolean isRhinoRuntimeType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz != Character.TYPE;
        }
        return clazz == StringClass || clazz == BooleanClass || NumberClass.isAssignableFrom(clazz) || ScriptableClass.isAssignableFrom(clazz);
    }

    public static ScriptableObject initSafeStandardObjects(Context context, ScriptableObject scriptableObject, boolean bl) {
        if (scriptableObject == null) {
            scriptableObject = new NativeObject();
        } else if (scriptableObject instanceof TopLevel) {
            ((TopLevel)scriptableObject).clearCache();
        }
        scriptableObject.associateValue(LIBRARY_SCOPE_KEY, scriptableObject);
        new ClassCache().associate(scriptableObject);
        BaseFunction.init(context, scriptableObject, bl);
        NativeObject.init(scriptableObject, bl);
        Scriptable scriptable = ScriptableObject.getObjectPrototype(scriptableObject);
        Scriptable scriptable2 = ScriptableObject.getClassPrototype(scriptableObject, "Function");
        scriptable2.setPrototype(scriptable);
        if (scriptableObject.getPrototype() == null) {
            scriptableObject.setPrototype(scriptable);
        }
        NativeError.init(scriptableObject, bl);
        NativeGlobal.init(context, scriptableObject, bl);
        NativeArray.init(scriptableObject, bl);
        if (context.getOptimizationLevel() > 0) {
            NativeArray.setMaximumInitialCapacity(200000);
        }
        NativeString.init(scriptableObject, bl);
        NativeBoolean.init(scriptableObject, bl);
        NativeNumber.init(scriptableObject, bl);
        NativeDate.init(scriptableObject, bl);
        NativeMath.init(scriptableObject, bl);
        NativeJSON.init(scriptableObject, bl);
        NativeWith.init(scriptableObject, bl);
        NativeCall.init(scriptableObject, bl);
        NativeScript.init(context, scriptableObject, bl);
        NativeIterator.init(context, scriptableObject, bl);
        NativeArrayIterator.init(scriptableObject, bl);
        NativeStringIterator.init(scriptableObject, bl);
        NativeJavaObject.init(scriptableObject, bl);
        NativeJavaMap.init(scriptableObject, bl);
        boolean bl2 = context.hasFeature(6) && context.getE4xImplementationFactory() != null;
        new LazilyLoadedCtor(scriptableObject, "RegExp", "org.mozilla.javascript.regexp.NativeRegExp", bl, true);
        new LazilyLoadedCtor(scriptableObject, "Continuation", "org.mozilla.javascript.NativeContinuation", bl, true);
        if (bl2) {
            String string = context.getE4xImplementationFactory().getImplementationClassName();
            new LazilyLoadedCtor(scriptableObject, "XML", string, bl, true);
            new LazilyLoadedCtor(scriptableObject, "XMLList", string, bl, true);
            new LazilyLoadedCtor(scriptableObject, "Namespace", string, bl, true);
            new LazilyLoadedCtor(scriptableObject, "QName", string, bl, true);
        }
        if (context.getLanguageVersion() >= 180 && context.hasFeature(14) || context.getLanguageVersion() >= 200) {
            new LazilyLoadedCtor(scriptableObject, "ArrayBuffer", "org.mozilla.javascript.typedarrays.NativeArrayBuffer", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Int8Array", "org.mozilla.javascript.typedarrays.NativeInt8Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint8Array", "org.mozilla.javascript.typedarrays.NativeUint8Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint8ClampedArray", "org.mozilla.javascript.typedarrays.NativeUint8ClampedArray", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Int16Array", "org.mozilla.javascript.typedarrays.NativeInt16Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint16Array", "org.mozilla.javascript.typedarrays.NativeUint16Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Int32Array", "org.mozilla.javascript.typedarrays.NativeInt32Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Uint32Array", "org.mozilla.javascript.typedarrays.NativeUint32Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Float32Array", "org.mozilla.javascript.typedarrays.NativeFloat32Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "Float64Array", "org.mozilla.javascript.typedarrays.NativeFloat64Array", bl, true);
            new LazilyLoadedCtor(scriptableObject, "DataView", "org.mozilla.javascript.typedarrays.NativeDataView", bl, true);
        }
        if (context.getLanguageVersion() >= 200) {
            NativeSymbol.init(context, scriptableObject, bl);
            NativeCollectionIterator.init(scriptableObject, "Set Iterator", bl);
            NativeCollectionIterator.init(scriptableObject, "Map Iterator", bl);
            NativeMap.init(context, scriptableObject, bl);
            NativePromise.init(context, scriptableObject, bl);
            NativeSet.init(context, scriptableObject, bl);
            NativeWeakMap.init(scriptableObject, bl);
            NativeWeakSet.init(scriptableObject, bl);
            NativeBigInt.init(scriptableObject, bl);
        }
        if (scriptableObject instanceof TopLevel) {
            ((TopLevel)scriptableObject).cacheBuiltins(scriptableObject, bl);
        }
        return scriptableObject;
    }

    public static ScriptableObject initStandardObjects(Context context, ScriptableObject scriptableObject, boolean bl) {
        ScriptableObject scriptableObject2 = ScriptRuntime.initSafeStandardObjects(context, scriptableObject, bl);
        new LazilyLoadedCtor(scriptableObject2, "Packages", "org.mozilla.javascript.NativeJavaTopPackage", bl, true);
        new LazilyLoadedCtor(scriptableObject2, "getClass", "org.mozilla.javascript.NativeJavaTopPackage", bl, true);
        new LazilyLoadedCtor(scriptableObject2, "JavaAdapter", "org.mozilla.javascript.JavaAdapter", bl, true);
        new LazilyLoadedCtor(scriptableObject2, "JavaImporter", "org.mozilla.javascript.ImporterTopLevel", bl, true);
        for (String string : ScriptRuntime.getTopPackageNames()) {
            new LazilyLoadedCtor(scriptableObject2, string, "org.mozilla.javascript.NativeJavaTopPackage", bl, true);
        }
        return scriptableObject2;
    }

    static String[] getTopPackageNames() {
        String[] stringArray;
        if ("Dalvik".equals(System.getProperty("java.vm.name"))) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "java";
            stringArray2[1] = "javax";
            stringArray2[2] = "org";
            stringArray2[3] = "com";
            stringArray2[4] = "edu";
            stringArray2[5] = "net";
            stringArray = stringArray2;
            stringArray2[6] = "android";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "java";
            stringArray3[1] = "javax";
            stringArray3[2] = "org";
            stringArray3[3] = "com";
            stringArray3[4] = "edu";
            stringArray = stringArray3;
            stringArray3[5] = "net";
        }
        return stringArray;
    }

    public static ScriptableObject getLibraryScopeOrNull(Scriptable scriptable) {
        ScriptableObject scriptableObject = (ScriptableObject)ScriptableObject.getTopScopeValue(scriptable, LIBRARY_SCOPE_KEY);
        return scriptableObject;
    }

    public static boolean isJSLineTerminator(int n) {
        if ((n & 0xDFD0) != 0) {
            return false;
        }
        return n == 10 || n == 13 || n == 8232 || n == 8233;
    }

    public static boolean isJSWhitespaceOrLineTerminator(int n) {
        return ScriptRuntime.isStrWhiteSpaceChar(n) || ScriptRuntime.isJSLineTerminator(n);
    }

    static boolean isStrWhiteSpaceChar(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: 
            case 160: 
            case 8232: 
            case 8233: 
            case 65279: {
                return true;
            }
        }
        return Character.getType(n) == 12;
    }

    public static Boolean wrapBoolean(boolean bl) {
        return bl;
    }

    public static Integer wrapInt(int n) {
        return n;
    }

    public static Number wrapNumber(double d) {
        if (Double.isNaN(d)) {
            return NaNobj;
        }
        return d;
    }

    public static boolean toBoolean(Object object) {
        block7: {
            do {
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
                if (object == null || Undefined.isUndefined(object)) {
                    return false;
                }
                if (object instanceof CharSequence) {
                    return ((CharSequence)object).length() != 0;
                }
                if (object instanceof BigInteger) {
                    return !BigInteger.ZERO.equals(object);
                }
                if (object instanceof Number) {
                    double d = ((Number)object).doubleValue();
                    return !Double.isNaN(d) && d != 0.0;
                }
                if (!(object instanceof Scriptable)) break block7;
                if (object instanceof ScriptableObject && ((ScriptableObject)object).avoidObjectDetection()) {
                    return false;
                }
                if (!Context.getContext().isVersionECMA1()) continue;
                return true;
            } while (!((object = ((Scriptable)object).getDefaultValue(BooleanClass)) instanceof Scriptable) || ScriptRuntime.isSymbol(object));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return true;
    }

    public static double toNumber(Object object) {
        block9: {
            do {
                if (object instanceof BigInteger) {
                    throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
                }
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                if (object == null) {
                    return 0.0;
                }
                if (Undefined.isUndefined(object)) {
                    return Double.NaN;
                }
                if (object instanceof String) {
                    return ScriptRuntime.toNumber((String)object);
                }
                if (object instanceof CharSequence) {
                    return ScriptRuntime.toNumber(object.toString());
                }
                if (object instanceof Boolean) {
                    return (Boolean)object != false ? 1.0 : 0.0;
                }
                if (object instanceof Symbol) {
                    throw ScriptRuntime.typeErrorById("msg.not.a.number", new Object[0]);
                }
                if (!(object instanceof Scriptable)) break block9;
            } while (!((object = ((Scriptable)object).getDefaultValue(NumberClass)) instanceof Scriptable) || ScriptRuntime.isSymbol(object));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return Double.NaN;
    }

    public static double toNumber(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toNumber(objectArray[n]) : Double.NaN;
    }

    static double stringPrefixToNumber(String string, int n, int n2) {
        return ScriptRuntime.stringToNumber(string, n, string.length() - 1, n2, true);
    }

    static double stringToNumber(String string, int n, int n2, int n3) {
        return ScriptRuntime.stringToNumber(string, n, n2, n3, false);
    }

    private static double stringToNumber(String string, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6;
        int n7 = 57;
        int n8 = 97;
        int n9 = 65;
        if (n3 < 10) {
            n7 = (char)(48 + n3 - 1);
        }
        if (n3 > 10) {
            n8 = (char)(97 + n3 - 10);
            n9 = (char)(65 + n3 - 10);
        }
        double d = 0.0;
        for (n6 = n; n6 <= n2; ++n6) {
            n5 = string.charAt(n6);
            if (48 <= n5 && n5 <= n7) {
                n4 = n5 - 48;
            } else if (97 <= n5 && n5 < n8) {
                n4 = n5 - 97 + 10;
            } else if (65 <= n5 && n5 < n9) {
                n4 = n5 - 65 + 10;
            } else {
                if (bl) break;
                return Double.NaN;
            }
            d = d * (double)n3 + (double)n4;
        }
        if (n == n6) {
            return Double.NaN;
        }
        if (d > 9.007199254740991E15) {
            if (n3 == 10) {
                try {
                    return Double.parseDouble(string.substring(n, n6));
                }
                catch (NumberFormatException numberFormatException) {
                    return Double.NaN;
                }
            }
            if (n3 == 2 || n3 == 4 || n3 == 8 || n3 == 16 || n3 == 32) {
                n5 = 1;
                n4 = 0;
                boolean bl2 = false;
                boolean bl3 = true;
                int n10 = 2;
                int n11 = 3;
                int n12 = 4;
                int n13 = 0;
                int n14 = 53;
                double d2 = 0.0;
                boolean bl4 = false;
                boolean bl5 = false;
                int n15 = n;
                while (true) {
                    if (n5 == 1) {
                        if (n15 == n6) break;
                        n4 = 48 <= (n4 = (int)string.charAt(n15++)) && n4 <= 57 ? (n4 -= 48) : (97 <= n4 && n4 <= 122 ? (n4 -= 87) : (n4 -= 55));
                        n5 = n3;
                    }
                    boolean bl6 = (n4 & (n5 >>= 1)) != 0;
                    switch (n13) {
                        case 0: {
                            if (!bl6) break;
                            --n14;
                            d = 1.0;
                            n13 = 1;
                            break;
                        }
                        case 1: {
                            d *= 2.0;
                            if (bl6) {
                                d += 1.0;
                            }
                            if (--n14 != 0) break;
                            bl4 = bl6;
                            n13 = 2;
                            break;
                        }
                        case 2: {
                            bl5 = bl6;
                            d2 = 2.0;
                            n13 = 3;
                            break;
                        }
                        case 3: {
                            if (bl6) {
                                n13 = 4;
                            }
                        }
                        case 4: {
                            d2 *= 2.0;
                        }
                    }
                }
                switch (n13) {
                    case 0: {
                        d = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bl5 & bl4) {
                            d += 1.0;
                        }
                        d *= d2;
                        break;
                    }
                    case 4: {
                        if (bl5) {
                            d += 1.0;
                        }
                        d *= d2;
                    }
                }
            }
        }
        return d;
    }

    public static double toNumber(String string) {
        int n;
        char c;
        boolean bl;
        char c2;
        char c3;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return 0.0;
            }
            c3 = string.charAt(n3);
            if (!ScriptRuntime.isStrWhiteSpaceChar(c3)) break;
            ++n3;
        }
        int n4 = n2 - 1;
        while (ScriptRuntime.isStrWhiteSpaceChar(c2 = string.charAt(n4))) {
            --n4;
        }
        Context context = Context.getCurrentContext();
        boolean bl2 = bl = context == null || context.getLanguageVersion() < 200;
        if (c3 == '0') {
            if (n3 + 2 <= n4) {
                c = string.charAt(n3 + 1);
                n = -1;
                if (c == 'x' || c == 'X') {
                    n = 16;
                } else if (!(bl || c != 'o' && c != 'O')) {
                    n = 8;
                } else if (!(bl || c != 'b' && c != 'B')) {
                    n = 2;
                }
                if (n != -1) {
                    if (bl) {
                        return ScriptRuntime.stringPrefixToNumber(string, n3 + 2, n);
                    }
                    return ScriptRuntime.stringToNumber(string, n3 + 2, n4, n);
                }
            }
        } else if (!(!bl || c3 != '+' && c3 != '-' || n3 + 3 > n4 || string.charAt(n3 + 1) != '0' || (c = string.charAt(n3 + 2)) != 'x' && c != 'X')) {
            double d = ScriptRuntime.stringPrefixToNumber(string, n3 + 3, 16);
            return c3 == '-' ? -d : d;
        }
        if (c2 == 'y') {
            if (c3 == '+' || c3 == '-') {
                ++n3;
            }
            if (n3 + 7 == n4 && string.regionMatches(n3, "Infinity", 0, 8)) {
                return c3 == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        String string2 = string.substring(n3, n4 + 1);
        for (n = string2.length() - 1; n >= 0; --n) {
            char c4 = string2.charAt(n);
            if ('0' <= c4 && c4 <= '9' || c4 == '.' || c4 == 'e' || c4 == 'E' || c4 == '+' || c4 == '-') continue;
            return Double.NaN;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static BigInteger toBigInt(Object object) {
        block13: {
            do {
                if (object instanceof BigInteger) {
                    return (BigInteger)object;
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).toBigInteger();
                }
                if (object instanceof Number) {
                    if (object instanceof Long) {
                        return BigInteger.valueOf((Long)object);
                    }
                    double d = ((Number)object).doubleValue();
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        throw ScriptRuntime.rangeErrorById("msg.cant.convert.to.bigint.isnt.integer", ScriptRuntime.toString(object));
                    }
                    BigDecimal bigDecimal = new BigDecimal(d, MathContext.UNLIMITED);
                    try {
                        return bigDecimal.toBigIntegerExact();
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw ScriptRuntime.rangeErrorById("msg.cant.convert.to.bigint.isnt.integer", ScriptRuntime.toString(object));
                    }
                }
                if (object == null || Undefined.isUndefined(object)) {
                    throw ScriptRuntime.typeErrorById("msg.cant.convert.to.bigint", ScriptRuntime.toString(object));
                }
                if (object instanceof String) {
                    return ScriptRuntime.toBigInt((String)object);
                }
                if (object instanceof CharSequence) {
                    return ScriptRuntime.toBigInt(object.toString());
                }
                if (object instanceof Boolean) {
                    return (Boolean)object != false ? BigInteger.ONE : BigInteger.ZERO;
                }
                if (object instanceof Symbol) {
                    throw ScriptRuntime.typeErrorById("msg.cant.convert.to.bigint", ScriptRuntime.toString(object));
                }
                if (!(object instanceof Scriptable)) break block13;
            } while (!((object = ((Scriptable)object).getDefaultValue(BigIntegerClass)) instanceof Scriptable) || ScriptRuntime.isSymbol(object));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return BigInteger.ZERO;
    }

    public static BigInteger toBigInt(String string) {
        int n;
        char c;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 == n2) {
                return BigInteger.ZERO;
            }
            c = string.charAt(n3);
            if (!ScriptRuntime.isStrWhiteSpaceChar(c)) break;
            ++n3;
        }
        int n4 = n2 - 1;
        while (ScriptRuntime.isStrWhiteSpaceChar(string.charAt(n4))) {
            --n4;
        }
        if (c == '0' && n3 + 2 <= n4) {
            char c2 = string.charAt(n3 + 1);
            n = -1;
            if (c2 == 'x' || c2 == 'X') {
                n = 16;
            } else if (c2 == 'o' || c2 == 'O') {
                n = 8;
            } else if (c2 == 'b' || c2 == 'B') {
                n = 2;
            }
            if (n != -1) {
                try {
                    return new BigInteger(string.substring(n3 + 2, n4 + 1), n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw ScriptRuntime.syntaxErrorById("msg.bigint.bad.form", new Object[0]);
                }
            }
        }
        String string2 = string.substring(n3, n4 + 1);
        for (n = string2.length() - 1; n >= 0; --n) {
            char c3 = string2.charAt(n);
            if (n == 0 && (c3 == '+' || c3 == '-') || '0' <= c3 && c3 <= '9') continue;
            throw ScriptRuntime.syntaxErrorById("msg.bigint.bad.form", new Object[0]);
        }
        try {
            return new BigInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw ScriptRuntime.syntaxErrorById("msg.bigint.bad.form", new Object[0]);
        }
    }

    public static Number toNumeric(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        return ScriptRuntime.toNumber(object);
    }

    public static int toIndex(Object object) {
        if (Undefined.isUndefined(object)) {
            return 0;
        }
        double d = ScriptRuntime.toInteger(object);
        if (d < 0.0) {
            throw ScriptRuntime.rangeError("index out of range");
        }
        double d2 = Math.min(d, 9.007199254740991E15);
        if (d != d2) {
            throw ScriptRuntime.rangeError("index out of range");
        }
        return (int)d2;
    }

    public static Object[] padArguments(Object[] objectArray, int n) {
        if (n < objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        if (objectArray.length < n) {
            Arrays.fill(objectArray2, objectArray.length, n, Undefined.instance);
        }
        return objectArray2;
    }

    public static String escapeString(String string) {
        return ScriptRuntime.escapeString(string, '\"');
    }

    public static String escapeString(String string, char c) {
        if (c != '\"' && c != '\'') {
            Kit.codeBug();
        }
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i != n; ++i) {
            int n2;
            char c2 = string.charAt(i);
            if (' ' <= c2 && c2 <= '~' && c2 != c && c2 != '\\') {
                if (stringBuilder == null) continue;
                stringBuilder.append(c2);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n + 3);
                stringBuilder.append(string);
                stringBuilder.setLength(i);
            }
            int n3 = -1;
            switch (c2) {
                case '\b': {
                    n3 = 98;
                    break;
                }
                case '\f': {
                    n3 = 102;
                    break;
                }
                case '\n': {
                    n3 = 110;
                    break;
                }
                case '\r': {
                    n3 = 114;
                    break;
                }
                case '\t': {
                    n3 = 116;
                    break;
                }
                case '\u000b': {
                    n3 = 118;
                    break;
                }
                case ' ': {
                    n3 = 32;
                    break;
                }
                case '\\': {
                    n3 = 92;
                }
            }
            if (n3 >= 0) {
                stringBuilder.append('\\');
                stringBuilder.append((char)n3);
                continue;
            }
            if (c2 == c) {
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            if (c2 < '\u0100') {
                stringBuilder.append("\\x");
                n2 = 2;
            } else {
                stringBuilder.append("\\u");
                n2 = 4;
            }
            for (int j = (n2 - 1) * 4; j >= 0; j -= 4) {
                int n4 = 0xF & c2 >> j;
                int n5 = n4 < 10 ? 48 + n4 : 87 + n4;
                stringBuilder.append((char)n5);
            }
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    static boolean isValidIdentifierName(String string, Context context, boolean bl) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i != n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return !TokenStream.isKeyword(string, context.getLanguageVersion(), bl);
    }

    public static CharSequence toCharSequence(Object object) {
        if (object instanceof NativeString) {
            return ((NativeString)object).toCharSequence();
        }
        return object instanceof CharSequence ? (CharSequence)object : ScriptRuntime.toString(object);
    }

    public static String toString(Object object) {
        block8: {
            do {
                if (object == null) {
                    return "null";
                }
                if (Undefined.isUndefined(object)) {
                    return "undefined";
                }
                if (object instanceof String) {
                    return (String)object;
                }
                if (object instanceof CharSequence) {
                    return object.toString();
                }
                if (object instanceof BigInteger) {
                    return object.toString();
                }
                if (object instanceof Number) {
                    return ScriptRuntime.numberToString(((Number)object).doubleValue(), 10);
                }
                if (object instanceof Symbol) {
                    throw ScriptRuntime.typeErrorById("msg.not.a.string", new Object[0]);
                }
                if (!(object instanceof Scriptable)) break block8;
            } while (!((object = ((Scriptable)object).getDefaultValue(StringClass)) instanceof Scriptable) || ScriptRuntime.isSymbol(object));
            throw ScriptRuntime.errorWithClassName("msg.primitive.expected", object);
        }
        return object.toString();
    }

    static String defaultObjectToString(Scriptable scriptable) {
        if (scriptable == null) {
            return "[object Null]";
        }
        if (Undefined.isUndefined(scriptable)) {
            return "[object Undefined]";
        }
        return "[object " + scriptable.getClassName() + ']';
    }

    public static String toString(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toString(objectArray[n]) : "undefined";
    }

    public static String toString(double d) {
        return ScriptRuntime.numberToString(d, 10);
    }

    public static String numberToString(double d, int n) {
        if (n < 2 || n > 36) {
            throw Context.reportRuntimeErrorById("msg.bad.radix", Integer.toString(n));
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (n != 10) {
            return DToA.JS_dtobasestr(n, d);
        }
        String string = FastDtoa.numberToString(d);
        if (string != null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        DToA.JS_dtostr(stringBuilder, 0, 0, d);
        return stringBuilder.toString();
    }

    public static String bigIntToString(BigInteger bigInteger, int n) {
        if (n < 2 || n > 36) {
            throw ScriptRuntime.rangeErrorById("msg.bad.radix", Integer.toString(n));
        }
        return bigInteger.toString(n);
    }

    static String uneval(Context context, Scriptable scriptable, Object object) {
        if (object == null) {
            return "null";
        }
        if (Undefined.isUndefined(object)) {
            return "undefined";
        }
        if (object instanceof CharSequence) {
            String string = ScriptRuntime.escapeString(object.toString());
            StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
            stringBuilder.append('\"');
            stringBuilder.append(string);
            stringBuilder.append('\"');
            return stringBuilder.toString();
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d == 0.0 && 1.0 / d < 0.0) {
                return "-0";
            }
            return ScriptRuntime.toString(d);
        }
        if (object instanceof Boolean) {
            return ScriptRuntime.toString(object);
        }
        if (object instanceof Scriptable) {
            Object object2;
            Scriptable scriptable2 = (Scriptable)object;
            if (ScriptableObject.hasProperty(scriptable2, "toSource") && (object2 = ScriptableObject.getProperty(scriptable2, "toSource")) instanceof Function) {
                Function function = (Function)object2;
                return ScriptRuntime.toString(function.call(context, scriptable, scriptable2, emptyArgs));
            }
            return ScriptRuntime.toString(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String defaultObjectToSource(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        boolean bl;
        boolean bl2;
        if (context.iterating == null) {
            bl2 = true;
            bl = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl2 = false;
            bl = context.iterating.has(scriptable2);
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        if (bl2) {
            stringBuilder.append("(");
        }
        stringBuilder.append('{');
        try {
            if (!bl) {
                context.iterating.intern(scriptable2);
                Object[] objectArray2 = scriptable2.getIds();
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object;
                    Object object2 = objectArray2[i];
                    if (object2 instanceof Integer) {
                        int n = (Integer)object2;
                        object = scriptable2.get(n, scriptable2);
                        if (object == Scriptable.NOT_FOUND) continue;
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(n);
                    } else {
                        String string = (String)object2;
                        object = scriptable2.get(string, scriptable2);
                        if (object == Scriptable.NOT_FOUND) continue;
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        if (ScriptRuntime.isValidIdentifierName(string, context, context.isStrictMode())) {
                            stringBuilder.append(string);
                        } else {
                            stringBuilder.append('\'');
                            stringBuilder.append(ScriptRuntime.escapeString(string, '\''));
                            stringBuilder.append('\'');
                        }
                    }
                    stringBuilder.append(':');
                    stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object));
                }
            }
        }
        finally {
            if (bl2) {
                context.iterating = null;
            }
        }
        stringBuilder.append('}');
        if (bl2) {
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static Scriptable toObject(Scriptable scriptable, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    @Deprecated
    public static Scriptable toObjectOrNull(Context context, Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object != null && !Undefined.isUndefined(object)) {
            return ScriptRuntime.toObject(context, ScriptRuntime.getTopCallScope(context), object);
        }
        return null;
    }

    public static Scriptable toObjectOrNull(Context context, Object object, Scriptable scriptable) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object != null && !Undefined.isUndefined(object)) {
            return ScriptRuntime.toObject(context, scriptable, object);
        }
        return null;
    }

    @Deprecated
    public static Scriptable toObject(Scriptable scriptable, Object object, Class<?> clazz) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptRuntime.toObject(Context.getContext(), scriptable, object);
    }

    public static Scriptable toObject(Context context, Scriptable scriptable, Object object) {
        if (object == null) {
            throw ScriptRuntime.typeErrorById("msg.null.to.object", new Object[0]);
        }
        if (Undefined.isUndefined(object)) {
            throw ScriptRuntime.typeErrorById("msg.undef.to.object", new Object[0]);
        }
        if (ScriptRuntime.isSymbol(object)) {
            if (object instanceof SymbolKey) {
                NativeSymbol nativeSymbol = new NativeSymbol((SymbolKey)object);
                ScriptRuntime.setBuiltinProtoAndParent(nativeSymbol, scriptable, TopLevel.Builtins.Symbol);
                return nativeSymbol;
            }
            NativeSymbol nativeSymbol = new NativeSymbol((NativeSymbol)object);
            ScriptRuntime.setBuiltinProtoAndParent(nativeSymbol, scriptable, TopLevel.Builtins.Symbol);
            return nativeSymbol;
        }
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        if (object instanceof CharSequence) {
            NativeString nativeString = new NativeString((CharSequence)object);
            ScriptRuntime.setBuiltinProtoAndParent(nativeString, scriptable, TopLevel.Builtins.String);
            return nativeString;
        }
        if (context.getLanguageVersion() >= 200 && object instanceof BigInteger) {
            NativeBigInt nativeBigInt = new NativeBigInt((BigInteger)object);
            ScriptRuntime.setBuiltinProtoAndParent(nativeBigInt, scriptable, TopLevel.Builtins.BigInt);
            return nativeBigInt;
        }
        if (object instanceof Number) {
            NativeNumber nativeNumber = new NativeNumber(((Number)object).doubleValue());
            ScriptRuntime.setBuiltinProtoAndParent(nativeNumber, scriptable, TopLevel.Builtins.Number);
            return nativeNumber;
        }
        if (object instanceof Boolean) {
            NativeBoolean nativeBoolean = new NativeBoolean((Boolean)object);
            ScriptRuntime.setBuiltinProtoAndParent(nativeBoolean, scriptable, TopLevel.Builtins.Boolean);
            return nativeBoolean;
        }
        Object object2 = context.getWrapFactory().wrap(context, scriptable, object, null);
        if (object2 instanceof Scriptable) {
            return (Scriptable)object2;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    @Deprecated
    public static Scriptable toObject(Context context, Scriptable scriptable, Object object, Class<?> clazz) {
        return ScriptRuntime.toObject(context, scriptable, object);
    }

    @Deprecated
    public static Object call(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable) {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(ScriptRuntime.toString(object));
        }
        Function function = (Function)object;
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object2, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefCallError(null, "function");
        }
        return function.call(context, scriptable, scriptable2, objectArray);
    }

    public static Scriptable newObject(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, string);
        if (objectArray == null) {
            objectArray = emptyArgs;
        }
        return function.construct(context, scriptable, objectArray);
    }

    public static Scriptable newBuiltinObject(Context context, Scriptable scriptable, TopLevel.Builtins builtins, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = TopLevel.getBuiltinCtor(context, scriptable, builtins);
        if (objectArray == null) {
            objectArray = emptyArgs;
        }
        return function.construct(context, scriptable, objectArray);
    }

    static Scriptable newNativeError(Context context, Scriptable scriptable, TopLevel.NativeErrors nativeErrors, Object[] objectArray) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = TopLevel.getNativeErrorCtor(context, scriptable, nativeErrors);
        if (objectArray == null) {
            objectArray = emptyArgs;
        }
        return function.construct(context, scriptable, objectArray);
    }

    public static double toInteger(Object object) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(object));
    }

    public static double toInteger(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (d == 0.0 || Double.isInfinite(d)) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInteger(objectArray[n]) : 0.0;
    }

    public static long toLength(Object[] objectArray, int n) {
        double d = ScriptRuntime.toInteger(objectArray, n);
        if (d <= 0.0) {
            return 0L;
        }
        return (long)Math.min(d, 9.007199254740991E15);
    }

    public static int toInt32(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(object));
    }

    public static int toInt32(Object[] objectArray, int n) {
        return n < objectArray.length ? ScriptRuntime.toInt32(objectArray[n]) : 0;
    }

    public static int toInt32(double d) {
        return DoubleConversion.doubleToInt32(d);
    }

    public static long toUint32(double d) {
        return (long)DoubleConversion.doubleToInt32(d) & 0xFFFFFFFFL;
    }

    public static long toUint32(Object object) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(object));
    }

    public static char toUint16(Object object) {
        double d = ScriptRuntime.toNumber(object);
        return (char)DoubleConversion.doubleToInt32(d);
    }

    public static Optional<Double> canonicalNumericIndexString(String string) {
        if ("-0".equals(string)) {
            return Optional.of(Double.NEGATIVE_INFINITY);
        }
        double d = ScriptRuntime.toNumber(string);
        if (Double.isNaN(d)) {
            return Optional.empty();
        }
        String string2 = ScriptRuntime.toString(d);
        if (string2.equals(string)) {
            return Optional.of(d);
        }
        return Optional.empty();
    }

    public static Object setDefaultNamespace(Object object, Context context) {
        Scriptable scriptable = context.currentActivationCall;
        if (scriptable == null) {
            scriptable = ScriptRuntime.getTopCallScope(context);
        }
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        Object object2 = xMLLib.toDefaultXmlNamespace(context, object);
        if (!scriptable.has(DEFAULT_NS_TAG, scriptable)) {
            ScriptableObject.defineProperty(scriptable, DEFAULT_NS_TAG, object2, 6);
        } else {
            scriptable.put(DEFAULT_NS_TAG, scriptable, object2);
        }
        return Undefined.instance;
    }

    public static Object searchDefaultNamespace(Context context) {
        Object object;
        Scriptable scriptable = context.currentActivationCall;
        if (scriptable == null) {
            scriptable = ScriptRuntime.getTopCallScope(context);
        }
        while (true) {
            Scriptable scriptable2;
            if ((scriptable2 = scriptable.getParentScope()) == null) {
                object = ScriptableObject.getProperty(scriptable, DEFAULT_NS_TAG);
                if (object != Scriptable.NOT_FOUND) break;
                return null;
            }
            object = scriptable.get(DEFAULT_NS_TAG, scriptable);
            if (object != Scriptable.NOT_FOUND) break;
            scriptable = scriptable2;
        }
        return object;
    }

    public static Object getTopLevelProp(Scriptable scriptable, String string) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        return ScriptableObject.getProperty(scriptable, string);
    }

    static Function getExistingCtor(Context context, Scriptable scriptable, String string) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object instanceof Function) {
            return (Function)object;
        }
        if (object == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeErrorById("msg.ctor.not.found", string);
        }
        throw Context.reportRuntimeErrorById("msg.not.ctor", string);
    }

    public static long indexFromString(String string) {
        int n = 10;
        int n2 = string.length();
        if (n2 > 0) {
            int n3 = 0;
            boolean bl = false;
            int n4 = string.charAt(0);
            if (n4 == 45 && n2 > 1) {
                n4 = string.charAt(1);
                if (n4 == 48) {
                    return -1L;
                }
                n3 = 1;
                bl = true;
            }
            if (0 <= (n4 -= 48) && n4 <= 9 && n2 <= (bl ? 11 : 10)) {
                int n5 = -n4;
                int n6 = 0;
                ++n3;
                if (n5 != 0) {
                    while (n3 != n2 && 0 <= (n4 = string.charAt(n3) - 48) && n4 <= 9) {
                        n6 = n5;
                        n5 = 10 * n5 - n4;
                        ++n3;
                    }
                }
                if (n3 == n2 && (n6 > -214748364 || n6 == -214748364 && n4 <= (bl ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(bl ? n5 : -n5);
                }
            }
        }
        return -1L;
    }

    public static long testUint32String(String string) {
        int n = 10;
        int n2 = string.length();
        if (1 <= n2 && n2 <= 10) {
            int n3 = string.charAt(0);
            if ((n3 -= 48) == 0) {
                return n2 == 1 ? 0L : -1L;
            }
            if (1 <= n3 && n3 <= 9) {
                long l = n3;
                for (int i = 1; i != n2; ++i) {
                    n3 = string.charAt(i) - 48;
                    if (0 > n3 || n3 > 9) {
                        return -1L;
                    }
                    l = 10L * l + (long)n3;
                }
                if (l >>> 32 == 0L) {
                    return l;
                }
            }
        }
        return -1L;
    }

    static Object getIndexObject(String string) {
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        return string;
    }

    static Object getIndexObject(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        return ScriptRuntime.toString(d);
    }

    public static StringIdOrIndex toStringIdOrIndex(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d < 0.0) {
                return new StringIdOrIndex(ScriptRuntime.toString(object));
            }
            int n = (int)d;
            if ((double)n == d) {
                return new StringIdOrIndex(n);
            }
            return new StringIdOrIndex(ScriptRuntime.toString(object));
        }
        String string = object instanceof String ? (String)object : ScriptRuntime.toString(object);
        long l = ScriptRuntime.indexFromString(string);
        if (l >= 0L && l <= Integer.MAX_VALUE) {
            return new StringIdOrIndex((int)l);
        }
        return new StringIdOrIndex(string);
    }

    @Deprecated
    public static Object getObjectElem(Object object, Object object2, Context context) {
        return ScriptRuntime.getObjectElem(object, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectElem(Object object, Object object2, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, object2);
        }
        return ScriptRuntime.getObjectElem(scriptable2, object2, context);
    }

    public static Object getObjectElem(Scriptable scriptable, Object object, Context context) {
        Object object2;
        if (scriptable instanceof XMLObject) {
            object2 = ((XMLObject)scriptable).get(context, object);
        } else if (ScriptRuntime.isSymbol(object)) {
            object2 = ScriptableObject.getProperty(scriptable, (Symbol)object);
        } else {
            StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object);
            if (stringIdOrIndex.stringId == null) {
                int n = stringIdOrIndex.index;
                object2 = ScriptableObject.getProperty(scriptable, n);
            } else {
                object2 = ScriptableObject.getProperty(scriptable, stringIdOrIndex.stringId);
            }
        }
        if (object2 == Scriptable.NOT_FOUND) {
            object2 = Undefined.instance;
        }
        return object2;
    }

    @Deprecated
    public static Object getObjectProp(Object object, String string, Context context) {
        return ScriptRuntime.getObjectProp(object, string, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectProp(Object object, String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        return ScriptRuntime.getObjectProp(scriptable2, string, context);
    }

    public static Object getObjectProp(Scriptable scriptable, String string, Context context) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            if (context.hasFeature(11)) {
                Context.reportWarning(ScriptRuntime.getMessageById("msg.ref.undefined.prop", string));
            }
            object = Undefined.instance;
        }
        return object;
    }

    @Deprecated
    public static Object getObjectPropNoWarn(Object object, String string, Context context) {
        return ScriptRuntime.getObjectPropNoWarn(object, string, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectPropNoWarn(Object object, String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        Object object2 = ScriptableObject.getProperty(scriptable2, string);
        if (object2 == Scriptable.NOT_FOUND) {
            return Undefined.instance;
        }
        return object2;
    }

    @Deprecated
    public static Object getObjectIndex(Object object, double d, Context context) {
        return ScriptRuntime.getObjectIndex(object, d, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object getObjectIndex(Object object, double d, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, ScriptRuntime.toString(d));
        }
        int n = (int)d;
        if ((double)n == d && n >= 0) {
            return ScriptRuntime.getObjectIndex(scriptable2, n, context);
        }
        String string = ScriptRuntime.toString(d);
        return ScriptRuntime.getObjectProp(scriptable2, string, context);
    }

    public static Object getObjectIndex(Scriptable scriptable, int n, Context context) {
        Object object = ScriptableObject.getProperty(scriptable, n);
        if (object == Scriptable.NOT_FOUND) {
            object = Undefined.instance;
        }
        return object;
    }

    @Deprecated
    public static Object setObjectElem(Object object, Object object2, Object object3, Context context) {
        return ScriptRuntime.setObjectElem(object, object2, object3, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object setObjectElem(Object object, Object object2, Object object3, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefWriteError(object, object2, object3);
        }
        return ScriptRuntime.setObjectElem(scriptable2, object2, object3, context);
    }

    public static Object setObjectElem(Scriptable scriptable, Object object, Object object2, Context context) {
        if (scriptable instanceof XMLObject) {
            ((XMLObject)scriptable).put(context, object, object2);
        } else if (ScriptRuntime.isSymbol(object)) {
            ScriptableObject.putProperty(scriptable, (Symbol)object, object2);
        } else {
            StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object);
            if (stringIdOrIndex.stringId == null) {
                ScriptableObject.putProperty(scriptable, stringIdOrIndex.index, object2);
            } else {
                ScriptableObject.putProperty(scriptable, stringIdOrIndex.stringId, object2);
            }
        }
        return object2;
    }

    @Deprecated
    public static Object setObjectProp(Object object, String string, Object object2, Context context) {
        return ScriptRuntime.setObjectProp(object, string, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object setObjectProp(Object object, String string, Object object2, Context context, Scriptable scriptable) {
        if (!(object instanceof Scriptable) && context.isStrictMode() && context.getLanguageVersion() >= 180) {
            throw ScriptRuntime.undefWriteError(object, string, object2);
        }
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefWriteError(object, string, object2);
        }
        return ScriptRuntime.setObjectProp(scriptable2, string, object2, context);
    }

    public static Object setObjectProp(Scriptable scriptable, String string, Object object, Context context) {
        ScriptableObject.putProperty(scriptable, string, object);
        return object;
    }

    @Deprecated
    public static Object setObjectIndex(Object object, double d, Object object2, Context context) {
        return ScriptRuntime.setObjectIndex(object, d, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object setObjectIndex(Object object, double d, Object object2, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefWriteError(object, String.valueOf(d), object2);
        }
        int n = (int)d;
        if ((double)n == d && n >= 0) {
            return ScriptRuntime.setObjectIndex(scriptable2, n, object2, context);
        }
        String string = ScriptRuntime.toString(d);
        return ScriptRuntime.setObjectProp(scriptable2, string, object2, context);
    }

    public static Object setObjectIndex(Scriptable scriptable, int n, Object object, Context context) {
        ScriptableObject.putProperty(scriptable, n, object);
        return object;
    }

    public static boolean deleteObjectElem(Scriptable scriptable, Object object, Context context) {
        if (ScriptRuntime.isSymbol(object)) {
            SymbolScriptable symbolScriptable = ScriptableObject.ensureSymbolScriptable(scriptable);
            Symbol symbol = (Symbol)object;
            symbolScriptable.delete(symbol);
            return !symbolScriptable.has(symbol, scriptable);
        }
        StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object);
        if (stringIdOrIndex.stringId == null) {
            scriptable.delete(stringIdOrIndex.index);
            return !scriptable.has(stringIdOrIndex.index, scriptable);
        }
        scriptable.delete(stringIdOrIndex.stringId);
        return !scriptable.has(stringIdOrIndex.stringId, scriptable);
    }

    public static boolean hasObjectElem(Scriptable scriptable, Object object, Context context) {
        boolean bl;
        if (ScriptRuntime.isSymbol(object)) {
            bl = ScriptableObject.hasProperty(scriptable, (Symbol)object);
        } else {
            StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object);
            bl = stringIdOrIndex.stringId == null ? ScriptableObject.hasProperty(scriptable, stringIdOrIndex.index) : ScriptableObject.hasProperty(scriptable, stringIdOrIndex.stringId);
        }
        return bl;
    }

    public static Object refGet(Ref ref, Context context) {
        return ref.get(context);
    }

    @Deprecated
    public static Object refSet(Ref ref, Object object, Context context) {
        return ScriptRuntime.refSet(ref, object, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Object refSet(Ref ref, Object object, Context context, Scriptable scriptable) {
        return ref.set(context, scriptable, object);
    }

    public static Object refDel(Ref ref, Context context) {
        return ScriptRuntime.wrapBoolean(ref.delete(context));
    }

    static boolean isSpecialProperty(String string) {
        return string.equals("__proto__") || string.equals("__parent__");
    }

    @Deprecated
    public static Ref specialRef(Object object, String string, Context context) {
        return ScriptRuntime.specialRef(object, string, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Ref specialRef(Object object, String string, Context context, Scriptable scriptable) {
        return SpecialRef.createSpecial(context, scriptable, object, string);
    }

    @Deprecated
    public static Object delete(Object object, Object object2, Context context) {
        return ScriptRuntime.delete(object, object2, context, false);
    }

    @Deprecated
    public static Object delete(Object object, Object object2, Context context, boolean bl) {
        return ScriptRuntime.delete(object, object2, context, ScriptRuntime.getTopCallScope(context), bl);
    }

    public static Object delete(Object object, Object object2, Context context, Scriptable scriptable, boolean bl) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            if (bl) {
                return Boolean.TRUE;
            }
            throw ScriptRuntime.undefDeleteError(object, object2);
        }
        boolean bl2 = ScriptRuntime.deleteObjectElem(scriptable2, object2, context);
        return ScriptRuntime.wrapBoolean(bl2);
    }

    public static Object name(Context context, Scriptable scriptable, String string) {
        Scriptable scriptable2 = scriptable.getParentScope();
        if (scriptable2 == null) {
            Object object = ScriptRuntime.topScopeName(context, scriptable, string);
            if (object == Scriptable.NOT_FOUND) {
                throw ScriptRuntime.notFoundError(scriptable, string);
            }
            return object;
        }
        return ScriptRuntime.nameOrFunction(context, scriptable, scriptable2, string, false);
    }

    private static Object nameOrFunction(Context context, Scriptable scriptable, Scriptable scriptable2, String string, boolean bl) {
        Object object;
        Scriptable scriptable3;
        block17: {
            scriptable3 = scriptable;
            XMLObject xMLObject = null;
            do {
                if (scriptable instanceof NativeWith) {
                    Scriptable scriptable4 = scriptable.getPrototype();
                    if (scriptable4 instanceof XMLObject) {
                        XMLObject xMLObject2 = (XMLObject)scriptable4;
                        if (xMLObject2.has(string, (Scriptable)xMLObject2)) {
                            scriptable3 = xMLObject2;
                            object = xMLObject2.get(string, (Scriptable)xMLObject2);
                            break block17;
                        }
                        if (xMLObject == null) {
                            xMLObject = xMLObject2;
                        }
                    } else {
                        object = ScriptableObject.getProperty(scriptable4, string);
                        if (object != Scriptable.NOT_FOUND) {
                            scriptable3 = scriptable4;
                            break block17;
                        }
                    }
                } else if (scriptable instanceof NativeCall) {
                    object = scriptable.get(string, scriptable);
                    if (object != Scriptable.NOT_FOUND) {
                        if (bl) {
                            scriptable3 = ScriptableObject.getTopLevelScope(scriptable2);
                        }
                        break block17;
                    }
                } else {
                    object = ScriptableObject.getProperty(scriptable, string);
                    if (object != Scriptable.NOT_FOUND) {
                        scriptable3 = scriptable;
                        break block17;
                    }
                }
                scriptable = scriptable2;
            } while ((scriptable2 = scriptable2.getParentScope()) != null);
            object = ScriptRuntime.topScopeName(context, scriptable, string);
            if (object == Scriptable.NOT_FOUND) {
                if (xMLObject == null || bl) {
                    throw ScriptRuntime.notFoundError(scriptable, string);
                }
                object = xMLObject.get(string, (Scriptable)xMLObject);
            }
            scriptable3 = scriptable;
        }
        if (bl) {
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(object, string);
            }
            ScriptRuntime.storeScriptable(context, scriptable3);
        }
        return object;
    }

    private static Object topScopeName(Context context, Scriptable scriptable, String string) {
        if (context.useDynamicScope) {
            scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
        }
        return ScriptableObject.getProperty(scriptable, string);
    }

    public static Scriptable bind(Context context, Scriptable scriptable, String string) {
        XMLObject xMLObject;
        block11: {
            xMLObject = null;
            Scriptable scriptable2 = scriptable.getParentScope();
            if (scriptable2 != null) {
                while (scriptable instanceof NativeWith) {
                    Scriptable scriptable3 = scriptable.getPrototype();
                    if (scriptable3 instanceof XMLObject) {
                        XMLObject xMLObject2 = (XMLObject)scriptable3;
                        if (xMLObject2.has(context, string)) {
                            return xMLObject2;
                        }
                        if (xMLObject == null) {
                            xMLObject = xMLObject2;
                        }
                    } else if (ScriptableObject.hasProperty(scriptable3, string)) {
                        return scriptable3;
                    }
                    scriptable = scriptable2;
                    if ((scriptable2 = scriptable2.getParentScope()) != null) continue;
                    break block11;
                }
                do {
                    if (ScriptableObject.hasProperty(scriptable, string)) {
                        return scriptable;
                    }
                    scriptable = scriptable2;
                } while ((scriptable2 = scriptable2.getParentScope()) != null);
            }
        }
        if (context.useDynamicScope) {
            scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
        }
        if (ScriptableObject.hasProperty(scriptable, string)) {
            return scriptable;
        }
        return xMLObject;
    }

    public static Object setName(Scriptable scriptable, Object object, Context context, Scriptable scriptable2, String string) {
        if (scriptable != null) {
            ScriptableObject.putProperty(scriptable, string, object);
        } else {
            if (context.hasFeature(11) || context.hasFeature(8)) {
                Context.reportWarning(ScriptRuntime.getMessageById("msg.assn.create.strict", string));
            }
            scriptable = ScriptableObject.getTopLevelScope(scriptable2);
            if (context.useDynamicScope) {
                scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
            }
            scriptable.put(string, scriptable, object);
        }
        return object;
    }

    public static Object strictSetName(Scriptable scriptable, Object object, Context context, Scriptable scriptable2, String string) {
        if (scriptable != null) {
            ScriptableObject.putProperty(scriptable, string, object);
            return object;
        }
        String string2 = "Assignment to undefined \"" + string + "\" in strict mode";
        throw ScriptRuntime.constructError("ReferenceError", string2);
    }

    public static Object setConst(Scriptable scriptable, Object object, Context context, String string) {
        if (scriptable instanceof XMLObject) {
            scriptable.put(string, scriptable, object);
        } else {
            ScriptableObject.putConstProperty(scriptable, string, object);
        }
        return object;
    }

    public static Scriptable toIterator(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl) {
        if (ScriptableObject.hasProperty(scriptable2, "__iterator__")) {
            Object object = ScriptableObject.getProperty(scriptable2, "__iterator__");
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.invalid.iterator", new Object[0]);
            }
            Callable callable = (Callable)object;
            Object[] objectArray = new Object[]{bl ? Boolean.TRUE : Boolean.FALSE};
            object = callable.call(context, scriptable, scriptable2, objectArray);
            if (!(object instanceof Scriptable)) {
                throw ScriptRuntime.typeErrorById("msg.iterator.primitive", new Object[0]);
            }
            return (Scriptable)object;
        }
        return null;
    }

    @Deprecated
    public static Object enumInit(Object object, Context context, boolean bl) {
        return ScriptRuntime.enumInit(object, context, bl ? 1 : 0);
    }

    @Deprecated
    public static Object enumInit(Object object, Context context, int n) {
        return ScriptRuntime.enumInit(object, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object enumInit(Object object, Context context, Scriptable scriptable, int n) {
        IdEnumeration idEnumeration = new IdEnumeration();
        idEnumeration.obj = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (n == 6) {
            idEnumeration.enumType = n;
            idEnumeration.iterator = null;
            return ScriptRuntime.enumInitInOrder(context, idEnumeration);
        }
        if (idEnumeration.obj == null) {
            return idEnumeration;
        }
        idEnumeration.enumType = n;
        idEnumeration.iterator = null;
        if (n != 3 && n != 4 && n != 5) {
            idEnumeration.iterator = ScriptRuntime.toIterator(context, idEnumeration.obj.getParentScope(), idEnumeration.obj, n == 0);
        }
        if (idEnumeration.iterator == null) {
            ScriptRuntime.enumChangeObject(idEnumeration);
        }
        return idEnumeration;
    }

    private static Object enumInitInOrder(Context context, IdEnumeration idEnumeration) {
        Object[] objectArray;
        if (!(idEnumeration.obj instanceof SymbolScriptable) || !ScriptableObject.hasProperty(idEnumeration.obj, SymbolKey.ITERATOR)) {
            throw ScriptRuntime.typeErrorById("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
        }
        Object object = ScriptableObject.getProperty(idEnumeration.obj, SymbolKey.ITERATOR);
        if (!(object instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
        }
        Callable callable = (Callable)object;
        Scriptable scriptable = idEnumeration.obj.getParentScope();
        Object object2 = callable.call(context, scriptable, idEnumeration.obj, objectArray = new Object[0]);
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeErrorById("msg.not.iterable", ScriptRuntime.toString(idEnumeration.obj));
        }
        idEnumeration.iterator = (Scriptable)object2;
        return idEnumeration;
    }

    public static void setEnumNumbers(Object object, boolean bl) {
        ((IdEnumeration)object).enumNumbers = bl;
    }

    @Deprecated
    public static Boolean enumNext(Object object) {
        return ScriptRuntime.enumNext(object, Context.getContext());
    }

    public static Boolean enumNext(Object object, Context context) {
        block10: {
            int n;
            IdEnumeration idEnumeration = (IdEnumeration)object;
            if (idEnumeration.iterator != null) {
                if (idEnumeration.enumType == 6) {
                    return ScriptRuntime.enumNextInOrder(idEnumeration, context);
                }
                Object object2 = ScriptableObject.getProperty(idEnumeration.iterator, "next");
                if (!(object2 instanceof Callable)) {
                    return Boolean.FALSE;
                }
                Callable callable = (Callable)object2;
                try {
                    idEnumeration.currentId = callable.call(context, idEnumeration.iterator.getParentScope(), idEnumeration.iterator, emptyArgs);
                    return Boolean.TRUE;
                }
                catch (JavaScriptException javaScriptException) {
                    if (javaScriptException.getValue() instanceof NativeIterator.StopIteration) {
                        return Boolean.FALSE;
                    }
                    throw javaScriptException;
                }
            }
            while (true) {
                if (idEnumeration.obj == null) {
                    return Boolean.FALSE;
                }
                if (idEnumeration.index == idEnumeration.ids.length) {
                    idEnumeration.obj = idEnumeration.obj.getPrototype();
                    ScriptRuntime.enumChangeObject(idEnumeration);
                    continue;
                }
                Object object3 = idEnumeration.ids[idEnumeration.index++];
                if (idEnumeration.used != null && idEnumeration.used.has(object3) || object3 instanceof Symbol) continue;
                if (object3 instanceof String) {
                    String string = (String)object3;
                    if (!idEnumeration.obj.has(string, idEnumeration.obj)) continue;
                    idEnumeration.currentId = string;
                    break block10;
                }
                n = ((Number)object3).intValue();
                if (idEnumeration.obj.has(n, idEnumeration.obj)) break;
            }
            idEnumeration.currentId = idEnumeration.enumNumbers ? Integer.valueOf(n) : String.valueOf(n);
        }
        return Boolean.TRUE;
    }

    private static Boolean enumNextInOrder(IdEnumeration idEnumeration, Context context) {
        Object object;
        Object object2 = ScriptableObject.getProperty(idEnumeration.iterator, "next");
        if (!(object2 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(idEnumeration.iterator, "next");
        }
        Callable callable = (Callable)object2;
        Scriptable scriptable = idEnumeration.iterator.getParentScope();
        Scriptable scriptable2 = ScriptRuntime.toObject(context, scriptable, object = callable.call(context, scriptable, idEnumeration.iterator, emptyArgs));
        Object object3 = ScriptableObject.getProperty(scriptable2, "done");
        if (object3 != Scriptable.NOT_FOUND && ScriptRuntime.toBoolean(object3)) {
            return Boolean.FALSE;
        }
        idEnumeration.currentId = ScriptableObject.getProperty(scriptable2, "value");
        return Boolean.TRUE;
    }

    public static Object enumId(Object object, Context context) {
        IdEnumeration idEnumeration = (IdEnumeration)object;
        if (idEnumeration.iterator != null) {
            return idEnumeration.currentId;
        }
        switch (idEnumeration.enumType) {
            case 0: 
            case 3: {
                return idEnumeration.currentId;
            }
            case 1: 
            case 4: {
                return ScriptRuntime.enumValue(object, context);
            }
            case 2: 
            case 5: {
                Object[] objectArray = new Object[]{idEnumeration.currentId, ScriptRuntime.enumValue(object, context)};
                return context.newArray(ScriptableObject.getTopLevelScope(idEnumeration.obj), objectArray);
            }
        }
        throw Kit.codeBug();
    }

    public static Object enumValue(Object object, Context context) {
        Object object2;
        IdEnumeration idEnumeration = (IdEnumeration)object;
        if (ScriptRuntime.isSymbol(idEnumeration.currentId)) {
            SymbolScriptable symbolScriptable = ScriptableObject.ensureSymbolScriptable(idEnumeration.obj);
            object2 = symbolScriptable.get((Symbol)idEnumeration.currentId, idEnumeration.obj);
        } else {
            StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(idEnumeration.currentId);
            object2 = stringIdOrIndex.stringId == null ? idEnumeration.obj.get(stringIdOrIndex.index, idEnumeration.obj) : idEnumeration.obj.get(stringIdOrIndex.stringId, idEnumeration.obj);
        }
        return object2;
    }

    private static void enumChangeObject(IdEnumeration idEnumeration) {
        Object[] objectArray = null;
        while (idEnumeration.obj != null && (objectArray = idEnumeration.obj.getIds()).length == 0) {
            idEnumeration.obj = idEnumeration.obj.getPrototype();
        }
        if (idEnumeration.obj != null && idEnumeration.ids != null) {
            Object[] objectArray2 = idEnumeration.ids;
            int n = objectArray2.length;
            if (idEnumeration.used == null) {
                idEnumeration.used = new ObjToIntMap(n);
            }
            for (int i = 0; i != n; ++i) {
                idEnumeration.used.intern(objectArray2[i]);
            }
        }
        idEnumeration.ids = objectArray;
        idEnumeration.index = 0;
    }

    public static boolean loadFromIterable(Context context, Scriptable scriptable, Object object, BiConsumer<Object, Object> biConsumer) {
        if (object == null || Undefined.isUndefined(object)) {
            return false;
        }
        Object object2 = ScriptRuntime.callIterator(object, context, scriptable);
        if (Undefined.isUndefined(object2)) {
            return false;
        }
        try (IteratorLikeIterable iteratorLikeIterable = new IteratorLikeIterable(context, scriptable, object2);){
            for (Object e : iteratorLikeIterable) {
                Object object3;
                Scriptable scriptable2 = ScriptableObject.ensureScriptable(e);
                if (scriptable2 instanceof Symbol) {
                    throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(scriptable2));
                }
                Object object4 = scriptable2.get(0, scriptable2);
                if (object4 == Scriptable.NOT_FOUND) {
                    object4 = Undefined.instance;
                }
                if ((object3 = scriptable2.get(1, scriptable2)) == Scriptable.NOT_FOUND) {
                    object3 = Undefined.instance;
                }
                biConsumer.accept(object4, object3);
            }
        }
        return true;
    }

    public static Callable getNameFunctionAndThis(String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = scriptable.getParentScope();
        if (scriptable2 == null) {
            Object object = ScriptRuntime.topScopeName(context, scriptable, string);
            if (!(object instanceof Callable)) {
                if (object == Scriptable.NOT_FOUND) {
                    throw ScriptRuntime.notFoundError(scriptable, string);
                }
                throw ScriptRuntime.notFunctionError(object, string);
            }
            ScriptRuntime.storeScriptable(context, scriptable);
            return (Callable)object;
        }
        return (Callable)ScriptRuntime.nameOrFunction(context, scriptable, scriptable2, string, true);
    }

    @Deprecated
    public static Callable getElemFunctionAndThis(Object object, Object object2, Context context) {
        return ScriptRuntime.getElemFunctionAndThis(object, object2, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Callable getElemFunctionAndThis(Object object, Object object2, Context context, Scriptable scriptable) {
        Object object3;
        Scriptable scriptable2;
        if (ScriptRuntime.isSymbol(object2)) {
            scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
            if (scriptable2 == null) {
                throw ScriptRuntime.undefCallError(object, String.valueOf(object2));
            }
            object3 = ScriptableObject.getProperty(scriptable2, (Symbol)object2);
        } else {
            StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object2);
            if (stringIdOrIndex.stringId != null) {
                return ScriptRuntime.getPropFunctionAndThis(object, stringIdOrIndex.stringId, context, scriptable);
            }
            scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
            if (scriptable2 == null) {
                throw ScriptRuntime.undefCallError(object, String.valueOf(object2));
            }
            object3 = ScriptableObject.getProperty(scriptable2, stringIdOrIndex.index);
        }
        if (!(object3 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object3, object2);
        }
        ScriptRuntime.storeScriptable(context, scriptable2);
        return (Callable)object3;
    }

    @Deprecated
    public static Callable getPropFunctionAndThis(Object object, String string, Context context) {
        return ScriptRuntime.getPropFunctionAndThis(object, string, context, ScriptRuntime.getTopCallScope(context));
    }

    public static Callable getPropFunctionAndThis(Object object, String string, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        return ScriptRuntime.getPropFunctionAndThisHelper(object, string, context, scriptable2);
    }

    private static Callable getPropFunctionAndThisHelper(Object object, String string, Context context, Scriptable scriptable) {
        Object object2;
        if (scriptable == null) {
            throw ScriptRuntime.undefCallError(object, string);
        }
        Object object3 = ScriptableObject.getProperty(scriptable, string);
        if (!(object3 instanceof Callable) && (object2 = ScriptableObject.getProperty(scriptable, "__noSuchMethod__")) instanceof Callable) {
            object3 = new NoSuchMethodShim((Callable)object2, string);
        }
        if (!(object3 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(scriptable, object3, string);
        }
        ScriptRuntime.storeScriptable(context, scriptable);
        return (Callable)object3;
    }

    public static Callable getValueFunctionAndThis(Object object, Context context) {
        if (!(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Callable callable = (Callable)object;
        Scriptable scriptable = null;
        if (callable instanceof Scriptable) {
            scriptable = ((Scriptable)((Object)callable)).getParentScope();
        }
        if (scriptable == null) {
            if (context.topCallScope == null) {
                throw new IllegalStateException();
            }
            scriptable = context.topCallScope;
        }
        if (scriptable.getParentScope() != null && !(scriptable instanceof NativeWith) && scriptable instanceof NativeCall) {
            scriptable = ScriptableObject.getTopLevelScope(scriptable);
        }
        ScriptRuntime.storeScriptable(context, scriptable);
        return callable;
    }

    public static Object callIterator(Object object, Context context, Scriptable scriptable) {
        Callable callable = ScriptRuntime.getElemFunctionAndThis(object, SymbolKey.ITERATOR, context, scriptable);
        Scriptable scriptable2 = ScriptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable2, emptyArgs);
    }

    public static boolean isIteratorDone(Context context, Object object) {
        if (!(object instanceof Scriptable)) {
            return false;
        }
        Object object2 = ScriptRuntime.getObjectProp((Scriptable)object, "done", context);
        return ScriptRuntime.toBoolean(object2);
    }

    public static Ref callRef(Callable callable, Scriptable scriptable, Object[] objectArray, Context context) {
        if (callable instanceof RefCallable) {
            RefCallable refCallable = (RefCallable)callable;
            Ref ref = refCallable.refCall(context, scriptable, objectArray);
            if (ref == null) {
                throw new IllegalStateException(refCallable.getClass().getName() + ".refCall() returned null");
            }
            return ref;
        }
        String string = ScriptRuntime.getMessageById("msg.no.ref.from.function", ScriptRuntime.toString(callable));
        throw ScriptRuntime.constructError("ReferenceError", string);
    }

    public static Scriptable newObject(Object object, Context context, Scriptable scriptable, Object[] objectArray) {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Function function = (Function)object;
        return function.construct(context, scriptable, objectArray);
    }

    public static Object callSpecial(Context context, Callable callable, Scriptable scriptable, Object[] objectArray, Scriptable scriptable2, Scriptable scriptable3, int n, String string, int n2) {
        if (n == 1) {
            if (scriptable.getParentScope() == null && NativeGlobal.isEvalFunction(callable)) {
                return ScriptRuntime.evalSpecial(context, scriptable2, scriptable3, objectArray, string, n2);
            }
        } else if (n == 2) {
            if (NativeWith.isWithFunction(callable)) {
                throw Context.reportRuntimeErrorById("msg.only.from.new", "With");
            }
        } else {
            throw Kit.codeBug();
        }
        return callable.call(context, scriptable2, scriptable, objectArray);
    }

    public static Object newSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, int n) {
        if (n == 1) {
            if (NativeGlobal.isEvalFunction(object)) {
                throw ScriptRuntime.typeErrorById("msg.not.ctor", "eval");
            }
        } else if (n == 2) {
            if (NativeWith.isWithFunction(object)) {
                return NativeWith.newWithSpecial(context, scriptable, objectArray);
            }
        } else {
            throw Kit.codeBug();
        }
        return ScriptRuntime.newObject(object, context, scriptable, objectArray);
    }

    public static Object applyOrCall(boolean bl, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object[] objectArray2;
        int n = objectArray.length;
        Callable callable = ScriptRuntime.getCallable(scriptable2);
        Scriptable scriptable3 = null;
        if (n != 0) {
            if (context.hasFeature(15)) {
                scriptable3 = ScriptRuntime.toObjectOrNull(context, objectArray[0], scriptable);
            } else {
                Scriptable scriptable4 = scriptable3 = objectArray[0] == Undefined.instance ? Undefined.SCRIPTABLE_UNDEFINED : ScriptRuntime.toObjectOrNull(context, objectArray[0], scriptable);
            }
        }
        if (scriptable3 == null && context.hasFeature(15)) {
            scriptable3 = ScriptRuntime.getTopCallScope(context);
        }
        if (bl) {
            objectArray2 = n <= 1 ? emptyArgs : ScriptRuntime.getApplyArguments(context, objectArray[1]);
        } else if (n <= 1) {
            objectArray2 = emptyArgs;
        } else {
            objectArray2 = new Object[n - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, n - 1);
        }
        return callable.call(context, scriptable, scriptable3, objectArray2);
    }

    private static boolean isArrayLike(Scriptable scriptable) {
        return scriptable != null && (scriptable instanceof NativeArray || scriptable instanceof Arguments || ScriptableObject.hasProperty(scriptable, "length"));
    }

    static Object[] getApplyArguments(Context context, Object object) {
        if (object == null || Undefined.isUndefined(object)) {
            return emptyArgs;
        }
        if (object instanceof Scriptable && ScriptRuntime.isArrayLike((Scriptable)object)) {
            return context.getElements((Scriptable)object);
        }
        if (object instanceof ScriptableObject) {
            return emptyArgs;
        }
        throw ScriptRuntime.typeErrorById("msg.arg.isnt.array", new Object[0]);
    }

    static Callable getCallable(Scriptable scriptable) {
        Callable callable;
        if (scriptable instanceof Callable) {
            callable = (Callable)((Object)scriptable);
        } else {
            if (scriptable == null) {
                throw ScriptRuntime.notFunctionError(null, null);
            }
            Object object = scriptable.getDefaultValue(FunctionClass);
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(object, scriptable);
            }
            callable = (Callable)object;
        }
        return callable;
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n) {
        Object object2;
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object3 = objectArray[0];
        if (!(object3 instanceof CharSequence)) {
            if (context.hasFeature(11) || context.hasFeature(9)) {
                throw Context.reportRuntimeErrorById("msg.eval.nonstring.strict", new Object[0]);
            }
            String string2 = ScriptRuntime.getMessageById("msg.eval.nonstring", new Object[0]);
            Context.reportWarning(string2);
            return object3;
        }
        if (string == null) {
            object2 = new int[1];
            string = Context.getSourcePositionFromStack(object2);
            if (string != null) {
                n = object2[0];
            } else {
                string = "";
            }
        }
        object2 = ScriptRuntime.makeUrlForGeneratedScript(true, string, n);
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator == null) {
            throw new JavaScriptException("Interpreter not present", string, n);
        }
        Script script = context.compileString(object3.toString(), evaluator, errorReporter, (String)object2, 1, null);
        evaluator.setEvalScriptFlag(script);
        Callable callable = (Callable)((Object)script);
        return callable.call(context, scriptable, (Scriptable)object, emptyArgs);
    }

    public static String typeof(Object object) {
        if (object == null) {
            return "object";
        }
        if (object == Undefined.instance) {
            return "undefined";
        }
        if (object instanceof Delegator) {
            return ScriptRuntime.typeof(((Delegator)object).getDelegee());
        }
        if (object instanceof ScriptableObject) {
            return ((ScriptableObject)object).getTypeOf();
        }
        if (object instanceof Scriptable) {
            return object instanceof Callable ? "function" : "object";
        }
        if (object instanceof CharSequence) {
            return "string";
        }
        if (object instanceof BigInteger) {
            return "bigint";
        }
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Boolean) {
            return "boolean";
        }
        if (ScriptRuntime.isSymbol(object)) {
            return "symbol";
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", object);
    }

    public static String typeofName(Scriptable scriptable, String string) {
        Context context = Context.getContext();
        Scriptable scriptable2 = ScriptRuntime.bind(context, scriptable, string);
        if (scriptable2 == null) {
            return "undefined";
        }
        return ScriptRuntime.typeof(ScriptRuntime.getObjectProp(scriptable2, string, context));
    }

    public static boolean isObject(Object object) {
        if (object == null) {
            return false;
        }
        if (Undefined.isUndefined(object)) {
            return false;
        }
        if (object instanceof ScriptableObject) {
            String string = ((ScriptableObject)object).getTypeOf();
            return "object".equals(string) || "function".equals(string);
        }
        if (object instanceof Scriptable) {
            return !(object instanceof Callable);
        }
        return false;
    }

    public static Object add(Object object, Object object2, Context context) {
        Object object3;
        if (object instanceof BigInteger && object2 instanceof BigInteger) {
            return ((BigInteger)object).add((BigInteger)object2);
        }
        if (object instanceof Number && object2 instanceof BigInteger || object instanceof BigInteger && object2 instanceof Number) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ScriptRuntime.wrapNumber(((Number)object).doubleValue() + ((Number)object2).doubleValue());
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            return new ConsString((CharSequence)object, (CharSequence)object2);
        }
        if (object instanceof XMLObject && (object3 = ((XMLObject)object).addValues(context, true, object2)) != Scriptable.NOT_FOUND) {
            return object3;
        }
        if (object2 instanceof XMLObject && (object3 = ((XMLObject)object2).addValues(context, false, object)) != Scriptable.NOT_FOUND) {
            return object3;
        }
        if (object instanceof Symbol || object2 instanceof Symbol) {
            throw ScriptRuntime.typeErrorById("msg.not.a.number", new Object[0]);
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(null);
        }
        if (!(object instanceof CharSequence) && !(object2 instanceof CharSequence)) {
            Number number;
            object3 = object instanceof Number ? (Number)((Number)object) : (Number)ScriptRuntime.toNumeric(object);
            Number number2 = number = object2 instanceof Number ? (Number)((Number)object2) : (Number)ScriptRuntime.toNumeric(object2);
            if (object3 instanceof BigInteger && number instanceof BigInteger) {
                return ((BigInteger)object3).add((BigInteger)number);
            }
            if (object3 instanceof BigInteger || number instanceof BigInteger) {
                throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
            }
            return ((Number)object3).doubleValue() + number.doubleValue();
        }
        return new ConsString(ScriptRuntime.toCharSequence(object), ScriptRuntime.toCharSequence(object2));
    }

    @Deprecated
    public static CharSequence add(CharSequence charSequence, Object object) {
        return new ConsString(charSequence, ScriptRuntime.toCharSequence(object));
    }

    @Deprecated
    public static CharSequence add(Object object, CharSequence charSequence) {
        return new ConsString(ScriptRuntime.toCharSequence(object), charSequence);
    }

    public static Number subtract(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).subtract((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        return number.doubleValue() - number2.doubleValue();
    }

    public static Number multiply(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).multiply((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        return number.doubleValue() * number2.doubleValue();
    }

    public static Number divide(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            if (number2.equals(BigInteger.ZERO)) {
                throw ScriptRuntime.rangeErrorById("msg.division.zero", new Object[0]);
            }
            return ((BigInteger)number).divide((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        return number.doubleValue() / number2.doubleValue();
    }

    public static Number remainder(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            if (number2.equals(BigInteger.ZERO)) {
                throw ScriptRuntime.rangeErrorById("msg.division.zero", new Object[0]);
            }
            return ((BigInteger)number).remainder((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        return number.doubleValue() % number2.doubleValue();
    }

    public static Number exponentiate(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            if (((BigInteger)number2).signum() == -1) {
                throw ScriptRuntime.rangeErrorById("msg.bigint.negative.exponent", new Object[0]);
            }
            try {
                int n = ((BigInteger)number2).intValueExact();
                return ((BigInteger)number).pow(n);
            }
            catch (ArithmeticException arithmeticException) {
                throw ScriptRuntime.rangeErrorById("msg.bigint.out.of.range.arithmetic", new Object[0]);
            }
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        return Math.pow(number.doubleValue(), number2.doubleValue());
    }

    public static Number bitwiseAND(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).and((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        int n = ScriptRuntime.toInt32(number.doubleValue()) & ScriptRuntime.toInt32(number2.doubleValue());
        return (double)n;
    }

    public static Number bitwiseOR(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).or((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        int n = ScriptRuntime.toInt32(number.doubleValue()) | ScriptRuntime.toInt32(number2.doubleValue());
        return (double)n;
    }

    public static Number bitwiseXOR(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ((BigInteger)number).xor((BigInteger)number2);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        int n = ScriptRuntime.toInt32(number.doubleValue()) ^ ScriptRuntime.toInt32(number2.doubleValue());
        return (double)n;
    }

    public static Number leftShift(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            try {
                int n = ((BigInteger)number2).intValueExact();
                return ((BigInteger)number).shiftLeft(n);
            }
            catch (ArithmeticException arithmeticException) {
                throw ScriptRuntime.rangeErrorById("msg.bigint.out.of.range.arithmetic", new Object[0]);
            }
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        int n = ScriptRuntime.toInt32(number.doubleValue()) << ScriptRuntime.toInt32(number2.doubleValue());
        return (double)n;
    }

    public static Number signedRightShift(Number number, Number number2) {
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            try {
                int n = ((BigInteger)number2).intValueExact();
                return ((BigInteger)number).shiftRight(n);
            }
            catch (ArithmeticException arithmeticException) {
                throw ScriptRuntime.rangeErrorById("msg.bigint.out.of.range.arithmetic", new Object[0]);
            }
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            throw ScriptRuntime.typeErrorById("msg.cant.convert.to.number", "BigInt");
        }
        int n = ScriptRuntime.toInt32(number.doubleValue()) >> ScriptRuntime.toInt32(number2.doubleValue());
        return (double)n;
    }

    public static Number bitwiseNOT(Number number) {
        if (number instanceof BigInteger) {
            return ((BigInteger)number).not();
        }
        int n = ~ScriptRuntime.toInt32(number.doubleValue());
        return (double)n;
    }

    @Deprecated
    public static Object nameIncrDecr(Scriptable scriptable, String string, int n) {
        return ScriptRuntime.nameIncrDecr(scriptable, string, Context.getContext(), n);
    }

    public static Object nameIncrDecr(Scriptable scriptable, String string, Context context, int n) {
        Object object;
        Scriptable scriptable2;
        block4: {
            do {
                if (context.useDynamicScope && scriptable.getParentScope() == null) {
                    scriptable = ScriptRuntime.checkDynamicScope(context.topCallScope, scriptable);
                }
                scriptable2 = scriptable;
                while (!(scriptable2 instanceof NativeWith) || !(scriptable2.getPrototype() instanceof XMLObject)) {
                    object = scriptable2.get(string, scriptable);
                    if (object == Scriptable.NOT_FOUND) {
                        if ((scriptable2 = scriptable2.getPrototype()) != null) continue;
                    }
                    break block4;
                }
            } while ((scriptable = scriptable.getParentScope()) != null);
            throw ScriptRuntime.notFoundError(null, string);
        }
        return ScriptRuntime.doScriptableIncrDecr(scriptable2, string, scriptable, object, n);
    }

    @Deprecated
    public static Object propIncrDecr(Object object, String string, Context context, int n) {
        return ScriptRuntime.propIncrDecr(object, string, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object propIncrDecr(Object object, String string, Context context, Scriptable scriptable, int n) {
        Object object2;
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.undefReadError(object, string);
        }
        Scriptable scriptable3 = scriptable2;
        while ((object2 = scriptable3.get(string, scriptable2)) == Scriptable.NOT_FOUND) {
            if ((scriptable3 = scriptable3.getPrototype()) != null) continue;
            scriptable2.put(string, scriptable2, (Object)NaNobj);
            return NaNobj;
        }
        return ScriptRuntime.doScriptableIncrDecr(scriptable3, string, scriptable2, object2, n);
    }

    private static Object doScriptableIncrDecr(Scriptable scriptable, String string, Scriptable scriptable2, Object object, int n) {
        boolean bl = (n & 2) != 0;
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)ScriptRuntime.toNumeric(object);
        Number number2 = number instanceof BigInteger ? ((n & 1) == 0 ? ((BigInteger)number).add(BigInteger.ONE) : ((BigInteger)number).subtract(BigInteger.ONE)) : ((n & 1) == 0 ? Double.valueOf(number.doubleValue() + 1.0) : Double.valueOf(number.doubleValue() - 1.0));
        scriptable.put(string, scriptable2, (Object)number2);
        if (bl) {
            return number;
        }
        return number2;
    }

    @Deprecated
    public static Object elemIncrDecr(Object object, Object object2, Context context, int n) {
        return ScriptRuntime.elemIncrDecr(object, object2, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object elemIncrDecr(Object object, Object object2, Context context, Scriptable scriptable, int n) {
        Object object3 = ScriptRuntime.getObjectElem(object, object2, context, scriptable);
        boolean bl = (n & 2) != 0;
        Number number = object3 instanceof Number ? (Number)((Number)object3) : (Number)ScriptRuntime.toNumeric(object3);
        Number number2 = number instanceof BigInteger ? ((n & 1) == 0 ? ((BigInteger)number).add(BigInteger.ONE) : ((BigInteger)number).subtract(BigInteger.ONE)) : ((n & 1) == 0 ? Double.valueOf(number.doubleValue() + 1.0) : Double.valueOf(number.doubleValue() - 1.0));
        ScriptRuntime.setObjectElem(object, object2, number2, context, scriptable);
        if (bl) {
            return number;
        }
        return number2;
    }

    @Deprecated
    public static Object refIncrDecr(Ref ref, Context context, int n) {
        return ScriptRuntime.refIncrDecr(ref, context, ScriptRuntime.getTopCallScope(context), n);
    }

    public static Object refIncrDecr(Ref ref, Context context, Scriptable scriptable, int n) {
        Object object = ref.get(context);
        boolean bl = (n & 2) != 0;
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)ScriptRuntime.toNumeric(object);
        Number number2 = number instanceof BigInteger ? ((n & 1) == 0 ? ((BigInteger)number).add(BigInteger.ONE) : ((BigInteger)number).subtract(BigInteger.ONE)) : ((n & 1) == 0 ? Double.valueOf(number.doubleValue() + 1.0) : Double.valueOf(number.doubleValue() - 1.0));
        ref.set(context, scriptable, number2);
        if (bl) {
            return number;
        }
        return number2;
    }

    public static Number negate(Number number) {
        if (number instanceof BigInteger) {
            return ((BigInteger)number).negate();
        }
        return -number.doubleValue();
    }

    public static Object toPrimitive(Object object) {
        return ScriptRuntime.toPrimitive(object, null);
    }

    public static Object toPrimitive(Object object, Class<?> clazz) {
        if (!(object instanceof Scriptable)) {
            return object;
        }
        Scriptable scriptable = (Scriptable)object;
        Object object2 = scriptable.getDefaultValue(clazz);
        if (object2 instanceof Scriptable && !ScriptRuntime.isSymbol(object2)) {
            throw ScriptRuntime.typeErrorById("msg.bad.default.value", new Object[0]);
        }
        return object2;
    }

    public static boolean eq(Object object, Object object2) {
        if (object == null || Undefined.isUndefined(object)) {
            Object object3;
            if (object2 == null || Undefined.isUndefined(object2)) {
                return true;
            }
            if (object2 instanceof ScriptableObject && (object3 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                return (Boolean)object3;
            }
            return false;
        }
        if (object instanceof BigInteger) {
            return ScriptRuntime.eqBigInt((BigInteger)object, object2);
        }
        if (object instanceof Number) {
            return ScriptRuntime.eqNumber(((Number)object).doubleValue(), object2);
        }
        if (object == object2) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ScriptRuntime.eqString((CharSequence)object, object2);
        }
        if (object instanceof Boolean) {
            Object object4;
            boolean bl = (Boolean)object;
            if (object2 instanceof Boolean) {
                return bl == (Boolean)object2;
            }
            if (object2 instanceof ScriptableObject && (object4 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                return (Boolean)object4;
            }
            return ScriptRuntime.eqNumber(bl ? 1.0 : 0.0, object2);
        }
        if (object instanceof Scriptable) {
            if (object instanceof Delegator) {
                object = ((Delegator)object).getDelegee();
                if (object2 instanceof Delegator) {
                    return ScriptRuntime.eq(object, ((Delegator)object2).getDelegee());
                }
                if (object == object2) {
                    return true;
                }
            }
            if (object2 instanceof Delegator && ((Delegator)object2).getDelegee() == object) {
                return true;
            }
            if (object2 instanceof Scriptable) {
                Object object5;
                if (object instanceof ScriptableObject && (object5 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object5;
                }
                if (object2 instanceof ScriptableObject && (object5 = ((ScriptableObject)object2).equivalentValues(object)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object5;
                }
                if (object instanceof Wrapper && object2 instanceof Wrapper) {
                    Object object6;
                    object5 = ((Wrapper)object).unwrap();
                    return object5 == (object6 = ((Wrapper)object2).unwrap()) || ScriptRuntime.isPrimitive(object5) && ScriptRuntime.isPrimitive(object6) && ScriptRuntime.eq(object5, object6);
                }
                return false;
            }
            if (object2 instanceof Boolean) {
                Object object7;
                if (object instanceof ScriptableObject && (object7 = ((ScriptableObject)object).equivalentValues(object2)) != Scriptable.NOT_FOUND) {
                    return (Boolean)object7;
                }
                double d = (Boolean)object2 != false ? 1.0 : 0.0;
                return ScriptRuntime.eqNumber(d, object);
            }
            if (object2 instanceof BigInteger) {
                return ScriptRuntime.eqBigInt((BigInteger)object2, object);
            }
            if (object2 instanceof Number) {
                return ScriptRuntime.eqNumber(((Number)object2).doubleValue(), object);
            }
            if (object2 instanceof CharSequence) {
                return ScriptRuntime.eqString((CharSequence)object2, object);
            }
            return false;
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return object == object2;
    }

    public static boolean same(Object object, Object object2) {
        if (!ScriptRuntime.typeof(object).equals(ScriptRuntime.typeof(object2))) {
            return false;
        }
        if (object instanceof Number) {
            if (ScriptRuntime.isNaN(object) && ScriptRuntime.isNaN(object2)) {
                return true;
            }
            return object.equals(object2);
        }
        return ScriptRuntime.eq(object, object2);
    }

    public static boolean sameZero(Object object, Object object2) {
        if (!ScriptRuntime.typeof(object).equals(ScriptRuntime.typeof(object2))) {
            return false;
        }
        if (object instanceof BigInteger) {
            return object.equals(object2);
        }
        if (object instanceof Number) {
            if (ScriptRuntime.isNaN(object) && ScriptRuntime.isNaN(object2)) {
                return true;
            }
            double d = ((Number)object).doubleValue();
            if (object2 instanceof Number) {
                double d2 = ((Number)object2).doubleValue();
                if (d == negativeZero && d2 == 0.0 || d == 0.0 && d2 == negativeZero) {
                    return true;
                }
            }
            return ScriptRuntime.eqNumber(d, object2);
        }
        return ScriptRuntime.eq(object, object2);
    }

    public static boolean isNaN(Object object) {
        if (object instanceof Double) {
            return ((Double)object).isNaN();
        }
        if (object instanceof Float) {
            return ((Float)object).isNaN();
        }
        return false;
    }

    public static boolean isPrimitive(Object object) {
        return object == null || Undefined.isUndefined(object) || object instanceof Number || object instanceof String || object instanceof Boolean;
    }

    static boolean eqNumber(double d, Object object) {
        while (true) {
            Number number;
            Object object2;
            if (object == null || Undefined.isUndefined(object)) {
                return false;
            }
            if (object instanceof BigInteger) {
                return ScriptRuntime.eqBigInt((BigInteger)object, d);
            }
            if (object instanceof Number) {
                return d == ((Number)object).doubleValue();
            }
            if (object instanceof CharSequence) {
                return d == ScriptRuntime.toNumber(object);
            }
            if (object instanceof Boolean) {
                return d == ((Boolean)object != false ? 1.0 : 0.0);
            }
            if (ScriptRuntime.isSymbol(object)) {
                return false;
            }
            if (!(object instanceof Scriptable)) break;
            if (object instanceof ScriptableObject && (object2 = ((ScriptableObject)object).equivalentValues(number = ScriptRuntime.wrapNumber(d))) != Scriptable.NOT_FOUND) {
                return (Boolean)object2;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return false;
    }

    static boolean eqBigInt(BigInteger bigInteger, Object object) {
        while (true) {
            Object object2;
            if (object == null || Undefined.isUndefined(object)) {
                return false;
            }
            if (object instanceof BigInteger) {
                return bigInteger.equals(object);
            }
            if (object instanceof Number) {
                return ScriptRuntime.eqBigInt(bigInteger, ((Number)object).doubleValue());
            }
            if (object instanceof CharSequence) {
                try {
                    object2 = ScriptRuntime.toBigInt(object);
                }
                catch (EcmaError ecmaError) {
                    return false;
                }
                return bigInteger.equals(object2);
            }
            if (object instanceof Boolean) {
                object2 = (Boolean)object != false ? BigInteger.ONE : BigInteger.ZERO;
                return bigInteger.equals(object2);
            }
            if (ScriptRuntime.isSymbol(object)) {
                return false;
            }
            if (!(object instanceof Scriptable)) break;
            if (object instanceof ScriptableObject && (object2 = ((ScriptableObject)object).equivalentValues(bigInteger)) != Scriptable.NOT_FOUND) {
                return (Boolean)object2;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return false;
    }

    private static boolean eqBigInt(BigInteger bigInteger, double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return false;
        }
        double d2 = Math.ceil(d);
        if (d2 != d) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        BigDecimal bigDecimal2 = new BigDecimal(d2, MathContext.UNLIMITED);
        return bigDecimal.compareTo(bigDecimal2) == 0;
    }

    private static boolean eqString(CharSequence charSequence, Object object) {
        while (true) {
            Object object2;
            if (object == null || Undefined.isUndefined(object)) {
                return false;
            }
            if (object instanceof CharSequence) {
                object2 = (CharSequence)object;
                return charSequence.length() == object2.length() && charSequence.toString().equals(object2.toString());
            }
            if (object instanceof BigInteger) {
                try {
                    object2 = ScriptRuntime.toBigInt(charSequence);
                }
                catch (EcmaError ecmaError) {
                    return false;
                }
                return ((BigInteger)object2).equals(object);
            }
            if (object instanceof Number) {
                return ScriptRuntime.toNumber(charSequence.toString()) == ((Number)object).doubleValue();
            }
            if (object instanceof Boolean) {
                return ScriptRuntime.toNumber(charSequence.toString()) == ((Boolean)object != false ? 1.0 : 0.0);
            }
            if (ScriptRuntime.isSymbol(object)) {
                return false;
            }
            if (!(object instanceof Scriptable)) break;
            if (object instanceof ScriptableObject && (object2 = ((ScriptableObject)object).equivalentValues(charSequence.toString())) != Scriptable.NOT_FOUND) {
                return (Boolean)object2;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        ScriptRuntime.warnAboutNonJSObject(object);
        return false;
    }

    public static boolean shallowEq(Object object, Object object2) {
        if (object == object2) {
            if (!(object instanceof Number)) {
                return true;
            }
            double d = ((Number)object).doubleValue();
            return !Double.isNaN(d);
        }
        if (object == null || object == Undefined.instance || object == Undefined.SCRIPTABLE_UNDEFINED) {
            return object == Undefined.instance && object2 == Undefined.SCRIPTABLE_UNDEFINED || object == Undefined.SCRIPTABLE_UNDEFINED && object2 == Undefined.instance;
        }
        if (object instanceof BigInteger) {
            if (object2 instanceof BigInteger) {
                return object.equals(object2);
            }
        } else if (object instanceof Number && !(object instanceof BigInteger)) {
            if (object2 instanceof Number && !(object2 instanceof BigInteger)) {
                return ((Number)object).doubleValue() == ((Number)object2).doubleValue();
            }
        } else if (object instanceof CharSequence) {
            if (object2 instanceof CharSequence) {
                return object.toString().equals(object2.toString());
            }
        } else if (object instanceof Boolean) {
            if (object2 instanceof Boolean) {
                return object.equals(object2);
            }
        } else if (object instanceof Scriptable) {
            if (object instanceof Wrapper && object2 instanceof Wrapper) {
                return ((Wrapper)object).unwrap() == ((Wrapper)object2).unwrap();
            }
            if (object instanceof Delegator) {
                object = ((Delegator)object).getDelegee();
                if (object2 instanceof Delegator) {
                    return ScriptRuntime.shallowEq(object, ((Delegator)object2).getDelegee());
                }
                if (object == object2) {
                    return true;
                }
            }
            if (object2 instanceof Delegator && ((Delegator)object2).getDelegee() == object) {
                return true;
            }
        } else {
            ScriptRuntime.warnAboutNonJSObject(object);
            return object == object2;
        }
        return false;
    }

    public static boolean instanceOf(Object object, Object object2, Context context) {
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeErrorById("msg.instanceof.not.object", new Object[0]);
        }
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)object2).hasInstance((Scriptable)object);
    }

    public static boolean jsDelegatesTo(Scriptable scriptable, Scriptable scriptable2) {
        for (Scriptable scriptable3 = scriptable.getPrototype(); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
            if (!scriptable3.equals(scriptable2)) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Object object, Object object2, Context context) {
        if (!(object2 instanceof Scriptable)) {
            throw ScriptRuntime.typeErrorById("msg.in.not.object", new Object[0]);
        }
        return ScriptRuntime.hasObjectElem((Scriptable)object2, object, context);
    }

    public static boolean compare(Object object, Object object2, int n) {
        assert (n == 17 || n == 15 || n == 16 || n == 14);
        if (object instanceof Number && object2 instanceof Number) {
            return ScriptRuntime.compare((Number)object, (Number)object2, n);
        }
        if (object instanceof Symbol || object2 instanceof Symbol) {
            throw ScriptRuntime.typeErrorById("msg.compare.symbol", new Object[0]);
        }
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            return ScriptRuntime.compareTo(object.toString(), object2.toString(), n);
        }
        return ScriptRuntime.compare(ScriptRuntime.toNumeric(object), ScriptRuntime.toNumeric(object2), n);
    }

    public static boolean compare(Number number, Number number2, int n) {
        assert (n == 17 || n == 15 || n == 16 || n == 14);
        if (number instanceof BigInteger && number2 instanceof BigInteger) {
            return ScriptRuntime.compareTo((BigInteger)number, (BigInteger)number2, n);
        }
        if (number instanceof BigInteger || number2 instanceof BigInteger) {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            if (number instanceof BigInteger) {
                bigDecimal2 = new BigDecimal((BigInteger)number);
            } else {
                double d = number.doubleValue();
                if (Double.isNaN(d)) {
                    return false;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    return n == 17 || n == 16;
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    return n == 15 || n == 14;
                }
                bigDecimal2 = new BigDecimal(d, MathContext.UNLIMITED);
            }
            if (number2 instanceof BigInteger) {
                bigDecimal = new BigDecimal((BigInteger)number2);
            } else {
                double d = number2.doubleValue();
                if (Double.isNaN(d)) {
                    return false;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    return n == 15 || n == 14;
                }
                if (d == Double.NEGATIVE_INFINITY) {
                    return n == 17 || n == 16;
                }
                bigDecimal = new BigDecimal(d, MathContext.UNLIMITED);
            }
            return ScriptRuntime.compareTo(bigDecimal2, bigDecimal, n);
        }
        return ScriptRuntime.compareTo(number.doubleValue(), number2.doubleValue(), n);
    }

    private static <T> boolean compareTo(Comparable<T> comparable, T t, int n) {
        switch (n) {
            case 17: {
                return comparable.compareTo(t) >= 0;
            }
            case 15: {
                return comparable.compareTo(t) <= 0;
            }
            case 16: {
                return comparable.compareTo(t) > 0;
            }
            case 14: {
                return comparable.compareTo(t) < 0;
            }
        }
        throw Kit.codeBug();
    }

    private static <T> boolean compareTo(double d, double d2, int n) {
        switch (n) {
            case 17: {
                return d >= d2;
            }
            case 15: {
                return d <= d2;
            }
            case 16: {
                return d > d2;
            }
            case 14: {
                return d < d2;
            }
        }
        throw Kit.codeBug();
    }

    public static ScriptableObject getGlobal(Context context) {
        String string = "org.mozilla.javascript.tools.shell.Global";
        Class<?> clazz = Kit.classOrNull("org.mozilla.javascript.tools.shell.Global");
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{ContextClass};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{context};
                return (ScriptableObject)constructor.newInstance(objectArray);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ImporterTopLevel(context);
    }

    public static boolean hasTopCall(Context context) {
        return context.topCallScope != null;
    }

    public static Scriptable getTopCallScope(Context context) {
        Scriptable scriptable = context.topCallScope;
        if (scriptable == null) {
            throw new IllegalStateException();
        }
        return scriptable;
    }

    @Deprecated
    public static Object doTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return ScriptRuntime.doTopCall(callable, context, scriptable, scriptable2, objectArray, context.isTopLevelStrict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doTopCall(Callable callable, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, boolean bl) {
        Object object;
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        if (context.topCallScope != null) {
            throw new IllegalStateException();
        }
        context.topCallScope = ScriptableObject.getTopLevelScope(scriptable);
        context.useDynamicScope = context.hasFeature(7);
        boolean bl2 = context.isTopLevelStrict;
        context.isTopLevelStrict = bl;
        ContextFactory contextFactory = context.getFactory();
        try {
            object = contextFactory.doTopCall(callable, context, scriptable, scriptable2, objectArray);
        }
        finally {
            context.topCallScope = null;
            context.cachedXMLLib = null;
            context.isTopLevelStrict = bl2;
            if (context.currentActivationCall != null) {
                throw new IllegalStateException();
            }
        }
        return object;
    }

    static Scriptable checkDynamicScope(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable == scriptable2) {
            return scriptable;
        }
        Scriptable scriptable3 = scriptable;
        do {
            if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
            return scriptable;
        } while (scriptable3 != null);
        return scriptable2;
    }

    public static void addInstructionCount(Context context, int n) {
        context.instructionCount += n;
        if (context.instructionCount > context.instructionThreshold) {
            context.observeInstructionCount(context.instructionCount);
            context.instructionCount = 0;
        }
    }

    public static void initScript(NativeFunction nativeFunction, Scriptable scriptable, Context context, Scriptable scriptable2, boolean bl) {
        if (context.topCallScope == null) {
            throw new IllegalStateException();
        }
        int n = nativeFunction.getParamAndVarCount();
        if (n != 0) {
            Scriptable scriptable3 = scriptable2;
            while (scriptable3 instanceof NativeWith) {
                scriptable3 = scriptable3.getParentScope();
            }
            int n2 = n;
            while (n2-- != 0) {
                String string = nativeFunction.getParamOrVarName(n2);
                boolean bl2 = nativeFunction.getParamOrVarConst(n2);
                if (!ScriptableObject.hasProperty(scriptable2, string)) {
                    if (bl2) {
                        ScriptableObject.defineConstProperty(scriptable3, string);
                        continue;
                    }
                    if (!bl) {
                        if (nativeFunction instanceof InterpretedFunction && !((InterpretedFunction)nativeFunction).hasFunctionNamed(string)) continue;
                        ScriptableObject.defineProperty(scriptable3, string, Undefined.instance, 4);
                        continue;
                    }
                    scriptable3.put(string, scriptable3, Undefined.instance);
                    continue;
                }
                ScriptableObject.redefineProperty(scriptable2, string, bl2);
            }
        }
    }

    @Deprecated
    public static Scriptable createFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray) {
        return ScriptRuntime.createFunctionActivation(nativeFunction, scriptable, objectArray, false);
    }

    public static Scriptable createFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray, boolean bl) {
        return new NativeCall(nativeFunction, scriptable, objectArray, false, bl);
    }

    public static Scriptable createArrowFunctionActivation(NativeFunction nativeFunction, Scriptable scriptable, Object[] objectArray, boolean bl) {
        return new NativeCall(nativeFunction, scriptable, objectArray, true, bl);
    }

    public static void enterActivationFunction(Context context, Scriptable scriptable) {
        if (context.topCallScope == null) {
            throw new IllegalStateException();
        }
        NativeCall nativeCall = (NativeCall)scriptable;
        nativeCall.parentActivationCall = context.currentActivationCall;
        context.currentActivationCall = nativeCall;
        nativeCall.defineAttributesForArguments();
    }

    public static void exitActivationFunction(Context context) {
        NativeCall nativeCall = context.currentActivationCall;
        context.currentActivationCall = nativeCall.parentActivationCall;
        nativeCall.parentActivationCall = null;
    }

    static NativeCall findFunctionActivation(Context context, Function function) {
        NativeCall nativeCall = context.currentActivationCall;
        while (nativeCall != null) {
            if (nativeCall.function == function) {
                return nativeCall;
            }
            nativeCall = nativeCall.parentActivationCall;
        }
        return null;
    }

    public static Scriptable newCatchScope(Throwable throwable, Scriptable scriptable, String string, Context context, Scriptable scriptable2) {
        Serializable serializable;
        Object object;
        boolean bl;
        if (throwable instanceof JavaScriptException) {
            bl = false;
            object = ((JavaScriptException)throwable).getValue();
        } else {
            bl = true;
            if (scriptable != null) {
                serializable = (NativeObject)scriptable;
                object = ((ScriptableObject)serializable).getAssociatedValue(throwable);
                if (object == null) {
                    Kit.codeBug();
                }
            } else {
                Object object2;
                int n;
                Object[] objectArray;
                Scriptable scriptable3;
                String string2;
                TopLevel.NativeErrors nativeErrors;
                Object object3;
                Throwable throwable2 = null;
                if (throwable instanceof EcmaError) {
                    object3 = (EcmaError)throwable;
                    serializable = object3;
                    nativeErrors = TopLevel.NativeErrors.valueOf(((EcmaError)object3).getName());
                    string2 = ((EcmaError)object3).getErrorMessage();
                } else if (throwable instanceof WrappedException) {
                    object3 = (WrappedException)throwable;
                    serializable = object3;
                    throwable2 = ((WrappedException)object3).getWrappedException();
                    if (!ScriptRuntime.isVisible(context, throwable2)) {
                        nativeErrors = TopLevel.NativeErrors.InternalError;
                        string2 = throwable2.getMessage();
                    } else {
                        nativeErrors = TopLevel.NativeErrors.JavaException;
                        string2 = throwable2.getClass().getName() + ": " + throwable2.getMessage();
                    }
                } else if (throwable instanceof EvaluatorException) {
                    object3 = (EvaluatorException)throwable;
                    serializable = object3;
                    nativeErrors = TopLevel.NativeErrors.InternalError;
                    string2 = ((RhinoException)object3).getMessage();
                } else if (context.hasFeature(13)) {
                    serializable = new WrappedException(throwable);
                    nativeErrors = TopLevel.NativeErrors.JavaException;
                    string2 = throwable.toString();
                } else {
                    throw Kit.codeBug();
                }
                object3 = ((RhinoException)serializable).sourceName();
                if (object3 == null) {
                    object3 = "";
                }
                if ((scriptable3 = ScriptRuntime.newNativeError(context, scriptable2, nativeErrors, objectArray = (n = ((RhinoException)serializable).lineNumber()) > 0 ? new Object[]{string2, object3, n} : new Object[]{string2, object3})) instanceof NativeError) {
                    ((NativeError)scriptable3).setStackProvider((RhinoException)serializable);
                }
                if (throwable2 != null && ScriptRuntime.isVisible(context, throwable2)) {
                    object2 = context.getWrapFactory().wrap(context, scriptable2, throwable2, null);
                    ScriptableObject.defineProperty(scriptable3, "javaException", object2, 7);
                }
                if (ScriptRuntime.isVisible(context, serializable)) {
                    object2 = context.getWrapFactory().wrap(context, scriptable2, serializable, null);
                    ScriptableObject.defineProperty(scriptable3, "rhinoException", object2, 7);
                }
                object = scriptable3;
            }
        }
        serializable = new NativeObject();
        if (string != null) {
            ((ScriptableObject)serializable).defineProperty(string, object, 4);
        }
        if (ScriptRuntime.isVisible(context, throwable)) {
            ((ScriptableObject)serializable).defineProperty("__exception__", Context.javaToJS(throwable, scriptable2), 6);
        }
        if (bl) {
            ((ScriptableObject)serializable).associateValue(throwable, object);
        }
        return serializable;
    }

    public static Scriptable wrapException(Throwable throwable, Scriptable scriptable, Context context) {
        Object object;
        int n;
        String string;
        String string2;
        RhinoException rhinoException;
        Object object2;
        Throwable throwable2 = null;
        if (throwable instanceof EcmaError) {
            object2 = (EcmaError)throwable;
            rhinoException = object2;
            string2 = ((EcmaError)object2).getName();
            string = ((EcmaError)object2).getErrorMessage();
        } else if (throwable instanceof WrappedException) {
            object2 = (WrappedException)throwable;
            rhinoException = object2;
            throwable2 = ((WrappedException)object2).getWrappedException();
            string2 = "JavaException";
            string = throwable2.getClass().getName() + ": " + throwable2.getMessage();
        } else if (throwable instanceof EvaluatorException) {
            object2 = (EvaluatorException)throwable;
            rhinoException = object2;
            string2 = "InternalError";
            string = ((RhinoException)object2).getMessage();
        } else if (context.hasFeature(13)) {
            rhinoException = new WrappedException(throwable);
            string2 = "JavaException";
            string = throwable.toString();
        } else {
            throw Kit.codeBug();
        }
        object2 = rhinoException.sourceName();
        if (object2 == null) {
            object2 = "";
        }
        Object[] objectArray = (n = rhinoException.lineNumber()) > 0 ? new Object[]{string, object2, n} : new Object[]{string, object2};
        Scriptable scriptable2 = context.newObject(scriptable, string2, objectArray);
        ScriptableObject.putProperty(scriptable2, "name", (Object)string2);
        if (scriptable2 instanceof NativeError) {
            ((NativeError)scriptable2).setStackProvider(rhinoException);
        }
        if (throwable2 != null && ScriptRuntime.isVisible(context, throwable2)) {
            object = context.getWrapFactory().wrap(context, scriptable, throwable2, null);
            ScriptableObject.defineProperty(scriptable2, "javaException", object, 7);
        }
        if (ScriptRuntime.isVisible(context, rhinoException)) {
            object = context.getWrapFactory().wrap(context, scriptable, rhinoException, null);
            ScriptableObject.defineProperty(scriptable2, "rhinoException", object, 7);
        }
        return scriptable2;
    }

    private static boolean isVisible(Context context, Object object) {
        ClassShutter classShutter = context.getClassShutter();
        return classShutter == null || classShutter.visibleToScripts(object.getClass().getName());
    }

    public static Scriptable enterWith(Object object, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = ScriptRuntime.toObjectOrNull(context, object, scriptable);
        if (scriptable2 == null) {
            throw ScriptRuntime.typeErrorById("msg.undef.with", ScriptRuntime.toString(object));
        }
        if (scriptable2 instanceof XMLObject) {
            XMLObject xMLObject = (XMLObject)scriptable2;
            return xMLObject.enterWith(scriptable);
        }
        return new NativeWith(scriptable, scriptable2);
    }

    public static Scriptable leaveWith(Scriptable scriptable) {
        NativeWith nativeWith = (NativeWith)scriptable;
        return nativeWith.getParentScope();
    }

    public static Scriptable enterDotQuery(Object object, Scriptable scriptable) {
        if (!(object instanceof XMLObject)) {
            throw ScriptRuntime.notXmlError(object);
        }
        XMLObject xMLObject = (XMLObject)object;
        return xMLObject.enterDotQuery(scriptable);
    }

    public static Object updateDotQuery(boolean bl, Scriptable scriptable) {
        NativeWith nativeWith = (NativeWith)scriptable;
        return nativeWith.updateDotQuery(bl);
    }

    public static Scriptable leaveDotQuery(Scriptable scriptable) {
        NativeWith nativeWith = (NativeWith)scriptable;
        return nativeWith.getParentScope();
    }

    @Deprecated
    public static void setFunctionProtoAndParent(BaseFunction baseFunction, Scriptable scriptable) {
        ScriptRuntime.setFunctionProtoAndParent(baseFunction, Context.getCurrentContext(), scriptable, false);
    }

    public static void setFunctionProtoAndParent(BaseFunction baseFunction, Context context, Scriptable scriptable) {
        ScriptRuntime.setFunctionProtoAndParent(baseFunction, context, scriptable, false);
    }

    @Deprecated
    public static void setFunctionProtoAndParent(BaseFunction baseFunction, Scriptable scriptable, boolean bl) {
        ScriptRuntime.setFunctionProtoAndParent(baseFunction, Context.getCurrentContext(), scriptable, bl);
    }

    public static void setFunctionProtoAndParent(BaseFunction baseFunction, Context context, Scriptable scriptable, boolean bl) {
        baseFunction.setParentScope(scriptable);
        if (bl) {
            baseFunction.setPrototype(ScriptableObject.getGeneratorFunctionPrototype(scriptable));
        } else {
            baseFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        }
        if (context != null && context.getLanguageVersion() >= 200) {
            baseFunction.setStandardPropertyAttributes(3);
        }
    }

    public static void setObjectProtoAndParent(ScriptableObject scriptableObject, Scriptable scriptable) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        scriptableObject.setParentScope(scriptable);
        Scriptable scriptable2 = ScriptableObject.getClassPrototype(scriptable, scriptableObject.getClassName());
        scriptableObject.setPrototype(scriptable2);
    }

    public static void setBuiltinProtoAndParent(ScriptableObject scriptableObject, Scriptable scriptable, TopLevel.Builtins builtins) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        scriptableObject.setParentScope(scriptable);
        scriptableObject.setPrototype(TopLevel.getBuiltinPrototype(scriptable, builtins));
    }

    public static void initFunction(Context context, Scriptable scriptable, NativeFunction nativeFunction, int n, boolean bl) {
        if (n == 1) {
            String string = nativeFunction.getFunctionName();
            if (string != null && string.length() != 0) {
                if (!bl) {
                    ScriptableObject.defineProperty(scriptable, string, nativeFunction, 4);
                } else {
                    scriptable.put(string, scriptable, (Object)nativeFunction);
                }
            }
        } else if (n == 3) {
            String string = nativeFunction.getFunctionName();
            if (string != null && string.length() != 0) {
                while (scriptable instanceof NativeWith) {
                    scriptable = scriptable.getParentScope();
                }
                scriptable.put(string, scriptable, (Object)nativeFunction);
            }
        } else {
            throw Kit.codeBug();
        }
    }

    public static Scriptable newArrayLiteral(Object[] objectArray, int[] nArray, Context context, Scriptable scriptable) {
        int n;
        int n2 = 2;
        int n3 = objectArray.length;
        int n4 = 0;
        if (nArray != null) {
            n4 = nArray.length;
        }
        if ((n = n3 + n4) > 1 && n4 * 2 < n) {
            Object[] objectArray2;
            if (n4 == 0) {
                objectArray2 = objectArray;
            } else {
                objectArray2 = new Object[n];
                int n5 = 0;
                int n6 = 0;
                for (int i = 0; i != n; ++i) {
                    if (n5 != n4 && nArray[n5] == i) {
                        objectArray2[i] = Scriptable.NOT_FOUND;
                        ++n5;
                        continue;
                    }
                    objectArray2[i] = objectArray[n6];
                    ++n6;
                }
            }
            return context.newArray(scriptable, objectArray2);
        }
        Scriptable scriptable2 = context.newArray(scriptable, n);
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i != n; ++i) {
            if (n7 != n4 && nArray[n7] == i) {
                ++n7;
                continue;
            }
            scriptable2.put(i, scriptable2, objectArray[n8]);
            ++n8;
        }
        return scriptable2;
    }

    @Deprecated
    public static Scriptable newObjectLiteral(Object[] objectArray, Object[] objectArray2, Context context, Scriptable scriptable) {
        return ScriptRuntime.newObjectLiteral(objectArray, objectArray2, null, context, scriptable);
    }

    public static Scriptable newObjectLiteral(Object[] objectArray, Object[] objectArray2, int[] nArray, Context context, Scriptable scriptable) {
        Scriptable scriptable2 = context.newObject(scriptable);
        int n = objectArray == null ? 0 : objectArray.length;
        for (int i = 0; i != n; ++i) {
            Object object;
            Object object2;
            Object object3 = objectArray[i];
            int n2 = nArray == null ? 0 : nArray[i];
            Object object4 = objectArray2[i];
            if (n2 == 0) {
                if (object3 instanceof Symbol) {
                    object2 = (Symbol)object3;
                    object = (SymbolScriptable)((Object)scriptable2);
                    object.put((Symbol)object2, scriptable2, object4);
                    continue;
                }
                if (object3 instanceof Integer) {
                    int n3 = (Integer)object3;
                    scriptable2.put(n3, scriptable2, object4);
                    continue;
                }
                object2 = ScriptRuntime.toString(object3);
                if (ScriptRuntime.isSpecialProperty((String)object2)) {
                    object = ScriptRuntime.specialRef(scriptable2, (String)object2, context, scriptable);
                    ((Ref)object).set(context, scriptable, object4);
                    continue;
                }
                scriptable2.put((String)object2, scriptable2, object4);
                continue;
            }
            object2 = (ScriptableObject)scriptable2;
            object = (Callable)object4;
            boolean bl = n2 == 1;
            String string = object3 instanceof String ? (String)object3 : null;
            int n4 = string == null ? (Integer)object3 : 0;
            ((ScriptableObject)object2).setGetterOrSetter(string, n4, (Callable)object, bl);
        }
        return scriptable2;
    }

    public static boolean isArrayObject(Object object) {
        return object instanceof NativeArray || object instanceof Arguments;
    }

    public static Object[] getArrayElements(Scriptable scriptable) {
        Context context = Context.getContext();
        long l = NativeArray.getLengthProperty(context, scriptable);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int n = (int)l;
        if (n == 0) {
            return emptyArgs;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Object object = ScriptableObject.getProperty(scriptable, i);
            objectArray[i] = object == Scriptable.NOT_FOUND ? Undefined.instance : object;
        }
        return objectArray;
    }

    static void checkDeprecated(Context context, String string) {
        int n = context.getLanguageVersion();
        if (n >= 140 || n == 0) {
            String string2 = ScriptRuntime.getMessageById("msg.deprec.ctor", string);
            if (n == 0) {
                Context.reportWarning(string2);
            } else {
                throw Context.reportRuntimeError(string2);
            }
        }
    }

    @Deprecated
    public static String getMessage0(String string) {
        return ScriptRuntime.getMessage(string, null);
    }

    @Deprecated
    public static String getMessage1(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    @Deprecated
    public static String getMessage2(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    @Deprecated
    public static String getMessage3(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    @Deprecated
    public static String getMessage4(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return ScriptRuntime.getMessage(string, objectArray);
    }

    @Deprecated
    public static String getMessage(String string, Object[] objectArray) {
        return messageProvider.getMessage(string, objectArray);
    }

    public static String getMessageById(String string, Object ... objectArray) {
        return messageProvider.getMessage(string, objectArray);
    }

    public static EcmaError constructError(String string, String string2) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        return ScriptRuntime.constructError(string, string2, string3, nArray[0], null, 0);
    }

    public static EcmaError constructError(String string, String string2, int n) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        if (nArray[0] != 0) {
            nArray[0] = nArray[0] + n;
        }
        return ScriptRuntime.constructError(string, string2, string3, nArray[0], null, 0);
    }

    public static EcmaError constructError(String string, String string2, String string3, int n, String string4, int n2) {
        return new EcmaError(string, string2, string3, n, string4, n2);
    }

    public static EcmaError rangeError(String string) {
        return ScriptRuntime.constructError("RangeError", string);
    }

    public static EcmaError rangeErrorById(String string, Object ... objectArray) {
        String string2 = ScriptRuntime.getMessageById(string, objectArray);
        return ScriptRuntime.rangeError(string2);
    }

    public static EcmaError typeError(String string) {
        return ScriptRuntime.constructError("TypeError", string);
    }

    public static EcmaError typeErrorById(String string, Object ... objectArray) {
        String string2 = ScriptRuntime.getMessageById(string, objectArray);
        return ScriptRuntime.typeError(string2);
    }

    @Deprecated
    public static EcmaError typeError0(String string) {
        String string2 = ScriptRuntime.getMessage0(string);
        return ScriptRuntime.typeError(string2);
    }

    @Deprecated
    public static EcmaError typeError1(String string, Object object) {
        String string2 = ScriptRuntime.getMessage1(string, object);
        return ScriptRuntime.typeError(string2);
    }

    @Deprecated
    public static EcmaError typeError2(String string, Object object, Object object2) {
        String string2 = ScriptRuntime.getMessage2(string, object, object2);
        return ScriptRuntime.typeError(string2);
    }

    @Deprecated
    public static EcmaError typeError3(String string, String string2, String string3, String string4) {
        String string5 = ScriptRuntime.getMessage3(string, string2, string3, string4);
        return ScriptRuntime.typeError(string5);
    }

    public static RuntimeException undefReadError(Object object, Object object2) {
        return ScriptRuntime.typeErrorById("msg.undef.prop.read", ScriptRuntime.toString(object), ScriptRuntime.toString(object2));
    }

    public static RuntimeException undefCallError(Object object, Object object2) {
        return ScriptRuntime.typeErrorById("msg.undef.method.call", ScriptRuntime.toString(object), ScriptRuntime.toString(object2));
    }

    public static RuntimeException undefWriteError(Object object, Object object2, Object object3) {
        return ScriptRuntime.typeErrorById("msg.undef.prop.write", ScriptRuntime.toString(object), ScriptRuntime.toString(object2), ScriptRuntime.toString(object3));
    }

    private static RuntimeException undefDeleteError(Object object, Object object2) {
        throw ScriptRuntime.typeErrorById("msg.undef.prop.delete", ScriptRuntime.toString(object), ScriptRuntime.toString(object2));
    }

    public static RuntimeException notFoundError(Scriptable scriptable, String string) {
        String string2 = ScriptRuntime.getMessageById("msg.is.not.defined", string);
        throw ScriptRuntime.constructError("ReferenceError", string2);
    }

    public static RuntimeException notFunctionError(Object object) {
        return ScriptRuntime.notFunctionError(object, object);
    }

    public static RuntimeException notFunctionError(Object object, Object object2) {
        String string;
        String string2 = string = object2 == null ? "null" : object2.toString();
        if (object == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeErrorById("msg.function.not.found", string);
        }
        return ScriptRuntime.typeErrorById("msg.isnt.function", string, ScriptRuntime.typeof(object));
    }

    public static RuntimeException notFunctionError(Object object, Object object2, String string) {
        int n;
        int n2;
        String string2 = ScriptRuntime.toString(object);
        if (object instanceof NativeFunction && (n2 = string2.indexOf(123, n = string2.indexOf(41))) > -1) {
            string2 = string2.substring(0, n2 + 1) + "...}";
        }
        if (object2 == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeErrorById("msg.function.not.found.in", string, string2);
        }
        return ScriptRuntime.typeErrorById("msg.isnt.function.in", string, string2, ScriptRuntime.typeof(object2));
    }

    private static RuntimeException notXmlError(Object object) {
        throw ScriptRuntime.typeErrorById("msg.isnt.xml.object", ScriptRuntime.toString(object));
    }

    public static EcmaError syntaxError(String string) {
        return ScriptRuntime.constructError("SyntaxError", string);
    }

    public static EcmaError syntaxErrorById(String string, Object ... objectArray) {
        String string2 = ScriptRuntime.getMessageById(string, objectArray);
        return ScriptRuntime.syntaxError(string2);
    }

    private static void warnAboutNonJSObject(Object object) {
        String string = ScriptRuntime.getMessageById("params.omit.non.js.object.warning", new Object[0]);
        if (!"true".equals(string)) {
            String string2 = ScriptRuntime.getMessageById("msg.non.js.object.warning", object, object.getClass().getName());
            Context.reportWarning(string2);
            System.err.println(string2);
        }
    }

    public static RegExpProxy getRegExpProxy(Context context) {
        return context.getRegExpProxy();
    }

    public static void setRegExpProxy(Context context, RegExpProxy regExpProxy) {
        if (regExpProxy == null) {
            throw new IllegalArgumentException();
        }
        context.regExpProxy = regExpProxy;
    }

    public static RegExpProxy checkRegExpProxy(Context context) {
        RegExpProxy regExpProxy = ScriptRuntime.getRegExpProxy(context);
        if (regExpProxy == null) {
            throw Context.reportRuntimeErrorById("msg.no.regexp", new Object[0]);
        }
        return regExpProxy;
    }

    public static Scriptable wrapRegExp(Context context, Scriptable scriptable, Object object) {
        return context.getRegExpProxy().wrapRegExp(context, scriptable, object);
    }

    public static Scriptable getTemplateLiteralCallSite(Context context, Scriptable scriptable, Object[] objectArray, int n) {
        Object object = objectArray[n];
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        assert (object instanceof String[]);
        String[] stringArray = (String[])object;
        assert ((stringArray.length & 1) == 0);
        ScriptableObject scriptableObject = (ScriptableObject)context.newArray(scriptable, stringArray.length >>> 1);
        ScriptableObject scriptableObject2 = (ScriptableObject)context.newArray(scriptable, stringArray.length >>> 1);
        scriptableObject.put("raw", (Scriptable)scriptableObject, (Object)scriptableObject2);
        scriptableObject.setAttributes("raw", 2);
        int n2 = stringArray.length;
        for (int i = 0; i < n2; i += 2) {
            int n3 = i >>> 1;
            scriptableObject.put(n3, (Scriptable)scriptableObject, stringArray[i] == null ? Undefined.instance : stringArray[i]);
            scriptableObject2.put(n3, (Scriptable)scriptableObject2, (Object)stringArray[i + 1]);
        }
        AbstractEcmaObjectOperations.setIntegrityLevel(context, scriptableObject2, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.FROZEN);
        AbstractEcmaObjectOperations.setIntegrityLevel(context, scriptableObject, AbstractEcmaObjectOperations.INTEGRITY_LEVEL.FROZEN);
        objectArray[n] = scriptableObject;
        return scriptableObject;
    }

    private static XMLLib currentXMLLib(Context context) {
        if (context.topCallScope == null) {
            throw new IllegalStateException();
        }
        XMLLib xMLLib = context.cachedXMLLib;
        if (xMLLib == null) {
            xMLLib = XMLLib.extractFromScope(context.topCallScope);
            if (xMLLib == null) {
                throw new IllegalStateException();
            }
            context.cachedXMLLib = xMLLib;
        }
        return xMLLib;
    }

    public static String escapeAttributeValue(Object object, Context context) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.escapeAttributeValue(object);
    }

    public static String escapeTextValue(Object object, Context context) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.escapeTextValue(object);
    }

    public static Ref memberRef(Object object, Object object2, Context context, int n) {
        if (!(object instanceof XMLObject)) {
            throw ScriptRuntime.notXmlError(object);
        }
        XMLObject xMLObject = (XMLObject)object;
        return xMLObject.memberRef(context, object2, n);
    }

    public static Ref memberRef(Object object, Object object2, Object object3, Context context, int n) {
        if (!(object instanceof XMLObject)) {
            throw ScriptRuntime.notXmlError(object);
        }
        XMLObject xMLObject = (XMLObject)object;
        return xMLObject.memberRef(context, object2, object3, n);
    }

    public static Ref nameRef(Object object, Context context, Scriptable scriptable, int n) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.nameRef(context, object, scriptable, n);
    }

    public static Ref nameRef(Object object, Object object2, Context context, Scriptable scriptable, int n) {
        XMLLib xMLLib = ScriptRuntime.currentXMLLib(context);
        return xMLLib.nameRef(context, object, object2, scriptable, n);
    }

    public static void storeUint32Result(Context context, long l) {
        if (l >>> 32 != 0L) {
            throw new IllegalArgumentException();
        }
        context.scratchUint32 = l;
    }

    public static long lastUint32Result(Context context) {
        long l = context.scratchUint32;
        if (l >>> 32 != 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    private static void storeScriptable(Context context, Scriptable scriptable) {
        if (context.scratchScriptable != null) {
            throw new IllegalStateException();
        }
        context.scratchScriptable = scriptable;
    }

    public static Scriptable lastStoredScriptable(Context context) {
        Scriptable scriptable = context.scratchScriptable;
        context.scratchScriptable = null;
        return scriptable;
    }

    static String makeUrlForGeneratedScript(boolean bl, String string, int n) {
        if (bl) {
            return string + '#' + n + "(eval)";
        }
        return string + '#' + n + "(Function)";
    }

    static boolean isGeneratedScript(String string) {
        return string.indexOf("(eval)") >= 0 || string.indexOf("(Function)") >= 0;
    }

    static boolean isSymbol(Object object) {
        return object instanceof NativeSymbol && ((NativeSymbol)object).isSymbol() || object instanceof SymbolKey;
    }

    private static RuntimeException errorWithClassName(String string, Object object) {
        return Context.reportRuntimeErrorById(string, object.getClass().getName());
    }

    public static JavaScriptException throwError(Context context, Scriptable scriptable, String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Scriptable scriptable2 = ScriptRuntime.newBuiltinObject(context, scriptable, TopLevel.Builtins.Error, new Object[]{string, string2, nArray[0]});
        return new JavaScriptException(scriptable2, string2, nArray[0]);
    }

    public static JavaScriptException throwCustomError(Context context, Scriptable scriptable, String string, String string2) {
        int[] nArray = new int[]{0};
        String string3 = Context.getSourcePositionFromStack(nArray);
        Scriptable scriptable2 = context.newObject(scriptable, string, new Object[]{string2, string3, nArray[0]});
        return new JavaScriptException(scriptable2, string3, nArray[0]);
    }

    private static class DefaultMessageProvider
    implements MessageProvider {
        private DefaultMessageProvider() {
        }

        @Override
        public String getMessage(String string, Object[] objectArray) {
            String string2;
            String string3 = "org.mozilla.javascript.resources.Messages";
            Context context = Context.getCurrentContext();
            Locale locale = context != null ? context.getLocale() : Locale.getDefault();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org.mozilla.javascript.resources.Messages", locale);
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                throw new RuntimeException("no message resource found for message property " + string);
            }
            MessageFormat messageFormat = new MessageFormat(string2);
            return messageFormat.format(objectArray);
        }
    }

    private static class IdEnumeration
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Scriptable obj;
        Object[] ids;
        ObjToIntMap used;
        Object currentId;
        int index;
        int enumType;
        boolean enumNumbers;
        Scriptable iterator;

        private IdEnumeration() {
        }
    }

    public static interface MessageProvider {
        public String getMessage(String var1, Object[] var2);
    }

    static class NoSuchMethodShim
    implements Callable {
        String methodName;
        Callable noSuchMethodMethod;

        NoSuchMethodShim(Callable callable, String string) {
            this.noSuchMethodMethod = callable;
            this.methodName = string;
        }

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            Object[] objectArray2 = new Object[]{this.methodName, ScriptRuntime.newArrayLiteral(objectArray, null, context, scriptable)};
            return this.noSuchMethodMethod.call(context, scriptable, scriptable2, objectArray2);
        }
    }

    public static final class StringIdOrIndex {
        final String stringId;
        final int index;

        StringIdOrIndex(String string) {
            this.stringId = string;
            this.index = -1;
        }

        StringIdOrIndex(int n) {
            this.stringId = null;
            this.index = n;
        }

        public String getStringId() {
            return this.stringId;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

