/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.ast.ArrayComprehension;
import org.mozilla.javascript.ast.ArrayComprehensionLoop;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.BigIntLiteral;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DestructuringForm;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ErrorNode;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.GeneratorExpression;
import org.mozilla.javascript.ast.GeneratorExpressionLoop;
import org.mozilla.javascript.ast.IdeErrorReporter;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.Symbol;
import org.mozilla.javascript.ast.TaggedTemplateLiteral;
import org.mozilla.javascript.ast.TemplateCharacters;
import org.mozilla.javascript.ast.TemplateLiteral;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.UpdateExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;
import org.mozilla.javascript.ast.XmlDotQuery;
import org.mozilla.javascript.ast.XmlElemRef;
import org.mozilla.javascript.ast.XmlExpression;
import org.mozilla.javascript.ast.XmlLiteral;
import org.mozilla.javascript.ast.XmlMemberGet;
import org.mozilla.javascript.ast.XmlPropRef;
import org.mozilla.javascript.ast.XmlRef;
import org.mozilla.javascript.ast.XmlString;
import org.mozilla.javascript.ast.Yield;

public class Parser {
    public static final int ARGC_LIMIT = 65536;
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private IdeErrorReporter errorCollector;
    private String sourceURI;
    private char[] sourceChars;
    boolean calledByCompileFunction;
    private boolean parseFinished;
    private TokenStream ts;
    private int currentFlaggedToken = 0;
    private int currentToken;
    private int syntaxErrorCount;
    private List<Comment> scannedComments;
    private Comment currentJsDocComment;
    protected int nestingOfFunction;
    private LabeledStatement currentLabel;
    private boolean inDestructuringAssignment;
    protected boolean inUseStrictDirective;
    ScriptNode currentScriptOrFn;
    Scope currentScope;
    private int endFlags;
    private boolean inForInit;
    private Map<String, LabeledStatement> labelSet;
    private List<Loop> loopSet;
    private List<Jump> loopAndSwitchSet;
    private int prevNameTokenStart;
    private String prevNameTokenString = "";
    private int prevNameTokenLineno;
    private boolean defaultUseStrictDirective;
    private static final int PROP_ENTRY = 1;
    private static final int GET_ENTRY = 2;
    private static final int SET_ENTRY = 4;
    private static final int METHOD_ENTRY = 8;

    public Parser() {
        this(new CompilerEnvirons());
    }

    public Parser(CompilerEnvirons compilerEnvirons) {
        this(compilerEnvirons, compilerEnvirons.getErrorReporter());
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
        if (errorReporter instanceof IdeErrorReporter) {
            this.errorCollector = (IdeErrorReporter)errorReporter;
        }
    }

    void addStrictWarning(String string, String string2) {
        int n = -1;
        int n2 = -1;
        if (this.ts != null) {
            n = this.ts.tokenBeg;
            n2 = this.ts.tokenEnd - this.ts.tokenBeg;
        }
        this.addStrictWarning(string, string2, n, n2);
    }

    void addStrictWarning(String string, String string2, int n, int n2) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2, n, n2);
        }
    }

    void addWarning(String string, String string2) {
        int n = -1;
        int n2 = -1;
        if (this.ts != null) {
            n = this.ts.tokenBeg;
            n2 = this.ts.tokenEnd - this.ts.tokenBeg;
        }
        this.addWarning(string, string2, n, n2);
    }

    void addWarning(String string, int n, int n2) {
        this.addWarning(string, null, n, n2);
    }

    void addWarning(String string, String string2, int n, int n2) {
        String string3 = this.lookupMessage(string, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(string, string2, n, n2);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(string3, this.sourceURI, n, n2);
        } else if (this.ts != null) {
            this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        } else {
            this.errorReporter.warning(string3, this.sourceURI, 1, "", 1);
        }
    }

    void addError(String string) {
        if (this.ts == null) {
            this.addError(string, 0, 0);
        } else {
            this.addError(string, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        }
    }

    void addError(String string, int n, int n2) {
        this.addError(string, null, n, n2);
    }

    void addError(String string, String string2) {
        if (this.ts == null) {
            this.addError(string, string2, 0, 0);
        } else {
            this.addError(string, string2, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        }
    }

    void addError(String string, int n) {
        String string2 = Character.toString((char)n);
        this.addError(string, string2);
    }

    void addError(String string, String string2, int n, int n2) {
        ++this.syntaxErrorCount;
        String string3 = this.lookupMessage(string, string2);
        if (this.errorCollector != null) {
            this.errorCollector.error(string3, this.sourceURI, n, n2);
        } else {
            int n3 = 1;
            int n4 = 1;
            String string4 = "";
            if (this.ts != null) {
                n3 = this.ts.getLineno();
                string4 = this.ts.getLine();
                n4 = this.ts.getOffset();
            }
            this.errorReporter.error(string3, this.sourceURI, n3, string4, n4);
        }
    }

    private void addStrictWarning(String string, String string2, int n, int n2, int n3, String string3, int n4) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2, n, n2, n3, string3, n4);
        }
    }

    private void addWarning(String string, String string2, int n, int n2, int n3, String string3, int n4) {
        String string4 = this.lookupMessage(string, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            this.addError(string, string2, n, n2, n3, string3, n4);
        } else if (this.errorCollector != null) {
            this.errorCollector.warning(string4, this.sourceURI, n, n2);
        } else {
            this.errorReporter.warning(string4, this.sourceURI, n3, string3, n4);
        }
    }

    private void addError(String string, String string2, int n, int n2, int n3, String string3, int n4) {
        ++this.syntaxErrorCount;
        String string4 = this.lookupMessage(string, string2);
        if (this.errorCollector != null) {
            this.errorCollector.error(string4, this.sourceURI, n, n2);
        } else {
            this.errorReporter.error(string4, this.sourceURI, n3, string3, n4);
        }
    }

    String lookupMessage(String string) {
        return this.lookupMessage(string, null);
    }

    String lookupMessage(String string, String string2) {
        return string2 == null ? ScriptRuntime.getMessageById(string, new Object[0]) : ScriptRuntime.getMessageById(string, string2);
    }

    void reportError(String string) {
        this.reportError(string, null);
    }

    void reportError(String string, String string2) {
        if (this.ts == null) {
            this.reportError(string, string2, 1, 1);
        } else {
            this.reportError(string, string2, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        }
    }

    void reportError(String string, int n, int n2) {
        this.reportError(string, null, n, n2);
    }

    void reportError(String string, String string2, int n, int n2) {
        this.addError(string, string2, n, n2);
        if (!this.compilerEnv.recoverFromErrors()) {
            throw new ParserException();
        }
    }

    private static int getNodeEnd(AstNode astNode) {
        return astNode.getPosition() + astNode.getLength();
    }

    private void recordComment(int n, String string) {
        if (this.scannedComments == null) {
            this.scannedComments = new ArrayList<Comment>();
        }
        Comment comment = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, string);
        if (this.ts.commentType == Token.CommentType.JSDOC && this.compilerEnv.isRecordingLocalJsDocComments()) {
            this.currentJsDocComment = new Comment(this.ts.tokenBeg, this.ts.getTokenLength(), this.ts.commentType, string);
            this.currentJsDocComment.setLineno(n);
        }
        comment.setLineno(n);
        this.scannedComments.add(comment);
    }

    private Comment getAndResetJsDoc() {
        Comment comment = this.currentJsDocComment;
        this.currentJsDocComment = null;
        return comment;
    }

    private int peekToken() throws IOException {
        if (this.currentFlaggedToken != 0) {
            return this.currentToken;
        }
        int n = this.ts.getLineno();
        int n2 = this.ts.getToken();
        boolean bl = false;
        while (n2 == 1 || n2 == 165) {
            if (n2 == 1) {
                ++n;
                bl = true;
                n2 = this.ts.getToken();
                continue;
            }
            if (this.compilerEnv.isRecordingComments()) {
                String string = this.ts.getAndResetCurrentComment();
                this.recordComment(n, string);
                break;
            }
            n2 = this.ts.getToken();
        }
        this.currentToken = n2;
        this.currentFlaggedToken = n2 | (bl ? 65536 : 0);
        return this.currentToken;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n, boolean bl) throws IOException {
        int n2 = this.peekToken();
        while (n2 == 165 && bl) {
            this.consumeToken();
            n2 = this.peekToken();
        }
        if (n2 != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private boolean mustMatchToken(int n, String string, boolean bl) throws IOException {
        return this.mustMatchToken(n, string, this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, bl);
    }

    private boolean mustMatchToken(int n, String string, int n2, int n3, boolean bl) throws IOException {
        if (this.matchToken(n, bl)) {
            return true;
        }
        this.reportError(string, n2, n3);
        return false;
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    void pushScope(Scope scope) {
        Scope scope2 = scope.getParentScope();
        if (scope2 != null) {
            if (scope2 != this.currentScope) {
                this.codeBug();
            }
        } else {
            this.currentScope.addChildScope(scope);
        }
        this.currentScope = scope;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    private void enterLoop(Loop loop) {
        if (this.loopSet == null) {
            this.loopSet = new ArrayList<Loop>();
        }
        this.loopSet.add(loop);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(loop);
        this.pushScope(loop);
        if (this.currentLabel != null) {
            this.currentLabel.setStatement(loop);
            this.currentLabel.getFirstLabel().setLoop(loop);
            loop.setRelative(-this.currentLabel.getPosition());
        }
    }

    private void exitLoop() {
        this.loopSet.remove(this.loopSet.size() - 1);
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
        this.popScope();
    }

    private void restoreRelativeLoopPosition(Loop loop) {
        if (loop.getParent() != null) {
            loop.setRelative(loop.getParent().getPosition());
        }
    }

    private void enterSwitch(SwitchStatement switchStatement) {
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ArrayList<Jump>();
        }
        this.loopAndSwitchSet.add(switchStatement);
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.remove(this.loopAndSwitchSet.size() - 1);
    }

    public AstRoot parse(String string, String string2, int n) {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        this.sourceURI = string2;
        if (this.compilerEnv.isIdeMode()) {
            this.sourceChars = string.toCharArray();
        }
        this.ts = new TokenStream(this, null, string, n);
        try {
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public AstRoot parse(Reader reader, String string, int n) throws IOException {
        if (this.parseFinished) {
            throw new IllegalStateException("parser reused");
        }
        if (this.compilerEnv.isIdeMode()) {
            return this.parse(Kit.readReader(reader), string, n);
        }
        try {
            this.sourceURI = string;
            this.ts = new TokenStream(this, reader, null, n);
            AstRoot astRoot = this.parse();
            return astRoot;
        }
        finally {
            this.parseFinished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstRoot parse() throws IOException {
        Iterator<Comment> iterator;
        int n;
        int n2 = 0;
        AstRoot astRoot = new AstRoot(n2);
        this.currentScriptOrFn = astRoot;
        this.currentScope = this.currentScriptOrFn;
        int n3 = this.ts.lineno;
        int n4 = n2;
        boolean bl = true;
        boolean bl2 = this.inUseStrictDirective;
        this.inUseStrictDirective = this.defaultUseStrictDirective;
        if (this.inUseStrictDirective) {
            astRoot.setInStrictMode(true);
        }
        try {
            while (true) {
                block23: {
                    if ((n = this.peekToken()) <= 0) {
                        break;
                    }
                    if (n == 113) {
                        this.consumeToken();
                        try {
                            iterator = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block23;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    if (n == 165) {
                        iterator = this.scannedComments.get(this.scannedComments.size() - 1);
                        this.consumeToken();
                    } else {
                        iterator = this.statement();
                        if (bl) {
                            String object = Parser.getDirective((AstNode)((Object)iterator));
                            if (object == null) {
                                bl = false;
                            } else if (object.equals("use strict")) {
                                this.inUseStrictDirective = true;
                                astRoot.setInStrictMode(true);
                            }
                        }
                    }
                }
                n4 = Parser.getNodeEnd((AstNode)((Object)iterator));
                astRoot.addChildToBack((Node)((Object)iterator));
                ((AstNode)((Object)iterator)).setParent(astRoot);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            iterator = this.lookupMessage("msg.too.deep.parser.recursion");
            if (!this.compilerEnv.isIdeMode()) {
                throw Context.reportRuntimeError((String)((Object)iterator), this.sourceURI, this.ts.lineno, null, 0);
            }
        }
        finally {
            this.inUseStrictDirective = bl2;
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = this.lookupMessage("msg.got.syntax.errors", string);
            if (!this.compilerEnv.isIdeMode()) {
                throw this.errorReporter.runtimeError(string, this.sourceURI, n3, null, 0);
            }
        }
        if (this.scannedComments != null) {
            n = this.scannedComments.size() - 1;
            n4 = Math.max(n4, Parser.getNodeEnd(this.scannedComments.get(n)));
            for (Comment comment : this.scannedComments) {
                astRoot.addComment(comment);
            }
        }
        astRoot.setLength(n4 - n2);
        astRoot.setSourceName(this.sourceURI);
        astRoot.setBaseLineno(n3);
        astRoot.setEndLineno(this.ts.lineno);
        return astRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parseFunctionBody(int n, FunctionNode functionNode) throws IOException {
        Block block;
        int n2;
        boolean bl;
        block18: {
            bl = false;
            if (!this.matchToken(88, true)) {
                if (this.compilerEnv.getLanguageVersion() < 180 && n != 4) {
                    this.reportError("msg.no.brace.body");
                } else {
                    bl = true;
                }
            }
            boolean bl2 = n == 4;
            ++this.nestingOfFunction;
            n2 = this.ts.tokenBeg;
            block = new Block(n2);
            boolean bl3 = true;
            boolean bl4 = this.inUseStrictDirective;
            this.inUseStrictDirective = false;
            block.setLineno(this.ts.lineno);
            try {
                AstNode astNode;
                if (bl) {
                    astNode = this.assignExpr();
                    ReturnStatement returnStatement = new ReturnStatement(astNode.getPosition(), astNode.getLength(), astNode);
                    returnStatement.putProp(25, Boolean.TRUE);
                    block.putProp(25, Boolean.TRUE);
                    if (bl2) {
                        returnStatement.putProp(27, Boolean.TRUE);
                    }
                    block.addStatement(returnStatement);
                    break block18;
                }
                while (true) {
                    int n3 = this.peekToken();
                    switch (n3) {
                        case -1: 
                        case 0: 
                        case 89: {
                            break block18;
                        }
                        case 165: {
                            this.consumeToken();
                            astNode = this.scannedComments.get(this.scannedComments.size() - 1);
                            break;
                        }
                        case 113: {
                            this.consumeToken();
                            astNode = this.function(1);
                            break;
                        }
                        default: {
                            astNode = this.statement();
                            if (!bl3) break;
                            String string = Parser.getDirective(astNode);
                            if (string == null) {
                                bl3 = false;
                                break;
                            }
                            if (!string.equals("use strict")) break;
                            this.inUseStrictDirective = true;
                            functionNode.setInStrictMode(true);
                            if (bl4) break;
                            this.setRequiresActivation();
                        }
                    }
                    block.addStatement(astNode);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
                this.inUseStrictDirective = bl4;
            }
        }
        int n4 = this.ts.tokenEnd;
        this.getAndResetJsDoc();
        if (!bl && this.mustMatchToken(89, "msg.no.brace.after.body", true)) {
            n4 = this.ts.tokenEnd;
        }
        block.setLength(n4 - n2);
        return block;
    }

    private static String getDirective(AstNode astNode) {
        AstNode astNode2;
        if (astNode instanceof ExpressionStatement && (astNode2 = ((ExpressionStatement)astNode).getExpression()) instanceof StringLiteral) {
            return ((StringLiteral)astNode2).getValue();
        }
        return null;
    }

    private void parseFunctionParams(FunctionNode functionNode) throws IOException {
        Object object;
        if (this.matchToken(91, true)) {
            functionNode.setRp(this.ts.tokenBeg - functionNode.getPosition());
            return;
        }
        HashMap<String, Object> hashMap = null;
        HashSet<Object> hashSet = new HashSet<Object>();
        do {
            Object object3;
            int n;
            if ((n = this.peekToken()) == 91) {
                functionNode.putIntProp(29, 1);
                break;
            }
            if (n == 86 || n == 88) {
                object3 = this.destructuringPrimaryExpr();
                this.markDestructuring((AstNode)object3);
                functionNode.addParam((AstNode)object3);
                if (hashMap == null) {
                    hashMap = new HashMap<String, Object>();
                }
                String string = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(90, string, false);
                hashMap.put(string, object3);
                continue;
            }
            if (this.mustMatchToken(39, "msg.no.parm", true)) {
                object3 = this.createNameNode();
                Comment comment = this.getAndResetJsDoc();
                if (comment != null) {
                    ((Node)object3).setJsDocNode(comment);
                }
                functionNode.addParam((AstNode)object3);
                object = this.ts.getString();
                this.defineSymbol(90, (String)object);
                if (!this.inUseStrictDirective) continue;
                if ("eval".equals(object) || "arguments".equals(object)) {
                    this.reportError("msg.bad.id.strict", (String)object);
                }
                if (hashSet.contains(object)) {
                    this.addError("msg.dup.param.strict", (String)object);
                }
                hashSet.add(object);
                continue;
            }
            functionNode.addParam(this.makeErrorNode());
        } while (this.matchToken(92, true));
        if (hashMap != null) {
            Node node = new Node(92);
            for (Map.Entry entry : hashMap.entrySet()) {
                object = this.createDestructuringAssignment(126, (Node)entry.getValue(), this.createName((String)entry.getKey()));
                node.addChildToBack((Node)object);
            }
            functionNode.putProp(23, node);
        }
        if (this.mustMatchToken(91, "msg.no.paren.after.parms", true)) {
            functionNode.setRp(this.ts.tokenBeg - functionNode.getPosition());
        }
    }

    private FunctionNode function(int n) throws IOException {
        return this.function(n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode function(int n, boolean bl) throws IOException {
        int n2;
        int n3 = n;
        int n4 = this.ts.lineno;
        int n5 = this.ts.tokenBeg;
        Name name = null;
        AstNode astNode = null;
        if (this.matchToken(39, true)) {
            Object object;
            name = this.createNameNode(true, 39);
            if (this.inUseStrictDirective && ("eval".equals(object = name.getIdentifier()) || "arguments".equals(object))) {
                this.reportError("msg.bad.id.strict", (String)object);
            }
            if (!this.matchToken(90, true)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    object = name;
                    name = null;
                    astNode = this.memberExprTail(false, (AstNode)object);
                }
                this.mustMatchToken(90, "msg.no.paren.parms", true);
            }
        } else if (!this.matchToken(90, true)) {
            if (this.matchToken(23, true) && this.compilerEnv.getLanguageVersion() >= 200) {
                return this.function(n, true);
            }
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                astNode = this.memberExpr(false);
            }
            this.mustMatchToken(90, "msg.no.paren.parms", true);
        }
        int n6 = n2 = this.currentToken == 90 ? this.ts.tokenBeg : -1;
        if (astNode != null) {
            n3 = 2;
        }
        if (n3 != 2 && name != null && name.length() > 0) {
            this.defineSymbol(113, name.getIdentifier());
        }
        FunctionNode functionNode = new FunctionNode(n5, name);
        functionNode.setFunctionType(n);
        if (bl) {
            functionNode.setIsES6Generator();
        }
        if (n2 != -1) {
            functionNode.setLp(n2 - n5);
        }
        functionNode.setJsDocNode(this.getAndResetJsDoc());
        PerFunctionVariables perFunctionVariables = new PerFunctionVariables(functionNode);
        try {
            this.parseFunctionParams(functionNode);
            functionNode.setBody(this.parseFunctionBody(n, functionNode));
            functionNode.setEncodedSourceBounds(n5, this.ts.tokenEnd);
            functionNode.setLength(this.ts.tokenEnd - n5);
            if (this.compilerEnv.isStrictMode() && !functionNode.getBody().hasConsistentReturnUsage()) {
                String string = name != null && name.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(string, name == null ? "" : name.getIdentifier());
            }
        }
        finally {
            perFunctionVariables.restore();
        }
        if (astNode != null) {
            Kit.codeBug();
            functionNode.setMemberExprNode(astNode);
        }
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n4);
        functionNode.setEndLineno(this.ts.lineno);
        if (this.compilerEnv.isIdeMode()) {
            functionNode.setParentScope(this.currentScope);
        }
        return functionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode arrowFunction(AstNode astNode) throws IOException {
        int n = this.ts.lineno;
        int n2 = astNode != null ? astNode.getPosition() : -1;
        FunctionNode functionNode = new FunctionNode(n2);
        functionNode.setFunctionType(4);
        functionNode.setJsDocNode(this.getAndResetJsDoc());
        HashMap<String, Node> hashMap = new HashMap<String, Node>();
        HashSet<String> hashSet = new HashSet<String>();
        PerFunctionVariables perFunctionVariables = new PerFunctionVariables(functionNode);
        try {
            Node node;
            if (astNode instanceof ParenthesizedExpression) {
                functionNode.setParens(0, astNode.getLength());
                if (astNode.getIntProp(29, 0) == 1) {
                    functionNode.putIntProp(29, 1);
                }
                if (!((node = ((ParenthesizedExpression)astNode).getExpression()) instanceof EmptyExpression)) {
                    this.arrowFunctionParams(functionNode, (AstNode)node, hashMap, hashSet);
                }
            } else {
                this.arrowFunctionParams(functionNode, astNode, hashMap, hashSet);
            }
            if (!hashMap.isEmpty()) {
                node = new Node(92);
                for (Map.Entry entry : hashMap.entrySet()) {
                    Node node2 = this.createDestructuringAssignment(126, (Node)entry.getValue(), this.createName((String)entry.getKey()));
                    node.addChildToBack(node2);
                }
                functionNode.putProp(23, node);
            }
            functionNode.setBody(this.parseFunctionBody(4, functionNode));
            functionNode.setEncodedSourceBounds(n2, this.ts.tokenEnd);
            functionNode.setLength(this.ts.tokenEnd - n2);
        }
        finally {
            perFunctionVariables.restore();
        }
        if (functionNode.isGenerator()) {
            this.reportError("msg.arrowfunction.generator");
            return this.makeErrorNode();
        }
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n);
        functionNode.setEndLineno(this.ts.lineno);
        return functionNode;
    }

    private void arrowFunctionParams(FunctionNode functionNode, AstNode astNode, Map<String, Node> map, Set<String> set) {
        if (astNode instanceof ArrayLiteral || astNode instanceof ObjectLiteral) {
            this.markDestructuring(astNode);
            functionNode.addParam(astNode);
            String string = this.currentScriptOrFn.getNextTempName();
            this.defineSymbol(90, string, false);
            map.put(string, astNode);
        } else if (astNode instanceof InfixExpression && astNode.getType() == 92) {
            this.arrowFunctionParams(functionNode, ((InfixExpression)astNode).getLeft(), map, set);
            this.arrowFunctionParams(functionNode, ((InfixExpression)astNode).getRight(), map, set);
        } else if (astNode instanceof Name) {
            functionNode.addParam(astNode);
            String string = ((Name)astNode).getIdentifier();
            this.defineSymbol(90, string);
            if (this.inUseStrictDirective) {
                if ("eval".equals(string) || "arguments".equals(string)) {
                    this.reportError("msg.bad.id.strict", string);
                }
                if (set.contains(string)) {
                    this.addError("msg.dup.param.strict", string);
                }
                set.add(string);
            }
        } else {
            this.reportError("msg.no.parm", astNode.getPosition(), astNode.getLength());
            functionNode.addParam(this.makeErrorNode());
        }
    }

    private AstNode statements(AstNode astNode) throws IOException {
        int n;
        if (this.currentToken != 88 && !this.compilerEnv.isIdeMode()) {
            this.codeBug();
        }
        int n2 = this.ts.tokenBeg;
        AstNode astNode2 = astNode != null ? astNode : new Block(n2);
        astNode2.setLineno(this.ts.lineno);
        while ((n = this.peekToken()) > 0 && n != 89) {
            astNode2.addChild(this.statement());
        }
        astNode2.setLength(this.ts.tokenBeg - n2);
        return astNode2;
    }

    private AstNode statements() throws IOException {
        return this.statements(null);
    }

    private ConditionData condition() throws IOException {
        ConditionData conditionData = new ConditionData();
        if (this.mustMatchToken(90, "msg.no.paren.cond", true)) {
            conditionData.lp = this.ts.tokenBeg;
        }
        conditionData.condition = this.expr(false);
        if (this.mustMatchToken(91, "msg.no.paren.after.cond", true)) {
            conditionData.rp = this.ts.tokenBeg;
        }
        if (conditionData.condition instanceof Assignment) {
            this.addStrictWarning("msg.equal.as.assign", "", conditionData.condition.getPosition(), conditionData.condition.getLength());
        }
        return conditionData;
    }

    private AstNode statement() throws IOException {
        int n = this.ts.tokenBeg;
        try {
            AstNode astNode = this.statementHelper();
            if (astNode != null) {
                int n2;
                if (this.compilerEnv.isStrictMode() && !astNode.hasSideEffects()) {
                    n2 = astNode.getPosition();
                    n2 = Math.max(n2, this.lineBeginningFor(n2));
                    this.addStrictWarning(astNode instanceof EmptyStatement ? "msg.extra.trailing.semi" : "msg.no.side.effects", "", n2, Parser.nodeEnd(astNode) - n2);
                }
                if ((n2 = this.peekToken()) == 165 && astNode.getLineno() == this.scannedComments.get(this.scannedComments.size() - 1).getLineno()) {
                    astNode.setInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                    this.consumeToken();
                }
                return astNode;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        block5: while (true) {
            int n3 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n3) {
                case -1: 
                case 0: 
                case 1: 
                case 85: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return new EmptyStatement(n, this.ts.tokenBeg - n);
    }

    private AstNode statementHelper() throws IOException {
        if (this.currentLabel != null && this.currentLabel.getStatement() != null) {
            this.currentLabel = null;
        }
        AstNode astNode = null;
        int n = this.peekToken();
        int n2 = this.ts.tokenBeg;
        switch (n) {
            case 116: {
                return this.ifStatement();
            }
            case 118: {
                return this.switchStatement();
            }
            case 121: {
                return this.whileLoop();
            }
            case 122: {
                return this.doLoop();
            }
            case 123: {
                return this.forLoop();
            }
            case 84: {
                return this.tryStatement();
            }
            case 50: {
                astNode = this.throwStatement();
                break;
            }
            case 124: {
                astNode = this.breakStatement();
                break;
            }
            case 125: {
                astNode = this.continueStatement();
                break;
            }
            case 127: {
                if (this.inUseStrictDirective) {
                    this.reportError("msg.no.with.strict");
                }
                return this.withStatement();
            }
            case 126: 
            case 158: {
                this.consumeToken();
                int n3 = this.ts.lineno;
                astNode = this.variables(this.currentToken, this.ts.tokenBeg, true);
                astNode.setLineno(n3);
                break;
            }
            case 157: {
                astNode = this.letStatement();
                if (astNode instanceof VariableDeclaration && this.peekToken() == 85) break;
                return astNode;
            }
            case 4: 
            case 73: {
                astNode = this.returnOrYield(n, false);
                break;
            }
            case 164: {
                this.consumeToken();
                astNode = new KeywordLiteral(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg, n);
                astNode.setLineno(this.ts.lineno);
                break;
            }
            case 88: {
                return this.block();
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 85: {
                this.consumeToken();
                n2 = this.ts.tokenBeg;
                astNode = new EmptyStatement(n2, this.ts.tokenEnd - n2);
                astNode.setLineno(this.ts.lineno);
                return astNode;
            }
            case 113: {
                this.consumeToken();
                return this.function(3);
            }
            case 120: {
                astNode = this.defaultXmlNamespace();
                break;
            }
            case 39: {
                astNode = this.nameOrLabel();
                if (astNode instanceof ExpressionStatement) break;
                return astNode;
            }
            case 165: {
                astNode = this.scannedComments.get(this.scannedComments.size() - 1);
                return astNode;
            }
            default: {
                int n4 = this.ts.lineno;
                astNode = new ExpressionStatement(this.expr(false), !this.insideFunction());
                astNode.setLineno(n4);
            }
        }
        this.autoInsertSemicolon(astNode);
        return astNode;
    }

    private void autoInsertSemicolon(AstNode astNode) throws IOException {
        int n = this.peekFlaggedToken();
        int n2 = astNode.getPosition();
        switch (n & 0xFFFF) {
            case 85: {
                this.consumeToken();
                astNode.setLength(this.ts.tokenEnd - n2);
                break;
            }
            case -1: 
            case 0: 
            case 89: {
                this.warnMissingSemi(n2, Math.max(n2 + 1, Parser.nodeEnd(astNode)));
                break;
            }
            default: {
                if ((n & 0x10000) == 0) {
                    this.reportError("msg.no.semi.stmt");
                    break;
                }
                this.warnMissingSemi(n2, Parser.nodeEnd(astNode));
            }
        }
    }

    private IfStatement ifStatement() throws IOException {
        int n;
        if (this.currentToken != 116) {
            this.codeBug();
        }
        this.consumeToken();
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.lineno;
        int n4 = -1;
        IfStatement ifStatement = new IfStatement(n2);
        ConditionData conditionData = this.condition();
        AstNode astNode = this.getNextStatementAfterInlineComments(ifStatement);
        AstNode astNode2 = null;
        if (this.matchToken(117, true)) {
            n = this.peekToken();
            if (n == 165) {
                ifStatement.setElseKeyWordInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                this.consumeToken();
            }
            n4 = this.ts.tokenBeg - n2;
            astNode2 = this.statement();
        }
        n = Parser.getNodeEnd(astNode2 != null ? astNode2 : astNode);
        ifStatement.setLength(n - n2);
        ifStatement.setCondition(conditionData.condition);
        ifStatement.setParens(conditionData.lp - n2, conditionData.rp - n2);
        ifStatement.setThenPart(astNode);
        ifStatement.setElsePart(astNode2);
        ifStatement.setElsePosition(n4);
        ifStatement.setLineno(n3);
        return ifStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwitchStatement switchStatement() throws IOException {
        SwitchStatement switchStatement;
        block18: {
            if (this.currentToken != 118) {
                this.codeBug();
            }
            this.consumeToken();
            int n = this.ts.tokenBeg;
            switchStatement = new SwitchStatement(n);
            if (this.mustMatchToken(90, "msg.no.paren.switch", true)) {
                switchStatement.setLp(this.ts.tokenBeg - n);
            }
            switchStatement.setLineno(this.ts.lineno);
            AstNode astNode = this.expr(false);
            switchStatement.setExpression(astNode);
            this.enterSwitch(switchStatement);
            try {
                if (this.mustMatchToken(91, "msg.no.paren.after.switch", true)) {
                    switchStatement.setRp(this.ts.tokenBeg - n);
                }
                this.mustMatchToken(88, "msg.no.brace.switch", true);
                boolean bl = false;
                block9: while (true) {
                    AstNode astNode2;
                    int n2 = this.nextToken();
                    int n3 = this.ts.tokenBeg;
                    int n4 = this.ts.lineno;
                    AstNode astNode3 = null;
                    switch (n2) {
                        case 89: {
                            switchStatement.setLength(this.ts.tokenEnd - n);
                            break block18;
                        }
                        case 119: {
                            astNode3 = this.expr(false);
                            this.mustMatchToken(107, "msg.no.colon.case", true);
                            break;
                        }
                        case 120: {
                            if (bl) {
                                this.reportError("msg.double.switch.default");
                            }
                            bl = true;
                            this.mustMatchToken(107, "msg.no.colon.case", true);
                            break;
                        }
                        case 165: {
                            astNode2 = this.scannedComments.get(this.scannedComments.size() - 1);
                            switchStatement.addChild(astNode2);
                            continue block9;
                        }
                        default: {
                            this.reportError("msg.bad.switch");
                            break block18;
                        }
                    }
                    astNode2 = new SwitchCase(n3);
                    ((SwitchCase)astNode2).setExpression(astNode3);
                    astNode2.setLength(this.ts.tokenEnd - n);
                    astNode2.setLineno(n4);
                    while ((n2 = this.peekToken()) != 89 && n2 != 119 && n2 != 120 && n2 != 0) {
                        AstNode astNode4;
                        if (n2 == 165) {
                            astNode4 = this.scannedComments.get(this.scannedComments.size() - 1);
                            if (astNode2.getInlineComment() == null && astNode4.getLineno() == astNode2.getLineno()) {
                                astNode2.setInlineComment(astNode4);
                            } else {
                                ((SwitchCase)astNode2).addStatement(astNode4);
                            }
                            this.consumeToken();
                            continue;
                        }
                        astNode4 = this.statement();
                        ((SwitchCase)astNode2).addStatement(astNode4);
                    }
                    switchStatement.addCase((SwitchCase)astNode2);
                }
            }
            finally {
                this.exitSwitch();
            }
        }
        return switchStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WhileLoop whileLoop() throws IOException {
        if (this.currentToken != 121) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        WhileLoop whileLoop = new WhileLoop(n);
        whileLoop.setLineno(this.ts.lineno);
        this.enterLoop(whileLoop);
        try {
            ConditionData conditionData = this.condition();
            whileLoop.setCondition(conditionData.condition);
            whileLoop.setParens(conditionData.lp - n, conditionData.rp - n);
            AstNode astNode = this.getNextStatementAfterInlineComments(whileLoop);
            whileLoop.setLength(Parser.getNodeEnd(astNode) - n);
            this.restoreRelativeLoopPosition(whileLoop);
            whileLoop.setBody(astNode);
        }
        finally {
            this.exitLoop();
        }
        return whileLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DoLoop doLoop() throws IOException {
        int n;
        if (this.currentToken != 122) {
            this.codeBug();
        }
        this.consumeToken();
        int n2 = this.ts.tokenBeg;
        DoLoop doLoop = new DoLoop(n2);
        doLoop.setLineno(this.ts.lineno);
        this.enterLoop(doLoop);
        try {
            AstNode astNode = this.getNextStatementAfterInlineComments(doLoop);
            this.mustMatchToken(121, "msg.no.while.do", true);
            doLoop.setWhilePosition(this.ts.tokenBeg - n2);
            ConditionData conditionData = this.condition();
            doLoop.setCondition(conditionData.condition);
            doLoop.setParens(conditionData.lp - n2, conditionData.rp - n2);
            n = Parser.getNodeEnd(astNode);
            this.restoreRelativeLoopPosition(doLoop);
            doLoop.setBody(astNode);
        }
        finally {
            this.exitLoop();
        }
        if (this.matchToken(85, true)) {
            n = this.ts.tokenEnd;
        }
        doLoop.setLength(n - n2);
        return doLoop;
    }

    private int peekUntilNonComment(int n) throws IOException {
        while (n == 165) {
            this.consumeToken();
            n = this.peekToken();
        }
        return n;
    }

    private AstNode getNextStatementAfterInlineComments(AstNode astNode) throws IOException {
        AstNode astNode2 = this.statement();
        if (165 == astNode2.getType()) {
            AstNode astNode3 = astNode2;
            astNode2 = this.statement();
            if (astNode != null) {
                astNode.setInlineComment(astNode3);
            } else {
                astNode2.setInlineComment(astNode3);
            }
        }
        return astNode2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loop forLoop() throws IOException {
        if (this.currentToken != 123) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        AstNode astNode = null;
        AstNode astNode2 = null;
        AstNode astNode3 = null;
        Loop loop = null;
        Scope scope = new Scope();
        this.pushScope(scope);
        try {
            AstNode astNode4;
            if (this.matchToken(39, true)) {
                if ("each".equals(this.ts.getString())) {
                    bl = true;
                    n3 = this.ts.tokenBeg - n;
                } else {
                    this.reportError("msg.no.paren.for");
                }
            }
            if (this.mustMatchToken(90, "msg.no.paren.for", true)) {
                n5 = this.ts.tokenBeg - n;
            }
            int n7 = this.peekToken();
            astNode = this.forLoopInit(n7);
            if (this.matchToken(52, true)) {
                bl2 = true;
                n4 = this.ts.tokenBeg - n;
                this.markDestructuring(astNode);
                astNode2 = this.expr(false);
            } else if (this.compilerEnv.getLanguageVersion() >= 200 && this.matchToken(39, true) && "of".equals(this.ts.getString())) {
                bl3 = true;
                n4 = this.ts.tokenBeg - n;
                this.markDestructuring(astNode);
                astNode2 = this.expr(false);
            } else {
                this.mustMatchToken(85, "msg.no.semi.for", true);
                if (this.peekToken() == 85) {
                    astNode2 = new EmptyExpression(this.ts.tokenBeg, 1);
                    astNode2.setLineno(this.ts.lineno);
                } else {
                    astNode2 = this.expr(false);
                }
                this.mustMatchToken(85, "msg.no.semi.for.cond", true);
                int n8 = this.ts.tokenEnd;
                if (this.peekToken() == 91) {
                    astNode3 = new EmptyExpression(n8, 1);
                    astNode3.setLineno(this.ts.lineno);
                } else {
                    astNode3 = this.expr(false);
                }
            }
            if (this.mustMatchToken(91, "msg.no.paren.for.ctrl", true)) {
                n6 = this.ts.tokenBeg - n;
            }
            if (bl2 || bl3) {
                astNode4 = new ForInLoop(n);
                if (astNode instanceof VariableDeclaration && ((VariableDeclaration)astNode).getVariables().size() > 1) {
                    this.reportError("msg.mult.index");
                }
                if (bl3 && bl) {
                    this.reportError("msg.invalid.for.each");
                }
                astNode4.setIterator(astNode);
                astNode4.setIteratedObject(astNode2);
                astNode4.setInPosition(n4);
                astNode4.setIsForEach(bl);
                astNode4.setEachPosition(n3);
                astNode4.setIsForOf(bl3);
                loop = astNode4;
            } else {
                astNode4 = new ForLoop(n);
                ((ForLoop)astNode4).setInitializer(astNode);
                ((ForLoop)astNode4).setCondition(astNode2);
                ((ForLoop)astNode4).setIncrement(astNode3);
                loop = astNode4;
            }
            this.currentScope.replaceWith(loop);
            this.popScope();
            this.enterLoop(loop);
            try {
                astNode4 = this.getNextStatementAfterInlineComments(loop);
                loop.setLength(Parser.getNodeEnd(astNode4) - n);
                this.restoreRelativeLoopPosition(loop);
                loop.setBody(astNode4);
            }
            finally {
                this.exitLoop();
            }
        }
        finally {
            if (this.currentScope == scope) {
                this.popScope();
            }
        }
        loop.setParens(n5, n6);
        loop.setLineno(n2);
        return loop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode forLoopInit(int n) throws IOException {
        try {
            this.inForInit = true;
            AstNode astNode = null;
            if (n == 85) {
                astNode = new EmptyExpression(this.ts.tokenBeg, 1);
                astNode.setLineno(this.ts.lineno);
            } else if (n == 126 || n == 157) {
                this.consumeToken();
                astNode = this.variables(n, this.ts.tokenBeg, false);
            } else {
                astNode = this.expr(false);
            }
            AstNode astNode2 = astNode;
            return astNode2;
        }
        finally {
            this.inForInit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TryStatement tryStatement() throws IOException {
        AstNode astNode;
        AstNode astNode2;
        if (this.currentToken != 84) {
            this.codeBug();
        }
        this.consumeToken();
        Comment comment = this.getAndResetJsDoc();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        int n3 = -1;
        TryStatement tryStatement = new TryStatement(n);
        int n4 = this.peekToken();
        while (n4 == 165) {
            astNode2 = this.scannedComments.get(this.scannedComments.size() - 1);
            tryStatement.setInlineComment(astNode2);
            this.consumeToken();
            n4 = this.peekToken();
        }
        if (n4 != 88) {
            this.reportError("msg.no.brace.try");
        }
        astNode2 = this.getNextStatementAfterInlineComments(tryStatement);
        int n5 = Parser.getNodeEnd(astNode2);
        ArrayList<Object> arrayList = null;
        boolean bl = false;
        int n6 = this.peekToken();
        while (n6 == 165) {
            astNode = this.scannedComments.get(this.scannedComments.size() - 1);
            tryStatement.setInlineComment(astNode);
            this.consumeToken();
            n6 = this.peekToken();
        }
        if (n6 == 128) {
            while (this.matchToken(128, true)) {
                Object object;
                AstNode astNode3;
                int n7 = this.ts.lineno;
                if (bl) {
                    this.reportError("msg.catch.unreachable");
                }
                int n8 = this.ts.tokenBeg;
                int n9 = -1;
                int n10 = -1;
                int n11 = -1;
                Name name = null;
                AstNode astNode4 = null;
                switch (this.peekToken()) {
                    case 90: {
                        this.matchToken(90, true);
                        n9 = this.ts.tokenBeg;
                        this.mustMatchToken(39, "msg.bad.catchcond", true);
                        name = this.createNameNode();
                        astNode3 = this.getAndResetJsDoc();
                        if (astNode3 != null) {
                            name.setJsDocNode((Comment)astNode3);
                        }
                        object = name.getIdentifier();
                        if (this.inUseStrictDirective && ("eval".equals(object) || "arguments".equals(object))) {
                            this.reportError("msg.bad.id.strict", (String)object);
                        }
                        if (this.matchToken(116, true)) {
                            n11 = this.ts.tokenBeg;
                            astNode4 = this.expr(false);
                        } else {
                            bl = true;
                        }
                        if (this.mustMatchToken(91, "msg.bad.catchcond", true)) {
                            n10 = this.ts.tokenBeg;
                        }
                        this.mustMatchToken(88, "msg.no.brace.catchblock", true);
                        break;
                    }
                    case 88: {
                        if (this.compilerEnv.getLanguageVersion() >= 200) {
                            this.matchToken(88, true);
                            break;
                        }
                        this.reportError("msg.no.paren.catch");
                        break;
                    }
                    default: {
                        this.reportError("msg.no.paren.catch");
                    }
                }
                astNode3 = new Scope(n8);
                object = new CatchClause(n8);
                ((Node)object).setLineno(this.ts.lineno);
                this.pushScope((Scope)astNode3);
                try {
                    this.statements(astNode3);
                }
                finally {
                    this.popScope();
                }
                n5 = Parser.getNodeEnd(astNode3);
                ((CatchClause)object).setVarName(name);
                ((CatchClause)object).setCatchCondition(astNode4);
                ((CatchClause)object).setBody((Scope)astNode3);
                if (n11 != -1) {
                    ((CatchClause)object).setIfPosition(n11 - n8);
                }
                ((CatchClause)object).setParens(n9, n10);
                ((Node)object).setLineno(n7);
                if (this.mustMatchToken(89, "msg.no.brace.after.body", true)) {
                    n5 = this.ts.tokenEnd;
                }
                ((AstNode)object).setLength(n5 - n8);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(object);
            }
        } else if (n6 != 129) {
            this.mustMatchToken(129, "msg.try.no.catchfinally", true);
        }
        astNode = null;
        if (this.matchToken(129, true)) {
            n3 = this.ts.tokenBeg;
            astNode = this.statement();
            n5 = Parser.getNodeEnd(astNode);
        }
        tryStatement.setLength(n5 - n);
        tryStatement.setTryBlock(astNode2);
        tryStatement.setCatchClauses(arrayList);
        tryStatement.setFinallyBlock(astNode);
        if (n3 != -1) {
            tryStatement.setFinallyPosition(n3 - n);
        }
        tryStatement.setLineno(n2);
        if (comment != null) {
            tryStatement.setJsDocNode(comment);
        }
        return tryStatement;
    }

    private ThrowStatement throwStatement() throws IOException {
        if (this.currentToken != 50) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        if (this.peekTokenOrEOL() == 1) {
            this.reportError("msg.bad.throw.eol");
        }
        AstNode astNode = this.expr(false);
        ThrowStatement throwStatement = new ThrowStatement(n, astNode);
        throwStatement.setLineno(n2);
        return throwStatement;
    }

    private LabeledStatement matchJumpLabelName() throws IOException {
        LabeledStatement labeledStatement = null;
        if (this.peekTokenOrEOL() == 39) {
            this.consumeToken();
            if (this.labelSet != null) {
                labeledStatement = this.labelSet.get(this.ts.getString());
            }
            if (labeledStatement == null) {
                this.reportError("msg.undef.label");
            }
        }
        return labeledStatement;
    }

    private BreakStatement breakStatement() throws IOException {
        LabeledStatement labeledStatement;
        Jump jump;
        if (this.currentToken != 124) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.tokenEnd;
        Name name = null;
        if (this.peekTokenOrEOL() == 39) {
            name = this.createNameNode();
            n3 = Parser.getNodeEnd(name);
        }
        Label label = jump = (labeledStatement = this.matchJumpLabelName()) == null ? null : labeledStatement.getFirstLabel();
        if (jump == null && name == null) {
            if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                this.reportError("msg.bad.break", n2, n3 - n2);
            } else {
                jump = this.loopAndSwitchSet.get(this.loopAndSwitchSet.size() - 1);
            }
        }
        BreakStatement breakStatement = new BreakStatement(n2, n3 - n2);
        breakStatement.setBreakLabel(name);
        if (jump != null) {
            breakStatement.setBreakTarget(jump);
        }
        breakStatement.setLineno(n);
        return breakStatement;
    }

    private ContinueStatement continueStatement() throws IOException {
        if (this.currentToken != 125) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = this.ts.tokenEnd;
        Name name = null;
        if (this.peekTokenOrEOL() == 39) {
            name = this.createNameNode();
            n3 = Parser.getNodeEnd(name);
        }
        LabeledStatement labeledStatement = this.matchJumpLabelName();
        Loop loop = null;
        if (labeledStatement == null && name == null) {
            if (this.loopSet == null || this.loopSet.size() == 0) {
                this.reportError("msg.continue.outside");
            } else {
                loop = this.loopSet.get(this.loopSet.size() - 1);
            }
        } else {
            if (labeledStatement == null || !(labeledStatement.getStatement() instanceof Loop)) {
                this.reportError("msg.continue.nonloop", n2, n3 - n2);
            }
            loop = labeledStatement == null ? null : (Loop)labeledStatement.getStatement();
        }
        ContinueStatement continueStatement = new ContinueStatement(n2, n3 - n2);
        if (loop != null) {
            continueStatement.setTarget(loop);
        }
        continueStatement.setLabel(name);
        continueStatement.setLineno(n);
        return continueStatement;
    }

    private WithStatement withStatement() throws IOException {
        if (this.currentToken != 127) {
            this.codeBug();
        }
        this.consumeToken();
        Comment comment = this.getAndResetJsDoc();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        int n3 = -1;
        int n4 = -1;
        if (this.mustMatchToken(90, "msg.no.paren.with", true)) {
            n3 = this.ts.tokenBeg;
        }
        AstNode astNode = this.expr(false);
        if (this.mustMatchToken(91, "msg.no.paren.after.with", true)) {
            n4 = this.ts.tokenBeg;
        }
        WithStatement withStatement = new WithStatement(n2);
        AstNode astNode2 = this.getNextStatementAfterInlineComments(withStatement);
        withStatement.setLength(Parser.getNodeEnd(astNode2) - n2);
        withStatement.setJsDocNode(comment);
        withStatement.setExpression(astNode);
        withStatement.setStatement(astNode2);
        withStatement.setParens(n3, n4);
        withStatement.setLineno(n);
        return withStatement;
    }

    private AstNode letStatement() throws IOException {
        if (this.currentToken != 157) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        AstNode astNode = this.peekToken() == 90 ? this.let(true, n2) : this.variables(157, n2, true);
        astNode.setLineno(n);
        return astNode;
    }

    private static final boolean nowAllSet(int n, int n2, int n3) {
        return (n & n3) != n3 && (n2 & n3) == n3;
    }

    private AstNode returnOrYield(int n, boolean bl) throws IOException {
        FunctionNode functionNode;
        AstNode astNode;
        if (!this.insideFunction()) {
            this.reportError(n == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        int n2 = this.ts.lineno;
        int n3 = this.ts.tokenBeg;
        int n4 = this.ts.tokenEnd;
        boolean bl2 = false;
        if (n == 73 && this.compilerEnv.getLanguageVersion() >= 200 && this.peekToken() == 23) {
            bl2 = true;
            this.consumeToken();
        }
        AstNode astNode2 = null;
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 85: 
            case 87: 
            case 89: 
            case 91: {
                break;
            }
            case 73: {
                if (this.compilerEnv.getLanguageVersion() < 200) break;
            }
            default: {
                astNode2 = this.expr(false);
                n4 = Parser.getNodeEnd(astNode2);
            }
        }
        int n5 = this.endFlags;
        if (n == 4) {
            this.endFlags |= astNode2 == null ? 2 : 4;
            astNode = new ReturnStatement(n3, n4 - n3, astNode2);
            if (Parser.nowAllSet(n5, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "", n3, n4 - n3);
            }
        } else {
            if (!this.insideFunction()) {
                this.reportError("msg.bad.yield");
            }
            this.endFlags |= 8;
            astNode = new Yield(n3, n4 - n3, astNode2, bl2);
            this.setRequiresActivation();
            this.setIsGenerator();
            if (!bl) {
                astNode = new ExpressionStatement(astNode);
            }
        }
        if (this.insideFunction() && Parser.nowAllSet(n5, this.endFlags, 12) && !(functionNode = (FunctionNode)this.currentScriptOrFn).isES6Generator()) {
            Name name = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (name == null || name.length() == 0) {
                this.addError("msg.anon.generator.returns", "");
            } else {
                this.addError("msg.generator.returns", name.getIdentifier());
            }
        }
        astNode.setLineno(n2);
        return astNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode block() throws IOException {
        if (this.currentToken != 88) {
            this.codeBug();
        }
        this.consumeToken();
        int n = this.ts.tokenBeg;
        Scope scope = new Scope(n);
        scope.setLineno(this.ts.lineno);
        this.pushScope(scope);
        try {
            this.statements(scope);
            this.mustMatchToken(89, "msg.no.brace.block", true);
            scope.setLength(this.ts.tokenEnd - n);
            Scope scope2 = scope;
            return scope2;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode defaultXmlNamespace() throws IOException {
        if (this.currentToken != 120) {
            this.codeBug();
        }
        this.consumeToken();
        this.mustHaveXML();
        this.setRequiresActivation();
        int n = this.ts.lineno;
        int n2 = this.ts.tokenBeg;
        if (!this.matchToken(39, true) || !"xml".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(39, true) || !"namespace".equals(this.ts.getString())) {
            this.reportError("msg.bad.namespace");
        }
        if (!this.matchToken(93, true)) {
            this.reportError("msg.bad.namespace");
        }
        AstNode astNode = this.expr(false);
        UnaryExpression unaryExpression = new UnaryExpression(n2, Parser.getNodeEnd(astNode) - n2);
        unaryExpression.setOperator(76);
        unaryExpression.setOperand(astNode);
        unaryExpression.setLineno(n);
        ExpressionStatement expressionStatement = new ExpressionStatement(unaryExpression, true);
        return expressionStatement;
    }

    private void recordLabel(Label label, LabeledStatement labeledStatement) throws IOException {
        if (this.peekToken() != 107) {
            this.codeBug();
        }
        this.consumeToken();
        String string = label.getName();
        if (this.labelSet == null) {
            this.labelSet = new HashMap<String, LabeledStatement>();
        } else {
            LabeledStatement labeledStatement2 = this.labelSet.get(string);
            if (labeledStatement2 != null) {
                if (this.compilerEnv.isIdeMode()) {
                    Label label2 = labeledStatement2.getLabelByName(string);
                    this.reportError("msg.dup.label", label2.getAbsolutePosition(), label2.getLength());
                }
                this.reportError("msg.dup.label", label.getPosition(), label.getLength());
            }
        }
        labeledStatement.addLabel(label);
        this.labelSet.put(string, labeledStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode nameOrLabel() throws IOException {
        if (this.currentToken != 39) {
            throw this.codeBug();
        }
        int n = this.ts.tokenBeg;
        this.currentFlaggedToken |= 0x20000;
        AstNode astNode = this.expr(false);
        if (astNode.getType() != 134) {
            ExpressionStatement expressionStatement = new ExpressionStatement(astNode, !this.insideFunction());
            expressionStatement.lineno = astNode.lineno;
            return expressionStatement;
        }
        LabeledStatement labeledStatement = new LabeledStatement(n);
        this.recordLabel((Label)astNode, labeledStatement);
        labeledStatement.setLineno(this.ts.lineno);
        AstNode astNode2 = null;
        while (this.peekToken() == 39) {
            this.currentFlaggedToken |= 0x20000;
            astNode = this.expr(false);
            if (astNode.getType() != 134) {
                astNode2 = new ExpressionStatement(astNode, !this.insideFunction());
                this.autoInsertSemicolon(astNode2);
                break;
            }
            this.recordLabel((Label)astNode, labeledStatement);
        }
        try {
            this.currentLabel = labeledStatement;
            if (astNode2 == null) {
                astNode2 = this.statementHelper();
                int n2 = this.peekToken();
                if (n2 == 165 && astNode2.getLineno() == this.scannedComments.get(this.scannedComments.size() - 1).getLineno()) {
                    astNode2.setInlineComment(this.scannedComments.get(this.scannedComments.size() - 1));
                    this.consumeToken();
                }
            }
        }
        finally {
            this.currentLabel = null;
            for (Label label : labeledStatement.getLabels()) {
                this.labelSet.remove(label.getName());
            }
        }
        labeledStatement.setLength(astNode2.getParent() == null ? Parser.getNodeEnd(astNode2) - n : Parser.getNodeEnd(astNode2));
        labeledStatement.setStatement(astNode2);
        return labeledStatement;
    }

    private VariableDeclaration variables(int n, int n2, boolean bl) throws IOException {
        int n3;
        VariableDeclaration variableDeclaration = new VariableDeclaration(n2);
        variableDeclaration.setType(n);
        variableDeclaration.setLineno(this.ts.lineno);
        Comment comment = this.getAndResetJsDoc();
        if (comment != null) {
            variableDeclaration.setJsDocNode(comment);
        }
        do {
            AstNode astNode = null;
            Name name = null;
            int n4 = this.peekToken();
            int n5 = this.ts.tokenBeg;
            n3 = this.ts.tokenEnd;
            if (n4 == 86 || n4 == 88) {
                astNode = this.destructuringPrimaryExpr();
                n3 = Parser.getNodeEnd(astNode);
                if (!(astNode instanceof DestructuringForm)) {
                    this.reportError("msg.bad.assign.left", n5, n3 - n5);
                }
                this.markDestructuring(astNode);
            } else {
                String string;
                this.mustMatchToken(39, "msg.bad.var", true);
                name = this.createNameNode();
                name.setLineno(this.ts.getLineno());
                if (this.inUseStrictDirective && ("eval".equals(string = this.ts.getString()) || "arguments".equals(this.ts.getString()))) {
                    this.reportError("msg.bad.id.strict", string);
                }
                this.defineSymbol(n, this.ts.getString(), this.inForInit);
            }
            int n6 = this.ts.lineno;
            Comment comment2 = this.getAndResetJsDoc();
            AstNode astNode2 = null;
            if (this.matchToken(93, true)) {
                astNode2 = this.assignExpr();
                n3 = Parser.getNodeEnd(astNode2);
            }
            VariableInitializer variableInitializer = new VariableInitializer(n5, n3 - n5);
            if (astNode != null) {
                if (astNode2 == null && !this.inForInit) {
                    this.reportError("msg.destruct.assign.no.init");
                }
                variableInitializer.setTarget(astNode);
            } else {
                variableInitializer.setTarget(name);
            }
            variableInitializer.setInitializer(astNode2);
            variableInitializer.setType(n);
            variableInitializer.setJsDocNode(comment2);
            variableInitializer.setLineno(n6);
            variableDeclaration.addVariable(variableInitializer);
        } while (this.matchToken(92, true));
        variableDeclaration.setLength(n3 - n2);
        variableDeclaration.setIsStatement(bl);
        return variableDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode let(boolean bl, int n) throws IOException {
        LetNode letNode = new LetNode(n);
        letNode.setLineno(this.ts.lineno);
        if (this.mustMatchToken(90, "msg.no.paren.after.let", true)) {
            letNode.setLp(this.ts.tokenBeg - n);
        }
        this.pushScope(letNode);
        try {
            VariableDeclaration variableDeclaration = this.variables(157, this.ts.tokenBeg, bl);
            letNode.setVariables(variableDeclaration);
            if (this.mustMatchToken(91, "msg.no.paren.let", true)) {
                letNode.setRp(this.ts.tokenBeg - n);
            }
            if (bl && this.peekToken() == 88) {
                this.consumeToken();
                int n2 = this.ts.tokenBeg;
                AstNode astNode = this.statements();
                this.mustMatchToken(89, "msg.no.curly.let", true);
                astNode.setLength(this.ts.tokenEnd - n2);
                letNode.setLength(this.ts.tokenEnd - n);
                letNode.setBody(astNode);
                letNode.setType(157);
            } else {
                AstNode astNode = this.expr(false);
                letNode.setLength(Parser.getNodeEnd(astNode) - n);
                letNode.setBody(astNode);
                if (bl) {
                    ExpressionStatement expressionStatement = new ExpressionStatement(letNode, !this.insideFunction());
                    expressionStatement.setLineno(letNode.getLineno());
                    ExpressionStatement expressionStatement2 = expressionStatement;
                    return expressionStatement2;
                }
            }
        }
        finally {
            this.popScope();
        }
        return letNode;
    }

    void defineSymbol(int n, String string) {
        this.defineSymbol(n, string, false);
    }

    void defineSymbol(int n, String string, boolean bl) {
        int n2;
        Scope scope;
        if (string == null) {
            if (this.compilerEnv.isIdeMode()) {
                return;
            }
            this.codeBug();
        }
        Symbol symbol = (scope = this.currentScope.getDefiningScope(string)) != null ? scope.getSymbol(string) : null;
        int n3 = n2 = symbol != null ? symbol.getDeclType() : -1;
        if (symbol != null && (n2 == 158 || n == 158 || scope == this.currentScope && n2 == 157)) {
            this.addError(n2 == 158 ? "msg.const.redecl" : (n2 == 157 ? "msg.let.redecl" : (n2 == 126 ? "msg.var.redecl" : (n2 == 113 ? "msg.fn.redecl" : "msg.parm.redecl"))), string);
            return;
        }
        switch (n) {
            case 157: {
                if (!bl && (this.currentScope.getType() == 116 || this.currentScope instanceof Loop)) {
                    this.addError("msg.let.decl.not.in.block");
                    return;
                }
                this.currentScope.putSymbol(new Symbol(n, string));
                return;
            }
            case 113: 
            case 126: 
            case 158: {
                if (symbol != null) {
                    if (n2 == 126) {
                        this.addStrictWarning("msg.var.redecl", string);
                    } else if (n2 == 90) {
                        this.addStrictWarning("msg.var.hides.arg", string);
                    }
                } else {
                    this.currentScriptOrFn.putSymbol(new Symbol(n, string));
                }
                return;
            }
            case 90: {
                if (symbol != null) {
                    this.addWarning("msg.dup.parms", string);
                }
                this.currentScriptOrFn.putSymbol(new Symbol(n, string));
                return;
            }
        }
        throw this.codeBug();
    }

    private AstNode expr(boolean bl) throws IOException {
        AstNode astNode = this.assignExpr();
        int n = astNode.getPosition();
        while (this.matchToken(92, true)) {
            int n2 = this.ts.tokenBeg;
            if (this.compilerEnv.isStrictMode() && !astNode.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "", n, Parser.nodeEnd(astNode) - n);
            }
            if (this.peekToken() == 73) {
                this.reportError("msg.yield.parenthesized");
            }
            if (bl && this.peekToken() == 91) {
                astNode.putIntProp(29, 1);
                return astNode;
            }
            astNode = new InfixExpression(92, astNode, this.assignExpr(), n2);
        }
        return astNode;
    }

    private AstNode assignExpr() throws IOException {
        int n = this.peekToken();
        if (n == 73) {
            return this.returnOrYield(n, true);
        }
        AstNode astNode = this.condExpr();
        boolean bl = false;
        n = this.peekTokenOrEOL();
        if (n == 1) {
            bl = true;
            n = this.peekToken();
        }
        if (93 <= n && n <= 105) {
            if (this.inDestructuringAssignment) {
                this.reportError("msg.destruct.default.vals");
            }
            this.consumeToken();
            Comment comment = this.getAndResetJsDoc();
            this.markDestructuring(astNode);
            int n2 = this.ts.tokenBeg;
            astNode = new Assignment(n, astNode, this.assignExpr(), n2);
            if (comment != null) {
                astNode.setJsDocNode(comment);
            }
        } else if (n == 85) {
            if (this.currentJsDocComment != null) {
                astNode.setJsDocNode(this.getAndResetJsDoc());
            }
        } else if (!bl && n == 168) {
            this.consumeToken();
            astNode = this.arrowFunction(astNode);
        }
        return astNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode condExpr() throws IOException {
        AstNode astNode = this.orExpr();
        if (this.matchToken(106, true)) {
            AstNode astNode2;
            int n = this.ts.lineno;
            int n2 = this.ts.tokenBeg;
            int n3 = -1;
            boolean bl = this.inForInit;
            this.inForInit = false;
            try {
                astNode2 = this.assignExpr();
            }
            finally {
                this.inForInit = bl;
            }
            if (this.mustMatchToken(107, "msg.no.colon.cond", true)) {
                n3 = this.ts.tokenBeg;
            }
            AstNode astNode3 = this.assignExpr();
            int n4 = astNode.getPosition();
            int n5 = Parser.getNodeEnd(astNode3) - n4;
            ConditionalExpression conditionalExpression = new ConditionalExpression(n4, n5);
            conditionalExpression.setLineno(n);
            conditionalExpression.setTestExpression(astNode);
            conditionalExpression.setTrueExpression(astNode2);
            conditionalExpression.setFalseExpression(astNode3);
            conditionalExpression.setQuestionMarkPosition(n2 - n4);
            conditionalExpression.setColonPosition(n3 - n4);
            astNode = conditionalExpression;
        }
        return astNode;
    }

    private AstNode orExpr() throws IOException {
        AstNode astNode = this.andExpr();
        if (this.matchToken(108, true)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(108, astNode, this.orExpr(), n);
        }
        return astNode;
    }

    private AstNode andExpr() throws IOException {
        AstNode astNode = this.bitOrExpr();
        if (this.matchToken(109, true)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(109, astNode, this.andExpr(), n);
        }
        return astNode;
    }

    private AstNode bitOrExpr() throws IOException {
        AstNode astNode = this.bitXorExpr();
        while (this.matchToken(9, true)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(9, astNode, this.bitXorExpr(), n);
        }
        return astNode;
    }

    private AstNode bitXorExpr() throws IOException {
        AstNode astNode = this.bitAndExpr();
        while (this.matchToken(10, true)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(10, astNode, this.bitAndExpr(), n);
        }
        return astNode;
    }

    private AstNode bitAndExpr() throws IOException {
        AstNode astNode = this.eqExpr();
        while (this.matchToken(11, true)) {
            int n = this.ts.tokenBeg;
            astNode = new InfixExpression(11, astNode, this.eqExpr(), n);
        }
        return astNode;
    }

    private AstNode eqExpr() throws IOException {
        AstNode astNode = this.relExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                case 12: 
                case 13: 
                case 46: 
                case 47: {
                    this.consumeToken();
                    int n3 = n;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        if (n == 12) {
                            n3 = 46;
                        } else if (n == 13) {
                            n3 = 47;
                        }
                    }
                    astNode = new InfixExpression(n3, astNode, this.relExpr(), n2);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode relExpr() throws IOException {
        AstNode astNode = this.shiftExpr();
        block4: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                case 52: {
                    if (this.inForInit) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 53: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.shiftExpr(), n2);
                    continue block4;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode shiftExpr() throws IOException {
        AstNode astNode = this.addExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.addExpr(), n2);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode addExpr() throws IOException {
        AstNode astNode = this.mulExpr();
        while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            if (n != 21 && n != 22) break;
            this.consumeToken();
            astNode = new InfixExpression(n, astNode, this.mulExpr(), n2);
        }
        return astNode;
    }

    private AstNode mulExpr() throws IOException {
        AstNode astNode = this.expExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.expExpr(), n2);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode expExpr() throws IOException {
        AstNode astNode = this.unaryExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.tokenBeg;
            switch (n) {
                case 75: {
                    if (astNode instanceof UnaryExpression) {
                        this.reportError("msg.no.unary.expr.on.left.exp", AstNode.operatorToString(astNode.getType()));
                        return this.makeErrorNode();
                    }
                    this.consumeToken();
                    astNode = new InfixExpression(n, astNode, this.expExpr(), n2);
                    continue block3;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode unaryExpr() throws IOException {
        int n = this.peekToken();
        if (n == 165) {
            this.consumeToken();
            n = this.peekUntilNonComment(n);
        }
        int n2 = this.ts.lineno;
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 130: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(n, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case 21: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(28, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case 22: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(29, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case 110: 
            case 111: {
                this.consumeToken();
                UpdateExpression updateExpression = new UpdateExpression(n, this.ts.tokenBeg, this.memberExpr(true));
                updateExpression.setLineno(n2);
                this.checkBadIncDec(updateExpression);
                return updateExpression;
            }
            case 31: {
                this.consumeToken();
                UnaryExpression unaryExpression = new UnaryExpression(n, this.ts.tokenBeg, this.unaryExpr());
                unaryExpression.setLineno(n2);
                return unaryExpression;
            }
            case -1: {
                this.consumeToken();
                return this.makeErrorNode();
            }
            case 14: {
                if (!this.compilerEnv.isXmlAvailable()) break;
                this.consumeToken();
                return this.memberExprTail(true, this.xmlInitializer());
            }
        }
        AstNode astNode = this.memberExpr(true);
        n = this.peekTokenOrEOL();
        if (n != 110 && n != 111) {
            return astNode;
        }
        this.consumeToken();
        UpdateExpression updateExpression = new UpdateExpression(n, this.ts.tokenBeg, astNode, true);
        updateExpression.setLineno(n2);
        this.checkBadIncDec(updateExpression);
        return updateExpression;
    }

    private AstNode xmlInitializer() throws IOException {
        if (this.currentToken != 14) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.getFirstXMLToken();
        if (n2 != 149 && n2 != 152) {
            this.reportError("msg.syntax");
            return this.makeErrorNode();
        }
        XmlLiteral xmlLiteral = new XmlLiteral(n);
        xmlLiteral.setLineno(this.ts.lineno);
        while (true) {
            switch (n2) {
                case 149: {
                    xmlLiteral.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                    this.mustMatchToken(88, "msg.syntax", true);
                    int n3 = this.ts.tokenBeg;
                    AstNode astNode = this.peekToken() == 89 ? new EmptyExpression(n3, this.ts.tokenEnd - n3) : this.expr(false);
                    this.mustMatchToken(89, "msg.syntax", true);
                    XmlExpression xmlExpression = new XmlExpression(n3, astNode);
                    xmlExpression.setIsXmlAttribute(this.ts.isXMLAttribute());
                    xmlExpression.setLength(this.ts.tokenEnd - n3);
                    xmlLiteral.addFragment(xmlExpression);
                    break;
                }
                case 152: {
                    xmlLiteral.addFragment(new XmlString(this.ts.tokenBeg, this.ts.getString()));
                    return xmlLiteral;
                }
                default: {
                    this.reportError("msg.syntax");
                    return this.makeErrorNode();
                }
            }
            n2 = this.ts.getNextXMLToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AstNode> argumentList() throws IOException {
        if (this.matchToken(91, true)) {
            return null;
        }
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        boolean bl = this.inForInit;
        this.inForInit = false;
        try {
            do {
                if (this.peekToken() == 91) {
                    break;
                }
                if (this.peekToken() == 73) {
                    this.reportError("msg.yield.parenthesized");
                }
                AstNode astNode = this.assignExpr();
                if (this.peekToken() == 123) {
                    try {
                        arrayList.add(this.generatorExpression(astNode, 0, true));
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                arrayList.add(astNode);
            } while (this.matchToken(92, true));
        }
        finally {
            this.inForInit = bl;
        }
        this.mustMatchToken(91, "msg.no.paren.arg", true);
        return arrayList;
    }

    private AstNode memberExpr(boolean bl) throws IOException {
        AstNode astNode;
        int n = this.peekToken();
        int n2 = this.ts.lineno;
        if (n != 30) {
            astNode = this.primaryExpr();
        } else {
            Iterable<AstNode> iterable;
            this.consumeToken();
            int n3 = this.ts.tokenBeg;
            NewExpression newExpression = new NewExpression(n3);
            AstNode astNode2 = this.memberExpr(false);
            int n4 = Parser.getNodeEnd(astNode2);
            newExpression.setTarget(astNode2);
            int n5 = -1;
            if (this.matchToken(90, true)) {
                n5 = this.ts.tokenBeg;
                iterable = this.argumentList();
                if (iterable != null && iterable.size() > 65536) {
                    this.reportError("msg.too.many.constructor.args");
                }
                int n6 = this.ts.tokenBeg;
                n4 = this.ts.tokenEnd;
                if (iterable != null) {
                    newExpression.setArguments((List<AstNode>)iterable);
                }
                newExpression.setParens(n5 - n3, n6 - n3);
            }
            if (this.matchToken(88, true)) {
                iterable = this.objectLiteral();
                n4 = Parser.getNodeEnd(iterable);
                newExpression.setInitializer((ObjectLiteral)iterable);
            }
            newExpression.setLength(n4 - n3);
            astNode = newExpression;
        }
        astNode.setLineno(n2);
        AstNode astNode3 = this.memberExprTail(bl, astNode);
        return astNode3;
    }

    private AstNode memberExprTail(boolean bl, AstNode astNode) throws IOException {
        if (astNode == null) {
            this.codeBug();
        }
        int n = astNode.getPosition();
        block8: while (true) {
            int n2 = this.peekToken();
            switch (n2) {
                case 112: 
                case 147: {
                    int n3 = this.ts.lineno;
                    astNode = this.propertyAccess(n2, astNode);
                    astNode.setLineno(n3);
                    continue block8;
                }
                case 150: {
                    this.consumeToken();
                    int n4 = this.ts.tokenBeg;
                    int n5 = -1;
                    int n3 = this.ts.lineno;
                    this.mustHaveXML();
                    this.setRequiresActivation();
                    AstNode astNode2 = this.expr(false);
                    int n6 = Parser.getNodeEnd(astNode2);
                    if (this.mustMatchToken(91, "msg.no.paren", true)) {
                        n5 = this.ts.tokenBeg;
                        n6 = this.ts.tokenEnd;
                    }
                    XmlDotQuery xmlDotQuery = new XmlDotQuery(n, n6 - n);
                    xmlDotQuery.setLeft(astNode);
                    xmlDotQuery.setRight(astNode2);
                    xmlDotQuery.setOperatorPosition(n4);
                    xmlDotQuery.setRp(n5 - n);
                    xmlDotQuery.setLineno(n3);
                    astNode = xmlDotQuery;
                    continue block8;
                }
                case 86: {
                    this.consumeToken();
                    int n7 = this.ts.tokenBeg;
                    int n8 = -1;
                    int n3 = this.ts.lineno;
                    AstNode astNode3 = this.expr(false);
                    int n6 = Parser.getNodeEnd(astNode3);
                    if (this.mustMatchToken(87, "msg.no.bracket.index", true)) {
                        n8 = this.ts.tokenBeg;
                        n6 = this.ts.tokenEnd;
                    }
                    ElementGet elementGet = new ElementGet(n, n6 - n);
                    elementGet.setTarget(astNode);
                    elementGet.setElement(astNode3);
                    elementGet.setParens(n7, n8);
                    elementGet.setLineno(n3);
                    astNode = elementGet;
                    continue block8;
                }
                case 90: {
                    if (!bl) break block8;
                    int n3 = this.ts.lineno;
                    this.consumeToken();
                    this.checkCallRequiresActivation(astNode);
                    FunctionCall functionCall = new FunctionCall(n);
                    functionCall.setTarget(astNode);
                    functionCall.setLineno(n3);
                    functionCall.setLp(this.ts.tokenBeg - n);
                    List<AstNode> list = this.argumentList();
                    if (list != null && list.size() > 65536) {
                        this.reportError("msg.too.many.function.args");
                    }
                    functionCall.setArguments(list);
                    functionCall.setRp(this.ts.tokenBeg - n);
                    functionCall.setLength(this.ts.tokenEnd - n);
                    astNode = functionCall;
                    continue block8;
                }
                case 165: {
                    int n9 = this.currentFlaggedToken;
                    this.peekUntilNonComment(n2);
                    this.currentFlaggedToken = (this.currentFlaggedToken & 0x10000) != 0 ? this.currentFlaggedToken : n9;
                    continue block8;
                }
                case 170: {
                    this.consumeToken();
                    astNode = this.taggedTemplateLiteral(astNode);
                    continue block8;
                }
            }
            break;
        }
        return astNode;
    }

    private AstNode taggedTemplateLiteral(AstNode astNode) throws IOException {
        AstNode astNode2 = this.templateLiteral(true);
        TaggedTemplateLiteral taggedTemplateLiteral = new TaggedTemplateLiteral();
        taggedTemplateLiteral.setTarget(astNode);
        taggedTemplateLiteral.setTemplateLiteral(astNode2);
        return taggedTemplateLiteral;
    }

    private AstNode propertyAccess(int n, AstNode astNode) throws IOException {
        InfixExpression infixExpression;
        if (astNode == null) {
            this.codeBug();
        }
        int n2 = 0;
        int n3 = this.ts.lineno;
        int n4 = this.ts.tokenBeg;
        this.consumeToken();
        if (n == 147) {
            this.mustHaveXML();
            n2 = 4;
        }
        if (!this.compilerEnv.isXmlAvailable()) {
            int n5 = this.nextToken();
            if (!(n5 == 39 || this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective))) {
                this.reportError("msg.no.name.after.dot");
            }
            Name name = this.createNameNode(true, 33);
            PropertyGet propertyGet = new PropertyGet(astNode, name, n4);
            propertyGet.setLineno(n3);
            return propertyGet;
        }
        AstNode astNode2 = null;
        int n6 = this.nextToken();
        switch (n6) {
            case 50: {
                this.saveNameTokenData(this.ts.tokenBeg, "throw", this.ts.lineno);
                astNode2 = this.propertyName(-1, n2);
                break;
            }
            case 39: {
                astNode2 = this.propertyName(-1, n2);
                break;
            }
            case 23: {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                astNode2 = this.propertyName(-1, n2);
                break;
            }
            case 151: {
                astNode2 = this.attributeAccess();
                break;
            }
            case 131: {
                String string = this.ts.getString();
                this.saveNameTokenData(this.ts.tokenBeg, string, this.ts.lineno);
                astNode2 = this.propertyName(-1, n2);
                break;
            }
            default: {
                String string;
                if (this.compilerEnv.isReservedKeywordAsIdentifier() && (string = Token.keywordToName(n6)) != null) {
                    this.saveNameTokenData(this.ts.tokenBeg, string, this.ts.lineno);
                    astNode2 = this.propertyName(-1, n2);
                    break;
                }
                this.reportError("msg.no.name.after.dot");
                return this.makeErrorNode();
            }
        }
        boolean bl = astNode2 instanceof XmlRef;
        InfixExpression infixExpression2 = infixExpression = bl ? new XmlMemberGet() : new PropertyGet();
        if (bl && n == 112) {
            infixExpression.setType(112);
        }
        int n7 = astNode.getPosition();
        infixExpression.setPosition(n7);
        infixExpression.setLength(Parser.getNodeEnd(astNode2) - n7);
        infixExpression.setOperatorPosition(n4 - n7);
        infixExpression.setLineno(astNode.getLineno());
        infixExpression.setLeft(astNode);
        infixExpression.setRight(astNode2);
        return infixExpression;
    }

    private AstNode attributeAccess() throws IOException {
        int n = this.nextToken();
        int n2 = this.ts.tokenBeg;
        switch (n) {
            case 39: {
                return this.propertyName(n2, 0);
            }
            case 23: {
                this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                return this.propertyName(n2, 0);
            }
            case 86: {
                return this.xmlElemRef(n2, null, -1);
            }
        }
        this.reportError("msg.no.name.after.xmlAttr");
        return this.makeErrorNode();
    }

    private AstNode propertyName(int n, int n2) throws IOException {
        int n3 = n != -1 ? n : this.ts.tokenBeg;
        int n4 = this.ts.lineno;
        int n5 = -1;
        Name name = this.createNameNode(true, this.currentToken);
        Name name2 = null;
        if (this.matchToken(148, true)) {
            name2 = name;
            n5 = this.ts.tokenBeg;
            switch (this.nextToken()) {
                case 39: {
                    name = this.createNameNode();
                    break;
                }
                case 23: {
                    this.saveNameTokenData(this.ts.tokenBeg, "*", this.ts.lineno);
                    name = this.createNameNode(false, -1);
                    break;
                }
                case 86: {
                    return this.xmlElemRef(n, name2, n5);
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    return this.makeErrorNode();
                }
            }
        }
        if (name2 == null && n2 == 0 && n == -1) {
            return name;
        }
        XmlPropRef xmlPropRef = new XmlPropRef(n3, Parser.getNodeEnd(name) - n3);
        xmlPropRef.setAtPos(n);
        xmlPropRef.setNamespace(name2);
        xmlPropRef.setColonPos(n5);
        xmlPropRef.setPropName(name);
        xmlPropRef.setLineno(n4);
        return xmlPropRef;
    }

    private XmlElemRef xmlElemRef(int n, Name name, int n2) throws IOException {
        int n3 = this.ts.tokenBeg;
        int n4 = -1;
        int n5 = n != -1 ? n : n3;
        AstNode astNode = this.expr(false);
        int n6 = Parser.getNodeEnd(astNode);
        if (this.mustMatchToken(87, "msg.no.bracket.index", true)) {
            n4 = this.ts.tokenBeg;
            n6 = this.ts.tokenEnd;
        }
        XmlElemRef xmlElemRef = new XmlElemRef(n5, n6 - n5);
        xmlElemRef.setNamespace(name);
        xmlElemRef.setColonPos(n2);
        xmlElemRef.setAtPos(n);
        xmlElemRef.setExpression(astNode);
        xmlElemRef.setBrackets(n3, n4);
        return xmlElemRef;
    }

    private AstNode destructuringPrimaryExpr() throws IOException, ParserException {
        try {
            this.inDestructuringAssignment = true;
            AstNode astNode = this.primaryExpr();
            return astNode;
        }
        finally {
            this.inDestructuringAssignment = false;
        }
    }

    private AstNode primaryExpr() throws IOException {
        int n = this.peekFlaggedToken();
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 113: {
                this.consumeToken();
                return this.function(2);
            }
            case 86: {
                this.consumeToken();
                return this.arrayLiteral();
            }
            case 88: {
                this.consumeToken();
                return this.objectLiteral();
            }
            case 157: {
                this.consumeToken();
                return this.let(false, this.ts.tokenBeg);
            }
            case 90: {
                this.consumeToken();
                return this.parenExpr();
            }
            case 151: {
                this.consumeToken();
                this.mustHaveXML();
                return this.attributeAccess();
            }
            case 39: {
                this.consumeToken();
                return this.name(n, n2);
            }
            case 40: 
            case 83: {
                this.consumeToken();
                return this.createNumericLiteral(n2, false);
            }
            case 41: {
                this.consumeToken();
                return this.createStringLiteral();
            }
            case 24: 
            case 103: {
                this.consumeToken();
                this.ts.readRegExp(n2);
                int n3 = this.ts.tokenBeg;
                int n4 = this.ts.tokenEnd;
                RegExpLiteral regExpLiteral = new RegExpLiteral(n3, n4 - n3);
                regExpLiteral.setValue(this.ts.getString());
                regExpLiteral.setFlags(this.ts.readAndClearRegExpFlags());
                return regExpLiteral;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.consumeToken();
                int n5 = this.ts.tokenBeg;
                int n6 = this.ts.tokenEnd;
                return new KeywordLiteral(n5, n6 - n5, n2);
            }
            case 170: {
                this.consumeToken();
                return this.templateLiteral(false);
            }
            case 131: {
                this.consumeToken();
                this.reportError("msg.reserved.id", this.ts.getString());
                break;
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 0: {
                this.consumeToken();
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.consumeToken();
                this.reportError("msg.syntax");
            }
        }
        this.consumeToken();
        return this.makeErrorNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AstNode parenExpr() throws IOException {
        boolean bl = this.inForInit;
        this.inForInit = false;
        try {
            boolean bl2;
            AstNode astNode;
            Comment comment = this.getAndResetJsDoc();
            int n = this.ts.lineno;
            int n2 = this.ts.tokenBeg;
            AstNode astNode2 = astNode = this.peekToken() == 91 ? new EmptyExpression(n2) : this.expr(true);
            if (this.peekToken() == 123) {
                AstNode astNode3 = this.generatorExpression(astNode, n2);
                return astNode3;
            }
            this.mustMatchToken(91, "msg.no.paren", true);
            int n3 = this.ts.tokenEnd - n2;
            boolean bl3 = bl2 = astNode.getIntProp(29, 0) == 1;
            if ((bl2 || astNode.getType() == 132) && this.peekToken() != 168) {
                this.reportError("msg.syntax");
                ErrorNode errorNode = this.makeErrorNode();
                return errorNode;
            }
            ParenthesizedExpression parenthesizedExpression = new ParenthesizedExpression(n2, n3, astNode);
            parenthesizedExpression.setLineno(n);
            if (comment == null) {
                comment = this.getAndResetJsDoc();
            }
            if (comment != null) {
                parenthesizedExpression.setJsDocNode(comment);
            }
            if (bl2) {
                parenthesizedExpression.putIntProp(29, 1);
            }
            ParenthesizedExpression parenthesizedExpression2 = parenthesizedExpression;
            return parenthesizedExpression2;
        }
        finally {
            this.inForInit = bl;
        }
    }

    private AstNode name(int n, int n2) throws IOException {
        String string = this.ts.getString();
        int n3 = this.ts.tokenBeg;
        int n4 = this.ts.lineno;
        if (0 != (n & 0x20000) && this.peekToken() == 107) {
            Label label = new Label(n3, this.ts.tokenEnd - n3);
            label.setName(string);
            label.setLineno(this.ts.lineno);
            return label;
        }
        this.saveNameTokenData(n3, string, n4);
        if (this.compilerEnv.isXmlAvailable()) {
            return this.propertyName(-1, 0);
        }
        return this.createNameNode(true, 39);
    }

    private AstNode arrayLiteral() throws IOException {
        if (this.currentToken != 86) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.tokenEnd;
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        ArrayLiteral arrayLiteral = new ArrayLiteral(n);
        boolean bl = true;
        int n3 = -1;
        int n4 = 0;
        while (true) {
            int n5;
            if ((n5 = this.peekToken()) == 92) {
                this.consumeToken();
                n3 = this.ts.tokenEnd;
                if (!bl) {
                    bl = true;
                    continue;
                }
                arrayList.add(new EmptyExpression(this.ts.tokenBeg, 1));
                ++n4;
                continue;
            }
            if (n5 == 165) {
                this.consumeToken();
                continue;
            }
            if (n5 == 87) {
                this.consumeToken();
                n2 = this.ts.tokenEnd;
                arrayLiteral.setDestructuringLength(arrayList.size() + (bl ? 1 : 0));
                arrayLiteral.setSkipCount(n4);
                if (n3 == -1) break;
                this.warnTrailingComma(n, arrayList, n3);
                break;
            }
            if (n5 == 123 && !bl && arrayList.size() == 1) {
                return this.arrayComprehension((AstNode)arrayList.get(0), n);
            }
            if (n5 == 0) {
                this.reportError("msg.no.bracket.arg");
                break;
            }
            if (!bl) {
                this.reportError("msg.no.bracket.arg");
            }
            arrayList.add(this.assignExpr());
            bl = false;
            n3 = -1;
        }
        for (AstNode astNode : arrayList) {
            arrayLiteral.addElement(astNode);
        }
        arrayLiteral.setLength(n2 - n);
        return arrayLiteral;
    }

    private AstNode arrayComprehension(AstNode astNode, int n) throws IOException {
        ArrayList<ArrayComprehensionLoop> arrayList = new ArrayList<ArrayComprehensionLoop>();
        while (this.peekToken() == 123) {
            arrayList.add(this.arrayComprehensionLoop());
        }
        int n2 = -1;
        ConditionData conditionData = null;
        if (this.peekToken() == 116) {
            this.consumeToken();
            n2 = this.ts.tokenBeg - n;
            conditionData = this.condition();
        }
        this.mustMatchToken(87, "msg.no.bracket.arg", true);
        ArrayComprehension arrayComprehension = new ArrayComprehension(n, this.ts.tokenEnd - n);
        arrayComprehension.setResult(astNode);
        arrayComprehension.setLoops(arrayList);
        if (conditionData != null) {
            arrayComprehension.setIfPosition(n2);
            arrayComprehension.setFilter(conditionData.condition);
            arrayComprehension.setFilterLp(conditionData.lp - n);
            arrayComprehension.setFilterRp(conditionData.rp - n);
        }
        return arrayComprehension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayComprehensionLoop arrayComprehensionLoop() throws IOException {
        if (this.nextToken() != 123) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        ArrayComprehensionLoop arrayComprehensionLoop = new ArrayComprehensionLoop(n);
        this.pushScope(arrayComprehensionLoop);
        try {
            if (this.matchToken(39, true)) {
                if (this.ts.getString().equals("each")) {
                    n2 = this.ts.tokenBeg - n;
                } else {
                    this.reportError("msg.no.paren.for");
                }
            }
            if (this.mustMatchToken(90, "msg.no.paren.for", true)) {
                n3 = this.ts.tokenBeg - n;
            }
            AstNode astNode = null;
            switch (this.peekToken()) {
                case 86: 
                case 88: {
                    astNode = this.destructuringPrimaryExpr();
                    this.markDestructuring(astNode);
                    break;
                }
                case 39: {
                    this.consumeToken();
                    astNode = this.createNameNode();
                    break;
                }
                default: {
                    this.reportError("msg.bad.var");
                }
            }
            if (astNode.getType() == 39) {
                this.defineSymbol(157, this.ts.getString(), true);
            }
            switch (this.nextToken()) {
                case 52: {
                    n5 = this.ts.tokenBeg - n;
                    break;
                }
                case 39: {
                    if ("of".equals(this.ts.getString())) {
                        if (n2 != -1) {
                            this.reportError("msg.invalid.for.each");
                        }
                        n5 = this.ts.tokenBeg - n;
                        bl = true;
                        break;
                    }
                }
                default: {
                    this.reportError("msg.in.after.for.name");
                }
            }
            AstNode astNode2 = this.expr(false);
            if (this.mustMatchToken(91, "msg.no.paren.for.ctrl", true)) {
                n4 = this.ts.tokenBeg - n;
            }
            arrayComprehensionLoop.setLength(this.ts.tokenEnd - n);
            arrayComprehensionLoop.setIterator(astNode);
            arrayComprehensionLoop.setIteratedObject(astNode2);
            arrayComprehensionLoop.setInPosition(n5);
            arrayComprehensionLoop.setEachPosition(n2);
            arrayComprehensionLoop.setIsForEach(n2 != -1);
            arrayComprehensionLoop.setParens(n3, n4);
            arrayComprehensionLoop.setIsForOf(bl);
            ArrayComprehensionLoop arrayComprehensionLoop2 = arrayComprehensionLoop;
            return arrayComprehensionLoop2;
        }
        finally {
            this.popScope();
        }
    }

    private AstNode generatorExpression(AstNode astNode, int n) throws IOException {
        return this.generatorExpression(astNode, n, false);
    }

    private AstNode generatorExpression(AstNode astNode, int n, boolean bl) throws IOException {
        ArrayList<GeneratorExpressionLoop> arrayList = new ArrayList<GeneratorExpressionLoop>();
        while (this.peekToken() == 123) {
            arrayList.add(this.generatorExpressionLoop());
        }
        int n2 = -1;
        ConditionData conditionData = null;
        if (this.peekToken() == 116) {
            this.consumeToken();
            n2 = this.ts.tokenBeg - n;
            conditionData = this.condition();
        }
        if (!bl) {
            this.mustMatchToken(91, "msg.no.paren.let", true);
        }
        GeneratorExpression generatorExpression = new GeneratorExpression(n, this.ts.tokenEnd - n);
        generatorExpression.setResult(astNode);
        generatorExpression.setLoops(arrayList);
        if (conditionData != null) {
            generatorExpression.setIfPosition(n2);
            generatorExpression.setFilter(conditionData.condition);
            generatorExpression.setFilterLp(conditionData.lp - n);
            generatorExpression.setFilterRp(conditionData.rp - n);
        }
        return generatorExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GeneratorExpressionLoop generatorExpressionLoop() throws IOException {
        if (this.nextToken() != 123) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        GeneratorExpressionLoop generatorExpressionLoop = new GeneratorExpressionLoop(n);
        this.pushScope(generatorExpressionLoop);
        try {
            if (this.mustMatchToken(90, "msg.no.paren.for", true)) {
                n2 = this.ts.tokenBeg - n;
            }
            AstNode astNode = null;
            switch (this.peekToken()) {
                case 86: 
                case 88: {
                    astNode = this.destructuringPrimaryExpr();
                    this.markDestructuring(astNode);
                    break;
                }
                case 39: {
                    this.consumeToken();
                    astNode = this.createNameNode();
                    break;
                }
                default: {
                    this.reportError("msg.bad.var");
                }
            }
            if (astNode.getType() == 39) {
                this.defineSymbol(157, this.ts.getString(), true);
            }
            if (this.mustMatchToken(52, "msg.in.after.for.name", true)) {
                n4 = this.ts.tokenBeg - n;
            }
            AstNode astNode2 = this.expr(false);
            if (this.mustMatchToken(91, "msg.no.paren.for.ctrl", true)) {
                n3 = this.ts.tokenBeg - n;
            }
            generatorExpressionLoop.setLength(this.ts.tokenEnd - n);
            generatorExpressionLoop.setIterator(astNode);
            generatorExpressionLoop.setIteratedObject(astNode2);
            generatorExpressionLoop.setInPosition(n4);
            generatorExpressionLoop.setParens(n2, n3);
            GeneratorExpressionLoop generatorExpressionLoop2 = generatorExpressionLoop;
            return generatorExpressionLoop2;
        }
        finally {
            this.popScope();
        }
    }

    private ObjectLiteral objectLiteral() throws IOException {
        Object object;
        int n = this.ts.tokenBeg;
        int n2 = this.ts.lineno;
        int n3 = -1;
        ArrayList<ObjectProperty> arrayList = new ArrayList<ObjectProperty>();
        HashSet<Object> hashSet = null;
        HashSet<Object> hashSet2 = null;
        if (this.inUseStrictDirective) {
            hashSet = new HashSet<Object>();
            hashSet2 = new HashSet<Object>();
        }
        Comment comment = this.getAndResetJsDoc();
        while (true) {
            object = null;
            int n4 = 1;
            int n5 = this.peekToken();
            Comment comment2 = this.getAndResetJsDoc();
            if (n5 == 165) {
                this.consumeToken();
                n5 = this.peekUntilNonComment(n5);
            }
            if (n5 == 89) {
                if (n3 == -1) break;
                this.warnTrailingComma(n, arrayList, n3);
                break;
            }
            AstNode astNode = this.objliteralProperty();
            if (astNode == null) {
                this.reportError("msg.bad.prop");
            } else {
                object = this.ts.getString();
                int n6 = this.ts.tokenBeg;
                this.consumeToken();
                int n7 = this.peekToken();
                if (n7 != 92 && n7 != 107 && n7 != 89) {
                    if (n7 == 90) {
                        n4 = 8;
                    } else if (astNode.getType() == 39) {
                        if ("get".equals(object)) {
                            n4 = 2;
                        } else if ("set".equals(object)) {
                            n4 = 4;
                        }
                    }
                    if (n4 == 2 || n4 == 4) {
                        astNode = this.objliteralProperty();
                        if (astNode == null) {
                            this.reportError("msg.bad.prop");
                        }
                        this.consumeToken();
                    }
                    if (astNode == null) {
                        object = null;
                    } else {
                        object = this.ts.getString();
                        ObjectProperty objectProperty = this.methodDefinition(n6, astNode, n4);
                        astNode.setJsDocNode(comment2);
                        arrayList.add(objectProperty);
                    }
                } else {
                    astNode.setJsDocNode(comment2);
                    arrayList.add(this.plainProperty(astNode, n5));
                }
            }
            if (this.inUseStrictDirective && object != null) {
                switch (n4) {
                    case 1: 
                    case 8: {
                        if (hashSet.contains(object) || hashSet2.contains(object)) {
                            this.addError("msg.dup.obj.lit.prop.strict", (String)object);
                        }
                        hashSet.add(object);
                        hashSet2.add(object);
                        break;
                    }
                    case 2: {
                        if (hashSet.contains(object)) {
                            this.addError("msg.dup.obj.lit.prop.strict", (String)object);
                        }
                        hashSet.add(object);
                        break;
                    }
                    case 4: {
                        if (hashSet2.contains(object)) {
                            this.addError("msg.dup.obj.lit.prop.strict", (String)object);
                        }
                        hashSet2.add(object);
                    }
                }
            }
            this.getAndResetJsDoc();
            if (!this.matchToken(92, true)) break;
            n3 = this.ts.tokenEnd;
        }
        this.mustMatchToken(89, "msg.no.brace.prop", true);
        object = new ObjectLiteral(n, this.ts.tokenEnd - n);
        if (comment != null) {
            ((Node)object).setJsDocNode(comment);
        }
        ((ObjectLiteral)object).setElements(arrayList);
        ((Node)object).setLineno(n2);
        return object;
    }

    private AstNode objliteralProperty() throws IOException {
        AstNode astNode;
        int n = this.peekToken();
        switch (n) {
            case 39: {
                astNode = this.createNameNode();
                break;
            }
            case 41: {
                astNode = this.createStringLiteral();
                break;
            }
            case 40: 
            case 83: {
                astNode = this.createNumericLiteral(n, true);
                break;
            }
            default: {
                if (this.compilerEnv.isReservedKeywordAsIdentifier() && TokenStream.isKeyword(this.ts.getString(), this.compilerEnv.getLanguageVersion(), this.inUseStrictDirective)) {
                    astNode = this.createNameNode();
                    break;
                }
                return null;
            }
        }
        return astNode;
    }

    private ObjectProperty plainProperty(AstNode astNode, int n) throws IOException {
        int n2 = this.peekToken();
        if ((n2 == 92 || n2 == 89) && n == 39 && this.compilerEnv.getLanguageVersion() >= 180) {
            if (!this.inDestructuringAssignment && this.compilerEnv.getLanguageVersion() < 200) {
                this.reportError("msg.bad.object.init");
            }
            Name name = new Name(astNode.getPosition(), astNode.getString());
            ObjectProperty objectProperty = new ObjectProperty();
            objectProperty.putProp(26, Boolean.TRUE);
            objectProperty.setLeftAndRight(astNode, name);
            return objectProperty;
        }
        this.mustMatchToken(107, "msg.no.colon.prop", true);
        ObjectProperty objectProperty = new ObjectProperty();
        objectProperty.setOperatorPosition(this.ts.tokenBeg);
        objectProperty.setLeftAndRight(astNode, this.assignExpr());
        return objectProperty;
    }

    private ObjectProperty methodDefinition(int n, AstNode astNode, int n2) throws IOException {
        FunctionNode functionNode = this.function(2);
        Name name = functionNode.getFunctionName();
        if (name != null && name.length() != 0) {
            this.reportError("msg.bad.prop");
        }
        ObjectProperty objectProperty = new ObjectProperty(n);
        switch (n2) {
            case 2: {
                objectProperty.setIsGetterMethod();
                functionNode.setFunctionIsGetterMethod();
                break;
            }
            case 4: {
                objectProperty.setIsSetterMethod();
                functionNode.setFunctionIsSetterMethod();
                break;
            }
            case 8: {
                objectProperty.setIsNormalMethod();
                functionNode.setFunctionIsNormalMethod();
            }
        }
        int n3 = Parser.getNodeEnd(functionNode);
        objectProperty.setLeft(astNode);
        objectProperty.setRight(functionNode);
        objectProperty.setLength(n3 - n);
        return objectProperty;
    }

    private Name createNameNode() {
        return this.createNameNode(false, 39);
    }

    private Name createNameNode(boolean bl, int n) {
        int n2 = this.ts.tokenBeg;
        String string = this.ts.getString();
        int n3 = this.ts.lineno;
        if (!"".equals(this.prevNameTokenString)) {
            n2 = this.prevNameTokenStart;
            string = this.prevNameTokenString;
            n3 = this.prevNameTokenLineno;
            this.prevNameTokenStart = 0;
            this.prevNameTokenString = "";
            this.prevNameTokenLineno = 0;
        }
        if (string == null) {
            if (this.compilerEnv.isIdeMode()) {
                string = "";
            } else {
                this.codeBug();
            }
        }
        Name name = new Name(n2, string);
        name.setLineno(n3);
        if (bl) {
            this.checkActivationName(string, n);
        }
        return name;
    }

    private StringLiteral createStringLiteral() {
        int n = this.ts.tokenBeg;
        int n2 = this.ts.tokenEnd;
        StringLiteral stringLiteral = new StringLiteral(n, n2 - n);
        stringLiteral.setLineno(this.ts.lineno);
        stringLiteral.setValue(this.ts.getString());
        stringLiteral.setQuoteCharacter(this.ts.getQuoteChar());
        return stringLiteral;
    }

    private AstNode templateLiteral(boolean bl) throws IOException {
        if (this.currentToken != 170) {
            this.codeBug();
        }
        int n = this.ts.tokenBeg;
        int n2 = this.ts.tokenEnd;
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        TemplateLiteral templateLiteral = new TemplateLiteral(n);
        int n3 = this.ts.tokenBeg + 1;
        int n4 = this.ts.readTemplateLiteral(bl);
        while (n4 == 172) {
            arrayList.add(this.createTemplateLiteralCharacters(n3));
            arrayList.add(this.expr(false));
            this.mustMatchToken(89, "msg.syntax", true);
            n3 = this.ts.tokenBeg + 1;
            n4 = this.ts.readTemplateLiteral(bl);
        }
        if (n4 == -1) {
            return this.makeErrorNode();
        }
        assert (n4 == 170);
        arrayList.add(this.createTemplateLiteralCharacters(n3));
        n2 = this.ts.tokenEnd;
        templateLiteral.setElements(arrayList);
        templateLiteral.setLength(n2 - n);
        return templateLiteral;
    }

    private TemplateCharacters createTemplateLiteralCharacters(int n) {
        TemplateCharacters templateCharacters = new TemplateCharacters(n, this.ts.tokenEnd - n - 1);
        templateCharacters.setValue(this.ts.getString());
        templateCharacters.setRawValue(this.ts.getRawString());
        return templateCharacters;
    }

    private AstNode createNumericLiteral(int n, boolean bl) {
        String string = this.ts.getString();
        if (this.inUseStrictDirective && this.ts.isNumericOldOctal() && (this.compilerEnv.getLanguageVersion() >= 200 || !bl)) {
            if (n == 83) {
                this.reportError("msg.no.old.octal.bigint");
            } else {
                this.reportError("msg.no.old.octal.strict");
            }
        }
        if (this.compilerEnv.getLanguageVersion() >= 200 || !bl) {
            if (this.ts.isNumericBinary()) {
                string = "0b" + string;
            } else if (this.ts.isNumericOldOctal()) {
                string = "0" + string;
            } else if (this.ts.isNumericOctal()) {
                string = "0o" + string;
            } else if (this.ts.isNumericHex()) {
                string = "0x" + string;
            }
        }
        if (n == 83) {
            return new BigIntLiteral(this.ts.tokenBeg, string + "n", this.ts.getBigInt());
        }
        return new NumberLiteral(this.ts.tokenBeg, string, this.ts.getNumber());
    }

    protected void checkActivationName(String string, int n) {
        if (!this.insideFunction()) {
            return;
        }
        boolean bl = false;
        if ("arguments".equals(string) && ((FunctionNode)this.currentScriptOrFn).getFunctionType() != 4) {
            bl = true;
        } else if (this.compilerEnv.getActivationNames() != null && this.compilerEnv.getActivationNames().contains(string)) {
            bl = true;
        } else if ("length".equals(string) && n == 33 && this.compilerEnv.getLanguageVersion() == 120) {
            bl = true;
        }
        if (bl) {
            this.setRequiresActivation();
        }
    }

    protected void setRequiresActivation() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setRequiresActivation();
        }
    }

    private void checkCallRequiresActivation(AstNode astNode) {
        if (astNode.getType() == 39 && "eval".equals(((Name)astNode).getIdentifier()) || astNode.getType() == 33 && "eval".equals(((PropertyGet)astNode).getProperty().getIdentifier())) {
            this.setRequiresActivation();
        }
    }

    protected void setIsGenerator() {
        if (this.insideFunction()) {
            ((FunctionNode)this.currentScriptOrFn).setIsGenerator();
        }
    }

    private void checkBadIncDec(UpdateExpression updateExpression) {
        AstNode astNode = this.removeParens(updateExpression.getOperand());
        int n = astNode.getType();
        if (n != 39 && n != 33 && n != 36 && n != 68 && n != 38) {
            this.reportError(updateExpression.getType() == 110 ? "msg.bad.incr" : "msg.bad.decr");
        }
    }

    private ErrorNode makeErrorNode() {
        ErrorNode errorNode = new ErrorNode(this.ts.tokenBeg, this.ts.tokenEnd - this.ts.tokenBeg);
        errorNode.setLineno(this.ts.lineno);
        return errorNode;
    }

    private static int nodeEnd(AstNode astNode) {
        return astNode.getPosition() + astNode.getLength();
    }

    private void saveNameTokenData(int n, String string, int n2) {
        this.prevNameTokenStart = n;
        this.prevNameTokenString = string;
        this.prevNameTokenLineno = n2;
    }

    private int lineBeginningFor(int n) {
        if (this.sourceChars == null) {
            return -1;
        }
        if (n <= 0) {
            return 0;
        }
        char[] cArray = this.sourceChars;
        if (n >= cArray.length) {
            n = cArray.length - 1;
        }
        while (--n >= 0) {
            char c = cArray[n];
            if (!ScriptRuntime.isJSLineTerminator(c)) continue;
            return n + 1;
        }
        return 0;
    }

    private void warnMissingSemi(int n, int n2) {
        if (this.compilerEnv.isStrictMode()) {
            int n3;
            int[] nArray = new int[2];
            String string = this.ts.getLine(n2, nArray);
            int n4 = n3 = this.compilerEnv.isIdeMode() ? Math.max(n, n2 - nArray[1]) : n;
            if (string != null) {
                this.addStrictWarning("msg.missing.semi", "", n3, n2 - n3, nArray[0], string, nArray[1]);
            } else {
                this.addStrictWarning("msg.missing.semi", "", n3, n2 - n3);
            }
        }
    }

    private void warnTrailingComma(int n, List<?> list, int n2) {
        if (this.compilerEnv.getWarnTrailingComma()) {
            if (!list.isEmpty()) {
                n = ((AstNode)list.get(0)).getPosition();
            }
            n = Math.max(n, this.lineBeginningFor(n2));
            this.addWarning("msg.extra.trailing.comma", n, n2 - n);
        }
    }

    PerFunctionVariables createPerFunctionVariables(FunctionNode functionNode) {
        return new PerFunctionVariables(functionNode);
    }

    Node createDestructuringAssignment(int n, Node node, Node node2) {
        String string = this.currentScriptOrFn.getNextTempName();
        Node node3 = this.destructuringAssignmentHelper(n, node, node2, string);
        Node node4 = node3.getLastChild();
        node4.addChildToBack(this.createName(string));
        return node3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node destructuringAssignmentHelper(int n, Node node, Node node2, String string) {
        Scope scope = this.createScopeNode(162, node.getLineno());
        scope.addChildToFront(new Node(157, this.createName(39, string, node2)));
        try {
            this.pushScope(scope);
            this.defineSymbol(157, string, true);
        }
        finally {
            this.popScope();
        }
        Node node3 = new Node(92);
        scope.addChildToBack(node3);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        switch (node.getType()) {
            case 66: {
                bl = this.destructuringArray((ArrayLiteral)node, n, string, node3, arrayList);
                break;
            }
            case 67: {
                bl = this.destructuringObject((ObjectLiteral)node, n, string, node3, arrayList);
                break;
            }
            case 33: 
            case 36: {
                switch (n) {
                    case 126: 
                    case 157: 
                    case 158: {
                        this.reportError("msg.bad.assign.left");
                    }
                }
                node3.addChildToBack(this.simpleAssignment(node, this.createName(string)));
                break;
            }
            default: {
                this.reportError("msg.bad.assign.left");
            }
        }
        if (bl) {
            node3.addChildToBack(this.createNumber(0.0));
        }
        scope.putProp(22, arrayList);
        return scope;
    }

    boolean destructuringArray(ArrayLiteral arrayLiteral, int n, String string, Node node, List<String> list) {
        boolean bl = true;
        int n2 = n == 158 ? 159 : 8;
        int n3 = 0;
        for (AstNode astNode : arrayLiteral.getElements()) {
            if (astNode.getType() == 132) {
                ++n3;
                continue;
            }
            Node node2 = new Node(36, this.createName(string), this.createNumber(n3));
            if (astNode.getType() == 39) {
                String string2 = astNode.getString();
                node.addChildToBack(new Node(n2, this.createName(49, string2, null), node2));
                if (n != -1) {
                    this.defineSymbol(n, string2, true);
                    list.add(string2);
                }
            } else {
                node.addChildToBack(this.destructuringAssignmentHelper(n, astNode, node2, this.currentScriptOrFn.getNextTempName()));
            }
            ++n3;
            bl = false;
        }
        return bl;
    }

    boolean destructuringObject(ObjectLiteral objectLiteral, int n, String string, Node node, List<String> list) {
        boolean bl = true;
        int n2 = n == 158 ? 159 : 8;
        for (ObjectProperty objectProperty : objectLiteral.getElements()) {
            Node node2;
            int n3 = 0;
            if (this.ts != null) {
                n3 = this.ts.lineno;
            }
            AstNode astNode = objectProperty.getLeft();
            Node node3 = null;
            if (astNode instanceof Name) {
                node2 = Node.newString(((Name)astNode).getIdentifier());
                node3 = new Node(33, this.createName(string), node2);
            } else if (astNode instanceof StringLiteral) {
                node2 = Node.newString(((StringLiteral)astNode).getValue());
                node3 = new Node(33, this.createName(string), node2);
            } else if (astNode instanceof NumberLiteral) {
                node2 = this.createNumber((int)((NumberLiteral)astNode).getNumber());
                node3 = new Node(36, this.createName(string), node2);
            } else {
                throw this.codeBug();
            }
            node3.setLineno(n3);
            node2 = objectProperty.getRight();
            if (node2.getType() == 39) {
                String string2 = ((Name)node2).getIdentifier();
                node.addChildToBack(new Node(n2, this.createName(49, string2, null), node3));
                if (n != -1) {
                    this.defineSymbol(n, string2, true);
                    list.add(string2);
                }
            } else {
                node.addChildToBack(this.destructuringAssignmentHelper(n, node2, node3, this.currentScriptOrFn.getNextTempName()));
            }
            bl = false;
        }
        return bl;
    }

    protected Node createName(String string) {
        this.checkActivationName(string, 39);
        return Node.newString(39, string);
    }

    protected Node createName(int n, String string, Node node) {
        Node node2 = this.createName(string);
        node2.setType(n);
        if (node != null) {
            node2.addChildToBack(node);
        }
        return node2;
    }

    protected Node createNumber(double d) {
        return Node.newNumber(d);
    }

    protected Scope createScopeNode(int n, int n2) {
        Scope scope = new Scope();
        scope.setType(n);
        scope.setLineno(n2);
        return scope;
    }

    protected Node simpleAssignment(Node node, Node node2) {
        int n = node.getType();
        switch (n) {
            case 39: {
                String string = ((Name)node).getIdentifier();
                if (this.inUseStrictDirective && ("eval".equals(string) || "arguments".equals(string))) {
                    this.reportError("msg.bad.id.strict", string);
                }
                node.setType(49);
                return new Node(8, node, node2);
            }
            case 33: 
            case 36: {
                int n2;
                Node node3;
                Node node4;
                if (node instanceof PropertyGet) {
                    node4 = ((PropertyGet)node).getTarget();
                    node3 = ((PropertyGet)node).getProperty();
                } else if (node instanceof ElementGet) {
                    node4 = ((ElementGet)node).getTarget();
                    node3 = ((ElementGet)node).getElement();
                } else {
                    node4 = node.getFirstChild();
                    node3 = node.getLastChild();
                }
                if (n == 33) {
                    n2 = 35;
                    node3.setType(41);
                } else {
                    n2 = 37;
                }
                return new Node(n2, node4, node3, node2);
            }
            case 68: {
                Node node5 = node.getFirstChild();
                this.checkMutableReference(node5);
                return new Node(69, node5, node2);
            }
        }
        throw this.codeBug();
    }

    protected void checkMutableReference(Node node) {
        int n = node.getIntProp(16, 0);
        if ((n & 4) != 0) {
            this.reportError("msg.bad.assign.left");
        }
    }

    protected AstNode removeParens(AstNode astNode) {
        while (astNode instanceof ParenthesizedExpression) {
            astNode = ((ParenthesizedExpression)astNode).getExpression();
        }
        return astNode;
    }

    void markDestructuring(AstNode astNode) {
        if (astNode instanceof DestructuringForm) {
            ((DestructuringForm)((Object)astNode)).setIsDestructuring(true);
        } else if (astNode instanceof ParenthesizedExpression) {
            this.markDestructuring(((ParenthesizedExpression)astNode).getExpression());
        }
    }

    private RuntimeException codeBug() throws RuntimeException {
        throw Kit.codeBug("ts.cursor=" + this.ts.cursor + ", ts.tokenBeg=" + this.ts.tokenBeg + ", currentToken=" + this.currentToken);
    }

    public void setDefaultUseStrictDirective(boolean bl) {
        this.defaultUseStrictDirective = bl;
    }

    public boolean inUseStrictDirective() {
        return this.inUseStrictDirective;
    }

    private static class ConditionData {
        AstNode condition;
        int lp = -1;
        int rp = -1;

        private ConditionData() {
        }
    }

    private static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }

    protected class PerFunctionVariables {
        private ScriptNode savedCurrentScriptOrFn;
        private Scope savedCurrentScope;
        private int savedEndFlags;
        private boolean savedInForInit;
        private Map<String, LabeledStatement> savedLabelSet;
        private List<Loop> savedLoopSet;
        private List<Jump> savedLoopAndSwitchSet;

        PerFunctionVariables(FunctionNode functionNode) {
            this.savedCurrentScriptOrFn = Parser.this.currentScriptOrFn;
            Parser.this.currentScriptOrFn = functionNode;
            this.savedCurrentScope = Parser.this.currentScope;
            Parser.this.currentScope = functionNode;
            this.savedLabelSet = Parser.this.labelSet;
            Parser.this.labelSet = null;
            this.savedLoopSet = Parser.this.loopSet;
            Parser.this.loopSet = null;
            this.savedLoopAndSwitchSet = Parser.this.loopAndSwitchSet;
            Parser.this.loopAndSwitchSet = null;
            this.savedEndFlags = Parser.this.endFlags;
            Parser.this.endFlags = 0;
            this.savedInForInit = Parser.this.inForInit;
            Parser.this.inForInit = false;
        }

        void restore() {
            Parser.this.currentScriptOrFn = this.savedCurrentScriptOrFn;
            Parser.this.currentScope = this.savedCurrentScope;
            Parser.this.labelSet = this.savedLabelSet;
            Parser.this.loopSet = this.savedLoopSet;
            Parser.this.loopAndSwitchSet = this.savedLoopAndSwitchSet;
            Parser.this.endFlags = this.savedEndFlags;
            Parser.this.inForInit = this.savedInForInit;
        }
    }
}

