/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.text.Collator;
import java.text.Normalizer;
import java.util.Locale;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeStringIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;

final class NativeString
extends IdScriptableObject {
    private static final long serialVersionUID = 920268368584188687L;
    private static final Object STRING_TAG = "String";
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final int ConstructorId_fromCharCode = -1;
    private static final int ConstructorId_fromCodePoint = -2;
    private static final int ConstructorId_raw = -3;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_charAt = 5;
    private static final int Id_charCodeAt = 6;
    private static final int Id_indexOf = 7;
    private static final int Id_lastIndexOf = 8;
    private static final int Id_split = 9;
    private static final int Id_substring = 10;
    private static final int Id_toLowerCase = 11;
    private static final int Id_toUpperCase = 12;
    private static final int Id_substr = 13;
    private static final int Id_concat = 14;
    private static final int Id_slice = 15;
    private static final int Id_bold = 16;
    private static final int Id_italics = 17;
    private static final int Id_fixed = 18;
    private static final int Id_strike = 19;
    private static final int Id_small = 20;
    private static final int Id_big = 21;
    private static final int Id_blink = 22;
    private static final int Id_sup = 23;
    private static final int Id_sub = 24;
    private static final int Id_fontsize = 25;
    private static final int Id_fontcolor = 26;
    private static final int Id_link = 27;
    private static final int Id_anchor = 28;
    private static final int Id_equals = 29;
    private static final int Id_equalsIgnoreCase = 30;
    private static final int Id_match = 31;
    private static final int Id_search = 32;
    private static final int Id_replace = 33;
    private static final int Id_localeCompare = 34;
    private static final int Id_toLocaleLowerCase = 35;
    private static final int Id_toLocaleUpperCase = 36;
    private static final int Id_trim = 37;
    private static final int Id_trimLeft = 38;
    private static final int Id_trimRight = 39;
    private static final int Id_includes = 40;
    private static final int Id_startsWith = 41;
    private static final int Id_endsWith = 42;
    private static final int Id_normalize = 43;
    private static final int Id_repeat = 44;
    private static final int Id_codePointAt = 45;
    private static final int Id_padStart = 46;
    private static final int Id_padEnd = 47;
    private static final int SymbolId_iterator = 48;
    private static final int Id_trimStart = 49;
    private static final int Id_trimEnd = 50;
    private static final int Id_at = 51;
    private static final int MAX_PROTOTYPE_ID = 51;
    private static final int ConstructorId_charAt = -5;
    private static final int ConstructorId_charCodeAt = -6;
    private static final int ConstructorId_indexOf = -7;
    private static final int ConstructorId_lastIndexOf = -8;
    private static final int ConstructorId_split = -9;
    private static final int ConstructorId_substring = -10;
    private static final int ConstructorId_toLowerCase = -11;
    private static final int ConstructorId_toUpperCase = -12;
    private static final int ConstructorId_substr = -13;
    private static final int ConstructorId_concat = -14;
    private static final int ConstructorId_slice = -15;
    private static final int ConstructorId_equalsIgnoreCase = -30;
    private static final int ConstructorId_match = -31;
    private static final int ConstructorId_search = -32;
    private static final int ConstructorId_replace = -33;
    private static final int ConstructorId_localeCompare = -34;
    private static final int ConstructorId_toLocaleLowerCase = -35;
    private CharSequence string;

    static void init(Scriptable scriptable, boolean bl) {
        NativeString nativeString = new NativeString("");
        nativeString.exportAsJSClass(51, scriptable, bl);
    }

    NativeString(CharSequence charSequence) {
        this.string = charSequence;
    }

    @Override
    public String getClassName() {
        return "String";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return NativeString.instanceIdInfo(7, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapInt(this.string.length());
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -1, "fromCharCode", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -2, "fromCodePoint", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -3, "raw", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -5, "charAt", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -6, "charCodeAt", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -7, "indexOf", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -8, "lastIndexOf", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -9, "split", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -10, "substring", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -11, "toLowerCase", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -12, "toUpperCase", 1);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -13, "substr", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -14, "concat", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -15, "slice", 3);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -30, "equalsIgnoreCase", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -31, "match", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -32, "search", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -33, "replace", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -34, "localeCompare", 2);
        this.addIdFunctionProperty(idFunctionObject, STRING_TAG, -35, "toLocaleLowerCase", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 48) {
            this.initPrototypeMethod(STRING_TAG, n, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 0;
                string = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string = "charAt";
                break;
            }
            case 6: {
                n2 = 1;
                string = "charCodeAt";
                break;
            }
            case 7: {
                n2 = 1;
                string = "indexOf";
                break;
            }
            case 8: {
                n2 = 1;
                string = "lastIndexOf";
                break;
            }
            case 9: {
                n2 = 2;
                string = "split";
                break;
            }
            case 10: {
                n2 = 2;
                string = "substring";
                break;
            }
            case 11: {
                n2 = 0;
                string = "toLowerCase";
                break;
            }
            case 12: {
                n2 = 0;
                string = "toUpperCase";
                break;
            }
            case 13: {
                n2 = 2;
                string = "substr";
                break;
            }
            case 14: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 15: {
                n2 = 2;
                string = "slice";
                break;
            }
            case 16: {
                n2 = 0;
                string = "bold";
                break;
            }
            case 17: {
                n2 = 0;
                string = "italics";
                break;
            }
            case 18: {
                n2 = 0;
                string = "fixed";
                break;
            }
            case 19: {
                n2 = 0;
                string = "strike";
                break;
            }
            case 20: {
                n2 = 0;
                string = "small";
                break;
            }
            case 21: {
                n2 = 0;
                string = "big";
                break;
            }
            case 22: {
                n2 = 0;
                string = "blink";
                break;
            }
            case 23: {
                n2 = 0;
                string = "sup";
                break;
            }
            case 24: {
                n2 = 0;
                string = "sub";
                break;
            }
            case 25: {
                n2 = 0;
                string = "fontsize";
                break;
            }
            case 26: {
                n2 = 0;
                string = "fontcolor";
                break;
            }
            case 27: {
                n2 = 0;
                string = "link";
                break;
            }
            case 28: {
                n2 = 0;
                string = "anchor";
                break;
            }
            case 29: {
                n2 = 1;
                string = "equals";
                break;
            }
            case 30: {
                n2 = 1;
                string = "equalsIgnoreCase";
                break;
            }
            case 31: {
                n2 = 1;
                string = "match";
                break;
            }
            case 32: {
                n2 = 1;
                string = "search";
                break;
            }
            case 33: {
                n2 = 2;
                string = "replace";
                break;
            }
            case 51: {
                n2 = 1;
                string = "at";
                break;
            }
            case 34: {
                n2 = 1;
                string = "localeCompare";
                break;
            }
            case 35: {
                n2 = 0;
                string = "toLocaleLowerCase";
                break;
            }
            case 36: {
                n2 = 0;
                string = "toLocaleUpperCase";
                break;
            }
            case 37: {
                n2 = 0;
                string = "trim";
                break;
            }
            case 38: {
                n2 = 0;
                string = "trimLeft";
                break;
            }
            case 39: {
                n2 = 0;
                string = "trimRight";
                break;
            }
            case 40: {
                n2 = 1;
                string = "includes";
                break;
            }
            case 41: {
                n2 = 1;
                string = "startsWith";
                break;
            }
            case 42: {
                n2 = 1;
                string = "endsWith";
                break;
            }
            case 43: {
                n2 = 0;
                string = "normalize";
                break;
            }
            case 44: {
                n2 = 1;
                string = "repeat";
                break;
            }
            case 45: {
                n2 = 1;
                string = "codePointAt";
                break;
            }
            case 46: {
                n2 = 1;
                string = "padStart";
                break;
            }
            case 47: {
                n2 = 1;
                string = "padEnd";
                break;
            }
            case 49: {
                n2 = 0;
                string = "trimStart";
                break;
            }
            case 50: {
                n2 = 0;
                string = "trimEnd";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(STRING_TAG, n, string, string2, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] object) {
        if (!idFunctionObject.hasTag(STRING_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, (Object[])object);
        }
        int n = idFunctionObject.methodId();
        block47: while (true) {
            switch (n) {
                case -35: 
                case -34: 
                case -33: 
                case -32: 
                case -31: 
                case -30: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    CharSequence charSequence;
                    if (((Object[])object).length > 0) {
                        scriptable2 = ScriptRuntime.toObject(context, scriptable, ScriptRuntime.toCharSequence(object[0]));
                        charSequence = new Object[((Object[])object).length - 1];
                        System.arraycopy(object, 1, charSequence, 0, ((CharSequence)charSequence).length);
                        object = charSequence;
                    } else {
                        scriptable2 = ScriptRuntime.toObject(context, scriptable, ScriptRuntime.toCharSequence(scriptable2));
                    }
                    n = -n;
                    continue block47;
                }
                case -2: {
                    int n2 = ((Object[])object).length;
                    if (n2 < 1) {
                        return "";
                    }
                    int[] nArray = new int[n2];
                    for (int i = 0; i != n2; ++i) {
                        Object object2 = object[i];
                        int n3 = ScriptRuntime.toInt32(object2);
                        double d = ScriptRuntime.toNumber(object2);
                        if (!ScriptRuntime.eqNumber(d, n3) || !Character.isValidCodePoint(n3)) {
                            throw ScriptRuntime.rangeError("Invalid code point " + ScriptRuntime.toString(object2));
                        }
                        nArray[i] = n3;
                    }
                    return new String(nArray, 0, n2);
                }
                case -1: {
                    int n4 = ((Object[])object).length;
                    if (n4 < 1) {
                        return "";
                    }
                    char[] cArray = new char[n4];
                    for (int i = 0; i != n4; ++i) {
                        cArray[i] = ScriptRuntime.toUint16(object[i]);
                    }
                    return new String(cArray);
                }
                case -3: {
                    return NativeString.js_raw(context, scriptable, object);
                }
                case 1: {
                    CharSequence charSequence = ((Object[])object).length == 0 ? "" : (ScriptRuntime.isSymbol(object[0]) && scriptable2 != null ? object[0].toString() : ScriptRuntime.toCharSequence(object[0]));
                    if (scriptable2 == null) {
                        return new NativeString(charSequence);
                    }
                    return charSequence instanceof String ? charSequence : charSequence.toString();
                }
                case 2: 
                case 4: {
                    CharSequence charSequence = NativeString.realThis((Scriptable)scriptable2, (IdFunctionObject)idFunctionObject).string;
                    return charSequence instanceof String ? charSequence : charSequence.toString();
                }
                case 3: {
                    CharSequence charSequence = NativeString.realThis((Scriptable)scriptable2, (IdFunctionObject)idFunctionObject).string;
                    return "(new String(\"" + ScriptRuntime.escapeString(charSequence.toString()) + "\"))";
                }
                case 5: 
                case 6: {
                    CharSequence charSequence = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    double d = ScriptRuntime.toInteger(object, 0);
                    if (d < 0.0 || d >= (double)charSequence.length()) {
                        if (n == 5) {
                            return "";
                        }
                        return ScriptRuntime.NaNobj;
                    }
                    char c = charSequence.charAt((int)d);
                    if (n == 5) {
                        return String.valueOf(c);
                    }
                    return ScriptRuntime.wrapInt(c);
                }
                case 7: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return ScriptRuntime.wrapInt(NativeString.js_indexOf(7, string, object));
                }
                case 40: 
                case 41: 
                case 42: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    if (((Object[])object).length > 0 && object[0] instanceof NativeRegExp) {
                        throw ScriptRuntime.typeErrorById("msg.first.arg.not.regexp", String.class.getSimpleName(), idFunctionObject.getFunctionName());
                    }
                    int n5 = NativeString.js_indexOf(n, string, object);
                    if (n == 40) {
                        return n5 != -1;
                    }
                    if (n == 41) {
                        return n5 == 0;
                    }
                    if (n == 42) {
                        return n5 != -1;
                    }
                }
                case 46: 
                case 47: {
                    return NativeString.js_pad(context, scriptable2, idFunctionObject, object, n == 46);
                }
                case 8: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return ScriptRuntime.wrapInt(NativeString.js_lastIndexOf(string, object));
                }
                case 9: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return ScriptRuntime.checkRegExpProxy(context).js_split(context, scriptable, string, (Object[])object);
                }
                case 10: {
                    CharSequence charSequence = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return NativeString.js_substring(context, charSequence, object);
                }
                case 11: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return string.toLowerCase(Locale.ROOT);
                }
                case 12: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return string.toUpperCase(Locale.ROOT);
                }
                case 13: {
                    CharSequence charSequence = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return NativeString.js_substr(charSequence, object);
                }
                case 14: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return NativeString.js_concat(string, object);
                }
                case 15: {
                    CharSequence charSequence = ScriptRuntime.toCharSequence(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    return NativeString.js_slice(charSequence, object);
                }
                case 16: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "b", null, null);
                }
                case 17: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "i", null, null);
                }
                case 18: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "tt", null, null);
                }
                case 19: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "strike", null, null);
                }
                case 20: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "small", null, null);
                }
                case 21: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "big", null, null);
                }
                case 22: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "blink", null, null);
                }
                case 23: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "sup", null, null);
                }
                case 24: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "sub", null, null);
                }
                case 25: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "font", "size", object);
                }
                case 26: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "font", "color", object);
                }
                case 27: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "a", "href", object);
                }
                case 28: {
                    return NativeString.tagify(context, scriptable2, idFunctionObject, "a", "name", object);
                }
                case 29: 
                case 30: {
                    String string = ScriptRuntime.toString(scriptable2);
                    String string2 = ScriptRuntime.toString(object, 0);
                    return ScriptRuntime.wrapBoolean(n == 29 ? string.equals(string2) : string.equalsIgnoreCase(string2));
                }
                case 31: 
                case 32: 
                case 33: {
                    int n6 = n == 31 ? 1 : (n == 32 ? 3 : 2);
                    ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject);
                    return ScriptRuntime.checkRegExpProxy(context).action(context, scriptable, scriptable2, (Object[])object, n6);
                }
                case 34: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    Collator collator = Collator.getInstance(context.getLocale());
                    collator.setStrength(3);
                    collator.setDecomposition(1);
                    return ScriptRuntime.wrapNumber(collator.compare(string, ScriptRuntime.toString(object, 0)));
                }
                case 35: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    Locale locale = context.getLocale();
                    if (((Object[])object).length > 0 && context.hasFeature(22)) {
                        String string3 = ScriptRuntime.toString(object[0]);
                        locale = new Locale(string3);
                    }
                    return string.toLowerCase(locale);
                }
                case 36: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    Locale locale = context.getLocale();
                    if (((Object[])object).length > 0 && context.hasFeature(22)) {
                        String string4 = ScriptRuntime.toString(object[0]);
                        locale = new Locale(string4);
                    }
                    return string.toUpperCase(locale);
                }
                case 37: {
                    int n7;
                    int n8;
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    char[] cArray = string.toCharArray();
                    for (n8 = 0; n8 < cArray.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n8]); ++n8) {
                    }
                    for (n7 = cArray.length; n7 > n8 && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n7 - 1]); --n7) {
                    }
                    return string.substring(n8, n7);
                }
                case 38: 
                case 49: {
                    int n9;
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    char[] cArray = string.toCharArray();
                    for (n9 = 0; n9 < cArray.length && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n9]); ++n9) {
                    }
                    int n10 = cArray.length;
                    return string.substring(n9, n10);
                }
                case 39: 
                case 50: {
                    int n11;
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    char[] cArray = string.toCharArray();
                    int n12 = 0;
                    for (n11 = cArray.length; n11 > n12 && ScriptRuntime.isJSWhitespaceOrLineTerminator(cArray[n11 - 1]); --n11) {
                    }
                    return string.substring(n12, n11);
                }
                case 43: {
                    Normalizer.Form form;
                    if (((Object[])object).length == 0 || Undefined.isUndefined(object[0])) {
                        return Normalizer.normalize(ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject)), Normalizer.Form.NFC);
                    }
                    String string = ScriptRuntime.toString(object, 0);
                    if (Normalizer.Form.NFD.name().equals(string)) {
                        form = Normalizer.Form.NFD;
                    } else if (Normalizer.Form.NFKC.name().equals(string)) {
                        form = Normalizer.Form.NFKC;
                    } else if (Normalizer.Form.NFKD.name().equals(string)) {
                        form = Normalizer.Form.NFKD;
                    } else if (Normalizer.Form.NFC.name().equals(string)) {
                        form = Normalizer.Form.NFC;
                    } else {
                        throw ScriptRuntime.rangeError("The normalization form should be one of 'NFC', 'NFD', 'NFKC', 'NFKD'.");
                    }
                    return Normalizer.normalize(ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject)), form);
                }
                case 44: {
                    return NativeString.js_repeat(context, scriptable2, idFunctionObject, object);
                }
                case 45: {
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    double d = ScriptRuntime.toInteger(object, 0);
                    return d < 0.0 || d >= (double)string.length() ? Undefined.instance : Integer.valueOf(string.codePointAt((int)d));
                }
                case 51: {
                    int n13;
                    String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                    Object object3 = ((Object[])object).length >= 1 ? object[0] : Undefined.instance;
                    int n14 = string.length();
                    int n15 = (int)ScriptRuntime.toInteger(object3);
                    int n16 = n13 = n15 >= 0 ? n15 : n14 + n15;
                    if (n13 < 0 || n13 >= n14) {
                        return Undefined.instance;
                    }
                    return string.substring(n13, n13 + 1);
                }
                case 48: {
                    return new NativeStringIterator(scriptable, ScriptRuntimeES6.requireObjectCoercible(context, scriptable2, idFunctionObject));
                }
            }
            break;
        }
        throw new IllegalArgumentException("String.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    private static NativeString realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeString.ensureType(scriptable, NativeString.class, idFunctionObject);
    }

    private static String tagify(Context context, Scriptable scriptable, IdFunctionObject idFunctionObject, String string, String string2, Object[] objectArray) {
        String string3 = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable, idFunctionObject));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(string);
        if (string2 != null && string2.length() > 0) {
            String string4 = ScriptRuntime.toString(objectArray, 0);
            string4 = string4.replace("\"", "&quot;");
            stringBuilder.append(' ').append(string2).append("=\"").append(string4).append('\"');
        }
        stringBuilder.append('>').append(string3).append("</").append(string).append('>');
        return stringBuilder.toString();
    }

    public CharSequence toCharSequence() {
        return this.string;
    }

    public String toString() {
        return this.string instanceof String ? (String)this.string : this.string.toString();
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (0 <= n && n < this.string.length()) {
            return String.valueOf(this.string.charAt(n));
        }
        return super.get(n, scriptable);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (0 <= n && n < this.string.length()) {
            return;
        }
        super.put(n, scriptable, object);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (0 <= n && n < this.string.length()) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public int getAttributes(int n) {
        if (0 <= n && n < this.string.length()) {
            int n2 = 5;
            if (Context.getContext().getLanguageVersion() < 200) {
                n2 |= 2;
            }
            return n2;
        }
        return super.getAttributes(n);
    }

    @Override
    protected Object[] getIds(boolean bl, boolean bl2) {
        Context context = Context.getCurrentContext();
        if (context != null && context.getLanguageVersion() >= 200) {
            int n;
            Object[] objectArray = super.getIds(bl, bl2);
            Object[] objectArray2 = new Object[objectArray.length + this.string.length()];
            for (n = 0; n < this.string.length(); ++n) {
                objectArray2[n] = n;
            }
            System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
            return objectArray2;
        }
        return super.getIds(bl, bl2);
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        if (!(object instanceof Symbol) && context != null && context.getLanguageVersion() >= 200) {
            ScriptRuntime.StringIdOrIndex stringIdOrIndex = ScriptRuntime.toStringIdOrIndex(object);
            if (stringIdOrIndex.stringId == null && 0 <= stringIdOrIndex.index && stringIdOrIndex.index < this.string.length()) {
                String string = String.valueOf(this.string.charAt(stringIdOrIndex.index));
                return this.defaultIndexPropertyDescriptor(string);
            }
        }
        return super.getOwnPropertyDescriptor(context, object);
    }

    private ScriptableObject defaultIndexPropertyDescriptor(Object object) {
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.defineProperty("value", object, 0);
        nativeObject.defineProperty("writable", (Object)Boolean.FALSE, 0);
        nativeObject.defineProperty("enumerable", (Object)Boolean.TRUE, 0);
        nativeObject.defineProperty("configurable", (Object)Boolean.FALSE, 0);
        return nativeObject;
    }

    private static int js_indexOf(int n, String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toInteger(objectArray, 1);
        if (n != 41 && n != 42 && string2.length() == 0) {
            return d > (double)string.length() ? string.length() : (int)d;
        }
        if (n != 41 && n != 42 && d > (double)string.length()) {
            return -1;
        }
        if (d < 0.0) {
            d = 0.0;
        } else if (d > (double)string.length()) {
            d = string.length();
        } else if (n == 42 && (Double.isNaN(d) || d > (double)string.length())) {
            d = string.length();
        }
        if (42 == n) {
            if (objectArray.length == 0 || objectArray.length == 1 || objectArray.length == 2 && objectArray[1] == Undefined.instance) {
                d = string.length();
            }
            return string.substring(0, (int)d).endsWith(string2) ? 0 : -1;
        }
        return n == 41 ? (string.startsWith(string2, (int)d) ? 0 : -1) : string.indexOf(string2, (int)d);
    }

    private static int js_lastIndexOf(String string, Object[] objectArray) {
        String string2 = ScriptRuntime.toString(objectArray, 0);
        double d = ScriptRuntime.toNumber(objectArray, 1);
        if (Double.isNaN(d) || d > (double)string.length()) {
            d = string.length();
        } else if (d < 0.0) {
            d = 0.0;
        }
        return string.lastIndexOf(string2, (int)d);
    }

    private static CharSequence js_substring(Context context, CharSequence charSequence, Object[] objectArray) {
        double d;
        int n = charSequence.length();
        double d2 = ScriptRuntime.toInteger(objectArray, 0);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length <= 1 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                d = 0.0;
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                if (context.getLanguageVersion() != 120) {
                    double d3 = d2;
                    d2 = d;
                    d = d3;
                } else {
                    d = d2;
                }
            }
        }
        return charSequence.subSequence((int)d2, (int)d);
    }

    int getLength() {
        return this.string.length();
    }

    private static CharSequence js_substr(CharSequence charSequence, Object[] objectArray) {
        Object object;
        if (objectArray.length < 1) {
            return charSequence;
        }
        double d = ScriptRuntime.toInteger(objectArray[0]);
        int n = charSequence.length();
        if (d < 0.0) {
            if ((d += (double)n) < 0.0) {
                d = 0.0;
            }
        } else if (d > (double)n) {
            d = n;
        }
        double d2 = n;
        if (objectArray.length > 1 && !Undefined.isUndefined(object = objectArray[1])) {
            d2 = ScriptRuntime.toInteger(object);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if ((d2 += d) > (double)n) {
                d2 = n;
            }
        }
        return charSequence.subSequence((int)d, (int)d2);
    }

    private static String js_concat(String string, Object[] objectArray) {
        int n = objectArray.length;
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            String string2 = ScriptRuntime.toString(objectArray[0]);
            return string.concat(string2);
        }
        int n2 = string.length();
        String[] stringArray = new String[n];
        for (int i = 0; i != n; ++i) {
            String string3;
            stringArray[i] = string3 = ScriptRuntime.toString(objectArray[i]);
            n2 += string3.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string);
        for (int i = 0; i != n; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private static CharSequence js_slice(CharSequence charSequence, Object[] objectArray) {
        double d;
        double d2 = objectArray.length < 1 ? 0.0 : ScriptRuntime.toInteger(objectArray[0]);
        int n = charSequence.length();
        if (d2 < 0.0) {
            if ((d2 += (double)n) < 0.0) {
                d2 = 0.0;
            }
        } else if (d2 > (double)n) {
            d2 = n;
        }
        if (objectArray.length < 2 || objectArray[1] == Undefined.instance) {
            d = n;
        } else {
            d = ScriptRuntime.toInteger(objectArray[1]);
            if (d < 0.0) {
                if ((d += (double)n) < 0.0) {
                    d = 0.0;
                }
            } else if (d > (double)n) {
                d = n;
            }
            if (d < d2) {
                d = d2;
            }
        }
        return charSequence.subSequence((int)d2, (int)d);
    }

    private static String js_repeat(Context context, Scriptable scriptable, IdFunctionObject idFunctionObject, Object[] objectArray) {
        int n;
        String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable, idFunctionObject));
        double d = ScriptRuntime.toInteger(objectArray, 0);
        if (d < 0.0 || d == Double.POSITIVE_INFINITY) {
            throw ScriptRuntime.rangeError("Invalid count value");
        }
        if (d == 0.0 || string.length() == 0) {
            return "";
        }
        long l = (long)string.length() * (long)d;
        if (d > 2.147483647E9 || l > Integer.MAX_VALUE) {
            throw ScriptRuntime.rangeError("Invalid size or count value");
        }
        StringBuilder stringBuilder = new StringBuilder((int)l);
        stringBuilder.append(string);
        int n2 = (int)d;
        for (n = 1; n <= n2 / 2; n *= 2) {
            stringBuilder.append((CharSequence)stringBuilder);
        }
        if (n < n2) {
            stringBuilder.append(stringBuilder.substring(0, string.length() * (n2 - n)));
        }
        return stringBuilder.toString();
    }

    private static String js_pad(Context context, Scriptable scriptable, IdFunctionObject idFunctionObject, Object[] objectArray, boolean bl) {
        String string = ScriptRuntime.toString(ScriptRuntimeES6.requireObjectCoercible(context, scriptable, idFunctionObject));
        long l = ScriptRuntime.toLength(objectArray, 0);
        if (l <= (long)string.length()) {
            return string;
        }
        String string2 = " ";
        if (objectArray.length >= 2 && !Undefined.isUndefined(objectArray[1]) && (string2 = ScriptRuntime.toString(objectArray[1])).length() < 1) {
            return string;
        }
        int n = (int)(l - (long)string.length());
        StringBuilder stringBuilder = new StringBuilder();
        do {
            stringBuilder.append(string2);
        } while (stringBuilder.length() < n);
        stringBuilder.setLength(n);
        if (bl) {
            return stringBuilder.append(string).toString();
        }
        return stringBuilder.insert(0, string).toString();
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 48;
        }
        return 0;
    }

    private static CharSequence js_raw(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Scriptable scriptable2 = ScriptRuntime.toObject(context, scriptable, object);
        Object object2 = ScriptRuntime.getObjectProp(scriptable2, "raw", context);
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, object2);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        if (l > Integer.MAX_VALUE) {
            throw ScriptRuntime.rangeError("raw.length > 2147483647");
        }
        int n = (int)l;
        if (n <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (true) {
            Object object3 = ScriptRuntime.getObjectIndex(scriptable3, n2, context);
            String string = ScriptRuntime.toString(object3);
            stringBuilder.append(string);
            if (++n2 == n) break;
            if (objectArray.length <= n2) continue;
            object3 = objectArray[n2];
            String string2 = ScriptRuntime.toString(object3);
            stringBuilder.append(string2);
        }
        return stringBuilder;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "toSource": {
                n = 3;
                break;
            }
            case "valueOf": {
                n = 4;
                break;
            }
            case "charAt": {
                n = 5;
                break;
            }
            case "charCodeAt": {
                n = 6;
                break;
            }
            case "indexOf": {
                n = 7;
                break;
            }
            case "lastIndexOf": {
                n = 8;
                break;
            }
            case "split": {
                n = 9;
                break;
            }
            case "substring": {
                n = 10;
                break;
            }
            case "toLowerCase": {
                n = 11;
                break;
            }
            case "toUpperCase": {
                n = 12;
                break;
            }
            case "substr": {
                n = 13;
                break;
            }
            case "concat": {
                n = 14;
                break;
            }
            case "slice": {
                n = 15;
                break;
            }
            case "bold": {
                n = 16;
                break;
            }
            case "italics": {
                n = 17;
                break;
            }
            case "fixed": {
                n = 18;
                break;
            }
            case "strike": {
                n = 19;
                break;
            }
            case "small": {
                n = 20;
                break;
            }
            case "big": {
                n = 21;
                break;
            }
            case "blink": {
                n = 22;
                break;
            }
            case "sup": {
                n = 23;
                break;
            }
            case "sub": {
                n = 24;
                break;
            }
            case "fontsize": {
                n = 25;
                break;
            }
            case "fontcolor": {
                n = 26;
                break;
            }
            case "link": {
                n = 27;
                break;
            }
            case "anchor": {
                n = 28;
                break;
            }
            case "equals": {
                n = 29;
                break;
            }
            case "equalsIgnoreCase": {
                n = 30;
                break;
            }
            case "match": {
                n = 31;
                break;
            }
            case "search": {
                n = 32;
                break;
            }
            case "replace": {
                n = 33;
                break;
            }
            case "localeCompare": {
                n = 34;
                break;
            }
            case "toLocaleLowerCase": {
                n = 35;
                break;
            }
            case "toLocaleUpperCase": {
                n = 36;
                break;
            }
            case "trim": {
                n = 37;
                break;
            }
            case "trimLeft": {
                n = 38;
                break;
            }
            case "trimRight": {
                n = 39;
                break;
            }
            case "includes": {
                n = 40;
                break;
            }
            case "startsWith": {
                n = 41;
                break;
            }
            case "endsWith": {
                n = 42;
                break;
            }
            case "normalize": {
                n = 43;
                break;
            }
            case "repeat": {
                n = 44;
                break;
            }
            case "codePointAt": {
                n = 45;
                break;
            }
            case "padStart": {
                n = 46;
                break;
            }
            case "padEnd": {
                n = 47;
                break;
            }
            case "trimStart": {
                n = 49;
                break;
            }
            case "trimEnd": {
                n = 50;
                break;
            }
            case "at": {
                n = 51;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }
}

