/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import org.mozilla.javascript.AbstractEcmaObjectOperations;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.LambdaFunction;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;

public class NativePromise
extends ScriptableObject {
    private State state = State.PENDING;
    private Object result = null;
    private boolean handled = false;
    private ArrayList<Reaction> fulfillReactions = new ArrayList();
    private ArrayList<Reaction> rejectReactions = new ArrayList();

    public static void init(Context context2, Scriptable scriptable3, boolean bl) {
        LambdaConstructor lambdaConstructor = new LambdaConstructor(scriptable3, "Promise", 1, 2, NativePromise::constructor);
        lambdaConstructor.setPrototypePropertyAttributes(7);
        lambdaConstructor.defineConstructorMethod(scriptable3, "resolve", 1, NativePromise::resolve, 2, 3);
        lambdaConstructor.defineConstructorMethod(scriptable3, "reject", 1, NativePromise::reject, 2, 3);
        lambdaConstructor.defineConstructorMethod(scriptable3, "all", 1, NativePromise::all, 2, 3);
        lambdaConstructor.defineConstructorMethod(scriptable3, "allSettled", 1, NativePromise::allSettled, 2, 3);
        lambdaConstructor.defineConstructorMethod(scriptable3, "race", 1, NativePromise::race, 2, 3);
        ScriptableObject scriptableObject = (ScriptableObject)context2.newObject(scriptable3);
        ScriptableObject.putProperty((Scriptable)scriptableObject, "enumerable", (Object)false);
        ScriptableObject.putProperty((Scriptable)scriptableObject, "configurable", (Object)true);
        ScriptableObject.putProperty((Scriptable)scriptableObject, "get", (Object)new LambdaFunction(scriptable3, "get [Symbol.species]", 0, (context, scriptable, scriptable2, objectArray) -> lambdaConstructor));
        lambdaConstructor.defineOwnProperty(context2, SymbolKey.SPECIES, scriptableObject, false);
        lambdaConstructor.definePrototypeMethod(scriptable3, "then", 2, (context, scriptable, scriptable2, objectArray) -> {
            NativePromise nativePromise = LambdaConstructor.convertThisObject(scriptable2, NativePromise.class);
            return nativePromise.then(context, scriptable, lambdaConstructor, objectArray);
        }, 2, 3);
        lambdaConstructor.definePrototypeMethod(scriptable3, "catch", 1, NativePromise::doCatch, 2, 3);
        lambdaConstructor.definePrototypeMethod(scriptable3, "finally", 1, (context, scriptable, scriptable2, objectArray) -> NativePromise.doFinally(context, scriptable, scriptable2, lambdaConstructor, objectArray), 2, 3);
        lambdaConstructor.definePrototypeProperty(SymbolKey.TO_STRING_TAG, (Object)"Promise", 3);
        ScriptableObject.defineProperty(scriptable3, "Promise", lambdaConstructor, 2);
        if (bl) {
            lambdaConstructor.sealObject();
        }
    }

    private static Scriptable constructor(Context context, Scriptable scriptable, Object[] objectArray) {
        Scriptable scriptable2;
        if (objectArray.length < 1 || !(objectArray[0] instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
        }
        Callable callable = (Callable)objectArray[0];
        NativePromise nativePromise = new NativePromise();
        ResolvingFunctions resolvingFunctions = new ResolvingFunctions(scriptable, nativePromise);
        Scriptable scriptable3 = Undefined.SCRIPTABLE_UNDEFINED;
        if (!context.isStrictMode() && (scriptable2 = context.topCallScope) != null) {
            scriptable3 = scriptable2;
        }
        try {
            callable.call(context, scriptable, scriptable3, new Object[]{resolvingFunctions.resolve, resolvingFunctions.reject});
        }
        catch (RhinoException rhinoException) {
            resolvingFunctions.reject.call(context, scriptable, scriptable3, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
        }
        return nativePromise;
    }

    @Override
    public String getClassName() {
        return "Promise";
    }

    Object getResult() {
        return this.result;
    }

    private static Object resolve(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.isObject(scriptable2)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(scriptable2));
        }
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        return NativePromise.resolveInternal(context, scriptable, scriptable2, object);
    }

    private static Object resolveInternal(Context context, Scriptable scriptable, Object object, Object object2) {
        Object object3;
        if (object2 instanceof NativePromise && (object3 = ScriptRuntime.getObjectProp(object2, "constructor", context, scriptable)) == object) {
            return object2;
        }
        object3 = new Capability(context, scriptable, object);
        ((Capability)object3).resolve.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{object2});
        return ((Capability)object3).promise;
    }

    private static Object reject(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.isObject(scriptable2)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(scriptable2));
        }
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Capability capability = new Capability(context, scriptable, scriptable2);
        capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{object});
        return capability.promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doAll(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, boolean bl) {
        IteratorLikeIterable iteratorLikeIterable;
        Object object;
        Capability capability = new Capability(context, scriptable, scriptable2);
        Object object2 = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        try {
            object = ScriptRuntime.callIterator(object2, context, scriptable);
            iteratorLikeIterable = new IteratorLikeIterable(context, scriptable, object);
        }
        catch (RhinoException rhinoException) {
            capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
            return capability.promise;
        }
        object = iteratorLikeIterable.iterator();
        PromiseAllResolver promiseAllResolver = new PromiseAllResolver((IteratorLikeIterable.Itr)object, scriptable2, capability, bl);
        try {
            Object object3 = promiseAllResolver.resolve(context, scriptable);
            if (!((IteratorLikeIterable.Itr)object).isDone()) {
                iteratorLikeIterable.close();
            }
            return object3;
        }
        catch (Throwable throwable) {
            try {
                if (!((IteratorLikeIterable.Itr)object).isDone()) {
                    iteratorLikeIterable.close();
                }
                throw throwable;
            }
            catch (RhinoException rhinoException) {
                capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
                return capability.promise;
            }
        }
    }

    private static Object all(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return NativePromise.doAll(context, scriptable, scriptable2, objectArray, true);
    }

    private static Object allSettled(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return NativePromise.doAll(context, scriptable, scriptable2, objectArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object race(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        IteratorLikeIterable iteratorLikeIterable;
        Object object;
        Capability capability = new Capability(context, scriptable, scriptable2);
        Object object2 = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        try {
            object = ScriptRuntime.callIterator(object2, context, scriptable);
            iteratorLikeIterable = new IteratorLikeIterable(context, scriptable, object);
        }
        catch (RhinoException rhinoException) {
            capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
            return capability.promise;
        }
        object = iteratorLikeIterable.iterator();
        try {
            Object object3 = NativePromise.performRace(context, scriptable, (IteratorLikeIterable.Itr)object, scriptable2, capability);
            if (!((IteratorLikeIterable.Itr)object).isDone()) {
                iteratorLikeIterable.close();
            }
            return object3;
        }
        catch (Throwable throwable) {
            try {
                if (!((IteratorLikeIterable.Itr)object).isDone()) {
                    iteratorLikeIterable.close();
                }
                throw throwable;
            }
            catch (RhinoException rhinoException) {
                capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
                return capability.promise;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object performRace(Context context, Scriptable scriptable, IteratorLikeIterable.Itr itr, Scriptable scriptable2, Capability capability) {
        Callable callable = ScriptRuntime.getPropFunctionAndThis(scriptable2, "resolve", context, scriptable);
        Scriptable scriptable3 = ScriptRuntime.lastStoredScriptable(context);
        while (true) {
            boolean bl;
            Object object = Undefined.instance;
            boolean bl2 = false;
            try {
                bl = itr.hasNext();
                if (bl) {
                    object = itr.next();
                }
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    itr.setDone(true);
                }
            }
            if (!bl) {
                return capability.promise;
            }
            Object object2 = callable.call(context, scriptable, scriptable3, new Object[]{object});
            Callable callable2 = ScriptRuntime.getPropFunctionAndThis(object2, "then", context, scriptable);
            callable2.call(context, scriptable, ScriptRuntime.lastStoredScriptable(context), new Object[]{capability.resolve, capability.reject});
        }
    }

    private Object then(Context context, Scriptable scriptable, LambdaConstructor lambdaConstructor, Object[] objectArray) {
        Constructable constructable = AbstractEcmaObjectOperations.speciesConstructor(context, this, lambdaConstructor);
        Capability capability = new Capability(context, scriptable, constructable);
        Callable callable = null;
        if (objectArray.length >= 1 && objectArray[0] instanceof Callable) {
            callable = (Callable)objectArray[0];
        }
        Callable callable2 = null;
        if (objectArray.length >= 2 && objectArray[1] instanceof Callable) {
            callable2 = (Callable)objectArray[1];
        }
        Reaction reaction = new Reaction(capability, ReactionType.FULFILL, callable);
        Reaction reaction2 = new Reaction(capability, ReactionType.REJECT, callable2);
        if (this.state == State.PENDING) {
            this.fulfillReactions.add(reaction);
            this.rejectReactions.add(reaction2);
        } else if (this.state == State.FULFILLED) {
            context.enqueueMicrotask(() -> reaction.invoke(context, scriptable, this.result));
        } else {
            assert (this.state == State.REJECTED);
            if (!this.handled) {
                context.getUnhandledPromiseTracker().promiseHandled(this);
            }
            context.enqueueMicrotask(() -> reaction2.invoke(context, scriptable, this.result));
        }
        this.handled = true;
        return capability.promise;
    }

    private static Object doCatch(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        Callable callable = ScriptRuntime.getPropFunctionAndThis(scriptable3, "then", context, scriptable);
        return callable.call(context, scriptable, ScriptRuntime.lastStoredScriptable(context), new Object[]{Undefined.instance, object});
    }

    private static Object doFinally(Context context, Scriptable scriptable, Scriptable scriptable2, LambdaConstructor lambdaConstructor, Object[] objectArray) {
        Callable callable;
        if (!ScriptRuntime.isObject(scriptable2)) {
            throw ScriptRuntime.typeErrorById("msg.arg.not.object", ScriptRuntime.typeof(scriptable2));
        }
        Scriptable scriptable3 = objectArray.length > 0 ? objectArray[0] : Undefined.SCRIPTABLE_UNDEFINED;
        Object object = scriptable3;
        Object object2 = scriptable3;
        Constructable constructable = AbstractEcmaObjectOperations.speciesConstructor(context, scriptable2, lambdaConstructor);
        if (scriptable3 instanceof Callable) {
            callable = (Callable)object;
            object = NativePromise.makeThenFinally(scriptable, constructable, callable);
            object2 = NativePromise.makeCatchFinally(scriptable, constructable, callable);
        }
        callable = ScriptRuntime.getPropFunctionAndThis(scriptable2, "then", context, scriptable);
        Scriptable scriptable4 = ScriptRuntime.lastStoredScriptable(context);
        return callable.call(context, scriptable, scriptable4, new Object[]{object, object2});
    }

    private static Callable makeThenFinally(Scriptable scriptable, Object object, Callable callable) {
        return new LambdaFunction(scriptable, 1, (context2, scriptable4, scriptable5, objectArray2) -> {
            Object object2 = objectArray2.length > 0 ? objectArray2[0] : Undefined.instance;
            LambdaFunction lambdaFunction = new LambdaFunction(scriptable, 0, (context, scriptable, scriptable2, objectArray) -> object2);
            Object object3 = callable.call(context2, scriptable4, Undefined.SCRIPTABLE_UNDEFINED, ScriptRuntime.emptyArgs);
            Object object4 = NativePromise.resolveInternal(context2, scriptable, object, object3);
            Callable callable2 = ScriptRuntime.getPropFunctionAndThis(object4, "then", context2, scriptable);
            return callable2.call(context2, scriptable, ScriptRuntime.lastStoredScriptable(context2), new Object[]{lambdaFunction});
        });
    }

    private static Callable makeCatchFinally(Scriptable scriptable, Object object, Callable callable) {
        return new LambdaFunction(scriptable, 1, (context2, scriptable4, scriptable5, objectArray2) -> {
            Object object2 = objectArray2.length > 0 ? objectArray2[0] : Undefined.instance;
            LambdaFunction lambdaFunction = new LambdaFunction(scriptable, 0, (context, scriptable, scriptable2, objectArray) -> {
                throw new JavaScriptException(object2, null, 0);
            });
            Object object3 = callable.call(context2, scriptable4, Undefined.SCRIPTABLE_UNDEFINED, ScriptRuntime.emptyArgs);
            Object object4 = NativePromise.resolveInternal(context2, scriptable, object, object3);
            Callable callable2 = ScriptRuntime.getPropFunctionAndThis(object4, "then", context2, scriptable);
            return callable2.call(context2, scriptable, ScriptRuntime.lastStoredScriptable(context2), new Object[]{lambdaFunction});
        });
    }

    private Object fulfillPromise(Context context, Scriptable scriptable, Object object) {
        assert (this.state == State.PENDING);
        this.result = object;
        ArrayList<Reaction> arrayList = this.fulfillReactions;
        this.fulfillReactions = new ArrayList();
        if (!this.rejectReactions.isEmpty()) {
            this.rejectReactions = new ArrayList();
        }
        this.state = State.FULFILLED;
        for (Reaction reaction : arrayList) {
            context.enqueueMicrotask(() -> reaction.invoke(context, scriptable, object));
        }
        return Undefined.instance;
    }

    private Object rejectPromise(Context context, Scriptable scriptable, Object object) {
        assert (this.state == State.PENDING);
        this.result = object;
        ArrayList<Reaction> arrayList = this.rejectReactions;
        this.rejectReactions = new ArrayList();
        if (!this.fulfillReactions.isEmpty()) {
            this.fulfillReactions = new ArrayList();
        }
        this.state = State.REJECTED;
        context.getUnhandledPromiseTracker().promiseRejected(this);
        for (Reaction reaction : arrayList) {
            context.enqueueMicrotask(() -> reaction.invoke(context, scriptable, object));
        }
        return Undefined.instance;
    }

    private void callThenable(Context context, Scriptable scriptable, Object object, Callable callable) {
        ResolvingFunctions resolvingFunctions = new ResolvingFunctions(scriptable, this);
        Scriptable scriptable2 = object instanceof Scriptable ? (Scriptable)object : Undefined.SCRIPTABLE_UNDEFINED;
        try {
            callable.call(context, scriptable, scriptable2, new Object[]{resolvingFunctions.resolve, resolvingFunctions.reject});
        }
        catch (RhinoException rhinoException) {
            resolvingFunctions.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
        }
    }

    private static Object getErrorObject(Context context, Scriptable scriptable, RhinoException rhinoException) {
        if (rhinoException instanceof JavaScriptException) {
            return ((JavaScriptException)rhinoException).getValue();
        }
        TopLevel.NativeErrors nativeErrors = TopLevel.NativeErrors.Error;
        if (rhinoException instanceof EcmaError) {
            EcmaError ecmaError = (EcmaError)rhinoException;
            switch (ecmaError.getName()) {
                case "EvalError": {
                    nativeErrors = TopLevel.NativeErrors.EvalError;
                    break;
                }
                case "RangeError": {
                    nativeErrors = TopLevel.NativeErrors.RangeError;
                    break;
                }
                case "ReferenceError": {
                    nativeErrors = TopLevel.NativeErrors.ReferenceError;
                    break;
                }
                case "SyntaxError": {
                    nativeErrors = TopLevel.NativeErrors.SyntaxError;
                    break;
                }
                case "TypeError": {
                    nativeErrors = TopLevel.NativeErrors.TypeError;
                    break;
                }
                case "URIError": {
                    nativeErrors = TopLevel.NativeErrors.URIError;
                    break;
                }
                case "InternalError": {
                    nativeErrors = TopLevel.NativeErrors.InternalError;
                    break;
                }
                case "JavaException": {
                    nativeErrors = TopLevel.NativeErrors.JavaException;
                    break;
                }
            }
        }
        return ScriptRuntime.newNativeError(context, scriptable, nativeErrors, new Object[]{rhinoException.getMessage()});
    }

    private static class Capability {
        Object promise;
        private Object rawResolve = Undefined.instance;
        Callable resolve;
        private Object rawReject = Undefined.instance;
        Callable reject;

        Capability(Context context2, Scriptable scriptable3, Object object) {
            if (!(object instanceof Constructable)) {
                throw ScriptRuntime.typeErrorById("msg.constructor.expected", new Object[0]);
            }
            Constructable constructable = (Constructable)object;
            LambdaFunction lambdaFunction = new LambdaFunction(scriptable3, 2, (context, scriptable, scriptable2, objectArray) -> this.executor(objectArray));
            this.promise = constructable.construct(context2, scriptable3, new Object[]{lambdaFunction});
            if (!(this.rawResolve instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
            }
            this.resolve = (Callable)this.rawResolve;
            if (!(this.rawReject instanceof Callable)) {
                throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
            }
            this.reject = (Callable)this.rawReject;
        }

        private Object executor(Object[] objectArray) {
            if (!Undefined.isUndefined(this.rawResolve) || !Undefined.isUndefined(this.rawReject)) {
                throw ScriptRuntime.typeErrorById("msg.promise.capability.state", new Object[0]);
            }
            if (objectArray.length > 0) {
                this.rawResolve = objectArray[0];
            }
            if (objectArray.length > 1) {
                this.rawReject = objectArray[1];
            }
            return Undefined.instance;
        }
    }

    private static class PromiseAllResolver {
        private static final int MAX_PROMISES = 0x200000;
        final ArrayList<Object> values = new ArrayList();
        int remainingElements = 1;
        IteratorLikeIterable.Itr iterator;
        Scriptable thisObj;
        Capability capability;
        boolean failFast;

        PromiseAllResolver(IteratorLikeIterable.Itr itr, Scriptable scriptable, Capability capability, boolean bl) {
            this.iterator = itr;
            this.thisObj = scriptable;
            this.capability = capability;
            this.failFast = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object resolve(Context context2, Scriptable scriptable3) {
            int n = 0;
            Callable callable = ScriptRuntime.getPropFunctionAndThis(this.thisObj, "resolve", context2, scriptable3);
            Scriptable scriptable4 = ScriptRuntime.lastStoredScriptable(context2);
            while (true) {
                Callable callable2;
                boolean bl;
                if (n == 0x200000) {
                    throw ScriptRuntime.rangeErrorById("msg.promise.all.toobig", new Object[0]);
                }
                Object object = Undefined.instance;
                boolean bl2 = false;
                try {
                    bl = this.iterator.hasNext();
                    if (bl) {
                        object = this.iterator.next();
                    }
                    bl2 = true;
                }
                finally {
                    if (!bl2) {
                        this.iterator.setDone(true);
                    }
                }
                if (!bl) {
                    if (--this.remainingElements == 0) {
                        this.finalResolution(context2, scriptable3);
                    }
                    return this.capability.promise;
                }
                this.values.add(Undefined.instance);
                Object object2 = callable.call(context2, scriptable3, scriptable4, new Object[]{object});
                PromiseElementResolver promiseElementResolver = new PromiseElementResolver(n);
                LambdaFunction lambdaFunction = new LambdaFunction(scriptable3, 1, (context, scriptable, scriptable2, objectArray) -> {
                    Object object;
                    Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
                    if (!this.failFast) {
                        Scriptable scriptable3 = context.newObject(scriptable);
                        scriptable3.put("status", scriptable3, (Object)"fulfilled");
                        scriptable3.put("value", scriptable3, object);
                        object = scriptable3;
                    }
                    return promiseElementResolver.resolve(context, scriptable, object, this);
                });
                Callable callable3 = this.capability.reject;
                if (!this.failFast) {
                    callable2 = new LambdaFunction(scriptable3, 1, (context, scriptable, scriptable2, objectArray) -> {
                        Scriptable scriptable3 = context.newObject(scriptable);
                        scriptable3.put("status", scriptable3, (Object)" rejected");
                        scriptable3.put("reason", scriptable3, objectArray.length > 0 ? objectArray[0] : Undefined.instance);
                        return promiseElementResolver.resolve(context, scriptable, scriptable3, this);
                    });
                    ((BaseFunction)callable2).setStandardPropertyAttributes(3);
                    callable3 = callable2;
                }
                ++this.remainingElements;
                callable2 = ScriptRuntime.getPropFunctionAndThis(object2, "then", context2, scriptable3);
                callable2.call(context2, scriptable3, ScriptRuntime.lastStoredScriptable(context2), new Object[]{lambdaFunction, callable3});
                ++n;
            }
        }

        void finalResolution(Context context, Scriptable scriptable) {
            Scriptable scriptable2 = context.newArray(scriptable, this.values.toArray());
            this.capability.resolve.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{scriptable2});
        }
    }

    private static class PromiseElementResolver {
        private boolean alreadyCalled = false;
        private final int index;

        PromiseElementResolver(int n) {
            this.index = n;
        }

        Object resolve(Context context, Scriptable scriptable, Object object, PromiseAllResolver promiseAllResolver) {
            if (this.alreadyCalled) {
                return Undefined.instance;
            }
            this.alreadyCalled = true;
            promiseAllResolver.values.set(this.index, object);
            if (--promiseAllResolver.remainingElements == 0) {
                promiseAllResolver.finalResolution(context, scriptable);
            }
            return Undefined.instance;
        }
    }

    private static class Reaction {
        Capability capability;
        ReactionType reaction = ReactionType.REJECT;
        Callable handler;

        Reaction(Capability capability, ReactionType reactionType, Callable callable) {
            this.capability = capability;
            this.reaction = reactionType;
            this.handler = callable;
        }

        void invoke(Context context, Scriptable scriptable, Object object) {
            try {
                Object object2 = null;
                if (this.handler == null) {
                    switch (this.reaction) {
                        case FULFILL: {
                            object2 = object;
                            break;
                        }
                        case REJECT: {
                            this.capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{object});
                            return;
                        }
                    }
                } else {
                    object2 = this.handler.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{object});
                }
                this.capability.resolve.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{object2});
            }
            catch (RhinoException rhinoException) {
                this.capability.reject.call(context, scriptable, Undefined.SCRIPTABLE_UNDEFINED, new Object[]{NativePromise.getErrorObject(context, scriptable, rhinoException)});
            }
        }
    }

    static enum ReactionType {
        FULFILL,
        REJECT;

    }

    private static class ResolvingFunctions {
        private boolean alreadyResolved = false;
        LambdaFunction resolve;
        LambdaFunction reject;

        ResolvingFunctions(Scriptable scriptable3, NativePromise nativePromise) {
            this.resolve = new LambdaFunction(scriptable3, 1, (context, scriptable, scriptable2, objectArray) -> this.resolve(context, scriptable, nativePromise, objectArray.length > 0 ? objectArray[0] : Undefined.instance));
            this.reject = new LambdaFunction(scriptable3, 1, (context, scriptable, scriptable2, objectArray) -> this.reject(context, scriptable, nativePromise, objectArray.length > 0 ? objectArray[0] : Undefined.instance));
        }

        private Object reject(Context context, Scriptable scriptable, NativePromise nativePromise, Object object) {
            if (this.alreadyResolved) {
                return Undefined.instance;
            }
            this.alreadyResolved = true;
            return nativePromise.rejectPromise(context, scriptable, object);
        }

        private Object resolve(Context context, Scriptable scriptable, NativePromise nativePromise, Object object) {
            if (this.alreadyResolved) {
                return Undefined.instance;
            }
            this.alreadyResolved = true;
            if (object == nativePromise) {
                Scriptable scriptable2 = ScriptRuntime.newNativeError(context, scriptable, TopLevel.NativeErrors.TypeError, new Object[]{"No promise self-resolution"});
                return nativePromise.rejectPromise(context, scriptable, scriptable2);
            }
            if (!ScriptRuntime.isObject(object)) {
                return nativePromise.fulfillPromise(context, scriptable, object);
            }
            Scriptable scriptable3 = ScriptableObject.ensureScriptable(object);
            Object object2 = ScriptableObject.getProperty(scriptable3, "then");
            if (!(object2 instanceof Callable)) {
                return nativePromise.fulfillPromise(context, scriptable, object);
            }
            context.enqueueMicrotask(() -> nativePromise.callThenable(context, scriptable, object, (Callable)object2));
            return Undefined.instance;
        }
    }

    static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

