/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SymbolKey;

final class NativeMath
extends ScriptableObject {
    private static final long serialVersionUID = -8838847185801131569L;
    private static final String MATH_TAG = "Math";
    private static final double LOG2E = 1.4426950408889634;
    private static final Double Double32 = 32.0;

    static void init(Scriptable scriptable, boolean bl) {
        NativeMath nativeMath = new NativeMath();
        nativeMath.setPrototype(NativeMath.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        nativeMath.defineProperty("toSource", (Object)MATH_TAG, 7);
        nativeMath.defineProperty(scriptable, "abs", 1, NativeMath::abs, 2, 3);
        nativeMath.defineProperty(scriptable, "acos", 1, NativeMath::acos, 2, 3);
        nativeMath.defineProperty(scriptable, "acosh", 1, NativeMath::acosh, 2, 3);
        nativeMath.defineProperty(scriptable, "asin", 1, NativeMath::asin, 2, 3);
        nativeMath.defineProperty(scriptable, "asinh", 1, NativeMath::asinh, 2, 3);
        nativeMath.defineProperty(scriptable, "atan", 1, NativeMath::atan, 2, 3);
        nativeMath.defineProperty(scriptable, "atanh", 1, NativeMath::atanh, 2, 3);
        nativeMath.defineProperty(scriptable, "atan2", 2, NativeMath::atan2, 2, 3);
        nativeMath.defineProperty(scriptable, "cbrt", 1, NativeMath::cbrt, 2, 3);
        nativeMath.defineProperty(scriptable, "ceil", 1, NativeMath::ceil, 2, 3);
        nativeMath.defineProperty(scriptable, "clz32", 1, NativeMath::clz32, 2, 3);
        nativeMath.defineProperty(scriptable, "cos", 1, NativeMath::cos, 2, 3);
        nativeMath.defineProperty(scriptable, "cosh", 1, NativeMath::cosh, 2, 3);
        nativeMath.defineProperty(scriptable, "exp", 1, NativeMath::exp, 2, 3);
        nativeMath.defineProperty(scriptable, "expm1", 1, NativeMath::expm1, 2, 3);
        nativeMath.defineProperty(scriptable, "floor", 1, NativeMath::floor, 2, 3);
        nativeMath.defineProperty(scriptable, "fround", 1, NativeMath::fround, 2, 3);
        nativeMath.defineProperty(scriptable, "hypot", 2, NativeMath::hypot, 2, 3);
        nativeMath.defineProperty(scriptable, "imul", 2, NativeMath::imul, 2, 3);
        nativeMath.defineProperty(scriptable, "log", 1, NativeMath::log, 2, 3);
        nativeMath.defineProperty(scriptable, "log1p", 1, NativeMath::log1p, 2, 3);
        nativeMath.defineProperty(scriptable, "log10", 1, NativeMath::log10, 2, 3);
        nativeMath.defineProperty(scriptable, "log2", 1, NativeMath::log2, 2, 3);
        nativeMath.defineProperty(scriptable, "max", 2, NativeMath::max, 2, 3);
        nativeMath.defineProperty(scriptable, "min", 2, NativeMath::min, 2, 3);
        nativeMath.defineProperty(scriptable, "pow", 2, NativeMath::pow, 2, 3);
        nativeMath.defineProperty(scriptable, "random", 0, NativeMath::random, 2, 3);
        nativeMath.defineProperty(scriptable, "round", 1, NativeMath::round, 2, 3);
        nativeMath.defineProperty(scriptable, "sign", 1, NativeMath::sign, 2, 3);
        nativeMath.defineProperty(scriptable, "sin", 1, NativeMath::sin, 2, 3);
        nativeMath.defineProperty(scriptable, "sinh", 1, NativeMath::sinh, 2, 3);
        nativeMath.defineProperty(scriptable, "sqrt", 1, NativeMath::sqrt, 2, 3);
        nativeMath.defineProperty(scriptable, "tan", 1, NativeMath::tan, 2, 3);
        nativeMath.defineProperty(scriptable, "tanh", 1, NativeMath::tanh, 2, 3);
        nativeMath.defineProperty(scriptable, "trunc", 1, NativeMath::trunc, 2, 3);
        nativeMath.defineProperty("E", (Object)Math.E, 7);
        nativeMath.defineProperty("PI", (Object)Math.PI, 7);
        nativeMath.defineProperty("LN10", (Object)2.302585092994046, 7);
        nativeMath.defineProperty("LN2", (Object)0.6931471805599453, 7);
        nativeMath.defineProperty("LOG2E", (Object)1.4426950408889634, 7);
        nativeMath.defineProperty("LOG10E", (Object)0.4342944819032518, 7);
        nativeMath.defineProperty("SQRT1_2", (Object)0.7071067811865476, 7);
        nativeMath.defineProperty("SQRT2", (Object)1.4142135623730951, 7);
        nativeMath.defineProperty(SymbolKey.TO_STRING_TAG, (Object)MATH_TAG, 3);
        ScriptableObject.defineProperty(scriptable, MATH_TAG, nativeMath, 2);
        if (bl) {
            nativeMath.sealObject();
        }
    }

    private NativeMath() {
    }

    @Override
    public String getClassName() {
        return MATH_TAG;
    }

    private static Object abs(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = d == 0.0 ? 0.0 : (d < 0.0 ? -d : d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object acos(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = !Double.isNaN(d) && -1.0 <= d && d <= 1.0 ? Math.acos(d) : Double.NaN;
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object acosh(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        if (!Double.isNaN(d)) {
            return Math.log(d + Math.sqrt(d * d - 1.0));
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object asin(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = !Double.isNaN(d) && -1.0 <= d && d <= 1.0 ? Math.asin(d) : Double.NaN;
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object asinh(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        if (Double.isInfinite(d)) {
            return d;
        }
        if (!Double.isNaN(d)) {
            if (d == 0.0) {
                if (1.0 / d > 0.0) {
                    return ScriptRuntime.zeroObj;
                }
                return ScriptRuntime.negativeZeroObj;
            }
            return Math.log(d + Math.sqrt(d * d + 1.0));
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object atan(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.atan(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object atanh(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        if (!Double.isNaN(d) && -1.0 <= d && d <= 1.0) {
            if (d == 0.0) {
                if (1.0 / d > 0.0) {
                    return ScriptRuntime.zeroObj;
                }
                return ScriptRuntime.negativeZeroObj;
            }
            return 0.5 * Math.log((d + 1.0) / (d - 1.0));
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object atan2(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.atan2(d, ScriptRuntime.toNumber(objectArray, 1));
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object cbrt(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.cbrt(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object ceil(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.ceil(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object clz32(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        if (d == 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            return Double32;
        }
        long l = ScriptRuntime.toUint32(d);
        if (l == 0L) {
            return Double32;
        }
        return 31.0 - Math.floor(Math.log(l >>> 0) * 1.4426950408889634);
    }

    private static Object cos(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Double.isInfinite(d) ? Double.NaN : Math.cos(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object cosh(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.cosh(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object exp(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = d == Double.POSITIVE_INFINITY ? d : (d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d));
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object expm1(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.expm1(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object floor(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.floor(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object fround(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = (float)d;
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object hypot(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray == null) {
            return 0.0;
        }
        double d = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        for (Object object : objectArray) {
            double d2 = ScriptRuntime.toNumber(object);
            if (Double.isNaN(d2)) {
                bl = true;
                continue;
            }
            if (Double.isInfinite(d2)) {
                bl2 = true;
                continue;
            }
            d += d2 * d2;
        }
        if (bl2) {
            return Double.POSITIVE_INFINITY;
        }
        if (bl) {
            return Double.NaN;
        }
        return Math.sqrt(d);
    }

    private static Object imul(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = ScriptRuntime.toInt32(objectArray, 0);
        int n2 = ScriptRuntime.toInt32(objectArray, 1);
        return ScriptRuntime.wrapNumber(n * n2);
    }

    private static Object log(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = d < 0.0 ? Double.NaN : Math.log(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object log1p(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.log1p(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object log10(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.log10(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object log2(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = d < 0.0 ? Double.NaN : Math.log(d) * 1.4426950408889634;
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object max(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i != objectArray.length; ++i) {
            double d2 = ScriptRuntime.toNumber(objectArray[i]);
            d = Math.max(d, d2);
        }
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object min(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i != objectArray.length; ++i) {
            double d2 = ScriptRuntime.toNumber(objectArray[i]);
            d = Math.min(d, d2);
        }
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object pow(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d;
        double d2 = ScriptRuntime.toNumber(objectArray, 0);
        double d3 = ScriptRuntime.toNumber(objectArray, 1);
        if (Double.isNaN(d3)) {
            d = d3;
        } else if (d3 == 0.0) {
            d = 1.0;
        } else if (d2 == 0.0) {
            long l;
            d = 1.0 / d2 > 0.0 ? (d3 > 0.0 ? 0.0 : Double.POSITIVE_INFINITY) : ((double)(l = (long)d3) == d3 && (l & 1L) != 0L ? (d3 > 0.0 ? -0.0 : Double.NEGATIVE_INFINITY) : (d3 > 0.0 ? 0.0 : Double.POSITIVE_INFINITY));
        } else {
            d = Math.pow(d2, d3);
            if (Double.isNaN(d)) {
                if (d3 == Double.POSITIVE_INFINITY) {
                    if (d2 < -1.0 || 1.0 < d2) {
                        d = Double.POSITIVE_INFINITY;
                    } else if (-1.0 < d2 && d2 < 1.0) {
                        d = 0.0;
                    }
                } else if (d3 == Double.NEGATIVE_INFINITY) {
                    if (d2 < -1.0 || 1.0 < d2) {
                        d = 0.0;
                    } else if (-1.0 < d2 && d2 < 1.0) {
                        d = Double.POSITIVE_INFINITY;
                    }
                } else if (d2 == Double.POSITIVE_INFINITY) {
                    d = d3 > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                } else if (d2 == Double.NEGATIVE_INFINITY) {
                    long l = (long)d3;
                    d = (double)l == d3 && (l & 1L) != 0L ? (d3 > 0.0 ? Double.NEGATIVE_INFINITY : -0.0) : (d3 > 0.0 ? Double.POSITIVE_INFINITY : 0.0);
                }
            }
        }
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object random(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return ScriptRuntime.wrapNumber(Math.random());
    }

    private static Object round(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        if (!Double.isNaN(d) && !Double.isInfinite(d)) {
            long l = Math.round(d);
            if (l != 0L) {
                d = l;
            } else if (d < 0.0) {
                d = ScriptRuntime.negativeZero;
            } else if (d != 0.0) {
                d = 0.0;
            }
        }
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object sign(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        if (!Double.isNaN(d)) {
            if (d == 0.0) {
                if (1.0 / d > 0.0) {
                    return ScriptRuntime.zeroObj;
                }
                return ScriptRuntime.negativeZeroObj;
            }
            return Math.signum(d);
        }
        return ScriptRuntime.NaNobj;
    }

    private static Object sin(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Double.isInfinite(d) ? Double.NaN : Math.sin(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object sinh(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.sinh(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object sqrt(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.sqrt(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object tan(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.tan(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object tanh(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = Math.tanh(d);
        return ScriptRuntime.wrapNumber(d);
    }

    private static Object trunc(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        double d = ScriptRuntime.toNumber(objectArray, 0);
        d = d < 0.0 ? Math.ceil(d) : Math.floor(d);
        return ScriptRuntime.wrapNumber(d);
    }
}

