/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.IteratorLikeIterable;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptRuntimeES6;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Sorting;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.xml.XMLObject;

public class NativeArray
extends IdScriptableObject
implements List {
    private static final long serialVersionUID = 7331366857676127338L;
    private static final Object ARRAY_TAG = "Array";
    private static final Long NEGATIVE_ONE = -1L;
    private static final int Id_length = 1;
    private static final int MAX_INSTANCE_ID = 1;
    private static final Comparator<Object> STRING_COMPARATOR = new StringLikeComparator();
    private static final Comparator<Object> DEFAULT_COMPARATOR = new ElementComparator();
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_join = 5;
    private static final int Id_reverse = 6;
    private static final int Id_sort = 7;
    private static final int Id_push = 8;
    private static final int Id_pop = 9;
    private static final int Id_shift = 10;
    private static final int Id_unshift = 11;
    private static final int Id_splice = 12;
    private static final int Id_concat = 13;
    private static final int Id_slice = 14;
    private static final int Id_indexOf = 15;
    private static final int Id_lastIndexOf = 16;
    private static final int Id_every = 17;
    private static final int Id_filter = 18;
    private static final int Id_forEach = 19;
    private static final int Id_map = 20;
    private static final int Id_some = 21;
    private static final int Id_find = 22;
    private static final int Id_findIndex = 23;
    private static final int Id_reduce = 24;
    private static final int Id_reduceRight = 25;
    private static final int Id_fill = 26;
    private static final int Id_keys = 27;
    private static final int Id_values = 28;
    private static final int Id_entries = 29;
    private static final int Id_includes = 30;
    private static final int Id_copyWithin = 31;
    private static final int Id_at = 32;
    private static final int Id_flat = 33;
    private static final int Id_flatMap = 34;
    private static final int SymbolId_iterator = 35;
    private static final int MAX_PROTOTYPE_ID = 35;
    private static final int ConstructorId_join = -5;
    private static final int ConstructorId_reverse = -6;
    private static final int ConstructorId_sort = -7;
    private static final int ConstructorId_push = -8;
    private static final int ConstructorId_pop = -9;
    private static final int ConstructorId_shift = -10;
    private static final int ConstructorId_unshift = -11;
    private static final int ConstructorId_splice = -12;
    private static final int ConstructorId_concat = -13;
    private static final int ConstructorId_slice = -14;
    private static final int ConstructorId_indexOf = -15;
    private static final int ConstructorId_lastIndexOf = -16;
    private static final int ConstructorId_every = -17;
    private static final int ConstructorId_filter = -18;
    private static final int ConstructorId_forEach = -19;
    private static final int ConstructorId_map = -20;
    private static final int ConstructorId_some = -21;
    private static final int ConstructorId_find = -22;
    private static final int ConstructorId_findIndex = -23;
    private static final int ConstructorId_reduce = -24;
    private static final int ConstructorId_reduceRight = -25;
    private static final int ConstructorId_isArray = -26;
    private static final int ConstructorId_of = -27;
    private static final int ConstructorId_from = -28;
    private long length;
    private int lengthAttr = 6;
    private transient int modCount;
    private Object[] dense;
    private boolean denseOnly;
    private static int maximumInitialCapacity = 10000;
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final double GROW_FACTOR = 1.5;
    private static final int MAX_PRE_GROW_SIZE = 0x55555554;

    static void init(Scriptable scriptable, boolean bl) {
        NativeArray nativeArray = new NativeArray(0L);
        nativeArray.exportAsJSClass(35, scriptable, bl);
    }

    static int getMaximumInitialCapacity() {
        return maximumInitialCapacity;
    }

    static void setMaximumInitialCapacity(int n) {
        maximumInitialCapacity = n;
    }

    public NativeArray(long l) {
        boolean bl = this.denseOnly = l <= (long)maximumInitialCapacity;
        if (this.denseOnly) {
            int n = (int)l;
            if (n < 10) {
                n = 10;
            }
            this.dense = new Object[n];
            Arrays.fill(this.dense, Scriptable.NOT_FOUND);
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.denseOnly = true;
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    @Override
    public String getClassName() {
        return "Array";
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        if (n == 1) {
            this.lengthAttr = n2;
        }
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if (string.equals("length")) {
            return NativeArray.instanceIdInfo(this.lengthAttr, 1);
        }
        return super.findInstanceIdInfo(string);
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "length";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapNumber(this.length);
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        if (n == 1) {
            this.setLength(object);
            return;
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -5, "join", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -6, "reverse", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -7, "sort", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -8, "push", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -9, "pop", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -10, "shift", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -11, "unshift", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -12, "splice", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -13, "concat", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -14, "slice", 2);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -15, "indexOf", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -16, "lastIndexOf", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -17, "every", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -18, "filter", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -19, "forEach", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -20, "map", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -21, "some", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -22, "find", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -23, "findIndex", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -24, "reduce", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -25, "reduceRight", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -26, "isArray", 1);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -27, "of", 0);
        this.addIdFunctionProperty(idFunctionObject, ARRAY_TAG, -28, "from", 1);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n == 35) {
            this.initPrototypeMethod(ARRAY_TAG, n, SymbolKey.ITERATOR, "[Symbol.iterator]", 0);
            return;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 5: {
                n2 = 1;
                string = "join";
                break;
            }
            case 6: {
                n2 = 0;
                string = "reverse";
                break;
            }
            case 7: {
                n2 = 1;
                string = "sort";
                break;
            }
            case 8: {
                n2 = 1;
                string = "push";
                break;
            }
            case 9: {
                n2 = 0;
                string = "pop";
                break;
            }
            case 10: {
                n2 = 0;
                string = "shift";
                break;
            }
            case 11: {
                n2 = 1;
                string = "unshift";
                break;
            }
            case 12: {
                n2 = 2;
                string = "splice";
                break;
            }
            case 13: {
                n2 = 1;
                string = "concat";
                break;
            }
            case 14: {
                n2 = 2;
                string = "slice";
                break;
            }
            case 15: {
                n2 = 1;
                string = "indexOf";
                break;
            }
            case 16: {
                n2 = 1;
                string = "lastIndexOf";
                break;
            }
            case 17: {
                n2 = 1;
                string = "every";
                break;
            }
            case 18: {
                n2 = 1;
                string = "filter";
                break;
            }
            case 19: {
                n2 = 1;
                string = "forEach";
                break;
            }
            case 20: {
                n2 = 1;
                string = "map";
                break;
            }
            case 21: {
                n2 = 1;
                string = "some";
                break;
            }
            case 22: {
                n2 = 1;
                string = "find";
                break;
            }
            case 23: {
                n2 = 1;
                string = "findIndex";
                break;
            }
            case 24: {
                n2 = 1;
                string = "reduce";
                break;
            }
            case 25: {
                n2 = 1;
                string = "reduceRight";
                break;
            }
            case 26: {
                n2 = 1;
                string = "fill";
                break;
            }
            case 27: {
                n2 = 0;
                string = "keys";
                break;
            }
            case 28: {
                n2 = 0;
                string = "values";
                break;
            }
            case 29: {
                n2 = 0;
                string = "entries";
                break;
            }
            case 30: {
                n2 = 1;
                string = "includes";
                break;
            }
            case 31: {
                n2 = 2;
                string = "copyWithin";
                break;
            }
            case 32: {
                n2 = 1;
                string = "at";
                break;
            }
            case 33: {
                n2 = 0;
                string = "flat";
                break;
            }
            case 34: {
                n2 = 1;
                string = "flatMap";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(ARRAY_TAG, n, string, string2, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(ARRAY_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        block33: while (true) {
            switch (n) {
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: 
                case -19: 
                case -18: 
                case -17: 
                case -16: 
                case -15: 
                case -14: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: {
                    if (objectArray.length > 0) {
                        scriptable2 = ScriptRuntime.toObject(context, scriptable, objectArray[0]);
                        Object[] objectArray2 = new Object[objectArray.length - 1];
                        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
                        objectArray = objectArray2;
                    }
                    n = -n;
                    continue block33;
                }
                case -26: {
                    return objectArray.length > 0 && NativeArray.js_isArray(objectArray[0]);
                }
                case -27: {
                    return NativeArray.js_of(context, scriptable, scriptable2, objectArray);
                }
                case -28: {
                    return NativeArray.js_from(context, scriptable, scriptable2, objectArray);
                }
                case 1: {
                    boolean bl;
                    boolean bl2 = bl = scriptable2 == null;
                    if (!bl) {
                        return idFunctionObject.construct(context, scriptable, objectArray);
                    }
                    return NativeArray.jsConstructor(context, scriptable, objectArray);
                }
                case 2: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, context.hasFeature(4), false);
                }
                case 3: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, false, true);
                }
                case 4: {
                    return NativeArray.toStringHelper(context, scriptable, scriptable2, true, false);
                }
                case 5: {
                    return NativeArray.js_join(context, scriptable, scriptable2, objectArray);
                }
                case 6: {
                    return NativeArray.js_reverse(context, scriptable, scriptable2, objectArray);
                }
                case 7: {
                    return NativeArray.js_sort(context, scriptable, scriptable2, objectArray);
                }
                case 8: {
                    return NativeArray.js_push(context, scriptable, scriptable2, objectArray);
                }
                case 9: {
                    return NativeArray.js_pop(context, scriptable, scriptable2, objectArray);
                }
                case 10: {
                    return NativeArray.js_shift(context, scriptable, scriptable2, objectArray);
                }
                case 11: {
                    return NativeArray.js_unshift(context, scriptable, scriptable2, objectArray);
                }
                case 12: {
                    return NativeArray.js_splice(context, scriptable, scriptable2, objectArray);
                }
                case 13: {
                    return NativeArray.js_concat(context, scriptable, scriptable2, objectArray);
                }
                case 14: {
                    return NativeArray.js_slice(context, scriptable, scriptable2, objectArray);
                }
                case 15: {
                    return NativeArray.js_indexOf(context, scriptable, scriptable2, objectArray);
                }
                case 16: {
                    return NativeArray.js_lastIndexOf(context, scriptable, scriptable2, objectArray);
                }
                case 30: {
                    return NativeArray.js_includes(context, scriptable, scriptable2, objectArray);
                }
                case 26: {
                    return NativeArray.js_fill(context, scriptable, scriptable2, objectArray);
                }
                case 31: {
                    return NativeArray.js_copyWithin(context, scriptable, scriptable2, objectArray);
                }
                case 32: {
                    return NativeArray.js_at(context, scriptable, scriptable2, objectArray);
                }
                case 33: {
                    return NativeArray.js_flat(context, scriptable, scriptable2, objectArray);
                }
                case 34: {
                    return NativeArray.js_flatMap(context, scriptable, scriptable2, objectArray);
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    return NativeArray.iterativeMethod(context, idFunctionObject, scriptable, scriptable2, objectArray);
                }
                case 24: 
                case 25: {
                    return NativeArray.reduceMethod(context, n, scriptable, scriptable2, objectArray);
                }
                case 27: {
                    scriptable2 = ScriptRuntime.toObject(context, scriptable, scriptable2);
                    return new NativeArrayIterator(scriptable, scriptable2, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
                }
                case 29: {
                    scriptable2 = ScriptRuntime.toObject(context, scriptable, scriptable2);
                    return new NativeArrayIterator(scriptable, scriptable2, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
                }
                case 28: 
                case 35: {
                    scriptable2 = ScriptRuntime.toObject(context, scriptable, scriptable2);
                    return new NativeArrayIterator(scriptable, scriptable2, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
                }
            }
            break;
        }
        throw new IllegalArgumentException("Array.prototype has no method: " + idFunctionObject.getFunctionName());
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.get(n, scriptable);
        }
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (!this.denseOnly && this.isGetterOrSetter(null, n, false)) {
            return super.has(n, scriptable);
        }
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n] != NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static long toArrayIndex(Object object) {
        if (object instanceof String) {
            return NativeArray.toArrayIndex((String)object);
        }
        if (object instanceof Number) {
            return NativeArray.toArrayIndex(((Number)object).doubleValue());
        }
        return -1L;
    }

    private static long toArrayIndex(String string) {
        long l = NativeArray.toArrayIndex(ScriptRuntime.toNumber(string));
        if (Long.toString(l).equals(string)) {
            return l;
        }
        return -1L;
    }

    private static long toArrayIndex(double d) {
        long l;
        if (!Double.isNaN(d) && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL) {
            return l;
        }
        return -1L;
    }

    private static int toDenseIndex(Object object) {
        long l = NativeArray.toArrayIndex(object);
        return 0L <= l && l < Integer.MAX_VALUE ? (int)l : -1;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        long l;
        super.put(string, scriptable, object);
        if (scriptable == this && (l = NativeArray.toArrayIndex(string)) >= this.length) {
            this.length = l + 1L;
            ++this.modCount;
            this.denseOnly = false;
        }
    }

    private boolean ensureCapacity(int n) {
        if (n > this.dense.length) {
            if (n > 0x55555554) {
                this.denseOnly = false;
                return false;
            }
            n = Math.max(n, (int)((double)this.dense.length * 1.5));
            Object[] objectArray = new Object[n];
            System.arraycopy(this.dense, 0, objectArray, 0, this.dense.length);
            Arrays.fill(objectArray, this.dense.length, objectArray.length, Scriptable.NOT_FOUND);
            this.dense = objectArray;
        }
        return true;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (!(scriptable != this || this.isSealed() || this.dense == null || 0 > n || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            if (!this.isExtensible() && this.length <= (long)n) {
                return;
            }
            if (n < this.dense.length) {
                this.dense[n] = object;
                if (this.length <= (long)n) {
                    this.length = (long)n + 1L;
                    ++this.modCount;
                }
                return;
            }
            if (this.denseOnly && (double)n < (double)this.dense.length * 1.5 && this.ensureCapacity(n + 1)) {
                this.dense[n] = object;
                this.length = (long)n + 1L;
                ++this.modCount;
                return;
            }
            this.denseOnly = false;
        }
        super.put(n, scriptable, object);
        if (scriptable == this && (this.lengthAttr & 1) == 0 && this.length <= (long)n) {
            this.length = (long)n + 1L;
            ++this.modCount;
        }
    }

    @Override
    public void delete(int n) {
        if (!(this.dense == null || 0 > n || n >= this.dense.length || this.isSealed() || !this.denseOnly && this.isGetterOrSetter(null, n, true))) {
            this.dense[n] = NOT_FOUND;
        } else {
            super.delete(n);
        }
    }

    @Override
    public Object[] getIds(boolean bl, boolean bl2) {
        Object[] objectArray = super.getIds(bl, bl2);
        if (this.dense == null) {
            return objectArray;
        }
        int n = this.dense.length;
        long l = this.length;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n == 0) {
            return objectArray;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n + n2];
        int n3 = 0;
        for (int i = 0; i != n; ++i) {
            if (this.dense[i] == NOT_FOUND) continue;
            objectArray2[n3] = i;
            ++n3;
        }
        if (n3 != n) {
            Object[] objectArray3 = new Object[n3 + n2];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n3);
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, objectArray2, n3, n2);
        return objectArray2;
    }

    public List<Integer> getIndexIds() {
        Object[] objectArray = this.getIds();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(objectArray.length);
        for (Object object : objectArray) {
            int n = ScriptRuntime.toInt32(object);
            if (n < 0 || !ScriptRuntime.toString(n).equals(ScriptRuntime.toString(object))) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return this.length;
        }
        return super.getDefaultValue(clazz);
    }

    private ScriptableObject defaultIndexPropertyDescriptor(Object object) {
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.defineProperty("value", object, 0);
        nativeObject.defineProperty("writable", (Object)Boolean.TRUE, 0);
        nativeObject.defineProperty("enumerable", (Object)Boolean.TRUE, 0);
        nativeObject.defineProperty("configurable", (Object)Boolean.TRUE, 0);
        return nativeObject;
    }

    @Override
    public int getAttributes(int n) {
        if (this.dense != null && n >= 0 && n < this.dense.length && this.dense[n] != NOT_FOUND) {
            return 0;
        }
        return super.getAttributes(n);
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        int n;
        if (this.dense != null && 0 <= (n = NativeArray.toDenseIndex(object)) && n < this.dense.length && this.dense[n] != NOT_FOUND) {
            Object object2 = this.dense[n];
            return this.defaultIndexPropertyDescriptor(object2);
        }
        return super.getOwnPropertyDescriptor(context, object);
    }

    @Override
    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        long l = NativeArray.toArrayIndex(object);
        if (l >= this.length) {
            this.length = l + 1L;
            ++this.modCount;
        }
        if (l != -1L && this.dense != null) {
            Object[] objectArray = this.dense;
            this.dense = null;
            this.denseOnly = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == NOT_FOUND) continue;
                if (!this.isExtensible()) {
                    this.setAttributes(i, 0);
                }
                this.put(i, (Scriptable)this, objectArray[i]);
            }
        }
        super.defineOwnProperty(context, object, scriptableObject, bl);
        if ("length".equals(object)) {
            this.lengthAttr = this.getAttributes("length");
        }
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length == 0) {
            return new NativeArray(0L);
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        Object object = objectArray[0];
        if (objectArray.length > 1 || !(object instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(object);
        if ((double)l != ((Number)object).doubleValue()) {
            String string = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(string);
        }
        return new NativeArray(l);
    }

    private static Scriptable callConstructorOrCreateArray(Context context, Scriptable scriptable, Scriptable scriptable2, long l, boolean bl) {
        Scriptable scriptable3;
        block6: {
            scriptable3 = null;
            if (scriptable2 instanceof Function) {
                try {
                    Object[] objectArray;
                    if (bl || l > 0L) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = l;
                    } else {
                        objectArray = ScriptRuntime.emptyArgs;
                    }
                    Object[] objectArray3 = objectArray;
                    scriptable3 = ((Function)scriptable2).construct(context, scriptable, objectArray3);
                }
                catch (EcmaError ecmaError) {
                    if ("TypeError".equals(ecmaError.getName())) break block6;
                    throw ecmaError;
                }
            }
        }
        if (scriptable3 == null) {
            scriptable3 = context.newArray(scriptable, l > Integer.MAX_VALUE ? 0 : (int)l);
        }
        return scriptable3;
    }

    private static Object js_from(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Scriptable scriptable3 = ScriptRuntime.toObject(scriptable, objectArray.length >= 1 ? objectArray[0] : Undefined.instance);
        Object object2 = objectArray.length >= 2 ? objectArray[1] : Undefined.instance;
        Scriptable scriptable4 = Undefined.SCRIPTABLE_UNDEFINED;
        boolean bl = !Undefined.isUndefined(object2);
        Function function = null;
        if (bl) {
            if (!(object2 instanceof Function)) {
                throw ScriptRuntime.typeErrorById("msg.map.function.not", new Object[0]);
            }
            function = (Function)object2;
            if (objectArray.length >= 3) {
                scriptable4 = NativeArray.ensureScriptable(objectArray[2]);
            }
        }
        Object object3 = ScriptableObject.getProperty(scriptable3, SymbolKey.ITERATOR);
        if (!(scriptable3 instanceof NativeArray || object3 == Scriptable.NOT_FOUND || Undefined.isUndefined(object3) || Undefined.isUndefined(object = ScriptRuntime.callIterator(scriptable3, context, scriptable)))) {
            Scriptable scriptable5 = NativeArray.callConstructorOrCreateArray(context, scriptable, scriptable2, 0L, false);
            long l = 0L;
            try (IteratorLikeIterable iteratorLikeIterable = new IteratorLikeIterable(context, scriptable, object);){
                for (Object object4 : iteratorLikeIterable) {
                    if (bl) {
                        object4 = function.call(context, scriptable, scriptable4, new Object[]{object4, l});
                    }
                    NativeArray.defineElem(context, scriptable5, l, object4);
                    ++l;
                }
            }
            NativeArray.setLengthProperty(context, scriptable5, l);
            return scriptable5;
        }
        long l = NativeArray.getLengthProperty(context, scriptable3);
        Scriptable scriptable6 = NativeArray.callConstructorOrCreateArray(context, scriptable, scriptable2, l, true);
        for (long i = 0L; i < l; ++i) {
            Object object5 = NativeArray.getElem(context, scriptable3, i);
            if (bl) {
                object5 = function.call(context, scriptable, scriptable4, new Object[]{object5, i});
            }
            NativeArray.defineElem(context, scriptable6, i, object5);
        }
        NativeArray.setLengthProperty(context, scriptable6, l);
        return scriptable6;
    }

    private static Object js_of(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = NativeArray.callConstructorOrCreateArray(context, scriptable, scriptable2, objectArray.length, true);
        if (context.getLanguageVersion() >= 200 && scriptable3 instanceof ScriptableObject) {
            ScriptableObject scriptableObject = ScriptableObject.buildDataDescriptor(scriptable3, null, 0);
            for (int i = 0; i < objectArray.length; ++i) {
                scriptableObject.put("value", (Scriptable)scriptableObject, objectArray[i]);
                ((ScriptableObject)scriptable3).defineOwnProperty(context, i, scriptableObject);
            }
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                NativeArray.defineElem(context, scriptable3, i, objectArray[i]);
            }
        }
        NativeArray.setLengthProperty(context, scriptable3, objectArray.length);
        return scriptable3;
    }

    public long getLength() {
        return this.length;
    }

    @Deprecated
    public long jsGet_length() {
        return this.getLength();
    }

    void setDenseOnly(boolean bl) {
        if (bl && !this.denseOnly) {
            throw new IllegalArgumentException();
        }
        this.denseOnly = bl;
    }

    private void setLength(Object object) {
        if ((this.lengthAttr & 1) != 0) {
            return;
        }
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d) {
            String string = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(string);
        }
        if (this.denseOnly) {
            if (l < this.length) {
                Arrays.fill(this.dense, (int)l, this.dense.length, NOT_FOUND);
                this.length = l;
                ++this.modCount;
                return;
            }
            if (l < 0x55555554L && (double)l < (double)this.length * 1.5 && this.ensureCapacity((int)l)) {
                this.length = l;
                ++this.modCount;
                return;
            }
            this.denseOnly = false;
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray;
                for (Object object2 : objectArray = this.getIds()) {
                    if (object2 instanceof String) {
                        String string = (String)object2;
                        long l2 = NativeArray.toArrayIndex(string);
                        if (l2 < l) continue;
                        this.delete(string);
                        continue;
                    }
                    int n = (Integer)object2;
                    if ((long)n < l) continue;
                    this.delete(n);
                }
            } else {
                for (long i = l; i < this.length; ++i) {
                    NativeArray.deleteElem(this, i);
                }
            }
        }
        this.length = l;
        ++this.modCount;
    }

    static long getLengthProperty(Context context, Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).getLength();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).getLength();
        }
        if (scriptable instanceof XMLObject) {
            Callable callable = (Callable)scriptable.get("length", scriptable);
            return ((Number)callable.call(context, scriptable, scriptable, ScriptRuntime.emptyArgs)).longValue();
        }
        Object object = ScriptableObject.getProperty(scriptable, "length");
        if (object == Scriptable.NOT_FOUND) {
            return 0L;
        }
        double d = ScriptRuntime.toNumber(object);
        if (d > 9.007199254740991E15) {
            return 0x1FFFFFFFFFFFFFL;
        }
        if (d < 0.0) {
            return 0L;
        }
        return (long)d;
    }

    private static Object setLengthProperty(Context context, Scriptable scriptable, long l) {
        Number number = ScriptRuntime.wrapNumber(l);
        ScriptableObject.putProperty(scriptable, "length", (Object)number);
        return number;
    }

    private static void deleteElem(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private static Object getElem(Context context, Scriptable scriptable, long l) {
        Object object = NativeArray.getRawElem(scriptable, l);
        return object != Scriptable.NOT_FOUND ? object : Undefined.instance;
    }

    private static Object getRawElem(Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            return ScriptableObject.getProperty(scriptable, Long.toString(l));
        }
        return ScriptableObject.getProperty(scriptable, (int)l);
    }

    private static void defineElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            scriptable.put(string, scriptable, object);
        } else {
            scriptable.put((int)l, scriptable, object);
        }
    }

    private static void defineElemOrThrow(Context context, Scriptable scriptable, long l, Object object) {
        if ((double)l > 9.007199254740991E15) {
            throw ScriptRuntime.typeErrorById("msg.arraylength.too.big", String.valueOf(l));
        }
        NativeArray.defineElem(context, scriptable, l, object);
    }

    private static void setElem(Context context, Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptableObject.putProperty(scriptable, string, object);
        } else {
            ScriptableObject.putProperty(scriptable, (int)l, object);
        }
    }

    private static void setRawElem(Context context, Scriptable scriptable, long l, Object object) {
        if (object == NOT_FOUND) {
            NativeArray.deleteElem(scriptable, l);
        } else {
            NativeArray.setElem(context, scriptable, l, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toStringHelper(Context context, Scriptable scriptable, Scriptable scriptable2, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        String string;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        StringBuilder stringBuilder = new StringBuilder(256);
        if (bl) {
            stringBuilder.append('[');
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl5 = false;
        long l2 = 0L;
        if (context.iterating == null) {
            bl4 = true;
            bl3 = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl4 = false;
            bl3 = context.iterating.has(scriptable3);
        }
        try {
            if (!bl3) {
                context.iterating.put(scriptable3, 0);
                boolean bl6 = !bl || context.getLanguageVersion() < 150;
                for (l2 = 0L; l2 < l; ++l2) {
                    Object object;
                    if (l2 > 0L) {
                        stringBuilder.append(string);
                    }
                    if ((object = NativeArray.getRawElem(scriptable3, l2)) == NOT_FOUND || bl6 && (object == null || object == Undefined.instance)) {
                        bl5 = false;
                        continue;
                    }
                    bl5 = true;
                    if (bl) {
                        stringBuilder.append(ScriptRuntime.uneval(context, scriptable, object));
                        continue;
                    }
                    if (object instanceof String) {
                        stringBuilder.append((String)object);
                        continue;
                    }
                    if (bl2) {
                        Callable callable = ScriptRuntime.getPropFunctionAndThis(object, "toLocaleString", context, scriptable);
                        Scriptable scriptable4 = ScriptRuntime.lastStoredScriptable(context);
                        object = callable.call(context, scriptable, scriptable4, ScriptRuntime.emptyArgs);
                    }
                    stringBuilder.append(ScriptRuntime.toString(object));
                }
                context.iterating.remove(scriptable3);
            }
        }
        finally {
            if (bl4) {
                context.iterating = null;
            }
        }
        if (bl) {
            if (!bl5 && l2 > 0L) {
                stringBuilder.append(", ]");
            } else {
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }

    private static Function getCallbackArg(Context context, Object object) {
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        if (context.getLanguageVersion() >= 200 && object instanceof NativeRegExp) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Function function = (Function)object;
        return function;
    }

    private static String js_join(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        String string;
        String[] stringArray;
        String string2;
        int n;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        if (l != (long)(n = (int)l)) {
            throw Context.reportRuntimeErrorById("msg.arraylength.too.big", String.valueOf(l));
        }
        String string3 = string2 = objectArray.length < 1 || objectArray[0] == Undefined.instance ? "," : ScriptRuntime.toString(objectArray[0]);
        if (scriptable3 instanceof NativeArray) {
            stringArray = (String[])scriptable3;
            if (stringArray.denseOnly) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    if (i != 0) {
                        stringBuilder.append(string2);
                    }
                    if (i >= stringArray.dense.length || (object = stringArray.dense[i]) == null || object == Undefined.instance || object == Scriptable.NOT_FOUND) continue;
                    stringBuilder.append(ScriptRuntime.toString(object));
                }
                return stringBuilder.toString();
            }
        }
        if (n == 0) {
            return "";
        }
        stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i != n; ++i) {
            Object object = NativeArray.getElem(context, scriptable3, i);
            if (object == null || object == Undefined.instance) continue;
            string = ScriptRuntime.toString(object);
            n2 += string.length();
            stringArray[i] = string;
        }
        StringBuilder stringBuilder = new StringBuilder(n2 += (n - 1) * string2.length());
        for (int i = 0; i != n; ++i) {
            if (i != 0) {
                stringBuilder.append(string2);
            }
            if ((string = stringArray[i]) == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static Scriptable js_reverse(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        if (scriptable3 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable3;
            if (nativeArray.denseOnly) {
                int n = 0;
                for (int i = (int)nativeArray.length - 1; n < i; ++n, --i) {
                    Object object = nativeArray.dense[n];
                    nativeArray.dense[n] = nativeArray.dense[i];
                    nativeArray.dense[i] = object;
                }
                return scriptable3;
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable3);
        long l2 = l / 2L;
        for (long i = 0L; i < l2; ++i) {
            long l3 = l - i - 1L;
            Object object = NativeArray.getRawElem(scriptable3, i);
            Object object2 = NativeArray.getRawElem(scriptable3, l3);
            NativeArray.setRawElem(context, scriptable3, i, object2);
            NativeArray.setRawElem(context, scriptable3, l3, object);
        }
        return scriptable3;
    }

    private static Scriptable js_sort(final Context context, final Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        int n;
        ElementComparator elementComparator;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        if (objectArray.length > 0 && Undefined.instance != objectArray[0]) {
            final Callable callable = ScriptRuntime.getValueFunctionAndThis(objectArray[0], context);
            final Scriptable scriptable4 = ScriptRuntime.lastStoredScriptable(context);
            final Object[] objectArray2 = new Object[2];
            elementComparator = new ElementComparator(new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    objectArray2[0] = object;
                    objectArray2[1] = object2;
                    Object object3 = callable.call(context, scriptable, scriptable4, objectArray2);
                    double d = ScriptRuntime.toNumber(object3);
                    int n = Double.compare(d, 0.0);
                    if (n < 0) {
                        return -1;
                    }
                    if (n > 0) {
                        return 1;
                    }
                    return 0;
                }
            });
        } else {
            elementComparator = DEFAULT_COMPARATOR;
        }
        long l = NativeArray.getLengthProperty(context, scriptable3);
        int n2 = (int)l;
        if (l != (long)n2) {
            throw Context.reportRuntimeErrorById("msg.arraylength.too.big", String.valueOf(l));
        }
        Object[] objectArray3 = new Object[n2];
        for (n = 0; n != n2; ++n) {
            objectArray3[n] = NativeArray.getRawElem(scriptable3, n);
        }
        Sorting.get().hybridSort(objectArray3, elementComparator);
        for (n = 0; n < n2; ++n) {
            NativeArray.setRawElem(context, scriptable3, n, objectArray3[n]);
        }
        return scriptable3;
    }

    private static Object js_push(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        if (scriptable3 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable3;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                for (Object object : objectArray) {
                    nativeArray.dense[(int)nativeArray.length++] = object;
                    ++nativeArray.modCount;
                }
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable3);
        for (int i = 0; i < objectArray.length; ++i) {
            NativeArray.setElem(context, scriptable3, l + (long)i, objectArray[i]);
        }
        Object object = NativeArray.setLengthProperty(context, scriptable3, l += (long)objectArray.length);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Undefined.instance : objectArray[objectArray.length - 1];
        }
        return object;
    }

    private static Object js_pop(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        if (scriptable3 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable3;
            if (nativeArray.denseOnly && nativeArray.length > 0L) {
                --nativeArray.length;
                ++nativeArray.modCount;
                Object object2 = nativeArray.dense[(int)nativeArray.length];
                nativeArray.dense[(int)nativeArray.length] = NOT_FOUND;
                return object2;
            }
        }
        if ((l = NativeArray.getLengthProperty(context, scriptable3)) > 0L) {
            object = NativeArray.getElem(context, scriptable3, --l);
            NativeArray.deleteElem(scriptable3, l);
        } else {
            object = Undefined.instance;
        }
        NativeArray.setLengthProperty(context, scriptable3, l);
        return object;
    }

    private static Object js_shift(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        Object object;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        if (scriptable3 instanceof NativeArray) {
            object = (NativeArray)scriptable3;
            if (((NativeArray)object).denseOnly && ((NativeArray)object).length > 0L) {
                --((NativeArray)object).length;
                ++((NativeArray)object).modCount;
                Object object2 = ((NativeArray)object).dense[0];
                System.arraycopy(((NativeArray)object).dense, 1, ((NativeArray)object).dense, 0, (int)((NativeArray)object).length);
                ((NativeArray)object).dense[(int)((NativeArray)object).length] = NOT_FOUND;
                return object2 == NOT_FOUND ? Undefined.instance : object2;
            }
        }
        if ((l = NativeArray.getLengthProperty(context, scriptable3)) > 0L) {
            long l2 = 0L;
            object = NativeArray.getElem(context, scriptable3, l2);
            if (--l > 0L) {
                for (l2 = 1L; l2 <= l; ++l2) {
                    Object object3 = NativeArray.getRawElem(scriptable3, l2);
                    NativeArray.setRawElem(context, scriptable3, l2 - 1L, object3);
                }
            }
            NativeArray.deleteElem(scriptable3, l);
        } else {
            object = Undefined.instance;
        }
        NativeArray.setLengthProperty(context, scriptable3, l);
        return object;
    }

    private static Object js_unshift(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        if (scriptable3 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable3;
            if (nativeArray.denseOnly && nativeArray.ensureCapacity((int)nativeArray.length + objectArray.length)) {
                System.arraycopy(nativeArray.dense, 0, nativeArray.dense, objectArray.length, (int)nativeArray.length);
                System.arraycopy(objectArray, 0, nativeArray.dense, 0, objectArray.length);
                nativeArray.length += (long)objectArray.length;
                ++nativeArray.modCount;
                return ScriptRuntime.wrapNumber(nativeArray.length);
            }
        }
        long l = NativeArray.getLengthProperty(context, scriptable3);
        int n = objectArray.length;
        if (n > 0) {
            if ((double)(l + (long)n) > 9.007199254740991E15) {
                throw ScriptRuntime.typeErrorById("msg.arraylength.too.big", l + (long)n);
            }
            if (l > 0L) {
                for (long i = l - 1L; i >= 0L; --i) {
                    Object object = NativeArray.getRawElem(scriptable3, i);
                    NativeArray.setRawElem(context, scriptable3, i + (long)n, object);
                }
            }
            for (int i = 0; i < objectArray.length; ++i) {
                NativeArray.setElem(context, scriptable3, i, objectArray[i]);
            }
        }
        return NativeArray.setLengthProperty(context, scriptable3, l += (long)n);
    }

    private static Object js_splice(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Object object2;
        long l;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        NativeArray nativeArray = null;
        boolean bl = false;
        if (scriptable3 instanceof NativeArray) {
            nativeArray = (NativeArray)scriptable3;
            bl = nativeArray.denseOnly;
        }
        scriptable = NativeArray.getTopLevelScope(scriptable);
        int n = objectArray.length;
        if (n == 0) {
            return context.newArray(scriptable, 0);
        }
        long l2 = NativeArray.getLengthProperty(context, scriptable3);
        long l3 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l2);
        --n;
        if (objectArray.length == 1) {
            l = l2 - l3;
        } else {
            double d = ScriptRuntime.toInteger(objectArray[1]);
            l = d < 0.0 ? 0L : (d > (double)(l2 - l3) ? l2 - l3 : (long)d);
            --n;
        }
        long l4 = l3 + l;
        long l5 = (long)n - l;
        if ((double)(l2 + l5) > 9.007199254740991E15) {
            throw ScriptRuntime.typeErrorById("msg.arraylength.too.big", l2 + l5);
        }
        if (l > Integer.MAX_VALUE) {
            String string = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(string);
        }
        if (l != 0L) {
            if (l == 1L && context.getLanguageVersion() == 120) {
                object2 = NativeArray.getElem(context, scriptable3, l3);
            } else if (bl) {
                int n2 = (int)(l4 - l3);
                Object[] objectArray2 = new Object[n2];
                System.arraycopy(nativeArray.dense, (int)l3, objectArray2, 0, n2);
                object2 = context.newArray(scriptable, objectArray2);
            } else {
                Scriptable scriptable4 = context.newArray(scriptable, 0);
                for (long i = l3; i != l4; ++i) {
                    Object object3 = NativeArray.getRawElem(scriptable3, i);
                    if (object3 == NOT_FOUND) continue;
                    NativeArray.setElem(context, scriptable4, i - l3, object3);
                }
                NativeArray.setLengthProperty(context, scriptable4, l4 - l3);
                object2 = scriptable4;
            }
        } else {
            object2 = context.getLanguageVersion() == 120 ? Undefined.instance : context.newArray(scriptable, 0);
        }
        if (bl && l2 + l5 < Integer.MAX_VALUE && nativeArray.ensureCapacity((int)(l2 + l5))) {
            System.arraycopy(nativeArray.dense, (int)l4, nativeArray.dense, (int)(l3 + (long)n), (int)(l2 - l4));
            if (n > 0) {
                System.arraycopy(objectArray, 2, nativeArray.dense, (int)l3, n);
            }
            if (l5 < 0L) {
                Arrays.fill(nativeArray.dense, (int)(l2 + l5), (int)l2, NOT_FOUND);
            }
            nativeArray.length = l2 + l5;
            ++nativeArray.modCount;
            return object2;
        }
        if (l5 > 0L) {
            for (long i = l2 - 1L; i >= l4; --i) {
                object = NativeArray.getRawElem(scriptable3, i);
                NativeArray.setRawElem(context, scriptable3, i + l5, object);
            }
        } else if (l5 < 0L) {
            long l6;
            for (l6 = l4; l6 < l2; ++l6) {
                object = NativeArray.getRawElem(scriptable3, l6);
                NativeArray.setRawElem(context, scriptable3, l6 + l5, object);
            }
            for (l6 = l2 - 1L; l6 >= l2 + l5; --l6) {
                NativeArray.deleteElem(scriptable3, l6);
            }
        }
        int n3 = objectArray.length - n;
        for (int i = 0; i < n; ++i) {
            NativeArray.setElem(context, scriptable3, l3 + (long)i, objectArray[i + n3]);
        }
        NativeArray.setLengthProperty(context, scriptable3, l2 + l5);
        return object2;
    }

    private static boolean isConcatSpreadable(Context context, Scriptable scriptable, Object object) {
        Object object2;
        if (object instanceof Scriptable && (object2 = ScriptableObject.getProperty((Scriptable)object, SymbolKey.IS_CONCAT_SPREADABLE)) != Scriptable.NOT_FOUND && !Undefined.isUndefined(object2)) {
            return ScriptRuntime.toBoolean(object2);
        }
        if (context.getLanguageVersion() < 200 && ScriptRuntime.instanceOf(object, object2 = ScriptRuntime.getExistingCtor(context, scriptable, "Array"), context)) {
            return true;
        }
        return NativeArray.js_isArray(object);
    }

    private static long concatSpreadArg(Context context, Scriptable scriptable, Scriptable scriptable2, long l) {
        long l2 = NativeArray.getLengthProperty(context, scriptable2);
        long l3 = l2 + l;
        if ((double)l3 > 9.007199254740991E15) {
            throw ScriptRuntime.typeErrorById("msg.arraylength.too.big", l3);
        }
        if (l3 <= Integer.MAX_VALUE && scriptable instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable;
            if (nativeArray.denseOnly && scriptable2 instanceof NativeArray) {
                NativeArray nativeArray2 = (NativeArray)scriptable2;
                if (nativeArray2.denseOnly) {
                    nativeArray.ensureCapacity((int)l3);
                    System.arraycopy(nativeArray2.dense, 0, nativeArray.dense, (int)l, (int)l2);
                    return l3;
                }
            }
        }
        long l4 = l;
        long l5 = 0L;
        while (l5 < l2) {
            Object object = NativeArray.getRawElem(scriptable2, l5);
            if (object != Scriptable.NOT_FOUND) {
                NativeArray.defineElem(context, scriptable, l4, object);
            }
            ++l5;
            ++l4;
        }
        return l3;
    }

    private static long doConcat(Context context, Scriptable scriptable, Scriptable scriptable2, Object object, long l) {
        if (NativeArray.isConcatSpreadable(context, scriptable, object)) {
            return NativeArray.concatSpreadArg(context, scriptable2, (Scriptable)object, l);
        }
        NativeArray.defineElem(context, scriptable2, l, object);
        return l + 1L;
    }

    private static Scriptable js_concat(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        scriptable = NativeArray.getTopLevelScope(scriptable);
        Scriptable scriptable4 = context.newArray(scriptable, 0);
        long l = NativeArray.doConcat(context, scriptable, scriptable4, scriptable3, 0L);
        for (Object object : objectArray) {
            l = NativeArray.doConcat(context, scriptable, scriptable4, object, l);
        }
        NativeArray.setLengthProperty(context, scriptable4, l);
        return scriptable4;
    }

    private static Scriptable js_slice(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        long l2;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l3 = NativeArray.getLengthProperty(context, scriptable3);
        if (objectArray.length == 0) {
            l2 = 0L;
            l = l3;
        } else {
            l2 = NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[0]), l3);
            l = objectArray.length == 1 || objectArray[1] == Undefined.instance ? l3 : NativeArray.toSliceIndex(ScriptRuntime.toInteger(objectArray[1]), l3);
        }
        if (l - l2 > Integer.MAX_VALUE) {
            String string = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(string);
        }
        Scriptable scriptable4 = context.newArray(scriptable, 0);
        for (long i = l2; i < l; ++i) {
            Object object = NativeArray.getRawElem(scriptable3, i);
            if (object == NOT_FOUND) continue;
            NativeArray.defineElem(context, scriptable4, i - l2, object);
        }
        NativeArray.setLengthProperty(context, scriptable4, Math.max(0L, l - l2));
        return scriptable4;
    }

    private static long toSliceIndex(double d, long l) {
        long l2 = d < 0.0 ? (d + (double)l < 0.0 ? 0L : (long)(d + (double)l)) : (d > (double)l ? l : (long)d);
        return l2;
    }

    private static Object js_indexOf(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l2 = NativeArray.getLengthProperty(context, scriptable3);
        if (objectArray.length < 2) {
            l = 0L;
        } else {
            l = (long)ScriptRuntime.toInteger(objectArray[1]);
            if (l < 0L && (l += l2) < 0L) {
                l = 0L;
            }
            if (l > l2 - 1L) {
                return NEGATIVE_ONE;
            }
        }
        if (scriptable3 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable3;
            if (nativeArray.denseOnly) {
                Scriptable scriptable4 = nativeArray.getPrototype();
                int n = (int)l;
                while ((long)n < l2) {
                    Object object2 = nativeArray.dense[n];
                    if (object2 == NOT_FOUND && scriptable4 != null) {
                        object2 = ScriptableObject.getProperty(scriptable4, n);
                    }
                    if (object2 != NOT_FOUND && ScriptRuntime.shallowEq(object2, object)) {
                        return (long)n;
                    }
                    ++n;
                }
                return NEGATIVE_ONE;
            }
        }
        for (long i = l; i < l2; ++i) {
            Object object3 = NativeArray.getRawElem(scriptable3, i);
            if (object3 == NOT_FOUND || !ScriptRuntime.shallowEq(object3, object)) continue;
            return i;
        }
        return NEGATIVE_ONE;
    }

    private static Object js_lastIndexOf(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l2 = NativeArray.getLengthProperty(context, scriptable3);
        if (objectArray.length < 2) {
            l = l2 - 1L;
        } else {
            l = (long)ScriptRuntime.toInteger(objectArray[1]);
            if (l >= l2) {
                l = l2 - 1L;
            } else if (l < 0L) {
                l += l2;
            }
            if (l < 0L) {
                return NEGATIVE_ONE;
            }
        }
        if (scriptable3 instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)scriptable3;
            if (nativeArray.denseOnly) {
                Scriptable scriptable4 = nativeArray.getPrototype();
                for (int i = (int)l; i >= 0; --i) {
                    Object object2 = nativeArray.dense[i];
                    if (object2 == NOT_FOUND && scriptable4 != null) {
                        object2 = ScriptableObject.getProperty(scriptable4, i);
                    }
                    if (object2 == NOT_FOUND || !ScriptRuntime.shallowEq(object2, object)) continue;
                    return (long)i;
                }
                return NEGATIVE_ONE;
            }
        }
        for (long i = l; i >= 0L; --i) {
            Object object3 = NativeArray.getRawElem(scriptable3, i);
            if (object3 == NOT_FOUND || !ScriptRuntime.shallowEq(object3, object)) continue;
            return i;
        }
        return NEGATIVE_ONE;
    }

    private static Boolean js_includes(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        Object object2 = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l2 = ScriptRuntime.toLength(new Object[]{NativeArray.getProperty(scriptable2, "length")}, 0);
        if (l2 == 0L) {
            return Boolean.FALSE;
        }
        if (objectArray.length < 2) {
            l = 0L;
        } else {
            l = (long)ScriptRuntime.toInteger(objectArray[1]);
            if (l < 0L && (l += l2) < 0L) {
                l = 0L;
            }
            if (l > l2 - 1L) {
                return Boolean.FALSE;
            }
        }
        if (scriptable3 instanceof NativeArray) {
            object = (NativeArray)scriptable3;
            if (((NativeArray)object).denseOnly) {
                Scriptable scriptable4 = ((ScriptableObject)object).getPrototype();
                int n = (int)l;
                while ((long)n < l2) {
                    Object object3 = ((NativeArray)object).dense[n];
                    if (object3 == NOT_FOUND && scriptable4 != null) {
                        object3 = ScriptableObject.getProperty(scriptable4, n);
                    }
                    if (object3 == NOT_FOUND) {
                        object3 = Undefined.instance;
                    }
                    if (ScriptRuntime.sameZero(object3, object2)) {
                        return Boolean.TRUE;
                    }
                    ++n;
                }
                return Boolean.FALSE;
            }
        }
        while (l < l2) {
            object = NativeArray.getRawElem(scriptable3, l);
            if (object == NOT_FOUND) {
                object = Undefined.instance;
            }
            if (ScriptRuntime.sameZero(object, object2)) {
                return Boolean.TRUE;
            }
            ++l;
        }
        return Boolean.FALSE;
    }

    private static Object js_fill(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        long l2 = 0L;
        if (objectArray.length >= 2) {
            l2 = (long)ScriptRuntime.toInteger(objectArray[1]);
        }
        long l3 = l2 < 0L ? Math.max(l + l2, 0L) : Math.min(l2, l);
        long l4 = l;
        if (objectArray.length >= 3 && !Undefined.isUndefined(objectArray[2])) {
            l4 = (long)ScriptRuntime.toInteger(objectArray[2]);
        }
        long l5 = l4 < 0L ? Math.max(l + l4, 0L) : Math.min(l4, l);
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        for (long i = l3; i < l5; ++i) {
            NativeArray.setRawElem(context, scriptable2, i, object);
        }
        return scriptable2;
    }

    private static Object js_copyWithin(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        Object object2 = objectArray.length >= 1 ? objectArray[0] : Undefined.instance;
        long l2 = (long)ScriptRuntime.toInteger(object2);
        long l3 = l2 < 0L ? Math.max(l + l2, 0L) : Math.min(l2, l);
        Object object3 = objectArray.length >= 2 ? objectArray[1] : Undefined.instance;
        long l4 = (long)ScriptRuntime.toInteger(object3);
        long l5 = l4 < 0L ? Math.max(l + l4, 0L) : Math.min(l4, l);
        long l6 = l;
        if (objectArray.length >= 3 && !Undefined.isUndefined(objectArray[2])) {
            l6 = (long)ScriptRuntime.toInteger(objectArray[2]);
        }
        long l7 = l6 < 0L ? Math.max(l + l6, 0L) : Math.min(l6, l);
        long l8 = Math.min(l7 - l5, l - l3);
        int n = 1;
        if (l5 < l3 && l3 < l5 + l8) {
            n = -1;
            l5 = l5 + l8 - 1L;
            l3 = l3 + l8 - 1L;
        }
        if (scriptable3 instanceof NativeArray && l8 <= Integer.MAX_VALUE) {
            object = (NativeArray)scriptable3;
            if (((NativeArray)object).denseOnly) {
                while (l8 > 0L) {
                    ((NativeArray)object).dense[(int)l3] = ((NativeArray)object).dense[(int)l5];
                    l5 += (long)n;
                    l3 += (long)n;
                    --l8;
                }
                return scriptable2;
            }
        }
        while (l8 > 0L) {
            object = NativeArray.getRawElem(scriptable3, l5);
            if (object == Scriptable.NOT_FOUND || Undefined.isUndefined(object)) {
                NativeArray.deleteElem(scriptable3, l3);
            } else {
                NativeArray.setElem(context, scriptable3, l3, object);
            }
            l5 += (long)n;
            l3 += (long)n;
            --l8;
        }
        return scriptable2;
    }

    private static Object js_at(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        long l;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l2 = NativeArray.getLengthProperty(context, scriptable3);
        long l3 = 0L;
        if (objectArray.length >= 1) {
            l3 = (long)ScriptRuntime.toInteger(objectArray[0]);
        }
        long l4 = l = l3 >= 0L ? l3 : l2 + l3;
        if (l < 0L || l >= l2) {
            return Undefined.instance;
        }
        return NativeArray.getElem(context, scriptable2, l);
    }

    private static Object js_flat(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        double d = objectArray.length < 1 || Undefined.isUndefined(objectArray[0]) ? 1.0 : ScriptRuntime.toInteger(objectArray[0]);
        return NativeArray.flat(context, scriptable, scriptable3, d);
    }

    private static Scriptable flat(Context context, Scriptable scriptable, Scriptable scriptable2, double d) {
        long l = NativeArray.getLengthProperty(context, scriptable2);
        Scriptable scriptable3 = context.newArray(scriptable, 0);
        long l2 = 0L;
        for (long i = 0L; i < l; ++i) {
            Object object = NativeArray.getRawElem(scriptable2, i);
            if (object == Scriptable.NOT_FOUND) continue;
            if (d >= 1.0 && NativeArray.js_isArray(object)) {
                Scriptable scriptable4 = NativeArray.flat(context, scriptable, (Scriptable)object, d - 1.0);
                long l3 = NativeArray.getLengthProperty(context, scriptable4);
                for (long j = 0L; j < l3; ++j) {
                    Object object2 = NativeArray.getRawElem(scriptable4, j);
                    NativeArray.defineElemOrThrow(context, scriptable3, l2++, object2);
                }
                continue;
            }
            NativeArray.defineElemOrThrow(context, scriptable3, l2++, object);
        }
        NativeArray.setLengthProperty(context, scriptable3, l2);
        return scriptable3;
    }

    private static Object js_flatMap(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Function function = NativeArray.getCallbackArg(context, object);
        Scriptable scriptable4 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable5 = objectArray.length < 2 || objectArray[1] == null || objectArray[1] == Undefined.instance ? scriptable4 : ScriptRuntime.toObject(context, scriptable, objectArray[1]);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        Scriptable scriptable6 = context.newArray(scriptable, 0);
        long l2 = 0L;
        for (long i = 0L; i < l; ++i) {
            Object object2 = NativeArray.getRawElem(scriptable3, i);
            if (object2 == Scriptable.NOT_FOUND) continue;
            Object[] objectArray2 = new Object[]{object2, i, scriptable3};
            Object object3 = function.call(context, scriptable4, scriptable5, objectArray2);
            if (NativeArray.js_isArray(object3)) {
                Scriptable scriptable7 = (Scriptable)object3;
                long l3 = NativeArray.getLengthProperty(context, scriptable7);
                for (long j = 0L; j < l3; ++j) {
                    Object object4 = NativeArray.getRawElem(scriptable7, j);
                    NativeArray.defineElemOrThrow(context, scriptable6, l2++, object4);
                }
                continue;
            }
            NativeArray.defineElemOrThrow(context, scriptable6, l2++, object3);
        }
        NativeArray.setLengthProperty(context, scriptable6, l2);
        return scriptable6;
    }

    private static Object iterativeMethod(Context context, IdFunctionObject idFunctionObject, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        int n = Math.abs(idFunctionObject.methodId());
        if (22 == n || 23 == n) {
            ScriptRuntimeES6.requireObjectCoercible(context, scriptable3, idFunctionObject);
        }
        long l = NativeArray.getLengthProperty(context, scriptable3);
        if (n == 20 && l > Integer.MAX_VALUE) {
            String string = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(string);
        }
        Object object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        Function function = NativeArray.getCallbackArg(context, object);
        Scriptable scriptable4 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable5 = objectArray.length < 2 || objectArray[1] == null || objectArray[1] == Undefined.instance ? scriptable4 : ScriptRuntime.toObject(context, scriptable, objectArray[1]);
        Scriptable scriptable6 = null;
        if (n == 18 || n == 20) {
            int n2 = n == 20 ? (int)l : 0;
            scriptable6 = context.newArray(scriptable, n2);
        }
        long l2 = 0L;
        block15: for (long i = 0L; i < l; ++i) {
            Object[] objectArray2 = new Object[3];
            Object object2 = NativeArray.getRawElem(scriptable3, i);
            if (object2 == Scriptable.NOT_FOUND) {
                if (n != 22 && n != 23) continue;
                object2 = Undefined.instance;
            }
            objectArray2[0] = object2;
            objectArray2[1] = i;
            objectArray2[2] = scriptable3;
            Object object3 = function.call(context, scriptable4, scriptable5, objectArray2);
            switch (n) {
                case 17: {
                    if (ScriptRuntime.toBoolean(object3)) continue block15;
                    return Boolean.FALSE;
                }
                case 18: {
                    if (!ScriptRuntime.toBoolean(object3)) continue block15;
                    NativeArray.defineElem(context, scriptable6, l2++, objectArray2[0]);
                    continue block15;
                }
                case 19: {
                    continue block15;
                }
                case 20: {
                    NativeArray.defineElem(context, scriptable6, i, object3);
                    continue block15;
                }
                case 21: {
                    if (!ScriptRuntime.toBoolean(object3)) continue block15;
                    return Boolean.TRUE;
                }
                case 22: {
                    if (!ScriptRuntime.toBoolean(object3)) continue block15;
                    return object2;
                }
                case 23: {
                    if (!ScriptRuntime.toBoolean(object3)) continue block15;
                    return ScriptRuntime.wrapNumber(i);
                }
            }
        }
        switch (n) {
            case 17: {
                return Boolean.TRUE;
            }
            case 18: 
            case 20: {
                return scriptable6;
            }
            case 21: {
                return Boolean.FALSE;
            }
            case 23: {
                return ScriptRuntime.wrapNumber(-1.0);
            }
        }
        return Undefined.instance;
    }

    private static Object reduceMethod(Context context, int n, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        Scriptable scriptable3 = ScriptRuntime.toObject(context, scriptable, scriptable2);
        long l = NativeArray.getLengthProperty(context, scriptable3);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : Undefined.instance;
        if (object == null || !(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Function function = (Function)object;
        Scriptable scriptable4 = ScriptableObject.getTopLevelScope(function);
        boolean bl = n == 24;
        Object object3 = objectArray.length > 1 ? objectArray[1] : Scriptable.NOT_FOUND;
        for (long i = 0L; i < l; ++i) {
            long l2 = bl ? i : l - 1L - i;
            Object object4 = NativeArray.getRawElem(scriptable3, l2);
            if (object4 == Scriptable.NOT_FOUND) continue;
            if (object3 == Scriptable.NOT_FOUND) {
                object3 = object4;
                continue;
            }
            Object[] objectArray2 = new Object[]{object3, object4, l2, scriptable3};
            object3 = function.call(context, scriptable4, scriptable4, objectArray2);
        }
        if (object3 == Scriptable.NOT_FOUND) {
            throw ScriptRuntime.typeErrorById("msg.empty.array.reduce", new Object[0]);
        }
        return object3;
    }

    private static boolean js_isArray(Object object) {
        if (!(object instanceof Scriptable)) {
            return false;
        }
        return "Array".equals(((Scriptable)object).getClassName());
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) > -1;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(ScriptRuntime.emptyArgs);
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        Object[] objectArray2 = objectArray.length >= n ? objectArray : (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        for (int i = 0; i < n; ++i) {
            objectArray2[i] = this.get(i);
        }
        return objectArray2;
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object e : collection) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        long l = this.length;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException("list.length (" + this.length + ") exceeds Integer.MAX_VALUE");
        }
        return (int)l;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0L;
    }

    public Object get(long l) {
        if (l < 0L || l >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        Object object = NativeArray.getRawElem(this, l);
        if (object == Scriptable.NOT_FOUND || object == Undefined.instance) {
            return null;
        }
        if (object instanceof Wrapper) {
            return ((Wrapper)object).unwrap();
        }
        return object;
    }

    public Object get(int n) {
        return this.get((long)n);
    }

    @Override
    public int indexOf(Object object) {
        int n = this.size();
        if (object == null) {
            for (int i = 0; i < n; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!object.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size();
        if (object == null) {
            for (int i = n - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                if (!object.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        final int n2 = this.size();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListIterator(){
            int cursor;
            int modCount;
            {
                this.cursor = n;
                this.modCount = NativeArray.this.modCount;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < n2;
            }

            @Override
            public Object next() {
                NativeArray.this.checkModCount(this.modCount);
                if (this.cursor == n2) {
                    throw new NoSuchElementException();
                }
                return NativeArray.this.get(this.cursor++);
            }

            @Override
            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public Object previous() {
                NativeArray.this.checkModCount(this.modCount);
                if (this.cursor == 0) {
                    throw new NoSuchElementException();
                }
                return NativeArray.this.get(--this.cursor);
            }

            @Override
            public int nextIndex() {
                return this.cursor;
            }

            @Override
            public int previousIndex() {
                return this.cursor - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public List subList(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        return new AbstractList(){
            private int modCount;
            {
                this.modCount = NativeArray.this.modCount;
            }

            @Override
            public Object get(int n3) {
                NativeArray.this.checkModCount(this.modCount);
                return NativeArray.this.get(n3 + n);
            }

            @Override
            public int size() {
                NativeArray.this.checkModCount(this.modCount);
                return n2 - n;
            }
        };
    }

    private void checkModCount(int n) {
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 35;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "toString": {
                n = 2;
                break;
            }
            case "toLocaleString": {
                n = 3;
                break;
            }
            case "toSource": {
                n = 4;
                break;
            }
            case "join": {
                n = 5;
                break;
            }
            case "reverse": {
                n = 6;
                break;
            }
            case "sort": {
                n = 7;
                break;
            }
            case "push": {
                n = 8;
                break;
            }
            case "pop": {
                n = 9;
                break;
            }
            case "shift": {
                n = 10;
                break;
            }
            case "unshift": {
                n = 11;
                break;
            }
            case "splice": {
                n = 12;
                break;
            }
            case "concat": {
                n = 13;
                break;
            }
            case "slice": {
                n = 14;
                break;
            }
            case "indexOf": {
                n = 15;
                break;
            }
            case "lastIndexOf": {
                n = 16;
                break;
            }
            case "every": {
                n = 17;
                break;
            }
            case "filter": {
                n = 18;
                break;
            }
            case "forEach": {
                n = 19;
                break;
            }
            case "map": {
                n = 20;
                break;
            }
            case "some": {
                n = 21;
                break;
            }
            case "find": {
                n = 22;
                break;
            }
            case "findIndex": {
                n = 23;
                break;
            }
            case "reduce": {
                n = 24;
                break;
            }
            case "reduceRight": {
                n = 25;
                break;
            }
            case "fill": {
                n = 26;
                break;
            }
            case "keys": {
                n = 27;
                break;
            }
            case "values": {
                n = 28;
                break;
            }
            case "entries": {
                n = 29;
                break;
            }
            case "includes": {
                n = 30;
                break;
            }
            case "copyWithin": {
                n = 31;
                break;
            }
            case "at": {
                n = 32;
                break;
            }
            case "flat": {
                n = 33;
                break;
            }
            case "flatMap": {
                n = 34;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static final class ElementComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = -1189948017688708858L;
        private final Comparator<Object> child;

        public ElementComparator() {
            this.child = STRING_COMPARATOR;
        }

        public ElementComparator(Comparator<Object> comparator) {
            this.child = comparator;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == Undefined.instance) {
                if (object2 == Undefined.instance) {
                    return 0;
                }
                if (object2 == Scriptable.NOT_FOUND) {
                    return -1;
                }
                return 1;
            }
            if (object == Scriptable.NOT_FOUND) {
                return object2 == Scriptable.NOT_FOUND ? 0 : 1;
            }
            if (object2 == Scriptable.NOT_FOUND) {
                return -1;
            }
            if (object2 == Undefined.instance) {
                return -1;
            }
            return this.child.compare(object, object2);
        }
    }

    public static final class StringLikeComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 5299017659728190979L;

        @Override
        public int compare(Object object, Object object2) {
            String string = ScriptRuntime.toString(object);
            String string2 = ScriptRuntime.toString(object2);
            return string.compareTo(string2);
        }
    }
}

