/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.ArrayComprehension;
import org.mozilla.javascript.ast.ArrayComprehensionLoop;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.BigIntLiteral;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.DestructuringForm;
import org.mozilla.javascript.ast.DoLoop;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForInLoop;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.GeneratorExpression;
import org.mozilla.javascript.ast.GeneratorExpressionLoop;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NewExpression;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.Symbol;
import org.mozilla.javascript.ast.TaggedTemplateLiteral;
import org.mozilla.javascript.ast.TemplateCharacters;
import org.mozilla.javascript.ast.TemplateLiteral;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.UpdateExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WhileLoop;
import org.mozilla.javascript.ast.WithStatement;
import org.mozilla.javascript.ast.XmlDotQuery;
import org.mozilla.javascript.ast.XmlElemRef;
import org.mozilla.javascript.ast.XmlExpression;
import org.mozilla.javascript.ast.XmlFragment;
import org.mozilla.javascript.ast.XmlLiteral;
import org.mozilla.javascript.ast.XmlMemberGet;
import org.mozilla.javascript.ast.XmlPropRef;
import org.mozilla.javascript.ast.XmlRef;
import org.mozilla.javascript.ast.XmlString;
import org.mozilla.javascript.ast.Yield;

public final class IRFactory {
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;
    private Parser parser;
    private Decompiler decompiler = new Decompiler();

    public IRFactory(CompilerEnvirons compilerEnvirons) {
        this(compilerEnvirons, compilerEnvirons.getErrorReporter());
    }

    public IRFactory(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.parser = new Parser(compilerEnvirons, errorReporter);
    }

    public ScriptNode transformTree(AstRoot astRoot) {
        this.parser.currentScriptOrFn = astRoot;
        this.parser.inUseStrictDirective = astRoot.isInStrictMode();
        int n = this.decompiler.getCurrentOffset();
        ScriptNode scriptNode = (ScriptNode)this.transform(astRoot);
        int n2 = this.decompiler.getCurrentOffset();
        scriptNode.setEncodedSourceBounds(n, n2);
        if (this.parser.compilerEnv.isGeneratingSource()) {
            scriptNode.setEncodedSource(this.decompiler.getEncodedSource());
        }
        this.decompiler = null;
        return scriptNode;
    }

    public Node transform(AstNode astNode) {
        switch (astNode.getType()) {
            case 161: {
                return this.transformArrayComp((ArrayComprehension)astNode);
            }
            case 66: {
                return this.transformArrayLiteral((ArrayLiteral)astNode);
            }
            case 83: {
                return this.transformBigInt((BigIntLiteral)astNode);
            }
            case 133: {
                return this.transformBlock(astNode);
            }
            case 124: {
                return this.transformBreak((BreakStatement)astNode);
            }
            case 38: {
                return this.transformFunctionCall((FunctionCall)astNode);
            }
            case 125: {
                return this.transformContinue((ContinueStatement)astNode);
            }
            case 122: {
                return this.transformDoLoop((DoLoop)astNode);
            }
            case 132: 
            case 165: {
                return astNode;
            }
            case 123: {
                if (astNode instanceof ForInLoop) {
                    return this.transformForInLoop((ForInLoop)astNode);
                }
                return this.transformForLoop((ForLoop)astNode);
            }
            case 113: {
                return this.transformFunction((FunctionNode)astNode);
            }
            case 166: {
                return this.transformGenExpr((GeneratorExpression)astNode);
            }
            case 36: {
                return this.transformElementGet((ElementGet)astNode);
            }
            case 33: {
                return this.transformPropertyGet((PropertyGet)astNode);
            }
            case 106: {
                return this.transformCondExpr((ConditionalExpression)astNode);
            }
            case 116: {
                return this.transformIf((IfStatement)astNode);
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 164: {
                return this.transformLiteral(astNode);
            }
            case 39: {
                return this.transformName((Name)astNode);
            }
            case 40: {
                return this.transformNumber((NumberLiteral)astNode);
            }
            case 30: {
                return this.transformNewExpr((NewExpression)astNode);
            }
            case 67: {
                return this.transformObjectLiteral((ObjectLiteral)astNode);
            }
            case 170: {
                return this.transformTemplateLiteral((TemplateLiteral)astNode);
            }
            case 173: {
                return this.transformTemplateLiteralCall((TaggedTemplateLiteral)astNode);
            }
            case 48: {
                return this.transformRegExp((RegExpLiteral)astNode);
            }
            case 4: {
                return this.transformReturn((ReturnStatement)astNode);
            }
            case 140: {
                return this.transformScript((ScriptNode)astNode);
            }
            case 41: {
                return this.transformString((StringLiteral)astNode);
            }
            case 118: {
                return this.transformSwitch((SwitchStatement)astNode);
            }
            case 50: {
                return this.transformThrow((ThrowStatement)astNode);
            }
            case 84: {
                return this.transformTry((TryStatement)astNode);
            }
            case 121: {
                return this.transformWhileLoop((WhileLoop)astNode);
            }
            case 127: {
                return this.transformWith((WithStatement)astNode);
            }
            case 73: 
            case 169: {
                return this.transformYield((Yield)astNode);
            }
        }
        if (astNode instanceof ExpressionStatement) {
            return this.transformExprStmt((ExpressionStatement)astNode);
        }
        if (astNode instanceof Assignment) {
            return this.transformAssignment((Assignment)astNode);
        }
        if (astNode instanceof UnaryExpression) {
            return this.transformUnary((UnaryExpression)astNode);
        }
        if (astNode instanceof UpdateExpression) {
            return this.transformUpdate((UpdateExpression)astNode);
        }
        if (astNode instanceof XmlMemberGet) {
            return this.transformXmlMemberGet((XmlMemberGet)astNode);
        }
        if (astNode instanceof InfixExpression) {
            return this.transformInfix((InfixExpression)astNode);
        }
        if (astNode instanceof VariableDeclaration) {
            return this.transformVariables((VariableDeclaration)astNode);
        }
        if (astNode instanceof ParenthesizedExpression) {
            return this.transformParenExpr((ParenthesizedExpression)astNode);
        }
        if (astNode instanceof LabeledStatement) {
            return this.transformLabeledStatement((LabeledStatement)astNode);
        }
        if (astNode instanceof LetNode) {
            return this.transformLetNode((LetNode)astNode);
        }
        if (astNode instanceof XmlRef) {
            return this.transformXmlRef((XmlRef)astNode);
        }
        if (astNode instanceof XmlLiteral) {
            return this.transformXmlLiteral((XmlLiteral)astNode);
        }
        throw new IllegalArgumentException("Can't transform: " + astNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformArrayComp(ArrayComprehension arrayComprehension) {
        int n = arrayComprehension.getLineno();
        Scope scope = this.parser.createScopeNode(161, n);
        String string = this.parser.currentScriptOrFn.getNextTempName();
        this.parser.pushScope(scope);
        try {
            this.parser.defineSymbol(157, string, false);
            Node node = new Node(133, n);
            Node node2 = this.createCallOrNew(30, this.parser.createName("Array"));
            Node node3 = new Node(137, this.createAssignment(93, this.parser.createName(string), node2), n);
            node.addChildToBack(node3);
            node.addChildToBack(this.arrayCompTransformHelper(arrayComprehension, string));
            scope.addChildToBack(node);
            scope.addChildToBack(this.parser.createName(string));
            Scope scope2 = scope;
            return scope2;
        }
        finally {
            this.parser.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node arrayCompTransformHelper(ArrayComprehension arrayComprehension, String string) {
        int n;
        Node node;
        Node node2;
        this.decompiler.addToken(86);
        int n2 = arrayComprehension.getLineno();
        Node node3 = this.transform(arrayComprehension.getResult());
        List<ArrayComprehensionLoop> list = arrayComprehension.getLoops();
        int n3 = list.size();
        Node[] nodeArray = new Node[n3];
        Node[] nodeArray2 = new Node[n3];
        for (int i = 0; i < n3; ++i) {
            node2 = list.get(i);
            this.decompiler.addName(" ");
            this.decompiler.addToken(123);
            if (((ForInLoop)node2).isForEach()) {
                this.decompiler.addName("each ");
            }
            this.decompiler.addToken(90);
            AstNode astNode = ((ForInLoop)node2).getIterator();
            String string2 = null;
            if (astNode.getType() == 39) {
                string2 = astNode.getString();
                this.decompiler.addName(string2);
            } else {
                this.decompile(astNode);
                string2 = this.parser.currentScriptOrFn.getNextTempName();
                this.parser.defineSymbol(90, string2, false);
                node3 = IRFactory.createBinary(92, this.createAssignment(93, astNode, this.parser.createName(string2)), node3);
            }
            node = this.parser.createName(string2);
            this.parser.defineSymbol(157, string2, false);
            nodeArray[i] = node;
            if (((ForInLoop)node2).isForOf()) {
                this.decompiler.addName("of ");
            } else {
                this.decompiler.addToken(52);
            }
            nodeArray2[i] = this.transform(((ForInLoop)node2).getIteratedObject());
            this.decompiler.addToken(91);
        }
        Node node4 = this.createCallOrNew(38, this.createPropertyGet(this.parser.createName(string), null, "push", 0));
        node2 = new Node(137, node4, n2);
        if (arrayComprehension.getFilter() != null) {
            this.decompiler.addName(" ");
            this.decompiler.addToken(116);
            this.decompiler.addToken(90);
            node2 = IRFactory.createIf(this.transform(arrayComprehension.getFilter()), node2, null, n2);
            this.decompiler.addToken(91);
        }
        int n4 = 0;
        try {
            for (n = n3 - 1; n >= 0; --n) {
                node = list.get(n);
                Scope scope = this.createLoopNode(null, ((AstNode)node).getLineno());
                this.parser.pushScope(scope);
                ++n4;
                node2 = this.createForIn(157, scope, nodeArray[n], nodeArray2[n], node2, ((ForInLoop)node).isForEach(), ((ForInLoop)node).isForOf());
            }
        }
        finally {
            for (n = 0; n < n4; ++n) {
                this.parser.popScope();
            }
        }
        this.decompiler.addToken(87);
        node4.addChildToBack(node3);
        return node2;
    }

    private Node transformArrayLiteral(ArrayLiteral arrayLiteral) {
        if (arrayLiteral.isDestructuring()) {
            return arrayLiteral;
        }
        this.decompiler.addToken(86);
        List<AstNode> list = arrayLiteral.getElements();
        Node node = new Node(66);
        ArrayList<Integer> arrayList = null;
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode = list.get(i);
            if (astNode.getType() != 132) {
                node.addChildToBack(this.transform(astNode));
            } else {
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                arrayList.add(i);
            }
            if (i >= list.size() - 1) continue;
            this.decompiler.addToken(92);
        }
        this.decompiler.addToken(87);
        node.putIntProp(21, arrayLiteral.getDestructuringLength());
        if (arrayList != null) {
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            node.putProp(11, nArray);
        }
        return node;
    }

    private Node transformAssignment(Assignment assignment) {
        AstNode astNode = assignment.getRight();
        AstNode astNode2 = this.parser.removeParens(assignment.getLeft());
        astNode2 = this.transformAssignmentLeft(assignment, astNode2, astNode);
        Node node = null;
        if (this.isDestructuring(astNode2)) {
            this.decompile(astNode2);
            node = astNode2;
        } else {
            node = this.transform(astNode2);
        }
        this.decompiler.addToken(assignment.getType());
        return this.createAssignment(assignment.getType(), node, this.transform(astNode));
    }

    private AstNode transformAssignmentLeft(Assignment assignment, AstNode astNode, AstNode astNode2) {
        if (astNode2.getType() == 42 && assignment.getType() == 93 && astNode instanceof Name && astNode2 instanceof KeywordLiteral) {
            String string = ((Name)astNode).getIdentifier();
            for (AstNode astNode3 = assignment.getParent(); astNode3 != null; astNode3 = astNode3.getParent()) {
                Name name;
                if (!(astNode3 instanceof FunctionNode) || (name = ((FunctionNode)astNode3).getFunctionName()) == null || !name.getIdentifier().equals(string)) continue;
                PropertyGet propertyGet = new PropertyGet();
                KeywordLiteral keywordLiteral = new KeywordLiteral();
                keywordLiteral.setType(43);
                propertyGet.setLeft(keywordLiteral);
                propertyGet.setRight(astNode);
                assignment.setLeft(propertyGet);
                return propertyGet;
            }
        }
        return astNode;
    }

    private Node transformBigInt(BigIntLiteral bigIntLiteral) {
        this.decompiler.addBigInt(bigIntLiteral.getBigInt());
        return bigIntLiteral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformBlock(AstNode astNode) {
        if (astNode instanceof Scope) {
            this.parser.pushScope((Scope)astNode);
        }
        try {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : astNode) {
                arrayList.add(this.transform((AstNode)node));
            }
            astNode.removeChildren();
            for (Node node : arrayList) {
                astNode.addChildToBack(node);
            }
            AstNode astNode2 = astNode;
            return astNode2;
        }
        finally {
            if (astNode instanceof Scope) {
                this.parser.popScope();
            }
        }
    }

    private Node transformBreak(BreakStatement breakStatement) {
        this.decompiler.addToken(124);
        if (breakStatement.getBreakLabel() != null) {
            this.decompiler.addName(breakStatement.getBreakLabel().getIdentifier());
        }
        this.decompiler.addEOL(85);
        return breakStatement;
    }

    private Node transformCondExpr(ConditionalExpression conditionalExpression) {
        Node node = this.transform(conditionalExpression.getTestExpression());
        this.decompiler.addToken(106);
        Node node2 = this.transform(conditionalExpression.getTrueExpression());
        this.decompiler.addToken(107);
        Node node3 = this.transform(conditionalExpression.getFalseExpression());
        return IRFactory.createCondExpr(node, node2, node3);
    }

    private Node transformContinue(ContinueStatement continueStatement) {
        this.decompiler.addToken(125);
        if (continueStatement.getLabel() != null) {
            this.decompiler.addName(continueStatement.getLabel().getIdentifier());
        }
        this.decompiler.addEOL(85);
        return continueStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformDoLoop(DoLoop doLoop) {
        doLoop.setType(136);
        this.parser.pushScope(doLoop);
        try {
            this.decompiler.addToken(122);
            this.decompiler.addEOL(88);
            Node node = this.transform(doLoop.getBody());
            this.decompiler.addToken(89);
            this.decompiler.addToken(121);
            this.decompiler.addToken(90);
            Node node2 = this.transform(doLoop.getCondition());
            this.decompiler.addToken(91);
            this.decompiler.addEOL(85);
            Node node3 = IRFactory.createLoop(doLoop, 0, node, node2, null, null);
            return node3;
        }
        finally {
            this.parser.popScope();
        }
    }

    private Node transformElementGet(ElementGet elementGet) {
        Node node = this.transform(elementGet.getTarget());
        this.decompiler.addToken(86);
        Node node2 = this.transform(elementGet.getElement());
        this.decompiler.addToken(87);
        return new Node(36, node, node2);
    }

    private Node transformExprStmt(ExpressionStatement expressionStatement) {
        Node node = this.transform(expressionStatement.getExpression());
        this.decompiler.addEOL(85);
        return new Node(expressionStatement.getType(), node, expressionStatement.getLineno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForInLoop(ForInLoop forInLoop) {
        this.decompiler.addToken(123);
        if (forInLoop.isForEach()) {
            this.decompiler.addName("each ");
        }
        this.decompiler.addToken(90);
        forInLoop.setType(136);
        this.parser.pushScope(forInLoop);
        try {
            int n = -1;
            AstNode astNode = forInLoop.getIterator();
            if (astNode instanceof VariableDeclaration) {
                n = astNode.getType();
            }
            Node node = this.transform(astNode);
            if (forInLoop.isForOf()) {
                this.decompiler.addName("of ");
            } else {
                this.decompiler.addToken(52);
            }
            Node node2 = this.transform(forInLoop.getIteratedObject());
            this.decompiler.addToken(91);
            this.decompiler.addEOL(88);
            Node node3 = this.transform(forInLoop.getBody());
            this.decompiler.addEOL(89);
            Node node4 = this.createForIn(n, forInLoop, node, node2, node3, forInLoop.isForEach(), forInLoop.isForOf());
            return node4;
        }
        finally {
            this.parser.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForLoop(ForLoop forLoop) {
        this.decompiler.addToken(123);
        this.decompiler.addToken(90);
        forLoop.setType(136);
        Scope scope = this.parser.currentScope;
        this.parser.currentScope = forLoop;
        try {
            Node node = this.transform(forLoop.getInitializer());
            this.decompiler.addToken(85);
            Node node2 = this.transform(forLoop.getCondition());
            this.decompiler.addToken(85);
            Node node3 = this.transform(forLoop.getIncrement());
            this.decompiler.addToken(91);
            this.decompiler.addEOL(88);
            Node node4 = this.transform(forLoop.getBody());
            this.decompiler.addEOL(89);
            Node node5 = IRFactory.createFor(forLoop, node, node2, node3, node4);
            return node5;
        }
        finally {
            this.parser.currentScope = scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformFunction(FunctionNode functionNode) {
        int n = functionNode.getFunctionType();
        int n2 = this.decompiler.markFunctionStart(n);
        Node node = this.decompileFunctionHeader(functionNode);
        int n3 = this.parser.currentScriptOrFn.addFunction(functionNode);
        Parser.PerFunctionVariables perFunctionVariables = this.parser.createPerFunctionVariables(functionNode);
        try {
            Node node2 = (Node)functionNode.getProp(23);
            functionNode.removeProp(23);
            int n4 = functionNode.getBody().getLineno();
            ++this.parser.nestingOfFunction;
            Node node3 = this.transform(functionNode.getBody());
            if (!functionNode.isExpressionClosure()) {
                this.decompiler.addToken(89);
            }
            functionNode.setEncodedSourceBounds(n2, this.decompiler.markFunctionEnd(n2));
            if (n != 2 && !functionNode.isExpressionClosure()) {
                this.decompiler.addToken(1);
            }
            if (node2 != null) {
                node3.addChildToFront(new Node(137, node2, n4));
            }
            int n5 = functionNode.getFunctionType();
            Node node4 = IRFactory.initFunction(functionNode, n3, node3, n5);
            if (node != null) {
                node4 = this.createAssignment(93, node, node4);
                if (n5 != 2) {
                    node4 = IRFactory.createExprStatementNoReturn(node4, functionNode.getLineno());
                }
            }
            Node node5 = node4;
            return node5;
        }
        finally {
            --this.parser.nestingOfFunction;
            perFunctionVariables.restore();
        }
    }

    private Node transformFunctionCall(FunctionCall functionCall) {
        Node node = this.createCallOrNew(38, this.transform(functionCall.getTarget()));
        node.setLineno(functionCall.getLineno());
        this.decompiler.addToken(90);
        List<AstNode> list = functionCall.getArguments();
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode = list.get(i);
            node.addChildToBack(this.transform(astNode));
            if (i >= list.size() - 1) continue;
            this.decompiler.addToken(92);
        }
        this.decompiler.addToken(91);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformGenExpr(GeneratorExpression generatorExpression) {
        Node node;
        Node node2;
        FunctionNode functionNode = new FunctionNode();
        functionNode.setSourceName(this.parser.currentScriptOrFn.getNextTempName());
        functionNode.setIsGenerator();
        functionNode.setFunctionType(2);
        functionNode.setRequiresActivation();
        int n = functionNode.getFunctionType();
        int n2 = this.decompiler.markFunctionStart(n);
        Node node3 = this.decompileFunctionHeader(functionNode);
        int n3 = this.parser.currentScriptOrFn.addFunction(functionNode);
        Parser.PerFunctionVariables perFunctionVariables = this.parser.createPerFunctionVariables(functionNode);
        try {
            node2 = (Node)functionNode.getProp(23);
            functionNode.removeProp(23);
            int n4 = generatorExpression.lineno;
            ++this.parser.nestingOfFunction;
            Node node4 = this.genExprTransformHelper(generatorExpression);
            if (!functionNode.isExpressionClosure()) {
                this.decompiler.addToken(89);
            }
            functionNode.setEncodedSourceBounds(n2, this.decompiler.markFunctionEnd(n2));
            if (n != 2 && !functionNode.isExpressionClosure()) {
                this.decompiler.addToken(1);
            }
            if (node2 != null) {
                node4.addChildToFront(new Node(137, node2, n4));
            }
            int n5 = functionNode.getFunctionType();
            node = IRFactory.initFunction(functionNode, n3, node4, n5);
            if (node3 != null) {
                node = this.createAssignment(93, node3, node);
                if (n5 != 2) {
                    node = IRFactory.createExprStatementNoReturn(node, functionNode.getLineno());
                }
            }
        }
        finally {
            --this.parser.nestingOfFunction;
            perFunctionVariables.restore();
        }
        node2 = this.createCallOrNew(38, node);
        node2.setLineno(generatorExpression.getLineno());
        this.decompiler.addToken(90);
        this.decompiler.addToken(91);
        return node2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node genExprTransformHelper(GeneratorExpression generatorExpression) {
        int n;
        Node node;
        Node node2;
        this.decompiler.addToken(90);
        int n2 = generatorExpression.getLineno();
        Node node3 = this.transform(generatorExpression.getResult());
        List<GeneratorExpressionLoop> list = generatorExpression.getLoops();
        int n3 = list.size();
        Node[] nodeArray = new Node[n3];
        Node[] nodeArray2 = new Node[n3];
        for (int i = 0; i < n3; ++i) {
            node2 = list.get(i);
            this.decompiler.addName(" ");
            this.decompiler.addToken(123);
            this.decompiler.addToken(90);
            AstNode astNode = ((ForInLoop)node2).getIterator();
            String string = null;
            if (astNode.getType() == 39) {
                string = astNode.getString();
                this.decompiler.addName(string);
            } else {
                this.decompile(astNode);
                string = this.parser.currentScriptOrFn.getNextTempName();
                this.parser.defineSymbol(90, string, false);
                node3 = IRFactory.createBinary(92, this.createAssignment(93, astNode, this.parser.createName(string)), node3);
            }
            node = this.parser.createName(string);
            this.parser.defineSymbol(157, string, false);
            nodeArray[i] = node;
            if (((ForInLoop)node2).isForOf()) {
                this.decompiler.addName("of ");
            } else {
                this.decompiler.addToken(52);
            }
            nodeArray2[i] = this.transform(((ForInLoop)node2).getIteratedObject());
            this.decompiler.addToken(91);
        }
        Node node4 = new Node(73, node3, generatorExpression.getLineno());
        node2 = new Node(137, node4, n2);
        if (generatorExpression.getFilter() != null) {
            this.decompiler.addName(" ");
            this.decompiler.addToken(116);
            this.decompiler.addToken(90);
            node2 = IRFactory.createIf(this.transform(generatorExpression.getFilter()), node2, null, n2);
            this.decompiler.addToken(91);
        }
        int n4 = 0;
        try {
            for (n = n3 - 1; n >= 0; --n) {
                node = list.get(n);
                Scope scope = this.createLoopNode(null, ((AstNode)node).getLineno());
                this.parser.pushScope(scope);
                ++n4;
                node2 = this.createForIn(157, scope, nodeArray[n], nodeArray2[n], node2, ((GeneratorExpressionLoop)node).isForEach(), ((ForInLoop)node).isForOf());
            }
        }
        finally {
            for (n = 0; n < n4; ++n) {
                this.parser.popScope();
            }
        }
        this.decompiler.addToken(91);
        return node2;
    }

    private Node transformIf(IfStatement ifStatement) {
        this.decompiler.addToken(116);
        this.decompiler.addToken(90);
        Node node = this.transform(ifStatement.getCondition());
        this.decompiler.addToken(91);
        this.decompiler.addEOL(88);
        Node node2 = this.transform(ifStatement.getThenPart());
        Node node3 = null;
        if (ifStatement.getElsePart() != null) {
            this.decompiler.addToken(89);
            this.decompiler.addToken(117);
            this.decompiler.addEOL(88);
            node3 = this.transform(ifStatement.getElsePart());
        }
        this.decompiler.addEOL(89);
        return IRFactory.createIf(node, node2, node3, ifStatement.getLineno());
    }

    private Node transformInfix(InfixExpression infixExpression) {
        Node node = this.transform(infixExpression.getLeft());
        this.decompiler.addToken(infixExpression.getType());
        Node node2 = this.transform(infixExpression.getRight());
        if (infixExpression instanceof XmlDotQuery) {
            this.decompiler.addToken(91);
        }
        return IRFactory.createBinary(infixExpression.getType(), node, node2);
    }

    private Node transformLabeledStatement(LabeledStatement labeledStatement) {
        Node node2;
        Label label = labeledStatement.getFirstLabel();
        List<Label> list = labeledStatement.getLabels();
        this.decompiler.addName(label.getName());
        if (list.size() > 1) {
            for (Node node2 : list.subList(1, list.size())) {
                this.decompiler.addEOL(107);
                this.decompiler.addName(node2.getName());
            }
        }
        if (labeledStatement.getStatement().getType() == 133) {
            this.decompiler.addToken(67);
            this.decompiler.addEOL(88);
        } else {
            this.decompiler.addEOL(107);
        }
        Node node3 = this.transform(labeledStatement.getStatement());
        if (labeledStatement.getStatement().getType() == 133) {
            this.decompiler.addEOL(89);
        }
        node2 = Node.newTarget();
        Node node4 = new Node(133, (Node)label, node3, node2);
        label.target = node2;
        return node4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformLetNode(LetNode letNode) {
        this.parser.pushScope(letNode);
        try {
            boolean bl;
            this.decompiler.addToken(157);
            this.decompiler.addToken(90);
            Node node = this.transformVariableInitializers(letNode.getVariables());
            this.decompiler.addToken(91);
            letNode.addChildToBack(node);
            boolean bl2 = bl = letNode.getType() == 162;
            if (letNode.getBody() != null) {
                if (bl) {
                    this.decompiler.addName(" ");
                } else {
                    this.decompiler.addEOL(88);
                }
                letNode.addChildToBack(this.transform(letNode.getBody()));
                if (!bl) {
                    this.decompiler.addEOL(89);
                }
            }
            LetNode letNode2 = letNode;
            return letNode2;
        }
        finally {
            this.parser.popScope();
        }
    }

    private Node transformLiteral(AstNode astNode) {
        this.decompiler.addToken(astNode.getType());
        return astNode;
    }

    private Node transformName(Name name) {
        this.decompiler.addName(name.getIdentifier());
        return name;
    }

    private Node transformNewExpr(NewExpression newExpression) {
        this.decompiler.addToken(30);
        Node node = this.createCallOrNew(30, this.transform(newExpression.getTarget()));
        node.setLineno(newExpression.getLineno());
        List<AstNode> list = newExpression.getArguments();
        this.decompiler.addToken(90);
        for (int i = 0; i < list.size(); ++i) {
            AstNode astNode = list.get(i);
            node.addChildToBack(this.transform(astNode));
            if (i >= list.size() - 1) continue;
            this.decompiler.addToken(92);
        }
        this.decompiler.addToken(91);
        if (newExpression.getInitializer() != null) {
            node.addChildToBack(this.transformObjectLiteral(newExpression.getInitializer()));
        }
        return node;
    }

    private Node transformNumber(NumberLiteral numberLiteral) {
        this.decompiler.addNumber(numberLiteral.getNumber());
        return numberLiteral;
    }

    private Node transformObjectLiteral(ObjectLiteral objectLiteral) {
        Object[] objectArray;
        if (objectLiteral.isDestructuring()) {
            return objectLiteral;
        }
        this.decompiler.addToken(88);
        List<ObjectProperty> list = objectLiteral.getElements();
        Node node = new Node(67);
        if (list.isEmpty()) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            int n = list.size();
            int n2 = 0;
            objectArray = new Object[n];
            for (ObjectProperty objectProperty : list) {
                if (objectProperty.isGetterMethod()) {
                    this.decompiler.addToken(155);
                } else if (objectProperty.isSetterMethod()) {
                    this.decompiler.addToken(156);
                } else if (objectProperty.isNormalMethod()) {
                    this.decompiler.addToken(167);
                }
                objectArray[n2++] = this.getPropKey(objectProperty.getLeft());
                if (!objectProperty.isMethod()) {
                    this.decompiler.addToken(67);
                }
                Node node2 = this.transform(objectProperty.getRight());
                if (objectProperty.isGetterMethod()) {
                    node2 = IRFactory.createUnary(155, node2);
                } else if (objectProperty.isSetterMethod()) {
                    node2 = IRFactory.createUnary(156, node2);
                } else if (objectProperty.isNormalMethod()) {
                    node2 = IRFactory.createUnary(167, node2);
                }
                node.addChildToBack(node2);
                if (n2 >= n) continue;
                this.decompiler.addToken(92);
            }
        }
        this.decompiler.addToken(89);
        node.putProp(12, objectArray);
        return node;
    }

    private Object getPropKey(Node node) {
        Object object;
        if (node instanceof Name) {
            String string = ((Name)node).getIdentifier();
            this.decompiler.addName(string);
            object = ScriptRuntime.getIndexObject(string);
        } else if (node instanceof StringLiteral) {
            String string = ((StringLiteral)node).getValue();
            this.decompiler.addString(string);
            object = ScriptRuntime.getIndexObject(string);
        } else if (node instanceof NumberLiteral) {
            double d = ((NumberLiteral)node).getNumber();
            this.decompiler.addNumber(d);
            object = ScriptRuntime.getIndexObject(d);
        } else {
            throw Kit.codeBug();
        }
        return object;
    }

    private Node transformParenExpr(ParenthesizedExpression parenthesizedExpression) {
        AstNode astNode = parenthesizedExpression.getExpression();
        this.decompiler.addToken(90);
        int n = 1;
        while (astNode instanceof ParenthesizedExpression) {
            this.decompiler.addToken(90);
            ++n;
            astNode = ((ParenthesizedExpression)astNode).getExpression();
        }
        Node node = this.transform(astNode);
        for (int i = 0; i < n; ++i) {
            this.decompiler.addToken(91);
        }
        node.putProp(19, Boolean.TRUE);
        return node;
    }

    private Node transformPropertyGet(PropertyGet propertyGet) {
        Node node = this.transform(propertyGet.getTarget());
        String string = propertyGet.getProperty().getIdentifier();
        this.decompiler.addToken(112);
        this.decompiler.addName(string);
        return this.createPropertyGet(node, null, string, 0);
    }

    private Node transformTemplateLiteral(TemplateLiteral templateLiteral) {
        this.decompiler.addToken(170);
        List<AstNode> list = templateLiteral.getElements();
        Node node = Node.newString("");
        for (AstNode astNode : list) {
            if (astNode.getType() != 171) {
                this.decompiler.addToken(172);
                node = IRFactory.createBinary(21, node, this.transform(astNode));
                this.decompiler.addToken(89);
                continue;
            }
            TemplateCharacters templateCharacters = (TemplateCharacters)astNode;
            this.decompiler.addTemplateLiteral(templateCharacters.getRawValue());
            String string = templateCharacters.getValue();
            if (string.length() <= 0) continue;
            node = IRFactory.createBinary(21, node, Node.newString(string));
        }
        this.decompiler.addToken(170);
        return node;
    }

    private Node transformTemplateLiteralCall(TaggedTemplateLiteral taggedTemplateLiteral) {
        Node node = this.createCallOrNew(38, this.transform(taggedTemplateLiteral.getTarget()));
        node.setLineno(taggedTemplateLiteral.getLineno());
        this.decompiler.addToken(170);
        TemplateLiteral templateLiteral = (TemplateLiteral)taggedTemplateLiteral.getTemplateLiteral();
        List<AstNode> list = templateLiteral.getElements();
        node.addChildToBack(templateLiteral);
        for (AstNode astNode : list) {
            if (astNode.getType() != 171) {
                this.decompiler.addToken(172);
                node.addChildToBack(this.transform(astNode));
                this.decompiler.addToken(89);
                continue;
            }
            TemplateCharacters templateCharacters = (TemplateCharacters)astNode;
            this.decompiler.addTemplateLiteral(templateCharacters.getRawValue());
        }
        this.parser.currentScriptOrFn.addTemplateLiteral(templateLiteral);
        this.decompiler.addToken(170);
        return node;
    }

    private Node transformRegExp(RegExpLiteral regExpLiteral) {
        this.decompiler.addRegexp(regExpLiteral.getValue(), regExpLiteral.getFlags());
        this.parser.currentScriptOrFn.addRegExp(regExpLiteral);
        return regExpLiteral;
    }

    private Node transformReturn(ReturnStatement returnStatement) {
        AstNode astNode;
        Node node;
        boolean bl = Boolean.TRUE.equals(returnStatement.getProp(25));
        boolean bl2 = Boolean.TRUE.equals(returnStatement.getProp(27));
        if (bl) {
            if (!bl2) {
                this.decompiler.addName(" ");
            }
        } else {
            this.decompiler.addToken(4);
        }
        Node node2 = node = (astNode = returnStatement.getReturnValue()) == null ? null : this.transform(astNode);
        if (!bl) {
            this.decompiler.addEOL(85);
        }
        return astNode == null ? new Node(4, returnStatement.getLineno()) : new Node(4, node, returnStatement.getLineno());
    }

    private Node transformScript(ScriptNode scriptNode) {
        this.decompiler.addToken(140);
        if (this.parser.currentScope != null) {
            Kit.codeBug();
        }
        this.parser.currentScope = scriptNode;
        Node node = new Node(133);
        for (Node node2 : scriptNode) {
            node.addChildToBack(this.transform((AstNode)node2));
        }
        scriptNode.removeChildren();
        Node node3 = node.getFirstChild();
        if (node3 != null) {
            scriptNode.addChildrenToBack(node3);
        }
        return scriptNode;
    }

    private Node transformString(StringLiteral stringLiteral) {
        this.decompiler.addString(stringLiteral.getValue());
        return Node.newString(stringLiteral.getValue());
    }

    private Node transformSwitch(SwitchStatement switchStatement) {
        this.decompiler.addToken(118);
        this.decompiler.addToken(90);
        Node node = this.transform(switchStatement.getExpression());
        this.decompiler.addToken(91);
        switchStatement.addChildToBack(node);
        Node node2 = new Node(133, (Node)switchStatement, switchStatement.getLineno());
        this.decompiler.addEOL(88);
        for (SwitchCase switchCase : switchStatement.getCases()) {
            AstNode astNode = switchCase.getExpression();
            Node node3 = null;
            if (astNode != null) {
                this.decompiler.addToken(119);
                node3 = this.transform(astNode);
            } else {
                this.decompiler.addToken(120);
            }
            this.decompiler.addEOL(107);
            List<AstNode> list = switchCase.getStatements();
            Block block = new Block();
            if (list != null) {
                for (AstNode astNode2 : list) {
                    block.addChildToBack(this.transform(astNode2));
                }
            }
            IRFactory.addSwitchCase(node2, node3, block);
        }
        this.decompiler.addEOL(89);
        IRFactory.closeSwitch(node2);
        return node2;
    }

    private Node transformThrow(ThrowStatement throwStatement) {
        this.decompiler.addToken(50);
        Node node = this.transform(throwStatement.getExpression());
        this.decompiler.addEOL(85);
        return new Node(50, node, throwStatement.getLineno());
    }

    private Node transformTry(TryStatement tryStatement) {
        this.decompiler.addToken(84);
        this.decompiler.addEOL(88);
        Node node = this.transform(tryStatement.getTryBlock());
        this.decompiler.addEOL(89);
        Block block = new Block();
        for (CatchClause catchClause : tryStatement.getCatchClauses()) {
            Node node2;
            this.decompiler.addToken(128);
            Name name = catchClause.getVarName();
            Node node3 = null;
            Node node4 = null;
            if (name != null) {
                this.decompiler.addToken(90);
                this.decompiler.addName(name.getIdentifier());
                node4 = this.parser.createName(name.getIdentifier());
                node2 = catchClause.getCatchCondition();
                if (node2 != null) {
                    this.decompiler.addName(" ");
                    this.decompiler.addToken(116);
                    node3 = this.transform((AstNode)node2);
                } else {
                    node3 = new EmptyExpression();
                }
                this.decompiler.addToken(91);
            }
            this.decompiler.addEOL(88);
            node2 = this.transform(catchClause.getBody());
            this.decompiler.addEOL(89);
            block.addChildToBack(this.createCatch(node4, node3, node2, catchClause.getLineno()));
        }
        Object object = null;
        if (tryStatement.getFinallyBlock() != null) {
            this.decompiler.addToken(129);
            this.decompiler.addEOL(88);
            object = this.transform(tryStatement.getFinallyBlock());
            this.decompiler.addEOL(89);
        }
        return this.createTryCatchFinally(node, block, (Node)object, tryStatement.getLineno());
    }

    private Node transformUnary(UnaryExpression unaryExpression) {
        int n = unaryExpression.getType();
        if (n == 76) {
            return this.transformDefaultXmlNamepace(unaryExpression);
        }
        this.decompiler.addToken(n);
        Node node = this.transform(unaryExpression.getOperand());
        return IRFactory.createUnary(n, node);
    }

    private Node transformUpdate(UpdateExpression updateExpression) {
        int n = updateExpression.getType();
        if (updateExpression.isPrefix()) {
            this.decompiler.addToken(n);
        }
        Node node = this.transform(updateExpression.getOperand());
        if (updateExpression.isPostfix()) {
            this.decompiler.addToken(n);
        }
        return IRFactory.createIncDec(n, updateExpression.isPostfix(), node);
    }

    private Node transformVariables(VariableDeclaration variableDeclaration) {
        this.decompiler.addToken(variableDeclaration.getType());
        this.transformVariableInitializers(variableDeclaration);
        AstNode astNode = variableDeclaration.getParent();
        if (!(astNode instanceof Loop) && !(astNode instanceof LetNode)) {
            this.decompiler.addEOL(85);
        }
        return variableDeclaration;
    }

    private Node transformVariableInitializers(VariableDeclaration variableDeclaration) {
        List<VariableInitializer> list = variableDeclaration.getVariables();
        int n = list.size();
        int n2 = 0;
        for (VariableInitializer variableInitializer : list) {
            AstNode astNode = variableInitializer.getTarget();
            AstNode astNode2 = variableInitializer.getInitializer();
            Node node = null;
            if (variableInitializer.isDestructuring()) {
                this.decompile(astNode);
                node = astNode;
            } else {
                node = this.transform(astNode);
            }
            Node node2 = null;
            if (astNode2 != null) {
                this.decompiler.addToken(93);
                node2 = this.transform(astNode2);
            }
            if (variableInitializer.isDestructuring()) {
                if (node2 == null) {
                    variableDeclaration.addChildToBack(node);
                } else {
                    Node node3 = this.parser.createDestructuringAssignment(variableDeclaration.getType(), node, node2);
                    variableDeclaration.addChildToBack(node3);
                }
            } else {
                if (node2 != null) {
                    node.addChildToBack(node2);
                }
                variableDeclaration.addChildToBack(node);
            }
            if (n2++ >= n - 1) continue;
            this.decompiler.addToken(92);
        }
        return variableDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformWhileLoop(WhileLoop whileLoop) {
        this.decompiler.addToken(121);
        whileLoop.setType(136);
        this.parser.pushScope(whileLoop);
        try {
            this.decompiler.addToken(90);
            Node node = this.transform(whileLoop.getCondition());
            this.decompiler.addToken(91);
            this.decompiler.addEOL(88);
            Node node2 = this.transform(whileLoop.getBody());
            this.decompiler.addEOL(89);
            Node node3 = IRFactory.createLoop(whileLoop, 1, node2, node, null, null);
            return node3;
        }
        finally {
            this.parser.popScope();
        }
    }

    private Node transformWith(WithStatement withStatement) {
        this.decompiler.addToken(127);
        this.decompiler.addToken(90);
        Node node = this.transform(withStatement.getExpression());
        this.decompiler.addToken(91);
        this.decompiler.addEOL(88);
        Node node2 = this.transform(withStatement.getStatement());
        this.decompiler.addEOL(89);
        return this.createWith(node, node2, withStatement.getLineno());
    }

    private Node transformYield(Yield yield) {
        Node node;
        this.decompiler.addToken(yield.getType());
        Node node2 = node = yield.getValue() == null ? null : this.transform(yield.getValue());
        if (node != null) {
            return new Node(yield.getType(), node, yield.getLineno());
        }
        return new Node(yield.getType(), yield.getLineno());
    }

    private Node transformXmlLiteral(XmlLiteral xmlLiteral) {
        Node node = new Node(30, xmlLiteral.getLineno());
        List<XmlFragment> list = xmlLiteral.getFragments();
        XmlString xmlString = (XmlString)list.get(0);
        boolean bl = xmlString.getXml().trim().startsWith("<>");
        node.addChildToBack(this.parser.createName(bl ? "XMLList" : "XML"));
        Node node2 = null;
        for (XmlFragment xmlFragment : list) {
            Object object;
            if (xmlFragment instanceof XmlString) {
                object = ((XmlString)xmlFragment).getXml();
                this.decompiler.addName((String)object);
                if (node2 == null) {
                    node2 = IRFactory.createString((String)object);
                    continue;
                }
                node2 = IRFactory.createBinary(21, node2, IRFactory.createString((String)object));
                continue;
            }
            object = (XmlExpression)xmlFragment;
            boolean bl2 = ((XmlExpression)object).isXmlAttribute();
            this.decompiler.addToken(88);
            Node node3 = ((XmlExpression)object).getExpression() instanceof EmptyExpression ? IRFactory.createString("") : this.transform(((XmlExpression)object).getExpression());
            this.decompiler.addToken(89);
            if (bl2) {
                node3 = IRFactory.createUnary(77, node3);
                Node node4 = IRFactory.createBinary(21, IRFactory.createString("\""), node3);
                node3 = IRFactory.createBinary(21, node4, IRFactory.createString("\""));
            } else {
                node3 = IRFactory.createUnary(78, node3);
            }
            node2 = IRFactory.createBinary(21, node2, node3);
        }
        node.addChildToBack(node2);
        return node;
    }

    private Node transformXmlMemberGet(XmlMemberGet xmlMemberGet) {
        int n;
        XmlRef xmlRef = xmlMemberGet.getMemberRef();
        Node node = this.transform(xmlMemberGet.getLeft());
        int n2 = n = xmlRef.isAttributeAccess() ? 2 : 0;
        if (xmlMemberGet.getType() == 147) {
            n |= 4;
            this.decompiler.addToken(147);
        } else {
            this.decompiler.addToken(112);
        }
        return this.transformXmlRef(node, xmlRef, n);
    }

    private Node transformXmlRef(XmlRef xmlRef) {
        int n = xmlRef.isAttributeAccess() ? 2 : 0;
        return this.transformXmlRef(null, xmlRef, n);
    }

    private Node transformXmlRef(Node node, XmlRef xmlRef, int n) {
        Name name;
        String string;
        if ((n & 2) != 0) {
            this.decompiler.addToken(151);
        }
        String string2 = string = (name = xmlRef.getNamespace()) != null ? name.getIdentifier() : null;
        if (string != null) {
            this.decompiler.addName(string);
            this.decompiler.addToken(148);
        }
        if (xmlRef instanceof XmlPropRef) {
            String string3 = ((XmlPropRef)xmlRef).getPropName().getIdentifier();
            this.decompiler.addName(string3);
            return this.createPropertyGet(node, string, string3, n);
        }
        this.decompiler.addToken(86);
        Node node2 = this.transform(((XmlElemRef)xmlRef).getExpression());
        this.decompiler.addToken(87);
        return this.createElementGet(node, string, node2, n);
    }

    private Node transformDefaultXmlNamepace(UnaryExpression unaryExpression) {
        this.decompiler.addToken(120);
        this.decompiler.addName(" xml");
        this.decompiler.addName(" namespace");
        this.decompiler.addToken(93);
        Node node = this.transform(unaryExpression.getOperand());
        return IRFactory.createUnary(76, node);
    }

    private static void addSwitchCase(Node node, Node node2, Node node3) {
        if (node.getType() != 133) {
            throw Kit.codeBug();
        }
        Jump jump = (Jump)node.getFirstChild();
        if (jump.getType() != 118) {
            throw Kit.codeBug();
        }
        Node node4 = Node.newTarget();
        if (node2 != null) {
            Jump jump2 = new Jump(119, node2);
            jump2.target = node4;
            jump.addChildToBack(jump2);
        } else {
            jump.setDefault(node4);
        }
        node.addChildToBack(node4);
        node.addChildToBack(node3);
    }

    private static void closeSwitch(Node node) {
        Node node2;
        if (node.getType() != 133) {
            throw Kit.codeBug();
        }
        Jump jump = (Jump)node.getFirstChild();
        if (jump.getType() != 118) {
            throw Kit.codeBug();
        }
        jump.target = node2 = Node.newTarget();
        Node node3 = jump.getDefault();
        if (node3 == null) {
            node3 = node2;
        }
        node.addChildAfter(IRFactory.makeJump(5, node3), jump);
        node.addChildToBack(node2);
    }

    private static Node createExprStatementNoReturn(Node node, int n) {
        return new Node(137, node, n);
    }

    private static Node createString(String string) {
        return Node.newString(string);
    }

    private Node createCatch(Node node, Node node2, Node node3, int n) {
        if (node == null) {
            node = new Node(132);
        }
        if (node2 == null) {
            node2 = new Node(132);
        }
        return new Node(128, node, node2, node3, n);
    }

    private static Node initFunction(FunctionNode functionNode, int n, Node node, int n2) {
        Node node2;
        Node node3;
        functionNode.setFunctionType(n2);
        functionNode.addChildToBack(node);
        int n3 = functionNode.getFunctionCount();
        if (n3 != 0) {
            functionNode.setRequiresActivation();
        }
        if (n2 == 2 && (node3 = functionNode.getFunctionName()) != null && ((Name)node3).length() != 0 && functionNode.getSymbol(((Name)node3).getIdentifier()) == null) {
            functionNode.putSymbol(new Symbol(113, ((Name)node3).getIdentifier()));
            node2 = new Node(137, new Node(8, Node.newString(49, ((Name)node3).getIdentifier()), new Node(64)));
            node.addChildrenToFront(node2);
        }
        if ((node3 = node.getLastChild()) == null || node3.getType() != 4) {
            node.addChildToBack(new Node(4));
        }
        node2 = Node.newString(113, functionNode.getName());
        node2.putIntProp(1, n);
        return node2;
    }

    private Scope createLoopNode(Node node, int n) {
        Scope scope = this.parser.createScopeNode(136, n);
        if (node != null) {
            ((Jump)node).setLoop(scope);
        }
        return scope;
    }

    private static Node createFor(Scope scope, Node node, Node node2, Node node3, Node node4) {
        if (node.getType() == 157) {
            Scope scope2 = Scope.splitScope(scope);
            scope2.setType(157);
            scope2.addChildrenToBack(node);
            scope2.addChildToBack(IRFactory.createLoop(scope, 2, node4, node2, new Node(132), node3));
            return scope2;
        }
        return IRFactory.createLoop(scope, 2, node4, node2, node, node3);
    }

    private static Node createLoop(Jump jump, int n, Node node, Node node2, Node node3, Node node4) {
        Node node5 = Node.newTarget();
        Node node6 = Node.newTarget();
        if (n == 2 && node2.getType() == 132) {
            node2 = new Node(45);
        }
        Jump jump2 = new Jump(6, node2);
        jump2.target = node5;
        Node node7 = Node.newTarget();
        jump.addChildToBack(node5);
        jump.addChildrenToBack(node);
        if (n == 1 || n == 2) {
            jump.addChildrenToBack(new Node(132, jump.getLineno()));
        }
        jump.addChildToBack(node6);
        jump.addChildToBack(jump2);
        jump.addChildToBack(node7);
        jump.target = node7;
        Node node8 = node6;
        if (n == 1 || n == 2) {
            jump.addChildToFront(IRFactory.makeJump(5, node6));
            if (n == 2) {
                int n2 = node3.getType();
                if (n2 != 132) {
                    if (n2 != 126 && n2 != 157) {
                        node3 = new Node(137, node3);
                    }
                    jump.addChildToFront(node3);
                }
                Node node9 = Node.newTarget();
                jump.addChildAfter(node9, node);
                if (node4.getType() != 132) {
                    node4 = new Node(137, node4);
                    jump.addChildAfter(node4, node9);
                }
                node8 = node9;
            }
        }
        jump.setContinue(node8);
        return jump;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Node createForIn(int n, Node node, Node node2, Node node3, Node node4, boolean bl, boolean bl2) {
        Node node5;
        Node node6;
        int n2;
        Node node7;
        int n3;
        int n4;
        int n5;
        block13: {
            block12: {
                n5 = -1;
                n4 = 0;
                n3 = node2.getType();
                if (n3 != 126 && n3 != 157) break block12;
                node7 = node2.getLastChild();
                n2 = node7.getType();
                if (n2 == 66 || n2 == 67) {
                    n3 = n5 = n2;
                    node6 = node7;
                    n4 = 0;
                    if (node7 instanceof ArrayLiteral) {
                        n4 = ((ArrayLiteral)node7).getDestructuringLength();
                    }
                    break block13;
                } else {
                    if (n2 != 39) {
                        this.parser.reportError("msg.bad.for.in.lhs");
                        return null;
                    }
                    node6 = Node.newString(39, node7.getString());
                }
                break block13;
            }
            if (n3 == 66 || n3 == 67) {
                n5 = n3;
                node6 = node2;
                n4 = 0;
                if (node2 instanceof ArrayLiteral) {
                    n4 = ((ArrayLiteral)node2).getDestructuringLength();
                }
            } else {
                node6 = IRFactory.makeReference(node2);
                if (node6 == null) {
                    this.parser.reportError("msg.bad.for.in.lhs");
                    return null;
                }
            }
        }
        node7 = new Node(145);
        n2 = bl ? 59 : (bl2 ? 61 : (n5 != -1 ? 60 : 58));
        Node node8 = new Node(n2, node3);
        node8.putProp(3, node7);
        Node node9 = new Node(62);
        node9.putProp(3, node7);
        Node node10 = new Node(63);
        node10.putProp(3, node7);
        Node node11 = new Node(133);
        if (n5 != -1) {
            node5 = this.parser.createDestructuringAssignment(n, node6, node10);
            if (!(bl || bl2 || n5 != 67 && n4 == 2)) {
                this.parser.reportError("msg.bad.for.in.destruct");
            }
        } else {
            node5 = this.parser.simpleAssignment(node6, node10);
        }
        node11.addChildToBack(new Node(137, node5));
        node11.addChildToBack(node4);
        node = IRFactory.createLoop((Jump)node, 1, node11, node9, null, null);
        node.addChildToFront(node8);
        if (n3 == 126 || n3 == 157) {
            node.addChildToFront(node2);
        }
        node7.addChildToBack(node);
        return node7;
    }

    private Node createTryCatchFinally(Node node, Node node2, Node node3, int n) {
        Node node4;
        Node node5;
        Node node6;
        boolean bl;
        boolean bl2 = bl = node3 != null && (node3.getType() != 133 || node3.hasChildren());
        if (node.getType() == 133 && !node.hasChildren() && !bl) {
            return node;
        }
        boolean bl3 = node2.hasChildren();
        if (!bl && !bl3) {
            return node;
        }
        Node node7 = new Node(145);
        Jump jump = new Jump(84, node, n);
        jump.putProp(3, node7);
        if (bl3) {
            node6 = Node.newTarget();
            jump.addChildToBack(IRFactory.makeJump(5, node6));
            jump.target = node5 = Node.newTarget();
            jump.addChildToBack(node5);
            node4 = new Node(145);
            Node node8 = node2.getFirstChild();
            boolean bl4 = false;
            int n2 = 0;
            while (node8 != null) {
                Node node9;
                int n3 = node8.getLineno();
                Node node10 = node8.getFirstChild();
                Node node11 = node10.getNext();
                Node node12 = node11.getNext();
                node8.removeChild(node10);
                node8.removeChild(node11);
                node8.removeChild(node12);
                node12.addChildToBack(new Node(3));
                node12.addChildToBack(IRFactory.makeJump(5, node6));
                if (node11.getType() == 132) {
                    node9 = node12;
                    bl4 = true;
                } else {
                    node9 = IRFactory.createIf(node11, node12, null, n3);
                }
                Node node13 = new Node(57, node10, IRFactory.createUseLocal(node7));
                node13.putProp(3, node4);
                node13.putIntProp(14, n2);
                node4.addChildToBack(node13);
                node4.addChildToBack(this.createWith(IRFactory.createUseLocal(node4), node9, n3));
                node8 = node8.getNext();
                ++n2;
            }
            jump.addChildToBack(node4);
            if (!bl4) {
                Node node14 = new Node(51);
                node14.putProp(3, node7);
                jump.addChildToBack(node14);
            }
            jump.addChildToBack(node6);
        }
        if (bl) {
            node6 = Node.newTarget();
            jump.setFinally(node6);
            jump.addChildToBack(IRFactory.makeJump(139, node6));
            node5 = Node.newTarget();
            jump.addChildToBack(IRFactory.makeJump(5, node5));
            jump.addChildToBack(node6);
            node4 = new Node(129, node3);
            node4.putProp(3, node7);
            jump.addChildToBack(node4);
            jump.addChildToBack(node5);
        }
        node7.addChildToBack(jump);
        return node7;
    }

    private Node createWith(Node node, Node node2, int n) {
        this.parser.setRequiresActivation();
        Node node3 = new Node(133, n);
        node3.addChildToBack(new Node(2, node));
        Node node4 = new Node(127, node2, n);
        node3.addChildrenToBack(node4);
        node3.addChildToBack(new Node(3));
        return node3;
    }

    private static Node createIf(Node node, Node node2, Node node3, int n) {
        int n2 = IRFactory.isAlwaysDefinedBoolean(node);
        if (n2 == 1) {
            return node2;
        }
        if (n2 == -1) {
            if (node3 != null) {
                return node3;
            }
            return new Node(133, n);
        }
        Node node4 = new Node(133, n);
        Node node5 = Node.newTarget();
        Jump jump = new Jump(7, node);
        jump.target = node5;
        node4.addChildToBack(jump);
        node4.addChildrenToBack(node2);
        if (node3 != null) {
            Node node6 = Node.newTarget();
            node4.addChildToBack(IRFactory.makeJump(5, node6));
            node4.addChildToBack(node5);
            node4.addChildrenToBack(node3);
            node4.addChildToBack(node6);
        } else {
            node4.addChildToBack(node5);
        }
        return node4;
    }

    private static Node createCondExpr(Node node, Node node2, Node node3) {
        int n = IRFactory.isAlwaysDefinedBoolean(node);
        if (n == 1) {
            return node2;
        }
        if (n == -1) {
            return node3;
        }
        return new Node(106, node, node2, node3);
    }

    private static Node createUnary(int n, Node node) {
        int n2 = node.getType();
        switch (n) {
            case 31: {
                Node node2;
                if (n2 == 39) {
                    node.setType(49);
                    Node node3 = Node.newString(node.getString());
                    node2 = new Node(n, node, node3);
                } else if (n2 == 33 || n2 == 36) {
                    Node node4 = node.getFirstChild();
                    Node node5 = node.getLastChild();
                    node.removeChild(node4);
                    node.removeChild(node5);
                    node2 = new Node(n, node4, node5);
                } else if (n2 == 68) {
                    Node node6 = node.getFirstChild();
                    node.removeChild(node6);
                    node2 = new Node(70, node6);
                } else {
                    node2 = new Node(n, new Node(45), node);
                }
                return node2;
            }
            case 32: {
                if (n2 != 39) break;
                node.setType(141);
                return node;
            }
            case 27: {
                if (n2 != 40) break;
                int n3 = ScriptRuntime.toInt32(node.getDouble());
                node.setDouble(~n3);
                return node;
            }
            case 29: {
                if (n2 != 40) break;
                node.setDouble(-node.getDouble());
                return node;
            }
            case 26: {
                int n4 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n4 == 0) break;
                int n5 = n4 == 1 ? 44 : 45;
                if (n2 == 45 || n2 == 44) {
                    node.setType(n5);
                    return node;
                }
                return new Node(n5);
            }
        }
        return new Node(n, node);
    }

    private Node createCallOrNew(int n, Node node) {
        Object object;
        int n2 = 0;
        if (node.getType() == 39) {
            object = node.getString();
            if (((String)object).equals("eval")) {
                n2 = 1;
            } else if (((String)object).equals("With")) {
                n2 = 2;
            }
        } else if (node.getType() == 33 && ((String)(object = node.getLastChild().getString())).equals("eval")) {
            n2 = 1;
        }
        object = new Node(n, node);
        if (n2 != 0) {
            this.parser.setRequiresActivation();
            ((Node)object).putIntProp(10, n2);
        }
        return object;
    }

    private static Node createIncDec(int n, boolean bl, Node node) {
        node = IRFactory.makeReference(node);
        int n2 = node.getType();
        switch (n2) {
            case 33: 
            case 36: 
            case 39: 
            case 68: {
                Node node2 = new Node(n, node);
                int n3 = 0;
                if (n == 111) {
                    n3 |= 1;
                }
                if (bl) {
                    n3 |= 2;
                }
                node2.putIntProp(13, n3);
                return node2;
            }
        }
        throw Kit.codeBug();
    }

    private Node createPropertyGet(Node node, String string, String string2, int n) {
        if (string == null && n == 0) {
            if (node == null) {
                return this.parser.createName(string2);
            }
            this.parser.checkActivationName(string2, 33);
            if (ScriptRuntime.isSpecialProperty(string2)) {
                Node node2 = new Node(72, node);
                node2.putProp(17, string2);
                return new Node(68, node2);
            }
            return new Node(33, node, Node.newString(string2));
        }
        Node node3 = Node.newString(string2);
        return this.createMemberRefGet(node, string, node3, n |= 1);
    }

    private Node createElementGet(Node node, String string, Node node2, int n) {
        if (string == null && n == 0) {
            if (node == null) {
                throw Kit.codeBug();
            }
            return new Node(36, node, node2);
        }
        return this.createMemberRefGet(node, string, node2, n);
    }

    private Node createMemberRefGet(Node node, String string, Node node2, int n) {
        Node node3 = null;
        if (string != null) {
            node3 = string.equals("*") ? new Node(42) : this.parser.createName(string);
        }
        Node node4 = node == null ? (string == null ? new Node(81, node2) : new Node(82, node3, node2)) : (string == null ? new Node(79, node, node2) : new Node(80, node, node3, node2));
        if (n != 0) {
            node4.putIntProp(16, n);
        }
        return new Node(68, node4);
    }

    private static Node createBinary(int n, Node node, Node node2) {
        switch (n) {
            case 21: {
                if (node.type == 41) {
                    String string;
                    if (node2.type == 41) {
                        string = node2.getString();
                    } else {
                        if (node2.type != 40) break;
                        string = ScriptRuntime.numberToString(node2.getDouble(), 10);
                    }
                    String string2 = node.getString();
                    node.setString(string2.concat(string));
                    return node;
                }
                if (node.type != 40) break;
                if (node2.type == 40) {
                    node.setDouble(node.getDouble() + node2.getDouble());
                    return node;
                }
                if (node2.type != 41) break;
                String string = ScriptRuntime.numberToString(node.getDouble(), 10);
                String string3 = node2.getString();
                node2.setString(string.concat(string3));
                return node2;
            }
            case 22: {
                if (node.type == 40) {
                    double d = node.getDouble();
                    if (node2.type == 40) {
                        node.setDouble(d - node2.getDouble());
                        return node;
                    }
                    if (d != 0.0) break;
                    return new Node(29, node2);
                }
                if (node2.type != 40 || node2.getDouble() != 0.0) break;
                return new Node(28, node);
            }
            case 23: {
                if (node.type == 40) {
                    double d = node.getDouble();
                    if (node2.type == 40) {
                        node.setDouble(d * node2.getDouble());
                        return node;
                    }
                    if (d != 1.0) break;
                    return new Node(28, node2);
                }
                if (node2.type != 40 || node2.getDouble() != 1.0) break;
                return new Node(28, node);
            }
            case 24: {
                if (node2.type != 40) break;
                double d = node2.getDouble();
                if (node.type == 40) {
                    node.setDouble(node.getDouble() / d);
                    return node;
                }
                if (d != 1.0) break;
                return new Node(28, node);
            }
            case 109: {
                int n2 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n2 == -1) {
                    return node;
                }
                if (n2 != 1) break;
                return node2;
            }
            case 108: {
                int n3 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n3 == 1) {
                    return node;
                }
                if (n3 != -1) break;
                return node2;
            }
        }
        return new Node(n, node, node2);
    }

    private Node createAssignment(int n, Node node, Node node2) {
        int n2;
        Node node3 = IRFactory.makeReference(node);
        if (node3 == null) {
            if (node.getType() == 66 || node.getType() == 67) {
                if (n != 93) {
                    this.parser.reportError("msg.bad.destruct.op");
                    return node2;
                }
                return this.parser.createDestructuringAssignment(-1, node, node2);
            }
            this.parser.reportError("msg.bad.assign.left");
            return node2;
        }
        node = node3;
        switch (n) {
            case 93: {
                return this.parser.simpleAssignment(node, node2);
            }
            case 94: {
                n2 = 9;
                break;
            }
            case 95: {
                n2 = 10;
                break;
            }
            case 96: {
                n2 = 11;
                break;
            }
            case 97: {
                n2 = 18;
                break;
            }
            case 98: {
                n2 = 19;
                break;
            }
            case 99: {
                n2 = 20;
                break;
            }
            case 100: {
                n2 = 21;
                break;
            }
            case 101: {
                n2 = 22;
                break;
            }
            case 102: {
                n2 = 23;
                break;
            }
            case 103: {
                n2 = 24;
                break;
            }
            case 104: {
                n2 = 25;
                break;
            }
            case 105: {
                n2 = 75;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int n3 = node.getType();
        switch (n3) {
            case 39: {
                Node node4 = new Node(n2, node, node2);
                Node node5 = Node.newString(49, node.getString());
                return new Node(8, node5, node4);
            }
            case 33: 
            case 36: {
                Node node6 = node.getFirstChild();
                Node node7 = node.getLastChild();
                int n4 = n3 == 33 ? 143 : 144;
                Node node8 = new Node(142);
                Node node9 = new Node(n2, node8, node2);
                return new Node(n4, node6, node7, node9);
            }
            case 68: {
                node3 = node.getFirstChild();
                this.parser.checkMutableReference(node3);
                Node node10 = new Node(142);
                Node node11 = new Node(n2, node10, node2);
                return new Node(146, node3, node11);
            }
        }
        throw Kit.codeBug();
    }

    private static Node createUseLocal(Node node) {
        if (145 != node.getType()) {
            throw Kit.codeBug();
        }
        Node node2 = new Node(54);
        node2.putProp(3, node);
        return node2;
    }

    private static Jump makeJump(int n, Node node) {
        Jump jump = new Jump(n);
        jump.target = node;
        return jump;
    }

    private static Node makeReference(Node node) {
        int n = node.getType();
        switch (n) {
            case 33: 
            case 36: 
            case 39: 
            case 68: {
                return node;
            }
            case 38: {
                node.setType(71);
                return new Node(68, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 42: 
            case 44: {
                return -1;
            }
            case 45: {
                return 1;
            }
            case 40: {
                double d = node.getDouble();
                if (!Double.isNaN(d) && d != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    boolean isDestructuring(Node node) {
        return node instanceof DestructuringForm && ((DestructuringForm)((Object)node)).isDestructuring();
    }

    Node decompileFunctionHeader(FunctionNode functionNode) {
        boolean bl;
        Node node = null;
        if (functionNode.getFunctionName() != null) {
            this.decompiler.addName(functionNode.getName());
        } else if (functionNode.getMemberExprNode() != null) {
            node = this.transform(functionNode.getMemberExprNode());
        }
        boolean bl2 = functionNode.getFunctionType() == 4;
        boolean bl3 = bl = bl2 && functionNode.getLp() == -1;
        if (!bl) {
            this.decompiler.addToken(90);
        }
        List<AstNode> list = functionNode.getParams();
        for (int i = 0; i < list.size(); ++i) {
            this.decompile(list.get(i));
            if (i >= list.size() - 1) continue;
            this.decompiler.addToken(92);
        }
        if (!bl) {
            this.decompiler.addToken(91);
        }
        if (bl2) {
            this.decompiler.addToken(168);
        }
        if (!functionNode.isExpressionClosure()) {
            this.decompiler.addEOL(88);
        }
        return node;
    }

    void decompile(AstNode astNode) {
        switch (astNode.getType()) {
            case 66: {
                this.decompileArrayLiteral((ArrayLiteral)astNode);
                break;
            }
            case 67: {
                this.decompileObjectLiteral((ObjectLiteral)astNode);
                break;
            }
            case 41: {
                this.decompiler.addString(((StringLiteral)astNode).getValue());
                break;
            }
            case 39: {
                this.decompiler.addName(((Name)astNode).getIdentifier());
                break;
            }
            case 40: {
                this.decompiler.addNumber(((NumberLiteral)astNode).getNumber());
                break;
            }
            case 83: {
                this.decompiler.addBigInt(astNode.getBigInt());
                break;
            }
            case 33: {
                this.decompilePropertyGet((PropertyGet)astNode);
                break;
            }
            case 132: {
                break;
            }
            case 36: {
                this.decompileElementGet((ElementGet)astNode);
                break;
            }
            case 43: {
                this.decompiler.addToken(astNode.getType());
                break;
            }
            default: {
                Kit.codeBug("unexpected token: " + Token.typeToName(astNode.getType()));
            }
        }
    }

    void decompileArrayLiteral(ArrayLiteral arrayLiteral) {
        this.decompiler.addToken(86);
        List<AstNode> list = arrayLiteral.getElements();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AstNode astNode = list.get(i);
            this.decompile(astNode);
            if (i >= n - 1) continue;
            this.decompiler.addToken(92);
        }
        this.decompiler.addToken(87);
    }

    void decompileObjectLiteral(ObjectLiteral objectLiteral) {
        this.decompiler.addToken(88);
        List<ObjectProperty> list = objectLiteral.getElements();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ObjectProperty objectProperty = list.get(i);
            boolean bl = Boolean.TRUE.equals(objectProperty.getProp(26));
            this.decompile(objectProperty.getLeft());
            if (!bl) {
                this.decompiler.addToken(107);
                this.decompile(objectProperty.getRight());
            }
            if (i >= n - 1) continue;
            this.decompiler.addToken(92);
        }
        this.decompiler.addToken(89);
    }

    void decompilePropertyGet(PropertyGet propertyGet) {
        this.decompile(propertyGet.getTarget());
        this.decompiler.addToken(112);
        this.decompile(propertyGet.getProperty());
    }

    void decompileElementGet(ElementGet elementGet) {
        this.decompile(elementGet.getTarget());
        this.decompiler.addToken(86);
        this.decompile(elementGet.getElement());
        this.decompiler.addToken(87);
    }
}

