/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.ImplementationVersion;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaToJSONConverters;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeContinuation;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UnhandledRejectionTracker;
import org.mozilla.javascript.VMBridge;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.xml.XMLLib;

public class Context
implements Closeable {
    public static final int VERSION_UNKNOWN = -1;
    public static final int VERSION_DEFAULT = 0;
    public static final int VERSION_1_0 = 100;
    public static final int VERSION_1_1 = 110;
    public static final int VERSION_1_2 = 120;
    public static final int VERSION_1_3 = 130;
    public static final int VERSION_1_4 = 140;
    public static final int VERSION_1_5 = 150;
    public static final int VERSION_1_6 = 160;
    public static final int VERSION_1_7 = 170;
    public static final int VERSION_1_8 = 180;
    public static final int VERSION_ES6 = 200;
    public static final int FEATURE_NON_ECMA_GET_YEAR = 1;
    public static final int FEATURE_MEMBER_EXPR_AS_FUNCTION_NAME = 2;
    public static final int FEATURE_RESERVED_KEYWORD_AS_IDENTIFIER = 3;
    public static final int FEATURE_TO_STRING_AS_SOURCE = 4;
    public static final int FEATURE_PARENT_PROTO_PROPERTIES = 5;
    @Deprecated
    public static final int FEATURE_PARENT_PROTO_PROPRTIES = 5;
    public static final int FEATURE_E4X = 6;
    public static final int FEATURE_DYNAMIC_SCOPE = 7;
    public static final int FEATURE_STRICT_VARS = 8;
    public static final int FEATURE_STRICT_EVAL = 9;
    public static final int FEATURE_LOCATION_INFORMATION_IN_ERROR = 10;
    public static final int FEATURE_STRICT_MODE = 11;
    public static final int FEATURE_WARNING_AS_ERROR = 12;
    public static final int FEATURE_ENHANCED_JAVA_ACCESS = 13;
    public static final int FEATURE_V8_EXTENSIONS = 14;
    public static final int FEATURE_OLD_UNDEF_NULL_THIS = 15;
    public static final int FEATURE_ENUMERATE_IDS_FIRST = 16;
    public static final int FEATURE_THREAD_SAFE_OBJECTS = 17;
    public static final int FEATURE_INTEGER_WITHOUT_DECIMAL_PLACE = 18;
    public static final int FEATURE_LITTLE_ENDIAN = 19;
    public static final int FEATURE_ENABLE_XML_SECURE_PARSING = 20;
    public static final int FEATURE_ENABLE_JAVA_MAP_ACCESS = 21;
    public static final int FEATURE_INTL_402 = 22;
    public static final String languageVersionProperty = "language version";
    public static final String errorReporterProperty = "error reporter";
    public static final Object[] emptyArgs = ScriptRuntime.emptyArgs;
    private static Class<?> codegenClass = Kit.classOrNull("org.mozilla.javascript.optimizer.Codegen");
    private static Class<?> interpreterClass = Kit.classOrNull("org.mozilla.javascript.Interpreter");
    private final ContextFactory factory;
    private boolean sealed;
    private Object sealKey;
    Scriptable topCallScope;
    boolean isContinuationsTopCall;
    NativeCall currentActivationCall;
    XMLLib cachedXMLLib;
    BaseFunction typeErrorThrower;
    ObjToIntMap iterating;
    Object interpreterSecurityDomain;
    int version;
    private SecurityController securityController;
    private boolean hasClassShutter;
    private ClassShutter classShutter;
    private ErrorReporter errorReporter;
    RegExpProxy regExpProxy;
    private Locale locale;
    private TimeZone timezone;
    private boolean generatingDebug;
    private boolean generatingDebugChanged;
    private boolean generatingSource = true;
    boolean useDynamicScope;
    private int optimizationLevel;
    private int maximumInterpreterStackDepth;
    private WrapFactory wrapFactory;
    Debugger debugger;
    private Object debuggerData;
    private int enterCount;
    private Object propertyListeners;
    private Map<Object, Object> threadLocalMap;
    private ClassLoader applicationClassLoader;
    private UnaryOperator<Object> javaToJSONConverter;
    private final ArrayDeque<Runnable> microtasks = new ArrayDeque();
    private final UnhandledRejectionTracker unhandledPromises = new UnhandledRejectionTracker();
    Set<String> activationNames;
    Object lastInterpreterFrame;
    ObjArray previousInterpreterInvocations;
    int instructionCount;
    int instructionThreshold;
    long scratchUint32;
    Scriptable scratchScriptable;
    public boolean generateObserverCount = false;
    boolean isTopLevelStrict;

    @Deprecated
    public Context() {
        this(ContextFactory.getGlobal());
    }

    protected Context(ContextFactory contextFactory) {
        if (contextFactory == null) {
            throw new IllegalArgumentException("factory == null");
        }
        this.factory = contextFactory;
        this.version = 0;
        this.optimizationLevel = codegenClass != null ? 0 : -1;
        this.maximumInterpreterStackDepth = Integer.MAX_VALUE;
    }

    public static Context getCurrentContext() {
        Object object = VMBridge.instance.getThreadContextHelper();
        return VMBridge.instance.getContext(object);
    }

    public static Context enter() {
        return Context.enter(null, ContextFactory.getGlobal());
    }

    @Deprecated
    public static Context enter(Context context) {
        return Context.enter(context, ContextFactory.getGlobal());
    }

    static final Context enter(Context context, ContextFactory contextFactory) {
        Object object = VMBridge.instance.getThreadContextHelper();
        Context context2 = VMBridge.instance.getContext(object);
        if (context2 != null) {
            context = context2;
        } else {
            if (context == null) {
                context = contextFactory.makeContext();
                if (context.enterCount != 0) {
                    throw new IllegalStateException("factory.makeContext() returned Context instance already associated with some thread");
                }
                contextFactory.onContextCreated(context);
                if (contextFactory.isSealed() && !context.isSealed()) {
                    context.seal(null);
                }
            } else if (context.enterCount != 0) {
                throw new IllegalStateException("can not use Context instance already associated with some thread");
            }
            VMBridge.instance.setContext(object, context);
        }
        ++context.enterCount;
        return context;
    }

    public static void exit() {
        Object object = VMBridge.instance.getThreadContextHelper();
        Context context = VMBridge.instance.getContext(object);
        if (context == null) {
            throw new IllegalStateException("Calling Context.exit without previous Context.enter");
        }
        if (context.enterCount < 1) {
            Kit.codeBug();
        }
        if (--context.enterCount == 0) {
            VMBridge.instance.setContext(object, null);
            context.factory.onContextReleased(context);
        }
    }

    @Override
    public void close() {
        Context.exit();
    }

    @Deprecated
    public static <T> T call(ContextAction<T> contextAction) {
        return Context.call(ContextFactory.getGlobal(), contextAction);
    }

    public static Object call(ContextFactory contextFactory, Callable callable, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (contextFactory == null) {
            contextFactory = ContextFactory.getGlobal();
        }
        return Context.call(contextFactory, context -> callable.call(context, scriptable, scriptable2, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T call(ContextFactory contextFactory, ContextAction<T> contextAction) {
        Context context = Context.enter(null, contextFactory);
        try {
            T t = contextAction.run(context);
            return t;
        }
        finally {
            Context.exit();
        }
    }

    @Deprecated
    public static void addContextListener(ContextListener contextListener) {
        String string = "org.mozilla.javascript.tools.debugger.Main";
        if (string.equals(contextListener.getClass().getName())) {
            Class<?> clazz = contextListener.getClass();
            Class<?> clazz2 = Kit.classOrNull("org.mozilla.javascript.ContextFactory");
            Class[] classArray = new Class[]{clazz2};
            Object[] objectArray = new Object[]{ContextFactory.getGlobal()};
            try {
                Method method = clazz.getMethod("attachTo", classArray);
                method.invoke((Object)contextListener, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return;
        }
        ContextFactory.getGlobal().addListener(contextListener);
    }

    @Deprecated
    public static void removeContextListener(ContextListener contextListener) {
        ContextFactory.getGlobal().addListener(contextListener);
    }

    public final ContextFactory getFactory() {
        return this.factory;
    }

    public final boolean isSealed() {
        return this.sealed;
    }

    public final void seal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.sealed = true;
        this.sealKey = object;
    }

    public final void unseal(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (this.sealKey != object) {
            throw new IllegalArgumentException();
        }
        if (!this.sealed) {
            throw new IllegalStateException();
        }
        this.sealed = false;
        this.sealKey = null;
    }

    static void onSealedMutation() {
        throw new IllegalStateException();
    }

    public final int getLanguageVersion() {
        return this.version;
    }

    public void setLanguageVersion(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Context.checkLanguageVersion(n);
        Object object = this.propertyListeners;
        if (object != null && n != this.version) {
            this.firePropertyChangeImpl(object, languageVersionProperty, this.version, n);
        }
        this.version = n;
    }

    public static boolean isValidLanguageVersion(int n) {
        switch (n) {
            case 0: 
            case 100: 
            case 110: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 160: 
            case 170: 
            case 180: 
            case 200: {
                return true;
            }
        }
        return false;
    }

    public static void checkLanguageVersion(int n) {
        if (Context.isValidLanguageVersion(n)) {
            return;
        }
        throw new IllegalArgumentException("Bad language version: " + n);
    }

    public final String getImplementationVersion() {
        return ImplementationVersion.get();
    }

    public final ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            return DefaultErrorReporter.instance;
        }
        return this.errorReporter;
    }

    public final ErrorReporter setErrorReporter(ErrorReporter errorReporter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        ErrorReporter errorReporter2 = this.getErrorReporter();
        if (errorReporter == errorReporter2) {
            return errorReporter2;
        }
        Object object = this.propertyListeners;
        if (object != null) {
            this.firePropertyChangeImpl(object, errorReporterProperty, errorReporter2, errorReporter);
        }
        this.errorReporter = errorReporter;
        return errorReporter2;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public final Locale setLocale(Locale locale) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        Locale locale2 = this.locale;
        this.locale = locale;
        return locale2;
    }

    public final TimeZone getTimeZone() {
        if (this.timezone == null) {
            this.timezone = TimeZone.getDefault();
        }
        return this.timezone;
    }

    public final TimeZone setTimeZone(TimeZone timeZone) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        TimeZone timeZone2 = this.timezone;
        this.timezone = timeZone;
        return timeZone2;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.addListener(this.propertyListeners, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.propertyListeners = Kit.removeListener(this.propertyListeners, propertyChangeListener);
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        Object object3 = this.propertyListeners;
        if (object3 != null) {
            this.firePropertyChangeImpl(object3, string, object, object2);
        }
    }

    private void firePropertyChangeImpl(Object object, String string, Object object2, Object object3) {
        Object object4;
        int n = 0;
        while ((object4 = Kit.getListener(object, n)) != null) {
            if (object4 instanceof PropertyChangeListener) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)object4;
                propertyChangeListener.propertyChange(new PropertyChangeEvent(this, string, object2, object3));
            }
            ++n;
        }
    }

    public static void reportWarning(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getContext();
        if (context.hasFeature(12)) {
            Context.reportError(string, string2, n, string3, n2);
        } else {
            context.getErrorReporter().warning(string, string2, n, string3, n2);
        }
    }

    public static void reportWarning(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportWarning(string, string2, nArray[0], null, 0);
    }

    public static void reportWarning(String string, Throwable throwable) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(string);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        Context.reportWarning(((Object)stringWriter).toString(), string2, nArray[0], null, 0);
    }

    public static void reportError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new EvaluatorException(string, string2, n, string3, n2);
        }
        context.getErrorReporter().error(string, string2, n, string3, n2);
    }

    public static void reportError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        Context.reportError(string, string2, nArray[0], null, 0);
    }

    public static EvaluatorException reportRuntimeError(String string, String string2, int n, String string3, int n2) {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return context.getErrorReporter().runtimeError(string, string2, n, string3, n2);
        }
        throw new EvaluatorException(string, string2, n, string3, n2);
    }

    static EvaluatorException reportRuntimeErrorById(String string, Object ... objectArray) {
        String string2 = ScriptRuntime.getMessageById(string, objectArray);
        return Context.reportRuntimeError(string2);
    }

    @Deprecated
    static EvaluatorException reportRuntimeError0(String string) {
        String string2 = ScriptRuntime.getMessageById(string, new Object[0]);
        return Context.reportRuntimeError(string2);
    }

    @Deprecated
    static EvaluatorException reportRuntimeError1(String string, Object object) {
        String string2 = ScriptRuntime.getMessageById(string, object);
        return Context.reportRuntimeError(string2);
    }

    @Deprecated
    static EvaluatorException reportRuntimeError2(String string, Object object, Object object2) {
        String string2 = ScriptRuntime.getMessageById(string, object, object2);
        return Context.reportRuntimeError(string2);
    }

    @Deprecated
    static EvaluatorException reportRuntimeError3(String string, Object object, Object object2, Object object3) {
        String string2 = ScriptRuntime.getMessageById(string, object, object2, object3);
        return Context.reportRuntimeError(string2);
    }

    @Deprecated
    static EvaluatorException reportRuntimeError4(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = ScriptRuntime.getMessageById(string, object, object2, object3, object4);
        return Context.reportRuntimeError(string2);
    }

    public static EvaluatorException reportRuntimeError(String string) {
        int[] nArray = new int[]{0};
        String string2 = Context.getSourcePositionFromStack(nArray);
        return Context.reportRuntimeError(string, string2, nArray[0], null, 0);
    }

    public final ScriptableObject initStandardObjects() {
        return this.initStandardObjects(null, false);
    }

    public final ScriptableObject initSafeStandardObjects() {
        return this.initSafeStandardObjects(null, false);
    }

    public final Scriptable initStandardObjects(ScriptableObject scriptableObject) {
        return this.initStandardObjects(scriptableObject, false);
    }

    public final Scriptable initSafeStandardObjects(ScriptableObject scriptableObject) {
        return this.initSafeStandardObjects(scriptableObject, false);
    }

    public ScriptableObject initStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        return ScriptRuntime.initStandardObjects(this, scriptableObject, bl);
    }

    public ScriptableObject initSafeStandardObjects(ScriptableObject scriptableObject, boolean bl) {
        return ScriptRuntime.initSafeStandardObjects(this, scriptableObject, bl);
    }

    public static Object getUndefinedValue() {
        return Undefined.instance;
    }

    public final Object evaluateString(Scriptable scriptable, String string, String string2, int n, Object object) {
        Script script = this.compileString(string, string2, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public final Object evaluateReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        Script script = this.compileReader(reader, string, n, object);
        if (script != null) {
            return script.exec(this, scriptable);
        }
        return null;
    }

    public Object executeScriptWithContinuations(Script script, Scriptable scriptable) throws ContinuationPending {
        if (!(script instanceof InterpretedFunction) || !((InterpretedFunction)script).isScript()) {
            throw new IllegalArgumentException("Script argument was not a script or was not created by interpreted mode ");
        }
        return this.callFunctionWithContinuations((InterpretedFunction)script, scriptable, ScriptRuntime.emptyArgs);
    }

    public Object callFunctionWithContinuations(Callable callable, Scriptable scriptable, Object[] objectArray) throws ContinuationPending {
        if (!(callable instanceof InterpretedFunction)) {
            throw new IllegalArgumentException("Function argument was not created by interpreted mode ");
        }
        if (ScriptRuntime.hasTopCall(this)) {
            throw new IllegalStateException("Cannot have any pending top calls when executing a script with continuations");
        }
        this.isContinuationsTopCall = true;
        return ScriptRuntime.doTopCall(callable, this, scriptable, scriptable, objectArray, this.isTopLevelStrict);
    }

    public ContinuationPending captureContinuation() {
        return new ContinuationPending(Interpreter.captureContinuation(this));
    }

    public Object resumeContinuation(Object object, Scriptable scriptable, Object object2) throws ContinuationPending {
        Object[] objectArray = new Object[]{object2};
        return Interpreter.restartContinuation((NativeContinuation)object, this, scriptable, objectArray);
    }

    public final boolean stringIsCompilableUnit(String string) {
        boolean bl = false;
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        compilerEnvirons.setGeneratingSource(false);
        Parser parser = new Parser(compilerEnvirons, DefaultErrorReporter.instance);
        try {
            parser.parse(string, null, 1);
        }
        catch (EvaluatorException evaluatorException) {
            bl = true;
        }
        return !bl || !parser.eof();
    }

    @Deprecated
    public final Script compileReader(Scriptable scriptable, Reader reader, String string, int n, Object object) throws IOException {
        return this.compileReader(reader, string, n, object);
    }

    public final Script compileReader(Reader reader, String string, int n, Object object) throws IOException {
        if (n < 0) {
            n = 0;
        }
        return (Script)this.compileImpl(null, Kit.readReader(reader), string, n, object, false, null, null);
    }

    public final Script compileString(String string, String string2, int n, Object object) {
        if (n < 0) {
            n = 0;
        }
        return this.compileString(string, null, null, string2, n, object);
    }

    final Script compileString(String string, Evaluator evaluator, ErrorReporter errorReporter, String string2, int n, Object object) {
        try {
            return (Script)this.compileImpl(null, string, string2, n, object, false, evaluator, errorReporter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public final Function compileFunction(Scriptable scriptable, String string, String string2, int n, Object object) {
        return this.compileFunction(scriptable, string, null, null, string2, n, object);
    }

    final Function compileFunction(Scriptable scriptable, String string, Evaluator evaluator, ErrorReporter errorReporter, String string2, int n, Object object) {
        try {
            return (Function)this.compileImpl(scriptable, string, string2, n, object, true, evaluator, errorReporter);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public final String decompileScript(Script script, int n) {
        NativeFunction nativeFunction = (NativeFunction)((Object)script);
        return nativeFunction.decompile(n, 0);
    }

    public final String decompileFunction(Function function, int n) {
        if (function instanceof BaseFunction) {
            return ((BaseFunction)function).decompile(n, 0);
        }
        return "function " + function.getClassName() + "() {\n\t[native code]\n}\n";
    }

    public final String decompileFunctionBody(Function function, int n) {
        if (function instanceof BaseFunction) {
            BaseFunction baseFunction = (BaseFunction)function;
            return baseFunction.decompile(n, 1);
        }
        return "[native code]\n";
    }

    public Scriptable newObject(Scriptable scriptable) {
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        return nativeObject;
    }

    public Scriptable newObject(Scriptable scriptable, String string) {
        return this.newObject(scriptable, string, ScriptRuntime.emptyArgs);
    }

    public Scriptable newObject(Scriptable scriptable, String string, Object[] objectArray) {
        return ScriptRuntime.newObject(this, scriptable, string, objectArray);
    }

    public Scriptable newArray(Scriptable scriptable, int n) {
        NativeArray nativeArray = new NativeArray(n);
        ScriptRuntime.setBuiltinProtoAndParent(nativeArray, scriptable, TopLevel.Builtins.Array);
        return nativeArray;
    }

    public Scriptable newArray(Scriptable scriptable, Object[] objectArray) {
        if (objectArray.getClass().getComponentType() != ScriptRuntime.ObjectClass) {
            throw new IllegalArgumentException();
        }
        NativeArray nativeArray = new NativeArray(objectArray);
        ScriptRuntime.setBuiltinProtoAndParent(nativeArray, scriptable, TopLevel.Builtins.Array);
        return nativeArray;
    }

    public final Object[] getElements(Scriptable scriptable) {
        return ScriptRuntime.getArrayElements(scriptable);
    }

    public static boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public static double toNumber(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public static String toString(Object object) {
        return ScriptRuntime.toString(object);
    }

    public static Scriptable toObject(Object object, Scriptable scriptable) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    @Deprecated
    public static Scriptable toObject(Object object, Scriptable scriptable, Class<?> clazz) {
        return ScriptRuntime.toObject(scriptable, object);
    }

    public static Object javaToJS(Object object, Scriptable scriptable) {
        return Context.javaToJS(object, scriptable, null);
    }

    public static Object javaToJS(Object object, Scriptable scriptable, Context context) {
        if (object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Scriptable) {
            return object;
        }
        if (object instanceof Character) {
            return String.valueOf(((Character)object).charValue());
        }
        if (context == null) {
            context = Context.getContext();
        }
        return context.getWrapFactory().wrap(context, scriptable, object, null);
    }

    public static Object jsToJava(Object object, Class<?> clazz) throws EvaluatorException {
        return NativeJavaObject.coerceTypeImpl(clazz, object);
    }

    @Deprecated
    public static Object toType(Object object, Class<?> clazz) throws IllegalArgumentException {
        try {
            return Context.jsToJava(object, clazz);
        }
        catch (EvaluatorException evaluatorException) {
            throw new IllegalArgumentException(evaluatorException.getMessage(), evaluatorException);
        }
    }

    public UnaryOperator<Object> getJavaToJSONConverter() {
        if (this.javaToJSONConverter == null) {
            return JavaToJSONConverters.STRING;
        }
        return this.javaToJSONConverter;
    }

    public void setJavaToJSONConverter(UnaryOperator<Object> unaryOperator) throws IllegalArgumentException {
        if (unaryOperator == null) {
            throw new IllegalArgumentException("javaToJSONConverter == null");
        }
        this.javaToJSONConverter = unaryOperator;
    }

    public static RuntimeException throwAsScriptRuntimeEx(Throwable throwable) {
        Context context;
        while (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof Error && ((context = Context.getContext()) == null || !context.hasFeature(13))) {
            throw (Error)throwable;
        }
        if (throwable instanceof RhinoException) {
            throw (RhinoException)throwable;
        }
        throw new WrappedException(throwable);
    }

    public final boolean isGeneratingDebug() {
        return this.generatingDebug;
    }

    public final void setGeneratingDebug(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingDebugChanged = true;
        if (bl && this.getOptimizationLevel() > 0) {
            this.setOptimizationLevel(0);
        }
        this.generatingDebug = bl;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final void setGeneratingSource(boolean bl) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.generatingSource = bl;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public final void setOptimizationLevel(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n == -2) {
            n = -1;
        }
        Context.checkOptimizationLevel(n);
        if (codegenClass == null) {
            n = -1;
        }
        this.optimizationLevel = n;
    }

    public static boolean isValidOptimizationLevel(int n) {
        return -1 <= n && n <= 9;
    }

    public static void checkOptimizationLevel(int n) {
        if (Context.isValidOptimizationLevel(n)) {
            return;
        }
        throw new IllegalArgumentException("Optimization level outside [-1..9]: " + n);
    }

    public final int getMaximumInterpreterStackDepth() {
        return this.maximumInterpreterStackDepth;
    }

    public final void setMaximumInterpreterStackDepth(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.optimizationLevel != -1) {
            throw new IllegalStateException("Cannot set maximumInterpreterStackDepth when optimizationLevel != -1");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Cannot set maximumInterpreterStackDepth to less than 1");
        }
        this.maximumInterpreterStackDepth = n;
    }

    public final void setSecurityController(SecurityController securityController) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (securityController == null) {
            throw new IllegalArgumentException();
        }
        if (this.securityController != null) {
            throw new SecurityException("Can not overwrite existing SecurityController object");
        }
        if (SecurityController.hasGlobal()) {
            throw new SecurityException("Can not overwrite existing global SecurityController object");
        }
        this.securityController = securityController;
    }

    public final synchronized void setClassShutter(ClassShutter classShutter) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classShutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.hasClassShutter) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = classShutter;
        this.hasClassShutter = true;
    }

    final synchronized ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public final synchronized ClassShutterSetter getClassShutterSetter() {
        if (this.hasClassShutter) {
            return null;
        }
        this.hasClassShutter = true;
        return new ClassShutterSetter(){

            @Override
            public void setClassShutter(ClassShutter classShutter) {
                Context.this.classShutter = classShutter;
            }

            @Override
            public ClassShutter getClassShutter() {
                return Context.this.classShutter;
            }
        };
    }

    public final Object getThreadLocal(Object object) {
        if (this.threadLocalMap == null) {
            return null;
        }
        return this.threadLocalMap.get(object);
    }

    public final synchronized void putThreadLocal(Object object, Object object2) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.threadLocalMap == null) {
            this.threadLocalMap = new HashMap<Object, Object>();
        }
        this.threadLocalMap.put(object, object2);
    }

    public final void removeThreadLocal(Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.threadLocalMap == null) {
            return;
        }
        this.threadLocalMap.remove(object);
    }

    @Deprecated
    public static void setCachingEnabled(boolean bl) {
    }

    public final void setWrapFactory(WrapFactory wrapFactory) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final Debugger getDebugger() {
        return this.debugger;
    }

    public final Object getDebuggerContextData() {
        return this.debuggerData;
    }

    public final void setDebugger(Debugger debugger, Object object) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        this.debugger = debugger;
        this.debuggerData = object;
    }

    public static DebuggableScript getDebuggableView(Script script) {
        if (script instanceof NativeFunction) {
            return ((NativeFunction)((Object)script)).getDebuggableView();
        }
        return null;
    }

    public boolean hasFeature(int n) {
        ContextFactory contextFactory = this.getFactory();
        return contextFactory.hasFeature(this, n);
    }

    public XMLLib.Factory getE4xImplementationFactory() {
        return this.getFactory().getE4xImplementationFactory();
    }

    public final int getInstructionObserverThreshold() {
        return this.instructionThreshold;
    }

    public final void setInstructionObserverThreshold(int n) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.instructionThreshold = n;
        this.setGenerateObserverCount(n > 0);
    }

    public void setGenerateObserverCount(boolean bl) {
        this.generateObserverCount = bl;
    }

    protected void observeInstructionCount(int n) {
        ContextFactory contextFactory = this.getFactory();
        contextFactory.observeInstructionCount(this, n);
    }

    public GeneratedClassLoader createClassLoader(ClassLoader classLoader) {
        ContextFactory contextFactory = this.getFactory();
        return contextFactory.createClassLoader(classLoader);
    }

    public final ClassLoader getApplicationClassLoader() {
        if (this.applicationClassLoader == null) {
            ContextFactory contextFactory = this.getFactory();
            ClassLoader classLoader = contextFactory.getApplicationClassLoader();
            if (classLoader == null) {
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                if (classLoader2 != null && Kit.testIfCanLoadRhinoClasses(classLoader2)) {
                    return classLoader2;
                }
                Class<?> clazz = contextFactory.getClass();
                classLoader = clazz != ScriptRuntime.ContextFactoryClass ? clazz.getClassLoader() : this.getClass().getClassLoader();
            }
            this.applicationClassLoader = classLoader;
        }
        return this.applicationClassLoader;
    }

    public final void setApplicationClassLoader(ClassLoader classLoader) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (classLoader == null) {
            this.applicationClassLoader = null;
            return;
        }
        if (!Kit.testIfCanLoadRhinoClasses(classLoader)) {
            throw new IllegalArgumentException("Loader can not resolve Rhino classes");
        }
        this.applicationClassLoader = classLoader;
    }

    public void enqueueMicrotask(Runnable runnable) {
        this.microtasks.add(runnable);
    }

    public void processMicrotasks() {
        Runnable runnable;
        do {
            if ((runnable = this.microtasks.poll()) == null) continue;
            runnable.run();
        } while (runnable != null);
    }

    public void setTrackUnhandledPromiseRejections(boolean bl) {
        this.unhandledPromises.enable(bl);
    }

    public UnhandledRejectionTracker getUnhandledPromiseTracker() {
        return this.unhandledPromises;
    }

    static Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new RuntimeException("No Context associated with current Thread");
        }
        return context;
    }

    protected Object compileImpl(Scriptable scriptable, String string, String string2, int n, Object object, boolean bl, Evaluator evaluator, ErrorReporter errorReporter) throws IOException {
        Object object2;
        Object object3;
        if (string2 == null) {
            string2 = "unnamed script";
        }
        if (object != null && this.getSecurityController() == null) {
            throw new IllegalArgumentException("securityDomain should be null if setSecurityController() was never called");
        }
        if (!(scriptable == null ^ bl)) {
            Kit.codeBug();
        }
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(this);
        if (errorReporter == null) {
            errorReporter = compilerEnvirons.getErrorReporter();
        }
        ScriptNode scriptNode = this.parse(string, string2, n, compilerEnvirons, errorReporter, bl);
        try {
            if (evaluator == null) {
                evaluator = this.createCompiler();
            }
            object3 = evaluator.compile(compilerEnvirons, scriptNode, scriptNode.getEncodedSource(), bl);
        }
        catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
            scriptNode = this.parse(string, string2, n, compilerEnvirons, errorReporter, bl);
            evaluator = Context.createInterpreter();
            object3 = evaluator.compile(compilerEnvirons, scriptNode, scriptNode.getEncodedSource(), bl);
        }
        if (this.debugger != null) {
            if (string == null) {
                Kit.codeBug();
            }
            if (object3 instanceof DebuggableScript) {
                object2 = (DebuggableScript)object3;
                Context.notifyDebugger_r(this, (DebuggableScript)object2, string);
            } else {
                throw new RuntimeException("NOT SUPPORTED");
            }
        }
        object2 = bl ? evaluator.createFunctionObject(this, scriptable, object3, object) : evaluator.createScriptObject(object3, object);
        return object2;
    }

    private ScriptNode parse(String string, String string2, int n, CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter, boolean bl) throws IOException {
        Parser parser = new Parser(compilerEnvirons, errorReporter);
        if (bl) {
            parser.calledByCompileFunction = true;
        }
        if (this.isStrictMode()) {
            parser.setDefaultUseStrictDirective(true);
        }
        AstRoot astRoot = parser.parse(string, string2, n);
        if (bl && (astRoot.getFirstChild() == null || astRoot.getFirstChild().getType() != 113)) {
            throw new IllegalArgumentException("compileFunction only accepts source with single JS function: " + string);
        }
        IRFactory iRFactory = new IRFactory(compilerEnvirons, errorReporter);
        ScriptNode scriptNode = iRFactory.transformTree(astRoot);
        return scriptNode;
    }

    private static void notifyDebugger_r(Context context, DebuggableScript debuggableScript, String string) {
        context.debugger.handleCompilationDone(context, debuggableScript, string);
        for (int i = 0; i != debuggableScript.getFunctionCount(); ++i) {
            Context.notifyDebugger_r(context, debuggableScript.getFunction(i), string);
        }
    }

    private Evaluator createCompiler() {
        Evaluator evaluator = null;
        if (this.optimizationLevel >= 0 && codegenClass != null) {
            evaluator = (Evaluator)Kit.newInstanceOrNull(codegenClass);
        }
        if (evaluator == null) {
            evaluator = Context.createInterpreter();
        }
        return evaluator;
    }

    static Evaluator createInterpreter() {
        return (Evaluator)Kit.newInstanceOrNull(interpreterClass);
    }

    static String getSourcePositionFromStack(int[] nArray) {
        StackTraceElement[] stackTraceElementArray;
        Context context = Context.getCurrentContext();
        if (context == null) {
            return null;
        }
        if (context.lastInterpreterFrame != null && (stackTraceElementArray = Context.createInterpreter()) != null) {
            return stackTraceElementArray.getSourcePositionFromStack(context, nArray);
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray = new Throwable().getStackTrace()) {
            int n;
            String string = stackTraceElement.getFileName();
            if (string == null || string.endsWith(".java") || (n = stackTraceElement.getLineNumber()) < 0) continue;
            nArray[0] = n;
            return string;
        }
        return null;
    }

    RegExpProxy getRegExpProxy() {
        Class<?> clazz;
        if (this.regExpProxy == null && (clazz = Kit.classOrNull("org.mozilla.javascript.regexp.RegExpImpl")) != null) {
            this.regExpProxy = (RegExpProxy)Kit.newInstanceOrNull(clazz);
        }
        return this.regExpProxy;
    }

    final boolean isVersionECMA1() {
        return this.version == 0 || this.version >= 130;
    }

    SecurityController getSecurityController() {
        SecurityController securityController = SecurityController.global();
        if (securityController != null) {
            return securityController;
        }
        return this.securityController;
    }

    public final boolean isGeneratingDebugChanged() {
        return this.generatingDebugChanged;
    }

    public void addActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames == null) {
            this.activationNames = new HashSet<String>();
        }
        this.activationNames.add(string);
    }

    public final boolean isActivationNeeded(String string) {
        return this.activationNames != null && this.activationNames.contains(string);
    }

    public void removeActivationName(String string) {
        if (this.sealed) {
            Context.onSealedMutation();
        }
        if (this.activationNames != null) {
            this.activationNames.remove(string);
        }
    }

    public final boolean isStrictMode() {
        return this.isTopLevelStrict || this.currentActivationCall != null && this.currentActivationCall.isStrict;
    }

    public static boolean isCurrentContextStrict() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            return false;
        }
        return context.isStrictMode();
    }

    public static interface ClassShutterSetter {
        public void setClassShutter(ClassShutter var1);

        public ClassShutter getClassShutter();
    }
}

