/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.math.BigInteger;
import java.util.List;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Icode;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.Jump;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.ast.TemplateCharacters;
import org.mozilla.javascript.ast.VariableInitializer;

class CodeGenerator
extends Icode {
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private boolean itsInTryFlag;
    private InterpreterData itsData;
    private ScriptNode scriptOrFn;
    private int iCodeTop;
    private int stackDepth;
    private int lineNumber;
    private int doubleTableTop;
    private ObjToIntMap strings = new ObjToIntMap(20);
    private ObjToIntMap bigInts = new ObjToIntMap(20);
    private int localTop;
    private int[] labelTable;
    private int labelTableTop;
    private long[] fixupTable;
    private int fixupTableTop;
    private ObjArray literalIds = new ObjArray();
    private int exceptionTableTop;
    private static final int ECF_TAIL = 1;

    CodeGenerator() {
    }

    public InterpreterData compile(CompilerEnvirons compilerEnvirons, ScriptNode scriptNode, String string, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        new NodeTransformer().transform(scriptNode, compilerEnvirons);
        this.scriptOrFn = bl ? scriptNode.getFunctionNode(0) : scriptNode;
        this.itsData = new InterpreterData(compilerEnvirons.getLanguageVersion(), this.scriptOrFn.getSourceName(), string, this.scriptOrFn.isInStrictMode());
        this.itsData.topLevel = true;
        if (bl) {
            this.generateFunctionICode();
        } else {
            this.generateICodeFromTree(this.scriptOrFn);
        }
        return this.itsData;
    }

    private void generateFunctionICode() {
        this.itsInFunctionFlag = true;
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        if (functionNode.getFunctionName() != null) {
            this.itsData.itsName = functionNode.getName();
        }
        if (functionNode.isGenerator()) {
            this.addIcode(-62);
            this.addUint16(functionNode.getBaseLineno() & 0xFFFF);
        }
        if (functionNode.isInStrictMode()) {
            this.itsData.isStrict = true;
        }
        if (functionNode.isES6Generator()) {
            this.itsData.isES6Generator = true;
        }
        this.itsData.declaredAsVar = functionNode.getParent() instanceof VariableInitializer;
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node node) {
        int n;
        Object object;
        Object object2;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        this.generateTemplateLiterals();
        this.visitStatement(node, 0);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            this.addToken(65);
        }
        if (this.itsData.itsICode.length != this.iCodeTop) {
            object2 = new byte[this.iCodeTop];
            System.arraycopy(this.itsData.itsICode, 0, object2, 0, this.iCodeTop);
            this.itsData.itsICode = object2;
        }
        if (this.strings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.strings.size()];
            object2 = this.strings.newIterator();
            ((ObjToIntMap.Iterator)object2).start();
            while (!((ObjToIntMap.Iterator)object2).done()) {
                object = (String)((ObjToIntMap.Iterator)object2).getKey();
                n = ((ObjToIntMap.Iterator)object2).getValue();
                if (this.itsData.itsStringTable[n] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n] = object;
                ((ObjToIntMap.Iterator)object2).next();
            }
        }
        if (this.doubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.doubleTableTop) {
            object2 = new double[this.doubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object2, 0, this.doubleTableTop);
            this.itsData.itsDoubleTable = (double[])object2;
        }
        if (this.bigInts.size() == 0) {
            this.itsData.itsBigIntTable = null;
        } else {
            this.itsData.itsBigIntTable = new BigInteger[this.bigInts.size()];
            object2 = this.bigInts.newIterator();
            ((ObjToIntMap.Iterator)object2).start();
            while (!((ObjToIntMap.Iterator)object2).done()) {
                object = (BigInteger)((ObjToIntMap.Iterator)object2).getKey();
                n = ((ObjToIntMap.Iterator)object2).getValue();
                if (this.itsData.itsBigIntTable[n] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsBigIntTable[n] = object;
                ((ObjToIntMap.Iterator)object2).next();
            }
        }
        if (this.exceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.exceptionTableTop) {
            object2 = new int[this.exceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object2, 0, this.exceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object2;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argIsConst = this.scriptOrFn.getParamAndVarConst();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
        if (this.literalIds.size() != 0) {
            this.itsData.literalIds = this.literalIds.toArray();
        }
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(i);
            CodeGenerator codeGenerator = new CodeGenerator();
            codeGenerator.compilerEnv = this.compilerEnv;
            codeGenerator.scriptOrFn = functionNode;
            codeGenerator.itsData = new InterpreterData(this.itsData);
            codeGenerator.generateFunctionICode();
            interpreterDataArray[i] = codeGenerator.itsData;
            AstNode astNode = functionNode.getParent();
            if (astNode instanceof AstRoot || astNode instanceof Scope || astNode instanceof Block) continue;
            codeGenerator.itsData.declaredAsFunctionExpression = true;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String string2 = this.scriptOrFn.getRegexpFlags(i);
            objectArray[i] = regExpProxy.compileRegExp(context, string, string2);
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private void generateTemplateLiterals() {
        int n = this.scriptOrFn.getTemplateLiteralCount();
        if (n == 0) {
            return;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            List<TemplateCharacters> list = this.scriptOrFn.getTemplateLiteralStrings(i);
            int n2 = 0;
            String[] stringArray = new String[list.size() * 2];
            for (TemplateCharacters templateCharacters : list) {
                stringArray[n2++] = templateCharacters.getValue();
                stringArray[n2++] = templateCharacters.getRawValue();
            }
            objectArray[i] = stringArray;
        }
        this.itsData.itsTemplateLiterals = objectArray;
    }

    private void updateLineNumber(Node node) {
        int n = node.getLineno();
        if (n != this.lineNumber && n >= 0) {
            if (this.itsData.firstLinePC < 0) {
                this.itsData.firstLinePC = n;
            }
            this.lineNumber = n;
            this.addIcode(-26);
            this.addUint16(n & 0xFFFF);
        }
    }

    private static RuntimeException badTree(Node node) {
        throw new RuntimeException(node.toString());
    }

    private void visitStatement(Node node, int n) {
        int n2 = node.getType();
        switch (n2) {
            case 113: {
                int n3 = node.getExistingIntProp(1);
                int n4 = this.scriptOrFn.getFunctionNode(n3).getFunctionType();
                if (n4 == 3) {
                    this.addIndexOp(-20, n3);
                } else if (n4 != 1) {
                    throw Kit.codeBug();
                }
                if (this.itsInFunctionFlag) break;
                this.addIndexOp(-19, n3);
                this.stackChange(1);
                this.addIcode(-5);
                this.stackChange(-1);
                break;
            }
            case 127: 
            case 132: 
            case 133: 
            case 134: 
            case 136: {
                this.updateLineNumber(node);
            }
            case 140: {
                Node node2;
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 2: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(2);
                this.stackChange(-1);
                break;
            }
            case 3: {
                this.addToken(3);
                break;
            }
            case 145: {
                Node node2;
                int n5 = this.allocLocal();
                node.putIntProp(2, n5);
                this.updateLineNumber(node);
                for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.visitStatement(node2, n);
                }
                this.addIndexOp(-56, n5);
                this.releaseLocal(n5);
                break;
            }
            case 164: {
                this.addIcode(-64);
                break;
            }
            case 118: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                for (Jump jump = (Jump)node2.getNext(); jump != null; jump = (Jump)jump.getNext()) {
                    if (jump.getType() != 119) {
                        throw CodeGenerator.badTree(jump);
                    }
                    Node node3 = jump.getFirstChild();
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.visitExpression(node3, 0);
                    this.addToken(46);
                    this.stackChange(-1);
                    this.addGoto(jump.target, -6);
                    this.stackChange(-1);
                }
                this.addIcode(-4);
                this.stackChange(-1);
                break;
            }
            case 135: {
                this.markTargetLabel(node);
                break;
            }
            case 6: 
            case 7: {
                Node node2;
                Node node4 = ((Jump)node).target;
                this.visitExpression(node2, 0);
                this.addGoto(node4, n2);
                this.stackChange(-1);
                break;
            }
            case 5: {
                Node node5 = ((Jump)node).target;
                this.addGoto(node5, n2);
                break;
            }
            case 139: {
                Node node6 = ((Jump)node).target;
                this.addGoto(node6, -23);
                break;
            }
            case 129: {
                Node node2;
                this.stackChange(1);
                int n6 = CodeGenerator.getLocalBlockRef(node);
                this.addIndexOp(-24, n6);
                this.stackChange(-1);
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.addIndexOp(-25, n6);
                break;
            }
            case 137: 
            case 138: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(n2 == 137 ? -4 : -5);
                this.stackChange(-1);
                break;
            }
            case 84: {
                Node node7;
                Node node2;
                Jump jump = (Jump)node;
                int n7 = CodeGenerator.getLocalBlockRef(jump);
                int n8 = this.allocLocal();
                this.addIndexOp(-13, n8);
                int n9 = this.iCodeTop;
                boolean bl = this.itsInTryFlag;
                this.itsInTryFlag = true;
                while (node2 != null) {
                    this.visitStatement(node2, n);
                    node2 = node2.getNext();
                }
                this.itsInTryFlag = bl;
                Node node8 = jump.target;
                if (node8 != null) {
                    int n10 = this.labelTable[this.getTargetLabel(node8)];
                    this.addExceptionHandler(n9, n10, n10, false, n7, n8);
                }
                if ((node7 = jump.getFinally()) != null) {
                    int n11 = this.labelTable[this.getTargetLabel(node7)];
                    this.addExceptionHandler(n9, n11, n11, true, n7, n8);
                }
                this.addIndexOp(-56, n8);
                this.releaseLocal(n8);
                break;
            }
            case 57: {
                Node node2;
                int n12 = CodeGenerator.getLocalBlockRef(node);
                int n13 = node.getExistingIntProp(14);
                String string = node2.getType() == 39 ? node2.getString() : "";
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringPrefix(string);
                this.addIndexPrefix(n12);
                this.addToken(57);
                this.addUint8(n13 != 0 ? 1 : 0);
                this.stackChange(-1);
                break;
            }
            case 50: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addToken(50);
                this.addUint16(this.lineNumber & 0xFFFF);
                this.stackChange(-1);
                break;
            }
            case 51: {
                this.updateLineNumber(node);
                this.addIndexOp(51, CodeGenerator.getLocalBlockRef(node));
                break;
            }
            case 4: {
                Node node2;
                this.updateLineNumber(node);
                if (node.getIntProp(20, 0) != 0) {
                    if (node2 == null || this.compilerEnv.getLanguageVersion() < 200) {
                        this.addIcode(-63);
                        this.addUint16(this.lineNumber & 0xFFFF);
                        break;
                    }
                    this.visitExpression(node2, 1);
                    this.addIcode(-65);
                    this.addUint16(this.lineNumber & 0xFFFF);
                    this.stackChange(-1);
                    break;
                }
                if (node2 == null) {
                    this.addIcode(-22);
                    break;
                }
                this.visitExpression(node2, 1);
                this.addToken(4);
                this.stackChange(-1);
                break;
            }
            case 65: {
                this.updateLineNumber(node);
                this.addToken(65);
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIndexOp(n2, CodeGenerator.getLocalBlockRef(node));
                this.stackChange(-1);
                break;
            }
            case -62: {
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
        if (this.stackDepth != n) {
            throw Kit.codeBug();
        }
    }

    private void visitExpression(Node node, int n) {
        int n2 = node.getType();
        int n3 = this.stackDepth;
        switch (n2) {
            case 113: {
                int n4 = node.getExistingIntProp(1);
                FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n4);
                if (functionNode.getFunctionType() != 2 && functionNode.getFunctionType() != 4) {
                    throw Kit.codeBug();
                }
                this.addIndexOp(-19, n4);
                this.stackChange(1);
                break;
            }
            case 54: {
                int n5 = CodeGenerator.getLocalBlockRef(node);
                this.addIndexOp(54, n5);
                this.stackChange(1);
                break;
            }
            case 92: {
                Node node2;
                Node node3 = node.getLastChild();
                for (node2 = node.getFirstChild(); node2 != node3; node2 = node2.getNext()) {
                    this.visitExpression(node2, 0);
                    this.addIcode(-4);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, n & 1);
                break;
            }
            case 142: {
                this.stackChange(1);
                break;
            }
            case 30: 
            case 38: 
            case 71: {
                Node node2;
                if (n2 == 30) {
                    this.visitExpression(node2, 0);
                } else {
                    this.generateCallFunAndThis(node2);
                }
                int n6 = 0;
                while ((node2 = node2.getNext()) != null) {
                    this.visitExpression(node2, 0);
                    ++n6;
                }
                int n7 = node.getIntProp(10, 0);
                if (n2 != 71 && n7 != 0) {
                    this.addIndexOp(-21, n6);
                    this.addUint8(n7);
                    this.addUint8(n2 == 30 ? 1 : 0);
                    this.addUint16(this.lineNumber & 0xFFFF);
                } else {
                    if (n2 == 38 && (n & 1) != 0 && !this.compilerEnv.isGenerateDebugInfo() && !this.itsInTryFlag) {
                        n2 = -55;
                    }
                    this.addIndexOp(n2, n6);
                }
                if (n2 == 30) {
                    this.stackChange(-n6);
                } else {
                    this.stackChange(-1 - n6);
                }
                if (n6 <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = n6;
                break;
            }
            case 108: 
            case 109: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addIcode(-1);
                this.stackChange(1);
                int n8 = this.iCodeTop;
                int n9 = n2 == 109 ? 7 : 6;
                this.addGotoOp(n9);
                this.stackChange(-1);
                this.addIcode(-4);
                this.stackChange(-1);
                node2 = node2.getNext();
                this.visitExpression(node2, n & 1);
                this.resolveForwardGoto(n8);
                break;
            }
            case 106: {
                Node node2;
                Node node4 = node2.getNext();
                Node node5 = node4.getNext();
                this.visitExpression(node2, 0);
                int n10 = this.iCodeTop;
                this.addGotoOp(7);
                this.stackChange(-1);
                this.visitExpression(node4, n & 1);
                int n11 = this.iCodeTop;
                this.addGotoOp(5);
                this.resolveForwardGoto(n10);
                this.stackDepth = n3;
                this.visitExpression(node5, n & 1);
                this.resolveForwardGoto(n11);
                break;
            }
            case 33: 
            case 34: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.addStringOp(n2, node2.getString());
                break;
            }
            case 31: {
                Node node2;
                boolean bl = node2.getType() == 49;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                if (bl) {
                    this.addIcode(0);
                } else {
                    this.addToken(31);
                }
                this.stackChange(-1);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 36: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 75: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addToken(n2);
                this.stackChange(-1);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 130: {
                Node node2;
                this.visitExpression(node2, 0);
                if (n2 == 130) {
                    this.addIcode(-4);
                    this.addIcode(-50);
                    break;
                }
                this.addToken(n2);
                break;
            }
            case 68: 
            case 70: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 35: 
            case 143: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                String string = node2.getString();
                node2 = node2.getNext();
                if (n2 == 143) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addStringOp(33, string);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addStringOp(35, string);
                this.stackChange(-1);
                break;
            }
            case 37: 
            case 144: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 144) {
                    this.addIcode(-2);
                    this.stackChange(2);
                    this.addToken(36);
                    this.stackChange(-1);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(37);
                this.stackChange(-2);
                break;
            }
            case 69: 
            case 146: {
                Node node2;
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                if (n2 == 146) {
                    this.addIcode(-1);
                    this.stackChange(1);
                    this.addToken(68);
                    this.stackChange(-1);
                }
                this.visitExpression(node2, 0);
                this.addToken(69);
                this.stackChange(-1);
                break;
            }
            case 8: 
            case 74: {
                Node node2;
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(n2, string);
                this.stackChange(-1);
                break;
            }
            case 159: {
                Node node2;
                String string = node2.getString();
                this.visitExpression(node2, 0);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addStringOp(-59, string);
                this.stackChange(-1);
                break;
            }
            case 141: {
                int n12 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n12 = this.scriptOrFn.getIndexForNameNode(node);
                }
                if (n12 == -1) {
                    this.addStringOp(-14, node.getString());
                    this.stackChange(1);
                    break;
                }
                this.addVarOp(55, n12);
                this.stackChange(1);
                this.addToken(32);
                break;
            }
            case 39: 
            case 41: 
            case 49: {
                this.addStringOp(n2, node.getString());
                this.stackChange(1);
                break;
            }
            case 110: 
            case 111: {
                Node node2;
                this.visitIncDec(node, node2);
                break;
            }
            case 40: {
                double d = node.getDouble();
                int n13 = (int)d;
                if ((double)n13 == d) {
                    if (n13 == 0) {
                        this.addIcode(-51);
                        if (1.0 / d < 0.0) {
                            this.addToken(29);
                        }
                    } else if (n13 == 1) {
                        this.addIcode(-52);
                    } else if ((short)n13 == n13) {
                        this.addIcode(-27);
                        this.addUint16(n13 & 0xFFFF);
                    } else {
                        this.addIcode(-28);
                        this.addInt(n13);
                    }
                } else {
                    int n14 = this.getDoubleIndex(d);
                    this.addIndexOp(40, n14);
                }
                this.stackChange(1);
                break;
            }
            case 55: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n15 = this.scriptOrFn.getIndexForNameNode(node);
                this.addVarOp(55, n15);
                this.stackChange(1);
                break;
            }
            case 56: {
                Node node2;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n16 = this.scriptOrFn.getIndexForNameNode(node2);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addVarOp(56, n16);
                break;
            }
            case 160: {
                Node node2;
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n17 = this.scriptOrFn.getIndexForNameNode(node2);
                node2 = node2.getNext();
                this.visitExpression(node2, 0);
                this.addVarOp(160, n17);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 64: {
                this.addToken(n2);
                this.stackChange(1);
                break;
            }
            case 62: 
            case 63: {
                this.addIndexOp(n2, CodeGenerator.getLocalBlockRef(node));
                this.stackChange(1);
                break;
            }
            case 83: {
                this.addBigInt(node.getBigInt());
                this.stackChange(1);
                break;
            }
            case 48: {
                int n18 = node.getExistingIntProp(4);
                this.addIndexOp(48, n18);
                this.stackChange(1);
                break;
            }
            case 66: 
            case 67: {
                Node node2;
                this.visitLiteral(node, node2);
                break;
            }
            case 161: {
                Node node2;
                this.visitArrayComprehension(node, node2, node2.getNext());
                break;
            }
            case 72: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addStringOp(n2, (String)node.getProp(17));
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                Node node2;
                int n19 = node.getIntProp(16, 0);
                int n20 = 0;
                do {
                    this.visitExpression(node2, 0);
                    ++n20;
                } while ((node2 = node2.getNext()) != null);
                this.addIndexOp(n2, n19);
                this.stackChange(1 - n20);
                break;
            }
            case 150: {
                Node node2;
                this.updateLineNumber(node);
                this.visitExpression(node2, 0);
                this.addIcode(-53);
                this.stackChange(-1);
                int n21 = this.iCodeTop;
                this.visitExpression(node2.getNext(), 0);
                this.addBackwardGoto(-54, n21);
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                Node node2;
                this.visitExpression(node2, 0);
                this.addToken(n2);
                break;
            }
            case 73: 
            case 169: {
                Node node2;
                if (node2 != null) {
                    this.visitExpression(node2, 0);
                } else {
                    this.addIcode(-50);
                    this.stackChange(1);
                }
                if (n2 == 73) {
                    this.addToken(73);
                } else {
                    this.addIcode(-66);
                }
                this.addUint16(node.getLineno() & 0xFFFF);
                break;
            }
            case 163: {
                Node node6 = node.getFirstChild();
                Node node7 = node6.getNext();
                this.visitExpression(node6.getFirstChild(), 0);
                this.addToken(2);
                this.stackChange(-1);
                this.visitExpression(node7.getFirstChild(), 0);
                this.addToken(3);
                break;
            }
            case 170: {
                this.visitTemplateLiteral(node);
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
        if (n3 + 1 != this.stackDepth) {
            Kit.codeBug();
        }
    }

    private void generateCallFunAndThis(Node node) {
        int n = node.getType();
        switch (n) {
            case 39: {
                String string = node.getString();
                this.addStringOp(-15, string);
                this.stackChange(2);
                break;
            }
            case 33: 
            case 36: {
                Node node2 = node.getFirstChild();
                this.visitExpression(node2, 0);
                Node node3 = node2.getNext();
                if (n == 33) {
                    String string = node3.getString();
                    this.addStringOp(-16, string);
                    this.stackChange(1);
                    break;
                }
                this.visitExpression(node3, 0);
                this.addIcode(-17);
                break;
            }
            default: {
                this.visitExpression(node, 0);
                this.addIcode(-18);
                this.stackChange(1);
            }
        }
    }

    private void visitIncDec(Node node, Node node2) {
        int n = node.getExistingIntProp(13);
        int n2 = node2.getType();
        switch (n2) {
            case 55: {
                if (this.itsData.itsNeedsActivation) {
                    Kit.codeBug();
                }
                int n3 = this.scriptOrFn.getIndexForNameNode(node2);
                this.addVarOp(-7, n3);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 39: {
                String string = node2.getString();
                this.addStringOp(-8, string);
                this.addUint8(n);
                this.stackChange(1);
                break;
            }
            case 33: {
                Node node3 = node2.getFirstChild();
                this.visitExpression(node3, 0);
                String string = node3.getNext().getString();
                this.addStringOp(-9, string);
                this.addUint8(n);
                break;
            }
            case 36: {
                Node node4 = node2.getFirstChild();
                this.visitExpression(node4, 0);
                Node node5 = node4.getNext();
                this.visitExpression(node5, 0);
                this.addIcode(-10);
                this.addUint8(n);
                this.stackChange(-1);
                break;
            }
            case 68: {
                Node node6 = node2.getFirstChild();
                this.visitExpression(node6, 0);
                this.addIcode(-11);
                this.addUint8(n);
                break;
            }
            default: {
                throw CodeGenerator.badTree(node);
            }
        }
    }

    private void visitLiteral(Node node, Node node2) {
        Object object;
        int n;
        int n2 = node.getType();
        Object[] objectArray = null;
        if (n2 == 66) {
            n = 0;
            for (object = node2; object != null; object = ((Node)object).getNext()) {
                ++n;
            }
        } else if (n2 == 67) {
            objectArray = (Object[])node.getProp(12);
            n = objectArray == null ? 0 : objectArray.length;
        } else {
            throw CodeGenerator.badTree(node);
        }
        this.addIndexOp(-29, n);
        this.stackChange(2);
        while (node2 != null) {
            int n3 = node2.getType();
            if (n3 == 155) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-57);
            } else if (n3 == 156) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-58);
            } else if (n3 == 167) {
                this.visitExpression(node2.getFirstChild(), 0);
                this.addIcode(-30);
            } else {
                this.visitExpression(node2, 0);
                this.addIcode(-30);
            }
            this.stackChange(-1);
            node2 = node2.getNext();
        }
        if (n2 == 66) {
            object = (int[])node.getProp(11);
            if (object == null) {
                this.addToken(66);
            } else {
                int n4 = this.literalIds.size();
                this.literalIds.add(object);
                this.addIndexOp(-31, n4);
            }
        } else {
            int n5 = this.literalIds.size();
            this.literalIds.add(objectArray);
            this.addIndexOp(67, n5);
        }
        this.stackChange(-1);
    }

    private void visitTemplateLiteral(Node node) {
        int n = node.getExistingIntProp(28);
        this.addIndexOp(-74, n);
        this.stackChange(1);
    }

    private void visitArrayComprehension(Node node, Node node2, Node node3) {
        this.visitStatement(node2, this.stackDepth);
        this.visitExpression(node3, 0);
    }

    private static int getLocalBlockRef(Node node) {
        Node node2 = (Node)node.getProp(3);
        return node2.getExistingIntProp(2);
    }

    private int getTargetLabel(Node node) {
        int n = node.labelId();
        if (n != -1) {
            return n;
        }
        n = this.labelTableTop;
        if (this.labelTable == null || n == this.labelTable.length) {
            if (this.labelTable == null) {
                this.labelTable = new int[32];
            } else {
                int[] nArray = new int[this.labelTable.length * 2];
                System.arraycopy(this.labelTable, 0, nArray, 0, n);
                this.labelTable = nArray;
            }
        }
        this.labelTableTop = n + 1;
        this.labelTable[n] = -1;
        node.labelId(n);
        return n;
    }

    private void markTargetLabel(Node node) {
        int n = this.getTargetLabel(node);
        if (this.labelTable[n] != -1) {
            Kit.codeBug();
        }
        this.labelTable[n] = this.iCodeTop;
    }

    private void addGoto(Node node, int n) {
        int n2;
        int n3 = this.getTargetLabel(node);
        if (n3 >= this.labelTableTop) {
            Kit.codeBug();
        }
        if ((n2 = this.labelTable[n3]) != -1) {
            this.addBackwardGoto(n, n2);
        } else {
            int n4 = this.iCodeTop;
            this.addGotoOp(n);
            int n5 = this.fixupTableTop;
            if (this.fixupTable == null || n5 == this.fixupTable.length) {
                if (this.fixupTable == null) {
                    this.fixupTable = new long[40];
                } else {
                    long[] lArray = new long[this.fixupTable.length * 2];
                    System.arraycopy(this.fixupTable, 0, lArray, 0, n5);
                    this.fixupTable = lArray;
                }
            }
            this.fixupTableTop = n5 + 1;
            this.fixupTable[n5] = (long)n3 << 32 | (long)n4;
        }
    }

    private void fixLabelGotos() {
        for (int i = 0; i < this.fixupTableTop; ++i) {
            long l = this.fixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.labelTable[n];
            if (n3 == -1) {
                throw Kit.codeBug();
            }
            this.resolveGoto(n2, n3);
        }
        this.fixupTableTop = 0;
    }

    private void addBackwardGoto(int n, int n2) {
        int n3 = this.iCodeTop;
        if (n3 <= n2) {
            throw Kit.codeBug();
        }
        this.addGotoOp(n);
        this.resolveGoto(n3, n2);
    }

    private void resolveForwardGoto(int n) {
        if (this.iCodeTop < n + 3) {
            throw Kit.codeBug();
        }
        this.resolveGoto(n, this.iCodeTop);
    }

    private void resolveGoto(int n, int n2) {
        int n3 = n2 - n;
        if (0 <= n3 && n3 <= 2) {
            throw Kit.codeBug();
        }
        int n4 = n + 1;
        if (n3 != (short)n3) {
            if (this.itsData.longJumps == null) {
                this.itsData.longJumps = new UintMap();
            }
            this.itsData.longJumps.put(n4, n2);
            n3 = 0;
        }
        byte[] byArray = this.itsData.itsICode;
        byArray[n4] = (byte)(n3 >> 8);
        byArray[n4 + 1] = (byte)n3;
    }

    private void addToken(int n) {
        if (!Icode.validTokenCode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n);
    }

    private void addIcode(int n) {
        if (!Icode.validIcode(n)) {
            throw Kit.codeBug();
        }
        this.addUint8(n & 0xFF);
    }

    private void addUint8(int n) {
        if ((n & 0xFFFFFF00) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.iCodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapacity(1);
        }
        byArray[n2] = (byte)n;
        this.iCodeTop = n2 + 1;
    }

    private void addUint16(int n) {
        if ((n & 0xFFFF0000) != 0) {
            throw Kit.codeBug();
        }
        int n2 = this.iCodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapacity(2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        this.iCodeTop = n2 + 2;
    }

    private void addInt(int n) {
        int n2 = this.iCodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapacity(4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        this.iCodeTop = n2 + 4;
    }

    private int getDoubleIndex(double d) {
        int n = this.doubleTableTop;
        if (n == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n) {
            double[] dArray = new double[n * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n] = d;
        this.doubleTableTop = n + 1;
        return n;
    }

    private void addGotoOp(int n) {
        int n2 = this.iCodeTop;
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 3 > byArray.length) {
            byArray = this.increaseICodeCapacity(3);
        }
        byArray[n2] = (byte)n;
        this.iCodeTop = n2 + 1 + 2;
    }

    private void addVarOp(int n, int n2) {
        switch (n) {
            case 160: {
                if (n2 < 128) {
                    this.addIcode(-61);
                    this.addUint8(n2);
                    return;
                }
                this.addIndexOp(-60, n2);
                return;
            }
            case 55: 
            case 56: {
                if (n2 < 128) {
                    this.addIcode(n == 55 ? -48 : -49);
                    this.addUint8(n2);
                    return;
                }
            }
            case -7: {
                this.addIndexOp(n, n2);
                return;
            }
        }
        throw Kit.codeBug();
    }

    private void addStringOp(int n, String string) {
        this.addStringPrefix(string);
        if (Icode.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addIndexOp(int n, int n2) {
        this.addIndexPrefix(n2);
        if (Icode.validIcode(n)) {
            this.addIcode(n);
        } else {
            this.addToken(n);
        }
    }

    private void addStringPrefix(String string) {
        int n = this.strings.get(string, -1);
        if (n == -1) {
            n = this.strings.size();
            this.strings.put(string, n);
        }
        if (n < 4) {
            this.addIcode(-41 - n);
        } else if (n <= 255) {
            this.addIcode(-45);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-46);
            this.addUint16(n);
        } else {
            this.addIcode(-47);
            this.addInt(n);
        }
    }

    private void addBigInt(BigInteger bigInteger) {
        int n = this.bigInts.get(bigInteger, -1);
        if (n == -1) {
            n = this.bigInts.size();
            this.bigInts.put(bigInteger, n);
        }
        if (n < 4) {
            this.addIcode(-67 - n);
        } else if (n <= 255) {
            this.addIcode(-71);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-72);
            this.addUint16(n);
        } else {
            this.addIcode(-73);
            this.addInt(n);
        }
        this.addToken(83);
    }

    private void addIndexPrefix(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n < 6) {
            this.addIcode(-32 - n);
        } else if (n <= 255) {
            this.addIcode(-38);
            this.addUint8(n);
        } else if (n <= 65535) {
            this.addIcode(-39);
            this.addUint16(n);
        } else {
            this.addIcode(-40);
            this.addInt(n);
        }
    }

    private void addExceptionHandler(int n, int n2, int n3, boolean bl, int n4, int n5) {
        int n6 = this.exceptionTableTop;
        int[] nArray = this.itsData.itsExceptionTable;
        if (nArray == null) {
            if (n6 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else if (nArray.length == n6) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n6);
            this.itsData.itsExceptionTable = nArray;
        }
        nArray[n6 + 0] = n;
        nArray[n6 + 1] = n2;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = bl ? 1 : 0;
        nArray[n6 + 4] = n4;
        nArray[n6 + 5] = n5;
        this.exceptionTableTop = n6 + 6;
    }

    private byte[] increaseICodeCapacity(int n) {
        int n2 = this.iCodeTop;
        int n3 = this.itsData.itsICode.length;
        if (n2 + n <= n3) {
            throw Kit.codeBug();
        }
        if (n2 + n > (n3 *= 2)) {
            n3 = n2 + n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n2);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private void stackChange(int n) {
        if (n <= 0) {
            this.stackDepth += n;
        } else {
            int n2 = this.stackDepth + n;
            if (n2 > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = n2;
            }
            this.stackDepth = n2;
        }
    }

    private int allocLocal() {
        int n = this.localTop++;
        if (this.localTop > this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = this.localTop;
        }
        return n;
    }

    private void releaseLocal(int n) {
        --this.localTop;
        if (n != this.localTop) {
            Kit.codeBug();
        }
    }
}

