/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.UniqueTag;

final class Arguments
extends IdScriptableObject {
    private static final long serialVersionUID = 4275508002492040609L;
    private static final String FTAG = "Arguments";
    private static final int Id_callee = 1;
    private static final int Id_length = 2;
    private static final int Id_caller = 3;
    private static final int MAX_INSTANCE_ID = 3;
    private static BaseFunction iteratorMethod = new BaseFunction(){
        private static final long serialVersionUID = 4239122318596177391L;

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            return new NativeArrayIterator(scriptable, scriptable2, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
        }
    };
    private Object callerObj;
    private Object calleeObj;
    private Object lengthObj;
    private int callerAttr = 2;
    private int calleeAttr = 2;
    private int lengthAttr = 2;
    private NativeCall activation;
    private Object[] args;

    public Arguments(NativeCall nativeCall) {
        this.activation = nativeCall;
        Scriptable scriptable = nativeCall.getParentScope();
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        this.args = nativeCall.originalArgs;
        this.lengthObj = this.args.length;
        NativeFunction nativeFunction = nativeCall.function;
        this.calleeObj = nativeFunction;
        int n = nativeFunction.getLanguageVersion();
        this.callerObj = n <= 130 && n != 0 ? null : NOT_FOUND;
        this.defineProperty(SymbolKey.ITERATOR, (Object)iteratorMethod, 2);
    }

    @Override
    public String getClassName() {
        return FTAG;
    }

    private Object arg(int n) {
        if (n < 0 || this.args.length <= n) {
            return NOT_FOUND;
        }
        return this.args[n];
    }

    private void putIntoActivation(int n, Object object) {
        String string = this.activation.function.getParamOrVarName(n);
        this.activation.put(string, (Scriptable)this.activation, object);
    }

    private Object getFromActivation(int n) {
        String string = this.activation.function.getParamOrVarName(n);
        return this.activation.get(string, (Scriptable)this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceArg(int n, Object object) {
        if (this.sharedWithActivation(n)) {
            this.putIntoActivation(n, object);
        }
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args == this.activation.originalArgs) {
                this.args = (Object[])this.args.clone();
            }
            this.args[n] = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeArg(int n) {
        Arguments arguments = this;
        synchronized (arguments) {
            if (this.args[n] != NOT_FOUND) {
                if (this.args == this.activation.originalArgs) {
                    this.args = (Object[])this.args.clone();
                }
                this.args[n] = NOT_FOUND;
            }
        }
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (this.arg(n) != NOT_FOUND) {
            return true;
        }
        return super.has(n, scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        Object object = this.arg(n);
        if (object == NOT_FOUND) {
            return super.get(n, scriptable);
        }
        if (this.sharedWithActivation(n)) {
            return this.getFromActivation(n);
        }
        return object;
    }

    private boolean sharedWithActivation(int n) {
        Context context = Context.getContext();
        if (context.isStrictMode()) {
            return false;
        }
        NativeFunction nativeFunction = this.activation.function;
        int n2 = nativeFunction.getParamCount();
        if (n < n2) {
            if (n < n2 - 1) {
                String string = nativeFunction.getParamOrVarName(n);
                for (int i = n + 1; i < n2; ++i) {
                    if (!string.equals(nativeFunction.getParamOrVarName(i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (this.arg(n) == NOT_FOUND) {
            super.put(n, scriptable, object);
        } else {
            this.replaceArg(n, object);
        }
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        super.put(string, scriptable, object);
    }

    @Override
    public void delete(int n) {
        if (0 <= n && n < this.args.length) {
            this.removeArg(n);
        }
        super.delete(n);
    }

    @Override
    protected int getMaxInstanceId() {
        return 3;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2;
        switch (string) {
            case "callee": {
                n2 = 1;
                break;
            }
            case "length": {
                n2 = 2;
                break;
            }
            case "caller": {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        Object object = Context.getContext();
        if (((Context)object).isStrictMode() && (n2 == 1 || n2 == 3)) {
            return super.findInstanceIdInfo(string);
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: {
                n = this.calleeAttr;
                break;
            }
            case 3: {
                n = this.callerAttr;
                break;
            }
            case 2: {
                n = this.lengthAttr;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Arguments.instanceIdInfo(n, n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "callee";
            }
            case 2: {
                return "length";
            }
            case 3: {
                return "caller";
            }
        }
        return null;
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return this.calleeObj;
            }
            case 2: {
                return this.lengthObj;
            }
            case 3: {
                NativeCall nativeCall;
                Object object = this.callerObj;
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                } else if (object == null && (nativeCall = this.activation.parentActivationCall) != null) {
                    object = nativeCall.get("arguments", (Scriptable)nativeCall);
                }
                return object;
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        switch (n) {
            case 1: {
                this.calleeObj = object;
                return;
            }
            case 2: {
                this.lengthObj = object;
                return;
            }
            case 3: {
                this.callerObj = object != null ? object : UniqueTag.NULL_VALUE;
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        switch (n) {
            case 1: {
                this.calleeAttr = n2;
                return;
            }
            case 2: {
                this.lengthAttr = n2;
                return;
            }
            case 3: {
                this.callerAttr = n2;
                return;
            }
        }
        super.setInstanceIdAttributes(n, n2);
    }

    @Override
    Object[] getIds(boolean bl, boolean bl2) {
        Object[] objectArray = super.getIds(bl, bl2);
        if (this.args.length != 0) {
            int n;
            int n2;
            boolean[] blArray = new boolean[this.args.length];
            int n3 = this.args.length;
            for (n2 = 0; n2 != objectArray.length; ++n2) {
                Object object = objectArray[n2];
                if (!(object instanceof Integer) || 0 > (n = ((Integer)object).intValue()) || n >= this.args.length || blArray[n]) continue;
                blArray[n] = true;
                --n3;
            }
            if (!bl) {
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    if (blArray[n2] || !super.has(n2, (Scriptable)this)) continue;
                    blArray[n2] = true;
                    --n3;
                }
            }
            if (n3 != 0) {
                Object[] objectArray2 = new Object[n3 + objectArray.length];
                System.arraycopy(objectArray, 0, objectArray2, n3, objectArray.length);
                objectArray = objectArray2;
                int n4 = 0;
                for (n = 0; n != this.args.length; ++n) {
                    if (blArray[n]) continue;
                    objectArray[n4] = n;
                    ++n4;
                }
                if (n4 != n3) {
                    Kit.codeBug();
                }
            }
        }
        return objectArray;
    }

    @Override
    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        int n;
        if (ScriptRuntime.isSymbol(object) || object instanceof Scriptable) {
            return super.getOwnPropertyDescriptor(context, object);
        }
        double d = ScriptRuntime.toNumber(object);
        if (d != (double)(n = (int)d)) {
            return super.getOwnPropertyDescriptor(context, object);
        }
        Object object2 = this.arg(n);
        if (object2 == NOT_FOUND) {
            return super.getOwnPropertyDescriptor(context, object);
        }
        if (this.sharedWithActivation(n)) {
            object2 = this.getFromActivation(n);
        }
        if (super.has(n, (Scriptable)this)) {
            ScriptableObject scriptableObject = super.getOwnPropertyDescriptor(context, object);
            scriptableObject.put("value", (Scriptable)scriptableObject, object2);
            return scriptableObject;
        }
        Scriptable scriptable = this.getParentScope();
        if (scriptable == null) {
            scriptable = this;
        }
        return Arguments.buildDataDescriptor(scriptable, object2, 0);
    }

    @Override
    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        int n;
        super.defineOwnProperty(context, object, scriptableObject, bl);
        if (ScriptRuntime.isSymbol(object)) {
            return;
        }
        double d = ScriptRuntime.toNumber(object);
        if (d != (double)(n = (int)d)) {
            return;
        }
        Object object2 = this.arg(n);
        if (object2 == NOT_FOUND) {
            return;
        }
        if (Arguments.isAccessorDescriptor(scriptableObject)) {
            this.removeArg(n);
            return;
        }
        Object object3 = Arguments.getProperty((Scriptable)scriptableObject, "value");
        if (object3 == NOT_FOUND) {
            return;
        }
        this.replaceArg(n, object3);
        if (Arguments.isFalse(Arguments.getProperty((Scriptable)scriptableObject, "writable"))) {
            this.removeArg(n);
        }
    }

    void defineAttributesForStrictMode() {
        Context context = Context.getContext();
        if (!context.isStrictMode()) {
            return;
        }
        this.setGetterOrSetter("caller", 0, new ThrowTypeError("caller"), true);
        this.setGetterOrSetter("caller", 0, new ThrowTypeError("caller"), false);
        this.setGetterOrSetter("callee", 0, new ThrowTypeError("callee"), true);
        this.setGetterOrSetter("callee", 0, new ThrowTypeError("callee"), false);
        this.setAttributes("caller", 6);
        this.setAttributes("callee", 6);
        this.callerObj = null;
        this.calleeObj = null;
    }

    private static class ThrowTypeError
    extends BaseFunction {
        private static final long serialVersionUID = -744615873947395749L;
        private String propertyName;

        ThrowTypeError(String string) {
            this.propertyName = string;
            super.setInstanceIdAttributes(3, 7);
        }

        @Override
        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
            throw ScriptRuntime.typeErrorById("msg.arguments.not.access.strict", this.propertyName);
        }
    }
}

